/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.exslt.Math;
import net.sf.saxon.functions.Evaluate;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ProcInstParser;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.SequenceValue;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.xpath.XPathException;

public class Extensions {
    public static void pauseTracing(XPathContext xPathContext) {
        xPathContext.getController().pauseTracing(true);
    }

    public static void resumeTracing(XPathContext xPathContext) {
        xPathContext.getController().pauseTracing(false);
    }

    public static String systemId(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            throw new XPathException.Dynamic("The context item for saxon:systemId() is not set");
        }
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getSystemId();
        }
        return "";
    }

    public static int lineNumber(XPathContext xPathContext) {
        Item item = xPathContext.getCurrentIterator().current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getLineNumber();
        }
        return -1;
    }

    public static boolean hasSameNodes(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) throws XPathException {
        NodeInfo nodeInfo;
        NodeInfo nodeInfo2;
        SequenceIterator sequenceIterator3 = sequenceIterator;
        SequenceIterator sequenceIterator4 = sequenceIterator2;
        do {
            nodeInfo2 = (NodeInfo)sequenceIterator3.next();
            nodeInfo = (NodeInfo)sequenceIterator4.next();
            if (nodeInfo2 != null && nodeInfo != null) continue;
            return nodeInfo2 == nodeInfo;
        } while (nodeInfo2.isSameNode(nodeInfo));
        return false;
    }

    public static double sum(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = 0.0;
        XPathContext xPathContext2 = xPathContext.newContext();
        xPathContext2.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Item item2 = preparedExpression.expression.evaluateItem(xPathContext2);
            if (item2 instanceof NumericValue) {
                DoubleValue doubleValue = (DoubleValue)((NumericValue)item2).convert(517);
                d += doubleValue.getValue();
                continue;
            }
            throw new XPathException.Dynamic("expression in saxon:sum() must return numeric values");
        }
        return d;
    }

    public static double max(SequenceIterator sequenceIterator) throws XPathException {
        return Math.max(sequenceIterator);
    }

    public static double max(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = Double.NEGATIVE_INFINITY;
        XPathContext xPathContext2 = xPathContext.newContext();
        xPathContext2.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Item item2 = preparedExpression.expression.evaluateItem(xPathContext2);
            if (item2 instanceof NumericValue) {
                DoubleValue doubleValue = (DoubleValue)((NumericValue)item2).convert(517);
                if (!(doubleValue.getValue() > d)) continue;
                d = doubleValue.getValue();
                continue;
            }
            throw new XPathException.Dynamic("expression in saxon:max() must return numeric values");
        }
        return d;
    }

    public static double min(SequenceIterator sequenceIterator) throws XPathException {
        return Math.min(sequenceIterator);
    }

    public static double min(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = Double.POSITIVE_INFINITY;
        XPathContext xPathContext2 = xPathContext.newContext();
        xPathContext2.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Item item2 = preparedExpression.expression.evaluateItem(xPathContext2);
            if (item2 instanceof NumericValue) {
                DoubleValue doubleValue = (DoubleValue)((NumericValue)item2).convert(517);
                if (!(doubleValue.getValue() < d)) continue;
                d = doubleValue.getValue();
                continue;
            }
            throw new XPathException.Dynamic("expression in saxon:min() must return numeric values");
        }
        return d;
    }

    public static SequenceValue highest(XPathContext xPathContext, SequenceIterator sequenceIterator) throws XPathException {
        return Math.highest(xPathContext, sequenceIterator);
    }

    public static SequenceIterator highest(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = Double.NEGATIVE_INFINITY;
        XPathContext xPathContext2 = xPathContext.newContext();
        Item item2 = null;
        xPathContext2.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Item item3 = preparedExpression.expression.evaluateItem(xPathContext2);
            if (item3 instanceof NumericValue) {
                DoubleValue doubleValue = (DoubleValue)((NumericValue)item3).convert(517);
                if (!(doubleValue.getValue() > d)) continue;
                d = doubleValue.getValue();
                item2 = sequenceIterator.current();
                continue;
            }
            throw new XPathException.Dynamic("expression in saxon:highest() must return numeric values");
        }
        return SingletonIterator.makeIterator(item2);
    }

    public static SequenceValue lowest(XPathContext xPathContext, SequenceIterator sequenceIterator) throws XPathException {
        return Math.lowest(xPathContext, sequenceIterator);
    }

    public static SequenceIterator lowest(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        Item item;
        double d = Double.POSITIVE_INFINITY;
        XPathContext xPathContext2 = xPathContext.newContext();
        Item item2 = null;
        xPathContext2.setCurrentIterator(sequenceIterator);
        while ((item = sequenceIterator.next()) != null) {
            Item item3 = preparedExpression.expression.evaluateItem(xPathContext2);
            if (item3 instanceof NumericValue) {
                DoubleValue doubleValue = (DoubleValue)((NumericValue)item3).convert(517);
                if (!(doubleValue.getValue() < d)) continue;
                d = doubleValue.getValue();
                item2 = sequenceIterator.current();
                continue;
            }
            throw new XPathException.Dynamic("expression in saxon:lowest() must return numeric values");
        }
        return SingletonIterator.makeIterator(item2);
    }

    public static SequenceIterator distinct(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        DistinctExpressionFunction distinctExpressionFunction = new DistinctExpressionFunction(preparedExpression.expression);
        XPathContext xPathContext2 = xPathContext.newContext();
        xPathContext2.setCurrentIterator(sequenceIterator);
        return new MappingIterator(sequenceIterator, distinctExpressionFunction, xPathContext2, new HashSet());
    }

    public static SequenceIterator leading(XPathContext xPathContext, SequenceIterator sequenceIterator, Evaluate.PreparedExpression preparedExpression) throws XPathException {
        return new FilterIterator.Leading(sequenceIterator, preparedExpression.expression, xPathContext.newContext());
    }

    public static SequenceIterator after(XPathContext xPathContext, SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2) throws XPathException {
        Object object;
        NodeInfo nodeInfo;
        block4: {
            nodeInfo = null;
            GlobalOrderComparer globalOrderComparer = GlobalOrderComparer.getInstance();
            while (true) {
                if ((object = sequenceIterator2.next()) == null) {
                    if (nodeInfo == null) {
                        return sequenceIterator;
                    }
                    break block4;
                }
                if (!(object instanceof NodeInfo)) break;
                NodeInfo nodeInfo2 = (NodeInfo)object;
                if (nodeInfo == null) {
                    nodeInfo = nodeInfo2;
                    continue;
                }
                if (globalOrderComparer.compare(nodeInfo2, nodeInfo) >= 0) continue;
                nodeInfo = nodeInfo2;
            }
            throw new XPathException.Dynamic("Operand of after() contains an item that is not a node");
        }
        object = new IdentityComparison(new ContextItemExpression(), 38, new SingletonNode(nodeInfo));
        return new FilterIterator(sequenceIterator, (Expression)object, xPathContext);
    }

    public static SequenceIterator tokenize(String string) {
        if (string == null) {
            return EmptyIterator.getInstance();
        }
        return new StringTokenIterator(string);
    }

    public static SequenceIterator tokenize(String string, String string2) {
        if (string == null) {
            return EmptyIterator.getInstance();
        }
        return new StringTokenIterator(string, string2);
    }

    public static String path(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            throw new XPathException.Dynamic("The context item for saxon:path() is not set");
        }
        if (item instanceof NodeInfo) {
            return Navigator.getPath((NodeInfo)item);
        }
        return "";
    }

    public static String typeAnnotation(NodeInfo nodeInfo) {
        int n = nodeInfo.getTypeAnnotation();
        if (n == -1) {
            return "untyped";
        }
        SchemaType schemaType = nodeInfo.getNamePool().getSchemaType(n & 0xFFFFF);
        if (schemaType == null) {
            return "unknownType";
        }
        return schemaType.getDescription();
    }

    public static XPathContext getContext(XPathContext xPathContext) {
        return xPathContext;
    }

    public static String getPseudoAttribute(XPathContext xPathContext, String string) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            throw new XPathException.Dynamic("The context item for saxon:getPseudoAttribute() is not set");
        }
        String string2 = ProcInstParser.getPseudoAttribute(item.getStringValue(), string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static SecondsDurationValue dayTimeDurationFromSeconds(double d) {
        return SecondsDurationValue.fromSeconds(d);
    }

    public static MonthDurationValue yearMonthDurationFromMonths(double d) {
        return MonthDurationValue.fromMonths((int)d);
    }

    private static class DistinctExpressionFunction
    implements MappingFunction {
        public Expression exp;

        public DistinctExpressionFunction(Expression expression) {
            this.exp = expression;
        }

        public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
            Item item2 = this.exp.evaluateItem(xPathContext);
            if (item2 == null) {
                return item2;
            }
            String string = item2.getStringValue();
            if (((HashSet)object).contains(string)) {
                return null;
            }
            ((HashSet)object).add(string);
            return item;
        }
    }
}

