/* This module is generated by the maint/MultiStage2.py script.
Do not modify it by hand. Instead modify the script and run it
to regenerate this code.

As well as being part of the PCRE2 library, this module is #included
by the pcre2test program, which redefines the PRIV macro to change
table names from _pcre2_xxx to xxxx, thereby avoiding name clashes
with the library. At present, just one of these tables is actually
needed. */

#ifndef PCRE2_PCRE2TEST

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "pcre2_internal.h"

#endif /* PCRE2_PCRE2TEST */

/* Unicode character database. */
/* This file was autogenerated by the MultiStage2.py script. */
/* Total size: 99316 bytes, block size: 128. */

/* The tables herein are needed only when UCP support is built,
and in PCRE2 that happens automatically with UTF support.
This module should not be referenced otherwise, so
it should not matter whether it is compiled or not. However
a comment was received about space saving - maybe the guy linked
all the modules rather than using a library - so we include a
condition to cut out the tables when not needed. But don't leave
a totally empty module because some compilers barf at that.
Instead, just supply some small dummy tables. */

#ifndef SUPPORT_UNICODE
const ucd_record PRIV(ucd_records)[] = {{0,0,0,0,0,0,0 }};
const uint16_t PRIV(ucd_stage1)[] = {0};
const uint16_t PRIV(ucd_stage2)[] = {0};
const uint32_t PRIV(ucd_caseless_sets)[] = {0};
#else

const char *PRIV(unicode_version) = "12.1.0";

/* If the 32-bit library is run in non-32-bit mode, character values
greater than 0x10ffff may be encountered. For these we set up a
special record. */

#if PCRE2_CODE_UNIT_WIDTH == 32
const ucd_record PRIV(dummy_ucd_record)[] = {{
  ucp_Unknown,    /* script */
  ucp_Cn,         /* type unassigned */
  ucp_gbOther,    /* grapheme break property */
  0,              /* case set */
  0,              /* other case */
  ucp_Unknown,    /* script extension */
  0,              /* dummy filler */
  }};
#endif

/* When recompiling tables with a new Unicode version, please check the
types in this structure definition from pcre2_internal.h (the actual
field names will be different):

typedef struct {
uint8_t property_0;
uint8_t property_1;
uint8_t property_2;
uint8_t property_3;
pcre_int32 property_4;
pcre_int16 property_5;
uint16_t property_6;
} ucd_record;
*/

/* This table contains lists of characters that are caseless sets of
more than one character. Each list is terminated by NOTACHAR. */

const uint32_t PRIV(ucd_caseless_sets)[] = {
  NOTACHAR,
  0x0053,   0x0073,   0x017f,   NOTACHAR,
  0x01c4,   0x01c5,   0x01c6,   NOTACHAR,
  0x01c7,   0x01c8,   0x01c9,   NOTACHAR,
  0x01ca,   0x01cb,   0x01cc,   NOTACHAR,
  0x01f1,   0x01f2,   0x01f3,   NOTACHAR,
  0x0345,   0x0399,   0x03b9,   0x1fbe,   NOTACHAR,
  0x00b5,   0x039c,   0x03bc,   NOTACHAR,
  0x03a3,   0x03c2,   0x03c3,   NOTACHAR,
  0x0392,   0x03b2,   0x03d0,   NOTACHAR,
  0x0398,   0x03b8,   0x03d1,   0x03f4,   NOTACHAR,
  0x03a6,   0x03c6,   0x03d5,   NOTACHAR,
  0x03a0,   0x03c0,   0x03d6,   NOTACHAR,
  0x039a,   0x03ba,   0x03f0,   NOTACHAR,
  0x03a1,   0x03c1,   0x03f1,   NOTACHAR,
  0x0395,   0x03b5,   0x03f5,   NOTACHAR,
  0x0412,   0x0432,   0x1c80,   NOTACHAR,
  0x0414,   0x0434,   0x1c81,   NOTACHAR,
  0x041e,   0x043e,   0x1c82,   NOTACHAR,
  0x0421,   0x0441,   0x1c83,   NOTACHAR,
  0x0422,   0x0442,   0x1c84,   0x1c85,   NOTACHAR,
  0x042a,   0x044a,   0x1c86,   NOTACHAR,
  0x0462,   0x0463,   0x1c87,   NOTACHAR,
  0x1e60,   0x1e61,   0x1e9b,   NOTACHAR,
  0x03a9,   0x03c9,   0x2126,   NOTACHAR,
  0x004b,   0x006b,   0x212a,   NOTACHAR,
  0x00c5,   0x00e5,   0x212b,   NOTACHAR,
  0x1c88,   0xa64a,   0xa64b,   NOTACHAR,
};

/* When #included in pcre2test, we don't need the table of digit
sets, nor the the large main UCD tables. */

#ifndef PCRE2_PCRE2TEST

/* This table lists the code points for the '9' characters in each
set of decimal digits. It is used to ensure that all the digits in
a script run come from the same set. */

const uint32_t PRIV(ucd_digit_sets)[] = {
  63,  /* Number of subsequent values */
  0x00039, 0x00669, 0x006f9, 0x007c9, 0x0096f, 0x009ef, 0x00a6f, 0x00aef,
  0x00b6f, 0x00bef, 0x00c6f, 0x00cef, 0x00d6f, 0x00def, 0x00e59, 0x00ed9,
  0x00f29, 0x01049, 0x01099, 0x017e9, 0x01819, 0x0194f, 0x019d9, 0x01a89,
  0x01a99, 0x01b59, 0x01bb9, 0x01c49, 0x01c59, 0x0a629, 0x0a8d9, 0x0a909,
  0x0a9d9, 0x0a9f9, 0x0aa59, 0x0abf9, 0x0ff19, 0x104a9, 0x10d39, 0x1106f,
  0x110f9, 0x1113f, 0x111d9, 0x112f9, 0x11459, 0x114d9, 0x11659, 0x116c9,
  0x11739, 0x118e9, 0x11c59, 0x11d59, 0x11da9, 0x16a69, 0x16b59, 0x1d7d7,
  0x1d7e1, 0x1d7eb, 0x1d7f5, 0x1d7ff, 0x1e149, 0x1e2f9, 0x1e959,
};

/* This vector is a list of lists of scripts for the Script Extension
property. Each sublist is zero-terminated. */

const uint8_t PRIV(ucd_script_sets)[] = {
  /*   0 */   0,
  /*   1 */   1,  11,   0,
  /*   4 */   1, 144,   0,
  /*   7 */   1,  50,   0,
  /*  10 */   1,  56,   0,
  /*  13 */   2,  17,   0,
  /*  16 */   3,  15,   0,
  /*  19 */   4,  23,   0,
  /*  22 */   6,  84,   0,
  /*  25 */  12,  36,   0,
  /*  28 */  13,  18,   0,
  /*  31 */  13,  34,   0,
  /*  34 */  13, 118,   0,
  /*  37 */  15, 107,   0,
  /*  40 */  15, 150,   0,
  /*  43 */  15, 100,   0,
  /*  46 */  15,  54,   0,
  /*  49 */  17,  34,   0,
  /*  52 */ 107,  54,   0,
  /*  55 */  21, 108,   0,
  /*  58 */  22, 129,   0,
  /*  61 */  27,  30,   0,
  /*  64 */  29, 150,   0,
  /*  67 */  34,  38,   0,
  /*  70 */  38,  65,   0,
  /*  73 */   1,  50,  56,   0,
  /*  77 */   3,  96,  49,   0,
  /*  81 */  96,  39,  53,   0,
  /*  85 */  12, 110,  36,   0,
  /*  89 */  15, 107,  29,   0,
  /*  93 */  15, 107,  34,   0,
  /*  97 */  23,  27,  30,   0,
  /* 101 */  69,  34,  39,   0,
  /* 105 */   1, 144,  50,  56,   0,
  /* 110 */   3,  15, 107,  29,   0,
  /* 115 */   7,  25,  52,  51,   0,
  /* 120 */  15, 142,  85, 111,   0,
  /* 125 */   4,  24,  23,  27,  30,   0,
  /* 131 */   4,  24,  23,  27,  30,  61,   0,
  /* 138 */  15,  29,  37,  44,  54,  55,   0,
  /* 145 */ 132,   1,  95, 112, 121, 144, 148,  50,   0,
  /* 154 */   3,  15, 107,  29, 150,  44,  55, 124,   0,
  /* 163 */  15, 142,  21,  22, 108,  85, 111, 114, 109, 102, 124,   0,
  /* 175 */   3,  15, 107,  21,  22,  29,  34,  37,  44,  54,  55, 124,   0,
  /* 188 */   3,  15, 107,  21,  22,  29,  34,  37,  44, 100,  54,  55, 124,   0,
  /* 202 */  15, 142,  21,  22, 108,  29,  85, 111, 114, 150, 109, 102, 124,   0,
  /* 216 */  15, 142,  21,  22, 108,  29,  85, 111,  37, 114, 150, 109, 102, 124,   0,
  /* 231 */   3,  15, 142, 143, 138, 107,  21,  22,  29, 111,  37, 150,  44, 109,  48,  49, 102,  54,  55, 124,   0,
  /* 252 */   3,  15, 142, 143, 138, 107,  21,  22,  29,  35, 111,  37, 150,  44, 109,  48,  49, 102,  54,  55, 124,   0,
  /* 274 */
};

/* These are the main two-stage UCD tables. The fields in each record are:
script (8 bits), character type (8 bits), grapheme break property (8 bits),
offset to multichar other cases or zero (8 bits), offset to other case
or zero (32 bits, signed), script extension (16 bits, signed), and a dummy
16-bit field to make the whole thing a multiple of 4 bytes. */

const ucd_record PRIV(ucd_records)[] = { /* 11508 bytes, record size 12 */
  {    10,      0,      2,      0,      0,     10,    256, }, /*   0 */
  {    10,      0,      2,      0,      0,     10,      0, }, /*   1 */
  {    10,      0,      1,      0,      0,     10,      0, }, /*   2 */
  {    10,      0,      0,      0,      0,     10,      0, }, /*   3 */
  {    10,     29,     12,      0,      0,     10,      0, }, /*   4 */
  {    10,     21,     12,      0,      0,     10,      0, }, /*   5 */
  {    10,     23,     12,      0,      0,     10,      0, }, /*   6 */
  {    10,     22,     12,      0,      0,     10,      0, }, /*   7 */
  {    10,     18,     12,      0,      0,     10,      0, }, /*   8 */
  {    10,     25,     12,      0,      0,     10,      0, }, /*   9 */
  {    10,     17,     12,      0,      0,     10,      0, }, /*  10 */
  {    10,     13,     12,      0,      0,     10,      0, }, /*  11 */
  {    34,      9,     12,      0,     32,     34,      0, }, /*  12 */
  {    34,      9,     12,    100,     32,     34,      0, }, /*  13 */
  {    34,      9,     12,      1,     32,     34,      0, }, /*  14 */
  {    10,     24,     12,      0,      0,     10,      0, }, /*  15 */
  {    10,     16,     12,      0,      0,     10,      0, }, /*  16 */
  {    34,      5,     12,      0,    -32,     34,      0, }, /*  17 */
  {    34,      5,     12,    100,    -32,     34,      0, }, /*  18 */
  {    34,      5,     12,      1,    -32,     34,      0, }, /*  19 */
  {    10,     26,     12,      0,      0,     10,      0, }, /*  20 */
  {    10,     26,     14,      0,      0,     10,      0, }, /*  21 */
  {    34,      7,     12,      0,      0,     34,      0, }, /*  22 */
  {    10,     20,     12,      0,      0,     10,      0, }, /*  23 */
  {    10,      1,      2,      0,      0,     10,      0, }, /*  24 */
  {    10,     15,     12,      0,      0,     10,      0, }, /*  25 */
  {    10,      5,     12,     26,    775,     10,      0, }, /*  26 */
  {    10,     19,     12,      0,      0,     10,      0, }, /*  27 */
  {    34,      9,     12,    104,     32,     34,      0, }, /*  28 */
  {    34,      5,     12,      0,   7615,     34,      0, }, /*  29 */
  {    34,      5,     12,    104,    -32,     34,      0, }, /*  30 */
  {    34,      5,     12,      0,    121,     34,      0, }, /*  31 */
  {    34,      9,     12,      0,      1,     34,      0, }, /*  32 */
  {    34,      5,     12,      0,     -1,     34,      0, }, /*  33 */
  {    34,      9,     12,      0,      0,     34,      0, }, /*  34 */
  {    34,      5,     12,      0,      0,     34,      0, }, /*  35 */
  {    34,      9,     12,      0,   -121,     34,      0, }, /*  36 */
  {    34,      5,     12,      1,   -268,     34,      0, }, /*  37 */
  {    34,      5,     12,      0,    195,     34,      0, }, /*  38 */
  {    34,      9,     12,      0,    210,     34,      0, }, /*  39 */
  {    34,      9,     12,      0,    206,     34,      0, }, /*  40 */
  {    34,      9,     12,      0,    205,     34,      0, }, /*  41 */
  {    34,      9,     12,      0,     79,     34,      0, }, /*  42 */
  {    34,      9,     12,      0,    202,     34,      0, }, /*  43 */
  {    34,      9,     12,      0,    203,     34,      0, }, /*  44 */
  {    34,      9,     12,      0,    207,     34,      0, }, /*  45 */
  {    34,      5,     12,      0,     97,     34,      0, }, /*  46 */
  {    34,      9,     12,      0,    211,     34,      0, }, /*  47 */
  {    34,      9,     12,      0,    209,     34,      0, }, /*  48 */
  {    34,      5,     12,      0,    163,     34,      0, }, /*  49 */
  {    34,      9,     12,      0,    213,     34,      0, }, /*  50 */
  {    34,      5,     12,      0,    130,     34,      0, }, /*  51 */
  {    34,      9,     12,      0,    214,     34,      0, }, /*  52 */
  {    34,      9,     12,      0,    218,     34,      0, }, /*  53 */
  {    34,      9,     12,      0,    217,     34,      0, }, /*  54 */
  {    34,      9,     12,      0,    219,     34,      0, }, /*  55 */
  {    34,      5,     12,      0,     56,     34,      0, }, /*  56 */
  {    34,      9,     12,      5,      2,     34,      0, }, /*  57 */
  {    34,      8,     12,      5,      1,     34,      0, }, /*  58 */
  {    34,      5,     12,      5,     -2,     34,      0, }, /*  59 */
  {    34,      9,     12,      9,      2,     34,      0, }, /*  60 */
  {    34,      8,     12,      9,      1,     34,      0, }, /*  61 */
  {    34,      5,     12,      9,     -2,     34,      0, }, /*  62 */
  {    34,      9,     12,     13,      2,     34,      0, }, /*  63 */
  {    34,      8,     12,     13,      1,     34,      0, }, /*  64 */
  {    34,      5,     12,     13,     -2,     34,      0, }, /*  65 */
  {    34,      5,     12,      0,    -79,     34,      0, }, /*  66 */
  {    34,      9,     12,     17,      2,     34,      0, }, /*  67 */
  {    34,      8,     12,     17,      1,     34,      0, }, /*  68 */
  {    34,      5,     12,     17,     -2,     34,      0, }, /*  69 */
  {    34,      9,     12,      0,    -97,     34,      0, }, /*  70 */
  {    34,      9,     12,      0,    -56,     34,      0, }, /*  71 */
  {    34,      9,     12,      0,   -130,     34,      0, }, /*  72 */
  {    34,      9,     12,      0,  10795,     34,      0, }, /*  73 */
  {    34,      9,     12,      0,   -163,     34,      0, }, /*  74 */
  {    34,      9,     12,      0,  10792,     34,      0, }, /*  75 */
  {    34,      5,     12,      0,  10815,     34,      0, }, /*  76 */
  {    34,      9,     12,      0,   -195,     34,      0, }, /*  77 */
  {    34,      9,     12,      0,     69,     34,      0, }, /*  78 */
  {    34,      9,     12,      0,     71,     34,      0, }, /*  79 */
  {    34,      5,     12,      0,  10783,     34,      0, }, /*  80 */
  {    34,      5,     12,      0,  10780,     34,      0, }, /*  81 */
  {    34,      5,     12,      0,  10782,     34,      0, }, /*  82 */
  {    34,      5,     12,      0,   -210,     34,      0, }, /*  83 */
  {    34,      5,     12,      0,   -206,     34,      0, }, /*  84 */
  {    34,      5,     12,      0,   -205,     34,      0, }, /*  85 */
  {    34,      5,     12,      0,   -202,     34,      0, }, /*  86 */
  {    34,      5,     12,      0,   -203,     34,      0, }, /*  87 */
  {    34,      5,     12,      0,  42319,     34,      0, }, /*  88 */
  {    34,      5,     12,      0,  42315,     34,      0, }, /*  89 */
  {    34,      5,     12,      0,   -207,     34,      0, }, /*  90 */
  {    34,      5,     12,      0,  42280,     34,      0, }, /*  91 */
  {    34,      5,     12,      0,  42308,     34,      0, }, /*  92 */
  {    34,      5,     12,      0,   -209,     34,      0, }, /*  93 */
  {    34,      5,     12,      0,   -211,     34,      0, }, /*  94 */
  {    34,      5,     12,      0,  10743,     34,      0, }, /*  95 */
  {    34,      5,     12,      0,  42305,     34,      0, }, /*  96 */
  {    34,      5,     12,      0,  10749,     34,      0, }, /*  97 */
  {    34,      5,     12,      0,   -213,     34,      0, }, /*  98 */
  {    34,      5,     12,      0,   -214,     34,      0, }, /*  99 */
  {    34,      5,     12,      0,  10727,     34,      0, }, /* 100 */
  {    34,      5,     12,      0,   -218,     34,      0, }, /* 101 */
  {    34,      5,     12,      0,  42307,     34,      0, }, /* 102 */
  {    34,      5,     12,      0,  42282,     34,      0, }, /* 103 */
  {    34,      5,     12,      0,    -69,     34,      0, }, /* 104 */
  {    34,      5,     12,      0,   -217,     34,      0, }, /* 105 */
  {    34,      5,     12,      0,    -71,     34,      0, }, /* 106 */
  {    34,      5,     12,      0,   -219,     34,      0, }, /* 107 */
  {    34,      5,     12,      0,  42261,     34,      0, }, /* 108 */
  {    34,      5,     12,      0,  42258,     34,      0, }, /* 109 */
  {    34,      6,     12,      0,      0,     34,      0, }, /* 110 */
  {    10,      6,     12,      0,      0,     10,      0, }, /* 111 */
  {     4,     24,     12,      0,      0,      4,      0, }, /* 112 */
  {    28,     12,      3,      0,      0,     28,      0, }, /* 113 */
  {    28,     12,      3,      0,      0,     20,      0, }, /* 114 */
  {    28,     12,      3,     21,    116,     20,      0, }, /* 115 */
  {    28,     12,      3,      0,      0,     34,      0, }, /* 116 */
  {    20,      9,     12,      0,      1,     20,      0, }, /* 117 */
  {    20,      5,     12,      0,     -1,     20,      0, }, /* 118 */
  {    20,     24,     12,      0,      0,     20,      0, }, /* 119 */
  {     0,      2,     12,      0,      0,      0,      0, }, /* 120 */
  {    20,      6,     12,      0,      0,     20,      0, }, /* 121 */
  {    20,      5,     12,      0,    130,     20,      0, }, /* 122 */
  {    20,      9,     12,      0,    116,     20,      0, }, /* 123 */
  {    20,      9,     12,      0,     38,     20,      0, }, /* 124 */
  {    20,      9,     12,      0,     37,     20,      0, }, /* 125 */
  {    20,      9,     12,      0,     64,     20,      0, }, /* 126 */
  {    20,      9,     12,      0,     63,     20,      0, }, /* 127 */
  {    20,      5,     12,      0,      0,     20,      0, }, /* 128 */
  {    20,      9,     12,      0,     32,     20,      0, }, /* 129 */
  {    20,      9,     12,     34,     32,     20,      0, }, /* 130 */
  {    20,      9,     12,     59,     32,     20,      0, }, /* 131 */
  {    20,      9,     12,     38,     32,     20,      0, }, /* 132 */
  {    20,      9,     12,     21,     32,     20,      0, }, /* 133 */
  {    20,      9,     12,     51,     32,     20,      0, }, /* 134 */
  {    20,      9,     12,     26,     32,     20,      0, }, /* 135 */
  {    20,      9,     12,     47,     32,     20,      0, }, /* 136 */
  {    20,      9,     12,     55,     32,     20,      0, }, /* 137 */
  {    20,      9,     12,     30,     32,     20,      0, }, /* 138 */
  {    20,      9,     12,     43,     32,     20,      0, }, /* 139 */
  {    20,      9,     12,     96,     32,     20,      0, }, /* 140 */
  {    20,      5,     12,      0,    -38,     20,      0, }, /* 141 */
  {    20,      5,     12,      0,    -37,     20,      0, }, /* 142 */
  {    20,      5,     12,      0,    -32,     20,      0, }, /* 143 */
  {    20,      5,     12,     34,    -32,     20,      0, }, /* 144 */
  {    20,      5,     12,     59,    -32,     20,      0, }, /* 145 */
  {    20,      5,     12,     38,    -32,     20,      0, }, /* 146 */
  {    20,      5,     12,     21,   -116,     20,      0, }, /* 147 */
  {    20,      5,     12,     51,    -32,     20,      0, }, /* 148 */
  {    20,      5,     12,     26,   -775,     20,      0, }, /* 149 */
  {    20,      5,     12,     47,    -32,     20,      0, }, /* 150 */
  {    20,      5,     12,     55,    -32,     20,      0, }, /* 151 */
  {    20,      5,     12,     30,      1,     20,      0, }, /* 152 */
  {    20,      5,     12,     30,    -32,     20,      0, }, /* 153 */
  {    20,      5,     12,     43,    -32,     20,      0, }, /* 154 */
  {    20,      5,     12,     96,    -32,     20,      0, }, /* 155 */
  {    20,      5,     12,      0,    -64,     20,      0, }, /* 156 */
  {    20,      5,     12,      0,    -63,     20,      0, }, /* 157 */
  {    20,      9,     12,      0,      8,     20,      0, }, /* 158 */
  {    20,      5,     12,     34,    -30,     20,      0, }, /* 159 */
  {    20,      5,     12,     38,    -25,     20,      0, }, /* 160 */
  {    20,      9,     12,      0,      0,     20,      0, }, /* 161 */
  {    20,      5,     12,     43,    -15,     20,      0, }, /* 162 */
  {    20,      5,     12,     47,    -22,     20,      0, }, /* 163 */
  {    20,      5,     12,      0,     -8,     20,      0, }, /* 164 */
  {    11,      9,     12,      0,      1,     11,      0, }, /* 165 */
  {    11,      5,     12,      0,     -1,     11,      0, }, /* 166 */
  {    20,      5,     12,     51,    -54,     20,      0, }, /* 167 */
  {    20,      5,     12,     55,    -48,     20,      0, }, /* 168 */
  {    20,      5,     12,      0,      7,     20,      0, }, /* 169 */
  {    20,      5,     12,      0,   -116,     20,      0, }, /* 170 */
  {    20,      9,     12,     38,    -60,     20,      0, }, /* 171 */
  {    20,      5,     12,     59,    -64,     20,      0, }, /* 172 */
  {    20,     25,     12,      0,      0,     20,      0, }, /* 173 */
  {    20,      9,     12,      0,     -7,     20,      0, }, /* 174 */
  {    20,      9,     12,      0,   -130,     20,      0, }, /* 175 */
  {    13,      9,     12,      0,     80,     13,      0, }, /* 176 */
  {    13,      9,     12,      0,     32,     13,      0, }, /* 177 */
  {    13,      9,     12,     63,     32,     13,      0, }, /* 178 */
  {    13,      9,     12,     67,     32,     13,      0, }, /* 179 */
  {    13,      9,     12,     71,     32,     13,      0, }, /* 180 */
  {    13,      9,     12,     75,     32,     13,      0, }, /* 181 */
  {    13,      9,     12,     79,     32,     13,      0, }, /* 182 */
  {    13,      9,     12,     84,     32,     13,      0, }, /* 183 */
  {    13,      5,     12,      0,    -32,     13,      0, }, /* 184 */
  {    13,      5,     12,     63,    -32,     13,      0, }, /* 185 */
  {    13,      5,     12,     67,    -32,     13,      0, }, /* 186 */
  {    13,      5,     12,     71,    -32,     13,      0, }, /* 187 */
  {    13,      5,     12,     75,    -32,     13,      0, }, /* 188 */
  {    13,      5,     12,     79,    -32,     13,      0, }, /* 189 */
  {    13,      5,     12,     84,    -32,     13,      0, }, /* 190 */
  {    13,      5,     12,      0,    -80,     13,      0, }, /* 191 */
  {    13,      9,     12,      0,      1,     13,      0, }, /* 192 */
  {    13,      5,     12,      0,     -1,     13,      0, }, /* 193 */
  {    13,      9,     12,     88,      1,     13,      0, }, /* 194 */
  {    13,      5,     12,     88,     -1,     13,      0, }, /* 195 */
  {    13,     26,     12,      0,      0,     13,      0, }, /* 196 */
  {    13,     12,      3,      0,      0,    -34,      0, }, /* 197 */
  {    13,     12,      3,      0,      0,    -28,      0, }, /* 198 */
  {    28,     12,      3,      0,      0,    -31,      0, }, /* 199 */
  {    13,     11,      3,      0,      0,     13,      0, }, /* 200 */
  {    13,      9,     12,      0,     15,     13,      0, }, /* 201 */
  {    13,      5,     12,      0,    -15,     13,      0, }, /* 202 */
  {     2,      9,     12,      0,     48,      2,      0, }, /* 203 */
  {     2,      6,     12,      0,      0,      2,      0, }, /* 204 */
  {     2,     21,     12,      0,      0,      2,      0, }, /* 205 */
  {     2,      5,     12,      0,      0,      2,      0, }, /* 206 */
  {     2,      5,     12,      0,    -48,      2,      0, }, /* 207 */
  {    10,     21,     12,      0,      0,    -13,      0, }, /* 208 */
  {     2,     17,     12,      0,      0,      2,      0, }, /* 209 */
  {     2,     26,     12,      0,      0,      2,      0, }, /* 210 */
  {     2,     23,     12,      0,      0,      2,      0, }, /* 211 */
  {    26,     12,      3,      0,      0,     26,      0, }, /* 212 */
  {    26,     17,     12,      0,      0,     26,      0, }, /* 213 */
  {    26,     21,     12,      0,      0,     26,      0, }, /* 214 */
  {    26,      7,     12,      0,      0,     26,      0, }, /* 215 */
  {     1,      1,      4,      0,      0,      1,      0, }, /* 216 */
  {    10,      1,      4,      0,      0,     10,      0, }, /* 217 */
  {     1,     25,     12,      0,      0,      1,      0, }, /* 218 */
  {     1,     21,     12,      0,      0,      1,      0, }, /* 219 */
  {     1,     23,     12,      0,      0,      1,      0, }, /* 220 */
  {    10,     21,     12,      0,      0,   -105,      0, }, /* 221 */
  {     1,     26,     12,      0,      0,      1,      0, }, /* 222 */
  {     1,     12,      3,      0,      0,      1,      0, }, /* 223 */
  {     1,      1,      2,      0,      0,    -73,      0, }, /* 224 */
  {     1,      7,     12,      0,      0,      1,      0, }, /* 225 */
  {    10,      6,     12,      0,      0,   -145,      0, }, /* 226 */
  {    28,     12,      3,      0,      0,     -7,      0, }, /* 227 */
  {     1,     13,     12,      0,      0,    -10,      0, }, /* 228 */
  {     1,     21,     12,      0,      0,     -4,      0, }, /* 229 */
  {     1,      6,     12,      0,      0,      1,      0, }, /* 230 */
  {     1,     13,     12,      0,      0,      1,      0, }, /* 231 */
  {    50,     21,     12,      0,      0,     50,      0, }, /* 232 */
  {    50,      1,      4,      0,      0,     50,      0, }, /* 233 */
  {    50,      7,     12,      0,      0,     50,      0, }, /* 234 */
  {    50,     12,      3,      0,      0,     50,      0, }, /* 235 */
  {    56,      7,     12,      0,      0,     56,      0, }, /* 236 */
  {    56,     12,      3,      0,      0,     56,      0, }, /* 237 */
  {    64,     13,     12,      0,      0,     64,      0, }, /* 238 */
  {    64,      7,     12,      0,      0,     64,      0, }, /* 239 */
  {    64,     12,      3,      0,      0,     64,      0, }, /* 240 */
  {    64,      6,     12,      0,      0,     64,      0, }, /* 241 */
  {    64,     26,     12,      0,      0,     64,      0, }, /* 242 */
  {    64,     21,     12,      0,      0,     64,      0, }, /* 243 */
  {    64,     23,     12,      0,      0,     64,      0, }, /* 244 */
  {    90,      7,     12,      0,      0,     90,      0, }, /* 245 */
  {    90,     12,      3,      0,      0,     90,      0, }, /* 246 */
  {    90,      6,     12,      0,      0,     90,      0, }, /* 247 */
  {    90,     21,     12,      0,      0,     90,      0, }, /* 248 */
  {    95,      7,     12,      0,      0,     95,      0, }, /* 249 */
  {    95,     12,      3,      0,      0,     95,      0, }, /* 250 */
  {    95,     21,     12,      0,      0,     95,      0, }, /* 251 */
  {    15,     12,      3,      0,      0,     15,      0, }, /* 252 */
  {    15,     10,      5,      0,      0,     15,      0, }, /* 253 */
  {    15,      7,     12,      0,      0,     15,      0, }, /* 254 */
  {    28,     12,      3,      0,      0,   -188,      0, }, /* 255 */
  {    28,     12,      3,      0,      0,   -175,      0, }, /* 256 */
  {    10,     21,     12,      0,      0,   -231,      0, }, /* 257 */
  {    10,     21,     12,      0,      0,   -252,      0, }, /* 258 */
  {    15,     13,     12,      0,      0,   -120,      0, }, /* 259 */
  {    15,     21,     12,      0,      0,     15,      0, }, /* 260 */
  {    15,      6,     12,      0,      0,     15,      0, }, /* 261 */
  {     3,      7,     12,      0,      0,      3,      0, }, /* 262 */
  {     3,     12,      3,      0,      0,      3,      0, }, /* 263 */
  {     3,     10,      5,      0,      0,      3,      0, }, /* 264 */
  {     3,     10,      3,      0,      0,      3,      0, }, /* 265 */
  {     3,     13,     12,      0,      0,    -77,      0, }, /* 266 */
  {     3,     23,     12,      0,      0,      3,      0, }, /* 267 */
  {     3,     15,     12,      0,      0,      3,      0, }, /* 268 */
  {     3,     26,     12,      0,      0,      3,      0, }, /* 269 */
  {     3,     21,     12,      0,      0,      3,      0, }, /* 270 */
  {    22,     12,      3,      0,      0,     22,      0, }, /* 271 */
  {    22,     10,      5,      0,      0,     22,      0, }, /* 272 */
  {    22,      7,     12,      0,      0,     22,      0, }, /* 273 */
  {    22,     13,     12,      0,      0,    -58,      0, }, /* 274 */
  {    22,     21,     12,      0,      0,     22,      0, }, /* 275 */
  {    21,     12,      3,      0,      0,     21,      0, }, /* 276 */
  {    21,     10,      5,      0,      0,     21,      0, }, /* 277 */
  {    21,      7,     12,      0,      0,     21,      0, }, /* 278 */
  {    21,     13,     12,      0,      0,    -55,      0, }, /* 279 */
  {    21,     21,     12,      0,      0,     21,      0, }, /* 280 */
  {    21,     23,     12,      0,      0,     21,      0, }, /* 281 */
  {    44,     12,      3,      0,      0,     44,      0, }, /* 282 */
  {    44,     10,      5,      0,      0,     44,      0, }, /* 283 */
  {    44,      7,     12,      0,      0,     44,      0, }, /* 284 */
  {    44,     10,      3,      0,      0,     44,      0, }, /* 285 */
  {    44,     13,     12,      0,      0,     44,      0, }, /* 286 */
  {    44,     26,     12,      0,      0,     44,      0, }, /* 287 */
  {    44,     15,     12,      0,      0,     44,      0, }, /* 288 */
  {    54,     12,      3,      0,      0,     54,      0, }, /* 289 */
  {    54,      7,     12,      0,      0,     54,      0, }, /* 290 */
  {    54,     10,      3,      0,      0,     54,      0, }, /* 291 */
  {    54,     10,      5,      0,      0,     54,      0, }, /* 292 */
  {    54,     13,     12,      0,      0,    -52,      0, }, /* 293 */
  {    54,     15,     12,      0,      0,    -52,      0, }, /* 294 */
  {    54,     26,     12,      0,      0,    -52,      0, }, /* 295 */
  {    54,     26,     12,      0,      0,     54,      0, }, /* 296 */
  {    54,     23,     12,      0,      0,     54,      0, }, /* 297 */
  {    55,     12,      3,      0,      0,     55,      0, }, /* 298 */
  {    55,     10,      5,      0,      0,     55,      0, }, /* 299 */
  {    55,      7,     12,      0,      0,     55,      0, }, /* 300 */
  {    55,     13,     12,      0,      0,     55,      0, }, /* 301 */
  {    55,     21,     12,      0,      0,     55,      0, }, /* 302 */
  {    55,     15,     12,      0,      0,     55,      0, }, /* 303 */
  {    55,     26,     12,      0,      0,     55,      0, }, /* 304 */
  {    29,      7,     12,      0,      0,     29,      0, }, /* 305 */
  {    29,     12,      3,      0,      0,     29,      0, }, /* 306 */
  {    29,     10,      5,      0,      0,     29,      0, }, /* 307 */
  {    29,     21,     12,      0,      0,     29,      0, }, /* 308 */
  {    29,     10,      3,      0,      0,     29,      0, }, /* 309 */
  {    29,     13,     12,      0,      0,    -64,      0, }, /* 310 */
  {    37,     12,      3,      0,      0,     37,      0, }, /* 311 */
  {    37,     10,      5,      0,      0,     37,      0, }, /* 312 */
  {    37,      7,     12,      0,      0,     37,      0, }, /* 313 */
  {    37,     10,      3,      0,      0,     37,      0, }, /* 314 */
  {    37,      7,      4,      0,      0,     37,      0, }, /* 315 */
  {    37,     26,     12,      0,      0,     37,      0, }, /* 316 */
  {    37,     15,     12,      0,      0,     37,      0, }, /* 317 */
  {    37,     13,     12,      0,      0,     37,      0, }, /* 318 */
  {    48,     10,      5,      0,      0,     48,      0, }, /* 319 */
  {    48,      7,     12,      0,      0,     48,      0, }, /* 320 */
  {    48,     12,      3,      0,      0,     48,      0, }, /* 321 */
  {    48,     10,      3,      0,      0,     48,      0, }, /* 322 */
  {    48,     13,     12,      0,      0,     48,      0, }, /* 323 */
  {    48,     21,     12,      0,      0,     48,      0, }, /* 324 */
  {    57,      7,     12,      0,      0,     57,      0, }, /* 325 */
  {    57,     12,      3,      0,      0,     57,      0, }, /* 326 */
  {    57,      7,      5,      0,      0,     57,      0, }, /* 327 */
  {    57,      6,     12,      0,      0,     57,      0, }, /* 328 */
  {    57,     21,     12,      0,      0,     57,      0, }, /* 329 */
  {    57,     13,     12,      0,      0,     57,      0, }, /* 330 */
  {    33,      7,     12,      0,      0,     33,      0, }, /* 331 */
  {    33,     12,      3,      0,      0,     33,      0, }, /* 332 */
  {    33,      7,      5,      0,      0,     33,      0, }, /* 333 */
  {    33,      6,     12,      0,      0,     33,      0, }, /* 334 */
  {    33,     13,     12,      0,      0,     33,      0, }, /* 335 */
  {    58,      7,     12,      0,      0,     58,      0, }, /* 336 */
  {    58,     26,     12,      0,      0,     58,      0, }, /* 337 */
  {    58,     21,     12,      0,      0,     58,      0, }, /* 338 */
  {    58,     12,      3,      0,      0,     58,      0, }, /* 339 */
  {    58,     13,     12,      0,      0,     58,      0, }, /* 340 */
  {    58,     15,     12,      0,      0,     58,      0, }, /* 341 */
  {    58,     22,     12,      0,      0,     58,      0, }, /* 342 */
  {    58,     18,     12,      0,      0,     58,      0, }, /* 343 */
  {    58,     10,      5,      0,      0,     58,      0, }, /* 344 */
  {    39,      7,     12,      0,      0,     39,      0, }, /* 345 */
  {    39,     10,     12,      0,      0,     39,      0, }, /* 346 */
  {    39,     12,      3,      0,      0,     39,      0, }, /* 347 */
  {    39,     10,      5,      0,      0,     39,      0, }, /* 348 */
  {    39,     13,     12,      0,      0,    -81,      0, }, /* 349 */
  {    39,     21,     12,      0,      0,     39,      0, }, /* 350 */
  {    39,     13,     12,      0,      0,     39,      0, }, /* 351 */
  {    39,     26,     12,      0,      0,     39,      0, }, /* 352 */
  {    17,      9,     12,      0,   7264,     17,      0, }, /* 353 */
  {    17,      5,     12,      0,   3008,     17,      0, }, /* 354 */
  {    10,     21,     12,      0,      0,    -49,      0, }, /* 355 */
  {    17,      6,     12,      0,      0,     17,      0, }, /* 356 */
  {    24,      7,      6,      0,      0,     24,      0, }, /* 357 */
  {    24,      7,      7,      0,      0,     24,      0, }, /* 358 */
  {    24,      7,      8,      0,      0,     24,      0, }, /* 359 */
  {    16,      7,     12,      0,      0,     16,      0, }, /* 360 */
  {    16,     12,      3,      0,      0,     16,      0, }, /* 361 */
  {    16,     21,     12,      0,      0,     16,      0, }, /* 362 */
  {    16,     15,     12,      0,      0,     16,      0, }, /* 363 */
  {    16,     26,     12,      0,      0,     16,      0, }, /* 364 */
  {     9,      9,     12,      0,  38864,      9,      0, }, /* 365 */
  {     9,      9,     12,      0,      8,      9,      0, }, /* 366 */
  {     9,      5,     12,      0,     -8,      9,      0, }, /* 367 */
  {     8,     17,     12,      0,      0,      8,      0, }, /* 368 */
  {     8,      7,     12,      0,      0,      8,      0, }, /* 369 */
  {     8,     26,     12,      0,      0,      8,      0, }, /* 370 */
  {     8,     21,     12,      0,      0,      8,      0, }, /* 371 */
  {    41,     29,     12,      0,      0,     41,      0, }, /* 372 */
  {    41,      7,     12,      0,      0,     41,      0, }, /* 373 */
  {    41,     22,     12,      0,      0,     41,      0, }, /* 374 */
  {    41,     18,     12,      0,      0,     41,      0, }, /* 375 */
  {    46,      7,     12,      0,      0,     46,      0, }, /* 376 */
  {    46,     14,     12,      0,      0,     46,      0, }, /* 377 */
  {    51,      7,     12,      0,      0,     51,      0, }, /* 378 */
  {    51,     12,      3,      0,      0,     51,      0, }, /* 379 */
  {    25,      7,     12,      0,      0,     25,      0, }, /* 380 */
  {    25,     12,      3,      0,      0,     25,      0, }, /* 381 */
  {    10,     21,     12,      0,      0,   -115,      0, }, /* 382 */
  {     7,      7,     12,      0,      0,      7,      0, }, /* 383 */
  {     7,     12,      3,      0,      0,      7,      0, }, /* 384 */
  {    52,      7,     12,      0,      0,     52,      0, }, /* 385 */
  {    52,     12,      3,      0,      0,     52,      0, }, /* 386 */
  {    32,      7,     12,      0,      0,     32,      0, }, /* 387 */
  {    32,     12,      3,      0,      0,     32,      0, }, /* 388 */
  {    32,     10,      5,      0,      0,     32,      0, }, /* 389 */
  {    32,     21,     12,      0,      0,     32,      0, }, /* 390 */
  {    32,      6,     12,      0,      0,     32,      0, }, /* 391 */
  {    32,     23,     12,      0,      0,     32,      0, }, /* 392 */
  {    32,     13,     12,      0,      0,     32,      0, }, /* 393 */
  {    32,     15,     12,      0,      0,     32,      0, }, /* 394 */
  {    38,     21,     12,      0,      0,     38,      0, }, /* 395 */
  {    10,     21,     12,      0,      0,    -70,      0, }, /* 396 */
  {    38,     17,     12,      0,      0,     38,      0, }, /* 397 */
  {    38,     12,      3,      0,      0,     38,      0, }, /* 398 */
  {    38,      1,      2,      0,      0,     38,      0, }, /* 399 */
  {    38,     13,     12,      0,      0,     38,      0, }, /* 400 */
  {    38,      7,     12,      0,      0,     38,      0, }, /* 401 */
  {    38,      6,     12,      0,      0,     38,      0, }, /* 402 */
  {    35,      7,     12,      0,      0,     35,      0, }, /* 403 */
  {    35,     12,      3,      0,      0,     35,      0, }, /* 404 */
  {    35,     10,      5,      0,      0,     35,      0, }, /* 405 */
  {    35,     26,     12,      0,      0,     35,      0, }, /* 406 */
  {    35,     21,     12,      0,      0,     35,      0, }, /* 407 */
  {    35,     13,     12,      0,      0,     35,      0, }, /* 408 */
  {    53,      7,     12,      0,      0,     53,      0, }, /* 409 */
  {    40,      7,     12,      0,      0,     40,      0, }, /* 410 */
  {    40,     13,     12,      0,      0,     40,      0, }, /* 411 */
  {    40,     15,     12,      0,      0,     40,      0, }, /* 412 */
  {    40,     26,     12,      0,      0,     40,      0, }, /* 413 */
  {    32,     26,     12,      0,      0,     32,      0, }, /* 414 */
  {     6,      7,     12,      0,      0,      6,      0, }, /* 415 */
  {     6,     12,      3,      0,      0,      6,      0, }, /* 416 */
  {     6,     10,      5,      0,      0,      6,      0, }, /* 417 */
  {     6,     21,     12,      0,      0,      6,      0, }, /* 418 */
  {    91,      7,     12,      0,      0,     91,      0, }, /* 419 */
  {    91,     10,      5,      0,      0,     91,      0, }, /* 420 */
  {    91,     12,      3,      0,      0,     91,      0, }, /* 421 */
  {    91,     10,     12,      0,      0,     91,      0, }, /* 422 */
  {    91,     13,     12,      0,      0,     91,      0, }, /* 423 */
  {    91,     21,     12,      0,      0,     91,      0, }, /* 424 */
  {    91,      6,     12,      0,      0,     91,      0, }, /* 425 */
  {    28,     11,      3,      0,      0,     28,      0, }, /* 426 */
  {    62,     12,      3,      0,      0,     62,      0, }, /* 427 */
  {    62,     10,      5,      0,      0,     62,      0, }, /* 428 */
  {    62,      7,     12,      0,      0,     62,      0, }, /* 429 */
  {    62,     10,      3,      0,      0,     62,      0, }, /* 430 */
  {    62,     13,     12,      0,      0,     62,      0, }, /* 431 */
  {    62,     21,     12,      0,      0,     62,      0, }, /* 432 */
  {    62,     26,     12,      0,      0,     62,      0, }, /* 433 */
  {    76,     12,      3,      0,      0,     76,      0, }, /* 434 */
  {    76,     10,      5,      0,      0,     76,      0, }, /* 435 */
  {    76,      7,     12,      0,      0,     76,      0, }, /* 436 */
  {    76,     13,     12,      0,      0,     76,      0, }, /* 437 */
  {    93,      7,     12,      0,      0,     93,      0, }, /* 438 */
  {    93,     12,      3,      0,      0,     93,      0, }, /* 439 */
  {    93,     10,      5,      0,      0,     93,      0, }, /* 440 */
  {    93,     21,     12,      0,      0,     93,      0, }, /* 441 */
  {    70,      7,     12,      0,      0,     70,      0, }, /* 442 */
  {    70,     10,      5,      0,      0,     70,      0, }, /* 443 */
  {    70,     12,      3,      0,      0,     70,      0, }, /* 444 */
  {    70,     21,     12,      0,      0,     70,      0, }, /* 445 */
  {    70,     13,     12,      0,      0,     70,      0, }, /* 446 */
  {    73,     13,     12,      0,      0,     73,      0, }, /* 447 */
  {    73,      7,     12,      0,      0,     73,      0, }, /* 448 */
  {    73,      6,     12,      0,      0,     73,      0, }, /* 449 */
  {    73,     21,     12,      0,      0,     73,      0, }, /* 450 */
  {    13,      5,     12,     63,  -6222,     13,      0, }, /* 451 */
  {    13,      5,     12,     67,  -6221,     13,      0, }, /* 452 */
  {    13,      5,     12,     71,  -6212,     13,      0, }, /* 453 */
  {    13,      5,     12,     75,  -6210,     13,      0, }, /* 454 */
  {    13,      5,     12,     79,  -6210,     13,      0, }, /* 455 */
  {    13,      5,     12,     79,  -6211,     13,      0, }, /* 456 */
  {    13,      5,     12,     84,  -6204,     13,      0, }, /* 457 */
  {    13,      5,     12,     88,  -6180,     13,      0, }, /* 458 */
  {    13,      5,     12,    108,  35267,     13,      0, }, /* 459 */
  {    17,      9,     12,      0,  -3008,     17,      0, }, /* 460 */
  {    76,     21,     12,      0,      0,     76,      0, }, /* 461 */
  {    28,     12,      3,      0,      0,   -110,      0, }, /* 462 */
  {    28,     12,      3,      0,      0,     15,      0, }, /* 463 */
  {    10,     21,     12,      0,      0,    -37,      0, }, /* 464 */
  {    28,     12,      3,      0,      0,    -16,      0, }, /* 465 */
  {    28,     12,      3,      0,      0,    -43,      0, }, /* 466 */
  {    28,     12,      3,      0,      0,   -138,      0, }, /* 467 */
  {    10,     10,      5,      0,      0,    -16,      0, }, /* 468 */
  {    10,      7,     12,      0,      0,    -40,      0, }, /* 469 */
  {    10,      7,     12,      0,      0,    -16,      0, }, /* 470 */
  {    10,      7,     12,      0,      0,     15,      0, }, /* 471 */
  {    10,      7,     12,      0,      0,   -154,      0, }, /* 472 */
  {    10,      7,     12,      0,      0,    -37,      0, }, /* 473 */
  {    28,     12,      3,      0,      0,    -89,      0, }, /* 474 */
  {    10,     10,      5,      0,      0,      3,      0, }, /* 475 */
  {    28,     12,      3,      0,      0,    -37,      0, }, /* 476 */
  {    10,      7,     12,      0,      0,    150,      0, }, /* 477 */
  {    13,      5,     12,      0,      0,     13,      0, }, /* 478 */
  {    13,      6,     12,      0,      0,     13,      0, }, /* 479 */
  {    34,      5,     12,      0,  35332,     34,      0, }, /* 480 */
  {    34,      5,     12,      0,   3814,     34,      0, }, /* 481 */
  {    34,      5,     12,      0,  35384,     34,      0, }, /* 482 */
  {    34,      9,     12,     92,      1,     34,      0, }, /* 483 */
  {    34,      5,     12,     92,     -1,     34,      0, }, /* 484 */
  {    34,      5,     12,     92,    -58,     34,      0, }, /* 485 */
  {    34,      9,     12,      0,  -7615,     34,      0, }, /* 486 */
  {    20,      5,     12,      0,      8,     20,      0, }, /* 487 */
  {    20,      9,     12,      0,     -8,     20,      0, }, /* 488 */
  {    20,      5,     12,      0,     74,     20,      0, }, /* 489 */
  {    20,      5,     12,      0,     86,     20,      0, }, /* 490 */
  {    20,      5,     12,      0,    100,     20,      0, }, /* 491 */
  {    20,      5,     12,      0,    128,     20,      0, }, /* 492 */
  {    20,      5,     12,      0,    112,     20,      0, }, /* 493 */
  {    20,      5,     12,      0,    126,     20,      0, }, /* 494 */
  {    20,      8,     12,      0,     -8,     20,      0, }, /* 495 */
  {    20,      5,     12,      0,      9,     20,      0, }, /* 496 */
  {    20,      9,     12,      0,    -74,     20,      0, }, /* 497 */
  {    20,      8,     12,      0,     -9,     20,      0, }, /* 498 */
  {    20,      5,     12,     21,  -7173,     20,      0, }, /* 499 */
  {    20,      9,     12,      0,    -86,     20,      0, }, /* 500 */
  {    20,      9,     12,      0,   -100,     20,      0, }, /* 501 */
  {    20,      9,     12,      0,   -112,     20,      0, }, /* 502 */
  {    20,      9,     12,      0,   -128,     20,      0, }, /* 503 */
  {    20,      9,     12,      0,   -126,     20,      0, }, /* 504 */
  {    28,      1,      3,      0,      0,     28,      0, }, /* 505 */
  {    28,      1,     13,      0,      0,     28,      0, }, /* 506 */
  {    10,     27,      2,      0,      0,     10,      0, }, /* 507 */
  {    10,     28,      2,      0,      0,     10,      0, }, /* 508 */
  {    10,     29,     12,      0,      0,    -67,      0, }, /* 509 */
  {    10,     21,     14,      0,      0,     10,      0, }, /* 510 */
  {     0,      2,      2,      0,      0,      0,      0, }, /* 511 */
  {    28,     12,      3,      0,      0,    -93,      0, }, /* 512 */
  {    10,      9,     12,      0,      0,     10,      0, }, /* 513 */
  {    10,      5,     12,      0,      0,     10,      0, }, /* 514 */
  {    20,      9,     12,     96,  -7517,     20,      0, }, /* 515 */
  {    34,      9,     12,    100,  -8383,     34,      0, }, /* 516 */
  {    34,      9,     12,    104,  -8262,     34,      0, }, /* 517 */
  {    34,      9,     12,      0,     28,     34,      0, }, /* 518 */
  {    10,      7,     12,      0,      0,     10,      0, }, /* 519 */
  {    10,      5,     14,      0,      0,     10,      0, }, /* 520 */
  {    34,      5,     12,      0,    -28,     34,      0, }, /* 521 */
  {    34,     14,     12,      0,     16,     34,      0, }, /* 522 */
  {    34,     14,     12,      0,    -16,     34,      0, }, /* 523 */
  {    34,     14,     12,      0,      0,     34,      0, }, /* 524 */
  {    10,     25,     14,      0,      0,     10,      0, }, /* 525 */
  {    10,     26,     12,      0,     26,     10,      0, }, /* 526 */
  {    10,     26,     14,      0,     26,     10,      0, }, /* 527 */
  {    10,     26,     12,      0,    -26,     10,      0, }, /* 528 */
  {     5,     26,     12,      0,      0,      5,      0, }, /* 529 */
  {    18,      9,     12,      0,     48,     18,      0, }, /* 530 */
  {    18,      5,     12,      0,    -48,     18,      0, }, /* 531 */
  {    34,      9,     12,      0, -10743,     34,      0, }, /* 532 */
  {    34,      9,     12,      0,  -3814,     34,      0, }, /* 533 */
  {    34,      9,     12,      0, -10727,     34,      0, }, /* 534 */
  {    34,      5,     12,      0, -10795,     34,      0, }, /* 535 */
  {    34,      5,     12,      0, -10792,     34,      0, }, /* 536 */
  {    34,      9,     12,      0, -10780,     34,      0, }, /* 537 */
  {    34,      9,     12,      0, -10749,     34,      0, }, /* 538 */
  {    34,      9,     12,      0, -10783,     34,      0, }, /* 539 */
  {    34,      9,     12,      0, -10782,     34,      0, }, /* 540 */
  {    34,      9,     12,      0, -10815,     34,      0, }, /* 541 */
  {    11,      5,     12,      0,      0,     11,      0, }, /* 542 */
  {    11,     26,     12,      0,      0,     11,      0, }, /* 543 */
  {    11,     12,      3,      0,      0,     11,      0, }, /* 544 */
  {    11,     21,     12,      0,      0,     11,      0, }, /* 545 */
  {    11,     15,     12,      0,      0,     11,      0, }, /* 546 */
  {    17,      5,     12,      0,  -7264,     17,      0, }, /* 547 */
  {    59,      7,     12,      0,      0,     59,      0, }, /* 548 */
  {    59,      6,     12,      0,      0,     59,      0, }, /* 549 */
  {    59,     21,     12,      0,      0,     59,      0, }, /* 550 */
  {    59,     12,      3,      0,      0,     59,      0, }, /* 551 */
  {    13,     12,      3,      0,      0,     13,      0, }, /* 552 */
  {    10,     21,     12,      0,      0,    -28,      0, }, /* 553 */
  {    23,     26,     12,      0,      0,     23,      0, }, /* 554 */
  {    10,     21,     12,      0,      0,   -131,      0, }, /* 555 */
  {    10,     21,     12,      0,      0,   -125,      0, }, /* 556 */
  {    23,      6,     12,      0,      0,     23,      0, }, /* 557 */
  {    10,      7,     12,      0,      0,     23,      0, }, /* 558 */
  {    23,     14,     12,      0,      0,     23,      0, }, /* 559 */
  {    10,     22,     12,      0,      0,   -131,      0, }, /* 560 */
  {    10,     18,     12,      0,      0,   -131,      0, }, /* 561 */
  {    10,     26,     12,      0,      0,   -125,      0, }, /* 562 */
  {    10,     17,     12,      0,      0,   -125,      0, }, /* 563 */
  {    10,     22,     12,      0,      0,   -125,      0, }, /* 564 */
  {    10,     18,     12,      0,      0,   -125,      0, }, /* 565 */
  {    28,     12,      3,      0,      0,    -19,      0, }, /* 566 */
  {    24,     10,      3,      0,      0,     24,      0, }, /* 567 */
  {    10,     17,     14,      0,      0,   -125,      0, }, /* 568 */
  {    10,      6,     12,      0,      0,    -61,      0, }, /* 569 */
  {    10,      7,     12,      0,      0,    -97,      0, }, /* 570 */
  {    10,     21,     14,      0,      0,    -97,      0, }, /* 571 */
  {    10,     26,     12,      0,      0,     23,      0, }, /* 572 */
  {    27,      7,     12,      0,      0,     27,      0, }, /* 573 */
  {    28,     12,      3,      0,      0,    -61,      0, }, /* 574 */
  {    10,     24,     12,      0,      0,    -61,      0, }, /* 575 */
  {    27,      6,     12,      0,      0,     27,      0, }, /* 576 */
  {    10,     17,     12,      0,      0,    -61,      0, }, /* 577 */
  {    30,      7,     12,      0,      0,     30,      0, }, /* 578 */
  {    30,      6,     12,      0,      0,     30,      0, }, /* 579 */
  {     4,      7,     12,      0,      0,      4,      0, }, /* 580 */
  {    24,      7,     12,      0,      0,     24,      0, }, /* 581 */
  {    10,     15,     12,      0,      0,     23,      0, }, /* 582 */
  {    24,     26,     12,      0,      0,     24,      0, }, /* 583 */
  {    10,     26,     14,      0,      0,     23,      0, }, /* 584 */
  {    30,     26,     12,      0,      0,     30,      0, }, /* 585 */
  {    23,      7,     12,      0,      0,     23,      0, }, /* 586 */
  {    61,      7,     12,      0,      0,     61,      0, }, /* 587 */
  {    61,      6,     12,      0,      0,     61,      0, }, /* 588 */
  {    61,     26,     12,      0,      0,     61,      0, }, /* 589 */
  {    86,      7,     12,      0,      0,     86,      0, }, /* 590 */
  {    86,      6,     12,      0,      0,     86,      0, }, /* 591 */
  {    86,     21,     12,      0,      0,     86,      0, }, /* 592 */
  {    77,      7,     12,      0,      0,     77,      0, }, /* 593 */
  {    77,      6,     12,      0,      0,     77,      0, }, /* 594 */
  {    77,     21,     12,      0,      0,     77,      0, }, /* 595 */
  {    77,     13,     12,      0,      0,     77,      0, }, /* 596 */
  {    13,      9,     12,    108,      1,     13,      0, }, /* 597 */
  {    13,      5,     12,    108, -35267,     13,      0, }, /* 598 */
  {    13,      7,     12,      0,      0,     13,      0, }, /* 599 */
  {    13,     21,     12,      0,      0,     13,      0, }, /* 600 */
  {    79,      7,     12,      0,      0,     79,      0, }, /* 601 */
  {    79,     14,     12,      0,      0,     79,      0, }, /* 602 */
  {    79,     12,      3,      0,      0,     79,      0, }, /* 603 */
  {    79,     21,     12,      0,      0,     79,      0, }, /* 604 */
  {    34,      9,     12,      0, -35332,     34,      0, }, /* 605 */
  {    34,      9,     12,      0, -42280,     34,      0, }, /* 606 */
  {    34,      5,     12,      0,     48,     34,      0, }, /* 607 */
  {    34,      9,     12,      0, -42308,     34,      0, }, /* 608 */
  {    34,      9,     12,      0, -42319,     34,      0, }, /* 609 */
  {    34,      9,     12,      0, -42315,     34,      0, }, /* 610 */
  {    34,      9,     12,      0, -42305,     34,      0, }, /* 611 */
  {    34,      9,     12,      0, -42258,     34,      0, }, /* 612 */
  {    34,      9,     12,      0, -42282,     34,      0, }, /* 613 */
  {    34,      9,     12,      0, -42261,     34,      0, }, /* 614 */
  {    34,      9,     12,      0,    928,     34,      0, }, /* 615 */
  {    34,      9,     12,      0,    -48,     34,      0, }, /* 616 */
  {    34,      9,     12,      0, -42307,     34,      0, }, /* 617 */
  {    34,      9,     12,      0, -35384,     34,      0, }, /* 618 */
  {    49,      7,     12,      0,      0,     49,      0, }, /* 619 */
  {    49,     12,      3,      0,      0,     49,      0, }, /* 620 */
  {    49,     10,      5,      0,      0,     49,      0, }, /* 621 */
  {    49,     26,     12,      0,      0,     49,      0, }, /* 622 */
  {    10,     15,     12,      0,      0,   -216,      0, }, /* 623 */
  {    10,     15,     12,      0,      0,   -202,      0, }, /* 624 */
  {    10,     26,     12,      0,      0,   -163,      0, }, /* 625 */
  {    10,     23,     12,      0,      0,   -163,      0, }, /* 626 */
  {    65,      7,     12,      0,      0,     65,      0, }, /* 627 */
  {    65,     21,     12,      0,      0,     65,      0, }, /* 628 */
  {    75,     10,      5,      0,      0,     75,      0, }, /* 629 */
  {    75,      7,     12,      0,      0,     75,      0, }, /* 630 */
  {    75,     12,      3,      0,      0,     75,      0, }, /* 631 */
  {    75,     21,     12,      0,      0,     75,      0, }, /* 632 */
  {    75,     13,     12,      0,      0,     75,      0, }, /* 633 */
  {    15,     12,      3,      0,      0,    -16,      0, }, /* 634 */
  {    15,      7,     12,      0,      0,    -46,      0, }, /* 635 */
  {    69,     13,     12,      0,      0,     69,      0, }, /* 636 */
  {    69,      7,     12,      0,      0,     69,      0, }, /* 637 */
  {    69,     12,      3,      0,      0,     69,      0, }, /* 638 */
  {    10,     21,     12,      0,      0,   -101,      0, }, /* 639 */
  {    69,     21,     12,      0,      0,     69,      0, }, /* 640 */
  {    74,      7,     12,      0,      0,     74,      0, }, /* 641 */
  {    74,     12,      3,      0,      0,     74,      0, }, /* 642 */
  {    74,     10,      5,      0,      0,     74,      0, }, /* 643 */
  {    74,     21,     12,      0,      0,     74,      0, }, /* 644 */
  {    84,     12,      3,      0,      0,     84,      0, }, /* 645 */
  {    84,     10,      5,      0,      0,     84,      0, }, /* 646 */
  {    84,      7,     12,      0,      0,     84,      0, }, /* 647 */
  {    84,     21,     12,      0,      0,     84,      0, }, /* 648 */
  {    10,      6,     12,      0,      0,    -22,      0, }, /* 649 */
  {    84,     13,     12,      0,      0,     84,      0, }, /* 650 */
  {    39,      6,     12,      0,      0,     39,      0, }, /* 651 */
  {    68,      7,     12,      0,      0,     68,      0, }, /* 652 */
  {    68,     12,      3,      0,      0,     68,      0, }, /* 653 */
  {    68,     10,      5,      0,      0,     68,      0, }, /* 654 */
  {    68,     13,     12,      0,      0,     68,      0, }, /* 655 */
  {    68,     21,     12,      0,      0,     68,      0, }, /* 656 */
  {    92,      7,     12,      0,      0,     92,      0, }, /* 657 */
  {    92,     12,      3,      0,      0,     92,      0, }, /* 658 */
  {    92,      6,     12,      0,      0,     92,      0, }, /* 659 */
  {    92,     21,     12,      0,      0,     92,      0, }, /* 660 */
  {    87,      7,     12,      0,      0,     87,      0, }, /* 661 */
  {    87,     10,      5,      0,      0,     87,      0, }, /* 662 */
  {    87,     12,      3,      0,      0,     87,      0, }, /* 663 */
  {    87,     21,     12,      0,      0,     87,      0, }, /* 664 */
  {    87,      6,     12,      0,      0,     87,      0, }, /* 665 */
  {    34,      5,     12,      0,   -928,     34,      0, }, /* 666 */
  {     9,      5,     12,      0, -38864,      9,      0, }, /* 667 */
  {    87,     13,     12,      0,      0,     87,      0, }, /* 668 */
  {    24,      7,      9,      0,      0,     24,      0, }, /* 669 */
  {    24,      7,     10,      0,      0,     24,      0, }, /* 670 */
  {     0,      4,     12,      0,      0,      0,      0, }, /* 671 */
  {     0,      3,     12,      0,      0,      0,      0, }, /* 672 */
  {    26,     25,     12,      0,      0,     26,      0, }, /* 673 */
  {     1,     24,     12,      0,      0,      1,      0, }, /* 674 */
  {     1,      7,     12,      0,      0,    -10,      0, }, /* 675 */
  {     1,     26,     12,      0,      0,    -10,      0, }, /* 676 */
  {    10,      6,      3,      0,      0,    -61,      0, }, /* 677 */
  {    36,      7,     12,      0,      0,     36,      0, }, /* 678 */
  {    10,     21,     12,      0,      0,    -25,      0, }, /* 679 */
  {    10,     15,     12,      0,      0,    -85,      0, }, /* 680 */
  {    10,     26,     12,      0,      0,    -25,      0, }, /* 681 */
  {    20,     14,     12,      0,      0,     20,      0, }, /* 682 */
  {    20,     15,     12,      0,      0,     20,      0, }, /* 683 */
  {    20,     26,     12,      0,      0,     20,      0, }, /* 684 */
  {    71,      7,     12,      0,      0,     71,      0, }, /* 685 */
  {    67,      7,     12,      0,      0,     67,      0, }, /* 686 */
  {    28,     12,      3,      0,      0,     -1,      0, }, /* 687 */
  {    10,     15,     12,      0,      0,     -1,      0, }, /* 688 */
  {    42,      7,     12,      0,      0,     42,      0, }, /* 689 */
  {    42,     15,     12,      0,      0,     42,      0, }, /* 690 */
  {    19,      7,     12,      0,      0,     19,      0, }, /* 691 */
  {    19,     14,     12,      0,      0,     19,      0, }, /* 692 */
  {   118,      7,     12,      0,      0,    118,      0, }, /* 693 */
  {   118,     12,      3,      0,      0,    118,      0, }, /* 694 */
  {    60,      7,     12,      0,      0,     60,      0, }, /* 695 */
  {    60,     21,     12,      0,      0,     60,      0, }, /* 696 */
  {    43,      7,     12,      0,      0,     43,      0, }, /* 697 */
  {    43,     21,     12,      0,      0,     43,      0, }, /* 698 */
  {    43,     14,     12,      0,      0,     43,      0, }, /* 699 */
  {    14,      9,     12,      0,     40,     14,      0, }, /* 700 */
  {    14,      5,     12,      0,    -40,     14,      0, }, /* 701 */
  {    47,      7,     12,      0,      0,     47,      0, }, /* 702 */
  {    45,      7,     12,      0,      0,     45,      0, }, /* 703 */
  {    45,     13,     12,      0,      0,     45,      0, }, /* 704 */
  {   136,      9,     12,      0,     40,    136,      0, }, /* 705 */
  {   136,      5,     12,      0,    -40,    136,      0, }, /* 706 */
  {   106,      7,     12,      0,      0,    106,      0, }, /* 707 */
  {   104,      7,     12,      0,      0,    104,      0, }, /* 708 */
  {   104,     21,     12,      0,      0,    104,      0, }, /* 709 */
  {   110,      7,     12,      0,      0,    110,      0, }, /* 710 */
  {    12,      7,     12,      0,      0,     12,      0, }, /* 711 */
  {    81,      7,     12,      0,      0,     81,      0, }, /* 712 */
  {    81,     21,     12,      0,      0,     81,      0, }, /* 713 */
  {    81,     15,     12,      0,      0,     81,      0, }, /* 714 */
  {   120,      7,     12,      0,      0,    120,      0, }, /* 715 */
  {   120,     26,     12,      0,      0,    120,      0, }, /* 716 */
  {   120,     15,     12,      0,      0,    120,      0, }, /* 717 */
  {   116,      7,     12,      0,      0,    116,      0, }, /* 718 */
  {   116,     15,     12,      0,      0,    116,      0, }, /* 719 */
  {   128,      7,     12,      0,      0,    128,      0, }, /* 720 */
  {   128,     15,     12,      0,      0,    128,      0, }, /* 721 */
  {    66,      7,     12,      0,      0,     66,      0, }, /* 722 */
  {    66,     15,     12,      0,      0,     66,      0, }, /* 723 */
  {    66,     21,     12,      0,      0,     66,      0, }, /* 724 */
  {    72,      7,     12,      0,      0,     72,      0, }, /* 725 */
  {    72,     21,     12,      0,      0,     72,      0, }, /* 726 */
  {    98,      7,     12,      0,      0,     98,      0, }, /* 727 */
  {    97,      7,     12,      0,      0,     97,      0, }, /* 728 */
  {    97,     15,     12,      0,      0,     97,      0, }, /* 729 */
  {    31,      7,     12,      0,      0,     31,      0, }, /* 730 */
  {    31,     12,      3,      0,      0,     31,      0, }, /* 731 */
  {    31,     15,     12,      0,      0,     31,      0, }, /* 732 */
  {    31,     21,     12,      0,      0,     31,      0, }, /* 733 */
  {    88,      7,     12,      0,      0,     88,      0, }, /* 734 */
  {    88,     15,     12,      0,      0,     88,      0, }, /* 735 */
  {    88,     21,     12,      0,      0,     88,      0, }, /* 736 */
  {   117,      7,     12,      0,      0,    117,      0, }, /* 737 */
  {   117,     15,     12,      0,      0,    117,      0, }, /* 738 */
  {   112,      7,     12,      0,      0,    112,      0, }, /* 739 */
  {   112,     26,     12,      0,      0,    112,      0, }, /* 740 */
  {   112,     12,      3,      0,      0,    112,      0, }, /* 741 */
  {   112,     15,     12,      0,      0,    112,      0, }, /* 742 */
  {   112,     21,     12,      0,      0,    112,      0, }, /* 743 */
  {    78,      7,     12,      0,      0,     78,      0, }, /* 744 */
  {    78,     21,     12,      0,      0,     78,      0, }, /* 745 */
  {    83,      7,     12,      0,      0,     83,      0, }, /* 746 */
  {    83,     15,     12,      0,      0,     83,      0, }, /* 747 */
  {    82,      7,     12,      0,      0,     82,      0, }, /* 748 */
  {    82,     15,     12,      0,      0,     82,      0, }, /* 749 */
  {   121,      7,     12,      0,      0,    121,      0, }, /* 750 */
  {   121,     21,     12,      0,      0,    121,      0, }, /* 751 */
  {   121,     15,     12,      0,      0,    121,      0, }, /* 752 */
  {    89,      7,     12,      0,      0,     89,      0, }, /* 753 */
  {   130,      9,     12,      0,     64,    130,      0, }, /* 754 */
  {   130,      5,     12,      0,    -64,    130,      0, }, /* 755 */
  {   130,     15,     12,      0,      0,    130,      0, }, /* 756 */
  {   144,      7,     12,      0,      0,    144,      0, }, /* 757 */
  {   144,     12,      3,      0,      0,    144,      0, }, /* 758 */
  {   144,     13,     12,      0,      0,    144,      0, }, /* 759 */
  {     1,     15,     12,      0,      0,      1,      0, }, /* 760 */
  {   147,      7,     12,      0,      0,    147,      0, }, /* 761 */
  {   147,     15,     12,      0,      0,    147,      0, }, /* 762 */
  {   148,      7,     12,      0,      0,    148,      0, }, /* 763 */
  {   148,     12,      3,      0,      0,    148,      0, }, /* 764 */
  {   148,     15,     12,      0,      0,    148,      0, }, /* 765 */
  {   148,     21,     12,      0,      0,    148,      0, }, /* 766 */
  {   149,      7,     12,      0,      0,    149,      0, }, /* 767 */
  {    94,     10,      5,      0,      0,     94,      0, }, /* 768 */
  {    94,     12,      3,      0,      0,     94,      0, }, /* 769 */
  {    94,      7,     12,      0,      0,     94,      0, }, /* 770 */
  {    94,     21,     12,      0,      0,     94,      0, }, /* 771 */
  {    94,     15,     12,      0,      0,     94,      0, }, /* 772 */
  {    94,     13,     12,      0,      0,     94,      0, }, /* 773 */
  {    85,     12,      3,      0,      0,     85,      0, }, /* 774 */
  {    85,     10,      5,      0,      0,     85,      0, }, /* 775 */
  {    85,      7,     12,      0,      0,     85,      0, }, /* 776 */
  {    85,     21,     12,      0,      0,     85,      0, }, /* 777 */
  {    85,      1,      4,      0,      0,     85,      0, }, /* 778 */
  {   101,      7,     12,      0,      0,    101,      0, }, /* 779 */
  {   101,     13,     12,      0,      0,    101,      0, }, /* 780 */
  {    96,     12,      3,      0,      0,     96,      0, }, /* 781 */
  {    96,      7,     12,      0,      0,     96,      0, }, /* 782 */
  {    96,     10,      5,      0,      0,     96,      0, }, /* 783 */
  {    96,     13,     12,      0,      0,     96,      0, }, /* 784 */
  {    96,     21,     12,      0,      0,     96,      0, }, /* 785 */
  {   111,      7,     12,      0,      0,    111,      0, }, /* 786 */
  {   111,     12,      3,      0,      0,    111,      0, }, /* 787 */
  {   111,     21,     12,      0,      0,    111,      0, }, /* 788 */
  {   100,     12,      3,      0,      0,    100,      0, }, /* 789 */
  {   100,     10,      5,      0,      0,    100,      0, }, /* 790 */
  {   100,      7,     12,      0,      0,    100,      0, }, /* 791 */
  {   100,      7,      4,      0,      0,    100,      0, }, /* 792 */
  {   100,     21,     12,      0,      0,    100,      0, }, /* 793 */
  {   100,     13,     12,      0,      0,    100,      0, }, /* 794 */
  {    48,     15,     12,      0,      0,     48,      0, }, /* 795 */
  {   108,      7,     12,      0,      0,    108,      0, }, /* 796 */
  {   108,     10,      5,      0,      0,    108,      0, }, /* 797 */
  {   108,     12,      3,      0,      0,    108,      0, }, /* 798 */
  {   108,     21,     12,      0,      0,    108,      0, }, /* 799 */
  {   129,      7,     12,      0,      0,    129,      0, }, /* 800 */
  {   129,     21,     12,      0,      0,    129,      0, }, /* 801 */
  {   109,      7,     12,      0,      0,    109,      0, }, /* 802 */
  {   109,     12,      3,      0,      0,    109,      0, }, /* 803 */
  {   109,     10,      5,      0,      0,    109,      0, }, /* 804 */
  {   109,     13,     12,      0,      0,    109,      0, }, /* 805 */
  {   107,     12,      3,      0,      0,    107,      0, }, /* 806 */
  {   107,     12,      3,      0,      0,    -52,      0, }, /* 807 */
  {   107,     10,      5,      0,      0,    107,      0, }, /* 808 */
  {   107,     10,      5,      0,      0,    -52,      0, }, /* 809 */
  {   107,      7,     12,      0,      0,    107,      0, }, /* 810 */
  {    28,     12,      3,      0,      0,    -52,      0, }, /* 811 */
  {   107,     10,      3,      0,      0,    107,      0, }, /* 812 */
  {   135,      7,     12,      0,      0,    135,      0, }, /* 813 */
  {   135,     10,      5,      0,      0,    135,      0, }, /* 814 */
  {   135,     12,      3,      0,      0,    135,      0, }, /* 815 */
  {   135,     21,     12,      0,      0,    135,      0, }, /* 816 */
  {   135,     13,     12,      0,      0,    135,      0, }, /* 817 */
  {   124,      7,     12,      0,      0,    124,      0, }, /* 818 */
  {   124,     10,      3,      0,      0,    124,      0, }, /* 819 */
  {   124,     10,      5,      0,      0,    124,      0, }, /* 820 */
  {   124,     12,      3,      0,      0,    124,      0, }, /* 821 */
  {   124,     21,     12,      0,      0,    124,      0, }, /* 822 */
  {   124,     13,     12,      0,      0,    124,      0, }, /* 823 */
  {   123,      7,     12,      0,      0,    123,      0, }, /* 824 */
  {   123,     10,      3,      0,      0,    123,      0, }, /* 825 */
  {   123,     10,      5,      0,      0,    123,      0, }, /* 826 */
  {   123,     12,      3,      0,      0,    123,      0, }, /* 827 */
  {   123,     21,     12,      0,      0,    123,      0, }, /* 828 */
  {   114,      7,     12,      0,      0,    114,      0, }, /* 829 */
  {   114,     10,      5,      0,      0,    114,      0, }, /* 830 */
  {   114,     12,      3,      0,      0,    114,      0, }, /* 831 */
  {   114,     21,     12,      0,      0,    114,      0, }, /* 832 */
  {   114,     13,     12,      0,      0,    114,      0, }, /* 833 */
  {   102,      7,     12,      0,      0,    102,      0, }, /* 834 */
  {   102,     12,      3,      0,      0,    102,      0, }, /* 835 */
  {   102,     10,      5,      0,      0,    102,      0, }, /* 836 */
  {   102,     13,     12,      0,      0,    102,      0, }, /* 837 */
  {   126,      7,     12,      0,      0,    126,      0, }, /* 838 */
  {   126,     12,      3,      0,      0,    126,      0, }, /* 839 */
  {   126,     10,      5,      0,      0,    126,      0, }, /* 840 */
  {   126,     13,     12,      0,      0,    126,      0, }, /* 841 */
  {   126,     15,     12,      0,      0,    126,      0, }, /* 842 */
  {   126,     21,     12,      0,      0,    126,      0, }, /* 843 */
  {   126,     26,     12,      0,      0,    126,      0, }, /* 844 */
  {   142,      7,     12,      0,      0,    142,      0, }, /* 845 */
  {   142,     10,      5,      0,      0,    142,      0, }, /* 846 */
  {   142,     12,      3,      0,      0,    142,      0, }, /* 847 */
  {   142,     21,     12,      0,      0,    142,      0, }, /* 848 */
  {   125,      9,     12,      0,     32,    125,      0, }, /* 849 */
  {   125,      5,     12,      0,    -32,    125,      0, }, /* 850 */
  {   125,     13,     12,      0,      0,    125,      0, }, /* 851 */
  {   125,     15,     12,      0,      0,    125,      0, }, /* 852 */
  {   125,      7,     12,      0,      0,    125,      0, }, /* 853 */
  {   150,      7,     12,      0,      0,    150,      0, }, /* 854 */
  {   150,     10,      5,      0,      0,    150,      0, }, /* 855 */
  {   150,     12,      3,      0,      0,    150,      0, }, /* 856 */
  {   150,     21,     12,      0,      0,    150,      0, }, /* 857 */
  {   141,      7,     12,      0,      0,    141,      0, }, /* 858 */
  {   141,     12,      3,      0,      0,    141,      0, }, /* 859 */
  {   141,     10,      5,      0,      0,    141,      0, }, /* 860 */
  {   141,      7,      4,      0,      0,    141,      0, }, /* 861 */
  {   141,     21,     12,      0,      0,    141,      0, }, /* 862 */
  {   140,      7,     12,      0,      0,    140,      0, }, /* 863 */
  {   140,     12,      3,      0,      0,    140,      0, }, /* 864 */
  {   140,     10,      5,      0,      0,    140,      0, }, /* 865 */
  {   140,      7,      4,      0,      0,    140,      0, }, /* 866 */
  {   140,     21,     12,      0,      0,    140,      0, }, /* 867 */
  {   122,      7,     12,      0,      0,    122,      0, }, /* 868 */
  {   133,      7,     12,      0,      0,    133,      0, }, /* 869 */
  {   133,     10,      5,      0,      0,    133,      0, }, /* 870 */
  {   133,     12,      3,      0,      0,    133,      0, }, /* 871 */
  {   133,     21,     12,      0,      0,    133,      0, }, /* 872 */
  {   133,     13,     12,      0,      0,    133,      0, }, /* 873 */
  {   133,     15,     12,      0,      0,    133,      0, }, /* 874 */
  {   134,     21,     12,      0,      0,    134,      0, }, /* 875 */
  {   134,      7,     12,      0,      0,    134,      0, }, /* 876 */
  {   134,     12,      3,      0,      0,    134,      0, }, /* 877 */
  {   134,     10,      5,      0,      0,    134,      0, }, /* 878 */
  {   138,      7,     12,      0,      0,    138,      0, }, /* 879 */
  {   138,     12,      3,      0,      0,    138,      0, }, /* 880 */
  {   138,      7,      4,      0,      0,    138,      0, }, /* 881 */
  {   138,     13,     12,      0,      0,    138,      0, }, /* 882 */
  {   143,      7,     12,      0,      0,    143,      0, }, /* 883 */
  {   143,     10,      5,      0,      0,    143,      0, }, /* 884 */
  {   143,     12,      3,      0,      0,    143,      0, }, /* 885 */
  {   143,     13,     12,      0,      0,    143,      0, }, /* 886 */
  {   145,      7,     12,      0,      0,    145,      0, }, /* 887 */
  {   145,     12,      3,      0,      0,    145,      0, }, /* 888 */
  {   145,     10,      5,      0,      0,    145,      0, }, /* 889 */
  {   145,     21,     12,      0,      0,    145,      0, }, /* 890 */
  {    54,     15,     12,      0,      0,     54,      0, }, /* 891 */
  {    54,     21,     12,      0,      0,     54,      0, }, /* 892 */
  {    63,      7,     12,      0,      0,     63,      0, }, /* 893 */
  {    63,     14,     12,      0,      0,     63,      0, }, /* 894 */
  {    63,     21,     12,      0,      0,     63,      0, }, /* 895 */
  {    80,      7,     12,      0,      0,     80,      0, }, /* 896 */
  {    80,      1,      2,      0,      0,     80,      0, }, /* 897 */
  {   127,      7,     12,      0,      0,    127,      0, }, /* 898 */
  {   115,      7,     12,      0,      0,    115,      0, }, /* 899 */
  {   115,     13,     12,      0,      0,    115,      0, }, /* 900 */
  {   115,     21,     12,      0,      0,    115,      0, }, /* 901 */
  {   103,      7,     12,      0,      0,    103,      0, }, /* 902 */
  {   103,     12,      3,      0,      0,    103,      0, }, /* 903 */
  {   103,     21,     12,      0,      0,    103,      0, }, /* 904 */
  {   119,      7,     12,      0,      0,    119,      0, }, /* 905 */
  {   119,     12,      3,      0,      0,    119,      0, }, /* 906 */
  {   119,     21,     12,      0,      0,    119,      0, }, /* 907 */
  {   119,     26,     12,      0,      0,    119,      0, }, /* 908 */
  {   119,      6,     12,      0,      0,    119,      0, }, /* 909 */
  {   119,     13,     12,      0,      0,    119,      0, }, /* 910 */
  {   119,     15,     12,      0,      0,    119,      0, }, /* 911 */
  {   146,      9,     12,      0,     32,    146,      0, }, /* 912 */
  {   146,      5,     12,      0,    -32,    146,      0, }, /* 913 */
  {   146,     15,     12,      0,      0,    146,      0, }, /* 914 */
  {   146,     21,     12,      0,      0,    146,      0, }, /* 915 */
  {    99,      7,     12,      0,      0,     99,      0, }, /* 916 */
  {    99,     12,      3,      0,      0,     99,      0, }, /* 917 */
  {    99,     10,      5,      0,      0,     99,      0, }, /* 918 */
  {    99,      6,     12,      0,      0,     99,      0, }, /* 919 */
  {   137,      6,     12,      0,      0,    137,      0, }, /* 920 */
  {   139,      6,     12,      0,      0,    139,      0, }, /* 921 */
  {   137,      7,     12,      0,      0,    137,      0, }, /* 922 */
  {   139,      7,     12,      0,      0,    139,      0, }, /* 923 */
  {   105,      7,     12,      0,      0,    105,      0, }, /* 924 */
  {   105,     26,     12,      0,      0,    105,      0, }, /* 925 */
  {   105,     12,      3,      0,      0,    105,      0, }, /* 926 */
  {   105,     21,     12,      0,      0,    105,      0, }, /* 927 */
  {    10,      1,      2,      0,      0,    105,      0, }, /* 928 */
  {    10,     10,      3,      0,      0,     10,      0, }, /* 929 */
  {    10,     10,      5,      0,      0,     10,      0, }, /* 930 */
  {    20,     12,      3,      0,      0,     20,      0, }, /* 931 */
  {   131,     26,     12,      0,      0,    131,      0, }, /* 932 */
  {   131,     12,      3,      0,      0,    131,      0, }, /* 933 */
  {   131,     21,     12,      0,      0,    131,      0, }, /* 934 */
  {    18,     12,      3,      0,      0,     18,      0, }, /* 935 */
  {   151,      7,     12,      0,      0,    151,      0, }, /* 936 */
  {   151,     12,      3,      0,      0,    151,      0, }, /* 937 */
  {   151,      6,     12,      0,      0,    151,      0, }, /* 938 */
  {   151,     13,     12,      0,      0,    151,      0, }, /* 939 */
  {   151,     26,     12,      0,      0,    151,      0, }, /* 940 */
  {   152,      7,     12,      0,      0,    152,      0, }, /* 941 */
  {   152,     12,      3,      0,      0,    152,      0, }, /* 942 */
  {   152,     13,     12,      0,      0,    152,      0, }, /* 943 */
  {   152,     23,     12,      0,      0,    152,      0, }, /* 944 */
  {   113,      7,     12,      0,      0,    113,      0, }, /* 945 */
  {   113,     15,     12,      0,      0,    113,      0, }, /* 946 */
  {   113,     12,      3,      0,      0,    113,      0, }, /* 947 */
  {   132,      9,     12,      0,     34,    132,      0, }, /* 948 */
  {   132,      5,     12,      0,    -34,    132,      0, }, /* 949 */
  {   132,     12,      3,      0,      0,    132,      0, }, /* 950 */
  {   132,      6,     12,      0,      0,    132,      0, }, /* 951 */
  {   132,     13,     12,      0,      0,    132,      0, }, /* 952 */
  {   132,     21,     12,      0,      0,    132,      0, }, /* 953 */
  {     0,      2,     14,      0,      0,      0,      0, }, /* 954 */
  {    10,     26,     11,      0,      0,     10,      0, }, /* 955 */
  {    27,     26,     12,      0,      0,     27,      0, }, /* 956 */
  {    10,     24,      3,      0,      0,     10,      0, }, /* 957 */
  {    10,      1,      3,      0,      0,     10,      0, }, /* 958 */
};

const uint16_t PRIV(ucd_stage1)[] = { /* 17408 bytes */
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, /* U+0000 */
 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, /* U+0800 */
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 41, 41, 42, 43, 44, 45, /* U+1000 */
 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, /* U+1800 */
 62, 63, 64, 65, 66, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, /* U+2000 */
 77, 77, 78, 79, 66, 66, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, /* U+2800 */
 90, 91, 92, 93, 94, 95, 96, 97, 98, 98, 98, 98, 98, 98, 98, 98, /* U+3000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+3800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+4000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 98, 98, 98, 98, /* U+4800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+5000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+5800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+6000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+6800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+7000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+7800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+8000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+8800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+9000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,100, /* U+9800 */
101,102,102,102,102,102,102,102,102,103,104,104,105,106,107,108, /* U+A000 */
109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,117, /* U+A800 */
118,119,120,121,122,123,117,118,119,120,121,122,123,117,118,119, /* U+B000 */
120,121,122,123,117,118,119,120,121,122,123,117,118,119,120,121, /* U+B800 */
122,123,117,118,119,120,121,122,123,117,118,119,120,121,122,123, /* U+C000 */
117,118,119,120,121,122,123,117,118,119,120,121,122,123,117,118, /* U+C800 */
119,120,121,122,123,117,118,119,120,121,122,123,117,118,119,124, /* U+D000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+D800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+E000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+E800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F000 */
126,126, 98, 98,127,128,129,130,131,131,132,133,134,135,136,137, /* U+F800 */
138,139,140,141,142,143,144,145,146,147,148,142,149,149,150,142, /* U+10000 */
151,152,153,154,155,156,157,158,159,160,161,142,162,142,163,164, /* U+10800 */
165,166,167,168,169,170,171,142,172,173,142,174,175,176,177,142, /* U+11000 */
178,179,142,180,181,182,142,142,183,184,185,186,142,187,142,188, /* U+11800 */
189,189,189,189,189,189,189,190,191,189,192,142,142,142,142,142, /* U+12000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+12800 */
193,193,193,193,193,193,193,193,194,142,142,142,142,142,142,142, /* U+13000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+13800 */
142,142,142,142,142,142,142,142,195,195,195,195,196,142,142,142, /* U+14000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+14800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+15000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+15800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+16000 */
197,197,197,197,198,199,200,201,142,142,142,142,202,203,204,205, /* U+16800 */
206,206,206,206,206,206,206,206,206,206,206,206,206,206,206,206, /* U+17000 */
206,206,206,206,206,206,206,206,206,206,206,206,206,206,206,206, /* U+17800 */
206,206,206,206,206,206,206,206,206,206,206,206,206,206,206,207, /* U+18000 */
206,206,206,206,206,208,142,142,142,142,142,142,142,142,142,142, /* U+18800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+19000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+19800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1A800 */
209,210,211,212,212,213,142,142,142,142,142,142,142,142,142,142, /* U+1B000 */
142,142,142,142,142,142,142,142,214,215,142,142,142,142,142,142, /* U+1B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+1C800 */
 71,216,217,218,219,220,221,142,222,223,224,225,226,227,228,229, /* U+1D000 */
230,230,230,230,231,232,142,142,142,142,142,142,142,142,142,142, /* U+1D800 */
233,142,234,142,142,235,142,142,142,142,142,142,142,142,142,142, /* U+1E000 */
236,237,238,142,142,142,142,142,239,240,241,142,242,243,142,142, /* U+1E800 */
244,245,246,247,248,249,250,251,250,250,252,250,253,254,255,256, /* U+1F000 */
257,258,259,260,261,262,249,249,249,249,249,249,249,249,249,263, /* U+1F800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+20000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+20800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+21000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+21800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+22000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+22800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+23000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+23800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+24000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+24800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+25000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+25800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+26000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+26800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+27000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+27800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+28000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+28800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+29000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+29800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,264, 98, 98, /* U+2A000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2A800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,265, 98, /* U+2B000 */
266, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2B800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2C000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,267, 98, 98, /* U+2C800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2D000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2D800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2E000 */
 98, 98, 98, 98, 98, 98, 98,268,142,142,142,142,142,142,142,142, /* U+2E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+2F000 */
 98, 98, 98, 98,269,142,142,142,142,142,142,142,142,142,142,142, /* U+2F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+30000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+30800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+31000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+31800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+32000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+32800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+33000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+33800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+34000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+34800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+35000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+35800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+36000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+36800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+37000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+37800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+38000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+38800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+39000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+39800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+3F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+40000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+40800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+41000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+41800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+42000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+42800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+43000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+43800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+44000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+44800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+45000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+45800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+46000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+46800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+47000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+47800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+48000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+48800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+49000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+49800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+4F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+50000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+50800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+51000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+51800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+52000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+52800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+53000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+53800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+54000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+54800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+55000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+55800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+56000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+56800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+57000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+57800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+58000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+58800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+59000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+59800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+5F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+60000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+60800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+61000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+61800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+62000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+62800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+63000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+63800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+64000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+64800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+65000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+65800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+66000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+66800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+67000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+67800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+68000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+68800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+69000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+69800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+6F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+70000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+70800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+71000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+71800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+72000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+72800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+73000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+73800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+74000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+74800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+75000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+75800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+76000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+76800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+77000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+77800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+78000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+78800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+79000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+79800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+7F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+80000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+80800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+81000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+81800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+82000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+82800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+83000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+83800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+84000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+84800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+85000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+85800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+86000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+86800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+87000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+87800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+88000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+88800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+89000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+89800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+8F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+90000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+90800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+91000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+91800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+92000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+92800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+93000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+93800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+94000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+94800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+95000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+95800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+96000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+96800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+97000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+97800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+98000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+98800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+99000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+99800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9A000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9A800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9B000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9B800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9C000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9C800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9D000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9D800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9E000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9E800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9F000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+9F800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A0000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+A9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AD000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AD800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+AF800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B0000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+B9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BD000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BD800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+BF800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C0000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+C9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CD000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CD800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+CF800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D0000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+D9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DD000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DD800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+DF800 */
270,271,272,273,271,271,271,271,271,271,271,271,271,271,271,271, /* U+E0000 */
271,271,271,271,271,271,271,271,271,271,271,271,271,271,271,271, /* U+E0800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E1000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E1800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E2000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E2800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E3000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E3800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E4000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E4800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E5000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E5800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E6000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E6800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E7000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E7800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E8000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E8800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E9000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+E9800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EA000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EA800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EB000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EB800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EC000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EC800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+ED000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+ED800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EE000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EE800 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EF000 */
142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142, /* U+EF800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F0000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F0800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F1000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F1800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F2000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F2800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F3000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F3800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F4000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F4800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F5000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F5800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F6000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F6800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F7000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F7800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F8000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F8800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F9000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+F9800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FA000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FA800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FB000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FB800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FC000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FC800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FD000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FD800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FE000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FE800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+FF000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,274, /* U+FF800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+100000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+100800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+101000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+101800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+102000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+102800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+103000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+103800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+104000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+104800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+105000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+105800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+106000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+106800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+107000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+107800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+108000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+108800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+109000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+109800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10A000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10A800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10B000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10B800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10C000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10C800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10D000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10D800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10E000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10E800 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126, /* U+10F000 */
126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,274, /* U+10F800 */
};

const uint16_t PRIV(ucd_stage2)[] = { /* 70400 bytes, block = 128 */
/* block 0 */
  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  1,  1,  3,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  4,  5,  5,  5,  6,  5,  5,  5,  7,  8,  5,  9,  5, 10,  5,  5,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  5,  5,  9,  9,  9,  5,
  5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 12,
 12, 12, 12, 14, 12, 12, 12, 12, 12, 12, 12,  7,  5,  8, 15, 16,
 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 17, 17, 17, 17,
 17, 17, 17, 19, 17, 17, 17, 17, 17, 17, 17,  7,  9,  8,  9,  1,

/* block 1 */
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  4,  5,  6,  6,  6,  6, 20,  5, 15, 21, 22, 23,  9, 24, 21, 15,
 20,  9, 25, 25, 15, 26,  5,  5, 15, 25, 22, 27, 25, 25, 25,  5,
 12, 12, 12, 12, 12, 28, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12,  9, 12, 12, 12, 12, 12, 12, 12, 29,
 17, 17, 17, 17, 17, 30, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17,  9, 17, 17, 17, 17, 17, 17, 17, 31,

/* block 2 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 34, 35, 32, 33, 32, 33, 32, 33, 35, 32, 33, 32, 33, 32, 33, 32,
 33, 32, 33, 32, 33, 32, 33, 32, 33, 35, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 36, 32, 33, 32, 33, 32, 33, 37,

/* block 3 */
 38, 39, 32, 33, 32, 33, 40, 32, 33, 41, 41, 32, 33, 35, 42, 43,
 44, 32, 33, 41, 45, 46, 47, 48, 32, 33, 49, 35, 47, 50, 51, 52,
 32, 33, 32, 33, 32, 33, 53, 32, 33, 53, 35, 35, 32, 33, 53, 32,
 33, 54, 54, 32, 33, 32, 33, 55, 32, 33, 35, 22, 32, 33, 35, 56,
 22, 22, 22, 22, 57, 58, 59, 60, 61, 62, 63, 64, 65, 32, 33, 32,
 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 66, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 35, 67, 68, 69, 32, 33, 70, 71, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 4 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 72, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 35, 35, 35, 35, 35, 35, 73, 32, 33, 74, 75, 76,
 76, 32, 33, 77, 78, 79, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 80, 81, 82, 83, 84, 35, 85, 85, 35, 86, 35, 87, 88, 35, 35, 35,
 85, 89, 35, 90, 35, 91, 92, 35, 93, 94, 92, 95, 96, 35, 35, 94,
 35, 97, 98, 35, 35, 99, 35, 35, 35, 35, 35, 35, 35,100, 35, 35,

/* block 5 */
101, 35,102,101, 35, 35, 35,103,101,104,105,105,106, 35, 35, 35,
 35, 35,107, 35, 22, 35, 35, 35, 35, 35, 35, 35, 35,108,109, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
110,110,110,110,110,110,110,110,110,111,111,111,111,111,111,111,
111,111, 15, 15, 15, 15,111,111,111,111,111,111,111,111,111,111,
111,111, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
110,110,110,110,110, 15, 15, 15, 15, 15,112,112,111, 15,111, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,

/* block 6 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,114,113,113,115,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,116,116,116,116,116,116,116,116,116,116,116,116,116,
117,118,117,118,111,119,117,118,120,120,121,122,122,122,  5,123,

/* block 7 */
120,120,120,120,119, 15,124,  5,125,125,125,120,126,120,127,127,
128,129,130,129,129,131,129,129,132,133,134,129,135,129,129,129,
136,137,120,138,129,129,139,129,129,140,129,129,141,142,142,142,
128,143,144,143,143,145,143,143,146,147,148,143,149,143,143,143,
150,151,152,153,143,143,154,143,143,155,143,143,156,157,157,158,
159,160,161,161,161,162,163,164,117,118,117,118,117,118,117,118,
117,118,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
167,168,169,170,171,172,173,117,118,174,117,118,128,175,175,175,

/* block 8 */
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
177,177,178,177,179,177,177,177,177,177,177,177,177,177,180,177,
177,181,182,177,177,177,177,177,177,177,183,177,177,177,177,177,
184,184,185,184,186,184,184,184,184,184,184,184,184,184,187,184,
184,188,189,184,184,184,184,184,184,184,190,184,184,184,184,184,
191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,
192,193,194,195,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,

/* block 9 */
192,193,196,197,198,199,199,198,200,200,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
201,192,193,192,193,192,193,192,193,192,193,192,193,192,193,202,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,

/* block 10 */
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
120,203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,
203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,
203,203,203,203,203,203,203,120,120,204,205,205,205,205,205,205,
206,207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,
207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,

/* block 11 */
207,207,207,207,207,207,207,206,206,208,209,120,120,210,210,211,
120,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,212,
212,212,212,212,212,212,212,212,212,212,212,212,212,212,213,212,
214,212,212,214,212,212,214,212,120,120,120,120,120,120,120,120,
215,215,215,215,215,215,215,215,215,215,215,215,215,215,215,215,
215,215,215,215,215,215,215,215,215,215,215,120,120,120,120,215,
215,215,215,214,214,120,120,120,120,120,120,120,120,120,120,120,

/* block 12 */
216,216,216,216,216,217,218,218,218,219,219,220,221,219,222,222,
223,223,223,223,223,223,223,223,223,223,223,221,224,120,219,221,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
226,225,225,225,225,225,225,225,225,225,225,227,227,227,227,227,
227,227,227,227,227,227,223,223,223,223,223,223,223,223,223,223,
228,228,228,228,228,228,228,228,228,228,219,219,219,219,225,225,
227,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 13 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,229,225,223,223,223,223,223,223,223,217,222,223,
223,223,223,223,223,230,230,223,223,222,223,223,223,223,225,225,
231,231,231,231,231,231,231,231,231,231,225,225,225,222,222,225,

/* block 14 */
232,232,232,232,232,232,232,232,232,232,232,232,232,232,120,233,
234,235,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,120,120,234,234,234,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 15 */
236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,
236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,
236,236,236,236,236,236,237,237,237,237,237,237,237,237,237,237,
237,236,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
238,238,238,238,238,238,238,238,238,238,239,239,239,239,239,239,
239,239,239,239,239,239,239,239,239,239,239,239,239,239,239,239,
239,239,239,239,239,239,239,239,239,239,239,240,240,240,240,240,
240,240,240,240,241,241,242,243,243,243,241,120,120,240,244,244,

/* block 16 */
245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
245,245,245,245,245,245,246,246,246,246,247,246,246,246,246,246,
246,246,246,246,247,246,246,246,247,246,246,246,246,246,120,120,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,120,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,250,250,250,120,120,251,120,
234,234,234,234,234,234,234,234,234,234,234,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 17 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,120,225,225,225,225,225,225,225,225,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,223,223,223,223,223,223,223,223,223,223,223,223,223,
223,223,217,223,223,223,223,223,223,223,223,223,223,223,223,223,
223,223,223,223,223,223,223,223,223,223,223,223,223,223,223,223,

/* block 18 */
252,252,252,253,254,254,254,254,254,254,254,254,254,254,254,254,
254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
254,254,254,254,254,254,254,254,254,254,252,253,252,254,253,253,
253,252,252,252,252,252,252,252,252,253,253,253,253,252,253,253,
254,255,256,113,113,252,252,252,254,254,254,254,254,254,254,254,
254,254,252,252,257,258,259,259,259,259,259,259,259,259,259,259,
260,261,254,254,254,254,254,254,254,254,254,254,254,254,254,254,

/* block 19 */
262,263,264,264,120,262,262,262,262,262,262,262,262,120,120,262,
262,120,120,262,262,262,262,262,262,262,262,262,262,262,262,262,
262,262,262,262,262,262,262,262,262,120,262,262,262,262,262,262,
262,120,262,120,120,120,262,262,262,262,120,120,263,262,265,264,
264,263,263,263,263,120,120,264,264,120,120,264,264,263,262,120,
120,120,120,120,120,120,120,265,120,120,120,120,262,262,120,262,
262,262,263,263,120,120,266,266,266,266,266,266,266,266,266,266,
262,262,267,267,268,268,268,268,268,268,269,267,262,270,263,120,

/* block 20 */
120,271,271,272,120,273,273,273,273,273,273,120,120,120,120,273,
273,120,120,273,273,273,273,273,273,273,273,273,273,273,273,273,
273,273,273,273,273,273,273,273,273,120,273,273,273,273,273,273,
273,120,273,273,120,273,273,120,273,273,120,120,271,120,272,272,
272,271,271,120,120,120,120,271,271,120,120,271,271,271,120,120,
120,271,120,120,120,120,120,120,120,273,273,273,273,120,273,120,
120,120,120,120,120,120,274,274,274,274,274,274,274,274,274,274,
271,271,273,273,273,271,275,120,120,120,120,120,120,120,120,120,

/* block 21 */
120,276,276,277,120,278,278,278,278,278,278,278,278,278,120,278,
278,278,120,278,278,278,278,278,278,278,278,278,278,278,278,278,
278,278,278,278,278,278,278,278,278,120,278,278,278,278,278,278,
278,120,278,278,120,278,278,278,278,278,120,120,276,278,277,277,
277,276,276,276,276,276,120,276,276,277,120,277,277,276,120,120,
278,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
278,278,276,276,120,120,279,279,279,279,279,279,279,279,279,279,
280,281,120,120,120,120,120,120,120,278,276,276,276,276,276,276,

/* block 22 */
120,282,283,283,120,284,284,284,284,284,284,284,284,120,120,284,
284,120,120,284,284,284,284,284,284,284,284,284,284,284,284,284,
284,284,284,284,284,284,284,284,284,120,284,284,284,284,284,284,
284,120,284,284,120,284,284,284,284,284,120,120,282,284,285,282,
283,282,282,282,282,120,120,283,283,120,120,283,283,282,120,120,
120,120,120,120,120,120,282,285,120,120,120,120,284,284,120,284,
284,284,282,282,120,120,286,286,286,286,286,286,286,286,286,286,
287,284,288,288,288,288,288,288,120,120,120,120,120,120,120,120,

/* block 23 */
120,120,289,290,120,290,290,290,290,290,290,120,120,120,290,290,
290,120,290,290,290,290,120,120,120,290,290,120,290,120,290,290,
120,120,120,290,290,120,120,120,290,290,290,120,120,120,290,290,
290,290,290,290,290,290,290,290,290,290,120,120,120,120,291,292,
289,292,292,120,120,120,292,292,292,120,292,292,292,289,120,120,
290,120,120,120,120,120,120,291,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,293,293,293,293,293,293,293,293,293,293,
294,294,294,295,296,296,296,296,296,297,296,120,120,120,120,120,

/* block 24 */
298,299,299,299,298,300,300,300,300,300,300,300,300,120,300,300,
300,120,300,300,300,300,300,300,300,300,300,300,300,300,300,300,
300,300,300,300,300,300,300,300,300,120,300,300,300,300,300,300,
300,300,300,300,300,300,300,300,300,300,120,120,120,300,298,298,
298,299,299,299,299,120,298,298,298,120,298,298,298,298,120,120,
120,120,120,120,120,298,298,120,300,300,300,120,120,120,120,120,
300,300,298,298,120,120,301,301,301,301,301,301,301,301,301,301,
120,120,120,120,120,120,120,302,303,303,303,303,303,303,303,304,

/* block 25 */
305,306,307,307,308,305,305,305,305,305,305,305,305,120,305,305,
305,120,305,305,305,305,305,305,305,305,305,305,305,305,305,305,
305,305,305,305,305,305,305,305,305,120,305,305,305,305,305,305,
305,305,305,305,120,305,305,305,305,305,120,120,306,305,307,306,
307,307,309,307,307,120,306,307,307,120,307,307,306,306,120,120,
120,120,120,120,120,309,309,120,120,120,120,120,120,120,305,120,
305,305,306,306,120,120,310,310,310,310,310,310,310,310,310,310,
120,305,305,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 26 */
311,311,312,312,120,313,313,313,313,313,313,313,313,120,313,313,
313,120,313,313,313,313,313,313,313,313,313,313,313,313,313,313,
313,313,313,313,313,313,313,313,313,313,313,313,313,313,313,313,
313,313,313,313,313,313,313,313,313,313,313,311,311,313,314,312,
312,311,311,311,311,120,312,312,312,120,312,312,312,311,315,316,
120,120,120,120,313,313,313,314,317,317,317,317,317,317,317,313,
313,313,311,311,120,120,318,318,318,318,318,318,318,318,318,318,
317,317,317,317,317,317,317,317,317,316,313,313,313,313,313,313,

/* block 27 */
120,120,319,319,120,320,320,320,320,320,320,320,320,320,320,320,
320,320,320,320,320,320,320,120,120,120,320,320,320,320,320,320,
320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,
320,320,120,320,320,320,320,320,320,320,320,320,120,320,120,120,
320,320,320,320,320,320,320,120,120,120,321,120,120,120,120,322,
319,319,321,321,321,120,321,120,319,319,319,319,319,319,319,322,
120,120,120,120,120,120,323,323,323,323,323,323,323,323,323,323,
120,120,319,319,324,120,120,120,120,120,120,120,120,120,120,120,

/* block 28 */
120,325,325,325,325,325,325,325,325,325,325,325,325,325,325,325,
325,325,325,325,325,325,325,325,325,325,325,325,325,325,325,325,
325,325,325,325,325,325,325,325,325,325,325,325,325,325,325,325,
325,326,325,327,326,326,326,326,326,326,326,120,120,120,120,  6,
325,325,325,325,325,325,328,326,326,326,326,326,326,326,326,329,
330,330,330,330,330,330,330,330,330,330,329,329,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 29 */
120,331,331,120,331,120,331,331,331,331,331,120,331,331,331,331,
331,331,331,331,331,331,331,331,331,331,331,331,331,331,331,331,
331,331,331,331,120,331,120,331,331,331,331,331,331,331,331,331,
331,332,331,333,332,332,332,332,332,332,332,332,332,331,120,120,
331,331,331,331,331,120,334,120,332,332,332,332,332,332,120,120,
335,335,335,335,335,335,335,335,335,335,120,120,331,331,331,331,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 30 */
336,337,337,337,338,338,338,338,338,338,338,338,338,338,338,338,
338,338,338,337,338,337,337,337,339,339,337,337,337,337,337,337,
340,340,340,340,340,340,340,340,340,340,341,341,341,341,341,341,
341,341,341,341,337,339,337,339,337,339,342,343,342,343,344,344,
336,336,336,336,336,336,336,336,120,336,336,336,336,336,336,336,
336,336,336,336,336,336,336,336,336,336,336,336,336,336,336,336,
336,336,336,336,336,336,336,336,336,336,336,336,336,120,120,120,
120,339,339,339,339,339,339,339,339,339,339,339,339,339,339,344,

/* block 31 */
339,339,339,339,339,338,339,339,336,336,336,336,336,339,339,339,
339,339,339,339,339,339,339,339,120,339,339,339,339,339,339,339,
339,339,339,339,339,339,339,339,339,339,339,339,339,339,339,339,
339,339,339,339,339,339,339,339,339,339,339,339,339,120,337,337,
337,337,337,337,337,337,339,337,337,337,337,337,337,120,337,337,
338,338,338,338,338, 20, 20, 20, 20,338,338,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 32 */
345,345,345,345,345,345,345,345,345,345,345,345,345,345,345,345,
345,345,345,345,345,345,345,345,345,345,345,345,345,345,345,345,
345,345,345,345,345,345,345,345,345,345,345,346,346,347,347,347,
347,348,347,347,347,347,347,347,346,347,347,348,348,347,347,345,
349,349,349,349,349,349,349,349,349,349,350,350,350,350,350,350,
345,345,345,345,345,345,348,348,347,347,345,345,345,345,347,347,
347,345,346,346,346,345,345,346,346,346,346,346,346,346,345,345,
345,347,347,347,347,345,345,345,345,345,345,345,345,345,345,345,

/* block 33 */
345,345,347,346,348,347,347,346,346,346,346,346,346,347,345,346,
351,351,351,351,351,351,351,351,351,351,346,346,346,347,352,352,
353,353,353,353,353,353,353,353,353,353,353,353,353,353,353,353,
353,353,353,353,353,353,353,353,353,353,353,353,353,353,353,353,
353,353,353,353,353,353,120,353,120,120,120,120,120,353,120,120,
354,354,354,354,354,354,354,354,354,354,354,354,354,354,354,354,
354,354,354,354,354,354,354,354,354,354,354,354,354,354,354,354,
354,354,354,354,354,354,354,354,354,354,354,355,356,354,354,354,

/* block 34 */
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,

/* block 35 */
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,

/* block 36 */
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,120,360,360,360,360,120,120,
360,360,360,360,360,360,360,120,360,120,360,360,360,360,120,120,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,

/* block 37 */
360,360,360,360,360,360,360,360,360,120,360,360,360,360,120,120,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,120,360,360,360,360,120,120,360,360,360,360,360,360,360,120,
360,120,360,360,360,360,120,120,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,120,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,

/* block 38 */
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,120,360,360,360,360,120,120,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,120,120,361,361,361,
362,362,362,362,362,362,362,362,362,363,363,363,363,363,363,363,
363,363,363,363,363,363,363,363,363,363,363,363,363,120,120,120,

/* block 39 */
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
364,364,364,364,364,364,364,364,364,364,120,120,120,120,120,120,
365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,
365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,
365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,
365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,
365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,365,
366,366,366,366,366,366,120,120,367,367,367,367,367,367,120,120,

/* block 40 */
368,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,

/* block 41 */
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,

/* block 42 */
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,370,371,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,

/* block 43 */
372,373,373,373,373,373,373,373,373,373,373,373,373,373,373,373,
373,373,373,373,373,373,373,373,373,373,373,374,375,120,120,120,
376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,
376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,
376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,
376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,
376,376,376,376,376,376,376,376,376,376,376,  5,  5,  5,377,377,
377,376,376,376,376,376,376,376,376,120,120,120,120,120,120,120,

/* block 44 */
378,378,378,378,378,378,378,378,378,378,378,378,378,120,378,378,
378,378,379,379,379,120,120,120,120,120,120,120,120,120,120,120,
380,380,380,380,380,380,380,380,380,380,380,380,380,380,380,380,
380,380,381,381,381,382,382,120,120,120,120,120,120,120,120,120,
383,383,383,383,383,383,383,383,383,383,383,383,383,383,383,383,
383,383,384,384,120,120,120,120,120,120,120,120,120,120,120,120,
385,385,385,385,385,385,385,385,385,385,385,385,385,120,385,385,
385,120,386,386,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 45 */
387,387,387,387,387,387,387,387,387,387,387,387,387,387,387,387,
387,387,387,387,387,387,387,387,387,387,387,387,387,387,387,387,
387,387,387,387,387,387,387,387,387,387,387,387,387,387,387,387,
387,387,387,387,388,388,389,388,388,388,388,388,388,388,389,389,
389,389,389,389,389,389,388,389,389,388,388,388,388,388,388,388,
388,388,388,388,390,390,390,391,390,390,390,392,387,388,120,120,
393,393,393,393,393,393,393,393,393,393,120,120,120,120,120,120,
394,394,394,394,394,394,394,394,394,394,120,120,120,120,120,120,

/* block 46 */
395,395,396,396,395,396,397,395,395,395,395,398,398,398,399,120,
400,400,400,400,400,400,400,400,400,400,120,120,120,120,120,120,
401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,
401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,
401,401,401,402,401,401,401,401,401,401,401,401,401,401,401,401,
401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,
401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,
401,401,401,401,401,401,401,401,401,120,120,120,120,120,120,120,

/* block 47 */
401,401,401,401,401,398,398,401,401,401,401,401,401,401,401,401,
401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,401,
401,401,401,401,401,401,401,401,401,398,401,120,120,120,120,120,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,369,
369,369,369,369,369,369,120,120,120,120,120,120,120,120,120,120,

/* block 48 */
403,403,403,403,403,403,403,403,403,403,403,403,403,403,403,403,
403,403,403,403,403,403,403,403,403,403,403,403,403,403,403,120,
404,404,404,405,405,405,405,404,404,405,405,405,120,120,120,120,
405,405,404,405,405,405,405,405,405,404,404,404,120,120,120,120,
406,120,120,120,407,407,408,408,408,408,408,408,408,408,408,408,
409,409,409,409,409,409,409,409,409,409,409,409,409,409,409,409,
409,409,409,409,409,409,409,409,409,409,409,409,409,409,120,120,
409,409,409,409,409,120,120,120,120,120,120,120,120,120,120,120,

/* block 49 */
410,410,410,410,410,410,410,410,410,410,410,410,410,410,410,410,
410,410,410,410,410,410,410,410,410,410,410,410,410,410,410,410,
410,410,410,410,410,410,410,410,410,410,410,410,120,120,120,120,
410,410,410,410,410,410,410,410,410,410,410,410,410,410,410,410,
410,410,410,410,410,410,410,410,410,410,120,120,120,120,120,120,
411,411,411,411,411,411,411,411,411,411,412,120,120,120,413,413,
414,414,414,414,414,414,414,414,414,414,414,414,414,414,414,414,
414,414,414,414,414,414,414,414,414,414,414,414,414,414,414,414,

/* block 50 */
415,415,415,415,415,415,415,415,415,415,415,415,415,415,415,415,
415,415,415,415,415,415,415,416,416,417,417,416,120,120,418,418,
419,419,419,419,419,419,419,419,419,419,419,419,419,419,419,419,
419,419,419,419,419,419,419,419,419,419,419,419,419,419,419,419,
419,419,419,419,419,419,419,419,419,419,419,419,419,419,419,419,
419,419,419,419,419,420,421,420,421,421,421,421,421,421,421,120,
421,422,421,422,422,421,421,421,421,421,421,421,421,420,420,420,
420,420,420,421,421,421,421,421,421,421,421,421,421,120,120,421,

/* block 51 */
423,423,423,423,423,423,423,423,423,423,120,120,120,120,120,120,
423,423,423,423,423,423,423,423,423,423,120,120,120,120,120,120,
424,424,424,424,424,424,424,425,424,424,424,424,424,424,120,120,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,426,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 52 */
427,427,427,427,428,429,429,429,429,429,429,429,429,429,429,429,
429,429,429,429,429,429,429,429,429,429,429,429,429,429,429,429,
429,429,429,429,429,429,429,429,429,429,429,429,429,429,429,429,
429,429,429,429,427,430,427,427,427,427,427,428,427,428,428,428,
428,428,427,428,428,429,429,429,429,429,429,429,120,120,120,120,
431,431,431,431,431,431,431,431,431,431,432,432,432,432,432,432,
432,433,433,433,433,433,433,433,433,433,433,427,427,427,427,427,
427,427,427,427,433,433,433,433,433,433,433,433,433,120,120,120,

/* block 53 */
434,434,435,436,436,436,436,436,436,436,436,436,436,436,436,436,
436,436,436,436,436,436,436,436,436,436,436,436,436,436,436,436,
436,435,434,434,434,434,435,435,434,434,435,434,434,434,436,436,
437,437,437,437,437,437,437,437,437,437,436,436,436,436,436,436,
438,438,438,438,438,438,438,438,438,438,438,438,438,438,438,438,
438,438,438,438,438,438,438,438,438,438,438,438,438,438,438,438,
438,438,438,438,438,438,439,440,439,439,440,440,440,439,440,439,
439,439,440,440,120,120,120,120,120,120,120,120,441,441,441,441,

/* block 54 */
442,442,442,442,442,442,442,442,442,442,442,442,442,442,442,442,
442,442,442,442,442,442,442,442,442,442,442,442,442,442,442,442,
442,442,442,442,443,443,443,443,443,443,443,443,444,444,444,444,
444,444,444,444,443,443,444,444,120,120,120,445,445,445,445,445,
446,446,446,446,446,446,446,446,446,446,120,120,120,442,442,442,
447,447,447,447,447,447,447,447,447,447,448,448,448,448,448,448,
448,448,448,448,448,448,448,448,448,448,448,448,448,448,448,448,
448,448,448,448,448,448,448,448,449,449,449,449,449,449,450,450,

/* block 55 */
451,452,453,454,455,456,457,458,459,120,120,120,120,120,120,120,
460,460,460,460,460,460,460,460,460,460,460,460,460,460,460,460,
460,460,460,460,460,460,460,460,460,460,460,460,460,460,460,460,
460,460,460,460,460,460,460,460,460,460,460,120,120,460,460,460,
461,461,461,461,461,461,461,461,120,120,120,120,120,120,120,120,
462,463,462,464,463,465,465,466,465,466,467,463,466,466,463,463,
466,468,463,463,463,463,463,463,463,469,470,471,471,465,471,471,
471,471,472,473,474,470,470,475,476,476,477,120,120,120,120,120,

/* block 56 */
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35,128,128,128,128,128,478,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,121,121,121,
121,121,110,110,110,110,121,121,121,121,121, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35,479,480, 35, 35, 35,481, 35, 35,

/* block 57 */
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,482, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,121,
114,114,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,120,113,113,113,113,113,

/* block 58 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
483,484, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 59 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 35, 35, 35, 35, 35,485, 35, 35,486, 35,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 60 */
487,487,487,487,487,487,487,487,488,488,488,488,488,488,488,488,
487,487,487,487,487,487,120,120,488,488,488,488,488,488,120,120,
487,487,487,487,487,487,487,487,488,488,488,488,488,488,488,488,
487,487,487,487,487,487,487,487,488,488,488,488,488,488,488,488,
487,487,487,487,487,487,120,120,488,488,488,488,488,488,120,120,
128,487,128,487,128,487,128,487,120,488,120,488,120,488,120,488,
487,487,487,487,487,487,487,487,488,488,488,488,488,488,488,488,
489,489,490,490,490,490,491,491,492,492,493,493,494,494,120,120,

/* block 61 */
487,487,487,487,487,487,487,487,495,495,495,495,495,495,495,495,
487,487,487,487,487,487,487,487,495,495,495,495,495,495,495,495,
487,487,487,487,487,487,487,487,495,495,495,495,495,495,495,495,
487,487,128,496,128,120,128,128,488,488,497,497,498,119,499,119,
119,119,128,496,128,120,128,128,500,500,500,500,498,119,119,119,
487,487,128,128,120,120,128,128,488,488,501,501,120,119,119,119,
487,487,128,128,128,169,128,128,488,488,502,502,174,119,119,119,
120,120,128,496,128,120,128,128,503,503,504,504,498,119,119,120,

/* block 62 */
  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4, 24,505,506, 24, 24,
 10, 10, 10, 10, 10, 10,  5,  5, 23, 27,  7, 23, 23, 27,  7, 23,
  5,  5,  5,  5,  5,  5,  5,  5,507,508, 24, 24, 24, 24, 24,509,
  5,  5,  5,  5,  5,  5,  5,  5,  5, 23, 27,  5,510,  5,  5, 16,
 16,  5,  5,  5,  9,  7,  8,  5,  5,510,  5,  5,  5,  5,  5,  5,
  5,  5,  9,  5, 16,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  4,
 24, 24, 24, 24, 24,511, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 25,110,120,120, 25, 25, 25, 25, 25, 25,  9,  9,  9,  7,  8,110,

/* block 63 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,  9,  9,  9,  7,  8,120,
110,110,110,110,110,110,110,110,110,110,110,110,110,120,120,120,
  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
113,113,113,113,113,113,113,113,113,113,113,113,113,426,426,426,
426,113,426,426,426,113,113,113,113,113,113,113,113,113,113,113,
512,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 64 */
 20, 20,513, 20, 20, 20, 20,513, 20, 20,514,513,513,513,514,514,
513,513,513,514, 20,513, 20, 20,  9,513,513,513,513,513, 20, 20,
 20, 20, 21, 20,513, 20,515, 20,513, 20,516,517,513,513, 20,514,
513,513,518,513,514,519,519,519,519,520, 20, 20,514,514,513,513,
  9,  9,  9,  9,  9,513,514,514,514,514, 20,  9, 20, 20,521, 20,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,
523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,

/* block 65 */
524,524,524, 32, 33,524,524,524,524, 25, 20, 20,120,120,120,120,
  9,  9,  9,  9,525, 21, 21, 21, 21, 21,  9,  9, 20, 20, 20, 20,
  9, 20, 20,  9, 20, 20,  9, 20, 20, 21, 21, 20, 20, 20,  9, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,
 20, 20,  9, 20,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 66 */
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 67 */
 20, 20, 20, 20, 20, 20, 20, 20,  7,  8,  7,  8, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20, 20,
  9,  9, 20, 20, 20, 20, 20, 20, 21,  7,  8, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9, 20, 20, 20,

/* block 68 */
 20, 20, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,  9,
  9,  9, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 20, 20, 20, 20, 21, 21, 21, 20, 20, 20, 20, 20,

/* block 69 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 70 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,526,526,526,526,526,526,526,526,526,526,
526,526,527,526,526,526,526,526,526,526,526,526,526,526,526,526,
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,
528,528,528,528,528,528,528,528,528,528, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 71 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 72 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 21,  9, 20, 20, 20, 20, 20, 20, 20, 20,
 21,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,525,525,525,525,  9,

/* block 73 */
 21, 21, 21, 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,525,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 74 */
 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 75 */
 21, 21, 21, 21, 21, 21, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 20, 21, 20, 21, 20, 20, 20, 20, 20, 20, 21, 20, 20,
 20, 21, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 21, 20, 20, 21, 20, 20, 20, 20, 21, 20, 21, 20,
 20, 20, 20, 21, 21, 21, 20, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 21, 21, 21, 21, 21,  7,  8,  7,  8,  7,  8,  7,  8,
  7,  8,  7,  8,  7,  8, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 76 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 20, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
  9,  9,  9,  9,  9,  7,  8,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 77 */
529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,
529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,
529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,
529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,
529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,
529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,
529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,
529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,529,

/* block 78 */
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,525,525,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 79 */
  9,  9,  9,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,
  8,  7,  8,  7,  8,  7,  8,  7,  8,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  7,  8,  7,  8,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  7,  8,  9,  9,

/* block 80 */
 20, 20, 20, 20, 20, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9, 20, 20,  9,  9,  9,  9,  9,  9, 20, 20, 20,
 21, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,120,120, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 81 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,120,120, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 82 */
530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,
530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,
530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,120,
531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,
531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,
531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,120,
 32, 33,532,533,534,535,536, 32, 33, 32, 33, 32, 33,537,538,539,
540, 35, 32, 33, 35, 32, 33, 35, 35, 35, 35, 35,110,110,541,541,

/* block 83 */
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,542,543,543,543,543,543,543,165,166,165,166,544,
544,544,165,166,120,120,120,120,120,545,545,545,545,546,545,545,

/* block 84 */
547,547,547,547,547,547,547,547,547,547,547,547,547,547,547,547,
547,547,547,547,547,547,547,547,547,547,547,547,547,547,547,547,
547,547,547,547,547,547,120,547,120,120,120,120,120,547,120,120,
548,548,548,548,548,548,548,548,548,548,548,548,548,548,548,548,
548,548,548,548,548,548,548,548,548,548,548,548,548,548,548,548,
548,548,548,548,548,548,548,548,548,548,548,548,548,548,548,548,
548,548,548,548,548,548,548,548,120,120,120,120,120,120,120,549,
550,120,120,120,120,120,120,120,120,120,120,120,120,120,120,551,

/* block 85 */
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,120,120,120,120,120,120,120,120,120,
360,360,360,360,360,360,360,120,360,360,360,360,360,360,360,120,
360,360,360,360,360,360,360,120,360,360,360,360,360,360,360,120,
360,360,360,360,360,360,360,120,360,360,360,360,360,360,360,120,
360,360,360,360,360,360,360,120,360,360,360,360,360,360,360,120,
552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,
552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,

/* block 86 */
  5,  5, 23, 27, 23, 27,  5,  5,  5, 23, 27,  5, 23, 27,  5,  5,
  5,  5,  5,  5,  5,  5,  5, 10,  5,  5, 10,  5, 23, 27,  5,  5,
 23, 27,  7,  8,  7,  8,  7,  8,  7,  8,  5,  5,  5,  5,  5,111,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 10, 10,  5,  5,  5,  5,
 10,  5,  7,553,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 87 */
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,120,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 88 */
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,

/* block 89 */
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,554,
554,554,554,554,554,554,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,120,

/* block 90 */
  4,555,555,556, 20,557,558,559,560,561,560,561,560,561,560,561,
560,561, 20,562,560,561,560,561,560,561,560,561,563,564,565,565,
 20,559,559,559,559,559,559,559,559,559,566,566,566,566,567,567,
568,569,569,569,569,569, 20,562,559,559,559,557,570,571,572,572,
120,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,

/* block 91 */
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,120,120,574,574,575,575,576,576,573,
577,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,555,569,579,579,578,

/* block 92 */
120,120,120,120,120,580,580,580,580,580,580,580,580,580,580,580,
580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,
580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,
120,581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,

/* block 93 */
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,120,
572,572,582,582,582,582,572,572,572,572,572,572,572,572,572,572,
580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,580,
580,580,580,580,580,580,580,580,580,580,580,120,120,120,120,120,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,120,120,120,120,120,120,120,120,120,120,120,120,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,

/* block 94 */
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,120,
582,582,582,582,582,582,582,582,582,582,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572, 25, 25, 25, 25, 25, 25, 25, 25,
 20, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583, 20,

/* block 95 */
582,582,582,582,582,582,582,582,582,582,572,572,572,572,572,572,
572,572,572,572,572,572,572,584,572,584,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
572,572,572,572,572,572,572,572,572,572,572,572, 20, 20, 20, 20,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,572,

/* block 96 */
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,572,572,572,572,572,

/* block 97 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,572,
572,572,572,572,572,572,572,572,572,572,572,572,572,572,572, 20,

/* block 98 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,

/* block 99 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,120,120,120,120,120,120,120,120,120,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 100 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 101 */
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,588,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,

/* block 102 */
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,

/* block 103 */
587,587,587,587,587,587,587,587,587,587,587,587,587,120,120,120,
589,589,589,589,589,589,589,589,589,589,589,589,589,589,589,589,
589,589,589,589,589,589,589,589,589,589,589,589,589,589,589,589,
589,589,589,589,589,589,589,589,589,589,589,589,589,589,589,589,
589,589,589,589,589,589,589,120,120,120,120,120,120,120,120,120,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,591,591,591,591,591,591,592,592,

/* block 104 */
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,

/* block 105 */
593,593,593,593,593,593,593,593,593,593,593,593,594,595,595,595,
593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,593,
596,596,596,596,596,596,596,596,596,596,593,593,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
192,193,192,193,192,193,192,193,192,193,597,598,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,599,198,
200,200,200,600,552,552,552,552,552,552,552,552,552,552,600,479,

/* block 106 */
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,479,479,552,552,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,602,602,602,602,602,602,602,602,602,602,
603,603,604,604,604,604,604,604,120,120,120,120,120,120,120,120,

/* block 107 */
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15,111,111,111,111,111,111,111,111,111,
 15, 15, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 35, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
110, 35, 35, 35, 35, 35, 35, 35, 35, 32, 33, 32, 33,605, 32, 33,

/* block 108 */
 32, 33, 32, 33, 32, 33, 32, 33,111, 15, 15, 32, 33,606, 35, 22,
 32, 33, 32, 33,607, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,608,609,610,611,608, 35,
612,613,614,615, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
120,120, 32, 33,616,617,618,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120, 22,110,110, 35, 22, 22, 22, 22, 22,

/* block 109 */
619,619,620,619,619,619,620,619,619,619,619,620,619,619,619,619,
619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,
619,619,619,621,621,620,620,621,622,622,622,622,120,120,120,120,
623,623,623,624,624,624,625,625,626,625,120,120,120,120,120,120,
627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,
627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,
627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,
627,627,627,627,628,628,628,628,120,120,120,120,120,120,120,120,

/* block 110 */
629,629,630,630,630,630,630,630,630,630,630,630,630,630,630,630,
630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,
630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,
630,630,630,630,629,629,629,629,629,629,629,629,629,629,629,629,
629,629,629,629,631,631,120,120,120,120,120,120,120,120,632,632,
633,633,633,633,633,633,633,633,633,633,120,120,120,120,120,120,
252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,634,254,635,254,254,254,254,260,260,260,254,260,254,254,252,

/* block 111 */
636,636,636,636,636,636,636,636,636,636,637,637,637,637,637,637,
637,637,637,637,637,637,637,637,637,637,637,637,637,637,637,637,
637,637,637,637,637,637,638,638,638,638,638,638,638,638,639,640,
641,641,641,641,641,641,641,641,641,641,641,641,641,641,641,641,
641,641,641,641,641,641,641,642,642,642,642,642,642,642,642,642,
642,642,643,643,120,120,120,120,120,120,120,120,120,120,120,644,
357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,357,
357,357,357,357,357,357,357,357,357,357,357,357,357,120,120,120,

/* block 112 */
645,645,645,646,647,647,647,647,647,647,647,647,647,647,647,647,
647,647,647,647,647,647,647,647,647,647,647,647,647,647,647,647,
647,647,647,647,647,647,647,647,647,647,647,647,647,647,647,647,
647,647,647,645,646,646,645,645,645,645,646,646,645,645,646,646,
646,648,648,648,648,648,648,648,648,648,648,648,648,648,120,649,
650,650,650,650,650,650,650,650,650,650,120,120,120,120,648,648,
345,345,345,345,345,347,651,345,345,345,345,345,345,345,345,345,
351,351,351,351,351,351,351,351,351,351,345,345,345,345,345,120,

/* block 113 */
652,652,652,652,652,652,652,652,652,652,652,652,652,652,652,652,
652,652,652,652,652,652,652,652,652,652,652,652,652,652,652,652,
652,652,652,652,652,652,652,652,652,653,653,653,653,653,653,654,
654,653,653,654,654,653,653,120,120,120,120,120,120,120,120,120,
652,652,652,653,652,652,652,652,652,652,652,652,653,654,120,120,
655,655,655,655,655,655,655,655,655,655,120,120,656,656,656,656,
345,345,345,345,345,345,345,345,345,345,345,345,345,345,345,345,
651,345,345,345,345,345,345,352,352,352,345,346,347,346,345,345,

/* block 114 */
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
658,657,658,658,658,657,657,658,658,657,657,657,657,657,658,658,
657,658,657,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,657,657,659,660,660,
661,661,661,661,661,661,661,661,661,661,661,662,663,663,662,662,
664,664,661,665,665,662,663,120,120,120,120,120,120,120,120,120,

/* block 115 */
120,360,360,360,360,360,360,120,120,360,360,360,360,360,360,120,
120,360,360,360,360,360,360,120,120,120,120,120,120,120,120,120,
360,360,360,360,360,360,360,120,360,360,360,360,360,360,360,120,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35,666, 35, 35, 35, 35, 35, 35, 35, 15,110,110,110,110,
 35, 35, 35, 35, 35,128, 35, 35,120,120,120,120,120,120,120,120,
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,

/* block 116 */
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,
661,661,661,661,661,661,661,661,661,661,661,661,661,661,661,661,
661,661,661,661,661,661,661,661,661,661,661,661,661,661,661,661,
661,661,661,662,662,663,662,662,663,662,662,664,662,663,120,120,
668,668,668,668,668,668,668,668,668,668,120,120,120,120,120,120,

/* block 117 */
669,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,669,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,669,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
669,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,

/* block 118 */
670,670,670,670,670,670,670,670,670,670,670,670,669,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,669,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
669,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,669,670,670,670,

/* block 119 */
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,669,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
669,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,669,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,

/* block 120 */
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,669,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
669,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,669,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,

/* block 121 */
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,669,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
669,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,669,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,

/* block 122 */
670,670,670,670,669,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
669,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,669,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,669,670,670,670,670,670,670,670,670,670,670,670,

/* block 123 */
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
669,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,669,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,669,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,

/* block 124 */
670,670,670,670,670,670,670,670,669,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,120,120,120,120,120,120,120,120,120,120,120,120,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,120,120,120,120,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,120,120,120,120,

/* block 125 */
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,
671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,671,

/* block 126 */
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,

/* block 127 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,120,120,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,

/* block 128 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 129 */
 35, 35, 35, 35, 35, 35, 35,120,120,120,120,120,120,120,120,120,
120,120,120,206,206,206,206,206,120,120,120,120,120,215,212,215,
215,215,215,215,215,215,215,215,215,673,215,215,215,215,215,215,
215,215,215,215,215,215,215,120,215,215,215,215,215,120,215,120,
215,215,120,215,215,120,215,215,215,215,215,215,215,215,215,215,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 130 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,674,674,674,674,674,674,674,674,674,674,674,674,674,674,
674,674,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 131 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 132 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,  8,  7,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 133 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
120,120,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
225,225,675,225,225,225,225,225,225,225,225,225,220,676,120,120,

/* block 134 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
  5,  5,  5,  5,  5,  5,  5,  7,  8,  5,120,120,120,120,120,120,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,552,552,
  5, 10, 10, 16, 16,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,
  8,  7,  8,  7,  8,556,556,  7,  8,  5,  5,  5,  5, 16, 16, 16,
  5,  5,  5,120,  5,  5,  5,  5, 10,  7,  8,  7,  8,  7,  8,  5,
  5,  5,  9, 10,  9,  9,  9,120,  5,  6,  5,  5,120,120,120,120,
225,225,225,225,225,120,225,225,225,225,225,225,225,225,225,225,

/* block 135 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,120,120, 24,

/* block 136 */
120,  5,  5,  5,  6,  5,  5,  5,  7,  8,  5,  9,  5, 10,  5,  5,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  5,  5,  9,  9,  9,  5,
  5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  7,  5,  8, 15, 16,
 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,  7,  9,  8,  9,  7,
  8,555,560,561,555,555,578,578,578,578,578,578,578,578,578,578,
569,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,

/* block 137 */
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,677,677,
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,
581,581,581,581,581,581,581,581,581,581,581,581,581,581,581,120,
120,120,581,581,581,581,581,581,120,120,581,581,581,581,581,581,
120,120,581,581,581,581,581,581,120,120,581,581,581,120,120,120,
  6,  6,  9, 15, 20,  6,  6,120, 20,  9,  9,  9,  9, 20, 20,120,
511,511,511,511,511,511,511,511,511, 24, 24, 24, 20, 20,120,120,

/* block 138 */
678,678,678,678,678,678,678,678,678,678,678,678,120,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,120,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,120,678,678,120,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,120,120,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 139 */
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,120,120,120,120,120,

/* block 140 */
679,679,679,120,120,120,120,680,680,680,680,680,680,680,680,680,
680,680,680,680,680,680,680,680,680,680,680,680,680,680,680,680,
680,680,680,680,680,680,680,680,680,680,680,680,680,680,680,680,
680,680,680,680,120,120,120,681,681,681,681,681,681,681,681,681,
682,682,682,682,682,682,682,682,682,682,682,682,682,682,682,682,
682,682,682,682,682,682,682,682,682,682,682,682,682,682,682,682,
682,682,682,682,682,682,682,682,682,682,682,682,682,682,682,682,
682,682,682,682,682,683,683,683,683,684,684,684,684,684,684,684,

/* block 141 */
684,684,684,684,684,684,684,684,684,684,683,683,684,684,684,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,120,
684,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,113,120,120,

/* block 142 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 143 */
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,120,120,120,
686,686,686,686,686,686,686,686,686,686,686,686,686,686,686,686,
686,686,686,686,686,686,686,686,686,686,686,686,686,686,686,686,
686,686,686,686,686,686,686,686,686,686,686,686,686,686,686,686,
686,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
687,688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,
688,688,688,688,688,688,688,688,688,688,688,688,120,120,120,120,

/* block 144 */
689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,
689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,689,
690,690,690,690,120,120,120,120,120,120,120,120,120,689,689,689,
691,691,691,691,691,691,691,691,691,691,691,691,691,691,691,691,
691,692,691,691,691,691,691,691,691,691,692,120,120,120,120,120,
693,693,693,693,693,693,693,693,693,693,693,693,693,693,693,693,
693,693,693,693,693,693,693,693,693,693,693,693,693,693,693,693,
693,693,693,693,693,693,694,694,694,694,694,120,120,120,120,120,

/* block 145 */
695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,
695,695,695,695,695,695,695,695,695,695,695,695,695,695,120,696,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,120,120,120,120,697,697,697,697,697,697,697,697,
698,699,699,699,699,699,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 146 */
700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,
700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,
700,700,700,700,700,700,700,700,701,701,701,701,701,701,701,701,
701,701,701,701,701,701,701,701,701,701,701,701,701,701,701,701,
701,701,701,701,701,701,701,701,701,701,701,701,701,701,701,701,
702,702,702,702,702,702,702,702,702,702,702,702,702,702,702,702,
702,702,702,702,702,702,702,702,702,702,702,702,702,702,702,702,
702,702,702,702,702,702,702,702,702,702,702,702,702,702,702,702,

/* block 147 */
703,703,703,703,703,703,703,703,703,703,703,703,703,703,703,703,
703,703,703,703,703,703,703,703,703,703,703,703,703,703,120,120,
704,704,704,704,704,704,704,704,704,704,120,120,120,120,120,120,
705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,
705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,
705,705,705,705,120,120,120,120,706,706,706,706,706,706,706,706,
706,706,706,706,706,706,706,706,706,706,706,706,706,706,706,706,
706,706,706,706,706,706,706,706,706,706,706,706,120,120,120,120,

/* block 148 */
707,707,707,707,707,707,707,707,707,707,707,707,707,707,707,707,
707,707,707,707,707,707,707,707,707,707,707,707,707,707,707,707,
707,707,707,707,707,707,707,707,120,120,120,120,120,120,120,120,
708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,
708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,
708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,
708,708,708,708,120,120,120,120,120,120,120,120,120,120,120,709,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 149 */
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,

/* block 150 */
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,120,120,120,120,120,120,120,120,120,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,120,120,120,120,120,120,120,120,120,120,
710,710,710,710,710,710,710,710,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 151 */
711,711,711,711,711,711,120,120,711,120,711,711,711,711,711,711,
711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,
711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,
711,711,711,711,711,711,120,711,711,120,120,120,711,120,120,711,
712,712,712,712,712,712,712,712,712,712,712,712,712,712,712,712,
712,712,712,712,712,712,120,713,714,714,714,714,714,714,714,714,
715,715,715,715,715,715,715,715,715,715,715,715,715,715,715,715,
715,715,715,715,715,715,715,716,716,717,717,717,717,717,717,717,

/* block 152 */
718,718,718,718,718,718,718,718,718,718,718,718,718,718,718,718,
718,718,718,718,718,718,718,718,718,718,718,718,718,718,718,120,
120,120,120,120,120,120,120,719,719,719,719,719,719,719,719,719,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,120,720,720,120,120,120,120,120,721,721,721,721,721,

/* block 153 */
722,722,722,722,722,722,722,722,722,722,722,722,722,722,722,722,
722,722,722,722,722,722,723,723,723,723,723,723,120,120,120,724,
725,725,725,725,725,725,725,725,725,725,725,725,725,725,725,725,
725,725,725,725,725,725,725,725,725,725,120,120,120,120,120,726,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 154 */
727,727,727,727,727,727,727,727,727,727,727,727,727,727,727,727,
727,727,727,727,727,727,727,727,727,727,727,727,727,727,727,727,
728,728,728,728,728,728,728,728,728,728,728,728,728,728,728,728,
728,728,728,728,728,728,728,728,120,120,120,120,729,729,728,728,
729,729,729,729,729,729,729,729,729,729,729,729,729,729,729,729,
120,120,729,729,729,729,729,729,729,729,729,729,729,729,729,729,
729,729,729,729,729,729,729,729,729,729,729,729,729,729,729,729,
729,729,729,729,729,729,729,729,729,729,729,729,729,729,729,729,

/* block 155 */
730,731,731,731,120,731,731,120,120,120,120,120,731,731,731,731,
730,730,730,730,120,730,730,730,120,730,730,730,730,730,730,730,
730,730,730,730,730,730,730,730,730,730,730,730,730,730,730,730,
730,730,730,730,730,730,120,120,731,731,731,120,120,120,120,731,
732,732,732,732,732,732,732,732,732,120,120,120,120,120,120,120,
733,733,733,733,733,733,733,733,733,120,120,120,120,120,120,120,
734,734,734,734,734,734,734,734,734,734,734,734,734,734,734,734,
734,734,734,734,734,734,734,734,734,734,734,734,734,735,735,736,

/* block 156 */
737,737,737,737,737,737,737,737,737,737,737,737,737,737,737,737,
737,737,737,737,737,737,737,737,737,737,737,737,737,738,738,738,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
739,739,739,739,739,739,739,739,740,739,739,739,739,739,739,739,
739,739,739,739,739,739,739,739,739,739,739,739,739,739,739,739,
739,739,739,739,739,741,741,120,120,120,120,742,742,742,742,742,
743,743,743,743,743,743,743,120,120,120,120,120,120,120,120,120,

/* block 157 */
744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,
744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,
744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,
744,744,744,744,744,744,120,120,120,745,745,745,745,745,745,745,
746,746,746,746,746,746,746,746,746,746,746,746,746,746,746,746,
746,746,746,746,746,746,120,120,747,747,747,747,747,747,747,747,
748,748,748,748,748,748,748,748,748,748,748,748,748,748,748,748,
748,748,748,120,120,120,120,120,749,749,749,749,749,749,749,749,

/* block 158 */
750,750,750,750,750,750,750,750,750,750,750,750,750,750,750,750,
750,750,120,120,120,120,120,120,120,751,751,751,751,120,120,120,
120,120,120,120,120,120,120,120,120,752,752,752,752,752,752,752,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 159 */
753,753,753,753,753,753,753,753,753,753,753,753,753,753,753,753,
753,753,753,753,753,753,753,753,753,753,753,753,753,753,753,753,
753,753,753,753,753,753,753,753,753,753,753,753,753,753,753,753,
753,753,753,753,753,753,753,753,753,753,753,753,753,753,753,753,
753,753,753,753,753,753,753,753,753,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 160 */
754,754,754,754,754,754,754,754,754,754,754,754,754,754,754,754,
754,754,754,754,754,754,754,754,754,754,754,754,754,754,754,754,
754,754,754,754,754,754,754,754,754,754,754,754,754,754,754,754,
754,754,754,120,120,120,120,120,120,120,120,120,120,120,120,120,
755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,
755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,
755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,
755,755,755,120,120,120,120,120,120,120,756,756,756,756,756,756,

/* block 161 */
757,757,757,757,757,757,757,757,757,757,757,757,757,757,757,757,
757,757,757,757,757,757,757,757,757,757,757,757,757,757,757,757,
757,757,757,757,758,758,758,758,120,120,120,120,120,120,120,120,
759,759,759,759,759,759,759,759,759,759,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 162 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
760,760,760,760,760,760,760,760,760,760,760,760,760,760,760,760,
760,760,760,760,760,760,760,760,760,760,760,760,760,760,760,120,

/* block 163 */
761,761,761,761,761,761,761,761,761,761,761,761,761,761,761,761,
761,761,761,761,761,761,761,761,761,761,761,761,761,762,762,762,
762,762,762,762,762,762,762,761,120,120,120,120,120,120,120,120,
763,763,763,763,763,763,763,763,763,763,763,763,763,763,763,763,
763,763,763,763,763,763,764,764,764,764,764,764,764,764,764,764,
764,765,765,765,765,766,766,766,766,766,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 164 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
767,767,767,767,767,767,767,767,767,767,767,767,767,767,767,767,
767,767,767,767,767,767,767,120,120,120,120,120,120,120,120,120,

/* block 165 */
768,769,768,770,770,770,770,770,770,770,770,770,770,770,770,770,
770,770,770,770,770,770,770,770,770,770,770,770,770,770,770,770,
770,770,770,770,770,770,770,770,770,770,770,770,770,770,770,770,
770,770,770,770,770,770,770,770,769,769,769,769,769,769,769,769,
769,769,769,769,769,769,769,771,771,771,771,771,771,771,120,120,
120,120,772,772,772,772,772,772,772,772,772,772,772,772,772,772,
772,772,772,772,772,772,773,773,773,773,773,773,773,773,773,773,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,769,

/* block 166 */
774,774,775,776,776,776,776,776,776,776,776,776,776,776,776,776,
776,776,776,776,776,776,776,776,776,776,776,776,776,776,776,776,
776,776,776,776,776,776,776,776,776,776,776,776,776,776,776,776,
775,775,775,774,774,774,774,775,775,774,774,777,777,778,777,777,
777,777,120,120,120,120,120,120,120,120,120,120,120,778,120,120,
779,779,779,779,779,779,779,779,779,779,779,779,779,779,779,779,
779,779,779,779,779,779,779,779,779,120,120,120,120,120,120,120,
780,780,780,780,780,780,780,780,780,780,120,120,120,120,120,120,

/* block 167 */
781,781,781,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,781,781,781,781,781,783,781,781,781,
781,781,781,781,781,120,784,784,784,784,784,784,784,784,784,784,
785,785,785,785,782,783,783,120,120,120,120,120,120,120,120,120,
786,786,786,786,786,786,786,786,786,786,786,786,786,786,786,786,
786,786,786,786,786,786,786,786,786,786,786,786,786,786,786,786,
786,786,786,787,788,788,786,120,120,120,120,120,120,120,120,120,

/* block 168 */
789,789,790,791,791,791,791,791,791,791,791,791,791,791,791,791,
791,791,791,791,791,791,791,791,791,791,791,791,791,791,791,791,
791,791,791,791,791,791,791,791,791,791,791,791,791,791,791,791,
791,791,791,790,790,790,789,789,789,789,789,789,789,789,789,790,
790,791,792,792,791,793,793,793,793,789,789,789,789,793,120,120,
794,794,794,794,794,794,794,794,794,794,791,793,791,793,793,793,
120,795,795,795,795,795,795,795,795,795,795,795,795,795,795,795,
795,795,795,795,795,120,120,120,120,120,120,120,120,120,120,120,

/* block 169 */
796,796,796,796,796,796,796,796,796,796,796,796,796,796,796,796,
796,796,120,796,796,796,796,796,796,796,796,796,796,796,796,796,
796,796,796,796,796,796,796,796,796,796,796,796,797,797,797,798,
798,798,797,797,798,797,798,798,799,799,799,799,799,799,798,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 170 */
800,800,800,800,800,800,800,120,800,120,800,800,800,800,120,800,
800,800,800,800,800,800,800,800,800,800,800,800,800,800,120,800,
800,800,800,800,800,800,800,800,800,801,120,120,120,120,120,120,
802,802,802,802,802,802,802,802,802,802,802,802,802,802,802,802,
802,802,802,802,802,802,802,802,802,802,802,802,802,802,802,802,
802,802,802,802,802,802,802,802,802,802,802,802,802,802,802,803,
804,804,804,803,803,803,803,803,803,803,803,120,120,120,120,120,
805,805,805,805,805,805,805,805,805,805,120,120,120,120,120,120,

/* block 171 */
806,807,808,809,120,810,810,810,810,810,810,810,810,120,120,810,
810,120,120,810,810,810,810,810,810,810,810,810,810,810,810,810,
810,810,810,810,810,810,810,810,810,120,810,810,810,810,810,810,
810,120,810,810,120,810,810,810,810,810,120,811,807,810,812,808,
806,808,808,808,808,120,120,808,808,120,120,808,808,808,120,120,
810,120,120,120,120,120,120,812,120,120,120,120,120,810,810,810,
810,810,808,808,120,120,806,806,806,806,806,806,806,120,120,120,
806,806,806,806,806,120,120,120,120,120,120,120,120,120,120,120,

/* block 172 */
813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,
813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,
813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,
813,813,813,813,813,814,814,814,815,815,815,815,815,815,815,815,
814,814,815,815,815,814,815,813,813,813,813,816,816,816,816,816,
817,817,817,817,817,817,817,817,817,817,120,816,120,816,815,813,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 173 */
818,818,818,818,818,818,818,818,818,818,818,818,818,818,818,818,
818,818,818,818,818,818,818,818,818,818,818,818,818,818,818,818,
818,818,818,818,818,818,818,818,818,818,818,818,818,818,818,818,
819,820,820,821,821,821,821,821,821,820,821,820,820,819,820,821,
821,820,821,821,818,818,822,818,120,120,120,120,120,120,120,120,
823,823,823,823,823,823,823,823,823,823,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 174 */
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,825,
826,826,827,827,827,827,120,120,826,826,826,826,827,827,826,827,
827,828,828,828,828,828,828,828,828,828,828,828,828,828,828,828,
828,828,828,828,828,828,828,828,824,824,824,824,827,827,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 175 */
829,829,829,829,829,829,829,829,829,829,829,829,829,829,829,829,
829,829,829,829,829,829,829,829,829,829,829,829,829,829,829,829,
829,829,829,829,829,829,829,829,829,829,829,829,829,829,829,829,
830,830,830,831,831,831,831,831,831,831,831,830,830,831,830,831,
831,832,832,832,829,120,120,120,120,120,120,120,120,120,120,120,
833,833,833,833,833,833,833,833,833,833,120,120,120,120,120,120,
395,395,395,395,395,395,395,395,395,395,395,395,395,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 176 */
834,834,834,834,834,834,834,834,834,834,834,834,834,834,834,834,
834,834,834,834,834,834,834,834,834,834,834,834,834,834,834,834,
834,834,834,834,834,834,834,834,834,834,834,835,836,835,836,836,
835,835,835,835,835,835,836,835,834,120,120,120,120,120,120,120,
837,837,837,837,837,837,837,837,837,837,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 177 */
838,838,838,838,838,838,838,838,838,838,838,838,838,838,838,838,
838,838,838,838,838,838,838,838,838,838,838,120,120,839,839,839,
840,840,839,839,839,839,840,839,839,839,839,839,120,120,120,120,
841,841,841,841,841,841,841,841,841,841,842,842,843,843,843,844,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 178 */
845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,
845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,
845,845,845,845,845,845,845,845,845,845,845,845,846,846,846,847,
847,847,847,847,847,847,847,847,846,847,847,848,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 179 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
849,849,849,849,849,849,849,849,849,849,849,849,849,849,849,849,
849,849,849,849,849,849,849,849,849,849,849,849,849,849,849,849,
850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,
850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,850,
851,851,851,851,851,851,851,851,851,851,852,852,852,852,852,852,
852,852,852,120,120,120,120,120,120,120,120,120,120,120,120,853,

/* block 180 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
854,854,854,854,854,854,854,854,120,120,854,854,854,854,854,854,
854,854,854,854,854,854,854,854,854,854,854,854,854,854,854,854,
854,854,854,854,854,854,854,854,854,854,854,854,854,854,854,854,
854,855,855,855,856,856,856,856,120,120,856,856,855,855,855,855,
856,854,857,854,855,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 181 */
858,859,859,859,859,859,859,859,859,859,859,858,858,858,858,858,
858,858,858,858,858,858,858,858,858,858,858,858,858,858,858,858,
858,858,858,858,858,858,858,858,858,858,858,858,858,858,858,858,
858,858,858,859,859,859,859,859,859,860,861,859,859,859,859,862,
862,862,862,862,862,862,862,859,120,120,120,120,120,120,120,120,
863,864,864,864,864,864,864,865,865,864,864,864,863,863,863,863,
863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,
863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,

/* block 182 */
863,863,863,863,866,866,866,866,866,866,864,864,864,864,864,864,
864,864,864,864,864,864,864,865,864,864,867,867,867,863,867,867,
867,867,867,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,
868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,
868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,
868,868,868,868,868,868,868,868,868,120,120,120,120,120,120,120,

/* block 183 */
869,869,869,869,869,869,869,869,869,120,869,869,869,869,869,869,
869,869,869,869,869,869,869,869,869,869,869,869,869,869,869,869,
869,869,869,869,869,869,869,869,869,869,869,869,869,869,869,870,
871,871,871,871,871,871,871,120,871,871,871,871,871,871,870,871,
869,872,872,872,872,872,120,120,120,120,120,120,120,120,120,120,
873,873,873,873,873,873,873,873,873,873,874,874,874,874,874,874,
874,874,874,874,874,874,874,874,874,874,874,874,874,120,120,120,
875,875,876,876,876,876,876,876,876,876,876,876,876,876,876,876,

/* block 184 */
876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,876,
120,120,877,877,877,877,877,877,877,877,877,877,877,877,877,877,
877,877,877,877,877,877,877,877,120,878,877,877,877,877,877,877,
877,878,877,877,878,877,877,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 185 */
879,879,879,879,879,879,879,120,879,879,120,879,879,879,879,879,
879,879,879,879,879,879,879,879,879,879,879,879,879,879,879,879,
879,879,879,879,879,879,879,879,879,879,879,879,879,879,879,879,
879,880,880,880,880,880,880,120,120,120,880,120,880,880,120,880,
880,880,880,880,880,880,881,880,120,120,120,120,120,120,120,120,
882,882,882,882,882,882,882,882,882,882,120,120,120,120,120,120,
883,883,883,883,883,883,120,883,883,120,883,883,883,883,883,883,
883,883,883,883,883,883,883,883,883,883,883,883,883,883,883,883,

/* block 186 */
883,883,883,883,883,883,883,883,883,883,884,884,884,884,884,120,
885,885,120,884,884,885,884,885,883,120,120,120,120,120,120,120,
886,886,886,886,886,886,886,886,886,886,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 187 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
887,887,887,887,887,887,887,887,887,887,887,887,887,887,887,887,
887,887,887,888,888,889,889,890,890,120,120,120,120,120,120,120,

/* block 188 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
294,294,891,294,891,296,296,296,296,296,296,296,296,297,297,297,
297,296,296,296,296,296,296,296,296,296,296,296,296,296,296,296,
296,296,120,120,120,120,120,120,120,120,120,120,120,120,120,892,

/* block 189 */
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,

/* block 190 */
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 191 */
894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,
894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,
894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,
894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,
894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,
894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,
894,894,894,894,894,894,894,894,894,894,894,894,894,894,894,120,
895,895,895,895,895,120,120,120,120,120,120,120,120,120,120,120,

/* block 192 */
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,893,
893,893,893,893,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 193 */
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,

/* block 194 */
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,120,
897,897,897,897,897,897,897,897,897,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 195 */
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,

/* block 196 */
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,898,
898,898,898,898,898,898,898,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 197 */
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,

/* block 198 */
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,601,
601,601,601,601,601,601,601,601,601,120,120,120,120,120,120,120,
899,899,899,899,899,899,899,899,899,899,899,899,899,899,899,899,
899,899,899,899,899,899,899,899,899,899,899,899,899,899,899,120,
900,900,900,900,900,900,900,900,900,900,120,120,120,120,901,901,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 199 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,902,120,120,
903,903,903,903,903,904,120,120,120,120,120,120,120,120,120,120,

/* block 200 */
905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,
905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,
905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,
906,906,906,906,906,906,906,907,907,907,907,907,908,908,908,908,
909,909,909,909,907,908,120,120,120,120,120,120,120,120,120,120,
910,910,910,910,910,910,910,910,910,910,120,911,911,911,911,911,
911,911,120,905,905,905,905,905,905,905,905,905,905,905,905,905,
905,905,905,905,905,905,905,905,120,120,120,120,120,905,905,905,

/* block 201 */
905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 202 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,
912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,912,
913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,
913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,

/* block 203 */
914,914,914,914,914,914,914,914,914,914,914,914,914,914,914,914,
914,914,914,914,914,914,914,915,915,915,915,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 204 */
916,916,916,916,916,916,916,916,916,916,916,916,916,916,916,916,
916,916,916,916,916,916,916,916,916,916,916,916,916,916,916,916,
916,916,916,916,916,916,916,916,916,916,916,916,916,916,916,916,
916,916,916,916,916,916,916,916,916,916,916,916,916,916,916,916,
916,916,916,916,916,916,916,916,916,916,916,120,120,120,120,917,
916,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,

/* block 205 */
918,918,918,918,918,918,918,918,120,120,120,120,120,120,120,917,
917,917,917,919,919,919,919,919,919,919,919,919,919,919,919,919,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
920,921,  5,111,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 206 */
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,

/* block 207 */
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,120,120,120,120,120,120,120,120,

/* block 208 */
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 209 */
578,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,

/* block 210 */
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,

/* block 211 */
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,
573,573,573,573,573,573,573,573,573,573,573,573,573,573,573,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
573,573,573,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,578,578,578,578,120,120,120,120,120,120,120,120,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,

/* block 212 */
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,

/* block 213 */
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,923,
923,923,923,923,923,923,923,923,923,923,923,923,120,120,120,120,

/* block 214 */
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,120,120,120,120,120,
924,924,924,924,924,924,924,924,924,924,924,924,924,120,120,120,

/* block 215 */
924,924,924,924,924,924,924,924,924,120,120,120,120,120,120,120,
924,924,924,924,924,924,924,924,924,924,120,120,925,926,926,927,
928,928,928,928,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 216 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,120,120,120,120,120,120,120,120,120,120,

/* block 217 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,120,120, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20,929,930,113,113,113, 20, 20, 20,930,929,929,
929,929,929, 24, 24, 24, 24, 24, 24, 24, 24,113,113,113,113,113,

/* block 218 */
113,113,113, 20, 20,113,113,113,113,113,113,113, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,113,113,113,113, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 219 */
684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,
684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,
684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,
684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,684,
684,684,931,931,931,684,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 220 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 221 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,120,120,120,120,
582,582,582,582,582,582,582,582,582,582,582,582,582,582,582,582,
582,582, 25, 25, 25, 25, 25, 25, 25,120,120,120,120,120,120,120,

/* block 222 */
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,514,514,
514,514,514,514,514,120,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,

/* block 223 */
513,513,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,513,120,513,513,
120,120,513,120,120,513,513,120,120,513,513,513,513,120,513,513,
513,513,513,513,513,513,514,514,514,514,120,514,120,514,514,514,
514,514,514,514,120,514,514,514,514,514,514,514,514,514,514,514,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,

/* block 224 */
514,514,514,514,513,513,120,513,513,513,513,120,120,513,513,513,
513,513,513,513,513,120,513,513,513,513,513,513,513,120,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,513,513,120,513,513,513,513,120,
513,513,513,513,513,120,513,120,120,120,513,513,513,513,513,513,
513,120,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,

/* block 225 */
513,513,513,513,513,513,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,

/* block 226 */
514,514,514,514,514,514,514,514,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,

/* block 227 */
513,513,513,513,513,513,513,513,513,513,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,120,120,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,  9,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,  9,514,514,514,514,
514,514,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,  9,514,514,514,514,

/* block 228 */
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,  9,514,514,514,514,514,514,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,  9,514,514,514,514,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,  9,
514,514,514,514,514,514,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,  9,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,

/* block 229 */
514,514,514,514,514,514,514,514,514,  9,514,514,514,514,514,514,
513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,513,
513,513,513,513,513,513,513,513,513,  9,514,514,514,514,514,514,
514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,514,
514,514,514,  9,514,514,514,514,514,514,513,514,120,120, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,

/* block 230 */
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,

/* block 231 */
933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,
933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,
933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,
933,933,933,933,933,933,933,932,932,932,932,933,933,933,933,933,
933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,
933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,
933,933,933,933,933,933,933,933,933,933,933,933,933,932,932,932,
932,932,932,932,932,933,932,932,932,932,932,932,932,932,932,932,

/* block 232 */
932,932,932,932,933,932,932,934,934,934,934,934,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,933,933,933,933,933,
120,933,933,933,933,933,933,933,933,933,933,933,933,933,933,933,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 233 */
935,935,935,935,935,935,935,120,935,935,935,935,935,935,935,935,
935,935,935,935,935,935,935,935,935,120,120,935,935,935,935,935,
935,935,120,935,935,120,935,935,935,935,935,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 234 */
936,936,936,936,936,936,936,936,936,936,936,936,936,936,936,936,
936,936,936,936,936,936,936,936,936,936,936,936,936,936,936,936,
936,936,936,936,936,936,936,936,936,936,936,936,936,120,120,120,
937,937,937,937,937,937,937,938,938,938,938,938,938,938,120,120,
939,939,939,939,939,939,939,939,939,939,120,120,120,120,936,940,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 235 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
941,941,941,941,941,941,941,941,941,941,941,941,941,941,941,941,
941,941,941,941,941,941,941,941,941,941,941,941,941,941,941,941,
941,941,941,941,941,941,941,941,941,941,941,941,942,942,942,942,
943,943,943,943,943,943,943,943,943,943,120,120,120,120,120,944,

/* block 236 */
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,

/* block 237 */
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,120,120,946,946,946,946,946,946,946,946,946,
947,947,947,947,947,947,947,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 238 */
948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,
948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,
948,948,949,949,949,949,949,949,949,949,949,949,949,949,949,949,
949,949,949,949,949,949,949,949,949,949,949,949,949,949,949,949,
949,949,949,949,950,950,950,950,950,950,950,951,120,120,120,120,
952,952,952,952,952,952,952,952,952,952,120,120,120,120,953,953,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 239 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 240 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 25, 25, 25,
  6, 25, 25, 25, 25,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 241 */
120, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 242 */
225,225,225,225,120,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
120,225,225,120,225,120,120,225,120,225,225,225,225,225,225,225,
225,225,225,120,225,225,225,225,120,225,120,225,120,120,120,120,
120,120,225,120,120,120,120,225,120,225,120,225,120,225,225,225,
120,225,225,120,225,120,120,225,120,225,120,225,120,225,120,225,
120,225,225,120,225,120,120,225,225,225,225,120,225,225,225,225,
225,225,225,120,225,225,225,225,120,225,225,225,225,120,225,120,

/* block 243 */
225,225,225,225,225,225,225,225,225,225,120,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,120,120,120,120,
120,225,225,225,120,225,225,225,225,225,120,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
218,218,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 244 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,954,954,954,954,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 245 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21,954,954,954,954,954,954,954,954,954,954,954,954,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,954,
954, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
954, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
954, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21,954,954,954,954,954,954,954,954,954,954,

/* block 246 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,954,954,954,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,954,954,954,
 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21,

/* block 247 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 20,
 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,955,955,955,955,955,955,955,955,955,955,
955,955,955,955,955,955,955,955,955,955,955,955,955,955,955,955,

/* block 248 */
956, 21, 21,954,954,954,954,954,954,954,954,954,954,954,954,954,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20,954,954,954,954,
 20, 20, 20, 20, 20, 20, 20, 20, 20,954,954,954,954,954,954,954,
584,584,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
 21, 21, 21, 21, 21, 21,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,

/* block 249 */
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,

/* block 250 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 251 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,957,957,957,957,957,

/* block 252 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20,
 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 253 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 254 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21,954,954,954,954,954,954,954,954,954,954,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,954,954,954,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,954,954,954,954,954,

/* block 255 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,954,954,954,954,954,954,954,954,954,954,954,954,

/* block 256 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 21, 21, 21, 21,954,954,954,954,954,954,954,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,

/* block 257 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,954,954,954,954,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20,954,954,954,954,954,954,954,954,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,954,954,954,954,954,954,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 258 */
 20, 20, 20, 20, 20, 20, 20, 20,954,954,954,954,954,954,954,954,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,

/* block 259 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,954, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21,954, 21, 21, 21, 21,954,954,954, 21, 21, 21, 21, 21, 21,

/* block 260 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21,954,954, 21, 21, 21, 21, 21, 21,954,954,954, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,954,954, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 261 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21,954,954,954,954,954,954,954,954,954,954,954,954,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,954,954,
 21, 21, 21, 21,954,954,954,954, 21, 21, 21,954,954,954,954,954,

/* block 262 */
 21, 21, 21,954,954,954,954,954,954,954,954,954,954,954,954,954,
 21, 21, 21, 21, 21, 21,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,

/* block 263 */
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,120,120,

/* block 264 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 265 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,120,120,120,120,120,120,120,120,120,120,120,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,

/* block 266 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,120,120,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,

/* block 267 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,

/* block 268 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 269 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 270 */
511, 24,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,

/* block 271 */
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,

/* block 272 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,

/* block 273 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,

/* block 274 */
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,672,
672,672,672,672,672,672,672,672,672,672,672,672,672,672,120,120,

};

#if UCD_BLOCK_SIZE != 128
#error Please correct UCD_BLOCK_SIZE in pcre2_internal.h
#endif
#endif  /* SUPPORT_UNICODE */

#endif  /* PCRE2_PCRE2TEST */
