/* purple.vapi generated by vapigen, do not modify. */

namespace Purple {
	[CCode (cheader_filename = "purple.h", free_function = "purple_account_destroy")]
	[Compact]
	public class Account {
		public weak string alias;
		public weak string buddy_icon_path;
		public weak GLib.SList deny;
		public bool disconnecting;
		public weak Purple.Connection gc;
		public weak string password;
		public Purple.PrivacyType perm_deny;
		public weak GLib.SList permit;
		public weak Purple.Presence presence;
		public void* priv;
		public weak string protocol_id;
		public weak Purple.ProxyInfo proxy_info;
		public weak Purple.AccountRegistrationCb registration_cb;
		public void* registration_cb_user_data;
		public bool remember_pass;
		public weak GLib.HashTable settings;
		public weak GLib.List status_types;
		public weak Purple.Log system_log;
		public void* ui_data;
		public weak GLib.HashTable ui_settings;
		public weak string user_info;
		public weak string username;
		[CCode (has_construct_function = false)]
		public Account (string username, string protocol_id);
		public void add_buddies (GLib.List buddies);
		public void add_buddy (Purple.Buddy buddy);
		public void change_password (string orig_pw, string new_pw);
		public void clear_current_error ();
		public void clear_settings ();
		public void connect ();
		public void destroy_log ();
		public void disconnect ();
		public unowned Purple.Status get_active_status ();
		public unowned string get_alias ();
		public bool get_bool (string name, bool default_value);
		public unowned string get_buddy_icon_path ();
		public bool get_check_mail ();
		public unowned Purple.Connection get_connection ();
		public unowned Purple.ConnectionErrorInfo get_current_error ();
		public bool get_enabled (string ui);
		public int get_int (string name, int default_value);
		public unowned Purple.Log get_log (bool create);
		public unowned string get_password ();
		public unowned Purple.Presence get_presence ();
		public unowned string get_protocol_id ();
		public unowned string get_protocol_name ();
		public unowned Purple.ProxyInfo get_proxy_info ();
		public bool get_remember_password ();
		public unowned Purple.Status get_status (string status_id);
		public unowned Purple.StatusType get_status_type (string id);
		public unowned Purple.StatusType get_status_type_with_primitive (Purple.StatusPrimitive primitive);
		public unowned GLib.List get_status_types ();
		public unowned string get_string (string name, string default_value);
		public bool get_ui_bool (string ui, string name, bool default_value);
		public int get_ui_int (string ui, string name, int default_value);
		public unowned string get_ui_string (string ui, string name, string default_value);
		public unowned string get_user_info ();
		public unowned string get_username ();
		public bool is_connected ();
		public bool is_connecting ();
		public bool is_disconnected ();
		public bool is_status_active (string status_id);
		public void notify_added (string remote_user, string id, string alias, string message);
		public void register ();
		public void remove_buddies (GLib.List buddies, GLib.List groups);
		public void remove_buddy (Purple.Buddy buddy, Purple.Group group);
		public void remove_group (Purple.Group group);
		public void remove_setting (string setting);
		public void request_add (string remote_user, string id, string alias, string message);
		public void* request_authorization (string remote_user, string id, string alias, string message, bool on_list, Purple.AccountRequestAuthorizationCb auth_cb, Purple.AccountRequestAuthorizationCb deny_cb);
		public void request_change_password ();
		public void request_change_user_info ();
		public static void request_close (void* ui_handle);
		public void request_close_with_account ();
		public void request_password (GLib.Callback ok_cb, GLib.Callback cancel_cb);
		public void set_alias (string alias);
		public void set_bool (string name, bool value);
		public void set_buddy_icon_path (string path);
		public void set_check_mail (bool value);
		public void set_connection (Purple.Connection gc);
		public void set_enabled (string ui, bool value);
		public void set_int (string name, int value);
		public void set_password (string password);
		public void set_protocol_id (string protocol_id);
		public void set_proxy_info (Purple.ProxyInfo info);
		public void set_register_callback (Purple.AccountRegistrationCb cb);
		public void set_remember_password (bool value);
		public void set_status (string status_id, bool active);
		public void set_status_list (string status_id, bool active, GLib.List attrs);
		public void set_status_types (GLib.List status_types);
		public void set_string (string name, string value);
		public void set_ui_bool (string ui, string name, bool value);
		public void set_ui_int (string ui, string name, int value);
		public void set_ui_string (string ui, string name, string value);
		public void set_user_info (string user_info);
		public void set_username (string username);
		public bool supports_offline_message (Purple.Buddy buddy);
		public void unregister (Purple.AccountUnregistrationCb cb);
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_account_option_destroy")]
	[Compact]
	public class AccountOption {
		public void* default_value;
		public bool masked;
		public weak string pref_name;
		public weak string text;
		public Purple.PrefType type;
		[CCode (has_construct_function = false)]
		public AccountOption (Purple.PrefType type, string text, string pref_name);
		public void add_list_item (string key, string value);
		public static unowned Purple.AccountOption bool_new (string text, string pref_name, bool default_value);
		public bool get_default_bool ();
		public int get_default_int ();
		public unowned string get_default_list_value ();
		public unowned string get_default_string ();
		public unowned GLib.List get_list ();
		public bool get_masked ();
		public unowned string get_setting ();
		public unowned string get_text ();
		public static unowned Purple.AccountOption int_new (string text, string pref_name, int default_value);
		public static unowned Purple.AccountOption list_new (string text, string pref_name, GLib.List list);
		public void set_default_bool (bool value);
		public void set_default_int (int value);
		public void set_default_string (string value);
		public void set_list (GLib.List values);
		public void set_masked (bool masked);
		public static unowned Purple.AccountOption string_new (string text, string pref_name, string default_value);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class AccountUiOps {
		public weak GLib.Callback close_account_request;
		public weak GLib.Callback notify_added;
		public weak GLib.Callback request_add;
		public weak GLib.Callback request_authorize;
		public weak GLib.Callback status_changed;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_account_user_split_destroy")]
	[Compact]
	public class AccountUserSplit {
		public weak string default_value;
		public weak GLib.ObjectPath field_sep;
		public bool reverse;
		public weak string text;
		[CCode (has_construct_function = false)]
		public AccountUserSplit (string text, string default_value, GLib.ObjectPath sep);
		public unowned string get_default_value ();
		public bool get_reverse ();
		public unowned GLib.ObjectPath get_separator ();
		public unowned string get_text ();
		public void set_reverse (bool reverse);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class AttentionType {
		public weak string icon_name;
		public weak string incoming_description;
		public weak string name;
		public weak string outgoing_description;
		public weak string unlocalized_name;
		[CCode (has_construct_function = false)]
		public AttentionType (string ulname, string name, string inc_desc, string out_desc);
		public unowned string get_icon_name ();
		public unowned string get_incoming_desc ();
		public unowned string get_name ();
		public unowned string get_outgoing_desc ();
		public unowned string get_unlocalized_name ();
		public void set_icon_name (string name);
		public void set_incoming_desc (string desc);
		public void set_name (string name);
		public void set_outgoing_desc (string desc);
		public void set_unlocalized_name (string ulname);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class BlistNode {
		public weak Purple.BlistNode child;
		public Purple.BlistNodeFlags flags;
		public weak Purple.BlistNode parent;
		public weak Purple.BlistNode prev;
		public weak GLib.HashTable settings;
		public Purple.BlistNodeType type;
		public void* ui_data;
		public bool get_bool (string key);
		public unowned GLib.List get_extended_menu ();
		public unowned Purple.BlistNode get_first_child ();
		public Purple.BlistNodeFlags get_flags ();
		public int get_int (string key);
		public unowned Purple.BlistNode get_parent ();
		public unowned Purple.BlistNode get_sibling_next ();
		public unowned Purple.BlistNode get_sibling_prev ();
		public unowned string get_string (string key);
		public void* get_ui_data ();
		public unowned Purple.BlistNode next (bool offline);
		public void remove_setting (string key);
		public void set_bool (string key, bool value);
		public void set_flags (Purple.BlistNodeFlags flags);
		public void set_int (string key, int value);
		public void set_string (string key, string value);
		public void set_ui_data (void* ui_data);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class BlistUiOps {
		public weak GLib.Callback destroy;
		public weak GLib.Callback new_list;
		public weak GLib.Callback new_node;
		public weak GLib.Callback remove;
		public weak GLib.Callback remove_node;
		public weak GLib.Callback request_add_buddy;
		public weak GLib.Callback request_add_chat;
		public weak GLib.Callback request_add_group;
		public weak GLib.Callback save_account;
		public weak GLib.Callback save_node;
		public weak GLib.Callback set_visible;
		public weak GLib.Callback show;
		public weak GLib.Callback update;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_buddy_destroy")]
	[Compact]
	public class Buddy {
		public weak Purple.Account account;
		public weak string alias;
		public weak Purple.BuddyIcon icon;
		public weak string name;
		public weak Purple.BlistNode node;
		public weak Purple.Presence presence;
		public void* proto_data;
		public weak string server_alias;
		[CCode (has_construct_function = false)]
		public Buddy (Purple.Account account, string name, string alias);
		public unowned Purple.Account get_account ();
		public unowned string get_alias ();
		public unowned string get_alias_only ();
		public unowned Purple.Contact get_contact ();
		public unowned string get_contact_alias ();
		public unowned Purple.Group get_group ();
		public unowned Purple.BuddyIcon get_icon ();
		public unowned string get_local_alias ();
		public unowned string get_local_buddy_alias ();
		public unowned string get_name ();
		public unowned Purple.Presence get_presence ();
		public void* get_protocol_data ();
		public unowned string get_server_alias ();
		public static unowned Purple.BuddyIcon icons_find (Purple.Account account, string username);
		public static unowned Purple.StoredImage icons_find_account_icon (Purple.Account account);
		public static unowned Purple.StoredImage icons_find_custom_icon (Purple.Contact contact);
		public static ulong icons_get_account_icon_timestamp (Purple.Account account);
		public static unowned string icons_get_cache_dir ();
		public unowned string icons_get_checksum_for_user ();
		public static void* icons_get_handle ();
		public static bool icons_has_custom_icon (Purple.Contact contact);
		public static void icons_init ();
		public static bool icons_is_caching ();
		public static unowned Purple.StoredImage icons_node_find_custom_icon (Purple.BlistNode node);
		public static bool icons_node_has_custom_icon (Purple.BlistNode node);
		public static unowned Purple.StoredImage icons_node_set_custom_icon (Purple.BlistNode node, uchar[] icon_data, size_t icon_len);
		public static unowned Purple.StoredImage icons_node_set_custom_icon_from_file (Purple.BlistNode node, string filename);
		public static unowned Purple.StoredImage icons_set_account_icon (Purple.Account account, uchar[] icon_data, size_t icon_len);
		public static void icons_set_cache_dir (string cache_dir);
		public static void icons_set_caching (bool caching);
		public static unowned Purple.StoredImage icons_set_custom_icon (Purple.Contact contact, uchar[] icon_data, size_t icon_len);
		public static void icons_set_for_user (Purple.Account account, string username, void* icon_data, size_t icon_len, string checksum);
		public static void icons_uninit ();
		public void set_icon (Purple.BuddyIcon icon);
		public void set_protocol_data (void* data);
	}
	[CCode (cheader_filename = "purple.h", ref_function = "purple_buddy_icon_ref", unref_function = "purple_buddy_icon_unref")]
	[Compact]
	public class BuddyIcon {
		[CCode (has_construct_function = false)]
		public BuddyIcon (Purple.Account account, string username, void* icon_data, size_t icon_len, string checksum);
		public unowned Purple.Account get_account ();
		public unowned string get_checksum ();
		public void* get_data (size_t len);
		public unowned string get_extension ();
		public unowned string get_full_path ();
		public static void get_scale_size (Purple.BuddyIconSpec spec, int width, int height);
		public unowned string get_username ();
		public void set_data (uchar[] data, size_t len, string checksum);
		public void update ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class BuddyIconSpec {
		public weak string format;
		public size_t max_filesize;
		public int max_height;
		public int max_width;
		public int min_height;
		public int min_width;
		public Purple.IconScaleRules scale_rules;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class BuddyList {
		public weak GLib.HashTable buddies;
		public weak Purple.BlistNode root;
		public void* ui_data;
	}
	[CCode (cheader_filename = "purple.h", copy_function = "purple_certificate_copy", free_function = "purple_certificate_destroy")]
	[Compact]
	public class Certificate {
		public void* data;
		public weak Purple.CertificateScheme scheme;
		public static void add_ca_search_path (string path);
		public static bool check_signature_chain (GLib.List chain);
		public static bool check_signature_chain_with_failing (GLib.List chain, out unowned Purple.Certificate failing);
		public bool check_subject_name (string name);
		public unowned Purple.Certificate copy ();
		public static unowned GLib.List copy_list (GLib.List crt_list);
		public static void destroy_list (GLib.List crt_list);
		public void display_x509 ();
		public static bool export (string filename, Purple.Certificate crt);
		public static unowned Purple.CertificatePool find_pool (string scheme_name, string pool_name);
		public static unowned Purple.CertificateScheme find_scheme (string name);
		public static unowned Purple.CertificateVerifier find_verifier (string scheme_name, string ver_name);
		public unowned GLib.ByteArray get_fingerprint_sha1 ();
		public static void* get_handle ();
		public unowned string get_issuer_unique_id ();
		public static unowned GLib.List get_pools ();
		public static unowned GLib.List get_schemes ();
		public unowned string get_subject_name ();
		public bool get_times (ulong activation, ulong expiration);
		public unowned string get_unique_id ();
		public static unowned GLib.List get_verifiers ();
		public static unowned Purple.Certificate import (Purple.CertificateScheme scheme, string filename);
		public static void init ();
		public static bool register_pool (Purple.CertificatePool pool);
		public static bool register_scheme (Purple.CertificateScheme scheme);
		public static bool register_verifier (Purple.CertificateVerifier vr);
		public bool signed_by (Purple.Certificate issuer);
		public static void uninit ();
		public static bool unregister_pool (Purple.CertificatePool pool);
		public static bool unregister_scheme (Purple.CertificateScheme scheme);
		public static bool unregister_verifier (Purple.CertificateVerifier vr);
		public static void verify (Purple.CertificateVerifier verifier, string subject_name, GLib.List cert_chain, Purple.CertificateVerifiedCallback cb, void* cb_data);
		public static void verify_complete (Purple.CertificateVerificationRequest vrq, Purple.CertificateVerificationStatus st);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class CertificatePool {
		public weak GLib.Callback cert_in_pool;
		public void* data;
		public weak GLib.Callback delete_cert;
		public weak string fullname;
		public weak GLib.Callback get_cert;
		public weak GLib.Callback init;
		public weak string name;
		public weak GLib.Callback put_cert;
		public weak string scheme_name;
		public weak GLib.Callback uninit;
		public bool contains (string id);
		public bool @delete (string id);
		public static void destroy_idlist (GLib.List idlist);
		public unowned GLib.List get_idlist ();
		public unowned Purple.CertificateScheme get_scheme ();
		public unowned string mkpath (string id);
		public unowned Purple.Certificate retrieve (string id);
		public bool store (string id, Purple.Certificate crt);
		public bool usable ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class CertificateScheme {
		public weak GLib.Callback check_subject_name;
		public weak GLib.Callback copy_certificate;
		public weak GLib.Callback destroy_certificate;
		public weak GLib.Callback export_certificate;
		public weak string fullname;
		public weak GLib.Callback get_fingerprint_sha1;
		public weak GLib.Callback get_issuer_unique_id;
		public weak GLib.Callback get_subject_name;
		public weak GLib.Callback get_times;
		public weak GLib.Callback get_unique_id;
		public weak GLib.Callback import_certificate;
		public weak string name;
		public weak GLib.Callback signed_by;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class CertificateVerificationRequest {
		public weak Purple.CertificateVerifiedCallback cb;
		public void* cb_data;
		public weak GLib.List cert_chain;
		public void* data;
		public weak Purple.CertificateScheme scheme;
		public weak string subject_name;
		public weak Purple.CertificateVerifier verifier;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class CertificateVerifier {
		public weak GLib.Callback destroy_request;
		public weak string name;
		public weak string scheme_name;
		public weak GLib.Callback start_verification;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_chat_destroy")]
	[Compact]
	public class Chat {
		public weak Purple.Account account;
		public weak string alias;
		public weak GLib.HashTable components;
		public weak Purple.BlistNode node;
		[CCode (has_construct_function = false)]
		public Chat (Purple.Account account, string alias, GLib.HashTable components);
		public unowned Purple.Account get_account ();
		public unowned GLib.HashTable get_components ();
		public unowned Purple.Group get_group ();
		public unowned string get_name ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class Cipher {
		public static bool digest_region (string name, uchar[] data, size_t data_len, size_t in_len, uchar[] digest, size_t out_len);
		public uint get_capabilities ();
		public unowned string get_name ();
		public static unowned string http_digest_calculate_response (string algorithm, string method, string digest_uri, string qop, string entity, string nonce, string nonce_count, string client_nonce, string session_key);
		public static unowned string http_digest_calculate_session_key (string algorithm, string username, string realm, string password, string nonce, string client_nonce);
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_cipher_context_destroy")]
	[Compact]
	public class CipherContext {
		[CCode (has_construct_function = false)]
		public CipherContext (Purple.Cipher cipher, void* extra);
		public void append (uchar[] data, size_t len);
		[CCode (has_construct_function = false)]
		public CipherContext.by_name (string name, void* extra);
		public int decrypt (uchar[] data, size_t len, uchar[] output, size_t outlen);
		public bool digest (size_t in_len, uchar[] digest, size_t out_len);
		public bool digest_to_str (size_t in_len, char[] digest_s, size_t out_len);
		public int encrypt (uchar[] data, size_t len, uchar[] output, size_t outlen);
		public Purple.CipherBatchMode get_batch_mode ();
		public size_t get_block_size ();
		public void* get_data ();
		public size_t get_key_size ();
		public void* get_option (string name);
		public size_t get_salt_size ();
		public void reset (void* extra);
		public void set_batch_mode (Purple.CipherBatchMode mode);
		public void set_data (void* data);
		public void set_iv (uchar[] iv, size_t len);
		public void set_key (uchar[] key);
		public void set_key_with_len (uchar[] key, size_t len);
		public void set_option (string name, void* value);
		public void set_salt (uchar[] salt);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class CipherOps {
		public weak GLib.Callback append;
		public weak GLib.Callback decrypt;
		public weak GLib.Callback digest;
		public weak GLib.Callback encrypt;
		public weak GLib.Callback get_batch_mode;
		public weak GLib.Callback get_block_size;
		public weak GLib.Callback get_key_size;
		public weak GLib.Callback get_option;
		public weak GLib.Callback get_salt_size;
		public weak GLib.Callback init;
		public weak GLib.Callback reset;
		public weak GLib.Callback set_batch_mode;
		public weak GLib.Callback set_iv;
		public weak GLib.Callback set_key;
		public weak GLib.Callback set_key_with_len;
		public weak GLib.Callback set_option;
		public weak GLib.Callback set_salt;
		public weak GLib.Callback uninit;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_circ_buffer_destroy")]
	[Compact]
	public class CircBuffer {
		public weak string buffer;
		public size_t buflen;
		public size_t bufused;
		public size_t growsize;
		public weak string inptr;
		public weak string outptr;
		[CCode (has_construct_function = false)]
		public CircBuffer (size_t growsize);
		public void append (void* src, size_t len);
		public size_t get_max_read ();
		public bool mark_read (size_t len);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class CmdId {
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_connection_destroy")]
	[Compact]
	public class Connection {
		public weak Purple.Account account;
		public weak GLib.SList buddy_chats;
		public uint disconnect_timeout;
		public weak string display_name;
		public Purple.ConnectionFlags flags;
		public int inpa;
		public uint keepalive;
		public ulong last_received;
		public weak string password;
		public void* proto_data;
		public weak Purple.Plugin prpl;
		public Purple.ConnectionState state;
		public bool wants_to_die;
		[CCode (has_construct_function = false, type = "void")]
		public Connection (Purple.Account account, bool regist, string password);
		public void error (string reason);
		public static bool error_is_fatal (Purple.ConnectionError reason);
		public void error_reason (Purple.ConnectionError reason, string description);
		public unowned Purple.Account get_account ();
		public unowned string get_display_name ();
		public unowned string get_password ();
		public void* get_protocol_data ();
		public unowned Purple.Plugin get_prpl ();
		public Purple.ConnectionState get_state ();
		public void notice (string text);
		public void set_account (Purple.Account account);
		public void set_display_name (string name);
		public void set_protocol_data (void* proto_data);
		public void set_state (Purple.ConnectionState state);
		public void ssl_error (Purple.SslErrorType ssl_error);
		[CCode (has_construct_function = false, type = "void")]
		public Connection.unregister (Purple.Account account, string password, Purple.AccountUnregistrationCb cb);
		public void update_progress (string text, size_t step, size_t count);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ConnectionErrorInfo {
		public weak string description;
		public Purple.ConnectionError type;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ConnectionUiOps {
		public weak GLib.Callback connect_progress;
		public weak GLib.Callback connected;
		public weak GLib.Callback disconnected;
		public weak GLib.Callback network_connected;
		public weak GLib.Callback network_disconnected;
		public weak GLib.Callback notice;
		public weak GLib.Callback report_disconnect;
		public weak GLib.Callback report_disconnect_reason;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_contact_destroy")]
	[Compact]
	public class Contact {
		public weak string alias;
		public int currentsize;
		public weak Purple.BlistNode node;
		public int online;
		public weak Purple.Buddy priority;
		public bool priority_valid;
		public int totalsize;
		[CCode (has_construct_function = false)]
		public Contact ();
		public unowned string get_alias ();
		public unowned Purple.Buddy get_priority_buddy ();
		public void invalidate_priority_buddy ();
		public bool on_account (Purple.Account account);
		public void set_alias (string alias);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ConvChat {
		public weak Purple.Conversation conv;
		public int id;
		public weak GLib.List ignored;
		public weak GLib.List in_room;
		public weak string nick;
		public weak string topic;
		public weak string who;
		public void add_user (string user, string extra_msg, Purple.ConvChatBuddyFlags flags, bool new_arrival);
		public void add_users (GLib.List users, GLib.List extra_msgs, GLib.List flags, bool new_arrivals);
		public static void cb_destroy (Purple.ConvChatBuddy cb);
		public unowned Purple.ConvChatBuddy cb_find (string name);
		public static unowned string cb_get_name (Purple.ConvChatBuddy cb);
		public static unowned Purple.ConvChatBuddy cb_new (string name, string alias, Purple.ConvChatBuddyFlags flags);
		public void clear_users ();
		public bool find_user (string user);
		public unowned Purple.Conversation get_conversation ();
		public int get_id ();
		public unowned GLib.List get_ignored ();
		public unowned string get_ignored_user (string user);
		public unowned string get_nick ();
		public unowned string get_topic ();
		public unowned GLib.List get_users ();
		public bool has_left ();
		public void ignore (string name);
		public void invite_user (string user, string message, bool confirm);
		public bool is_user_ignored (string user);
		public void left ();
		public void remove_user (string user, string reason);
		public void remove_users (GLib.List users, string reason);
		public void rename_user (string old_user, string new_user);
		public void send (string message);
		public void send_with_flags (string message, Purple.MessageFlags flags);
		public void set_id (int id);
		public unowned GLib.List set_ignored (GLib.List ignored);
		public void set_nick (string nick);
		public void set_topic (string who, string topic);
		public unowned GLib.List set_users (GLib.List users);
		public void unignore (string name);
		public Purple.ConvChatBuddyFlags user_get_flags (string user);
		public void user_set_flags (string user, Purple.ConvChatBuddyFlags flags);
		public void write (string who, string message, Purple.MessageFlags flags, ulong mtime);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ConvChatBuddy {
		public weak string alias;
		public weak string alias_key;
		public bool buddy;
		public Purple.ConvChatBuddyFlags flags;
		public weak string name;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ConvIm {
		public weak Purple.Conversation conv;
		public weak Purple.BuddyIcon icon;
		public uint send_typed_timeout;
		public ulong type_again;
		public Purple.TypingState typing_state;
		public uint typing_timeout;
		public unowned Purple.Conversation get_conversation ();
		public unowned Purple.BuddyIcon get_icon ();
		public uint get_send_typed_timeout ();
		public ulong get_type_again ();
		public Purple.TypingState get_typing_state ();
		public uint get_typing_timeout ();
		public void send (string message);
		public void send_with_flags (string message, Purple.MessageFlags flags);
		public void set_icon (Purple.BuddyIcon icon);
		public void set_type_again (uint val);
		public void set_typing_state (Purple.TypingState state);
		public void start_send_typed_timeout ();
		public void start_typing_timeout (int timeout);
		public void stop_send_typed_timeout ();
		public void stop_typing_timeout ();
		public void update_typing ();
		public void write (string who, string message, Purple.MessageFlags flags, ulong mtime);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ConvMessage {
		public weak string alias;
		public weak Purple.Conversation conv;
		public Purple.MessageFlags flags;
		public weak string what;
		public ulong when;
		public weak string who;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_conversation_destroy")]
	[Compact]
	public class Conversation {
		public weak Purple.Account account;
		public weak GLib.HashTable data;
		public Purple.ConnectionFlags features;
		public bool logging;
		public weak GLib.List logs;
		public weak GLib.List message_history;
		public weak string name;
		public weak string title;
		public Purple.ConversationType type;
		public void* u;
		public void* ui_data;
		public weak Purple.ConversationUiOps ui_ops;
		[CCode (has_construct_function = false)]
		public Conversation (Purple.ConversationType type, Purple.Account account, string name);
		public void autoset_title ();
		public void clear_message_history ();
		public void close_logs ();
		public bool do_command (string cmdline, string markup, string error);
		public static void @foreach (GLib.Callback func);
		public unowned Purple.Account get_account ();
		public unowned Purple.ConvChat get_chat_data ();
		public void* get_data (string key);
		public unowned GLib.List get_extended_menu ();
		public Purple.ConnectionFlags get_features ();
		public unowned Purple.Connection get_gc ();
		public unowned Purple.ConvIm get_im_data ();
		public unowned GLib.List get_message_history ();
		public unowned string get_name ();
		public unowned string get_title ();
		public unowned Purple.ConversationUiOps get_ui_ops ();
		public bool has_focus ();
		public bool is_logging ();
		public static Purple.MessageFlags message_get_flags (Purple.ConvMessage msg);
		public static unowned string message_get_message (Purple.ConvMessage msg);
		public static unowned string message_get_sender (Purple.ConvMessage msg);
		public static ulong message_get_timestamp (Purple.ConvMessage msg);
		public void present ();
		public void set_account (Purple.Account account);
		public void set_data (string key, void* data);
		public void set_features (Purple.ConnectionFlags features);
		public void set_logging (bool log);
		public void set_name (string name);
		public void set_title (string title);
		public void set_ui_ops (Purple.ConversationUiOps ops);
		public void update (Purple.ConvUpdateType type);
		public void write (string who, string message, Purple.MessageFlags flags, ulong mtime);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ConversationUiOps {
		public weak GLib.Callback chat_add_users;
		public weak GLib.Callback chat_remove_users;
		public weak GLib.Callback chat_rename_user;
		public weak GLib.Callback chat_update_user;
		public weak GLib.Callback create_conversation;
		public weak GLib.Callback custom_smiley_add;
		public weak GLib.Callback custom_smiley_close;
		public weak GLib.Callback custom_smiley_write;
		public weak GLib.Callback destroy_conversation;
		public weak GLib.Callback has_focus;
		public weak GLib.Callback present;
		public weak GLib.Callback send_confirm;
		public weak GLib.Callback write_chat;
		public weak GLib.Callback write_conv;
		public weak GLib.Callback write_im;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class Core {
		public static bool ensure_single_instance ();
		public static unowned string get_ui ();
		public static unowned GLib.HashTable get_ui_info ();
		public static unowned Purple.CoreUiOps get_ui_ops ();
		public static unowned string get_version ();
		public static bool init (string ui);
		public static bool migrate ();
		public static void quit ();
		public static bool quit_cb (void* unused);
		public static void set_ui_ops (Purple.CoreUiOps ops);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class CoreUiOps {
		public weak GLib.Callback debug_ui_init;
		public weak GLib.Callback get_ui_info;
		public weak GLib.Callback quit;
		public weak GLib.Callback ui_init;
		public weak GLib.Callback ui_prefs_init;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class DBusType {
		public weak Purple.DBusType parent;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class DebugUiOps {
		public weak GLib.Callback is_enabled;
		public weak GLib.Callback print;
	}
	[CCode (cheader_filename = "purple.h", copy_function = "purple_desktop_item_copy", unref_function = "purple_desktop_item_unref")]
	[Compact]
	public class DesktopItem {
		public unowned Purple.DesktopItem copy ();
		[CCode (has_construct_function = false)]
		public DesktopItem.from_file (string filename);
		public Purple.DesktopItemType get_entry_type ();
		public unowned string get_string (string attr);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class DnsQueryData {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class DnsQueryUiOps {
		public weak GLib.Callback destroy;
		public weak GLib.Callback resolve_host;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class EventLoopUiOps {
		public weak GLib.Callback input_add;
		public weak GLib.Callback input_get_error;
		public weak GLib.Callback input_remove;
		public weak GLib.Callback timeout_add;
		public weak GLib.Callback timeout_add_seconds;
		public weak GLib.Callback timeout_remove;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_group_destroy")]
	[Compact]
	public class Group {
		public int currentsize;
		public weak string name;
		public weak Purple.BlistNode node;
		public int online;
		public int totalsize;
		[CCode (has_construct_function = false)]
		public Group (string name);
		public unowned GLib.SList get_accounts ();
		public unowned string get_name ();
		public bool on_account (Purple.Account account);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class IdleUiOps {
		public weak GLib.Callback get_time_idle;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class KeyValuePair {
		public weak string key;
		public void* value;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class Log {
		public weak Purple.Account account;
		public weak Purple.Conversation conv;
		public weak Purple.LogLogger logger;
		public void* logger_data;
		public weak string name;
		public ulong time;
		public void* tm;
		public Purple.LogType type;
		[CCode (has_construct_function = false)]
		public Log (Purple.LogType type, string name, Purple.Account account, Purple.Conversation conv, ulong time, void* tm);
		public bool common_deleter ();
		public bool common_is_deletable ();
		public static unowned GLib.List common_lister (Purple.LogType type, string name, Purple.Account account, string ext, Purple.LogLogger logger);
		public int common_sizer ();
		public static int common_total_sizer (Purple.LogType type, string name, Purple.Account account, string ext);
		public void common_writer (string ext);
		public static int compare (void* y, void* z);
		public bool @delete ();
		public static int get_activity_score (Purple.LogType type, string name, Purple.Account account);
		public static void* get_handle ();
		public static unowned string get_log_dir (Purple.LogType type, string name, Purple.Account account);
		public static unowned GLib.HashTable get_log_sets ();
		public static unowned GLib.List get_logs (Purple.LogType type, string name, Purple.Account account);
		public int get_size ();
		public static unowned GLib.List get_system_logs (Purple.Account account);
		public static int get_total_size (Purple.LogType type, string name, Purple.Account account);
		public static void init ();
		public bool is_deletable ();
		public unowned string read (Purple.LogReadFlags flags);
		public static void uninit ();
		public void write (Purple.MessageFlags type, string from, ulong time, string message);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class LogCommonLoggerData {
		public void* extra_data;
		public weak GLib.FileStream file;
		public weak string path;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class LogLogger {
		public weak GLib.Callback create;
		public weak GLib.Callback finalize;
		public weak GLib.Callback get_log_sets;
		public weak string id;
		public weak GLib.Callback is_deletable;
		public weak GLib.Callback list;
		public weak GLib.Callback list_syslog;
		public weak string name;
		public weak GLib.Callback read;
		public weak GLib.Callback size;
		public weak GLib.Callback total_size;
		public weak GLib.Callback write;
		[CCode (has_construct_function = false)]
		public LogLogger (string id, string name, int functions);
		public void add ();
		public static unowned Purple.LogLogger @get ();
		public static unowned GLib.List get_options ();
		public void remove ();
		public void @set ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class LogSet {
		public weak Purple.Account account;
		public bool buddy;
		public weak string name;
		public weak string normalized_name;
		public Purple.LogType type;
		public static int compare (void* y, void* z);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class Media {
		public bool accepted (string sess_id, string participant);
		public void add_remote_candidates (string sess_id, string participant, GLib.List remote_candidates);
		public bool add_stream (string sess_id, string who, Purple.MediaSessionType type, bool initiator, string transmitter, uint num_params, GLib.Parameter @params);
		public bool candidates_prepared (string session_id, string participant);
		public bool codecs_ready (string sess_id);
		public static GLib.Type element_type_get_type ();
		public void end (string session_id, string participant);
		public void error (string error);
		public unowned Purple.Account get_account ();
		public unowned GLib.List get_codecs (string sess_id);
		public unowned GLib.List get_local_candidates (string sess_id, string participant);
		public void* get_manager ();
		public void* get_prpl_data ();
		public unowned GLib.List get_session_ids ();
		public Purple.MediaSessionType get_session_type (string sess_id);
		public unowned Gst.Element get_src (string sess_id);
		public unowned Gst.Element get_tee (string session_id, string participant);
		public static GLib.Type info_type_get_type ();
		public bool is_initiator (string sess_id, string participant);
		public static GLib.Type network_protocol_get_type ();
		public void remove_output_windows ();
		public static GLib.Type session_type_get_type ();
		public void set_input_volume (string session_id, double level);
		public void set_output_volume (string session_id, string participant, double level);
		public ulong set_output_window (string session_id, string participant, ulong window_id);
		public void set_prpl_data (void* prpl_data);
		public bool set_remote_codecs (string sess_id, string participant, GLib.List codecs);
		public bool set_send_codec (string sess_id, Purple.MediaCodec codec);
		public static GLib.Type state_changed_get_type ();
		public void stream_info (Purple.MediaInfoType type, string session_id, string participant, bool local);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MediaCandidate {
		[CCode (has_construct_function = false)]
		public MediaCandidate (string foundation, uint component_id, Purple.MediaCandidateType type, Purple.MediaNetworkProtocol proto, string ip, uint port);
		public unowned string get_base_ip ();
		public uint16 get_base_port ();
		public Purple.MediaCandidateType get_candidate_type ();
		public uint get_component_id ();
		public unowned string get_foundation ();
		public unowned string get_ip ();
		public unowned string get_password ();
		public uint16 get_port ();
		public uint32 get_priority ();
		public Purple.MediaNetworkProtocol get_protocol ();
		public uint get_ttl ();
		public unowned string get_username ();
		public static unowned GLib.List list_copy (GLib.List candidates);
		public static void list_free (GLib.List candidates);
		public static GLib.Type type_get_type ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MediaCodec {
		[CCode (has_construct_function = false)]
		public MediaCodec (int id, string encoding_name, Purple.MediaSessionType media_type, uint clock_rate);
		public void add_optional_parameter (string name, string value);
		public uint get_channels ();
		public uint get_clock_rate ();
		public unowned string get_encoding_name ();
		public uint get_id ();
		public unowned Purple.KeyValuePair get_optional_parameter (string name, string value);
		public unowned GLib.List get_optional_parameters ();
		public static unowned GLib.List list_copy (GLib.List codecs);
		public static void list_free (GLib.List codecs);
		public void remove_optional_parameter (Purple.KeyValuePair param);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MediaElementInfo {
		public unowned Gst.Element call_create (Purple.Media media, string session_id, string participant);
		public Purple.MediaElementType get_element_type ();
		public unowned string get_id ();
		public unowned string get_name ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MediaElementInfoClass {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MediaManager {
		public unowned Purple.Media create_media (Purple.Account account, string conference_type, string remote_user, bool initiator);
		public bool create_output_window (Purple.Media media, string session_id, string participant);
		public static unowned Purple.MediaManager @get ();
		public unowned Purple.MediaElementInfo get_active_element (Purple.MediaElementType type);
		public unowned Gst.Element get_element (Purple.MediaSessionType type, Purple.Media media, string session_id, string participant);
		public unowned Purple.MediaElementInfo get_element_info (string name);
		public unowned GLib.List get_media ();
		public unowned GLib.List get_media_by_account (Purple.Account account);
		public unowned Gst.Element get_pipeline ();
		public Purple.MediaCaps get_ui_caps ();
		public bool register_element (Purple.MediaElementInfo info);
		public void remove_media (Purple.Media media);
		public bool remove_output_window (ulong output_window_id);
		public void remove_output_windows (Purple.Media media, string session_id, string participant);
		public bool set_active_element (Purple.MediaElementInfo info);
		public ulong set_output_window (Purple.Media media, string session_id, string participant, ulong window_id);
		public void set_ui_caps (Purple.MediaCaps caps);
		public bool unregister_element (string name);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MediaManagerClass {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MenuAction {
		public weak Purple.Callback callback;
		public weak GLib.List children;
		public void* data;
		public weak string label;
		[CCode (has_construct_function = false)]
		public MenuAction (string label, Purple.Callback callback, void* data, GLib.List children);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MimeDocument {
		[CCode (has_construct_function = false)]
		public MimeDocument ();
		public unowned string get_field (string field);
		public unowned GLib.List get_fields ();
		public unowned GLib.List get_parts ();
		public static unowned Purple.MimeDocument parse (string buf);
		public static unowned Purple.MimeDocument parsen (string buf, size_t len);
		public void set_field (string field, string value);
		public void write (GLib.StringBuilder str);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class MimePart {
		[CCode (has_construct_function = false)]
		public MimePart (Purple.MimeDocument doc);
		public unowned string get_data ();
		public void get_data_decoded (uchar[] data, size_t len);
		public unowned string get_field (string field);
		public unowned string get_field_decoded (string field);
		public unowned GLib.List get_fields ();
		public size_t get_length ();
		public void set_data (string data);
		public void set_field (string field, string value);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class NetworkListenData {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class NotifySearchButton {
		public weak Purple.NotifySearchResultsCallback callback;
		public weak string label;
		public Purple.NotifySearchButtonType type;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class NotifySearchColumn {
		public weak string title;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_notify_searchresults_free")]
	[Compact]
	public class NotifySearchResults {
		public weak GLib.List buttons;
		public weak GLib.List columns;
		[CCode (cname = "purple_notify_searchresults_new", has_construct_function = false)]
		public NotifySearchResults ();
		[CCode (cname = "purple_notify_searchresults_button_add")]
		public void button_add (Purple.NotifySearchButtonType type, Purple.NotifySearchResultsCallback cb);
		[CCode (cname = "purple_notify_searchresults_button_add_labeled")]
		public void button_add_labeled (string label, Purple.NotifySearchResultsCallback cb);
		[CCode (cname = "purple_notify_searchresults_column_add")]
		public void column_add (Purple.NotifySearchColumn column);
		[CCode (cname = "purple_notify_searchresults_column_get_title")]
		public unowned string column_get_title (uint column_id);
		[CCode (cname = "purple_notify_searchresults_column_new")]
		public static unowned Purple.NotifySearchColumn column_new (string title);
		[CCode (cname = "purple_notify_searchresults_get_columns_count")]
		public uint get_columns_count ();
		[CCode (cname = "purple_notify_searchresults_get_rows_count")]
		public uint get_rows_count ();
		[CCode (cname = "purple_notify_searchresults_row_add")]
		public void row_add (GLib.List row);
		[CCode (cname = "purple_notify_searchresults_row_get")]
		public unowned GLib.List row_get (uint row_id);
		[CCode (cname = "purple_notify_searchresults_new_rows", has_construct_function = false, type = "void")]
		public NotifySearchResults.rows (Purple.Connection gc, Purple.NotifySearchResults results, void* data);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class NotifyUiOps {
		public weak GLib.Callback close_notify;
		public weak GLib.Callback notify_email;
		public weak GLib.Callback notify_emails;
		public weak GLib.Callback notify_formatted;
		public weak GLib.Callback notify_message;
		public weak GLib.Callback notify_searchresults;
		public weak GLib.Callback notify_searchresults_new_rows;
		public weak GLib.Callback notify_uri;
		public weak GLib.Callback notify_userinfo;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_notify_user_info_destroy")]
	[Compact]
	public class NotifyUserInfo {
		[CCode (has_construct_function = false)]
		public NotifyUserInfo ();
		public void add_pair (string label, string value);
		public void add_section_break ();
		public void add_section_header (string label);
		public unowned GLib.List get_entries ();
		public unowned string get_text_with_newline (string newline);
		public void prepend_pair (string label, string value);
		public void prepend_section_break ();
		public void prepend_section_header (string label);
		public void remove_entry (Purple.NotifyUserInfoEntry user_info_entry);
		public void remove_last_item ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class NotifyUserInfoEntry {
		[CCode (has_construct_function = false)]
		public NotifyUserInfoEntry (string label, string value);
		public unowned string get_label ();
		public unowned string get_value ();
		public void set_label (string label);
		public void set_type (Purple.NotifyUserInfoEntryType type);
		public void set_value (string value);
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_plugin_destroy")]
	[Compact]
	public class Plugin {
		public weak GLib.List dependent_plugins;
		public weak string error;
		public void* extra;
		public void* handle;
		public weak Purple.PluginInfo info;
		public void* ipc_data;
		public bool loaded;
		public bool native_plugin;
		public weak string path;
		public bool unloadable;
		[CCode (has_construct_function = false)]
		public Plugin (bool native, string path);
		public void disable ();
		public unowned string get_author ();
		public unowned string get_description ();
		public unowned string get_homepage ();
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned string get_summary ();
		public unowned string get_version ();
		public void* ipc_call (string command, bool ok);
		public bool ipc_get_params (string command, out unowned Purple.Value ret_value, int num_params, out unowned Purple.Value @params);
		public bool ipc_register (string command, Purple.Callback func, Purple.SignalMarshalFunc marshal, Purple.Value ret_value, int num_params);
		public void ipc_unregister (string command);
		public void ipc_unregister_all ();
		public bool is_loaded ();
		public bool is_unloadable ();
		public bool load ();
		public static unowned Purple.Plugin probe (string filename);
		public bool register ();
		public bool reload ();
		public bool unload ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class PluginAction {
		public weak GLib.Callback callback;
		public void* context;
		public weak string label;
		public weak Purple.Plugin plugin;
		public void* user_data;
		[CCode (has_construct_function = false)]
		public PluginAction (string label, GLib.Callback callback);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class PluginInfo {
		public weak GLib.Callback actions;
		public weak string author;
		public weak GLib.List dependencies;
		public weak string description;
		public weak GLib.Callback destroy;
		public void* extra_info;
		public uint flags;
		public weak string homepage;
		public weak string id;
		public weak GLib.Callback load;
		public uint magic;
		public uint major_version;
		public uint minor_version;
		public weak string name;
		public weak Purple.PluginUiInfo prefs_info;
		public weak Purple.PluginPriority priority;
		public weak string summary;
		public Purple.PluginType type;
		public void* ui_info;
		public weak string ui_requirement;
		public weak GLib.Callback unload;
		public weak string version;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class PluginLoaderInfo {
		public weak GLib.Callback destroy;
		public weak GLib.List exts;
		public weak GLib.Callback load;
		public weak GLib.Callback probe;
		public weak GLib.Callback unload;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_plugin_pref_destroy")]
	[Compact]
	public class PluginPref {
		[CCode (has_construct_function = false)]
		public PluginPref ();
		public void add_choice (string label, void* choice);
		public void get_bounds (int min, int max);
		public unowned GLib.List get_choices ();
		public Purple.StringFormatType get_format_type ();
		public unowned string get_label ();
		public bool get_masked ();
		public uint get_max_length ();
		public unowned string get_name ();
		public void set_bounds (int min, int max);
		public void set_format_type (Purple.StringFormatType format);
		public void set_label (string label);
		public void set_masked (bool mask);
		public void set_max_length (uint max_length);
		public void set_name (string name);
		public void set_type (Purple.PluginPrefType type);
		[CCode (has_construct_function = false)]
		public PluginPref.with_label (string label);
		[CCode (has_construct_function = false)]
		public PluginPref.with_name (string name);
		[CCode (has_construct_function = false)]
		public PluginPref.with_name_and_label (string name, string label);
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_plugin_pref_frame_destroy")]
	[Compact]
	public class PluginPrefFrame {
		[CCode (has_construct_function = false)]
		public PluginPrefFrame ();
		public void add (Purple.PluginPref pref);
		public unowned GLib.List get_prefs ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class PluginPriority {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class PluginProtocolInfo {
		public weak GLib.Callback add_buddies;
		public weak GLib.Callback add_buddy;
		public weak GLib.Callback add_deny;
		public weak GLib.Callback add_permit;
		public weak GLib.Callback alias_buddy;
		public weak GLib.Callback blist_node_menu;
		public weak GLib.Callback buddy_free;
		public weak GLib.Callback can_receive_file;
		public weak GLib.Callback change_passwd;
		public weak GLib.Callback chat_info;
		public weak GLib.Callback chat_info_defaults;
		public weak GLib.Callback chat_invite;
		public weak GLib.Callback chat_leave;
		public weak GLib.Callback chat_send;
		public weak GLib.Callback chat_whisper;
		public weak GLib.Callback close;
		public weak GLib.Callback convo_closed;
		public weak GLib.Callback find_blist_chat;
		public weak GLib.Callback get_account_text_table;
		public weak GLib.Callback get_attention_types;
		public weak GLib.Callback get_cb_away;
		public weak GLib.Callback get_cb_info;
		public weak GLib.Callback get_cb_real_name;
		public weak GLib.Callback get_chat_name;
		public weak GLib.Callback get_info;
		public weak GLib.Callback get_media_caps;
		public weak GLib.Callback group_buddy;
		public weak Purple.BuddyIconSpec icon_spec;
		public weak GLib.Callback initiate_media;
		public weak GLib.Callback join_chat;
		public weak GLib.Callback keepalive;
		public weak GLib.Callback list_emblem;
		public weak GLib.Callback list_icon;
		public weak GLib.Callback login;
		public weak GLib.Callback new_xfer;
		public weak GLib.Callback normalize;
		public weak GLib.Callback offline_message;
		public Purple.ProtocolOptions options;
		public weak GLib.List protocol_options;
		public weak GLib.Callback register_user;
		public weak GLib.Callback reject_chat;
		public weak GLib.Callback rem_deny;
		public weak GLib.Callback rem_permit;
		public weak GLib.Callback remove_buddies;
		public weak GLib.Callback remove_buddy;
		public weak GLib.Callback remove_group;
		public weak GLib.Callback rename_group;
		public weak GLib.Callback roomlist_cancel;
		public weak GLib.Callback roomlist_expand_category;
		public weak GLib.Callback roomlist_get_list;
		public weak GLib.Callback roomlist_room_serialize;
		public weak GLib.Callback send_attention;
		public weak GLib.Callback send_file;
		public weak GLib.Callback send_im;
		public weak GLib.Callback send_raw;
		public weak GLib.Callback send_typing;
		public weak GLib.Callback set_buddy_icon;
		public weak GLib.Callback set_chat_topic;
		public weak GLib.Callback set_idle;
		public weak GLib.Callback set_info;
		public weak GLib.Callback set_permit_deny;
		public weak GLib.Callback set_status;
		public weak GLib.Callback status_text;
		public weak GLib.Callback status_types;
		public uint struct_size;
		public weak GLib.Callback tooltip_text;
		public weak GLib.Callback unregister_user;
		public weak GLib.List user_splits;
		public weak Purple.WhiteboardPrplOps whiteboard_prpl_ops;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class PluginUiInfo {
		public weak Purple.PluginPrefFrame frame;
		public weak GLib.Callback get_plugin_pref_frame;
		public int page_num;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_pounce_destroy")]
	[Compact]
	public class Pounce {
		public weak GLib.HashTable actions;
		public void* data;
		public Purple.PounceEvent events;
		public Purple.PounceOption options;
		public weak string pouncee;
		public weak Purple.Account pouncer;
		public bool save;
		public weak string ui_type;
		[CCode (has_construct_function = false)]
		public Pounce (string ui_type, Purple.Account pouncer, string pouncee, Purple.PounceEvent event, Purple.PounceOption option);
		public unowned string action_get_attribute (string action, string attr);
		public bool action_is_enabled (string action);
		public void action_register (string name);
		public void action_set_attribute (string action, string attr, string value);
		public void action_set_enabled (string action, bool enabled);
		public static void destroy_all_by_account (Purple.Account account);
		public static void execute (Purple.Account pouncer, string pouncee, Purple.PounceEvent events);
		public void* get_data ();
		public Purple.PounceEvent get_events ();
		public Purple.PounceOption get_options ();
		public unowned string get_pouncee ();
		public unowned Purple.Account get_pouncer ();
		public bool get_save ();
		public void set_data (void* data);
		public void set_events (Purple.PounceEvent events);
		public void set_options (Purple.PounceOption options);
		public void set_pouncee (string pouncee);
		public void set_pouncer (Purple.Account pouncer);
		public void set_save (bool save);
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_presence_destroy")]
	[Compact]
	public class Presence {
		[CCode (has_construct_function = false)]
		public Presence (Purple.PresenceContext context);
		public void add_list (GLib.List source_list);
		public void add_status (Purple.Status status);
		public int compare (Purple.Presence presence2);
		[CCode (has_construct_function = false)]
		public Presence.for_account (Purple.Account account);
		[CCode (has_construct_function = false)]
		public Presence.for_buddy (Purple.Buddy buddy);
		[CCode (has_construct_function = false)]
		public Presence.for_conv (Purple.Conversation conv);
		public unowned Purple.Account get_account ();
		public unowned Purple.Status get_active_status ();
		public unowned Purple.Buddy get_buddy ();
		public unowned string get_chat_user ();
		public Purple.PresenceContext get_context ();
		public unowned Purple.Conversation get_conversation ();
		public ulong get_idle_time ();
		public ulong get_login_time ();
		public unowned Purple.Status get_status (string status_id);
		public unowned GLib.List get_statuses ();
		public bool is_available ();
		public bool is_idle ();
		public bool is_online ();
		public bool is_status_active (string status_id);
		public bool is_status_primitive_active (Purple.StatusPrimitive primitive);
		public void set_idle (bool idle, ulong idle_time);
		public void set_login_time (ulong login_time);
		public void set_status_active (string status_id, bool active);
		public void switch_status (string status_id);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class PrivacyUiOps {
		public weak GLib.Callback deny_added;
		public weak GLib.Callback deny_removed;
		public weak GLib.Callback permit_added;
		public weak GLib.Callback permit_removed;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ProxyConnectData {
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_proxy_info_destroy")]
	[Compact]
	public class ProxyInfo {
		public weak string host;
		public weak string password;
		public int port;
		public Purple.ProxyType type;
		public weak string username;
		[CCode (has_construct_function = false)]
		public ProxyInfo ();
		public unowned string get_host ();
		public unowned string get_password ();
		public int get_port ();
		public unowned string get_username ();
		public void set_host (string host);
		public void set_password (string password);
		public void set_port (int port);
		public void set_type (Purple.ProxyType type);
		public void set_username (string username);
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_request_field_destroy")]
	[Compact]
	public class RequestField {
		public weak Purple.RequestFieldGroup group;
		public weak string id;
		public weak string label;
		public bool required;
		public Purple.RequestFieldType type;
		public weak string type_hint;
		public void* u;
		public void* ui_data;
		public bool visible;
		[CCode (has_construct_function = false)]
		public RequestField (string id, string text, Purple.RequestFieldType type);
		public unowned Purple.Account account_get_default_value ();
		public unowned Purple.FilterAccountFunc account_get_filter ();
		public bool account_get_show_all ();
		public unowned Purple.Account account_get_value ();
		public static unowned Purple.RequestField account_new (string id, string text, Purple.Account account);
		public void account_set_default_value (Purple.Account default_value);
		public void account_set_filter (Purple.FilterAccountFunc filter_func);
		public void account_set_show_all (bool show_all);
		public void account_set_value (Purple.Account value);
		public bool bool_get_default_value ();
		public bool bool_get_value ();
		public static unowned Purple.RequestField bool_new (string id, string text, bool default_value);
		public void bool_set_default_value (bool default_value);
		public void bool_set_value (bool value);
		public void choice_add (string label);
		public int choice_get_default_value ();
		public unowned GLib.List choice_get_labels ();
		public int choice_get_value ();
		public static unowned Purple.RequestField choice_new (string id, string text, int default_value);
		public void choice_set_default_value (int default_value);
		public void choice_set_value (int value);
		public unowned Purple.RequestFieldGroup get_group ();
		public unowned string get_id ();
		public unowned string get_label ();
		public unowned string get_type_hint ();
		public void* get_ui_data ();
		public unowned string image_get_buffer ();
		public uint image_get_scale_x ();
		public uint image_get_scale_y ();
		public size_t image_get_size ();
		public static unowned Purple.RequestField image_new (string id, string text, string buf, size_t size);
		public void image_set_scale (uint x, uint y);
		public int int_get_default_value ();
		public int int_get_value ();
		public static unowned Purple.RequestField int_new (string id, string text, int default_value);
		public void int_set_default_value (int default_value);
		public void int_set_value (int value);
		public bool is_required ();
		public bool is_visible ();
		public static unowned Purple.RequestField label_new (string id, string text);
		public void list_add (string item, void* data);
		public void list_add_selected (string item);
		public void list_clear_selected ();
		public void* list_get_data (string text);
		public unowned GLib.List list_get_items ();
		public bool list_get_multi_select ();
		public unowned GLib.List list_get_selected ();
		public bool list_is_selected (string item);
		public static unowned Purple.RequestField list_new (string id, string text);
		public void list_set_multi_select (bool multi_select);
		public void list_set_selected (GLib.List items);
		public void set_label (string label);
		public void set_required (bool required);
		public void set_type_hint (string type_hint);
		public void set_ui_data (void* ui_data);
		public void set_visible (bool visible);
		public unowned string string_get_default_value ();
		public unowned string string_get_value ();
		public bool string_is_editable ();
		public bool string_is_masked ();
		public bool string_is_multiline ();
		public static unowned Purple.RequestField string_new (string id, string text, string default_value, bool multiline);
		public void string_set_default_value (string default_value);
		public void string_set_editable (bool editable);
		public void string_set_masked (bool masked);
		public void string_set_value (string value);
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_request_field_group_destroy")]
	[Compact]
	public class RequestFieldGroup {
		public weak GLib.List fields;
		public weak Purple.RequestFields fields_list;
		public weak string title;
		[CCode (has_construct_function = false)]
		public RequestFieldGroup (string title);
		public void add_field (Purple.RequestField field);
		public unowned GLib.List get_fields ();
		public unowned string get_title ();
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_request_fields_destroy")]
	[Compact]
	public class RequestFields {
		public weak GLib.HashTable fields;
		public weak GLib.List groups;
		public weak GLib.List required_fields;
		public void* ui_data;
		[CCode (has_construct_function = false)]
		public RequestFields ();
		public void add_group (Purple.RequestFieldGroup group);
		public bool all_required_filled ();
		public bool exists (string id);
		public unowned Purple.Account get_account (string id);
		public bool get_bool (string id);
		public int get_choice (string id);
		public unowned Purple.RequestField get_field (string id);
		public unowned GLib.List get_groups ();
		public int get_integer (string id);
		public unowned GLib.List get_required ();
		public unowned string get_string (string id);
		public bool is_field_required (string id);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class RequestUiOps {
		public weak GLib.Callback close_request;
		public weak GLib.Callback request_action;
		public weak GLib.Callback request_choice;
		public weak GLib.Callback request_fields;
		public weak GLib.Callback request_file;
		public weak GLib.Callback request_folder;
		public weak GLib.Callback request_input;
	}
	[CCode (cheader_filename = "purple.h", ref_function = "purple_roomlist_ref", ref_function_void = true, unref_function = "purple_roomlist_unref")]
	[Compact]
	public class Roomlist {
		public weak Purple.Account account;
		public weak GLib.List fields;
		public bool in_progress;
		public void* proto_data;
		public uint @ref;
		public weak GLib.List rooms;
		public void* ui_data;
		[CCode (has_construct_function = false)]
		public Roomlist (Purple.Account account);
		public void cancel_get_list ();
		public void expand_category (Purple.RoomlistRoom category);
		public unowned GLib.List get_fields ();
		public bool get_in_progress ();
		public static unowned Purple.Roomlist get_list (Purple.Connection gc);
		public static unowned Purple.RoomlistUiOps get_ui_ops ();
		public void set_fields (GLib.List fields);
		public void set_in_progress (bool in_progress);
		public static void set_ui_ops (Purple.RoomlistUiOps ops);
		public static void show_with_account (Purple.Account account);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class RoomlistField {
		public bool hidden;
		public weak string label;
		public weak string name;
		public Purple.RoomlistFieldType type;
		[CCode (has_construct_function = false)]
		public RoomlistField (Purple.RoomlistFieldType type, string label, string name, bool hidden);
		public bool get_hidden ();
		public unowned string get_label ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class RoomlistRoom {
		public bool expanded_once;
		public weak GLib.List fields;
		public weak string name;
		public weak Purple.RoomlistRoom parent;
		public Purple.RoomlistRoomType type;
		[CCode (has_construct_function = false)]
		public RoomlistRoom (Purple.RoomlistRoomType type, string name, Purple.RoomlistRoom parent);
		public static void add (Purple.Roomlist list, Purple.RoomlistRoom room);
		public static void add_field (Purple.Roomlist list, Purple.RoomlistRoom room, void* field);
		public unowned GLib.List get_fields ();
		public unowned string get_name ();
		public unowned Purple.RoomlistRoom get_parent ();
		public static void join (Purple.Roomlist list, Purple.RoomlistRoom room);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class RoomlistUiOps {
		public weak GLib.Callback add_room;
		public weak GLib.Callback create;
		public weak GLib.Callback destroy;
		public weak GLib.Callback in_progress;
		public weak GLib.Callback set_fields;
		public weak GLib.Callback show_with_account;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SavedStatus {
		[CCode (cname = "purple_savedstatus_new", has_construct_function = false)]
		public SavedStatus (string title, Purple.StatusPrimitive type);
		[CCode (cname = "purple_savedstatus_activate")]
		public void activate ();
		[CCode (cname = "purple_savedstatus_activate_for_account")]
		public void activate_for_account (Purple.Account account);
		[CCode (cname = "purple_savedstatus_delete")]
		public static bool @delete (string title);
		[CCode (cname = "purple_savedstatus_delete_by_status")]
		public void delete_by_status ();
		[CCode (cname = "purple_savedstatus_find")]
		public static unowned Purple.SavedStatus find (string title);
		[CCode (cname = "purple_savedstatus_find_by_creation_time")]
		public static unowned Purple.SavedStatus find_by_creation_time (ulong creation_time);
		[CCode (cname = "purple_savedstatus_find_transient_by_type_and_message")]
		public static unowned Purple.SavedStatus find_transient_by_type_and_message (Purple.StatusPrimitive type, string message);
		[CCode (cname = "purple_savedstatus_get_creation_time")]
		public ulong get_creation_time ();
		[CCode (cname = "purple_savedstatus_get_current")]
		public static unowned Purple.SavedStatus get_current ();
		[CCode (cname = "purple_savedstatus_get_default")]
		public static unowned Purple.SavedStatus get_default ();
		[CCode (cname = "purple_savedstatus_get_idleaway")]
		public static unowned Purple.SavedStatus get_idleaway ();
		[CCode (cname = "purple_savedstatus_get_message")]
		public unowned string get_message ();
		[CCode (cname = "purple_savedstatus_get_startup")]
		public static unowned Purple.SavedStatus get_startup ();
		[CCode (cname = "purple_savedstatus_get_substatus")]
		public unowned Purple.SavedStatusSub get_substatus (Purple.Account account);
		[CCode (cname = "purple_savedstatus_get_title")]
		public unowned string get_title ();
		[CCode (cname = "purple_savedstatus_has_substatuses")]
		public bool has_substatuses ();
		[CCode (cname = "purple_savedstatus_is_idleaway")]
		public static bool is_idleaway ();
		[CCode (cname = "purple_savedstatus_is_transient")]
		public bool is_transient ();
		[CCode (cname = "purple_savedstatus_set_idleaway")]
		public static void set_idleaway (bool idleaway);
		[CCode (cname = "purple_savedstatus_set_message")]
		public void set_message (string message);
		[CCode (cname = "purple_savedstatus_set_substatus")]
		public void set_substatus (Purple.Account account, Purple.StatusType type, string message);
		[CCode (cname = "purple_savedstatus_set_title")]
		public void set_title (string title);
		[CCode (cname = "purple_savedstatus_set_type")]
		public void set_type (Purple.StatusPrimitive type);
		[CCode (cname = "purple_savedstatus_substatus_get_message")]
		public static unowned string substatus_get_message (Purple.SavedStatusSub substatus);
		[CCode (cname = "purple_savedstatus_substatus_get_type")]
		public static unowned Purple.StatusType substatus_get_type (Purple.SavedStatusSub substatus);
		[CCode (cname = "purple_savedstatus_unset_substatus")]
		public void unset_substatus (Purple.Account account);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SavedStatusSub {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class Smiley {
		[CCode (has_construct_function = false)]
		public Smiley (Purple.StoredImage img, string shortcut);
		public void @delete ();
		[CCode (has_construct_function = false)]
		public Smiley.from_file (string shortcut, string filepath);
		public unowned string get_checksum ();
		public void* get_data (size_t len);
		public unowned string get_extension ();
		public unowned string get_full_path ();
		public unowned string get_shortcut ();
		public unowned Purple.StoredImage get_stored_image ();
		public void set_data (uchar[] smiley_data, size_t smiley_data_len);
		public bool set_shortcut (string shortcut);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SmileyClass {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SoundTheme {
		public weak Purple.Theme parent;
		public void* priv;
		public unowned string get_file (string event);
		public unowned string get_file_full (string event);
		public void set_file (string event, string filename);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SoundThemeClass {
		public weak Purple.ThemeClass parent_class;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SoundThemeLoader {
		public weak Purple.ThemeLoader parent;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SoundThemeLoaderClass {
		public weak Purple.ThemeLoaderClass parent_class;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SoundUiOps {
		public weak GLib.Callback init;
		public weak GLib.Callback play_event;
		public weak GLib.Callback play_file;
		public weak GLib.Callback uninit;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SrvQueryData {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SrvResponse {
		[CCode (array_length = false)]
		public weak GLib.ObjectPath[] hostname;
		public int port;
		public int pref;
		public int weight;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SslConnection {
		public weak Purple.SslInputFunction connect_cb;
		public void* connect_cb_data;
		public weak Purple.ProxyConnectData connect_data;
		public weak Purple.SslErrorFunction error_cb;
		public int fd;
		public weak string host;
		public uint inpa;
		public int port;
		public void* private_data;
		public weak Purple.SslInputFunction recv_cb;
		public void* recv_cb_data;
		public weak Purple.CertificateVerifier verifier;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class SslOps {
		public weak GLib.Callback close;
		public weak GLib.Callback connectfunc;
		public weak GLib.Callback get_peer_certificates;
		public weak GLib.Callback init;
		public weak GLib.Callback read;
		public weak GLib.Callback uninit;
		public weak GLib.Callback write;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_status_destroy")]
	[Compact]
	public class Status {
		[CCode (has_construct_function = false)]
		public Status (Purple.StatusType status_type, Purple.Presence presence);
		public int compare (Purple.Status status2);
		public bool get_attr_boolean (string id);
		public int get_attr_int (string id);
		public unowned string get_attr_string (string id);
		public unowned Purple.Value get_attr_value (string id);
		public static void* get_handle ();
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned Purple.Presence get_presence ();
		public static void init ();
		public bool is_active ();
		public bool is_available ();
		public bool is_exclusive ();
		public bool is_independent ();
		public bool is_online ();
		public void set_active (bool active);
		public void set_active_with_attrs (bool active, void* args);
		public void set_active_with_attrs_list (bool active, GLib.List attrs);
		public void set_attr_boolean (string id, bool value);
		public void set_attr_int (string id, int value);
		public void set_attr_string (string id, string value);
		public static void uninit ();
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_status_attr_destroy")]
	[Compact]
	public class StatusAttr {
		[CCode (has_construct_function = false)]
		public StatusAttr (string id, string name, Purple.Value value_type);
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned Purple.Value get_value ();
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_status_type_destroy")]
	[Compact]
	public class StatusType {
		[CCode (has_construct_function = false)]
		public StatusType (Purple.StatusPrimitive primitive, string id, string name, bool user_settable);
		public void add_attr (string id, string name, Purple.Value value);
		public void add_attrs (string id, string name, Purple.Value value);
		public void add_attrs_vargs (void* args);
		public static unowned Purple.StatusType find_with_id (GLib.List status_types, string id);
		[CCode (has_construct_function = false)]
		public StatusType.full (Purple.StatusPrimitive primitive, string id, string name, bool saveable, bool user_settable, bool independent);
		public unowned Purple.StatusAttr get_attr (string id);
		public unowned GLib.List get_attrs ();
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned string get_primary_attr ();
		public Purple.StatusPrimitive get_primitive ();
		public bool is_available ();
		public bool is_exclusive ();
		public bool is_independent ();
		public bool is_saveable ();
		public bool is_user_settable ();
		public void set_primary_attr (string attr_id);
		[CCode (has_construct_function = false)]
		public StatusType.with_attrs (Purple.StatusPrimitive primitive, string id, string name, bool saveable, bool user_settable, bool independent, string attr_id, string attr_name, Purple.Value attr_value);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class StoredImage {
	}
	[CCode (cheader_filename = "purple.h", ref_function = "purple_stringref_ref", unref_function = "purple_stringref_unref")]
	[Compact]
	public class Stringref {
		[CCode (has_construct_function = false)]
		public Stringref (string value);
		public int cmp (Purple.Stringref s2);
		public size_t len ();
		[CCode (has_construct_function = false)]
		public Stringref.noref (string value);
		public static unowned Purple.Stringref printf (string format);
		public unowned string value ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class StunNatDiscovery {
		public ulong lookup_time;
		[CCode (array_length = false)]
		public weak GLib.ObjectPath[] publicip;
		public weak string servername;
		public Purple.StunStatus status;
		public Purple.StunNatType type;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class Theme {
		public weak GLib.Object parent;
		public void* priv;
		public unowned string get_author ();
		public unowned string get_description ();
		public unowned string get_dir ();
		public unowned string get_image ();
		public unowned string get_image_full ();
		public unowned string get_name ();
		public unowned string get_type_string ();
		public void set_author (string author);
		public void set_description (string description);
		public void set_dir (string dir);
		public void set_image (string img);
		public void set_name (string name);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ThemeClass {
		public weak GLib.ObjectClass parent_class;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ThemeLoader {
		public weak GLib.Object parent;
		public void* priv;
		public unowned Purple.Theme build (string dir);
		public unowned string get_type_string ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ThemeLoaderClass {
		public weak GLib.ObjectClass parent_class;
		public weak GLib.Callback purple_theme_loader_build;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ThemeManager {
		public weak GLib.Object parent;
		public static void add_theme (Purple.Theme theme);
		public static unowned Purple.Theme find_theme (string name, string type);
		public static void for_each_theme (Purple.PTFunc func);
		public static void init ();
		public static unowned Purple.Theme load_theme (string theme_dir, string type);
		public static void refresh ();
		public static void register_type (Purple.ThemeLoader loader);
		public static void remove_theme (Purple.Theme theme);
		public static void uninit ();
		public static void unregister_type (Purple.ThemeLoader loader);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class ThemeManagerClass {
		public weak GLib.ObjectClass parent_class;
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_txt_response_destroy")]
	[Compact]
	public class TxtResponse {
		public unowned string get_content ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class UPnPMappingAddRemove {
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class UtilFetchUrlData {
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_value_destroy")]
	[Compact]
	public class Value {
		public void* data;
		public uint flags;
		public Purple.Type type;
		public void* u;
		[CCode (has_construct_function = false)]
		public Value (Purple.Type type);
		public unowned Purple.Value dup ();
		public bool get_boolean ();
		public void* get_boxed ();
		public unowned GLib.ObjectPath get_char ();
		public int get_enum ();
		public int get_int ();
		public int64 get_int64 ();
		public long get_long ();
		public void* get_object ();
		public void* get_pointer ();
		public short get_short ();
		public unowned string get_specific_type ();
		public unowned string get_string ();
		public uint get_subtype ();
		public uint get_uchar ();
		public uint get_uint ();
		public uint64 get_uint64 ();
		public uint get_ulong ();
		public uint get_ushort ();
		public bool is_outgoing ();
		[CCode (has_construct_function = false)]
		public Value.outgoing (Purple.Type type);
		public void set_boolean (bool data);
		public void set_boxed (void* data);
		public void set_char (GLib.ObjectPath data);
		public void set_enum (int data);
		public void set_int (int data);
		public void set_int64 (int64 data);
		public void set_long (long data);
		public void set_object (void* data);
		public void set_pointer (void* data);
		public void set_short (short data);
		public void set_string (string data);
		public void set_uchar (uint data);
		public void set_uint (uint data);
		public void set_uint64 (uint64 data);
		public void set_ulong (uint data);
		public void set_ushort (uint data);
	}
	[CCode (cheader_filename = "purple.h", free_function = "purple_whiteboard_destroy")]
	[Compact]
	public class Whiteboard {
		public weak Purple.Account account;
		public weak GLib.List draw_list;
		public void* proto_data;
		public weak Purple.WhiteboardPrplOps prpl_ops;
		public int state;
		public void* ui_data;
		public weak string who;
		public void clear ();
		public static unowned Purple.Whiteboard create (Purple.Account account, string who, int state);
		public void draw_line (int x1, int y1, int x2, int y2, int color, int size);
		public static void draw_list_destroy (GLib.List draw_list);
		public void draw_point (int x, int y, int color, int size);
		public bool get_brush (int size, int color);
		public bool get_dimensions (int width, int height);
		public static unowned Purple.Whiteboard get_session (Purple.Account account, string who);
		public void send_brush (int size, int color);
		public void send_clear ();
		public void send_draw_list (GLib.List list);
		public void set_brush (int size, int color);
		public void set_dimensions (int width, int height);
		public void set_prpl_ops (Purple.WhiteboardPrplOps ops);
		public static void set_ui_ops (Purple.WhiteboardUiOps ops);
		public void start ();
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class WhiteboardPrplOps {
		public weak GLib.Callback clear;
		public weak GLib.Callback end;
		public weak GLib.Callback get_brush;
		public weak GLib.Callback get_dimensions;
		public weak GLib.Callback send_draw_list;
		public weak GLib.Callback set_brush;
		public weak GLib.Callback set_dimensions;
		public weak GLib.Callback start;
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class WhiteboardUiOps {
		public weak GLib.Callback clear;
		public weak GLib.Callback create;
		public weak GLib.Callback destroy;
		public weak GLib.Callback draw_line;
		public weak GLib.Callback draw_point;
		public weak GLib.Callback set_brush;
		public weak GLib.Callback set_dimensions;
	}
	[CCode (cheader_filename = "purple.h", ref_function = "purple_xfer_ref", ref_function_void = true, unref_function = "purple_xfer_unref")]
	[Compact]
	public class Xfer {
		public weak Purple.Account account;
		public size_t bytes_remaining;
		public size_t bytes_sent;
		public size_t current_buffer_size;
		public void* data;
		public weak GLib.FileStream dest_fp;
		public ulong end_time;
		public int fd;
		public weak string filename;
		public weak string local_filename;
		public int local_port;
		public weak string message;
		public void* ops;
		public uint @ref;
		public weak string remote_ip;
		public int remote_port;
		public size_t size;
		public ulong start_time;
		public Purple.XferStatusType status;
		public Purple.XferType type;
		public void* ui_data;
		public weak Purple.XferUiOps ui_ops;
		public int watcher;
		public weak string who;
		[CCode (has_construct_function = false)]
		public Xfer (Purple.Account account, Purple.XferType type, string who);
		public void add ();
		public void cancel_local ();
		public void cancel_remote ();
		public void conversation_write (string message, bool is_error);
		public void end ();
		public static void error (Purple.XferType type, Purple.Account account, string who, string msg);
		public unowned Purple.Account get_account ();
		public size_t get_bytes_remaining ();
		public size_t get_bytes_sent ();
		public ulong get_end_time ();
		public unowned string get_filename ();
		public unowned string get_local_filename ();
		public uint get_local_port ();
		public double get_progress ();
		public unowned string get_remote_ip ();
		public uint get_remote_port ();
		public unowned string get_remote_user ();
		public size_t get_size ();
		public ulong get_start_time ();
		public Purple.XferStatusType get_status ();
		public unowned Purple.XferUiOps get_ui_ops ();
		public bool is_canceled ();
		public bool is_completed ();
		public void prpl_ready ();
		public ssize_t read (uchar[] buffer);
		public void request ();
		public void request_accepted (string filename);
		public void request_denied ();
		public void set_ack_fnc (GLib.Callback fnc);
		public void set_bytes_sent (size_t bytes_sent);
		public void set_cancel_recv_fnc (GLib.Callback fnc);
		public void set_cancel_send_fnc (GLib.Callback fnc);
		public void set_completed (bool completed);
		public void set_end_fnc (GLib.Callback fnc);
		public void set_filename (string filename);
		public void set_init_fnc (GLib.Callback fnc);
		public void set_local_filename (string filename);
		public void set_message (string message);
		public void set_read_fnc (GLib.Callback fnc);
		public void set_request_denied_fnc (GLib.Callback fnc);
		public void set_size (size_t size);
		public void set_start_fnc (GLib.Callback fnc);
		public void set_write_fnc (GLib.Callback fnc);
		public void start (int fd, string ip, uint port);
		public void ui_ready ();
		public void update_progress ();
		public ssize_t write (uchar[] buffer, size_t size);
	}
	[CCode (cheader_filename = "purple.h")]
	[Compact]
	public class XferUiOps {
		public weak GLib.Callback add_xfer;
		public weak GLib.Callback cancel_local;
		public weak GLib.Callback cancel_remote;
		public weak GLib.Callback data_not_sent;
		public weak GLib.Callback destroy;
		public weak GLib.Callback new_xfer;
		public weak GLib.Callback ui_read;
		public weak GLib.Callback ui_write;
		public weak GLib.Callback update_progress;
	}
	[CCode (cheader_filename = "purple.h", copy_function = "xmlnode_copy", free_function = "xmlnode_free")]
	[Compact]
	public class xmlnode {
		public weak string data;
		public size_t data_sz;
		public weak Purple.xmlnode lastchild;
		public weak string name;
		public weak GLib.HashTable namespace_map;
		public weak Purple.xmlnode next;
		public weak Purple.xmlnode parent;
		public weak string prefix;
		public Purple.XMLNodeType type;
		public weak string xmlns;
		[CCode (cname = "xmlnode_new", has_construct_function = false, type = "xmlnode*")]
		public xmlnode (string name);
		[CCode (cname = "xmlnode_new_child", has_construct_function = false, type = "xmlnode*")]
		public xmlnode.child (Purple.xmlnode parent, string name);
		[CCode (cname = "xmlnode_copy")]
		public static unowned Purple.xmlnode copy (Purple.xmlnode src);
		[CCode (cname = "xmlnode_from_file")]
		public static unowned Purple.xmlnode from_file (string dir, string filename, string description, string process);
		[CCode (cname = "xmlnode_from_str")]
		public static unowned Purple.xmlnode from_str (string str, ssize_t size);
		[CCode (cname = "xmlnode_get_attrib")]
		public static unowned string get_attrib (Purple.xmlnode node, string attr);
		[CCode (cname = "xmlnode_get_attrib_with_namespace")]
		public static unowned string get_attrib_with_namespace (Purple.xmlnode node, string attr, string xmlns);
		[CCode (cname = "xmlnode_get_child")]
		public static unowned Purple.xmlnode get_child (Purple.xmlnode parent, string name);
		[CCode (cname = "xmlnode_get_child_with_namespace")]
		public static unowned Purple.xmlnode get_child_with_namespace (Purple.xmlnode parent, string name, string xmlns);
		[CCode (cname = "xmlnode_get_data")]
		public static unowned string get_data (Purple.xmlnode node);
		[CCode (cname = "xmlnode_get_data_unescaped")]
		public static unowned string get_data_unescaped (Purple.xmlnode node);
		[CCode (cname = "xmlnode_get_namespace")]
		public static unowned string get_namespace (Purple.xmlnode node);
		[CCode (cname = "xmlnode_get_next_twin")]
		public static unowned Purple.xmlnode get_next_twin (Purple.xmlnode node);
		[CCode (cname = "xmlnode_get_parent")]
		public static unowned Purple.xmlnode get_parent (Purple.xmlnode child);
		[CCode (cname = "xmlnode_get_prefix")]
		public static unowned string get_prefix (Purple.xmlnode node);
		[CCode (cname = "xmlnode_insert_child")]
		public static void insert_child (Purple.xmlnode parent, Purple.xmlnode child);
		[CCode (cname = "xmlnode_insert_data")]
		public static void insert_data (Purple.xmlnode node, string data, ssize_t size);
		[CCode (cname = "xmlnode_remove_attrib")]
		public static void remove_attrib (Purple.xmlnode node, string attr);
		[CCode (cname = "xmlnode_remove_attrib_with_namespace")]
		public static void remove_attrib_with_namespace (Purple.xmlnode node, string attr, string xmlns);
		[CCode (cname = "xmlnode_set_attrib")]
		public static void set_attrib (Purple.xmlnode node, string attr, string value);
		[CCode (cname = "xmlnode_set_attrib_full")]
		public static void set_attrib_full (Purple.xmlnode node, string attr, string xmlns, string prefix, string value);
		[CCode (cname = "xmlnode_set_attrib_with_namespace")]
		public static void set_attrib_with_namespace (Purple.xmlnode node, string attr, string xmlns, string value);
		[CCode (cname = "xmlnode_set_attrib_with_prefix")]
		public static void set_attrib_with_prefix (Purple.xmlnode node, string attr, string prefix, string value);
		[CCode (cname = "xmlnode_set_namespace")]
		public static void set_namespace (Purple.xmlnode node, string xmlns);
		[CCode (cname = "xmlnode_set_prefix")]
		public static void set_prefix (Purple.xmlnode node, string prefix);
		[CCode (cname = "xmlnode_to_formatted_str")]
		public static unowned string to_formatted_str (Purple.xmlnode node, int len);
		[CCode (cname = "xmlnode_to_str")]
		public static unowned string to_str (Purple.xmlnode node, int len);
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_ACCOUNT_REQUEST_", has_type_id = false)]
	public enum AccountRequestType {
		AUTHORIZATION
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_BLIST_NODE_FLAG_NO_", has_type_id = false)]
	public enum BlistNodeFlags {
		SAVE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_BLIST_", has_type_id = false)]
	public enum BlistNodeType {
		GROUP_NODE,
		CONTACT_NODE,
		BUDDY_NODE,
		CHAT_NODE,
		OTHER_NODE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CERTIFICATE_", has_type_id = false)]
	public enum CertificateVerificationStatus {
		INVALID,
		VALID
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CIPHER_BATCH_MODE_", has_type_id = false)]
	public enum CipherBatchMode {
		ECB,
		CBC
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CIPHER_CAPS_", has_type_id = false)]
	public enum CipherCaps {
		SET_OPT,
		GET_OPT,
		INIT,
		RESET,
		UNINIT,
		SET_IV,
		APPEND,
		DIGEST,
		ENCRYPT,
		DECRYPT,
		SET_SALT,
		GET_SALT_SIZE,
		SET_KEY,
		GET_KEY_SIZE,
		SET_BATCH_MODE,
		GET_BATCH_MODE,
		GET_BLOCK_SIZE,
		SET_KEY_WITH_LEN,
		UNKNOWN
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CMD_FLAG_", has_type_id = false)]
	public enum CmdFlag {
		IM,
		CHAT,
		PRPL_ONLY,
		ALLOW_WRONG_ARGS
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CMD_P_", has_type_id = false)]
	public enum CmdPriority {
		VERY_LOW,
		LOW,
		DEFAULT,
		PRPL,
		PLUGIN,
		ALIAS,
		HIGH,
		VERY_HIGH
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CMD_RET_", has_type_id = false)]
	public enum CmdRet {
		OK,
		FAILED,
		CONTINUE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CMD_STATUS_", has_type_id = false)]
	public enum CmdStatus {
		OK,
		FAILED,
		NOT_FOUND,
		WRONG_ARGS,
		WRONG_PRPL,
		WRONG_TYPE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CONNECTION_ERROR_", has_type_id = false)]
	public enum ConnectionError {
		NETWORK_ERROR,
		INVALID_USERNAME,
		AUTHENTICATION_FAILED,
		AUTHENTICATION_IMPOSSIBLE,
		NO_SSL_SUPPORT,
		ENCRYPTION_ERROR,
		NAME_IN_USE,
		INVALID_SETTINGS,
		CERT_NOT_PROVIDED,
		CERT_UNTRUSTED,
		CERT_EXPIRED,
		CERT_NOT_ACTIVATED,
		CERT_HOSTNAME_MISMATCH,
		CERT_FINGERPRINT_MISMATCH,
		CERT_SELF_SIGNED,
		CERT_OTHER_ERROR,
		OTHER_ERROR
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CONNECTION_", has_type_id = false)]
	public enum ConnectionFlags {
		HTML,
		NO_BGCOLOR,
		AUTO_RESP,
		FORMATTING_WBFO,
		NO_NEWLINES,
		NO_FONTSIZE,
		NO_URLDESC,
		NO_IMAGES,
		ALLOW_CUSTOM_SMILEY
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_", has_type_id = false)]
	public enum ConnectionState {
		DISCONNECTED,
		CONNECTED,
		CONNECTING
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CBFLAGS_", has_type_id = false)]
	public enum ConvChatBuddyFlags {
		NONE,
		VOICE,
		HALFOP,
		OP,
		FOUNDER,
		TYPING
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CONV_", has_type_id = false)]
	public enum ConvUpdateType {
		UPDATE_ADD,
		UPDATE_REMOVE,
		UPDATE_ACCOUNT,
		UPDATE_TYPING,
		UPDATE_UNSEEN,
		UPDATE_LOGGING,
		UPDATE_TOPIC,
		ACCOUNT_ONLINE,
		ACCOUNT_OFFLINE,
		UPDATE_AWAY,
		UPDATE_ICON,
		UPDATE_TITLE,
		UPDATE_CHATLEFT,
		UPDATE_FEATURES
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_CONV_TYPE_", has_type_id = false)]
	public enum ConversationType {
		UNKNOWN,
		IM,
		CHAT,
		MISC,
		ANY
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_DEBUG_", has_type_id = false)]
	public enum DebugLevel {
		ALL,
		MISC,
		INFO,
		WARNING,
		ERROR,
		FATAL
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_DESKTOP_ITEM_TYPE_", has_type_id = false)]
	public enum DesktopItemType {
		NULL,
		OTHER,
		APPLICATION,
		LINK,
		FSDEVICE,
		MIME_TYPE,
		DIRECTORY,
		SERVICE,
		SERVICE_TYPE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_ICON_SCALE_", has_type_id = false)]
	public enum IconScaleRules {
		DISPLAY,
		SEND
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_INPUT_", has_type_id = false)]
	public enum InputCondition {
		READ,
		WRITE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_LOG_READ_NO_", has_type_id = false)]
	public enum LogReadFlags {
		NEWLINE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_LOG_", has_type_id = false)]
	public enum LogType {
		IM,
		CHAT,
		SYSTEM
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MEDIA_CANDIDATE_TYPE_", has_type_id = false)]
	public enum MediaCandidateType {
		HOST,
		SRFLX,
		PRFLX,
		RELAY,
		MULTICAST
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MEDIA_CAPS_", has_type_id = false)]
	public enum MediaCaps {
		NONE,
		AUDIO,
		AUDIO_SINGLE_DIRECTION,
		VIDEO,
		VIDEO_SINGLE_DIRECTION,
		AUDIO_VIDEO,
		MODIFY_SESSION,
		CHANGE_DIRECTION
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MEDIA_COMPONENT_", has_type_id = false)]
	public enum MediaComponentType {
		NONE,
		RTP,
		RTCP
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MEDIA_ELEMENT_", has_type_id = false)]
	public enum MediaElementType {
		NONE,
		AUDIO,
		VIDEO,
		AUDIO_VIDEO,
		NO_SRCS,
		ONE_SRC,
		MULTI_SRC,
		REQUEST_SRC,
		NO_SINKS,
		ONE_SINK,
		MULTI_SINK,
		REQUEST_SINK,
		UNIQUE,
		SRC,
		SINK
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MEDIA_INFO_", has_type_id = false)]
	public enum MediaInfoType {
		HANGUP,
		ACCEPT,
		REJECT,
		MUTE,
		UNMUTE,
		PAUSE,
		UNPAUSE,
		HOLD,
		UNHOLD
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MEDIA_NETWORK_PROTOCOL_", has_type_id = false)]
	public enum MediaNetworkProtocol {
		UDP,
		TCP
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MEDIA_", has_type_id = false)]
	public enum MediaSessionType {
		NONE,
		RECV_AUDIO,
		SEND_AUDIO,
		RECV_VIDEO,
		SEND_VIDEO,
		AUDIO,
		VIDEO
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MEDIA_STATE_", has_type_id = false)]
	public enum MediaState {
		NEW,
		CONNECTED,
		END
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_MESSAGE_", has_type_id = false)]
	public enum MessageFlags {
		SEND,
		RECV,
		SYSTEM,
		AUTO_RESP,
		ACTIVE_ONLY,
		NICK,
		NO_LOG,
		WHISPER,
		ERROR,
		DELAYED,
		RAW,
		IMAGES,
		NOTIFY,
		NO_LINKIFY,
		INVISIBLE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_NOTIFY_MSG_", has_type_id = false)]
	public enum NotifyMsgType {
		ERROR,
		WARNING,
		INFO
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_NOTIFY_BUTTON_", has_type_id = false)]
	public enum NotifySearchButtonType {
		LABELED,
		CONTINUE,
		ADD,
		INFO,
		IM,
		JOIN,
		INVITE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_NOTIFY_", has_type_id = false)]
	public enum NotifyType {
		MESSAGE,
		EMAIL,
		EMAILS,
		FORMATTED,
		SEARCHRESULTS,
		USERINFO,
		URI
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_NOTIFY_USER_INFO_ENTRY_", has_type_id = false)]
	public enum NotifyUserInfoEntryType {
		PAIR,
		SECTION_BREAK,
		SECTION_HEADER
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_PLUGIN_PREF_", has_type_id = false)]
	public enum PluginPrefType {
		NONE,
		CHOICE,
		INFO,
		STRING_FORMAT
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_PLUGIN_", has_type_id = false)]
	public enum PluginType {
		UNKNOWN,
		STANDARD,
		LOADER,
		PROTOCOL
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_PMP_TYPE_", has_type_id = false)]
	public enum PmpType {
		UDP,
		TCP
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_POUNCE_", has_type_id = false)]
	public enum PounceEvent {
		NONE,
		SIGNON,
		SIGNOFF,
		AWAY,
		AWAY_RETURN,
		IDLE,
		IDLE_RETURN,
		TYPING,
		TYPED,
		TYPING_STOPPED,
		MESSAGE_RECEIVED
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_POUNCE_OPTION_", has_type_id = false)]
	public enum PounceOption {
		NONE,
		AWAY
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_PREF_", has_type_id = false)]
	public enum PrefType {
		NONE,
		BOOLEAN,
		INT,
		STRING,
		STRING_LIST,
		PATH,
		PATH_LIST
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_PRESENCE_CONTEXT_", has_type_id = false)]
	public enum PresenceContext {
		UNSET,
		ACCOUNT,
		CONV,
		BUDDY
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_PRIVACY_", has_type_id = false)]
	public enum PrivacyType {
		ALLOW_ALL,
		DENY_ALL,
		ALLOW_USERS,
		DENY_USERS,
		ALLOW_BUDDYLIST
	}
	[CCode (cheader_filename = "purple.h", cprefix = "OPT_PROTO_", has_type_id = false)]
	public enum ProtocolOptions {
		UNIQUE_CHATNAME,
		CHAT_TOPIC,
		NO_PASSWORD,
		MAIL_CHECK,
		IM_IMAGE,
		PASSWORD_OPTIONAL,
		USE_POINTSIZE,
		REGISTER_NOSCREENNAME,
		SLASH_COMMANDS_NATIVE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_PROXY_", has_type_id = false)]
	public enum ProxyType {
		USE_GLOBAL,
		NONE,
		HTTP,
		SOCKS4,
		SOCKS5,
		USE_ENVVAR
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_REQUEST_FIELD_", has_type_id = false)]
	public enum RequestFieldType {
		NONE,
		STRING,
		INTEGER,
		BOOLEAN,
		CHOICE,
		LIST,
		LABEL,
		IMAGE,
		ACCOUNT
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_REQUEST_", has_type_id = false)]
	public enum RequestType {
		INPUT,
		CHOICE,
		ACTION,
		FIELDS,
		FILE,
		FOLDER
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_ROOMLIST_FIELD_", has_type_id = false)]
	public enum RoomlistFieldType {
		BOOL,
		INT,
		STRING
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_ROOMLIST_ROOMTYPE_", has_type_id = false)]
	public enum RoomlistRoomType {
		CATEGORY,
		ROOM
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_", has_type_id = false)]
	public enum SoundEventID {
		SOUND_BUDDY_ARRIVE,
		SOUND_BUDDY_LEAVE,
		SOUND_RECEIVE,
		SOUND_FIRST_RECEIVE,
		SOUND_SEND,
		SOUND_CHAT_JOIN,
		SOUND_CHAT_LEAVE,
		SOUND_CHAT_YOU_SAY,
		SOUND_CHAT_SAY,
		SOUND_POUNCE_DEFAULT,
		SOUND_CHAT_NICK,
		NUM_SOUNDS
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_SSL_", has_type_id = false)]
	public enum SslErrorType {
		HANDSHAKE_FAILED,
		CONNECT_FAILED,
		CERTIFICATE_INVALID
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_STATUS_", has_type_id = false)]
	public enum StatusPrimitive {
		UNSET,
		OFFLINE,
		AVAILABLE,
		UNAVAILABLE,
		INVISIBLE,
		AWAY,
		EXTENDED_AWAY,
		MOBILE,
		TUNE,
		NUM_PRIMITIVES
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_STRING_FORMAT_TYPE_", has_type_id = false)]
	public enum StringFormatType {
		NONE,
		MULTILINE,
		HTML
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_STUN_NAT_TYPE_", has_type_id = false)]
	public enum StunNatType {
		PUBLIC_IP,
		UNKNOWN_NAT,
		FULL_CONE,
		RESTRICTED_CONE,
		PORT_RESTRICTED_CONE,
		SYMMETRIC
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_STUN_STATUS_", has_type_id = false)]
	public enum StunStatus {
		UNDISCOVERED,
		UNKNOWN,
		DISCOVERING,
		DISCOVERED
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_SUBTYPE_", has_type_id = false)]
	public enum SubType {
		UNKNOWN,
		ACCOUNT,
		BLIST,
		BLIST_BUDDY,
		BLIST_GROUP,
		BLIST_CHAT,
		BUDDY_ICON,
		CONNECTION,
		CONVERSATION,
		PLUGIN,
		BLIST_NODE,
		CIPHER,
		STATUS,
		LOG,
		XFER,
		SAVEDSTATUS,
		XMLNODE,
		USERINFO,
		STORED_IMAGE,
		CERTIFICATEPOOL
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_TYPE_", has_type_id = false)]
	public enum Type {
		UNKNOWN,
		SUBTYPE,
		CHAR,
		UCHAR,
		BOOLEAN,
		SHORT,
		USHORT,
		INT,
		UINT,
		LONG,
		ULONG,
		INT64,
		UINT64,
		STRING,
		OBJECT,
		POINTER,
		ENUM,
		BOXED
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_", has_type_id = false)]
	public enum TypingState {
		NOT_TYPING,
		TYPING,
		TYPED
	}
	[CCode (cheader_filename = "purple.h", cprefix = "XMLNODE_TYPE_", has_type_id = false)]
	public enum XMLNodeType {
		TAG,
		ATTRIB,
		DATA
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_XFER_STATUS_", has_type_id = false)]
	public enum XferStatusType {
		UNKNOWN,
		NOT_STARTED,
		ACCEPTED,
		STARTED,
		DONE,
		CANCEL_LOCAL,
		CANCEL_REMOTE
	}
	[CCode (cheader_filename = "purple.h", cprefix = "PURPLE_XFER_", has_type_id = false)]
	public enum XferType {
		UNKNOWN,
		SEND,
		RECEIVE
	}
	[CCode (cheader_filename = "purple.h")]
	public delegate void AccountRegistrationCb (Purple.Account account, bool succeeded);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void AccountRequestAuthorizationCb (void* p1);
	[CCode (cheader_filename = "purple.h")]
	public delegate void AccountUnregistrationCb (Purple.Account account, bool succeeded);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void Callback ();
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void CertificateVerifiedCallback (Purple.CertificateVerificationStatus st, void* userdata);
	[CCode (cheader_filename = "purple.h")]
	public delegate Purple.CmdRet CmdFunc (Purple.Conversation p1, string cmd, string args, string error);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void DnsQueryConnectFunction (GLib.SList hosts, void* data, string error_message);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void DnsQueryFailedCallback (Purple.DnsQueryData query_data, string error_message);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void DnsQueryResolvedCallback (Purple.DnsQueryData query_data, GLib.SList hosts);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate bool FilterAccountFunc (Purple.Account account);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate unowned string InfoFieldFormatCallback (string field, size_t len);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void InputFunction (void* p1, int p2, Purple.InputCondition p3);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void LogSetCallback (GLib.HashTable sets, Purple.LogSet @set);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate unowned Gst.Element MediaElementCreateCallback (Purple.Media media, string session_id, string participant);
	[CCode (cheader_filename = "purple.h")]
	public delegate void NetworkListenCallback (int listenfd);
	[CCode (cheader_filename = "purple.h")]
	public delegate void NotifyCloseCallback ();
	[CCode (cheader_filename = "purple.h")]
	public delegate void NotifySearchResultsCallback (Purple.Connection c, GLib.List row);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void PTFunc (Purple.Theme p1);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void PounceCb (Purple.Pounce p1, Purple.PounceEvent p2, void* p3);
	[CCode (cheader_filename = "purple.h")]
	public delegate void PrefCallback (string name, Purple.PrefType type, void* val);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void ProxyConnectFunction (void* data, int source, string error_message);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void RequestActionCb (void* p1, int p2);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void RequestChoiceCb (void* p1, int p2);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void RequestFieldsCb (void* p1, Purple.RequestFields fields);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void RequestFileCb (void* p1, string filename);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void RequestInputCb (void* p1, string p2);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void SignalMarshalFunc (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public delegate void SrvCallback (Purple.SrvResponse resp, int results);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void SslErrorFunction (Purple.SslConnection p1, Purple.SslErrorType p2, void* p3);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void SslInputFunction (void* p1, Purple.SslConnection p2, Purple.InputCondition p3);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void StunCallback (Purple.StunNatDiscovery p1);
	[CCode (cheader_filename = "purple.h")]
	public delegate void TxtCallback (GLib.List responses);
	[CCode (cheader_filename = "purple.h")]
	public delegate void UPnPCallback (bool success);
	[CCode (cheader_filename = "purple.h", has_target = false)]
	public delegate void UtilFetchUrlCallback (Purple.UtilFetchUrlData url_data, void* user_data, string url_text, size_t len, string error_message);
	[CCode (cheader_filename = "purple.h")]
	public const string DBUS_INTERFACE_PURPLE;
	[CCode (cheader_filename = "purple.h")]
	public const string DBUS_PATH_PURPLE;
	[CCode (cheader_filename = "purple.h")]
	public const string DBUS_SERVICE_PURPLE;
	[CCode (cheader_filename = "purple.h")]
	public const int DEFAULT_ACTION_NONE;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_ACTIONS;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_COMMENT;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_DEFAULT_APP;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_DEV;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_DOC_PATH;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_ENCODING;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_EXEC;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_FILE_PATTERN;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_FS_TYPE;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_GENERIC_NAME;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_HIDDEN;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_ICON;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_MIME_TYPE;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_MINI_ICON;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_MOUNT_POINT;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_NAME;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_NO_DISPLAY;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_PATH;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_PATTERNS;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_READ_ONLY;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_SORT_ORDER;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_SWALLOW_EXEC;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_SWALLOW_TITLE;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_TERMINAL;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_TERMINAL_OPTIONS;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_TRY_EXEC;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_TYPE;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_UNMOUNT_ICON;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_URL;
	[CCode (cheader_filename = "purple.h")]
	public const string DESKTOP_ITEM_VERSION;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_ACTIONS;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_COMMENT;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_DEFAULT_APP;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_DEV;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_DOC_PATH;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_ENCODING;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_EXEC;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_FILE_PATTERN;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_FS_TYPE;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_GENERIC_NAME;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_HIDDEN;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_ICON;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_MIME_TYPE;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_MINI_ICON;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_MOUNT_POINT;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_NAME;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_NO_DISPLAY;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_PATH;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_PATTERNS;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_READ_ONLY;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_SORT_ORDER;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_SWALLOW_EXEC;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_SWALLOW_TITLE;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_TERMINAL;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_TERMINAL_OPTIONS;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_TRY_EXEC;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_TYPE;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_UNMOUNT_ICON;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_URL;
	[CCode (cheader_filename = "purple.h")]
	public const string GAIM_DESKTOP_ITEM_VERSION;
	[CCode (cheader_filename = "purple.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "purple.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "purple.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "purple.h")]
	public const int NO_TZ_OFF;
	[CCode (cheader_filename = "purple.h")]
	public const int PLUGINS;
	[CCode (cheader_filename = "purple.h")]
	public const int PLUGIN_FLAG_INVISIBLE;
	[CCode (cheader_filename = "purple.h")]
	public const int PLUGIN_MAGIC;
	[CCode (cheader_filename = "purple.h")]
	public const int PMP_LIFETIME;
	[CCode (cheader_filename = "purple.h")]
	public const int PRIORITY_DEFAULT;
	[CCode (cheader_filename = "purple.h")]
	public const int PRIORITY_HIGHEST;
	[CCode (cheader_filename = "purple.h")]
	public const int PRIORITY_LOWEST;
	[CCode (cheader_filename = "purple.h")]
	public const int SIGNAL_PRIORITY_DEFAULT;
	[CCode (cheader_filename = "purple.h")]
	public const int SIGNAL_PRIORITY_HIGHEST;
	[CCode (cheader_filename = "purple.h")]
	public const int SIGNAL_PRIORITY_LOWEST;
	[CCode (cheader_filename = "purple.h")]
	public const int SSL_DEFAULT_PORT;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_ALBUM;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_ARTIST;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_COMMENT;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_FULL;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_GENRE;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_TIME;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_TITLE;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_TRACK;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_URL;
	[CCode (cheader_filename = "purple.h")]
	public const string TUNE_YEAR;
	[CCode (cheader_filename = "purple.h")]
	public static void accounts_add (Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static void accounts_delete (Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Account accounts_find (string name, string protocol);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Account accounts_find_any (string name, string protocol);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Account accounts_find_connected (string name, string protocol);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Account accounts_find_ext (string name, string protocol_id, GLib.Callback account_test);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List accounts_get_all ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List accounts_get_all_active ();
	[CCode (cheader_filename = "purple.h")]
	public static void* accounts_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.AccountUiOps accounts_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void accounts_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void accounts_remove (Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static void accounts_reorder (Purple.Account account, int new_index);
	[CCode (cheader_filename = "purple.h")]
	public static void accounts_restore_current_statuses ();
	[CCode (cheader_filename = "purple.h")]
	public static void accounts_set_ui_ops (Purple.AccountUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void accounts_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned uchar[] base16_decode (string str, size_t ret_len);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string base16_encode (uchar[] data, size_t len);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string base16_encode_chunked (uchar[] data, size_t len);
	[CCode (cheader_filename = "purple.h")]
	public static unowned uchar[] base64_decode (string str, size_t ret_len);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string base64_encode (uchar[] data, size_t len);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_add_account (Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_add_buddy (Purple.Buddy buddy, Purple.Contact contact, Purple.Group group, Purple.BlistNode node);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_add_chat (Purple.Chat chat, Purple.Group group, Purple.BlistNode node);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_add_contact (Purple.Contact contact, Purple.Group group, Purple.BlistNode node);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_add_group (Purple.Group group, Purple.BlistNode node);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_alias_buddy (Purple.Buddy buddy, string alias);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_alias_chat (Purple.Chat chat, string alias);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_alias_contact (Purple.Contact contact, string alias);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_destroy ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Chat blist_find_chat (Purple.Account account, string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.SList blist_get_buddies ();
	[CCode (cheader_filename = "purple.h")]
	public static int blist_get_group_online_count (Purple.Group group);
	[CCode (cheader_filename = "purple.h")]
	public static int blist_get_group_size (Purple.Group group, bool offline);
	[CCode (cheader_filename = "purple.h")]
	public static void* blist_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.BlistNode blist_get_root ();
	[CCode (cheader_filename = "purple.h")]
	public static void* blist_get_ui_data ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.BlistUiOps blist_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void blist_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void blist_load ();
	[CCode (cheader_filename = "purple.h")]
	public static void blist_merge_contact (Purple.Contact source, Purple.BlistNode node);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.BuddyList blist_new ();
	[CCode (cheader_filename = "purple.h")]
	public static void blist_remove_account (Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_remove_buddy (Purple.Buddy buddy);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_remove_chat (Purple.Chat chat);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_remove_contact (Purple.Contact contact);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_remove_group (Purple.Group group);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_rename_buddy (Purple.Buddy buddy, string name);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_rename_group (Purple.Group group, string name);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_request_add_buddy (Purple.Account account, string username, string group, string alias);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_request_add_chat (Purple.Account account, Purple.Group group, string alias, string name);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_request_add_group ();
	[CCode (cheader_filename = "purple.h")]
	public static void blist_schedule_save ();
	[CCode (cheader_filename = "purple.h")]
	public static void blist_server_alias_buddy (Purple.Buddy buddy, string alias);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_set_ui_data (void* ui_data);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_set_ui_ops (Purple.BlistUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_set_visible (bool show);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_show ();
	[CCode (cheader_filename = "purple.h")]
	public static void blist_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void blist_update_buddy_icon (Purple.Buddy buddy);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_update_buddy_status (Purple.Buddy buddy, Purple.Status old_status);
	[CCode (cheader_filename = "purple.h")]
	public static void blist_update_node_icon (Purple.BlistNode node);
	[CCode (cheader_filename = "purple.h")]
	public static int build_dir (string path, int mode);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Cipher ciphers_find_cipher (string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List ciphers_get_ciphers ();
	[CCode (cheader_filename = "purple.h")]
	public static void* ciphers_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static void ciphers_init ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Cipher ciphers_register_cipher (string name, Purple.CipherOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void ciphers_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static bool ciphers_unregister_cipher (Purple.Cipher cipher);
	[CCode (cheader_filename = "purple.h")]
	public static Purple.CmdStatus cmd_do_command (Purple.Conversation conv, string cmdline, string markup, string errormsg);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List cmd_help (Purple.Conversation conv, string cmd);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List cmd_list (Purple.Conversation conv);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.CmdId cmd_register (string cmd, string args, Purple.CmdPriority p, Purple.CmdFlag f, string prpl_id, Purple.CmdFunc func, string helpstr, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void cmd_unregister (Purple.CmdId id);
	[CCode (cheader_filename = "purple.h")]
	public static void* cmds_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static void cmds_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void cmds_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void connections_disconnect_all ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List connections_get_all ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List connections_get_connecting ();
	[CCode (cheader_filename = "purple.h")]
	public static void* connections_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.ConnectionUiOps connections_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void connections_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void connections_set_ui_ops (Purple.ConnectionUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void connections_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static bool conv_custom_smiley_add (Purple.Conversation conv, string smile, string cksum_type, string chksum, bool remote);
	[CCode (cheader_filename = "purple.h")]
	public static void conv_custom_smiley_close (Purple.Conversation conv, string smile);
	[CCode (cheader_filename = "purple.h")]
	public static void conv_custom_smiley_write (Purple.Conversation conv, string smile, uchar[] data, size_t size);
	[CCode (cheader_filename = "purple.h")]
	public static bool conv_present_error (string who, Purple.Account account, string what);
	[CCode (cheader_filename = "purple.h")]
	public static void conv_send_confirm (Purple.Conversation conv, string message);
	[CCode (cheader_filename = "purple.h")]
	public static void* conversations_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static void conversations_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void conversations_set_ui_ops (Purple.ConversationUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void conversations_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string date_format_full (void* tm);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string date_format_long (void* tm);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string date_format_short (void* tm);
	[CCode (cheader_filename = "purple.h")]
	public static void debug (Purple.DebugLevel level, string category, string format);
	[CCode (cheader_filename = "purple.h")]
	public static void debug_error (string category, string format);
	[CCode (cheader_filename = "purple.h")]
	public static void debug_fatal (string category, string format);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.DebugUiOps debug_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void debug_info (string category, string format);
	[CCode (cheader_filename = "purple.h")]
	public static void debug_init ();
	[CCode (cheader_filename = "purple.h")]
	public static bool debug_is_enabled ();
	[CCode (cheader_filename = "purple.h")]
	public static bool debug_is_unsafe ();
	[CCode (cheader_filename = "purple.h")]
	public static bool debug_is_verbose ();
	[CCode (cheader_filename = "purple.h")]
	public static void debug_misc (string category, string format);
	[CCode (cheader_filename = "purple.h")]
	public static void debug_set_enabled (bool enabled);
	[CCode (cheader_filename = "purple.h")]
	public static void debug_set_ui_ops (Purple.DebugUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void debug_set_unsafe (bool unsafe);
	[CCode (cheader_filename = "purple.h")]
	public static void debug_set_verbose (bool verbose);
	[CCode (cheader_filename = "purple.h")]
	public static void debug_warning (string category, string format);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.DnsQueryData dnsquery_a (string hostname, int port, Purple.DnsQueryConnectFunction callback, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void dnsquery_destroy (Purple.DnsQueryData query_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string dnsquery_get_host (Purple.DnsQueryData query_data);
	[CCode (cheader_filename = "purple.h")]
	public static uint dnsquery_get_port (Purple.DnsQueryData query_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.DnsQueryUiOps dnsquery_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void dnsquery_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void dnsquery_set_ui_ops (Purple.DnsQueryUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void dnsquery_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static bool email_is_valid (string address);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string escape_filename (string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.EventLoopUiOps eventloop_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void eventloop_set_ui_ops (Purple.EventLoopUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string fd_get_ip (int fd);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.SList find_buddies (Purple.Account account, string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Buddy find_buddy (Purple.Account account, string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Buddy find_buddy_in_group (Purple.Account account, string name, Purple.Group group);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Conversation find_chat (Purple.Connection gc, int id);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Conversation find_conversation_with_account (Purple.ConversationType type, string name, Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Group find_group (string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Pounce find_pounce (Purple.Account pouncer, string pouncee, Purple.PounceEvent events);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Plugin find_prpl (string id);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string gai_strerror (int errnum);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.AttentionType get_attention_type_from_code (Purple.Account account, uint type_code);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.BuddyList get_blist ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List get_chats ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List get_conversations ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Core get_core ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string get_host_name ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List get_ims ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string get_tzoff_str (void* tm, bool iso);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.ProxyInfo global_proxy_get_info ();
	[CCode (cheader_filename = "purple.h")]
	public static void global_proxy_set_info (Purple.ProxyInfo info);
	[CCode (cheader_filename = "purple.h")]
	public static void got_protocol_handler_uri (string uri);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string home_dir ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.IdleUiOps idle_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void idle_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void idle_set (ulong time);
	[CCode (cheader_filename = "purple.h")]
	public static void idle_set_ui_ops (Purple.IdleUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void idle_touch ();
	[CCode (cheader_filename = "purple.h")]
	public static void idle_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.StoredImage imgstore_add (void* data, size_t size, string filename);
	[CCode (cheader_filename = "purple.h")]
	public static int imgstore_add_with_id (void* data, size_t size, string filename);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.StoredImage imgstore_find_by_id (int id);
	[CCode (cheader_filename = "purple.h")]
	public static void* imgstore_get_data (Purple.StoredImage img);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string imgstore_get_extension (Purple.StoredImage img);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string imgstore_get_filename (Purple.StoredImage img);
	[CCode (cheader_filename = "purple.h")]
	public static void* imgstore_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static size_t imgstore_get_size (Purple.StoredImage img);
	[CCode (cheader_filename = "purple.h")]
	public static void imgstore_init ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.StoredImage imgstore_new_from_file (string path);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.StoredImage imgstore_ref (Purple.StoredImage img);
	[CCode (cheader_filename = "purple.h")]
	public static void imgstore_ref_by_id (int id);
	[CCode (cheader_filename = "purple.h")]
	public static void imgstore_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.StoredImage imgstore_unref (Purple.StoredImage img);
	[CCode (cheader_filename = "purple.h")]
	public static void imgstore_unref_by_id (int id);
	[CCode (cheader_filename = "purple.h")]
	public static uint input_add (int fd, Purple.InputCondition cond, Purple.InputFunction func);
	[CCode (cheader_filename = "purple.h")]
	public static int input_get_error (int fd, int error);
	[CCode (cheader_filename = "purple.h")]
	public static bool input_remove (uint handle);
	[CCode (cheader_filename = "purple.h")]
	public static bool ip_address_is_valid (string ip);
	[CCode (cheader_filename = "purple.h")]
	public static bool ipv4_address_is_valid (string ip);
	[CCode (cheader_filename = "purple.h")]
	public static bool ipv6_address_is_valid (string ip);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string markup_escape_text (string text, ssize_t length);
	[CCode (cheader_filename = "purple.h")]
	public static bool markup_extract_info_field (string str, int len, Purple.NotifyUserInfo user_info, string start_token, int skip, string end_token, GLib.ObjectPath check_value, string no_value_token, string display_name, bool is_link, string link_prefix, Purple.InfoFieldFormatCallback format_cb);
	[CCode (cheader_filename = "purple.h")]
	public static bool markup_find_tag (string needle, string haystack, out string start, out string end, out GLib.Datalist attributes);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string markup_get_css_property (string style, string opt);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string markup_get_tag_name (string tag);
	[CCode (cheader_filename = "purple.h")]
	public static void markup_html_to_xhtml (string html, out unowned string dest_xhtml, out unowned string dest_plain);
	[CCode (cheader_filename = "purple.h")]
	public static bool markup_is_rtl (string html);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string markup_linkify (string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string markup_slice (string str, uint x, uint y);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string markup_strip_html (string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string markup_unescape_entity (string text, int length);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__INT_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER_POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER_POINTER_POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER_POINTER_POINTER_POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER_POINTER_POINTER_POINTER_POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER_POINTER_POINTER_POINTER_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER_POINTER_POINTER_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_BOOLEAN__POINTER_POINTER_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_INT__INT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_INT__INT_INT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_INT__POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_INT__POINTER_POINTER_POINTER_POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_POINTER__POINTER_INT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_POINTER__POINTER_INT64 (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_POINTER__POINTER_INT64_BOOLEAN (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_POINTER__POINTER_INT_BOOLEAN (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_POINTER__POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__INT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__INT_INT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_INT_INT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_INT_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER_POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER_POINTER_POINTER_POINTER (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER_POINTER_POINTER_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER_POINTER_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER_POINTER_UINT_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_POINTER_UINT_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static void marshal_VOID__POINTER_UINT (Purple.Callback cb, void* args, void* data, void* return_val);
	[CCode (cheader_filename = "purple.h")]
	public static bool message_meify (string message, ssize_t len);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string mime_decode_field (string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.FileStream mkstemp (out unowned string path, bool binary);
	[CCode (cheader_filename = "purple.h")]
	public static int network_convert_idn_to_ascii (string @in, string @out);
	[CCode (cheader_filename = "purple.h")]
	public static void network_force_online ();
	[CCode (cheader_filename = "purple.h")]
	public static void* network_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string network_get_local_system_ip (int fd);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string network_get_my_ip (int fd);
	[CCode (cheader_filename = "purple.h")]
	public static uint network_get_port_from_fd (int fd);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string network_get_public_ip ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string network_get_stun_ip ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string network_get_turn_ip ();
	[CCode (cheader_filename = "purple.h")]
	public static void network_init ();
	[CCode (cheader_filename = "purple.h")]
	public static uint network_ip_atoi (string ip);
	[CCode (cheader_filename = "purple.h")]
	public static bool network_is_available ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.NetworkListenData network_listen (uint port, int socket_type, Purple.NetworkListenCallback cb, void* cb_data);
	[CCode (cheader_filename = "purple.h")]
	public static void network_listen_cancel (Purple.NetworkListenData listen_data);
	[CCode (cheader_filename = "purple.h")]
	public static void network_listen_map_external (bool map_external);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.NetworkListenData network_listen_range (uint start, uint end, int socket_type, Purple.NetworkListenCallback cb, void* cb_data);
	[CCode (cheader_filename = "purple.h")]
	public static void network_remove_port_mapping (int fd);
	[CCode (cheader_filename = "purple.h")]
	public static void network_set_public_ip (string ip);
	[CCode (cheader_filename = "purple.h")]
	public static void network_set_stun_server (string stun_server);
	[CCode (cheader_filename = "purple.h")]
	public static void network_set_turn_server (string turn_server);
	[CCode (cheader_filename = "purple.h")]
	public static void network_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string normalize (Purple.Account account, string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string normalize_nocase (Purple.Account account, string str);
	[CCode (cheader_filename = "purple.h")]
	public static void notify_close (Purple.NotifyType type, void* ui_handle);
	[CCode (cheader_filename = "purple.h")]
	public static void notify_close_with_handle (void* handle);
	[CCode (cheader_filename = "purple.h")]
	public static void* notify_email (void* handle, string subject, string from, string to, string url, Purple.NotifyCloseCallback cb);
	[CCode (cheader_filename = "purple.h")]
	public static void* notify_emails (void* handle, size_t count, bool detailed, out unowned string subjects, out unowned string froms, out unowned string tos, out unowned string urls, Purple.NotifyCloseCallback cb);
	[CCode (cheader_filename = "purple.h")]
	public static void* notify_formatted (void* handle, string title, string primary, string secondary, string text, Purple.NotifyCloseCallback cb);
	[CCode (cheader_filename = "purple.h")]
	public static void* notify_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.NotifyUiOps notify_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void notify_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void* notify_message (void* handle, Purple.NotifyMsgType type, string title, string primary, string secondary, Purple.NotifyCloseCallback cb);
	[CCode (cheader_filename = "purple.h")]
	public static void* notify_searchresults (Purple.Connection gc, string title, string primary, string secondary, Purple.NotifySearchResults results, Purple.NotifyCloseCallback cb);
	[CCode (cheader_filename = "purple.h")]
	public static void notify_set_ui_ops (Purple.NotifyUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void notify_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void* notify_uri (void* handle, string uri);
	[CCode (cheader_filename = "purple.h")]
	public static void* notify_userinfo (Purple.Connection gc, string who, Purple.NotifyUserInfo user_info, Purple.NotifyCloseCallback cb);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string ntlm_gen_type1 (string hostname, string domain);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string ntlm_gen_type3 (string username, string passw, string hostname, string domain, uchar nonce, uint32 flags);
	[CCode (cheader_filename = "purple.h")]
	public static uchar ntlm_parse_type2 (string type2, uint32 flags);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_add_search_path (string path);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_destroy_all ();
	[CCode (cheader_filename = "purple.h")]
	public static bool plugins_enabled ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Plugin plugins_find_with_basename (string basename);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Plugin plugins_find_with_filename (string filename);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Plugin plugins_find_with_id (string id);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Plugin plugins_find_with_name (string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List plugins_get_all ();
	[CCode (cheader_filename = "purple.h")]
	public static void* plugins_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List plugins_get_loaded ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List plugins_get_protocols ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List plugins_get_search_paths ();
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_load_saved (string key);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_probe (string ext);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_register_load_notify_cb (GLib.Callback func, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_register_probe_notify_cb (GLib.Callback func, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_register_unload_notify_cb (GLib.Callback func, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_save_loaded (string key);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_unload (Purple.PluginType type);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_unload_all ();
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_unregister_load_notify_cb (GLib.Callback func);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_unregister_probe_notify_cb (GLib.Callback func);
	[CCode (cheader_filename = "purple.h")]
	public static void plugins_unregister_unload_notify_cb (GLib.Callback func);
	[CCode (cheader_filename = "purple.h")]
	public static bool pmp_create_map (Purple.PmpType type, uint privateport, uint publicport, int lifetime);
	[CCode (cheader_filename = "purple.h")]
	public static bool pmp_destroy_map (Purple.PmpType type, uint privateport);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string pmp_get_public_ip ();
	[CCode (cheader_filename = "purple.h")]
	public static void pmp_init ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List pounces_get_all ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List pounces_get_all_for_ui (string ui);
	[CCode (cheader_filename = "purple.h")]
	public static void* pounces_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static void pounces_init ();
	[CCode (cheader_filename = "purple.h")]
	public static bool pounces_load ();
	[CCode (cheader_filename = "purple.h")]
	public static void pounces_register_handler (string ui, Purple.PounceCb cb, GLib.Callback new_pounce, GLib.Callback free_pounce);
	[CCode (cheader_filename = "purple.h")]
	public static void pounces_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void pounces_unregister_handler (string ui);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_add_bool (string name, bool value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_add_int (string name, int value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_add_none (string name);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_add_path (string name, string value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_add_path_list (string name, GLib.List value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_add_string (string name, string value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_add_string_list (string name, GLib.List value);
	[CCode (cheader_filename = "purple.h")]
	public static uint prefs_connect_callback (void* handle, string name, Purple.PrefCallback cb, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_destroy ();
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_disconnect_by_handle (void* handle);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_disconnect_callback (uint callback_id);
	[CCode (cheader_filename = "purple.h")]
	public static bool prefs_exists (string name);
	[CCode (cheader_filename = "purple.h")]
	public static bool prefs_get_bool (string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List prefs_get_children_names (string name);
	[CCode (cheader_filename = "purple.h")]
	public static void* prefs_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static int prefs_get_int (string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string prefs_get_path (string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List prefs_get_path_list (string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string prefs_get_string (string name);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List prefs_get_string_list (string name);
	[CCode (cheader_filename = "purple.h")]
	public static Purple.PrefType prefs_get_type (string name);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_init ();
	[CCode (cheader_filename = "purple.h")]
	public static bool prefs_load ();
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_remove (string name);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_rename (string oldname, string newname);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_rename_boolean_toggle (string oldname, string newname);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_set_bool (string name, bool value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_set_generic (string name, void* value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_set_int (string name, int value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_set_path (string name, string value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_set_path_list (string name, GLib.List value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_set_string (string name, string value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_set_string_list (string name, GLib.List value);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_trigger_callback (string name);
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void prefs_update_old ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string primitive_get_id_from_type (Purple.StatusPrimitive type);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string primitive_get_name_from_type (Purple.StatusPrimitive type);
	[CCode (cheader_filename = "purple.h")]
	public static Purple.StatusPrimitive primitive_get_type_from_id (string id);
	[CCode (cheader_filename = "purple.h")]
	public static void print_utf8_to_console (GLib.FileStream filestream, string message);
	[CCode (cheader_filename = "purple.h")]
	public static void privacy_allow (Purple.Account account, string who, bool local, bool restore);
	[CCode (cheader_filename = "purple.h")]
	public static bool privacy_check (Purple.Account account, string who);
	[CCode (cheader_filename = "purple.h")]
	public static void privacy_deny (Purple.Account account, string who, bool local, bool restore);
	[CCode (cheader_filename = "purple.h")]
	public static bool privacy_deny_add (Purple.Account account, string name, bool local_only);
	[CCode (cheader_filename = "purple.h")]
	public static bool privacy_deny_remove (Purple.Account account, string name, bool local_only);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.PrivacyUiOps privacy_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void privacy_init ();
	[CCode (cheader_filename = "purple.h")]
	public static bool privacy_permit_add (Purple.Account account, string name, bool local_only);
	[CCode (cheader_filename = "purple.h")]
	public static bool privacy_permit_remove (Purple.Account account, string name, bool local_only);
	[CCode (cheader_filename = "purple.h")]
	public static void privacy_set_ui_ops (Purple.PrivacyUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static bool program_is_valid (string program);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.ProxyConnectData proxy_connect (void* handle, Purple.Account account, string host, int port, Purple.ProxyConnectFunction connect_cb, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void proxy_connect_cancel (Purple.ProxyConnectData connect_data);
	[CCode (cheader_filename = "purple.h")]
	public static void proxy_connect_cancel_with_handle (void* handle);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.ProxyConnectData proxy_connect_socks5 (void* handle, Purple.ProxyInfo gpi, string host, int port, Purple.ProxyConnectFunction connect_cb, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.ProxyConnectData proxy_connect_udp (void* handle, Purple.Account account, string host, int port, Purple.ProxyConnectFunction connect_cb, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void* proxy_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.ProxyInfo proxy_get_setup (Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static void proxy_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void proxy_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_change_account_status (Purple.Account account, Purple.Status old_status, Purple.Status new_status);
	[CCode (cheader_filename = "purple.h")]
	public static Purple.MediaCaps prpl_get_media_caps (Purple.Account account, string who);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List prpl_get_statuses (Purple.Account account, Purple.Presence presence);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_account_actions (Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_account_idle (Purple.Account account, bool idle, ulong idle_time);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_account_login_time (Purple.Account account, ulong login_time);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_account_status (Purple.Account account, string status_id);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_attention (Purple.Connection gc, string who, uint type_code);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_attention_in_chat (Purple.Connection gc, int id, string who, uint type_code);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_user_idle (Purple.Account account, string name, bool idle, ulong idle_time);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_user_login_time (Purple.Account account, string name, ulong login_time);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_user_status (Purple.Account account, string name, string status_id);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_got_user_status_deactive (Purple.Account account, string name, string status_id);
	[CCode (cheader_filename = "purple.h")]
	public static bool prpl_initiate_media (Purple.Account account, string who, Purple.MediaSessionType type);
	[CCode (cheader_filename = "purple.h")]
	public static void prpl_send_attention (Purple.Connection gc, string who, uint type_code);
	[CCode (cheader_filename = "purple.h")]
	public static unowned uchar[] quotedp_decode (string str, size_t ret_len);
	[CCode (cheader_filename = "purple.h")]
	public static void* request_action (void* handle, string title, string primary, string secondary, int default_action, Purple.Account account, string who, Purple.Conversation conv, size_t action_count);
	[CCode (cheader_filename = "purple.h")]
	public static void* request_action_varg (void* handle, string title, string primary, string secondary, int default_action, Purple.Account account, string who, Purple.Conversation conv, size_t action_count, void* actions);
	[CCode (cheader_filename = "purple.h")]
	public static void* request_choice (void* handle, string title, string primary, string secondary, int default_value, string ok_text, GLib.Callback ok_cb, string cancel_text, GLib.Callback cancel_cb, Purple.Account account, string who, Purple.Conversation conv);
	[CCode (cheader_filename = "purple.h")]
	public static void* request_choice_varg (void* handle, string title, string primary, string secondary, int default_value, string ok_text, GLib.Callback ok_cb, string cancel_text, GLib.Callback cancel_cb, Purple.Account account, string who, Purple.Conversation conv, void* choices);
	[CCode (cheader_filename = "purple.h")]
	public static void request_close (Purple.RequestType type, void* uihandle);
	[CCode (cheader_filename = "purple.h")]
	public static void request_close_with_handle (void* handle);
	[CCode (cheader_filename = "purple.h")]
	public static void* request_fields (void* handle, string title, string primary, string secondary, Purple.RequestFields fields, string ok_text, GLib.Callback ok_cb, string cancel_text, GLib.Callback cancel_cb, Purple.Account account, string who, Purple.Conversation conv);
	[CCode (cheader_filename = "purple.h")]
	public static void* request_file (void* handle, string title, string filename, bool savedialog, GLib.Callback ok_cb, GLib.Callback cancel_cb, Purple.Account account, string who, Purple.Conversation conv);
	[CCode (cheader_filename = "purple.h")]
	public static void* request_folder (void* handle, string title, string dirname, GLib.Callback ok_cb, GLib.Callback cancel_cb, Purple.Account account, string who, Purple.Conversation conv);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.RequestUiOps request_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void* request_input (void* handle, string title, string primary, string secondary, string default_value, bool multiline, bool masked, string hint, string ok_text, GLib.Callback ok_cb, string cancel_text, GLib.Callback cancel_cb, Purple.Account account, string who, Purple.Conversation conv);
	[CCode (cheader_filename = "purple.h")]
	public static void request_set_ui_ops (Purple.RequestUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void restore_default_signal_handlers ();
	[CCode (cheader_filename = "purple.h")]
	public static bool running_gnome ();
	[CCode (cheader_filename = "purple.h")]
	public static bool running_kde ();
	[CCode (cheader_filename = "purple.h")]
	public static bool running_osx ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List savedstatuses_get_all ();
	[CCode (cheader_filename = "purple.h")]
	public static void* savedstatuses_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List savedstatuses_get_popular (uint how_many);
	[CCode (cheader_filename = "purple.h")]
	public static void savedstatuses_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void savedstatuses_uninit ();
	[CCode (cheader_filename = "purple.h", cname = "serv_add_deny")]
	public static void serv_add_deny (Purple.Connection p1, string p2);
	[CCode (cheader_filename = "purple.h", cname = "serv_add_permit")]
	public static void serv_add_permit (Purple.Connection p1, string p2);
	[CCode (cheader_filename = "purple.h", cname = "serv_alias_buddy")]
	public static void serv_alias_buddy (Purple.Buddy p1);
	[CCode (cheader_filename = "purple.h", cname = "serv_chat_invite")]
	public static void serv_chat_invite (Purple.Connection p1, int p2, string p3, string p4);
	[CCode (cheader_filename = "purple.h", cname = "serv_chat_leave")]
	public static void serv_chat_leave (Purple.Connection p1, int p2);
	[CCode (cheader_filename = "purple.h", cname = "serv_chat_send")]
	public static int serv_chat_send (Purple.Connection p1, int p2, string p3, Purple.MessageFlags flags);
	[CCode (cheader_filename = "purple.h", cname = "serv_chat_whisper")]
	public static void serv_chat_whisper (Purple.Connection p1, int p2, string p3, string p4);
	[CCode (cheader_filename = "purple.h", cname = "serv_get_info")]
	public static void serv_get_info (Purple.Connection p1, string p2);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_alias")]
	public static void serv_got_alias (Purple.Connection gc, string who, string alias);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_attention")]
	public static void serv_got_attention (Purple.Connection gc, string who, uint type_code);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_chat_in")]
	public static void serv_got_chat_in (Purple.Connection g, int id, string who, Purple.MessageFlags flags, string message, ulong mtime);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_chat_invite")]
	public static void serv_got_chat_invite (Purple.Connection gc, string name, string who, string message, GLib.HashTable data);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_chat_left")]
	public static void serv_got_chat_left (Purple.Connection g, int id);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_im")]
	public static void serv_got_im (Purple.Connection gc, string who, string msg, Purple.MessageFlags flags, ulong mtime);
	[CCode (cheader_filename = "purple.h")]
	public static void serv_got_join_chat_failed (Purple.Connection gc, GLib.HashTable data);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_joined_chat")]
	public static unowned Purple.Conversation serv_got_joined_chat (Purple.Connection gc, int id, string name);
	[CCode (cheader_filename = "purple.h")]
	public static void serv_got_private_alias (Purple.Connection gc, string who, string alias);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_typing")]
	public static void serv_got_typing (Purple.Connection gc, string name, int timeout, Purple.TypingState state);
	[CCode (cheader_filename = "purple.h", cname = "serv_got_typing_stopped")]
	public static void serv_got_typing_stopped (Purple.Connection gc, string name);
	[CCode (cheader_filename = "purple.h", cname = "serv_join_chat")]
	public static void serv_join_chat (Purple.Connection p1, GLib.HashTable data);
	[CCode (cheader_filename = "purple.h", cname = "serv_move_buddy")]
	public static void serv_move_buddy (Purple.Buddy p1, Purple.Group p2, Purple.Group p3);
	[CCode (cheader_filename = "purple.h", cname = "serv_reject_chat")]
	public static void serv_reject_chat (Purple.Connection p1, GLib.HashTable data);
	[CCode (cheader_filename = "purple.h", cname = "serv_rem_deny")]
	public static void serv_rem_deny (Purple.Connection p1, string p2);
	[CCode (cheader_filename = "purple.h", cname = "serv_rem_permit")]
	public static void serv_rem_permit (Purple.Connection p1, string p2);
	[CCode (cheader_filename = "purple.h", cname = "serv_send_attention")]
	public static void serv_send_attention (Purple.Connection gc, string who, uint type_code);
	[CCode (cheader_filename = "purple.h", cname = "serv_send_file")]
	public static void serv_send_file (Purple.Connection gc, string who, string file);
	[CCode (cheader_filename = "purple.h", cname = "serv_send_im")]
	public static int serv_send_im (Purple.Connection p1, string p2, string p3, Purple.MessageFlags flags);
	[CCode (cheader_filename = "purple.h", cname = "serv_send_typing")]
	public static uint serv_send_typing (Purple.Connection gc, string name, Purple.TypingState state);
	[CCode (cheader_filename = "purple.h", cname = "serv_set_info")]
	public static void serv_set_info (Purple.Connection p1, string p2);
	[CCode (cheader_filename = "purple.h", cname = "serv_set_permit_deny")]
	public static void serv_set_permit_deny (Purple.Connection p1);
	[CCode (cheader_filename = "purple.h")]
	public static void set_blist (Purple.BuddyList blist);
	[CCode (cheader_filename = "purple.h")]
	public static ulong signal_connect (void* instance, string @signal, void* handle, Purple.Callback func, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static ulong signal_connect_priority (void* instance, string @signal, void* handle, Purple.Callback func, void* data, int priority);
	[CCode (cheader_filename = "purple.h")]
	public static ulong signal_connect_priority_vargs (void* instance, string @signal, void* handle, Purple.Callback func, void* data, int priority);
	[CCode (cheader_filename = "purple.h")]
	public static ulong signal_connect_vargs (void* instance, string @signal, void* handle, Purple.Callback func, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static void signal_disconnect (void* instance, string @signal, void* handle, Purple.Callback func);
	[CCode (cheader_filename = "purple.h")]
	public static void signal_emit (void* instance, string @signal);
	[CCode (cheader_filename = "purple.h")]
	public static void* signal_emit_return_1 (void* instance, string @signal);
	[CCode (cheader_filename = "purple.h")]
	public static void signal_emit_vargs (void* instance, string @signal, void* args);
	[CCode (cheader_filename = "purple.h")]
	public static void* signal_emit_vargs_return_1 (void* instance, string @signal, void* args);
	[CCode (cheader_filename = "purple.h")]
	public static void signal_get_values (void* instance, string @signal, out unowned Purple.Value ret_value, int num_values, out unowned Purple.Value values);
	[CCode (cheader_filename = "purple.h")]
	public static ulong signal_register (void* instance, string @signal, Purple.SignalMarshalFunc marshal, Purple.Value ret_value, int num_values);
	[CCode (cheader_filename = "purple.h")]
	public static void signal_unregister (void* instance, string @signal);
	[CCode (cheader_filename = "purple.h")]
	public static void signals_disconnect_by_handle (void* handle);
	[CCode (cheader_filename = "purple.h")]
	public static void signals_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void signals_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void signals_unregister_by_instance (void* instance);
	[CCode (cheader_filename = "purple.h")]
	public static void smarshal_BOOLEAN__OBJECT_POINTER_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "purple.h")]
	public static void smarshal_VOID__ENUM_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "purple.h")]
	public static void smarshal_VOID__ENUM_STRING_STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "purple.h")]
	public static void smarshal_VOID__POINTER_POINTER_OBJECT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "purple.h")]
	public static void smarshal_VOID__STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "purple.h")]
	public static void smarshal_VOID__STRING_STRING_DOUBLE (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Smiley smileys_find_by_checksum (string checksum);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.Smiley smileys_find_by_shortcut (string shortcut);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List smileys_get_all ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string smileys_get_storing_dir ();
	[CCode (cheader_filename = "purple.h")]
	public static void smileys_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void smileys_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.SoundUiOps sound_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void sound_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void sound_play_event (Purple.SoundEventID event, Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static void sound_play_file (string filename, Purple.Account account);
	[CCode (cheader_filename = "purple.h")]
	public static void sound_set_ui_ops (Purple.SoundUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void sound_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static void* sounds_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static void srv_cancel (Purple.SrvQueryData query_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.SrvQueryData srv_resolve (string protocol, string transport, string domain, Purple.SrvCallback cb, void* extradata);
	[CCode (cheader_filename = "purple.h")]
	public static void ssl_close (Purple.SslConnection gsc);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.SslConnection ssl_connect (Purple.Account account, string host, int port, Purple.SslInputFunction func, Purple.SslErrorFunction error_func, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.SslConnection ssl_connect_fd (Purple.Account account, int fd, Purple.SslInputFunction func, Purple.SslErrorFunction error_func, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.SslConnection ssl_connect_with_host_fd (Purple.Account account, int fd, Purple.SslInputFunction func, Purple.SslErrorFunction error_func, string host, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.SslConnection ssl_connect_with_ssl_cn (Purple.Account account, string host, int port, Purple.SslInputFunction func, Purple.SslErrorFunction error_func, string ssl_host, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.SslOps ssl_get_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List ssl_get_peer_certificates (Purple.SslConnection gsc);
	[CCode (cheader_filename = "purple.h")]
	public static void ssl_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void ssl_input_add (Purple.SslConnection gsc, Purple.SslInputFunction func, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static bool ssl_is_supported ();
	[CCode (cheader_filename = "purple.h")]
	public static size_t ssl_read (Purple.SslConnection gsc, void* buffer, size_t len);
	[CCode (cheader_filename = "purple.h")]
	public static void ssl_set_ops (Purple.SslOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string ssl_strerror (Purple.SslErrorType error);
	[CCode (cheader_filename = "purple.h")]
	public static void ssl_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static size_t ssl_write (Purple.SslConnection gsc, void* buffer, size_t len);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string str_add_cr (string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string str_binary_to_ascii (uint binary, uint len);
	[CCode (cheader_filename = "purple.h")]
	public static bool str_has_prefix (string s, string p);
	[CCode (cheader_filename = "purple.h")]
	public static bool str_has_suffix (string s, string x);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string str_seconds_to_string (uint sec);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string str_size_to_units (size_t size);
	[CCode (cheader_filename = "purple.h")]
	public static void str_strip_char (string str, GLib.ObjectPath thechar);
	[CCode (cheader_filename = "purple.h")]
	public static ulong str_to_time (string timestamp, bool utc, void* tm, long tz_off, out unowned string rest);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string strcasereplace (string str, string delimiter, string replacement);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string strcasestr (string haystack, string needle);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string strdup_withhtml (string src);
	[CCode (cheader_filename = "purple.h")]
	public static bool strequal (string left, string right);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string strreplace (string str, string delimiter, string replacement);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.StunNatDiscovery stun_discover (Purple.StunCallback cb);
	[CCode (cheader_filename = "purple.h")]
	public static void stun_init ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned string text_strip_mnemonic (string @in);
	[CCode (cheader_filename = "purple.h")]
	public static ulong time_build (int year, int month, int day, int hour, int min, int sec);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string time_format (void* tm);
	[CCode (cheader_filename = "purple.h")]
	public static uint timeout_add (uint interval, GLib.SourceFunc function, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static uint timeout_add_seconds (uint interval, GLib.SourceFunc function, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static bool timeout_remove (uint handle);
	[CCode (cheader_filename = "purple.h")]
	public static void txt_cancel (Purple.SrvQueryData query_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.SrvQueryData txt_resolve (string owner, string domain, Purple.TxtCallback cb, void* extradata);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string unescape_filename (string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string unescape_html (string html);
	[CCode (cheader_filename = "purple.h")]
	public static void upnp_cancel_port_mapping (Purple.UPnPMappingAddRemove mapping_data);
	[CCode (cheader_filename = "purple.h")]
	public static void upnp_discover (Purple.UPnPCallback cb, void* cb_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string upnp_get_public_ip ();
	[CCode (cheader_filename = "purple.h")]
	public static void upnp_init ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.UPnPMappingAddRemove upnp_remove_port_mapping (uint portmap, string protocol, Purple.UPnPCallback cb, void* cb_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.UPnPMappingAddRemove upnp_set_port_mapping (uint portmap, string protocol, Purple.UPnPCallback cb, void* cb_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List uri_list_extract_filenames (string uri_list);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List uri_list_extract_uris (string uri_list);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string url_decode (string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string url_encode (string str);
	[CCode (cheader_filename = "purple.h")]
	public static bool url_parse (string url, out unowned string ret_host, int ret_port, out unowned string ret_path, out unowned string ret_user, out unowned string ret_passwd);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string user_dir ();
	[CCode (cheader_filename = "purple.h")]
	public static bool utf8_has_word (string haystack, string needle);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string utf8_ncr_decode (string @in);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string utf8_ncr_encode (string @in);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string utf8_salvage (string str);
	[CCode (cheader_filename = "purple.h")]
	public static int utf8_strcasecmp (string a, string b);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string utf8_strftime (string format, void* tm);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string utf8_strip_unprintables (string str);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string utf8_try_convert (string str);
	[CCode (cheader_filename = "purple.h")]
	public static void util_chrreplace (string str, GLib.ObjectPath delimiter, GLib.ObjectPath replacement);
	[CCode (cheader_filename = "purple.h")]
	public static void util_fetch_url_cancel (Purple.UtilFetchUrlData url_data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.UtilFetchUrlData util_fetch_url_request (string url, bool full, string user_agent, bool http11, string request, bool include_headers, Purple.UtilFetchUrlCallback callback, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.UtilFetchUrlData util_fetch_url_request_len (string url, bool full, string user_agent, bool http11, string request, bool include_headers, ssize_t max_len, Purple.UtilFetchUrlCallback callback, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.UtilFetchUrlData util_fetch_url_request_len_with_account (Purple.Account account, string url, bool full, string user_agent, bool http11, string request, bool include_headers, ssize_t max_len, Purple.UtilFetchUrlCallback callback, void* data);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string util_format_song_info (string title, string artist, string album, void* unused);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string util_get_image_checksum (void* image_data, size_t image_len);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string util_get_image_extension (void* data, size_t len);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string util_get_image_filename (void* image_data, size_t image_len);
	[CCode (cheader_filename = "purple.h")]
	public static void util_init ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.xmlnode util_read_xml_from_file (string filename, string description);
	[CCode (cheader_filename = "purple.h")]
	public static void util_set_current_song (string title, string artist, string album);
	[CCode (cheader_filename = "purple.h")]
	public static void util_set_user_dir (string dir);
	[CCode (cheader_filename = "purple.h")]
	public static void util_uninit ();
	[CCode (cheader_filename = "purple.h")]
	public static bool util_write_data_to_file (string filename, string data, ssize_t size);
	[CCode (cheader_filename = "purple.h")]
	public static bool util_write_data_to_file_absolute (string filename_full, string data, ssize_t size);
	[CCode (cheader_filename = "purple.h")]
	public static unowned string version_check (uint required_major, uint required_minor, uint required_micro);
	[CCode (cheader_filename = "purple.h")]
	public static unowned GLib.List xfers_get_all ();
	[CCode (cheader_filename = "purple.h")]
	public static void* xfers_get_handle ();
	[CCode (cheader_filename = "purple.h")]
	public static unowned Purple.XferUiOps xfers_get_ui_ops ();
	[CCode (cheader_filename = "purple.h")]
	public static void xfers_init ();
	[CCode (cheader_filename = "purple.h")]
	public static void xfers_set_ui_ops (Purple.XferUiOps ops);
	[CCode (cheader_filename = "purple.h")]
	public static void xfers_uninit ();
}
