#line 2 "libxlu_disk_l.c"
#line 31 "libxlu_disk_l.l"
#include "libxl_osdeps.h" /* must come before any other headers */



#line 8 "libxlu_disk_l.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE xlu__disk_yyrestart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via xlu__disk_yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void xlu__disk_yyrestart (FILE *input_file ,yyscan_t yyscanner );
void xlu__disk_yy_switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE xlu__disk_yy_create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void xlu__disk_yy_delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void xlu__disk_yy_flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void xlu__disk_yypush_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void xlu__disk_yypop_buffer_state (yyscan_t yyscanner );

static void xlu__disk_yyensure_buffer_stack (yyscan_t yyscanner );
static void xlu__disk_yy_load_buffer_state (yyscan_t yyscanner );
static void xlu__disk_yy_init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER xlu__disk_yy_flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE xlu__disk_yy_scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE xlu__disk_yy_scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE xlu__disk_yy_scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

void *xlu__disk_yyalloc (yy_size_t ,yyscan_t yyscanner );
void *xlu__disk_yyrealloc (void *,yy_size_t ,yyscan_t yyscanner );
void xlu__disk_yyfree (void * ,yyscan_t yyscanner );

#define yy_new_buffer xlu__disk_yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        xlu__disk_yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            xlu__disk_yy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        xlu__disk_yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            xlu__disk_yy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

#define xlu__disk_yywrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyg->yytext_ptr -= yyg->yy_more_len; \
	yyleng = (size_t) (yy_cp - yyg->yytext_ptr); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 29
#define YY_END_OF_BUFFER 30
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_acclist[490] =
    {   0,
       28,   28,   30,   26,   27,   29, 8193,   26,   27,   29,
    16385, 8193,   26,   29,16385,   26,   27,   29,   27,   29,
       26,   27,   29,   26,   27,   29,   26,   27,   29,   26,
       27,   29,   26,   27,   29,   26,   27,   29,   26,   27,
       29,   26,   27,   29,   26,   27,   29,   26,   27,   29,
       26,   27,   29,   26,   27,   29,   26,   27,   29,   26,
       27,   29,   26,   27,   29,   28,   29,   29,   26,   26,
     8193,   26, 8193,   26,16385, 8193,   26, 8193,   26,   26,
     8217,   26,16409,   26,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   26,   26,   26,   26,

       26,   26,   26,   26,   28, 8193,   26, 8193,   26, 8193,
     8217,   26, 8217,   26, 8217,   16,   26,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   26, 8217,   26, 8217,
       26, 8217,   16,   26,   21, 8217,   26,16409,   26,   26,
       26,   26,   26,   26,   26,   26,   26, 8210, 8217,   26,
    16402,16409,   26,   24, 8217,   26,16409,   26, 8209, 8217,
       26,16401,16409,   26,   26, 8212, 8217,   26,16404,16409,
       26,   26,   26,   26,   21, 8217,   26,   21, 8217,   26,
       21,   26,   21, 8217,   26,    3,   26,   26,   26,   26,

       23, 8217,   26,16409,   26,   26, 8210, 8217,   26, 8210,
     8217,   26, 8210,   26, 8210, 8217,   26,   24, 8217,   26,
       24, 8217,   26,   24,   26,   24, 8217, 8209, 8217,   26,
     8209, 8217,   26, 8209,   26, 8209, 8217,   26, 8212, 8217,
       26, 8212, 8217,   26, 8212,   26, 8212, 8217,   26,   26,
       10,   26,   21, 8217,   26,   21, 8217,   26,   21, 8217,
       21,   26,   21,   26,    3,   26,   26,   26,   26,   23,
     8217,   26,   23, 8217,   26,   23,   26,   23, 8217,   26,
       22, 8217,   26,16409, 8210, 8217,   26, 8210, 8217,   26,
     8210, 8217, 8210,   26, 8210,   26,   24, 8217,   26,   24,

     8217,   26,   24, 8217,   24,   26,   24, 8209, 8217,   26,
     8209, 8217,   26, 8209, 8217, 8209,   26, 8209,   26, 8212,
     8217,   26, 8212, 8217,   26, 8212, 8217, 8212,   26, 8212,
       26,   26,   10,   16,   10,    7,   26,   26,   26,   13,
       26,   23, 8217,   26,   23, 8217,   26,   23, 8217,   23,
       26,   23,    2,   22, 8217,   26,   22, 8217,   26,   22,
       26,   22, 8217,   26,   11,   26,   15,   10,   10,   16,
        7,   16,    7,    8,   26,    6,   26,   13,   26,    2,
       16,    2,   22, 8217,   26,   22, 8217,   26,   22, 8217,
       22,   26,   22,   26,   11,   16,   11,   19, 8217,   26,

    16409,   15,   16,   15,    7,    7,   16,    8,   16,    8,
       26,    6,   16,    6,    6,   16,    6,   16,   26,    2,
        2,   16,   26,   11,   11,   16,   19, 8217,   26,   19,
     8217,   26,   19,   26,   19, 8217,   15,   16,    8,    8,
       16,   26,    6,    6,   16,    6,    6,   26,   14,   26,
       19, 8217,   26,   19, 8217,   26,   19, 8217,   19,   26,
       19,   26,    6,    6,   26,   14,   26,    9,    6,    5,
        6,   26,    9,   16,    9,    4,    6,    5,    6,   26,
        9,    9,   16,    4,    6,   12,   26,   12,   26
    } ;

static yyconst flex_int16_t yy_accept[287] =
    {   0,
        1,    1,    1,    2,    3,    4,    7,   12,   16,   19,
       21,   24,   27,   30,   33,   36,   39,   42,   45,   48,
       51,   54,   57,   60,   63,   66,   68,   69,   70,   71,
       73,   76,   78,   79,   80,   81,   84,   84,   85,   86,
       87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
       97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
      108,  110,  111,  113,  115,  116,  117,  118,  119,  120,
      121,  122,  123,  124,  125,  126,  127,  128,  129,  130,
      131,  132,  133,  134,  135,  136,  137,  138,  140,  142,
      143,  144,  145,  149,  150,  151,  152,  153,  154,  155,

      156,  157,  158,  163,  164,  168,  169,  174,  175,  176,
      181,  182,  183,  184,  185,  188,  191,  193,  195,  196,
      198,  199,  200,  201,  205,  206,  207,  210,  213,  215,
      217,  218,  221,  224,  226,  228,  231,  234,  236,  238,
      239,  242,  245,  247,  249,  250,  251,  252,  253,  256,
      259,  261,  263,  264,  265,  267,  268,  269,  270,  273,
      276,  278,  280,  281,  285,  288,  291,  293,  295,  296,
      297,  300,  303,  305,  307,  308,  311,  314,  316,  318,
      319,  320,  323,  326,  328,  330,  331,  332,  333,  335,
      336,  337,  338,  339,  340,  342,  345,  348,  350,  352,

      353,  354,  357,  360,  362,  364,  365,  366,  367,  368,
      369,  371,  373,  374,  375,  376,  377,  378,  380,  382,
      383,  386,  389,  391,  393,  394,  395,  397,  398,  402,
      404,  405,  406,  408,  410,  411,  412,  414,  415,  417,
      419,  420,  421,  423,  424,  425,  427,  430,  433,  435,
      437,  439,  440,  442,  443,  444,  446,  447,  448,  449,
      451,  454,  457,  459,  461,  462,  463,  464,  465,  466,
      468,  469,  470,  472,  473,  475,  476,  478,  480,  481,
      482,  484,  486,  488,  490,  490
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    4,    5,    1,    1,    6,    6,    7,
        6,    6,    6,    6,    6,    6,    6,    8,    1,    1,
        9,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,   10,   11,   12,   13,

       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   19,
       33,   19,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[34] =
    {   0,
        1,    1,    2,    3,    1,    1,    1,    1,    4,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[345] =
    {   0,
        0,    0,  714,  713,  715,  700,   32,   35,  718,  718,
       44,   62,   30,   41,   50,   51,  690,   64,   66,   40,
       68,  674,   69,  662,   72,    0,  718,  640,  718,   90,
       93,    0,    0,  102,  622,  111,    0,   74,   77,   88,
       81,   97,   99,  107,  111,  113,  114,   44,  119,  120,
      127,  115,  125,  126,  128,  129,  130,  132,    0,  143,
        0,    0,  156,    0,    0,  616,  143,  153,  152,  140,
      141,  157,  156,  163,  164,  159,  165,  167,  172,  195,
      175,  169,  176,  182,  181,  195,  183,  203,    0,    0,
      718,  192,  220,  199,  205,  200,  206,  606,  209,  602,

      216,  220,  246,  218,  255,  227,  264,  251,  231,  276,
      222,  260,  233,  234,  279,    0,  283,    0,  279,  286,
      281,  242,  283,  310,  265,  287,  295,    0,  313,    0,
      292,  320,    0,  322,    0,  324,    0,  331,    0,  320,
      333,    0,  335,    0,  293,  322,  604,  291,  343,    0,
        0,    0,    0,  335,  718,  340,  348,  346,  357,    0,
      359,    0,  298,  368,  371,    0,    0,    0,    0,  352,
      375,    0,    0,    0,    0,  378,    0,    0,    0,    0,
      376,  385,    0,    0,    0,    0,  347,  381,  596,  718,
      588,  383,  386,  384,  394,  396,    0,    0,    0,    0,

      580,  404,    0,  406,    0,  393,  572,  333,  413,  564,
      718,  556,  718,  544,  391,  407,  401,  718,  516,  718,
      418,    0,    0,    0,    0,  405,  509,  718,  432,  500,
        0,  492,  718,  474,  718,  413,  473,  718,  426,  424,
      240,  472,  718,  461,  425,  718,  440,    0,  442,    0,
        0,  379,  718,  438,  351,  718,  427,  422,  434,  451,
      454,    0,    0,    0,    0,  450,  449,  452,  455,  718,
      305,  457,  186,  454,  139,  718,   79,  718,  457,   38,
      718,  718,  462,  718,  718,  479,  483,  486,  490,  494,
      498,  502,  506,  510,  514,  518,  522,  526,  530,  534,

      538,  542,  546,  550,  554,  558,  562,  566,  570,  574,
      578,  582,  586,  590,  594,  598,  602,  606,  610,  614,
      618,  622,  626,  630,  634,  638,  642,  646,  650,  654,
      658,  662,  666,  670,  674,  678,  682,  686,  690,  694,
      698,  702,  706,  710
    } ;

static yyconst flex_int16_t yy_def[345] =
    {   0,
      285,    1,  286,  286,  285,  287,  288,  288,  285,  285,
      289,  289,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,  290,  285,  287,  285,  291,
      288,  292,  292,  293,   12,  287,  294,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,  290,  291,
      292,  292,  295,  296,  296,  285,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,  293,
       12,   12,   12,   12,   12,   12,   12,  295,  296,  296,
      285,   12,  297,   12,   12,   12,   12,   12,   12,   12,

       12,   12,  298,   80,  299,   12,  300,   12,   12,  301,
       12,   12,   12,   12,  302,  303,  297,  303,   12,   12,
       12,   12,   12,  304,   12,   12,  305,  306,  298,  306,
       80,  307,  308,  299,  308,  309,  310,  300,  310,   12,
      311,  312,  301,  312,   12,   12,  313,   12,  302,  303,
      303,  314,  314,   12,  285,   12,   12,   12,  315,  316,
      304,  316,   12,  317,  305,  306,  306,  318,  318,   80,
      307,  308,  308,  319,  319,  309,  310,  310,  320,  320,
       12,  311,  312,  312,  321,  321,   12,   12,  322,  285,
      323,   12,   12,   80,   12,  315,  316,  316,  324,  324,

      325,  326,  327,  317,  327,   80,  328,   12,  329,  322,
      285,  330,  285,  331,   12,  332,   80,  285,  333,  285,
      326,  327,  327,  334,  334,   80,  335,  285,  336,  337,
      337,  330,  285,  338,  285,   12,  339,  285,  339,  339,
       80,  333,  285,   80,  335,  285,  340,  341,  336,  341,
      337,  338,  285,   12,  339,  285,  339,  339,   80,   80,
      340,  341,  341,  342,  342,   12,  339,  339,   80,  285,
      343,  339,  339,   80,  344,  285,  339,  285,   80,  344,
      285,  285,   80,  285,    0,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,

      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285
    } ;

static yyconst flex_int16_t yy_nxt[752] =
    {   0,
        6,    7,    8,    9,    6,    6,    6,    6,   10,   11,
       12,   13,   14,   15,   16,   17,   17,   18,   17,   17,
       17,   17,   19,   17,   20,   21,   22,   23,   24,   17,
       25,   17,   17,   31,   31,   32,   31,   31,   32,   35,
       33,  276,   41,   33,   28,   28,   28,   29,   34,   35,
       35,   36,   37,   35,   42,   38,   52,   77,   43,   35,
       35,   39,   28,   28,   28,   29,   34,   44,   46,   36,
       37,   40,   45,   35,   47,   35,   50,   35,   35,   53,
       55,   35,  282,   35,   57,   67,   35,   48,   58,   51,
       35,   49,   28,   61,   31,   31,   32,   35,   62,   69,

       68,   33,   28,   28,   28,   29,   35,   70,   35,   28,
       37,   63,   63,   63,   64,   63,   35,   74,   63,   65,
       35,   50,   35,   35,   35,   72,   73,   71,   35,   35,
       78,   80,   79,   75,   35,   35,   35,   35,   35,   35,
       76,   35,  281,   87,   83,   28,   61,   81,   82,   35,
       35,   62,   35,   85,   84,   86,   92,   83,   28,   89,
       93,   35,   35,   95,   90,   35,   35,   98,   35,   96,
       97,   94,   35,   35,   35,   79,   35,   99,   35,  103,
      100,   35,  105,  107,   35,   35,  101,  109,  110,  278,
       35,   35,   35,  111,  102,   28,   28,   28,   29,  108,

      106,   35,   28,   37,   35,   28,   89,  104,   35,   35,
      112,   90,  119,  113,   35,   35,  124,  122,   35,  114,
      115,  115,   63,  116,  115,   35,  120,  115,  118,   35,
       34,   35,  121,   83,  107,  131,   35,   79,  110,  145,
       35,  147,   35,   35,  259,  126,  127,  127,   63,  128,
      127,   35,   34,  127,  130,  132,  132,   63,  133,  132,
       35,  148,  132,  135,  136,  136,   63,  137,  136,   35,
      157,  136,  139,  146,   35,  140,  141,  141,   63,  142,
      141,   28,  150,  141,  144,   28,  152,  151,   35,  155,
       35,  153,   35,  163,  164,   35,   35,   28,  166,  191,

       35,  154,   35,  167,   34,  156,  201,   35,  276,  158,
      159,  159,   63,  160,  159,   28,  168,  159,  162,  170,
      187,  169,   28,  172,   28,  174,   28,  177,  173,   35,
      175,   35,  178,   28,  179,   28,  183,   28,  185,  180,
      229,  184,   35,  186,   35,   28,  150,  192,  181,   35,
      188,  151,  194,  193,  238,   35,   35,   35,  195,   28,
      197,   28,  199,  206,   34,  198,  208,  200,  202,  202,
       63,  203,  202,   28,  166,  202,  205,   28,  172,  167,
       28,  177,  235,  173,  207,   35,  178,   28,  183,  209,
       35,  214,   35,  184,  216,   35,   34,  218,   28,  197,

       35,  217,  226,   35,  198,   34,   28,  222,   28,  224,
      238,  215,  223,   34,  225,   66,  231,   34,  239,  240,
       28,  222,   35,  236,  241,  238,  223,  256,  228,  256,
      238,  244,  247,  247,   63,  248,  247,  254,  257,  247,
      250,  258,   28,  262,   28,  264,   34,   35,  263,  268,
      265,  266,  238,  267,  270,  238,   28,  262,  271,   35,
      238,  269,  263,   34,  274,  284,   34,   34,  279,   34,
      283,  273,  272,  260,   34,  220,  256,  253,  277,   26,
       26,   26,   26,   28,   28,   28,   30,   30,   30,   30,
       35,   35,   35,   35,   59,  213,   59,   59,   60,   60,

       60,   60,   62,  251,   62,   62,   34,   34,   34,   34,
       66,   66,  246,   66,   88,   88,   88,   88,   90,  243,
       90,   90,  117,  117,  117,  117,  129,  129,  129,  129,
      134,  134,  134,  134,  138,  138,  138,  138,  143,  143,
      143,  143,  149,  149,  149,  149,  151,  235,  151,  151,
      161,  161,  161,  161,  165,  165,  165,  165,  167,  233,
      167,  167,  171,  171,  171,  171,  173,  190,  173,  173,
      176,  176,  176,  176,  178,  228,  178,  178,  182,  182,
      182,  182,  184,  220,  184,  184,  189,  189,  189,  189,
      153,  213,  153,  153,  196,  196,  196,  196,  198,  211,

      198,  198,  204,  204,  204,  204,  169,  190,  169,  169,
      175,  125,  175,  175,  180,  123,  180,  180,  186,   91,
      186,  186,  210,  210,  210,  210,  212,  212,  212,  212,
      200,   35,  200,  200,  219,  219,  219,  219,  221,  221,
      221,  221,  223,   29,  223,  223,  227,  227,  227,  227,
      230,  230,  230,  230,  232,  232,  232,  232,  234,  234,
      234,  234,  237,  237,  237,  237,  242,  242,  242,  242,
      225,   56,  225,  225,  245,  245,  245,  245,  249,  249,
      249,  249,  231,   54,  231,  231,  252,  252,  252,  252,
      255,  255,  255,  255,  261,  261,  261,  261,  263,   35,

      263,  263,  265,   29,  265,  265,  275,  275,  275,  275,
      280,  280,  280,  280,  285,   27,   27,    5,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285
    } ;

static yyconst flex_int16_t yy_chk[752] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    7,    7,    7,    8,    8,    8,   13,
        7,  280,   13,    8,   11,   11,   11,   11,   11,   20,
       14,   11,   11,   48,   14,   11,   20,   48,   14,   15,
       16,   11,   12,   12,   12,   12,   12,   14,   16,   12,
       12,   12,   15,   18,   16,   19,   19,   21,   23,   21,
       23,   25,  277,   38,   25,   38,   39,   18,   25,   19,
       41,   18,   30,   30,   31,   31,   31,   40,   30,   40,

       39,   31,   34,   34,   34,   34,   42,   41,   43,   34,
       34,   36,   36,   36,   36,   36,   44,   44,   36,   36,
       45,   45,   46,   47,   52,   43,   43,   42,   49,   50,
       49,   51,   50,   46,   53,   54,   51,   55,   56,   57,
       47,   58,  275,   57,   58,   60,   60,   52,   53,   70,
       71,   60,   67,   56,   55,   56,   67,   54,   63,   63,
       68,   69,   68,   70,   63,   73,   72,   73,   76,   71,
       72,   69,   74,   75,   77,   74,   78,   75,   82,   79,
       76,   79,   81,   83,   81,   83,   77,   85,   85,  273,
       85,   84,   87,   85,   78,   80,   80,   80,   80,   84,

       82,   92,   80,   80,   86,   88,   88,   80,   94,   96,
       86,   88,   94,   87,   95,   97,   99,   97,   99,   92,
       93,   93,   93,   93,   93,  101,   95,   93,   93,  102,
      104,  111,   96,  106,  106,  104,  106,  102,  109,  111,
      109,  113,  113,  114,  241,  101,  103,  103,  103,  103,
      103,  122,  241,  103,  103,  105,  105,  105,  105,  105,
      108,  114,  105,  105,  107,  107,  107,  107,  107,  112,
      122,  107,  107,  112,  125,  108,  110,  110,  110,  110,
      110,  115,  115,  110,  110,  117,  117,  115,  119,  120,
      121,  117,  123,  125,  126,  120,  126,  127,  127,  148,

      148,  119,  145,  127,  131,  121,  163,  163,  271,  123,
      124,  124,  124,  124,  124,  129,  129,  124,  124,  131,
      145,  129,  132,  132,  134,  134,  136,  136,  132,  140,
      134,  146,  136,  138,  138,  141,  141,  143,  143,  138,
      208,  141,  208,  143,  154,  149,  149,  154,  140,  156,
      146,  149,  157,  156,  255,  158,  187,  157,  158,  159,
      159,  161,  161,  170,  170,  159,  187,  161,  164,  164,
      164,  164,  164,  165,  165,  164,  164,  171,  171,  165,
      176,  176,  252,  171,  181,  181,  176,  182,  182,  188,
      188,  192,  192,  182,  193,  193,  194,  195,  196,  196,

      215,  194,  206,  195,  196,  206,  202,  202,  204,  204,
      216,  192,  202,  217,  204,  209,  209,  226,  216,  216,
      221,  221,  236,  215,  217,  258,  221,  240,  245,  239,
      257,  226,  229,  229,  229,  229,  229,  236,  239,  229,
      229,  240,  247,  247,  249,  249,  259,  254,  247,  258,
      249,  254,  267,  257,  260,  268,  261,  261,  266,  266,
      272,  259,  261,  260,  269,  283,  274,  269,  274,  279,
      279,  268,  267,  244,  283,  242,  237,  234,  272,  286,
      286,  286,  286,  287,  287,  287,  288,  288,  288,  288,
      289,  289,  289,  289,  290,  232,  290,  290,  291,  291,

      291,  291,  292,  230,  292,  292,  293,  293,  293,  293,
      294,  294,  227,  294,  295,  295,  295,  295,  296,  219,
      296,  296,  297,  297,  297,  297,  298,  298,  298,  298,
      299,  299,  299,  299,  300,  300,  300,  300,  301,  301,
      301,  301,  302,  302,  302,  302,  303,  214,  303,  303,
      304,  304,  304,  304,  305,  305,  305,  305,  306,  212,
      306,  306,  307,  307,  307,  307,  308,  210,  308,  308,
      309,  309,  309,  309,  310,  207,  310,  310,  311,  311,
      311,  311,  312,  201,  312,  312,  313,  313,  313,  313,
      314,  191,  314,  314,  315,  315,  315,  315,  316,  189,

      316,  316,  317,  317,  317,  317,  318,  147,  318,  318,
      319,  100,  319,  319,  320,   98,  320,  320,  321,   66,
      321,  321,  322,  322,  322,  322,  323,  323,  323,  323,
      324,   35,  324,  324,  325,  325,  325,  325,  326,  326,
      326,  326,  327,   28,  327,  327,  328,  328,  328,  328,
      329,  329,  329,  329,  330,  330,  330,  330,  331,  331,
      331,  331,  332,  332,  332,  332,  333,  333,  333,  333,
      334,   24,  334,  334,  335,  335,  335,  335,  336,  336,
      336,  336,  337,   22,  337,  337,  338,  338,  338,  338,
      339,  339,  339,  339,  340,  340,  340,  340,  341,   17,

      341,  341,  342,    6,  342,  342,  343,  343,  343,  343,
      344,  344,  344,  344,    5,    4,    3,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285
    } ;

#define YY_TRAILING_MASK 0x2000
#define YY_TRAILING_HEAD_MASK 0x4000
#define REJECT \
{ \
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */ \
yy_cp = yyg->yy_full_match; /* restore poss. backed-over text */ \
yyg->yy_lp = yyg->yy_full_lp; /* restore orig. accepting pos. */ \
yyg->yy_state_ptr = yyg->yy_full_state; /* restore orig. state */ \
yy_current_state = *yyg->yy_state_ptr; /* restore curr. state */ \
++yyg->yy_lp; \
goto find_rule; \
}

#define yymore() (yyg->yy_more_flag = 1)
#define YY_MORE_ADJ yyg->yy_more_len
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "libxlu_disk_l.l"
/* -*- fundamental -*- */
/*
 * libxlu_disk_l.l - parser for disk specification strings
 *
 * Copyright (C) 2011      Citrix Ltd.
 * Author Ian Jackson <ian.jackson@eu.citrix.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 only. with the special
 * exception on linking described in file LICENSE.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
/*
 * Parsing the old xm/xend/xl-4.1 disk specs is a tricky problem,
 * because the target string might in theory contain "," which is the
 * delimiter we use for stripping off things on the RHS, and ":",
 * which is the delimiter we use for stripping off things on the LHS.
 *
 * In this parser we do not support such target strings in the old
 * syntax; if the target string has to contain "," or ":" the new
 * syntax's "target=" should be used.
 */

#line 35 "libxlu_disk_l.l"
#include "libxlu_disk_i.h"

#define YY_NO_INPUT

/* Some versions of flex have a bug (Fedora bugzilla 612465) which causes
 * it to fail to declare these functions, which it defines.  So declare
 * them ourselves.  Hopefully we won't have to simultaneously support
 * a flex version which declares these differently somehow. */
int xlu__disk_yyget_column(yyscan_t yyscanner);
void xlu__disk_yyset_column(int  column_no, yyscan_t yyscanner);


/*----- useful macros and functions used in actions -----
 * we use macros in the actual rules to keep the actions short
 * and particularly to avoid repeating boilerplate values such as
 * DPC->disk, yytext, etc. */

/* Sets an enum, checking it hasn't already been set to a different value  */
#define DSET(dpc,member,enumname,str,valname) do{			\
	if (dpc->disk->member != LIBXL_DISK_##enumname##_UNKNOWN &&	\
	    dpc->disk->member != LIBXL_DISK_##enumname##_##valname) {	\
	    xlu__disk_err(dpc, str, TOSTRING(member) " respecified");	\
	} else {							\
	    dpc->disk->member = LIBXL_DISK_##enumname##_##valname;	\
	}								\
    }while(0)

/* For actions whose patterns contain '=', finds the start of the value */
#define FROMEQUALS (strchr(yytext,'=')+1)

/* Chops the delimiter off, modifying yytext and yyleng. */
#define STRIP(delim) do{                                                \
	if (yyleng>0 && yytext[yyleng-1]==(delim))                      \
	    yytext[--yyleng] = 0;                                       \
    }while(0)

/* Sets a string value, checking it hasn't been set already. */
#define SAVESTRING(what,loc,val) do{					\
	savestring(DPC, what " respecified", &DPC->disk->loc, (val));	\
    }while(0)
static void savestring(DiskParseContext *dpc, const char *what_respecified,
		       char **update, const char *value) {
    if (*update) {
        if (**update) { xlu__disk_err(dpc,value,what_respecified); return; }
        free(*update); /* do not complain about overwriting empty strings */
    }
    *update = strdup(value);
}

#define DPC dpc /* our convention in lexer helper functions */

/* Sets ->readwrite from the string.  This ought to be an enum, perhaps. */
static void setaccess(DiskParseContext *dpc, const char *str) {
    if (!strcmp(str, "r") || !strcmp(str, "ro")) {
        dpc->disk->readwrite = 0;
    } else if (!strcmp(str, "rw") || !strcmp(str, "w") || !strcmp(str,"")) {
	dpc->disk->readwrite = 1;
    } else {
	xlu__disk_err(dpc,str,"unknown value for access");
    }
}

/* Sets ->format from the string.  IDL should provide something for this. */
static void setformat(DiskParseContext *dpc, const char *str) {
    if      (!strcmp(str,""))       DSET(dpc,format,FORMAT,str,RAW);
    else if (!strcmp(str,"raw"))    DSET(dpc,format,FORMAT,str,RAW);
    else if (!strcmp(str,"qcow"))   DSET(dpc,format,FORMAT,str,QCOW);
    else if (!strcmp(str,"qcow2"))  DSET(dpc,format,FORMAT,str,QCOW2);
    else if (!strcmp(str,"vhd"))    DSET(dpc,format,FORMAT,str,VHD);
    else if (!strcmp(str,"empty"))  DSET(dpc,format,FORMAT,str,EMPTY);
    else xlu__disk_err(dpc,str,"unknown value for format");
}

/* Sets ->backend from the string.  IDL should provide something for this. */
static void setbackendtype(DiskParseContext *dpc, const char *str) {
    if (     !strcmp(str,"phy"))   DSET(dpc,backend,BACKEND,str,PHY);
    else if (!strcmp(str,"tap"))   DSET(dpc,backend,BACKEND,str,TAP);
    else if (!strcmp(str,"qdisk")) DSET(dpc,backend,BACKEND,str,QDISK);
    else xlu__disk_err(dpc,str,"unknown value for backendtype");
}

#define DEPRECATE(usewhatinstead) /* not currently reported */

/* Handles a vdev positional parameter which includes a devtype. */
static int vdev_and_devtype(DiskParseContext *dpc, char *str) {
    /* returns 1 if it was <vdev>:<devtype>, 0 (doing nothing) otherwise */
    char *colon = strrchr(str, ':');
    if (!colon)
        return 0;

    DEPRECATE("use `devtype=...'");
    *colon++ = 0;
    SAVESTRING("vdev", vdev, str);

    if (!strcmp(colon,"cdrom")) {
        DPC->disk->is_cdrom = 1;
    } else if (!strcmp(colon,"disk")) {
        DPC->disk->is_cdrom = 0;
    } else {
        xlu__disk_err(DPC,colon,"unknown deprecated type");
    }
    return 1;
}

#undef DPC /* needs to be defined differently the actual lexer */
#define DPC ((DiskParseContext*)yyextra)


#line 918 "libxlu_disk_l.c"

#define INITIAL 0
#define LEXERR 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    yy_state_type *yy_state_buf;
    yy_state_type *yy_state_ptr;
    char *yy_full_match;
    int yy_lp;

    /* These are only needed for trailing context rules,
     * but there's no conditional variable for that yet. */
    int yy_looking_for_trail_begin;
    int yy_full_lp;
    int *yy_full_state;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

int xlu__disk_yylex_init (yyscan_t* scanner);

int xlu__disk_yylex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int xlu__disk_yylex_destroy (yyscan_t yyscanner );

int xlu__disk_yyget_debug (yyscan_t yyscanner );

void xlu__disk_yyset_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE xlu__disk_yyget_extra (yyscan_t yyscanner );

void xlu__disk_yyset_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *xlu__disk_yyget_in (yyscan_t yyscanner );

void xlu__disk_yyset_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *xlu__disk_yyget_out (yyscan_t yyscanner );

void xlu__disk_yyset_out  (FILE * out_str ,yyscan_t yyscanner );

int xlu__disk_yyget_leng (yyscan_t yyscanner );

char *xlu__disk_yyget_text (yyscan_t yyscanner );

int xlu__disk_yyget_lineno (yyscan_t yyscanner );

void xlu__disk_yyset_lineno (int line_number ,yyscan_t yyscanner );

int xlu__disk_yyget_column  (yyscan_t yyscanner );

void xlu__disk_yyset_column (int column_no ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int xlu__disk_yywrap (yyscan_t yyscanner );
#else
extern int xlu__disk_yywrap (yyscan_t yyscanner );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int xlu__disk_yylex (yyscan_t yyscanner);

#define YY_DECL int xlu__disk_yylex (yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

#line 155 "libxlu_disk_l.l"


 /*----- the scanner rules which do the parsing -----*/

#line 1163 "libxlu_disk_l.c"

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

        /* Create the reject buffer large enough to save one state per allowed character. */
        if ( ! yyg->yy_state_buf )
            yyg->yy_state_buf = (yy_state_type *)xlu__disk_yyalloc(YY_STATE_BUF_SIZE  ,yyscanner);
            if ( ! yyg->yy_state_buf )
                YY_FATAL_ERROR( "out of dynamic memory in xlu__disk_yylex()" );

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			xlu__disk_yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				xlu__disk_yy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		xlu__disk_yy_load_buffer_state(yyscanner );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yyg->yy_more_len = 0;
		if ( yyg->yy_more_flag )
			{
			yyg->yy_more_len = yyg->yy_c_buf_p - yyg->yytext_ptr;
			yyg->yy_more_flag = 0;
			}
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;

		yyg->yy_state_ptr = yyg->yy_state_buf;
		*yyg->yy_state_ptr++ = yy_current_state;

yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 286 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			*yyg->yy_state_ptr++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_current_state != 285 );

yy_find_action:
		yy_current_state = *--yyg->yy_state_ptr;
		yyg->yy_lp = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( yyg->yy_lp && yyg->yy_lp < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[yyg->yy_lp];
				if ( yy_act & YY_TRAILING_HEAD_MASK ||
				     yyg->yy_looking_for_trail_begin )
					{
					if ( yy_act == yyg->yy_looking_for_trail_begin )
						{
						yyg->yy_looking_for_trail_begin = 0;
						yy_act &= ~YY_TRAILING_HEAD_MASK;
						break;
						}
					}
				else if ( yy_act & YY_TRAILING_MASK )
					{
					yyg->yy_looking_for_trail_begin = yy_act & ~YY_TRAILING_MASK;
					yyg->yy_looking_for_trail_begin |= YY_TRAILING_HEAD_MASK;
					}
				else
					{
					yyg->yy_full_match = yy_cp;
					yyg->yy_full_state = yyg->yy_state_ptr;
					yyg->yy_full_lp = yyg->yy_lp;
					break;
					}
				++yyg->yy_lp;
				goto find_rule;
				}
			--yy_cp;
			yy_current_state = *--yyg->yy_state_ptr;
			yyg->yy_lp = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 159 "libxlu_disk_l.l"
{ /* ignore whitespace before parameters */ }
	YY_BREAK
/* ordinary parameters setting enums or strings */
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 163 "libxlu_disk_l.l"
{ STRIP(','); setformat(DPC, FROMEQUALS); }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 165 "libxlu_disk_l.l"
{ DPC->disk->is_cdrom = 1; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 166 "libxlu_disk_l.l"
{ DPC->disk->is_cdrom = 1; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 167 "libxlu_disk_l.l"
{ DPC->disk->is_cdrom = 0; }
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 168 "libxlu_disk_l.l"
{ xlu__disk_err(DPC,yytext,"unknown value for type"); }
	YY_BREAK
case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 170 "libxlu_disk_l.l"
{ STRIP(','); setaccess(DPC, FROMEQUALS); }
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 171 "libxlu_disk_l.l"
{ STRIP(','); SAVESTRING("backend", backend_domname, FROMEQUALS); }
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 172 "libxlu_disk_l.l"
{ STRIP(','); setbackendtype(DPC,FROMEQUALS); }
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 174 "libxlu_disk_l.l"
{ STRIP(','); SAVESTRING("vdev", vdev, FROMEQUALS); }
	YY_BREAK
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 175 "libxlu_disk_l.l"
{ STRIP(','); SAVESTRING("script", script, FROMEQUALS); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 176 "libxlu_disk_l.l"
{ DPC->disk->direct_io_safe = 1; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 177 "libxlu_disk_l.l"
{ libxl_defbool_set(&DPC->disk->discard_enable, true); }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 178 "libxlu_disk_l.l"
{ libxl_defbool_set(&DPC->disk->discard_enable, false); }
	YY_BREAK
/* the target magic parameter, eats the rest of the string */
case 15:
YY_RULE_SETUP
#line 182 "libxlu_disk_l.l"
{ STRIP(','); SAVESTRING("target", pdev_path, FROMEQUALS); }
	YY_BREAK
/* unknown parameters */
case 16:
/* rule 16 can match eol */
YY_RULE_SETUP
#line 186 "libxlu_disk_l.l"
{ xlu__disk_err(DPC,yytext,"unknown parameter"); }
	YY_BREAK
/* deprecated prefixes */
/* the "/.*" in these patterns ensures that they count as if they
   * matched the whole string, so these patterns take precedence */
case 17:
YY_RULE_SETUP
#line 193 "libxlu_disk_l.l"
{
                    STRIP(':');
                    DPC->had_depr_prefix=1; DEPRECATE("use `[format=]...,'");
                    setformat(DPC, yytext);
                 }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 199 "libxlu_disk_l.l"
{
                    char *newscript;
                    STRIP(':');
                    DPC->had_depr_prefix=1; DEPRECATE("use `script=...'");
                    if (asprintf(&newscript, "block-%s", yytext) < 0) {
                            xlu__disk_err(DPC,yytext,"unable to format script");
                            return 0;
                    }
                    savestring(DPC, "script respecified",
                               &DPC->disk->script, newscript);
                    free(newscript);
                }
	YY_BREAK
case 19:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp = yy_bp + 8;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 212 "libxlu_disk_l.l"
{ DPC->had_depr_prefix=1; DEPRECATE(0); }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 213 "libxlu_disk_l.l"
{ DPC->had_depr_prefix=1; DEPRECATE(0); }
	YY_BREAK
case 21:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp = yy_bp + 4;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 214 "libxlu_disk_l.l"
{ DPC->had_depr_prefix=1; DEPRECATE(0); }
	YY_BREAK
case 22:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp = yy_bp + 6;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 215 "libxlu_disk_l.l"
{ DPC->had_depr_prefix=1; DEPRECATE(0); }
	YY_BREAK
case 23:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp = yy_bp + 5;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 216 "libxlu_disk_l.l"
{ DPC->had_depr_prefix=1; DEPRECATE(0); }
	YY_BREAK
case 24:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp = yy_bp + 4;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 217 "libxlu_disk_l.l"
{ DPC->had_depr_prefix=1; DEPRECATE(0); }
	YY_BREAK
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 219 "libxlu_disk_l.l"
{
		  xlu__disk_err(DPC,yytext,"unknown deprecated disk prefix");
		  return 0;
		}
	YY_BREAK
/* positional parameters */
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 226 "libxlu_disk_l.l"
{
    STRIP(',');

    if (DPC->err) {
        /* previous errors may just lead to subsequent ones */
    } else if (!DPC->disk->pdev_path) {
        SAVESTRING("target", pdev_path, yytext);
    } else if (!DPC->had_depr_prefix &&
               DPC->disk->format == LIBXL_DISK_FORMAT_UNKNOWN) {
        if (!*DPC->disk->pdev_path && vdev_and_devtype(DPC,yytext)) {
            DPC->disk->format = LIBXL_DISK_FORMAT_EMPTY;
        } else {
            setformat(DPC,yytext);
        }
    } else if (!DPC->disk->vdev) {
        if (!vdev_and_devtype(DPC,yytext))
            SAVESTRING("vdev", vdev, yytext);
    } else if (!DPC->access_set) {
        DPC->access_set = 1;
        setaccess(DPC,yytext);
    } else {
        xlu__disk_err(DPC,yytext,"too many positional parameters");
        return 0; /* don't print any more errors */
    }
}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 252 "libxlu_disk_l.l"
{
    BEGIN(LEXERR);
    yymore();
}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 256 "libxlu_disk_l.l"
{
    xlu__disk_err(DPC,yytext,"bad disk syntax"); return 0;
}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 259 "libxlu_disk_l.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 1506 "libxlu_disk_l.c"
			case YY_STATE_EOF(INITIAL):
			case YY_STATE_EOF(LEXERR):
				yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * xlu__disk_yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( xlu__disk_yywrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of xlu__disk_yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			xlu__disk_yyrestart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) xlu__disk_yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	yyg->yy_state_ptr = yyg->yy_state_buf;
	*yyg->yy_state_ptr++ = yy_current_state;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 286 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		*yyg->yy_state_ptr++ = yy_current_state;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	register YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 286 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 285);
	if ( ! yy_is_jam )
		*yyg->yy_state_ptr++ = yy_current_state;

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					xlu__disk_yyrestart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( xlu__disk_yywrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void xlu__disk_yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        xlu__disk_yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            xlu__disk_yy_create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	xlu__disk_yy_init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	xlu__disk_yy_load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void xlu__disk_yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		xlu__disk_yypop_buffer_state();
	 *		xlu__disk_yypush_buffer_state(new_buffer);
     */
	xlu__disk_yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	xlu__disk_yy_load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (xlu__disk_yywrap()) processing, but the only time this flag
	 * is looked at is after xlu__disk_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void xlu__disk_yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE xlu__disk_yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) xlu__disk_yyalloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in xlu__disk_yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) xlu__disk_yyalloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in xlu__disk_yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	xlu__disk_yy_init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with xlu__disk_yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void xlu__disk_yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		xlu__disk_yyfree((void *) b->yy_ch_buf ,yyscanner );

	xlu__disk_yyfree((void *) b ,yyscanner );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a xlu__disk_yyrestart() or at EOF.
 */
    static void xlu__disk_yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	xlu__disk_yy_flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then xlu__disk_yy_init_buffer was _probably_
     * called from xlu__disk_yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void xlu__disk_yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		xlu__disk_yy_load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void xlu__disk_yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	xlu__disk_yyensure_buffer_stack(yyscanner);

	/* This block is copied from xlu__disk_yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from xlu__disk_yy_switch_to_buffer. */
	xlu__disk_yy_load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void xlu__disk_yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	xlu__disk_yy_delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		xlu__disk_yy_load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void xlu__disk_yyensure_buffer_stack (yyscan_t yyscanner)
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)xlu__disk_yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in xlu__disk_yyensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)xlu__disk_yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in xlu__disk_yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE xlu__disk_yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) xlu__disk_yyalloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in xlu__disk_yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	xlu__disk_yy_switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to xlu__disk_yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       xlu__disk_yy_scan_bytes() instead.
 */
YY_BUFFER_STATE xlu__disk_yy_scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return xlu__disk_yy_scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to xlu__disk_yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE xlu__disk_yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) xlu__disk_yyalloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in xlu__disk_yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = xlu__disk_yy_scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in xlu__disk_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE xlu__disk_yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int xlu__disk_yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int xlu__disk_yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *xlu__disk_yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *xlu__disk_yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int xlu__disk_yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *xlu__disk_yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void xlu__disk_yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void xlu__disk_yyset_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "xlu__disk_yyset_lineno called with no buffer" , yyscanner); 
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void xlu__disk_yyset_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "xlu__disk_yyset_column called with no buffer" , yyscanner); 
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see xlu__disk_yy_switch_to_buffer
 */
void xlu__disk_yyset_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void xlu__disk_yyset_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int xlu__disk_yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void xlu__disk_yyset_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* Accessor methods for yylval and yylloc */

/* User-visible API */

/* xlu__disk_yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int xlu__disk_yylex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) xlu__disk_yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* xlu__disk_yylex_init_extra has the same functionality as xlu__disk_yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to xlu__disk_yyalloc in
 * the yyextra field.
 */

int xlu__disk_yylex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    xlu__disk_yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) xlu__disk_yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    xlu__disk_yyset_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from xlu__disk_yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

    yyg->yy_state_buf = 0;
    yyg->yy_state_ptr = 0;
    yyg->yy_full_match = 0;
    yyg->yy_lp = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * xlu__disk_yylex_init()
     */
    return 0;
}

/* xlu__disk_yylex_destroy is for both reentrant and non-reentrant scanners. */
int xlu__disk_yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		xlu__disk_yy_delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		xlu__disk_yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	xlu__disk_yyfree(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        xlu__disk_yyfree(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    xlu__disk_yyfree ( yyg->yy_state_buf , yyscanner);
    yyg->yy_state_buf  = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * xlu__disk_yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    xlu__disk_yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *xlu__disk_yyalloc (yy_size_t  size , yyscan_t yyscanner)
{
	return (void *) malloc( size );
}

void *xlu__disk_yyrealloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void xlu__disk_yyfree (void * ptr , yyscan_t yyscanner)
{
	free( (char *) ptr );	/* see xlu__disk_yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 259 "libxlu_disk_l.l"
