/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIDS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgDeleteSection(const char * const name);

	Delete the specified section from the INI file.

ob(ject): cfgDeleteSection
su(bsystem): inifile/3
ty(pe): 
sy(nopsis): 
sh(ort description): Delete the entire section
he(ader files): 
lo(ng description): Deletes an entire section. The currently selected
	section is deselected upon return of this function.
pr(erequistes): 
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgids.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIDS.C 1.3 1999/12/13 02:22:21 ska Exp ska $";
#endif

int cfgDeleteSection(const char * const name)
{	int rv;

	DBG_ENTER("cfgDeleteSection", Suppl_inifile3)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	if((rv = cfgOpenSection(name)) == CFG_ERR_NONE)
		DBG_RETURN_BI( cfgDeleteCurSection())
	chkHeap

	DBG_RETURN_I( rv)
}
