/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfilePagemaker6
extends TiffProfile {
    public TiffProfilePagemaker6() {
        this._profileText = "Adobe PageMaker 6.0";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        boolean bl;
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        long l = nisoImageMetadata.getImageLength();
        if (l == -1L || nisoImageMetadata.getImageWidth() == -1L) {
            return false;
        }
        boolean bl2 = nisoImageMetadata.getStripOffsets() != null;
        boolean bl3 = bl = nisoImageMetadata.getTileOffsets() != null;
        if (bl2 && bl || !bl2 && !bl) {
            return false;
        }
        if (bl2) {
            if (nisoImageMetadata.getStripByteCounts() == null) {
                return false;
            }
            long l2 = nisoImageMetadata.getRowsPerStrip();
            if (l2 == -1L || l2 < 1L || l2 > l) {
                return false;
            }
        }
        if (bl && (nisoImageMetadata.getTileWidth() == -1L || nisoImageMetadata.getTileLength() == -1L || nisoImageMetadata.getTileOffsets() == null || nisoImageMetadata.getTileByteCounts() == null)) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 2, 5, 32773, 32895, 32896})) {
            return false;
        }
        int n = nisoImageMetadata.getColorSpace();
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 5 && n != 8 && n != 9) {
            return false;
        }
        int n2 = tiffIFD.getInkSet();
        int n3 = nisoImageMetadata.getSamplesPerPixel();
        if (n == 0 || n == 1 || n == 3 ? n3 != 1 : (n == 2 || n == 8 || n == 9 ? n3 != 3 : n2 == 1 && n3 != 4)) {
            return false;
        }
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray != null) {
            if (n == 0 || n == 1 || n == 3) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 1 || nArray[i] == 2 || nArray[i] == 4 || nArray[i] == 8) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 8) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return n2 != 2 || tiffIFD.getInkNames() != null && tiffIFD.getNumberOfInks() != -1;
    }
}

