#pragma once

#if defined(_MSC_VER)
#	pragma warning(push)
#	pragma warning(disable: 4100) // DISABLE warning C4100: '' : unreferenced formal parameter
#	pragma warning(disable: 4146) // DISABLE warning C4146: unary minus operator applied to unsigned type, result still unsigned
#	pragma warning(disable: 4244) // DISABLE warning C4244: '+=' : conversion from '__int64' to 'FT_ULong', possible loss of data
#	pragma warning(disable: 4267) // DISABLE warning C4267: 'initializing' : conversion from 'size_t' to 'FT_Long', possible loss of data
#	pragma warning(disable: 4700) // DISABLE warning C4700: uninitialized local variable 'temp' used
#	pragma warning(disable: 4701) // DISABLE warning C4701: potentially uninitialized local variable '' used
#elif defined(__GNUC__)
#	pragma GCC system_header
#endif // defined(__GNUC__)

/***************************************************************************/
/*                                                                         */
/*  ftsystem.c                                                             */
/*                                                                         */
/*    ANSI-specific FreeType low-level system interface (body).            */
/*                                                                         */
/*  Copyright 1996-2002, 2006, 2008-2011 by                                */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This file contains the default interface used by FreeType to access   */
/* low-level, i.e. memory management, i/o access as well as thread       */
/* synchronisation.  It can be replaced by user-specific routines if     */
/* necessary.                                                            */
/*                                                                       */
/*************************************************************************/
/***************************************************************************/
/*                                                                         */
/*  ft2build.h                                                             */
/*                                                                         */
/*    FreeType 2 build and setup macros.                                   */
/*    (Generic version)                                                    */
/*                                                                         */
/*  Copyright 1996-2001, 2006 by                                           */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This file corresponds to the default `ft2build.h' file for            */
/* FreeType 2.  It uses the `freetype' include root.                     */
/*                                                                       */
/* Note that specific platforms might use a different configuration.     */
/* See builds/unix/ft2unix.h for an example.                             */
/*                                                                       */
/*************************************************************************/
#ifndef __FT2_BUILD_GENERIC_H__
#define __FT2_BUILD_GENERIC_H__
/***************************************************************************/
/*                                                                         */
/*  ftheader.h                                                             */
/*                                                                         */
/*    Build macros of the FreeType 2 library.                              */
/*                                                                         */
/*  Copyright 1996-2008, 2010, 2012 by                                     */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#ifndef __FT_HEADER_H__
#define __FT_HEADER_H__
/*@***********************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_BEGIN_HEADER                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    This macro is used in association with @FT_END_HEADER in header    */
/*    files to ensure that the declarations within are properly          */
/*    encapsulated in an `extern "C" { .. }' block when included from a  */
/*    C++ compiler.                                                      */
/*                                                                       */
#ifdef __cplusplus
#define FT_BEGIN_HEADER  extern "C" {
#else
/* nothing */
#define FT_BEGIN_HEADER   
#endif
/*@***********************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_END_HEADER                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    This macro is used in association with @FT_BEGIN_HEADER in header  */
/*    files to ensure that the declarations within are properly          */
/*    encapsulated in an `extern "C" { .. }' block when included from a  */
/*    C++ compiler.                                                      */
/*                                                                       */
#ifdef __cplusplus
#define FT_END_HEADER  }
#else
/* nothing */
#define FT_END_HEADER   
#endif
/*************************************************************************/
/*                                                                       */
/* Aliases for the FreeType 2 public and configuration files.            */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    header_file_macros                                                 */
/*                                                                       */
/* <Title>                                                               */
/*    Header File Macros                                                 */
/*                                                                       */
/* <Abstract>                                                            */
/*    Macro definitions used to #include specific header files.          */
/*                                                                       */
/* <Description>                                                         */
/*    The following macros are defined to the name of specific           */
/*    FreeType~2 header files.  They can be used directly in #include    */
/*    statements as in:                                                  */
/*                                                                       */
/*    {                                                                  */
/*      #include FT_FREETYPE_H                                           */
/*      #include FT_MULTIPLE_MASTERS_H                                   */
/*      #include FT_GLYPH_H                                              */
/*    }                                                                  */
/*                                                                       */
/*    There are several reasons why we are now using macros to name      */
/*    public header files.  The first one is that such macros are not    */
/*    limited to the infamous 8.3~naming rule required by DOS (and       */
/*    `FT_MULTIPLE_MASTERS_H' is a lot more meaningful than `ftmm.h').   */
/*                                                                       */
/*    The second reason is that it allows for more flexibility in the    */
/*    way FreeType~2 is installed on a given system.                     */
/*                                                                       */
/*************************************************************************/
/* configuration files */
/*************************************************************************
   *
   * @macro:
   *   FT_CONFIG_CONFIG_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing
   *   FreeType~2 configuration data.
   *
   */
#ifndef FT_CONFIG_CONFIG_H
#define FT_CONFIG_CONFIG_H  <freetype/config/ftconfig.h>
#endif
/*************************************************************************
   *
   * @macro:
   *   FT_CONFIG_STANDARD_LIBRARY_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing
   *   FreeType~2 interface to the standard C library functions.
   *
   */
#ifndef FT_CONFIG_STANDARD_LIBRARY_H
#define FT_CONFIG_STANDARD_LIBRARY_H  <freetype/config/ftstdlib.h>
#endif
/*************************************************************************
   *
   * @macro:
   *   FT_CONFIG_OPTIONS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing
   *   FreeType~2 project-specific configuration options.
   *
   */
#ifndef FT_CONFIG_OPTIONS_H
#define FT_CONFIG_OPTIONS_H  <freetype/config/ftoption.h>
#endif
/*************************************************************************
   *
   * @macro:
   *   FT_CONFIG_MODULES_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   list of FreeType~2 modules that are statically linked to new library
   *   instances in @FT_Init_FreeType.
   *
   */
#ifndef FT_CONFIG_MODULES_H
#define FT_CONFIG_MODULES_H  <freetype/config/ftmodule.h>
#endif
/* */
/* public headers */
/*************************************************************************
   *
   * @macro:
   *   FT_FREETYPE_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   base FreeType~2 API.
   *
   */
#define FT_FREETYPE_H  <freetype/freetype.h>
/*************************************************************************
   *
   * @macro:
   *   FT_ERRORS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   list of FreeType~2 error codes (and messages).
   *
   *   It is included by @FT_FREETYPE_H.
   *
   */
#define FT_ERRORS_H  <freetype/fterrors.h>
/*************************************************************************
   *
   * @macro:
   *   FT_MODULE_ERRORS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   list of FreeType~2 module error offsets (and messages).
   *
   */
#define FT_MODULE_ERRORS_H  <freetype/ftmoderr.h>
/*************************************************************************
   *
   * @macro:
   *   FT_SYSTEM_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 interface to low-level operations (i.e., memory management
   *   and stream i/o).
   *
   *   It is included by @FT_FREETYPE_H.
   *
   */
#define FT_SYSTEM_H  <freetype/ftsystem.h>
/*************************************************************************
   *
   * @macro:
   *   FT_IMAGE_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing type
   *   definitions related to glyph images (i.e., bitmaps, outlines,
   *   scan-converter parameters).
   *
   *   It is included by @FT_FREETYPE_H.
   *
   */
#define FT_IMAGE_H  <freetype/ftimage.h>
/*************************************************************************
   *
   * @macro:
   *   FT_TYPES_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   basic data types defined by FreeType~2.
   *
   *   It is included by @FT_FREETYPE_H.
   *
   */
#define FT_TYPES_H  <freetype/fttypes.h>
/*************************************************************************
   *
   * @macro:
   *   FT_LIST_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   list management API of FreeType~2.
   *
   *   (Most applications will never need to include this file.)
   *
   */
#define FT_LIST_H  <freetype/ftlist.h>
/*************************************************************************
   *
   * @macro:
   *   FT_OUTLINE_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   scalable outline management API of FreeType~2.
   *
   */
#define FT_OUTLINE_H  <freetype/ftoutln.h>
/*************************************************************************
   *
   * @macro:
   *   FT_SIZES_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   API which manages multiple @FT_Size objects per face.
   *
   */
#define FT_SIZES_H  <freetype/ftsizes.h>
/*************************************************************************
   *
   * @macro:
   *   FT_MODULE_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   module management API of FreeType~2.
   *
   */
#define FT_MODULE_H  <freetype/ftmodapi.h>
/*************************************************************************
   *
   * @macro:
   *   FT_RENDER_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   renderer module management API of FreeType~2.
   *
   */
#define FT_RENDER_H  <freetype/ftrender.h>
/*************************************************************************
   *
   * @macro:
   *   FT_AUTOHINTER_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing
   *   structures and macros related to the auto-hinting module.
   *
   */
#define FT_AUTOHINTER_H  <freetype/ftautoh.h>
/*************************************************************************
   *
   * @macro:
   *   FT_TYPE1_TABLES_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   types and API specific to the Type~1 format.
   *
   */
#define FT_TYPE1_TABLES_H  <freetype/t1tables.h>
/*************************************************************************
   *
   * @macro:
   *   FT_TRUETYPE_IDS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   enumeration values which identify name strings, languages, encodings,
   *   etc.  This file really contains a _large_ set of constant macro
   *   definitions, taken from the TrueType and OpenType specifications.
   *
   */
#define FT_TRUETYPE_IDS_H  <freetype/ttnameid.h>
/*************************************************************************
   *
   * @macro:
   *   FT_TRUETYPE_TABLES_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   types and API specific to the TrueType (as well as OpenType) format.
   *
   */
#define FT_TRUETYPE_TABLES_H  <freetype/tttables.h>
/*************************************************************************
   *
   * @macro:
   *   FT_TRUETYPE_TAGS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   definitions of TrueType four-byte `tags' which identify blocks in
   *   SFNT-based font formats (i.e., TrueType and OpenType).
   *
   */
#define FT_TRUETYPE_TAGS_H  <freetype/tttags.h>
/*************************************************************************
   *
   * @macro:
   *   FT_BDF_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   definitions of an API which accesses BDF-specific strings from a
   *   face.
   *
   */
#define FT_BDF_H  <freetype/ftbdf.h>
/*************************************************************************
   *
   * @macro:
   *   FT_CID_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   definitions of an API which access CID font information from a
   *   face.
   *
   */
#define FT_CID_H  <freetype/ftcid.h>
/*************************************************************************
   *
   * @macro:
   *   FT_GZIP_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   definitions of an API which supports gzip-compressed files.
   *
   */
#define FT_GZIP_H  <freetype/ftgzip.h>
/*************************************************************************
   *
   * @macro:
   *   FT_LZW_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   definitions of an API which supports LZW-compressed files.
   *
   */
#define FT_LZW_H  <freetype/ftlzw.h>
/*************************************************************************
   *
   * @macro:
   *   FT_BZIP2_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   definitions of an API which supports bzip2-compressed files.
   *
   */
#define FT_BZIP2_H  <freetype/ftbzip2.h>
/*************************************************************************
   *
   * @macro:
   *   FT_WINFONTS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   definitions of an API which supports Windows FNT files.
   *
   */
#define FT_WINFONTS_H   <freetype/ftwinfnt.h>
/*************************************************************************
   *
   * @macro:
   *   FT_GLYPH_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   API of the optional glyph management component.
   *
   */
#define FT_GLYPH_H  <freetype/ftglyph.h>
/*************************************************************************
   *
   * @macro:
   *   FT_BITMAP_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   API of the optional bitmap conversion component.
   *
   */
#define FT_BITMAP_H  <freetype/ftbitmap.h>
/*************************************************************************
   *
   * @macro:
   *   FT_BBOX_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   API of the optional exact bounding box computation routines.
   *
   */
#define FT_BBOX_H  <freetype/ftbbox.h>
/*************************************************************************
   *
   * @macro:
   *   FT_CACHE_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   API of the optional FreeType~2 cache sub-system.
   *
   */
#define FT_CACHE_H  <freetype/ftcache.h>
/*************************************************************************
   *
   * @macro:
   *   FT_CACHE_IMAGE_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   `glyph image' API of the FreeType~2 cache sub-system.
   *
   *   It is used to define a cache for @FT_Glyph elements.  You can also
   *   use the API defined in @FT_CACHE_SMALL_BITMAPS_H if you only need to
   *   store small glyph bitmaps, as it will use less memory.
   *
   *   This macro is deprecated.  Simply include @FT_CACHE_H to have all
   *   glyph image-related cache declarations.
   *
   */
#define FT_CACHE_IMAGE_H  FT_CACHE_H
/*************************************************************************
   *
   * @macro:
   *   FT_CACHE_SMALL_BITMAPS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   `small bitmaps' API of the FreeType~2 cache sub-system.
   *
   *   It is used to define a cache for small glyph bitmaps in a relatively
   *   memory-efficient way.  You can also use the API defined in
   *   @FT_CACHE_IMAGE_H if you want to cache arbitrary glyph images,
   *   including scalable outlines.
   *
   *   This macro is deprecated.  Simply include @FT_CACHE_H to have all
   *   small bitmaps-related cache declarations.
   *
   */
#define FT_CACHE_SMALL_BITMAPS_H  FT_CACHE_H
/*************************************************************************
   *
   * @macro:
   *   FT_CACHE_CHARMAP_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   `charmap' API of the FreeType~2 cache sub-system.
   *
   *   This macro is deprecated.  Simply include @FT_CACHE_H to have all
   *   charmap-based cache declarations.
   *
   */
#define FT_CACHE_CHARMAP_H  FT_CACHE_H
/*************************************************************************
   *
   * @macro:
   *   FT_MAC_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   Macintosh-specific FreeType~2 API.  The latter is used to access
   *   fonts embedded in resource forks.
   *
   *   This header file must be explicitly included by client applications
   *   compiled on the Mac (note that the base API still works though).
   *
   */
#define FT_MAC_H  <freetype/ftmac.h>
/*************************************************************************
   *
   * @macro:
   *   FT_MULTIPLE_MASTERS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   optional multiple-masters management API of FreeType~2.
   *
   */
#define FT_MULTIPLE_MASTERS_H  <freetype/ftmm.h>
/*************************************************************************
   *
   * @macro:
   *   FT_SFNT_NAMES_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   optional FreeType~2 API which accesses embedded `name' strings in
   *   SFNT-based font formats (i.e., TrueType and OpenType).
   *
   */
#define FT_SFNT_NAMES_H  <freetype/ftsnames.h>
/*************************************************************************
   *
   * @macro:
   *   FT_OPENTYPE_VALIDATE_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   optional FreeType~2 API which validates OpenType tables (BASE, GDEF,
   *   GPOS, GSUB, JSTF).
   *
   */
#define FT_OPENTYPE_VALIDATE_H  <freetype/ftotval.h>
/*************************************************************************
   *
   * @macro:
   *   FT_GX_VALIDATE_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   optional FreeType~2 API which validates TrueTypeGX/AAT tables (feat,
   *   mort, morx, bsln, just, kern, opbd, trak, prop).
   *
   */
#define FT_GX_VALIDATE_H  <freetype/ftgxval.h>
/*************************************************************************
   *
   * @macro:
   *   FT_PFR_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which accesses PFR-specific data.
   *
   */
#define FT_PFR_H  <freetype/ftpfr.h>
/*************************************************************************
   *
   * @macro:
   *   FT_STROKER_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which provides functions to stroke outline paths.
   */
#define FT_STROKER_H  <freetype/ftstroke.h>
/*************************************************************************
   *
   * @macro:
   *   FT_SYNTHESIS_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which performs artificial obliquing and emboldening.
   */
#define FT_SYNTHESIS_H  <freetype/ftsynth.h>
/*************************************************************************
   *
   * @macro:
   *   FT_XFREE86_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which provides functions specific to the XFree86 and
   *   X.Org X11 servers.
   */
#define FT_XFREE86_H  <freetype/ftxf86.h>
/*************************************************************************
   *
   * @macro:
   *   FT_TRIGONOMETRY_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which performs trigonometric computations (e.g.,
   *   cosines and arc tangents).
   */
#define FT_TRIGONOMETRY_H  <freetype/fttrigon.h>
/*************************************************************************
   *
   * @macro:
   *   FT_LCD_FILTER_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which performs color filtering for subpixel rendering.
   */
#define FT_LCD_FILTER_H  <freetype/ftlcdfil.h>
/*************************************************************************
   *
   * @macro:
   *   FT_UNPATENTED_HINTING_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which performs color filtering for subpixel rendering.
   */
#define FT_UNPATENTED_HINTING_H  <freetype/ttunpat.h>
/*************************************************************************
   *
   * @macro:
   *   FT_INCREMENTAL_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which performs color filtering for subpixel rendering.
   */
#define FT_INCREMENTAL_H  <freetype/ftincrem.h>
/*************************************************************************
   *
   * @macro:
   *   FT_GASP_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which returns entries from the TrueType GASP table.
   */
#define FT_GASP_H  <freetype/ftgasp.h>
/*************************************************************************
   *
   * @macro:
   *   FT_ADVANCES_H
   *
   * @description:
   *   A macro used in #include statements to name the file containing the
   *   FreeType~2 API which returns individual and ranged glyph advances.
   */
#define FT_ADVANCES_H  <freetype/ftadvanc.h>
/* */
#define FT_ERROR_DEFINITIONS_H  <freetype/fterrdef.h>
/* The internals of the cache sub-system are no longer exposed.  We */
/* default to FT_CACHE_H at the moment just in case, but we know of */
/* no rogue client that uses them.                                  */
/*                                                                  */
#define FT_CACHE_MANAGER_H           <freetype/ftcache.h>
#define FT_CACHE_INTERNAL_MRU_H      <freetype/ftcache.h>
#define FT_CACHE_INTERNAL_MANAGER_H  <freetype/ftcache.h>
#define FT_CACHE_INTERNAL_CACHE_H    <freetype/ftcache.h>
#define FT_CACHE_INTERNAL_GLYPH_H    <freetype/ftcache.h>
#define FT_CACHE_INTERNAL_IMAGE_H    <freetype/ftcache.h>
#define FT_CACHE_INTERNAL_SBITS_H    <freetype/ftcache.h>
#define FT_INCREMENTAL_H          <freetype/ftincrem.h>
#define FT_TRUETYPE_UNPATENTED_H  <freetype/ttunpat.h>
/*
   * Include internal headers definitions from <freetype/internal/...>
   * only when building the library.
   */
#ifdef FT2_BUILD_LIBRARY
#define  FT_INTERNAL_INTERNAL_H  <freetype/internal/internal.h>
/***************************************************************************/
/*                                                                         */
/*  internal.h                                                             */
/*                                                                         */
/*    Internal header files (specification only).                          */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2003, 2004 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This file is automatically included by `ft2build.h'.                  */
/* Do not include it manually!                                           */
/*                                                                       */
/*************************************************************************/
#define FT_INTERNAL_OBJECTS_H             <freetype/internal/ftobjs.h>
#define FT_INTERNAL_PIC_H                 <freetype/internal/ftpic.h>
#define FT_INTERNAL_STREAM_H              <freetype/internal/ftstream.h>
#define FT_INTERNAL_MEMORY_H              <freetype/internal/ftmemory.h>
#define FT_INTERNAL_DEBUG_H               <freetype/internal/ftdebug.h>
#define FT_INTERNAL_CALC_H                <freetype/internal/ftcalc.h>
#define FT_INTERNAL_DRIVER_H              <freetype/internal/ftdriver.h>
#define FT_INTERNAL_TRACE_H               <freetype/internal/fttrace.h>
#define FT_INTERNAL_GLYPH_LOADER_H        <freetype/internal/ftgloadr.h>
#define FT_INTERNAL_SFNT_H                <freetype/internal/sfnt.h>
#define FT_INTERNAL_SERVICE_H             <freetype/internal/ftserv.h>
#define FT_INTERNAL_RFORK_H               <freetype/internal/ftrfork.h>
#define FT_INTERNAL_VALIDATE_H            <freetype/internal/ftvalid.h>
#define FT_INTERNAL_TRUETYPE_TYPES_H      <freetype/internal/tttypes.h>
#define FT_INTERNAL_TYPE1_TYPES_H         <freetype/internal/t1types.h>
#define FT_INTERNAL_POSTSCRIPT_AUX_H      <freetype/internal/psaux.h>
#define FT_INTERNAL_POSTSCRIPT_HINTS_H    <freetype/internal/pshints.h>
#define FT_INTERNAL_POSTSCRIPT_GLOBALS_H  <freetype/internal/psglobal.h>
#define FT_INTERNAL_AUTOHINT_H            <freetype/internal/autohint.h>
/* END */
/* FT2_BUILD_LIBRARY */
#endif  
/* __FT2_BUILD_H__ */
#endif  
/* END */
/* __FT2_BUILD_GENERIC_H__ */
#endif  
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftconfig.h                                                             */
/*                                                                         */
/*    ANSI-specific configuration file (specification only).               */
/*                                                                         */
/*  Copyright 1996-2004, 2006-2008, 2010-2011 by                           */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This header file contains a number of macro definitions that are used */
/* by the rest of the engine.  Most of the macros here are automatically */
/* determined at compile time, and you should not need to change it to   */
/* port FreeType, except to compile the library with a non-ANSI          */
/* compiler.                                                             */
/*                                                                       */
/* Note however that if some specific modifications are needed, we       */
/* advise you to place a modified copy in your build directory.          */
/*                                                                       */
/* The build directory is usually `freetype/builds/<system>', and        */
/* contains system-specific files that are always included first when    */
/* building the library.                                                 */
/*                                                                       */
/* This ANSI version should stay in `include/freetype/config'.           */
/*                                                                       */
/*************************************************************************/
#define __FTCONFIG_H__
/***************************************************************************/
/*                                                                         */
/*  ftoption.h                                                             */
/*                                                                         */
/*    User-selectable configuration macros (specification only).           */
/*                                                                         */
/*  Copyright 1996-2012 by                                                 */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTOPTION_H__
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/*                 USER-SELECTABLE CONFIGURATION MACROS                  */
/*                                                                       */
/* This file contains the default configuration macro definitions for    */
/* a standard build of the FreeType library.  There are three ways to    */
/* use this file to build project-specific versions of the library:      */
/*                                                                       */
/*  - You can modify this file by hand, but this is not recommended in   */
/*    cases where you would like to build several versions of the        */
/*    library from a single source directory.                            */
/*                                                                       */
/*  - You can put a copy of this file in your build directory, more      */
/*    precisely in `$BUILD/freetype/config/ftoption.h', where `$BUILD'   */
/*    is the name of a directory that is included _before_ the FreeType  */
/*    include path during compilation.                                   */
/*                                                                       */
/*    The default FreeType Makefiles and Jamfiles use the build          */
/*    directory `builds/<system>' by default, but you can easily change  */
/*    that for your own projects.                                        */
/*                                                                       */
/*  - Copy the file <ft2build.h> to `$BUILD/ft2build.h' and modify it    */
/*    slightly to pre-define the macro FT_CONFIG_OPTIONS_H used to       */
/*    locate this file during the build.  For example,                   */
/*                                                                       */
/*      #define FT_CONFIG_OPTIONS_H  <myftoptions.h>                     */
/*      #include <freetype/config/ftheader.h>                            */
/*                                                                       */
/*    will use `$BUILD/myftoptions.h' instead of this file for macro     */
/*    definitions.                                                       */
/*                                                                       */
/*    Note also that you can similarly pre-define the macro              */
/*    FT_CONFIG_MODULES_H used to locate the file listing of the modules */
/*    that are statically linked to the library at compile time.  By     */
/*    default, this file is <freetype/config/ftmodule.h>.                */
/*                                                                       */
/*  We highly recommend using the third method whenever possible.        */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/**** G E N E R A L   F R E E T Y P E   2   C O N F I G U R A T I O N ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Uncomment the line below if you want to activate sub-pixel rendering  */
/* (a.k.a. LCD rendering, or ClearType) in this build of the library.    */
/*                                                                       */
/* Note that this feature is covered by several Microsoft patents        */
/* and should not be activated in any default build of the library.      */
/*                                                                       */
/* This macro has no impact on the FreeType API, only on its             */
/* _implementation_.  For example, using FT_RENDER_MODE_LCD when calling */
/* FT_Render_Glyph still generates a bitmap that is 3 times wider than   */
/* the original size in case this macro isn't defined; however, each     */
/* triplet of subpixels has R=G=B.                                       */
/*                                                                       */
/* This is done to allow FreeType clients to run unmodified, forcing     */
/* them to display normal gray-level anti-aliased glyphs.                */
/*                                                                       */
#define FT_CONFIG_OPTION_SUBPIXEL_RENDERING
/*************************************************************************/
/*                                                                       */
/* Many compilers provide a non-ANSI 64-bit data type that can be used   */
/* by FreeType to speed up some computations.  However, this will create */
/* some problems when compiling the library in strict ANSI mode.         */
/*                                                                       */
/* For this reason, the use of 64-bit integers is normally disabled when */
/* the __STDC__ macro is defined.  You can however disable this by       */
/* defining the macro FT_CONFIG_OPTION_FORCE_INT64 here.                 */
/*                                                                       */
/* For most compilers, this will only create compilation warnings when   */
/* building the library.                                                 */
/*                                                                       */
/* ObNote: The compiler-specific 64-bit integers are detected in the     */
/*         file `ftconfig.h' either statically or through the            */
/*         `configure' script on supported platforms.                    */
/*                                                                       */
#undef FT_CONFIG_OPTION_FORCE_INT64
/*************************************************************************/
/*                                                                       */
/* If this macro is defined, do not try to use an assembler version of   */
/* performance-critical functions (e.g. FT_MulFix).  You should only do  */
/* that to verify that the assembler function works properly, or to      */
/* execute benchmark tests of the various implementations.               */
/* #define FT_CONFIG_OPTION_NO_ASSEMBLER */
#undef FT_CONFIG_OPTION_NO_ASSEMBLER
/*************************************************************************/
/*                                                                       */
/* If this macro is defined, try to use an inlined assembler version of  */
/* the `FT_MulFix' function, which is a `hotspot' when loading and       */
/* hinting glyphs, and which should be executed as fast as possible.     */
/*                                                                       */
/* Note that if your compiler or CPU is not supported, this will default */
/* to the standard and portable implementation found in `ftcalc.c'.      */
/*                                                                       */
#define FT_CONFIG_OPTION_INLINE_MULFIX
/*************************************************************************/
/*                                                                       */
/* LZW-compressed file support.                                          */
/*                                                                       */
/*   FreeType now handles font files that have been compressed with the  */
/*   `compress' program.  This is mostly used to parse many of the PCF   */
/*   files that come with various X11 distributions.  The implementation */
/*   uses NetBSD's `zopen' to partially uncompress the file on the fly   */
/*   (see src/lzw/ftgzip.c).                                             */
/*                                                                       */
/*   Define this macro if you want to enable this `feature'.             */
/*                                                                       */
/* #define FT_CONFIG_OPTION_USE_LZW */
#undef FT_CONFIG_OPTION_USE_LZW
/*************************************************************************/
/*                                                                       */
/* Gzip-compressed file support.                                         */
/*                                                                       */
/*   FreeType now handles font files that have been compressed with the  */
/*   `gzip' program.  This is mostly used to parse many of the PCF files */
/*   that come with XFree86.  The implementation uses `zlib' to          */
/*   partially uncompress the file on the fly (see src/gzip/ftgzip.c).   */
/*                                                                       */
/*   Define this macro if you want to enable this `feature'.  See also   */
/*   the macro FT_CONFIG_OPTION_SYSTEM_ZLIB below.                       */
/*                                                                       */
/* #define FT_CONFIG_OPTION_USE_ZLIB */
#undef FT_CONFIG_OPTION_USE_ZLIB
/*************************************************************************/
/*                                                                       */
/* ZLib library selection                                                */
/*                                                                       */
/*   This macro is only used when FT_CONFIG_OPTION_USE_ZLIB is defined.  */
/*   It allows FreeType's `ftgzip' component to link to the system's     */
/*   installation of the ZLib library.  This is useful on systems like   */
/*   Unix or VMS where it generally is already available.                */
/*                                                                       */
/*   If you let it undefined, the component will use its own copy        */
/*   of the zlib sources instead.  These have been modified to be        */
/*   included directly within the component and *not* export external    */
/*   function names.  This allows you to link any program with FreeType  */
/*   _and_ ZLib without linking conflicts.                               */
/*                                                                       */
/*   Do not #undef this macro here since the build system might define   */
/*   it for certain configurations only.                                 */
/*                                                                       */
/* #define FT_CONFIG_OPTION_SYSTEM_ZLIB */
 #undef FT_CONFIG_OPTION_SYSTEM_ZLIB
/*************************************************************************/
/*                                                                       */
/* Bzip2-compressed file support.                                        */
/*                                                                       */
/*   FreeType now handles font files that have been compressed with the  */
/*   `bzip2' program.  This is mostly used to parse many of the PCF      */
/*   files that come with XFree86.  The implementation uses `libbz2' to  */
/*   partially uncompress the file on the fly (see src/bzip2/ftbzip2.c). */
/*   Contrary to gzip, bzip2 currently is not included and need to use   */
/*   the system available bzip2 implementation.                          */
/*                                                                       */
/*   Define this macro if you want to enable this `feature'.             */
/*                                                                       */
/* #define FT_CONFIG_OPTION_USE_BZIP2 */
#undef FT_CONFIG_OPTION_USE_BZIP2
/*************************************************************************/
/*                                                                       */
/* Define to disable the use of file stream functions and types, FILE,   */
/* fopen() etc.  Enables the use of smaller system libraries on embedded */
/* systems that have multiple system libraries, some with or without     */
/* file stream support, in the cases where file stream support is not    */
/* necessary such as memory loading of font files.                       */
/*                                                                       */
/* #define FT_CONFIG_OPTION_DISABLE_STREAM_SUPPORT */
#undef FT_CONFIG_OPTION_DISABLE_STREAM_SUPPORT
/*************************************************************************/
/*                                                                       */
/* DLL export compilation                                                */
/*                                                                       */
/*   When compiling FreeType as a DLL, some systems/compilers need a     */
/*   special keyword in front OR after the return type of function       */
/*   declarations.                                                       */
/*                                                                       */
/*   Two macros are used within the FreeType source code to define       */
/*   exported library functions: FT_EXPORT and FT_EXPORT_DEF.            */
/*                                                                       */
/*     FT_EXPORT( return_type )                                          */
/*                                                                       */
/*       is used in a function declaration, as in                        */
/*                                                                       */
/*         FT_EXPORT( FT_Error )                                         */
/*         FT_Init_FreeType( FT_Library*  alibrary );                    */
/*                                                                       */
/*                                                                       */
/*     FT_EXPORT_DEF( return_type )                                      */
/*                                                                       */
/*       is used in a function definition, as in                         */
/*                                                                       */
/*         FT_EXPORT_DEF( FT_Error )                                     */
/*         FT_Init_FreeType( FT_Library*  alibrary )                     */
/*         {                                                             */
/*           ... some code ...                                           */
/*           return FT_Err_Ok;                                           */
/*         }                                                             */
/*                                                                       */
/*   You can provide your own implementation of FT_EXPORT and            */
/*   FT_EXPORT_DEF here if you want.  If you leave them undefined, they  */
/*   will be later automatically defined as `extern return_type' to      */
/*   allow normal compilation.                                           */
/*                                                                       */
/*   Do not #undef these macros here since the build system might define */
/*   them for certain configurations only.                               */
/*                                                                       */
/* #define FT_EXPORT(x)      extern x */
/* #define FT_EXPORT_DEF(x)  x */
/*************************************************************************/
/*                                                                       */
/* Glyph Postscript Names handling                                       */
/*                                                                       */
/*   By default, FreeType 2 is compiled with the `psnames' module.  This */
/*   module is in charge of converting a glyph name string into a        */
/*   Unicode value, or return a Macintosh standard glyph name for the    */
/*   use with the TrueType `post' table.                                 */
/*                                                                       */
/*   Undefine this macro if you do not want `psnames' compiled in your   */
/*   build of FreeType.  This has the following effects:                 */
/*                                                                       */
/*   - The TrueType driver will provide its own set of glyph names,      */
/*     if you build it to support postscript names in the TrueType       */
/*     `post' table.                                                     */
/*                                                                       */
/*   - The Type 1 driver will not be able to synthesize a Unicode        */
/*     charmap out of the glyphs found in the fonts.                     */
/*                                                                       */
/*   You would normally undefine this configuration macro when building  */
/*   a version of FreeType that doesn't contain a Type 1 or CFF driver.  */
/*                                                                       */
#define FT_CONFIG_OPTION_POSTSCRIPT_NAMES
/*************************************************************************/
/*                                                                       */
/* Postscript Names to Unicode Values support                            */
/*                                                                       */
/*   By default, FreeType 2 is built with the `PSNames' module compiled  */
/*   in.  Among other things, the module is used to convert a glyph name */
/*   into a Unicode value.  This is especially useful in order to        */
/*   synthesize on the fly a Unicode charmap from the CFF/Type 1 driver  */
/*   through a big table named the `Adobe Glyph List' (AGL).             */
/*                                                                       */
/*   Undefine this macro if you do not want the Adobe Glyph List         */
/*   compiled in your `PSNames' module.  The Type 1 driver will not be   */
/*   able to synthesize a Unicode charmap out of the glyphs found in the */
/*   fonts.                                                              */
/*                                                                       */
#define FT_CONFIG_OPTION_ADOBE_GLYPH_LIST
/*************************************************************************/
/*                                                                       */
/* Support for Mac fonts                                                 */
/*                                                                       */
/*   Define this macro if you want support for outline fonts in Mac      */
/*   format (mac dfont, mac resource, macbinary containing a mac         */
/*   resource) on non-Mac platforms.                                     */
/*                                                                       */
/*   Note that the `FOND' resource isn't checked.                        */
/*                                                                       */
#define FT_CONFIG_OPTION_MAC_FONTS
/*************************************************************************/
/*                                                                       */
/* Guessing methods to access embedded resource forks                    */
/*                                                                       */
/*   Enable extra Mac fonts support on non-Mac platforms (e.g.           */
/*   GNU/Linux).                                                         */
/*                                                                       */
/*   Resource forks which include fonts data are stored sometimes in     */
/*   locations which users or developers don't expected.  In some cases, */
/*   resource forks start with some offset from the head of a file.  In  */
/*   other cases, the actual resource fork is stored in file different   */
/*   from what the user specifies.  If this option is activated,         */
/*   FreeType tries to guess whether such offsets or different file      */
/*   names must be used.                                                 */
/*                                                                       */
/*   Note that normal, direct access of resource forks is controlled via */
/*   the FT_CONFIG_OPTION_MAC_FONTS option.                              */
/*                                                                       */
#define FT_CONFIG_OPTION_GUESSING_EMBEDDED_RFORK
/*************************************************************************/
/*                                                                       */
/* Allow the use of FT_Incremental_Interface to load typefaces that      */
/* contain no glyph data, but supply it via a callback function.         */
/* This is required by clients supporting document formats which         */
/* supply font data incrementally as the document is parsed, such        */
/* as the Ghostscript interpreter for the PostScript language.           */
/*                                                                       */
#define FT_CONFIG_OPTION_INCREMENTAL
/*************************************************************************/
/*                                                                       */
/* The size in bytes of the render pool used by the scan-line converter  */
/* to do all of its work.                                                */
/*                                                                       */
/* This must be greater than 4KByte if you use FreeType to rasterize     */
/* glyphs; otherwise, you may set it to zero to avoid unnecessary        */
/* allocation of the render pool.                                        */
/*                                                                       */
#define FT_RENDER_POOL_SIZE  16384L
/*************************************************************************/
/*                                                                       */
/* FT_MAX_MODULES                                                        */
/*                                                                       */
/*   The maximum number of modules that can be registered in a single    */
/*   FreeType library object.  32 is the default.                        */
/*                                                                       */
#define FT_MAX_MODULES  32
/*************************************************************************/
/*                                                                       */
/* Debug level                                                           */
/*                                                                       */
/*   FreeType can be compiled in debug or trace mode.  In debug mode,    */
/*   errors are reported through the `ftdebug' component.  In trace      */
/*   mode, additional messages are sent to the standard output during    */
/*   execution.                                                          */
/*                                                                       */
/*   Define FT_DEBUG_LEVEL_ERROR to build the library in debug mode.     */
/*   Define FT_DEBUG_LEVEL_TRACE to build it in trace mode.              */
/*                                                                       */
/*   Don't define any of these macros to compile in `release' mode!      */
/*                                                                       */
/*   Do not #undef these macros here since the build system might define */
/*   them for certain configurations only.                               */
/*                                                                       */
/* #define FT_DEBUG_LEVEL_ERROR */
/* #define FT_DEBUG_LEVEL_TRACE */
#undef FT_DEBUG_LEVEL_ERROR
#undef FT_DEBUG_LEVEL_TRACE 
/*************************************************************************/
/*                                                                       */
/* Autofitter debugging                                                  */
/*                                                                       */
/*   If FT_DEBUG_AUTOFIT is defined, FreeType provides some means to     */
/*   control the autofitter behaviour for debugging purposes with global */
/*   boolean variables (consequently, you should *never* enable this     */
/*   while compiling in `release' mode):                                 */
/*                                                                       */
/*     _af_debug_disable_horz_hints                                      */
/*     _af_debug_disable_vert_hints                                      */
/*     _af_debug_disable_blue_hints                                      */
/*                                                                       */
/*   Additionally, the following functions provide dumps of various      */
/*   internal autofit structures to stdout (using `printf'):             */
/*                                                                       */
/*     af_glyph_hints_dump_points                                        */
/*     af_glyph_hints_dump_segments                                      */
/*     af_glyph_hints_dump_edges                                         */
/*                                                                       */
/*   As an argument, they use another global variable:                   */
/*                                                                       */
/*     _af_debug_hints                                                   */
/*                                                                       */
/*   Please have a look at the `ftgrid' demo program to see how those    */
/*   variables and macros should be used.                                */
/*                                                                       */
/*   Do not #undef these macros here since the build system might define */
/*   them for certain configurations only.                               */
/*                                                                       */
/* #define FT_DEBUG_AUTOFIT */
#undef FT_DEBUG_AUTOFIT
/*************************************************************************/
/*                                                                       */
/* Memory Debugging                                                      */
/*                                                                       */
/*   FreeType now comes with an integrated memory debugger that is       */
/*   capable of detecting simple errors like memory leaks or double      */
/*   deletes.  To compile it within your build of the library, you       */
/*   should define FT_DEBUG_MEMORY here.                                 */
/*                                                                       */
/*   Note that the memory debugger is only activated at runtime when     */
/*   when the _environment_ variable `FT2_DEBUG_MEMORY' is defined also! */
/*                                                                       */
/*   Do not #undef this macro here since the build system might define   */
/*   it for certain configurations only.                                 */
/*                                                                       */
/* #define FT_DEBUG_MEMORY */
#undef FT_DEBUG_MEMORY
/*************************************************************************/
/*                                                                       */
/* Module errors                                                         */
/*                                                                       */
/*   If this macro is set (which is _not_ the default), the higher byte  */
/*   of an error code gives the module in which the error has occurred,  */
/*   while the lower byte is the real error code.                        */
/*                                                                       */
/*   Setting this macro makes sense for debugging purposes only, since   */
/*   it would break source compatibility of certain programs that use    */
/*   FreeType 2.                                                         */
/*                                                                       */
/*   More details can be found in the files ftmoderr.h and fterrors.h.   */
/*                                                                       */
#undef FT_CONFIG_OPTION_USE_MODULE_ERRORS
/*************************************************************************/
/*                                                                       */
/* Position Independent Code                                             */
/*                                                                       */
/*   If this macro is set (which is _not_ the default), FreeType2 will   */
/*   avoid creating constants that require address fixups.  Instead the  */
/*   constants will be moved into a struct and additional intialization  */
/*   code will be used.                                                  */
/*                                                                       */
/*   Setting this macro is needed for systems that prohibit address      */
/*   fixups, such as BREW.                                               */
/*                                                                       */
/* #define FT_CONFIG_OPTION_PIC */
#undef FT_CONFIG_OPTION_PIC
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****        S F N T   D R I V E R    C O N F I G U R A T I O N       ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_EMBEDDED_BITMAPS if you want to support       */
/* embedded bitmaps in all formats using the SFNT module (namely         */
/* TrueType & OpenType).                                                 */
/*                                                                       */
#define TT_CONFIG_OPTION_EMBEDDED_BITMAPS
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_POSTSCRIPT_NAMES if you want to be able to    */
/* load and enumerate the glyph Postscript names in a TrueType or        */
/* OpenType file.                                                        */
/*                                                                       */
/* Note that when you do not compile the `PSNames' module by undefining  */
/* the above FT_CONFIG_OPTION_POSTSCRIPT_NAMES, the `sfnt' module will   */
/* contain additional code used to read the PS Names table from a font.  */
/*                                                                       */
/* (By default, the module uses `PSNames' to extract glyph names.)       */
/*                                                                       */
#define TT_CONFIG_OPTION_POSTSCRIPT_NAMES
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_SFNT_NAMES if your applications need to       */
/* access the internal name table in a SFNT-based format like TrueType   */
/* or OpenType.  The name table contains various strings used to         */
/* describe the font, like family name, copyright, version, etc.  It     */
/* does not contain any glyph name though.                               */
/*                                                                       */
/* Accessing SFNT names is done through the functions declared in        */
/* `freetype/ftsnames.h'.                                                */
/*                                                                       */
#define TT_CONFIG_OPTION_SFNT_NAMES
/*************************************************************************/
/*                                                                       */
/* TrueType CMap support                                                 */
/*                                                                       */
/*   Here you can fine-tune which TrueType CMap table format shall be    */
/*   supported.                                                          */
#define TT_CONFIG_CMAP_FORMAT_0
#define TT_CONFIG_CMAP_FORMAT_2
#define TT_CONFIG_CMAP_FORMAT_4
#define TT_CONFIG_CMAP_FORMAT_6
#define TT_CONFIG_CMAP_FORMAT_8
#define TT_CONFIG_CMAP_FORMAT_10
#define TT_CONFIG_CMAP_FORMAT_12
#define TT_CONFIG_CMAP_FORMAT_13
#define TT_CONFIG_CMAP_FORMAT_14
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****    T R U E T Y P E   D R I V E R    C O N F I G U R A T I O N   ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_BYTECODE_INTERPRETER if you want to compile   */
/* a bytecode interpreter in the TrueType driver.                        */
/*                                                                       */
/* By undefining this, you will only compile the code necessary to load  */
/* TrueType glyphs without hinting.                                      */
/*                                                                       */
/*   Do not #undef this macro here, since the build system might         */
/*   define it for certain configurations only.                          */
/*                                                                       */
#define TT_CONFIG_OPTION_BYTECODE_INTERPRETER
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_SUBPIXEL_HINTING if you want to compile       */
/* EXPERIMENTAL subpixel hinting support into the TrueType driver.  This */
/* replaces the native TrueType hinting mechanism when anything but      */
/* FT_RENDER_MODE_MONO is requested.                                     */
/*                                                                       */
/* Enabling this causes the TrueType driver to ignore instructions under */
/* certain conditions.  This is done in accordance with the guide here,  */
/* with some minor differences:                                          */
/*                                                                       */
/*  http://www.microsoft.com/typography/cleartype/truetypecleartype.aspx */
/*                                                                       */
/* By undefining this, you only compile the code necessary to hint       */
/* TrueType glyphs with native TT hinting.                               */
/*                                                                       */
/*   This option requires TT_CONFIG_OPTION_BYTECODE_INTERPRETER to be    */
/*   defined.                                                            */
/*                                                                       */
/* #define TT_CONFIG_OPTION_SUBPIXEL_HINTING */
#undef TT_CONFIG_OPTION_SUBPIXEL_HINTING
/*************************************************************************/
/*                                                                       */
/* If you define TT_CONFIG_OPTION_UNPATENTED_HINTING, a special version  */
/* of the TrueType bytecode interpreter is used that doesn't implement   */
/* any of the patented opcodes and algorithms.  The patents related to   */
/* TrueType hinting have expired worldwide since May 2010; this option   */
/* is now deprecated.                                                    */
/*                                                                       */
/* Note that the TT_CONFIG_OPTION_UNPATENTED_HINTING macro is *ignored*  */
/* if you define TT_CONFIG_OPTION_BYTECODE_INTERPRETER; in other words,  */
/* either define TT_CONFIG_OPTION_BYTECODE_INTERPRETER or                */
/* TT_CONFIG_OPTION_UNPATENTED_HINTING but not both at the same time.    */
/*                                                                       */
/* This macro is only useful for a small number of font files (mostly    */
/* for Asian scripts) that require bytecode interpretation to properly   */
/* load glyphs.  For all other fonts, this produces unpleasant results,  */
/* thus the unpatented interpreter is never used to load glyphs from     */
/* TrueType fonts unless one of the following two options is used.       */
/*                                                                       */
/*   - The unpatented interpreter is explicitly activated by the user    */
/*     through the FT_PARAM_TAG_UNPATENTED_HINTING parameter tag         */
/*     when opening the FT_Face.                                         */
/*                                                                       */
/*   - FreeType detects that the FT_Face corresponds to one of the       */
/*     `trick' fonts (e.g., `Mingliu') it knows about.  The font engine  */
/*     contains a hard-coded list of font names and other matching       */
/*     parameters (see function `tt_face_init' in file                   */
/*     `src/truetype/ttobjs.c').                                         */
/*                                                                       */
/* Here a sample code snippet for using FT_PARAM_TAG_UNPATENTED_HINTING. */
/*                                                                       */
/*   {                                                                   */
/*     FT_Parameter  parameter;                                          */
/*     FT_Open_Args  open_args;                                          */
/*                                                                       */
/*                                                                       */
/*     parameter.tag = FT_PARAM_TAG_UNPATENTED_HINTING;                  */
/*                                                                       */
/*     open_args.flags      = FT_OPEN_PATHNAME | FT_OPEN_PARAMS;         */
/*     open_args.pathname   = my_font_pathname;                          */
/*     open_args.num_params = 1;                                         */
/*     open_args.params     = &parameter;                                */
/*                                                                       */
/*     error = FT_Open_Face( library, &open_args, index, &face );        */
/*     ...                                                               */
/*   }                                                                   */
/*                                                                       */
/* #define TT_CONFIG_OPTION_UNPATENTED_HINTING */
#undef TT_CONFIG_OPTION_UNPATENTED_HINTING
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_INTERPRETER_SWITCH to compile the TrueType    */
/* bytecode interpreter with a huge switch statement, rather than a call */
/* table.  This results in smaller and faster code for a number of       */
/* architectures.                                                        */
/*                                                                       */
/* Note however that on some compiler/processor combinations, undefining */
/* this macro will generate faster, though larger, code.                 */
/*                                                                       */
#define TT_CONFIG_OPTION_INTERPRETER_SWITCH
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_COMPONENT_OFFSET_SCALED to compile the        */
/* TrueType glyph loader to use Apple's definition of how to handle      */
/* component offsets in composite glyphs.                                */
/*                                                                       */
/* Apple and MS disagree on the default behavior of component offsets    */
/* in composites.  Apple says that they should be scaled by the scaling  */
/* factors in the transformation matrix (roughly, it's more complex)     */
/* while MS says they should not.  OpenType defines two bits in the      */
/* composite flags array which can be used to disambiguate, but old      */
/* fonts will not have them.                                             */
/*                                                                       */
/*   http://www.microsoft.com/typography/otspec/glyf.htm                 */
/*   http://fonts.apple.com/TTRefMan/RM06/Chap6glyf.html                 */
/*                                                                       */
#undef TT_CONFIG_OPTION_COMPONENT_OFFSET_SCALED
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_GX_VAR_SUPPORT if you want to include         */
/* support for Apple's distortable font technology (fvar, gvar, cvar,    */
/* and avar tables).  This has many similarities to Type 1 Multiple      */
/* Masters support.                                                      */
/*                                                                       */
#define TT_CONFIG_OPTION_GX_VAR_SUPPORT
/*************************************************************************/
/*                                                                       */
/* Define TT_CONFIG_OPTION_BDF if you want to include support for        */
/* an embedded `BDF ' table within SFNT-based bitmap formats.            */
/*                                                                       */
#define TT_CONFIG_OPTION_BDF
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****      T Y P E 1   D R I V E R    C O N F I G U R A T I O N       ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* T1_MAX_DICT_DEPTH is the maximum depth of nest dictionaries and       */
/* arrays in the Type 1 stream (see t1load.c).  A minimum of 4 is        */
/* required.                                                             */
/*                                                                       */
#define T1_MAX_DICT_DEPTH  5
/*************************************************************************/
/*                                                                       */
/* T1_MAX_SUBRS_CALLS details the maximum number of nested sub-routine   */
/* calls during glyph loading.                                           */
/*                                                                       */
#define T1_MAX_SUBRS_CALLS  16
/*************************************************************************/
/*                                                                       */
/* T1_MAX_CHARSTRING_OPERANDS is the charstring stack's capacity.  A     */
/* minimum of 16 is required.                                            */
/*                                                                       */
/* The Chinese font MingTiEG-Medium (CNS 11643 character set) needs 256. */
/*                                                                       */
#define T1_MAX_CHARSTRINGS_OPERANDS  256
/*************************************************************************/
/*                                                                       */
/* Define this configuration macro if you want to prevent the            */
/* compilation of `t1afm', which is in charge of reading Type 1 AFM      */
/* files into an existing face.  Note that if set, the T1 driver will be */
/* unable to produce kerning distances.                                  */
/*                                                                       */
#undef T1_CONFIG_OPTION_NO_AFM
/*************************************************************************/
/*                                                                       */
/* Define this configuration macro if you want to prevent the            */
/* compilation of the Multiple Masters font support in the Type 1        */
/* driver.                                                               */
/*                                                                       */
#undef T1_CONFIG_OPTION_NO_MM_SUPPORT
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****    A U T O F I T   M O D U L E    C O N F I G U R A T I O N     ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Compile autofit module with CJK (Chinese, Japanese, Korean) script    */
/* support.                                                              */
/*                                                                       */
#define AF_CONFIG_OPTION_CJK
/*************************************************************************/
/*                                                                       */
/* Compile autofit module with Indic script support.                     */
/*                                                                       */
#define AF_CONFIG_OPTION_INDIC
/*************************************************************************/
/*                                                                       */
/* Compile autofit module with warp hinting.  The idea of the warping    */
/* code is to slightly scale and shift a glyph within a single dimension */
/* so that as much of its segments are aligned (more or less) on the     */
/* grid.  To find out the optimal scaling and shifting value, various    */
/* parameter combinations are tried and scored.                          */
/*                                                                       */
/* This experimental option is only active if the render mode is         */
/* FT_RENDER_MODE_LIGHT.                                                 */
/*                                                                       */
/* #define AF_CONFIG_OPTION_USE_WARPER */
#undef AF_CONFIG_OPTION_USE_WARPER
/* */
/*
   * Define this variable if you want to keep the layout of internal
   * structures that was used prior to FreeType 2.2.  This also compiles in
   * a few obsolete functions to avoid linking problems on typical Unix
   * distributions.
   *
   * For embedded systems or building a new distribution from scratch, it
   * is recommended to disable the macro since it reduces the library's code
   * size and activates a few memory-saving optimizations as well.
   */
/* #define FT_CONFIG_OPTION_OLD_INTERNALS*/
#undef FT_CONFIG_OPTION_OLD_INTERNALS
/*
   *  To detect legacy cache-lookup call from a rogue client (<= 2.1.7),
   *  we restrict the number of charmaps in a font.  The current API of
   *  FTC_CMapCache_Lookup() takes cmap_index & charcode, but old API
   *  takes charcode only.  To determine the passed value is for cmap_index
   *  or charcode, the possible cmap_index is restricted not to exceed
   *  the minimum possible charcode by a rogue client.  It is also very
   *  unlikely that a rogue client is interested in Unicode values 0 to 15.
   *
   *  NOTE: The original threshold was 4 deduced from popular number of
   *        cmap subtables in UCS-4 TrueType fonts, but now it is not
   *        irregular for OpenType fonts to have more than 4 subtables,
   *        because variation selector subtables are available for Apple
   *        and Microsoft platforms.
   */
/*
   * This macro is defined if either unpatented or native TrueType
   * hinting is requested by the definitions above.
   */
#define  TT_USE_BYTECODE_INTERPRETER
#undef   TT_CONFIG_OPTION_UNPATENTED_HINTING
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftstdlib.h                                                             */
/*                                                                         */
/*    ANSI-specific library and header configuration file (specification   */
/*    only).                                                               */
/*                                                                         */
/*  Copyright 2002-2007, 2009, 2011-2012 by                                */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This file is used to group all #includes to the ANSI C library that   */
/* FreeType normally requires.  It also defines macros to rename the     */
/* standard functions within the FreeType source code.                   */
/*                                                                       */
/* Load a file which defines __FTSTDLIB_H__ before this one to override  */
/* it.                                                                   */
/*                                                                       */
/*************************************************************************/
#define __FTSTDLIB_H__
#include <stddef.h>
#define ft_ptrdiff_t  ptrdiff_t
/**********************************************************************/
/*                                                                    */
/*                           integer limits                           */
/*                                                                    */
/* UINT_MAX and ULONG_MAX are used to automatically compute the size  */
/* of `int' and `long' in bytes at compile-time.  So far, this works  */
/* for all platforms the library has been tested on.                  */
/*                                                                    */
/* Note that on the extremely rare platforms that do not provide      */
/* integer types that are _exactly_ 16 and 32 bits wide (e.g. some    */
/* old Crays where `int' is 36 bits), we do not make any guarantee    */
/* about the correct behaviour of FT2 with all fonts.                 */
/*                                                                    */
/* In these case, `ftconfig.h' will refuse to compile anyway with a   */
/* message like `couldn't find 32-bit type' or something similar.     */
/*                                                                    */
/**********************************************************************/
#include <limits.h>
#define FT_CHAR_BIT    CHAR_BIT
#define FT_USHORT_MAX  USHRT_MAX
#define FT_INT_MAX     INT_MAX
#define FT_INT_MIN     INT_MIN
#define FT_UINT_MAX    UINT_MAX
#define FT_ULONG_MAX   ULONG_MAX
/**********************************************************************/
/*                                                                    */
/*                 character and string processing                    */
/*                                                                    */
/**********************************************************************/
#include <string.h>
#define ft_memchr   memchr
#define ft_memcmp   memcmp
#define ft_memcpy   memcpy
#define ft_memmove  memmove
#define ft_memset   memset
#define ft_strcat   strcat
#define ft_strcmp   strcmp
#define ft_strcpy   strcpy
#define ft_strlen   strlen
#define ft_strncmp  strncmp
#define ft_strncpy  strncpy
#define ft_strrchr  strrchr
#define ft_strstr   strstr
/**********************************************************************/
/*                                                                    */
/*                           file handling                            */
/*                                                                    */
/**********************************************************************/
#include <stdio.h>
#define FT_FILE     FILE
#define ft_fclose   fclose
#define ft_fopen    fopen
#define ft_fread    fread
#define ft_fseek    fseek
#define ft_ftell    ftell
#define ft_sprintf  sprintf
/**********************************************************************/
/*                                                                    */
/*                             sorting                                */
/*                                                                    */
/**********************************************************************/
#include <stdlib.h>
#define ft_qsort  qsort
/**********************************************************************/
/*                                                                    */
/*                        memory allocation                           */
/*                                                                    */
/**********************************************************************/
#define ft_scalloc   calloc
#define ft_sfree     free
#define ft_smalloc   malloc
#define ft_srealloc  realloc
/**********************************************************************/
/*                                                                    */
/*                          miscellaneous                             */
/*                                                                    */
/**********************************************************************/
#define ft_atol   atol
#define ft_labs   labs
/**********************************************************************/
/*                                                                    */
/*                         execution control                          */
/*                                                                    */
/**********************************************************************/
#include <setjmp.h>
/* note: this cannot be a typedef since */
#define ft_jmp_buf     jmp_buf   
/*       jmp_buf is defined as a macro  */
/*       on certain platforms           */
#define ft_longjmp     longjmp
/* same thing here */
#define ft_setjmp( b ) setjmp( *(ft_jmp_buf*) &(b) )  
/* the following is only used for debugging purposes, i.e., if */
/* FT_DEBUG_LEVEL_ERROR or FT_DEBUG_LEVEL_TRACE are defined    */
#include <stdarg.h>
/* END */
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/*               PLATFORM-SPECIFIC CONFIGURATION MACROS                  */
/*                                                                       */
/* These macros can be toggled to suit a specific system.  The current   */
/* ones are defaults used to compile FreeType in an ANSI C environment   */
/* (16bit compilers are also supported).  Copy this file to your own     */
/* `freetype/builds/<system>' directory, and edit it to port the engine. */
/*                                                                       */
/*************************************************************************/
/* There are systems (like the Texas Instruments 'C54x) where a `char' */
/* has 16 bits.  ANSI C says that sizeof(char) is always 1.  Since an  */
/* `int' has 16 bits also for this system, sizeof(int) gives 1 which   */
/* is probably unexpected.                                             */
/*                                                                     */
/* `CHAR_BIT' (defined in limits.h) gives the number of bits in a      */
/* `char' type.                                                        */
#ifndef FT_CHAR_BIT
#define FT_CHAR_BIT  CHAR_BIT
#endif
/* The size of an `int' type.  */
#if                                 FT_UINT_MAX == 0xFFFFUL
#define FT_SIZEOF_INT  (16 / FT_CHAR_BIT)
#elif                               FT_UINT_MAX == 0xFFFFFFFFUL
#define FT_SIZEOF_INT  (32 / FT_CHAR_BIT)
#elif FT_UINT_MAX > 0xFFFFFFFFUL && FT_UINT_MAX == 0xFFFFFFFFFFFFFFFFUL
#define FT_SIZEOF_INT  (64 / FT_CHAR_BIT)
#else
#error "Unsupported size of `int' type!"
#endif
/* The size of a `long' type.  A five-byte `long' (as used e.g. on the */
/* DM642) is recognized but avoided.                                   */
#if                                  FT_ULONG_MAX == 0xFFFFFFFFUL
#define FT_SIZEOF_LONG  (32 / FT_CHAR_BIT)
#elif FT_ULONG_MAX > 0xFFFFFFFFUL && FT_ULONG_MAX == 0xFFFFFFFFFFUL
#define FT_SIZEOF_LONG  (32 / FT_CHAR_BIT)
#elif FT_ULONG_MAX > 0xFFFFFFFFUL && FT_ULONG_MAX == 0xFFFFFFFFFFFFFFFFUL
#define FT_SIZEOF_LONG  (64 / FT_CHAR_BIT)
#else
#error "Unsupported size of `long' type!"
#endif
/* FT_UNUSED is a macro used to indicate that a given parameter is not  */
/* used -- this is only used to get rid of unpleasant compiler warnings */
#ifndef FT_UNUSED
#define FT_UNUSED( arg )  ( (arg) = (arg) )
#endif
/*************************************************************************/
/*                                                                       */
/*                     AUTOMATIC CONFIGURATION MACROS                    */
/*                                                                       */
/* These macros are computed from the ones defined above.  Don't touch   */
/* their definition, unless you know precisely what you are doing.  No   */
/* porter should need to mess with them.                                 */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Mac support                                                           */
/*                                                                       */
/*   This is the only necessary change, so it is defined here instead    */
/*   providing a new configuration file.                                 */
/*                                                                       */
#if defined( __APPLE__ ) || ( defined( __MWERKS__ ) && defined( macintosh ) )
/* no Carbon frameworks for 64bit 10.4.x */
/* AvailabilityMacros.h is available since Mac OS X 10.2,        */
/* so guess the system version by maximum errno before inclusion */
#include <errno.h>
/* defined since 10.2 */
#ifdef ECANCELED  
#include "AvailabilityMacros.h"
#endif
#if defined( __LP64__ ) && \
    ( MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_4 )
#undef FT_MACINTOSH
#endif
#elif defined( __SC__ ) || defined( __MRC__ )
/* Classic MacOS compilers */
#include "ConditionalMacros.h"
#if TARGET_OS_MAC
#define FT_MACINTOSH 1
#endif
#endif
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    basic_types                                                        */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Int16                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for a 16bit signed integer type.                         */
/*                                                                       */
  typedef signed short  FT_Int16;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_UInt16                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for a 16bit unsigned integer type.                       */
/*                                                                       */
  typedef unsigned short  FT_UInt16;
/* */
/* this #if 0 ... #endif clause is for documentation purposes */
#if 0
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Int32                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for a 32bit signed integer type.  The size depends on    */
/*    the configuration.                                                 */
/*                                                                       */
  typedef signed XXX  FT_Int32;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_UInt32                                                          */
/*                                                                       */
/*    A typedef for a 32bit unsigned integer type.  The size depends on  */
/*    the configuration.                                                 */
/*                                                                       */
  typedef unsigned XXX  FT_UInt32;
/* */
#endif
#if FT_SIZEOF_INT == (32 / FT_CHAR_BIT)
  typedef signed int      FT_Int32;
  typedef unsigned int    FT_UInt32;
#elif FT_SIZEOF_LONG == (32 / FT_CHAR_BIT)
  typedef signed long     FT_Int32;
  typedef unsigned long   FT_UInt32;
#else
#error "no 32bit type found -- please check your configuration files"
#endif
/* look up an integer type that is at least 32 bits */
#if FT_SIZEOF_INT >= (32 / FT_CHAR_BIT)
  typedef int            FT_Fast;
  typedef unsigned int   FT_UFast;
#elif FT_SIZEOF_LONG >= (32 / FT_CHAR_BIT)
  typedef long           FT_Fast;
  typedef unsigned long  FT_UFast;
#endif
/* determine whether we have a 64-bit int type for platforms without */
/* Autoconf                                                          */
#if FT_SIZEOF_LONG == (64 / FT_CHAR_BIT)
/* FT_LONG64 must be defined if a 64-bit type is available */
#define FT_LONG64
#define FT_INT64  long
/* Visual C++ (and Intel C++) */
#elif defined( _MSC_VER ) && _MSC_VER >= 900   
/* this compiler provides the __int64 type */
#define FT_LONG64
#define FT_INT64  __int64
/* Borland C++ */
#elif defined( __BORLANDC__ )   
/* XXXX: We should probably check the value of __BORLANDC__ in order */
/*       to test the compiler version.                               */
/* this compiler provides the __int64 type */
#define FT_LONG64
#define FT_INT64  __int64
/* Watcom C++ */
#elif defined( __WATCOMC__ )    
/* Watcom doesn't provide 64-bit data types */
/* Metrowerks CodeWarrior */
#elif defined( __MWERKS__ )     
#define FT_LONG64
#define FT_INT64  long long int
#elif defined( __GNUC__ )
/* GCC provides the `long long' type */
#define FT_LONG64
#define FT_INT64  long long int
/* FT_SIZEOF_LONG == (64 / FT_CHAR_BIT) */
#endif  
/*************************************************************************/
/*                                                                       */
/* A 64-bit data type will create compilation problems if you compile    */
/* in strict ANSI mode.  To avoid them, we disable its use if __STDC__   */
/* is defined.  You can however ignore this rule by defining the         */
/* FT_CONFIG_OPTION_FORCE_INT64 configuration macro.                     */
/*                                                                       */
#if defined( FT_LONG64 ) && !defined( FT_CONFIG_OPTION_FORCE_INT64 )
#ifdef __STDC__
/* undefine the 64-bit macros in strict ANSI compilation mode */
#undef FT_LONG64
#undef FT_INT64
/* __STDC__ */
#endif  
/* FT_LONG64 && !FT_CONFIG_OPTION_FORCE_INT64 */
#endif  
#define FT_BEGIN_STMNT  do {
#define FT_END_STMNT    } while ( 0 )
#define FT_DUMMY_STMNT  FT_BEGIN_STMNT FT_END_STMNT
/* Provide assembler fragments for performance-critical functions. */
/* These must be defined `static __inline__' with GCC.             */
/* RVCT */
#if defined( __CC_ARM ) || defined( __ARMCC__ )   
#define FT_MULFIX_ASSEMBLER  FT_MulFix_arm
/* documentation is in freetype.h */
  static __inline FT_Int32
  FT_MulFix_arm( FT_Int32  a,
                 FT_Int32  b )
  {
    register FT_Int32  t, t2;
    __asm
    {
/* (lo=t2,hi=t) = a*b */
      smull t2, t,  b,  a            
/* a   = (hi >> 31) */
      mov   a,  t,  asr #31          
/* a  += 0x8000 */
      add   a,  a,  #0x8000          
/* t2 += a */
      adds  t2, t2, a                
/* t  += carry */
      adc   t,  t,  #0               
/* a   = t2 >> 16 */
      mov   a,  t2, lsr #16          
/* a  |= t << 16 */
      orr   a,  a,  t,  lsl #16      
    }
    return a;
  }
/* __CC_ARM || __ARMCC__ */
#endif  
#ifdef __GNUC__
#if defined( __arm__ ) && !defined( __thumb__ )    && \
    !( defined( __CC_ARM ) || defined( __ARMCC__ ) )
#define FT_MULFIX_ASSEMBLER  FT_MulFix_arm
/* documentation is in freetype.h */
  static __inline__ FT_Int32
  FT_MulFix_arm( FT_Int32  a,
                 FT_Int32  b )
  {
    register FT_Int32  t, t2;
    __asm__ __volatile__ (
/* (lo=%1,hi=%2) = a*b */
      "smull  %1, %2, %4, %3\n\t"        
/* %0  = (hi >> 31) */
      "mov    %0, %2, asr #31\n\t"       
/* %0 += 0x8000 */
      "add    %0, %0, #0x8000\n\t"       
/* %1 += %0 */
      "adds   %1, %1, %0\n\t"            
/* %2 += carry */
      "adc    %2, %2, #0\n\t"            
/* %0  = %1 >> 16 */
      "mov    %0, %1, lsr #16\n\t"       
/* %0 |= %2 << 16 */
      "orr    %0, %0, %2, lsl #16\n\t"   
      : "=r"(a), "=&r"(t2), "=&r"(t)
      : "r"(a), "r"(b)
      : "cc" );
    return a;
  }
/* __arm__ && !__thumb__ && !( __CC_ARM || __ARMCC__ ) */
#endif  
#if defined( __i386__ )
#define FT_MULFIX_ASSEMBLER  FT_MulFix_i386
/* documentation is in freetype.h */
  static __inline__ FT_Int32
  FT_MulFix_i386( FT_Int32  a,
                  FT_Int32  b )
  {
    register FT_Int32  result;
    __asm__ __volatile__ (
      "imul  %%edx\n"
      "movl  %%edx, %%ecx\n"
      "sarl  $31, %%ecx\n"
      "addl  $0x8000, %%ecx\n"
      "addl  %%ecx, %%eax\n"
      "adcl  $0, %%edx\n"
      "shrl  $16, %%eax\n"
      "shll  $16, %%edx\n"
      "addl  %%edx, %%eax\n"
      : "=a"(result), "=d"(b)
      : "a"(a), "d"(b)
      : "%ecx", "cc" );
    return result;
  }
/* i386 */
#endif  
/* __GNUC__ */
#endif  
/* Visual C++ */
#ifdef _MSC_VER  
#ifdef _M_IX86
#define FT_MULFIX_ASSEMBLER  FT_MulFix_i386
/* documentation is in freetype.h */
  static __inline FT_Int32
  FT_MulFix_i386( FT_Int32  a,
                  FT_Int32  b )
  {
    register FT_Int32  result;
    __asm
    {
      mov eax, a
      mov edx, b
      imul edx
      mov ecx, edx
      sar ecx, 31
      add ecx, 8000h
      add eax, ecx
      adc edx, 0
      shr eax, 16
      shl edx, 16
      add eax, edx
      mov result, eax
    }
    return result;
  }
/* _M_IX86 */
#endif  
/* _MSC_VER */
#endif  
#ifdef FT_MULFIX_ASSEMBLER
#define FT_MULFIX_INLINED  FT_MULFIX_ASSEMBLER
#endif
#ifdef FT_MAKE_OPTION_SINGLE_OBJECT
#define FT_LOCAL( x )      static  x
#define FT_LOCAL_DEF( x )  static  x
#else
#ifdef __cplusplus
#define FT_LOCAL( x )      extern "C"  x
#define FT_LOCAL_DEF( x )  extern "C"  x
#else
#define FT_LOCAL( x )      extern  x
#define FT_LOCAL_DEF( x )  x
#endif
/* FT_MAKE_OPTION_SINGLE_OBJECT */
#endif  
#ifndef FT_BASE
#ifdef __cplusplus
#define FT_BASE( x )  extern "C"  x
#else
#define FT_BASE( x )  extern  x
#endif
/* !FT_BASE */
#endif  
#ifndef FT_BASE_DEF
#ifdef __cplusplus
#define FT_BASE_DEF( x )  x
#else
#define FT_BASE_DEF( x )  x
#endif
/* !FT_BASE_DEF */
#endif  
#ifndef FT_EXPORT
#ifdef __cplusplus
#define FT_EXPORT( x )  extern "C"  x
#else
#define FT_EXPORT( x )  extern  x
#endif
/* !FT_EXPORT */
#endif  
#ifndef FT_EXPORT_DEF
#ifdef __cplusplus
#define FT_EXPORT_DEF( x )  extern "C"  x
#else
#define FT_EXPORT_DEF( x )  extern  x
#endif
/* !FT_EXPORT_DEF */
#endif  
#ifndef FT_EXPORT_VAR
#ifdef __cplusplus
#define FT_EXPORT_VAR( x )  extern "C"  x
#else
#define FT_EXPORT_VAR( x )  extern  x
#endif
/* !FT_EXPORT_VAR */
#endif  
/* The following macros are needed to compile the library with a   */
/* C++ compiler and with 16bit compilers.                          */
/*                                                                 */
/* This is special.  Within C++, you must specify `extern "C"' for */
/* functions which are used via function pointers, and you also    */
/* must do that for structures which contain function pointers to  */
/* assure C linkage -- it's not possible to have (local) anonymous */
/* functions which are accessed by (global) function pointers.     */
/*                                                                 */
/*                                                                 */
/* FT_CALLBACK_DEF is used to _define_ a callback function.        */
/*                                                                 */
/* FT_CALLBACK_TABLE is used to _declare_ a constant variable that */
/* contains pointers to callback functions.                        */
/*                                                                 */
/* FT_CALLBACK_TABLE_DEF is used to _define_ a constant variable   */
/* that contains pointers to callback functions.                   */
/*                                                                 */
/*                                                                 */
/* Some 16bit compilers have to redefine these macros to insert    */
/* the infamous `_cdecl' or `__fastcall' declarations.             */
/*                                                                 */
#ifndef FT_CALLBACK_DEF
#ifdef __cplusplus
#define FT_CALLBACK_DEF( x )  extern "C"  x
#else
#define FT_CALLBACK_DEF( x )  static  x
#endif
/* FT_CALLBACK_DEF */
#endif  
#ifndef FT_CALLBACK_TABLE
#ifdef __cplusplus
#define FT_CALLBACK_TABLE      extern "C"
#define FT_CALLBACK_TABLE_DEF  extern "C"
#else
#define FT_CALLBACK_TABLE      extern
/* nothing */
#define FT_CALLBACK_TABLE_DEF   
#endif
/* FT_CALLBACK_TABLE */
#endif  
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftdebug.h                                                              */
/*                                                                         */
/*    Debugging and logging component (specification).                     */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2004, 2006, 2007, 2008, 2009 by             */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/*                                                                         */
/*  IMPORTANT: A description of FreeType's debugging support can be        */
/*             found in `docs/DEBUG.TXT'.  Read it if you need to use or   */
/*             understand this code.                                       */
/*                                                                         */
/***************************************************************************/
#define __FTDEBUG_H__
/***************************************************************************/
/*                                                                         */
/*  freetype.h                                                             */
/*                                                                         */
/*    FreeType high-level API and common types (specification only).       */
/*                                                                         */
/*  Copyright 1996-2012 by                                                 */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FREETYPE_H__
#ifndef FT_FREETYPE_H
#error "`ft2build.h' hasn't been included yet!"
#error "Please always use macros to include FreeType header files."
#error "Example:"
#error "  #include <ft2build.h>"
#error "  #include FT_FREETYPE_H"
#endif
/***************************************************************************/
/*                                                                         */
/*  fterrors.h                                                             */
/*                                                                         */
/*    FreeType error code handling (specification).                        */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2004, 2007 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This special header file is used to define the handling of FT2        */
/* enumeration constants.  It can also be used to generate error message */
/* strings with a small macro trick explained below.                     */
/*                                                                       */
/* I - Error Formats                                                     */
/* -----------------                                                     */
/*                                                                       */
/*   The configuration macro FT_CONFIG_OPTION_USE_MODULE_ERRORS can be   */
/*   defined in ftoption.h in order to make the higher byte indicate     */
/*   the module where the error has happened (this is not compatible     */
/*   with standard builds of FreeType 2).  You can then use the macro    */
/*   FT_ERROR_BASE macro to extract the generic error code from an       */
/*   FT_Error value.                                                     */
/*                                                                       */
/*                                                                       */
/* II - Error Message strings                                            */
/* --------------------------                                            */
/*                                                                       */
/*   The error definitions below are made through special macros that    */
/*   allow client applications to build a table of error message strings */
/*   if they need it.  The strings are not included in a normal build of */
/*   FreeType 2 to save space (most client applications do not use       */
/*   them).                                                              */
/*                                                                       */
/*   To do so, you have to define the following macros before including  */
/*   this file:                                                          */
/*                                                                       */
/*   FT_ERROR_START_LIST ::                                              */
/*     This macro is called before anything else to define the start of  */
/*     the error list.  It is followed by several FT_ERROR_DEF calls     */
/*     (see below).                                                      */
/*                                                                       */
/*   FT_ERROR_DEF( e, v, s ) ::                                          */
/*     This macro is called to define one single error.                  */
/*     `e' is the error code identifier (e.g. FT_Err_Invalid_Argument).  */
/*     `v' is the error numerical value.                                 */
/*     `s' is the corresponding error string.                            */
/*                                                                       */
/*   FT_ERROR_END_LIST ::                                                */
/*     This macro ends the list.                                         */
/*                                                                       */
/*   Additionally, you have to undefine __FTERRORS_H__ before #including */
/*   this file.                                                          */
/*                                                                       */
/*   Here is a simple example:                                           */
/*                                                                       */
/*     {                                                                 */
/*       #undef __FTERRORS_H__                                           */
/*       #define FT_ERRORDEF( e, v, s )  { e, s },                       */
/*       #define FT_ERROR_START_LIST     {                               */
/*       #define FT_ERROR_END_LIST       { 0, 0 } };                     */
/*                                                                       */
/*       const struct                                                    */
/*       {                                                               */
/*         int          err_code;                                        */
/*         const char*  err_msg;                                         */
/*       } ft_errors[] =                                                 */
/*                                                                       */
/*       #include FT_ERRORS_H                                            */
/*     }                                                                 */
/*                                                                       */
/*************************************************************************/
#ifndef __FTERRORS_H__
#define __FTERRORS_H__
/* include module base error codes */
/***************************************************************************/
/*                                                                         */
/*  ftmoderr.h                                                             */
/*                                                                         */
/*    FreeType module error offsets (specification).                       */
/*                                                                         */
/*  Copyright 2001, 2002, 2003, 2004, 2005, 2010 by                        */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This file is used to define the FreeType module error offsets.        */
/*                                                                       */
/* The lower byte gives the error code, the higher byte gives the        */
/* module.  The base module has error offset 0.  For example, the error  */
/* `FT_Err_Invalid_File_Format' has value 0x003, the error               */
/* `TT_Err_Invalid_File_Format' has value 0x1103, the error              */
/* `T1_Err_Invalid_File_Format' has value 0x1203, etc.                   */
/*                                                                       */
/* Undefine the macro FT_CONFIG_OPTION_USE_MODULE_ERRORS in ftoption.h   */
/* to make the higher byte always zero (disabling the module error       */
/* mechanism).                                                           */
/*                                                                       */
/* It can also be used to create a module error message table easily     */
/* with something like                                                   */
/*                                                                       */
/*   {                                                                   */
/*     #undef __FTMODERR_H__                                             */
/*     #define FT_MODERRDEF( e, v, s )  { FT_Mod_Err_ ## e, s },         */
/*     #define FT_MODERR_START_LIST     {                                */
/*     #define FT_MODERR_END_LIST       { 0, 0 } };                      */
/*                                                                       */
/*     const struct                                                      */
/*     {                                                                 */
/*       int          mod_err_offset;                                    */
/*       const char*  mod_err_msg                                        */
/*     } ft_mod_errors[] =                                               */
/*                                                                       */
/*     #include FT_MODULE_ERRORS_H                                       */
/*   }                                                                   */
/*                                                                       */
/* To use such a table, all errors must be ANDed with 0xFF00 to remove   */
/* the error code.                                                       */
/*                                                                       */
/*************************************************************************/
#define __FTMODERR_H__
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                       SETUP MACROS                      *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#undef  FT_NEED_EXTERN_C
#ifndef FT_MODERRDEF
#define FT_MODERRDEF( e, v, s )  FT_Mod_Err_ ## e = 0,
#define FT_MODERR_START_LIST  enum {
#define FT_MODERR_END_LIST    FT_Mod_Err_Max };
#ifdef __cplusplus
#define FT_NEED_EXTERN_C
  extern "C" {
#endif
/* !FT_MODERRDEF */
#endif  
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****               LIST MODULE ERROR BASES                   *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#ifdef FT_MODERR_START_LIST
  FT_MODERR_START_LIST
#endif
  FT_MODERRDEF( Base,      0x000, "base module" )
  FT_MODERRDEF( Autofit,   0x100, "autofitter module" )
  FT_MODERRDEF( BDF,       0x200, "BDF module" )
  FT_MODERRDEF( Bzip2,     0x300, "Bzip2 module" )
  FT_MODERRDEF( Cache,     0x400, "cache module" )
  FT_MODERRDEF( CFF,       0x500, "CFF module" )
  FT_MODERRDEF( CID,       0x600, "CID module" )
  FT_MODERRDEF( Gzip,      0x700, "Gzip module" )
  FT_MODERRDEF( LZW,       0x800, "LZW module" )
  FT_MODERRDEF( OTvalid,   0x900, "OpenType validation module" )
  FT_MODERRDEF( PCF,       0xA00, "PCF module" )
  FT_MODERRDEF( PFR,       0xB00, "PFR module" )
  FT_MODERRDEF( PSaux,     0xC00, "PS auxiliary module" )
  FT_MODERRDEF( PShinter,  0xD00, "PS hinter module" )
  FT_MODERRDEF( PSnames,   0xE00, "PS names module" )
  FT_MODERRDEF( Raster,    0xF00, "raster module" )
  FT_MODERRDEF( SFNT,     0x1000, "SFNT module" )
  FT_MODERRDEF( Smooth,   0x1100, "smooth raster module" )
  FT_MODERRDEF( TrueType, 0x1200, "TrueType module" )
  FT_MODERRDEF( Type1,    0x1300, "Type 1 module" )
  FT_MODERRDEF( Type42,   0x1400, "Type 42 module" )
  FT_MODERRDEF( Winfonts, 0x1500, "Windows FON/FNT module" )
#ifdef FT_MODERR_END_LIST
  FT_MODERR_END_LIST
#endif
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                      CLEANUP                            *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#ifdef FT_NEED_EXTERN_C
  }
#endif
#undef FT_MODERR_START_LIST
#undef FT_MODERR_END_LIST
#undef FT_MODERRDEF
#undef FT_NEED_EXTERN_C
/* END */
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                       SETUP MACROS                      *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#undef  FT_NEED_EXTERN_C
#undef  FT_ERR_XCAT
#undef  FT_ERR_CAT
#define FT_ERR_XCAT( x, y )  x ## y
#define FT_ERR_CAT( x, y )   FT_ERR_XCAT( x, y )
/* FT_ERR_PREFIX is used as a prefix for error identifiers. */
/* By default, we use `FT_Err_'.                            */
/*                                                          */
#ifndef FT_ERR_PREFIX
#define FT_ERR_PREFIX  FT_Err_
#endif
/* FT_ERR_BASE is used as the base for module-specific errors. */
/*                                                             */
#undef FT_ERR_BASE
#define FT_ERR_BASE  0
/* If FT_ERRORDEF is not defined, we need to define a simple */
/* enumeration type.                                         */
/*                                                           */
#ifndef FT_ERRORDEF
#define FT_ERRORDEF( e, v, s )  e = v,
#define FT_ERROR_START_LIST     enum {
#define FT_ERROR_END_LIST       FT_ERR_CAT( FT_ERR_PREFIX, Max ) };
#ifdef __cplusplus
#define FT_NEED_EXTERN_C
  extern "C" {
#endif
/* !FT_ERRORDEF */
#endif  
/* this macro is used to define an error */
#define FT_ERRORDEF_( e, v, s )   \
          FT_ERRORDEF( FT_ERR_CAT( FT_ERR_PREFIX, e ), v + FT_ERR_BASE, s )
/* this is only used for <module>_Err_Ok, which must be 0! */
#define FT_NOERRORDEF_( e, v, s ) \
          FT_ERRORDEF( FT_ERR_CAT( FT_ERR_PREFIX, e ), v, s )
#ifdef FT_ERROR_START_LIST
  FT_ERROR_START_LIST
#endif
/* now include the error codes */
/***************************************************************************/
/*                                                                         */
/*  fterrdef.h                                                             */
/*                                                                         */
/*    FreeType error codes (specification).                                */
/*                                                                         */
/*  Copyright 2002, 2004, 2006, 2007, 2010-2012 by                         */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                LIST OF ERROR CODES/MESSAGES             *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
/* You need to define both FT_ERRORDEF_ and FT_NOERRORDEF_ before */
/* including this file.                                           */
/* generic errors */
  FT_NOERRORDEF_( Ok,                                        0x00, \
                  "no error" )
  FT_ERRORDEF_( Cannot_Open_Resource,                        0x01, \
                "cannot open resource" )
  FT_ERRORDEF_( Unknown_File_Format,                         0x02, \
                "unknown file format" )
  FT_ERRORDEF_( Invalid_File_Format,                         0x03, \
                "broken file" )
  FT_ERRORDEF_( Invalid_Version,                             0x04, \
                "invalid FreeType version" )
  FT_ERRORDEF_( Lower_Module_Version,                        0x05, \
                "module version is too low" )
  FT_ERRORDEF_( Invalid_Argument,                            0x06, \
                "invalid argument" )
  FT_ERRORDEF_( Unimplemented_Feature,                       0x07, \
                "unimplemented feature" )
  FT_ERRORDEF_( Invalid_Table,                               0x08, \
                "broken table" )
  FT_ERRORDEF_( Invalid_Offset,                              0x09, \
                "broken offset within table" )
  FT_ERRORDEF_( Array_Too_Large,                             0x0A, \
                "array allocation size too large" )
  FT_ERRORDEF_( Missing_Module,                              0x0B, \
                "missing module" )
  FT_ERRORDEF_( Missing_Property,                            0x0C, \
                "missing property" )
/* glyph/character errors */
  FT_ERRORDEF_( Invalid_Glyph_Index,                         0x10, \
                "invalid glyph index" )
  FT_ERRORDEF_( Invalid_Character_Code,                      0x11, \
                "invalid character code" )
  FT_ERRORDEF_( Invalid_Glyph_Format,                        0x12, \
                "unsupported glyph image format" )
  FT_ERRORDEF_( Cannot_Render_Glyph,                         0x13, \
                "cannot render this glyph format" )
  FT_ERRORDEF_( Invalid_Outline,                             0x14, \
                "invalid outline" )
  FT_ERRORDEF_( Invalid_Composite,                           0x15, \
                "invalid composite glyph" )
  FT_ERRORDEF_( Too_Many_Hints,                              0x16, \
                "too many hints" )
  FT_ERRORDEF_( Invalid_Pixel_Size,                          0x17, \
                "invalid pixel size" )
/* handle errors */
  FT_ERRORDEF_( Invalid_Handle,                              0x20, \
                "invalid object handle" )
  FT_ERRORDEF_( Invalid_Library_Handle,                      0x21, \
                "invalid library handle" )
  FT_ERRORDEF_( Invalid_Driver_Handle,                       0x22, \
                "invalid module handle" )
  FT_ERRORDEF_( Invalid_Face_Handle,                         0x23, \
                "invalid face handle" )
  FT_ERRORDEF_( Invalid_Size_Handle,                         0x24, \
                "invalid size handle" )
  FT_ERRORDEF_( Invalid_Slot_Handle,                         0x25, \
                "invalid glyph slot handle" )
  FT_ERRORDEF_( Invalid_CharMap_Handle,                      0x26, \
                "invalid charmap handle" )
  FT_ERRORDEF_( Invalid_Cache_Handle,                        0x27, \
                "invalid cache manager handle" )
  FT_ERRORDEF_( Invalid_Stream_Handle,                       0x28, \
                "invalid stream handle" )
/* driver errors */
  FT_ERRORDEF_( Too_Many_Drivers,                            0x30, \
                "too many modules" )
  FT_ERRORDEF_( Too_Many_Extensions,                         0x31, \
                "too many extensions" )
/* memory errors */
  FT_ERRORDEF_( Out_Of_Memory,                               0x40, \
                "out of memory" )
  FT_ERRORDEF_( Unlisted_Object,                             0x41, \
                "unlisted object" )
/* stream errors */
  FT_ERRORDEF_( Cannot_Open_Stream,                          0x51, \
                "cannot open stream" )
  FT_ERRORDEF_( Invalid_Stream_Seek,                         0x52, \
                "invalid stream seek" )
  FT_ERRORDEF_( Invalid_Stream_Skip,                         0x53, \
                "invalid stream skip" )
  FT_ERRORDEF_( Invalid_Stream_Read,                         0x54, \
                "invalid stream read" )
  FT_ERRORDEF_( Invalid_Stream_Operation,                    0x55, \
                "invalid stream operation" )
  FT_ERRORDEF_( Invalid_Frame_Operation,                     0x56, \
                "invalid frame operation" )
  FT_ERRORDEF_( Nested_Frame_Access,                         0x57, \
                "nested frame access" )
  FT_ERRORDEF_( Invalid_Frame_Read,                          0x58, \
                "invalid frame read" )
/* raster errors */
  FT_ERRORDEF_( Raster_Uninitialized,                        0x60, \
                "raster uninitialized" )
  FT_ERRORDEF_( Raster_Corrupted,                            0x61, \
                "raster corrupted" )
  FT_ERRORDEF_( Raster_Overflow,                             0x62, \
                "raster overflow" )
  FT_ERRORDEF_( Raster_Negative_Height,                      0x63, \
                "negative height while rastering" )
/* cache errors */
  FT_ERRORDEF_( Too_Many_Caches,                             0x70, \
                "too many registered caches" )
/* TrueType and SFNT errors */
  FT_ERRORDEF_( Invalid_Opcode,                              0x80, \
                "invalid opcode" )
  FT_ERRORDEF_( Too_Few_Arguments,                           0x81, \
                "too few arguments" )
  FT_ERRORDEF_( Stack_Overflow,                              0x82, \
                "stack overflow" )
  FT_ERRORDEF_( Code_Overflow,                               0x83, \
                "code overflow" )
  FT_ERRORDEF_( Bad_Argument,                                0x84, \
                "bad argument" )
  FT_ERRORDEF_( Divide_By_Zero,                              0x85, \
                "division by zero" )
  FT_ERRORDEF_( Invalid_Reference,                           0x86, \
                "invalid reference" )
  FT_ERRORDEF_( Debug_OpCode,                                0x87, \
                "found debug opcode" )
  FT_ERRORDEF_( ENDF_In_Exec_Stream,                         0x88, \
                "found ENDF opcode in execution stream" )
  FT_ERRORDEF_( Nested_DEFS,                                 0x89, \
                "nested DEFS" )
  FT_ERRORDEF_( Invalid_CodeRange,                           0x8A, \
                "invalid code range" )
  FT_ERRORDEF_( Execution_Too_Long,                          0x8B, \
                "execution context too long" )
  FT_ERRORDEF_( Too_Many_Function_Defs,                      0x8C, \
                "too many function definitions" )
  FT_ERRORDEF_( Too_Many_Instruction_Defs,                   0x8D, \
                "too many instruction definitions" )
  FT_ERRORDEF_( Table_Missing,                               0x8E, \
                "SFNT font table missing" )
  FT_ERRORDEF_( Horiz_Header_Missing,                        0x8F, \
                "horizontal header (hhea) table missing" )
  FT_ERRORDEF_( Locations_Missing,                           0x90, \
                "locations (loca) table missing" )
  FT_ERRORDEF_( Name_Table_Missing,                          0x91, \
                "name table missing" )
  FT_ERRORDEF_( CMap_Table_Missing,                          0x92, \
                "character map (cmap) table missing" )
  FT_ERRORDEF_( Hmtx_Table_Missing,                          0x93, \
                "horizontal metrics (hmtx) table missing" )
  FT_ERRORDEF_( Post_Table_Missing,                          0x94, \
                "PostScript (post) table missing" )
  FT_ERRORDEF_( Invalid_Horiz_Metrics,                       0x95, \
                "invalid horizontal metrics" )
  FT_ERRORDEF_( Invalid_CharMap_Format,                      0x96, \
                "invalid character map (cmap) format" )
  FT_ERRORDEF_( Invalid_PPem,                                0x97, \
                "invalid ppem value" )
  FT_ERRORDEF_( Invalid_Vert_Metrics,                        0x98, \
                "invalid vertical metrics" )
  FT_ERRORDEF_( Could_Not_Find_Context,                      0x99, \
                "could not find context" )
  FT_ERRORDEF_( Invalid_Post_Table_Format,                   0x9A, \
                "invalid PostScript (post) table format" )
  FT_ERRORDEF_( Invalid_Post_Table,                          0x9B, \
                "invalid PostScript (post) table" )
/* CFF, CID, and Type 1 errors */
  FT_ERRORDEF_( Syntax_Error,                                0xA0, \
                "opcode syntax error" )
  FT_ERRORDEF_( Stack_Underflow,                             0xA1, \
                "argument stack underflow" )
  FT_ERRORDEF_( Ignore,                                      0xA2, \
                "ignore" )
  FT_ERRORDEF_( No_Unicode_Glyph_Name,                       0xA3, \
                "no Unicode glyph name found" )
/* BDF errors */
  FT_ERRORDEF_( Missing_Startfont_Field,                     0xB0, \
                "`STARTFONT' field missing" )
  FT_ERRORDEF_( Missing_Font_Field,                          0xB1, \
                "`FONT' field missing" )
  FT_ERRORDEF_( Missing_Size_Field,                          0xB2, \
                "`SIZE' field missing" )
  FT_ERRORDEF_( Missing_Fontboundingbox_Field,               0xB3, \
                "`FONTBOUNDINGBOX' field missing" )
  FT_ERRORDEF_( Missing_Chars_Field,                         0xB4, \
                "`CHARS' field missing" )
  FT_ERRORDEF_( Missing_Startchar_Field,                     0xB5, \
                "`STARTCHAR' field missing" )
  FT_ERRORDEF_( Missing_Encoding_Field,                      0xB6, \
                "`ENCODING' field missing" )
  FT_ERRORDEF_( Missing_Bbx_Field,                           0xB7, \
                "`BBX' field missing" )
  FT_ERRORDEF_( Bbx_Too_Big,                                 0xB8, \
                "`BBX' too big" )
  FT_ERRORDEF_( Corrupted_Font_Header,                       0xB9, \
                "Font header corrupted or missing fields" )
  FT_ERRORDEF_( Corrupted_Font_Glyphs,                       0xBA, \
                "Font glyphs corrupted or missing fields" )
/* END */
#ifdef FT_ERROR_END_LIST
  FT_ERROR_END_LIST
#endif
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                      SIMPLE CLEANUP                     *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#ifdef FT_NEED_EXTERN_C
  }
#endif
#undef FT_ERROR_START_LIST
#undef FT_ERROR_END_LIST
#undef FT_ERRORDEF
#undef FT_ERRORDEF_
#undef FT_NOERRORDEF_
#undef FT_NEED_EXTERN_C
#undef FT_ERR_BASE
/* FT_KEEP_ERR_PREFIX is needed for ftvalid.h */
#ifndef FT_KEEP_ERR_PREFIX
#undef FT_ERR_PREFIX
#else
#undef FT_KEEP_ERR_PREFIX
#endif
/* __FTERRORS_H__ */
#endif  
/* END */
/***************************************************************************/
/*                                                                         */
/*  fttypes.h                                                              */
/*                                                                         */
/*    FreeType simple types definitions (specification only).              */
/*                                                                         */
/*  Copyright 1996-2002, 2004, 2006-2009, 2012 by                          */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTTYPES_H__
/***************************************************************************/
/*                                                                         */
/*  ftsystem.h                                                             */
/*                                                                         */
/*    FreeType low-level system interface definition (specification).      */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2005, 2010 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTSYSTEM_H__
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*   system_interface                                                    */
/*                                                                       */
/* <Title>                                                               */
/*   System Interface                                                    */
/*                                                                       */
/* <Abstract>                                                            */
/*   How FreeType manages memory and i/o.                                */
/*                                                                       */
/* <Description>                                                         */
/*   This section contains various definitions related to memory         */
/*   management and i/o access.  You need to understand this             */
/*   information if you want to use a custom memory manager or you own   */
/*   i/o streams.                                                        */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/*                  M E M O R Y   M A N A G E M E N T                    */
/*                                                                       */
/*************************************************************************/
/*************************************************************************
   *
   * @type:
   *   FT_Memory
   *
   * @description:
   *   A handle to a given memory manager object, defined with an
   *   @FT_MemoryRec structure.
   *
   */
  typedef struct FT_MemoryRec_*  FT_Memory;
/*************************************************************************
   *
   * @functype:
   *   FT_Alloc_Func
   *
   * @description:
   *   A function used to allocate `size' bytes from `memory'.
   *
   * @input:
   *   memory ::
   *     A handle to the source memory manager.
   *
   *   size ::
   *     The size in bytes to allocate.
   *
   * @return:
   *   Address of new memory block.  0~in case of failure.
   *
   */
  typedef void*
  (*FT_Alloc_Func)( FT_Memory  memory,
                    long       size );
/*************************************************************************
   *
   * @functype:
   *   FT_Free_Func
   *
   * @description:
   *   A function used to release a given block of memory.
   *
   * @input:
   *   memory ::
   *     A handle to the source memory manager.
   *
   *   block ::
   *     The address of the target memory block.
   *
   */
  typedef void
  (*FT_Free_Func)( FT_Memory  memory,
                   void*      block );
/*************************************************************************
   *
   * @functype:
   *   FT_Realloc_Func
   *
   * @description:
   *   A function used to re-allocate a given block of memory.
   *
   * @input:
   *   memory ::
   *     A handle to the source memory manager.
   *
   *   cur_size ::
   *     The block's current size in bytes.
   *
   *   new_size ::
   *     The block's requested new size.
   *
   *   block ::
   *     The block's current address.
   *
   * @return:
   *   New block address.  0~in case of memory shortage.
   *
   * @note:
   *   In case of error, the old block must still be available.
   *
   */
  typedef void*
  (*FT_Realloc_Func)( FT_Memory  memory,
                      long       cur_size,
                      long       new_size,
                      void*      block );
/*************************************************************************
   *
   * @struct:
   *   FT_MemoryRec
   *
   * @description:
   *   A structure used to describe a given memory manager to FreeType~2.
   *
   * @fields:
   *   user ::
   *     A generic typeless pointer for user data.
   *
   *   alloc ::
   *     A pointer type to an allocation function.
   *
   *   free ::
   *     A pointer type to an memory freeing function.
   *
   *   realloc ::
   *     A pointer type to a reallocation function.
   *
   */
  struct  FT_MemoryRec_
  {
    void*            user;
    FT_Alloc_Func    alloc;
    FT_Free_Func     free;
    FT_Realloc_Func  realloc;
  };
/*************************************************************************/
/*                                                                       */
/*                       I / O   M A N A G E M E N T                     */
/*                                                                       */
/*************************************************************************/
/*************************************************************************
   *
   * @type:
   *   FT_Stream
   *
   * @description:
   *   A handle to an input stream.
   *
   */
  typedef struct FT_StreamRec_*  FT_Stream;
/*************************************************************************
   *
   * @struct:
   *   FT_StreamDesc
   *
   * @description:
   *   A union type used to store either a long or a pointer.  This is used
   *   to store a file descriptor or a `FILE*' in an input stream.
   *
   */
  typedef union  FT_StreamDesc_
  {
    long   value;
    void*  pointer;
  } FT_StreamDesc;
/*************************************************************************
   *
   * @functype:
   *   FT_Stream_IoFunc
   *
   * @description:
   *   A function used to seek and read data from a given input stream.
   *
   * @input:
   *   stream ::
   *     A handle to the source stream.
   *
   *   offset ::
   *     The offset of read in stream (always from start).
   *
   *   buffer ::
   *     The address of the read buffer.
   *
   *   count ::
   *     The number of bytes to read from the stream.
   *
   * @return:
   *   The number of bytes effectively read by the stream.
   *
   * @note:
   *   This function might be called to perform a seek or skip operation
   *   with a `count' of~0.  A non-zero return value then indicates an
   *   error.
   *
   */
  typedef unsigned long
  (*FT_Stream_IoFunc)( FT_Stream       stream,
                       unsigned long   offset,
                       unsigned char*  buffer,
                       unsigned long   count );
/*************************************************************************
   *
   * @functype:
   *   FT_Stream_CloseFunc
   *
   * @description:
   *   A function used to close a given input stream.
   *
   * @input:
   *  stream ::
   *     A handle to the target stream.
   *
   */
  typedef void
  (*FT_Stream_CloseFunc)( FT_Stream  stream );
/*************************************************************************
   *
   * @struct:
   *   FT_StreamRec
   *
   * @description:
   *   A structure used to describe an input stream.
   *
   * @input:
   *   base ::
   *     For memory-based streams, this is the address of the first stream
   *     byte in memory.  This field should always be set to NULL for
   *     disk-based streams.
   *
   *   size ::
   *     The stream size in bytes.
   *
   *   pos ::
   *     The current position within the stream.
   *
   *   descriptor ::
   *     This field is a union that can hold an integer or a pointer.  It is
   *     used by stream implementations to store file descriptors or `FILE*'
   *     pointers.
   *
   *   pathname ::
   *     This field is completely ignored by FreeType.  However, it is often
   *     useful during debugging to use it to store the stream's filename
   *     (where available).
   *
   *   read ::
   *     The stream's input function.
   *
   *   close ::
   *     The stream's close function.
   *
   *   memory ::
   *     The memory manager to use to preload frames.  This is set
   *     internally by FreeType and shouldn't be touched by stream
   *     implementations.
   *
   *   cursor ::
   *     This field is set and used internally by FreeType when parsing
   *     frames.
   *
   *   limit ::
   *     This field is set and used internally by FreeType when parsing
   *     frames.
   *
   */
  typedef struct  FT_StreamRec_
  {
    unsigned char*       base;
    unsigned long        size;
    unsigned long        pos;
    FT_StreamDesc        descriptor;
    FT_StreamDesc        pathname;
    FT_Stream_IoFunc     read;
    FT_Stream_CloseFunc  close;
    FT_Memory            memory;
    unsigned char*       cursor;
    unsigned char*       limit;
  } FT_StreamRec;
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftimage.h                                                              */
/*                                                                         */
/*    FreeType glyph image formats and default raster interface            */
/*    (specification).                                                     */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009,   */
/*            2010 by                                                      */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Note: A `raster' is simply a scan-line converter, used to render      */
/*       FT_Outlines into FT_Bitmaps.                                    */
/*                                                                       */
/*************************************************************************/
#define __FTIMAGE_H__
/* _STANDALONE_ is from ftgrays.c */
#ifndef _STANDALONE_
#endif
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    basic_types                                                        */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Pos                                                             */
/*                                                                       */
/* <Description>                                                         */
/*    The type FT_Pos is used to store vectorial coordinates.  Depending */
/*    on the context, these can represent distances in integer font      */
/*    units, or 16.16, or 26.6 fixed float pixel coordinates.            */
/*                                                                       */
  typedef signed long  FT_Pos;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Vector                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A simple structure used to store a 2D vector; coordinates are of   */
/*    the FT_Pos type.                                                   */
/*                                                                       */
/* <Fields>                                                              */
/*    x :: The horizontal coordinate.                                    */
/*    y :: The vertical coordinate.                                      */
/*                                                                       */
  typedef struct  FT_Vector_
  {
    FT_Pos  x;
    FT_Pos  y;
  } FT_Vector;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_BBox                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to hold an outline's bounding box, i.e., the      */
/*    coordinates of its extrema in the horizontal and vertical          */
/*    directions.                                                        */
/*                                                                       */
/* <Fields>                                                              */
/*    xMin :: The horizontal minimum (left-most).                        */
/*                                                                       */
/*    yMin :: The vertical minimum (bottom-most).                        */
/*                                                                       */
/*    xMax :: The horizontal maximum (right-most).                       */
/*                                                                       */
/*    yMax :: The vertical maximum (top-most).                           */
/*                                                                       */
/* <Note>                                                                */
/*    The bounding box is specified with the coordinates of the lower    */
/*    left and the upper right corner.  In PostScript, those values are  */
/*    often called (llx,lly) and (urx,ury), respectively.                */
/*                                                                       */
/*    If `yMin' is negative, this value gives the glyph's descender.     */
/*    Otherwise, the glyph doesn't descend below the baseline.           */
/*    Similarly, if `ymax' is positive, this value gives the glyph's     */
/*    ascender.                                                          */
/*                                                                       */
/*    `xMin' gives the horizontal distance from the glyph's origin to    */
/*    the left edge of the glyph's bounding box.  If `xMin' is negative, */
/*    the glyph extends to the left of the origin.                       */
/*                                                                       */
  typedef struct  FT_BBox_
  {
    FT_Pos  xMin, yMin;
    FT_Pos  xMax, yMax;
  } FT_BBox;
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_Pixel_Mode                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    An enumeration type used to describe the format of pixels in a     */
/*    given bitmap.  Note that additional formats may be added in the    */
/*    future.                                                            */
/*                                                                       */
/* <Values>                                                              */
/*    FT_PIXEL_MODE_NONE ::                                              */
/*      Value~0 is reserved.                                             */
/*                                                                       */
/*    FT_PIXEL_MODE_MONO ::                                              */
/*      A monochrome bitmap, using 1~bit per pixel.  Note that pixels    */
/*      are stored in most-significant order (MSB), which means that     */
/*      the left-most pixel in a byte has value 128.                     */
/*                                                                       */
/*    FT_PIXEL_MODE_GRAY ::                                              */
/*      An 8-bit bitmap, generally used to represent anti-aliased glyph  */
/*      images.  Each pixel is stored in one byte.  Note that the number */
/*      of `gray' levels is stored in the `num_grays' field of the       */
/*      @FT_Bitmap structure (it generally is 256).                      */
/*                                                                       */
/*    FT_PIXEL_MODE_GRAY2 ::                                             */
/*      A 2-bit per pixel bitmap, used to represent embedded             */
/*      anti-aliased bitmaps in font files according to the OpenType     */
/*      specification.  We haven't found a single font using this        */
/*      format, however.                                                 */
/*                                                                       */
/*    FT_PIXEL_MODE_GRAY4 ::                                             */
/*      A 4-bit per pixel bitmap, representing embedded anti-aliased     */
/*      bitmaps in font files according to the OpenType specification.   */
/*      We haven't found a single font using this format, however.       */
/*                                                                       */
/*    FT_PIXEL_MODE_LCD ::                                               */
/*      An 8-bit bitmap, representing RGB or BGR decimated glyph images  */
/*      used for display on LCD displays; the bitmap is three times      */
/*      wider than the original glyph image.  See also                   */
/*      @FT_RENDER_MODE_LCD.                                             */
/*                                                                       */
/*    FT_PIXEL_MODE_LCD_V ::                                             */
/*      An 8-bit bitmap, representing RGB or BGR decimated glyph images  */
/*      used for display on rotated LCD displays; the bitmap is three    */
/*      times taller than the original glyph image.  See also            */
/*      @FT_RENDER_MODE_LCD_V.                                           */
/*                                                                       */
  typedef enum  FT_Pixel_Mode_
  {
    FT_PIXEL_MODE_NONE = 0,
    FT_PIXEL_MODE_MONO,
    FT_PIXEL_MODE_GRAY,
    FT_PIXEL_MODE_GRAY2,
    FT_PIXEL_MODE_GRAY4,
    FT_PIXEL_MODE_LCD,
    FT_PIXEL_MODE_LCD_V,
/* do not remove */
    FT_PIXEL_MODE_MAX       
  } FT_Pixel_Mode;
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    ft_pixel_mode_xxx                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    A list of deprecated constants.  Use the corresponding             */
/*    @FT_Pixel_Mode values instead.                                     */
/*                                                                       */
/* <Values>                                                              */
/*    ft_pixel_mode_none  :: See @FT_PIXEL_MODE_NONE.                    */
/*    ft_pixel_mode_mono  :: See @FT_PIXEL_MODE_MONO.                    */
/*    ft_pixel_mode_grays :: See @FT_PIXEL_MODE_GRAY.                    */
/*    ft_pixel_mode_pal2  :: See @FT_PIXEL_MODE_GRAY2.                   */
/*    ft_pixel_mode_pal4  :: See @FT_PIXEL_MODE_GRAY4.                   */
/*                                                                       */
#define ft_pixel_mode_none   FT_PIXEL_MODE_NONE
#define ft_pixel_mode_mono   FT_PIXEL_MODE_MONO
#define ft_pixel_mode_grays  FT_PIXEL_MODE_GRAY
#define ft_pixel_mode_pal2   FT_PIXEL_MODE_GRAY2
#define ft_pixel_mode_pal4   FT_PIXEL_MODE_GRAY4
/* */
#if 0
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_Palette_Mode                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    THIS TYPE IS DEPRECATED.  DO NOT USE IT!                           */
/*                                                                       */
/*    An enumeration type to describe the format of a bitmap palette,    */
/*    used with ft_pixel_mode_pal4 and ft_pixel_mode_pal8.               */
/*                                                                       */
/* <Values>                                                              */
/*    ft_palette_mode_rgb  :: The palette is an array of 3-byte RGB      */
/*                            records.                                   */
/*                                                                       */
/*    ft_palette_mode_rgba :: The palette is an array of 4-byte RGBA     */
/*                            records.                                   */
/*                                                                       */
/* <Note>                                                                */
/*    As ft_pixel_mode_pal2, pal4 and pal8 are currently unused by       */
/*    FreeType, these types are not handled by the library itself.       */
/*                                                                       */
  typedef enum  FT_Palette_Mode_
  {
    ft_palette_mode_rgb = 0,
    ft_palette_mode_rgba,
/* do not remove */
    ft_palette_mode_max    
  } FT_Palette_Mode;
/* */
#endif
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Bitmap                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to describe a bitmap or pixmap to the raster.     */
/*    Note that we now manage pixmaps of various depths through the      */
/*    `pixel_mode' field.                                                */
/*                                                                       */
/* <Fields>                                                              */
/*    rows         :: The number of bitmap rows.                         */
/*                                                                       */
/*    width        :: The number of pixels in bitmap row.                */
/*                                                                       */
/*    pitch        :: The pitch's absolute value is the number of bytes  */
/*                    taken by one bitmap row, including padding.        */
/*                    However, the pitch is positive when the bitmap has */
/*                    a `down' flow, and negative when it has an `up'    */
/*                    flow.  In all cases, the pitch is an offset to add */
/*                    to a bitmap pointer in order to go down one row.   */
/*                                                                       */
/*                    Note that `padding' means the alignment of a       */
/*                    bitmap to a byte border, and FreeType functions    */
/*                    normally align to the smallest possible integer    */
/*                    value.                                             */
/*                                                                       */
/*                    For the B/W rasterizer, `pitch' is always an even  */
/*                    number.                                            */
/*                                                                       */
/*                    To change the pitch of a bitmap (say, to make it a */
/*                    multiple of 4), use @FT_Bitmap_Convert.            */
/*                    Alternatively, you might use callback functions to */
/*                    directly render to the application's surface; see  */
/*                    the file `example2.cpp' in the tutorial for a      */
/*                    demonstration.                                     */
/*                                                                       */
/*    buffer       :: A typeless pointer to the bitmap buffer.  This     */
/*                    value should be aligned on 32-bit boundaries in    */
/*                    most cases.                                        */
/*                                                                       */
/*    num_grays    :: This field is only used with                       */
/*                    @FT_PIXEL_MODE_GRAY; it gives the number of gray   */
/*                    levels used in the bitmap.                         */
/*                                                                       */
/*    pixel_mode   :: The pixel mode, i.e., how pixel bits are stored.   */
/*                    See @FT_Pixel_Mode for possible values.            */
/*                                                                       */
/*    palette_mode :: This field is intended for paletted pixel modes;   */
/*                    it indicates how the palette is stored.  Not       */
/*                    used currently.                                    */
/*                                                                       */
/*    palette      :: A typeless pointer to the bitmap palette; this     */
/*                    field is intended for paletted pixel modes.  Not   */
/*                    used currently.                                    */
/*                                                                       */
/* <Note>                                                                */
/*   For now, the only pixel modes supported by FreeType are mono and    */
/*   grays.  However, drivers might be added in the future to support    */
/*   more `colorful' options.                                            */
/*                                                                       */
  typedef struct  FT_Bitmap_
  {
    int             rows;
    int             width;
    int             pitch;
    unsigned char*  buffer;
    short           num_grays;
    char            pixel_mode;
    char            palette_mode;
    void*           palette;
  } FT_Bitmap;
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    outline_processing                                                 */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Outline                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    This structure is used to describe an outline to the scan-line     */
/*    converter.                                                         */
/*                                                                       */
/* <Fields>                                                              */
/*    n_contours :: The number of contours in the outline.               */
/*                                                                       */
/*    n_points   :: The number of points in the outline.                 */
/*                                                                       */
/*    points     :: A pointer to an array of `n_points' @FT_Vector       */
/*                  elements, giving the outline's point coordinates.    */
/*                                                                       */
/*    tags       :: A pointer to an array of `n_points' chars, giving    */
/*                  each outline point's type.                           */
/*                                                                       */
/*                  If bit~0 is unset, the point is `off' the curve,     */
/*                  i.e., a Bézier control point, while it is `on' if    */
/*                  set.                                                 */
/*                                                                       */
/*                  Bit~1 is meaningful for `off' points only.  If set,  */
/*                  it indicates a third-order Bézier arc control point; */
/*                  and a second-order control point if unset.           */
/*                                                                       */
/*                  If bit~2 is set, bits 5-7 contain the drop-out mode  */
/*                  (as defined in the OpenType specification; the value */
/*                  is the same as the argument to the SCANMODE          */
/*                  instruction).                                        */
/*                                                                       */
/*                  Bits 3 and~4 are reserved for internal purposes.     */
/*                                                                       */
/*    contours   :: An array of `n_contours' shorts, giving the end      */
/*                  point of each contour within the outline.  For       */
/*                  example, the first contour is defined by the points  */
/*                  `0' to `contours[0]', the second one is defined by   */
/*                  the points `contours[0]+1' to `contours[1]', etc.    */
/*                                                                       */
/*    flags      :: A set of bit flags used to characterize the outline  */
/*                  and give hints to the scan-converter and hinter on   */
/*                  how to convert/grid-fit it.  See @FT_OUTLINE_FLAGS.  */
/*                                                                       */
/* <Note>                                                                */
/*    The B/W rasterizer only checks bit~2 in the `tags' array for the   */
/*    first point of each contour.  The drop-out mode as given with      */
/*    @FT_OUTLINE_IGNORE_DROPOUTS, @FT_OUTLINE_SMART_DROPOUTS, and       */
/*    @FT_OUTLINE_INCLUDE_STUBS in `flags' is then overridden.           */
/*                                                                       */
  typedef struct  FT_Outline_
  {
/* number of contours in glyph        */
    short       n_contours;       
/* number of points in the glyph      */
    short       n_points;         
/* the outline's points               */
    FT_Vector*  points;           
/* the points flags                   */
    char*       tags;             
/* the contour end points             */
    short*      contours;         
/* outline masks                      */
    int         flags;            
  } FT_Outline;
/* Following limits must be consistent with */
/* FT_Outline.{n_contours,n_points}         */
#define FT_OUTLINE_CONTOURS_MAX  SHRT_MAX
#define FT_OUTLINE_POINTS_MAX    SHRT_MAX
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_OUTLINE_FLAGS                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    A list of bit-field constants use for the flags in an outline's    */
/*    `flags' field.                                                     */
/*                                                                       */
/* <Values>                                                              */
/*    FT_OUTLINE_NONE ::                                                 */
/*      Value~0 is reserved.                                             */
/*                                                                       */
/*    FT_OUTLINE_OWNER ::                                                */
/*      If set, this flag indicates that the outline's field arrays      */
/*      (i.e., `points', `flags', and `contours') are `owned' by the     */
/*      outline object, and should thus be freed when it is destroyed.   */
/*                                                                       */
/*    FT_OUTLINE_EVEN_ODD_FILL ::                                        */
/*      By default, outlines are filled using the non-zero winding rule. */
/*      If set to 1, the outline will be filled using the even-odd fill  */
/*      rule (only works with the smooth rasterizer).                    */
/*                                                                       */
/*    FT_OUTLINE_REVERSE_FILL ::                                         */
/*      By default, outside contours of an outline are oriented in       */
/*      clock-wise direction, as defined in the TrueType specification.  */
/*      This flag is set if the outline uses the opposite direction      */
/*      (typically for Type~1 fonts).  This flag is ignored by the scan  */
/*      converter.                                                       */
/*                                                                       */
/*    FT_OUTLINE_IGNORE_DROPOUTS ::                                      */
/*      By default, the scan converter will try to detect drop-outs in   */
/*      an outline and correct the glyph bitmap to ensure consistent     */
/*      shape continuity.  If set, this flag hints the scan-line         */
/*      converter to ignore such cases.  See below for more information. */
/*                                                                       */
/*    FT_OUTLINE_SMART_DROPOUTS ::                                       */
/*      Select smart dropout control.  If unset, use simple dropout      */
/*      control.  Ignored if @FT_OUTLINE_IGNORE_DROPOUTS is set.  See    */
/*      below for more information.                                      */
/*                                                                       */
/*    FT_OUTLINE_INCLUDE_STUBS ::                                        */
/*      If set, turn pixels on for `stubs', otherwise exclude them.      */
/*      Ignored if @FT_OUTLINE_IGNORE_DROPOUTS is set.  See below for    */
/*      more information.                                                */
/*                                                                       */
/*    FT_OUTLINE_HIGH_PRECISION ::                                       */
/*      This flag indicates that the scan-line converter should try to   */
/*      convert this outline to bitmaps with the highest possible        */
/*      quality.  It is typically set for small character sizes.  Note   */
/*      that this is only a hint that might be completely ignored by a   */
/*      given scan-converter.                                            */
/*                                                                       */
/*    FT_OUTLINE_SINGLE_PASS ::                                          */
/*      This flag is set to force a given scan-converter to only use a   */
/*      single pass over the outline to render a bitmap glyph image.     */
/*      Normally, it is set for very large character sizes.  It is only  */
/*      a hint that might be completely ignored by a given               */
/*      scan-converter.                                                  */
/*                                                                       */
/* <Note>                                                                */
/*    The flags @FT_OUTLINE_IGNORE_DROPOUTS, @FT_OUTLINE_SMART_DROPOUTS, */
/*    and @FT_OUTLINE_INCLUDE_STUBS are ignored by the smooth            */
/*    rasterizer.                                                        */
/*                                                                       */
/*    There exists a second mechanism to pass the drop-out mode to the   */
/*    B/W rasterizer; see the `tags' field in @FT_Outline.               */
/*                                                                       */
/*    Please refer to the description of the `SCANTYPE' instruction in   */
/*    the OpenType specification (in file `ttinst1.doc') how simple      */
/*    drop-outs, smart drop-outs, and stubs are defined.                 */
/*                                                                       */
#define FT_OUTLINE_NONE             0x0
#define FT_OUTLINE_OWNER            0x1
#define FT_OUTLINE_EVEN_ODD_FILL    0x2
#define FT_OUTLINE_REVERSE_FILL     0x4
#define FT_OUTLINE_IGNORE_DROPOUTS  0x8
#define FT_OUTLINE_SMART_DROPOUTS   0x10
#define FT_OUTLINE_INCLUDE_STUBS    0x20
#define FT_OUTLINE_HIGH_PRECISION   0x100
#define FT_OUTLINE_SINGLE_PASS      0x200
/*************************************************************************
  *
  * @enum:
  *   ft_outline_flags
  *
  * @description:
  *   These constants are deprecated.  Please use the corresponding
  *   @FT_OUTLINE_FLAGS values.
  *
  * @values:
  *   ft_outline_none            :: See @FT_OUTLINE_NONE.
  *   ft_outline_owner           :: See @FT_OUTLINE_OWNER.
  *   ft_outline_even_odd_fill   :: See @FT_OUTLINE_EVEN_ODD_FILL.
  *   ft_outline_reverse_fill    :: See @FT_OUTLINE_REVERSE_FILL.
  *   ft_outline_ignore_dropouts :: See @FT_OUTLINE_IGNORE_DROPOUTS.
  *   ft_outline_high_precision  :: See @FT_OUTLINE_HIGH_PRECISION.
  *   ft_outline_single_pass     :: See @FT_OUTLINE_SINGLE_PASS.
  */
#define ft_outline_none             FT_OUTLINE_NONE
#define ft_outline_owner            FT_OUTLINE_OWNER
#define ft_outline_even_odd_fill    FT_OUTLINE_EVEN_ODD_FILL
#define ft_outline_reverse_fill     FT_OUTLINE_REVERSE_FILL
#define ft_outline_ignore_dropouts  FT_OUTLINE_IGNORE_DROPOUTS
#define ft_outline_high_precision   FT_OUTLINE_HIGH_PRECISION
#define ft_outline_single_pass      FT_OUTLINE_SINGLE_PASS
/* */
#define FT_CURVE_TAG( flag )  ( flag & 3 )
#define FT_CURVE_TAG_ON            1
#define FT_CURVE_TAG_CONIC         0
#define FT_CURVE_TAG_CUBIC         2
#define FT_CURVE_TAG_HAS_SCANMODE  4
/* reserved for the TrueType hinter */
#define FT_CURVE_TAG_TOUCH_X       8   
/* reserved for the TrueType hinter */
#define FT_CURVE_TAG_TOUCH_Y      16   
#define FT_CURVE_TAG_TOUCH_BOTH    ( FT_CURVE_TAG_TOUCH_X | \
                                     FT_CURVE_TAG_TOUCH_Y )
#define FT_Curve_Tag_On       FT_CURVE_TAG_ON
#define FT_Curve_Tag_Conic    FT_CURVE_TAG_CONIC
#define FT_Curve_Tag_Cubic    FT_CURVE_TAG_CUBIC
#define FT_Curve_Tag_Touch_X  FT_CURVE_TAG_TOUCH_X
#define FT_Curve_Tag_Touch_Y  FT_CURVE_TAG_TOUCH_Y
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Outline_MoveToFunc                                              */
/*                                                                       */
/* <Description>                                                         */
/*    A function pointer type used to describe the signature of a `move  */
/*    to' function during outline walking/decomposition.                 */
/*                                                                       */
/*    A `move to' is emitted to start a new contour in an outline.       */
/*                                                                       */
/* <Input>                                                               */
/*    to   :: A pointer to the target point of the `move to'.            */
/*                                                                       */
/*    user :: A typeless pointer which is passed from the caller of the  */
/*            decomposition function.                                    */
/*                                                                       */
/* <Return>                                                              */
/*    Error code.  0~means success.                                      */
/*                                                                       */
  typedef int
  (*FT_Outline_MoveToFunc)( const FT_Vector*  to,
                            void*             user );
#define FT_Outline_MoveTo_Func  FT_Outline_MoveToFunc
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Outline_LineToFunc                                              */
/*                                                                       */
/* <Description>                                                         */
/*    A function pointer type used to describe the signature of a `line  */
/*    to' function during outline walking/decomposition.                 */
/*                                                                       */
/*    A `line to' is emitted to indicate a segment in the outline.       */
/*                                                                       */
/* <Input>                                                               */
/*    to   :: A pointer to the target point of the `line to'.            */
/*                                                                       */
/*    user :: A typeless pointer which is passed from the caller of the  */
/*            decomposition function.                                    */
/*                                                                       */
/* <Return>                                                              */
/*    Error code.  0~means success.                                      */
/*                                                                       */
  typedef int
  (*FT_Outline_LineToFunc)( const FT_Vector*  to,
                            void*             user );
#define FT_Outline_LineTo_Func  FT_Outline_LineToFunc
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Outline_ConicToFunc                                             */
/*                                                                       */
/* <Description>                                                         */
/*    A function pointer type used to describe the signature of a `conic */
/*    to' function during outline walking or decomposition.              */
/*                                                                       */
/*    A `conic to' is emitted to indicate a second-order Bézier arc in   */
/*    the outline.                                                       */
/*                                                                       */
/* <Input>                                                               */
/*    control :: An intermediate control point between the last position */
/*               and the new target in `to'.                             */
/*                                                                       */
/*    to      :: A pointer to the target end point of the conic arc.     */
/*                                                                       */
/*    user    :: A typeless pointer which is passed from the caller of   */
/*               the decomposition function.                             */
/*                                                                       */
/* <Return>                                                              */
/*    Error code.  0~means success.                                      */
/*                                                                       */
  typedef int
  (*FT_Outline_ConicToFunc)( const FT_Vector*  control,
                             const FT_Vector*  to,
                             void*             user );
#define FT_Outline_ConicTo_Func  FT_Outline_ConicToFunc
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Outline_CubicToFunc                                             */
/*                                                                       */
/* <Description>                                                         */
/*    A function pointer type used to describe the signature of a `cubic */
/*    to' function during outline walking or decomposition.              */
/*                                                                       */
/*    A `cubic to' is emitted to indicate a third-order Bézier arc.      */
/*                                                                       */
/* <Input>                                                               */
/*    control1 :: A pointer to the first Bézier control point.           */
/*                                                                       */
/*    control2 :: A pointer to the second Bézier control point.          */
/*                                                                       */
/*    to       :: A pointer to the target end point.                     */
/*                                                                       */
/*    user     :: A typeless pointer which is passed from the caller of  */
/*                the decomposition function.                            */
/*                                                                       */
/* <Return>                                                              */
/*    Error code.  0~means success.                                      */
/*                                                                       */
  typedef int
  (*FT_Outline_CubicToFunc)( const FT_Vector*  control1,
                             const FT_Vector*  control2,
                             const FT_Vector*  to,
                             void*             user );
#define FT_Outline_CubicTo_Func  FT_Outline_CubicToFunc
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Outline_Funcs                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    A structure to hold various function pointers used during outline  */
/*    decomposition in order to emit segments, conic, and cubic Béziers. */
/*                                                                       */
/* <Fields>                                                              */
/*    move_to  :: The `move to' emitter.                                 */
/*                                                                       */
/*    line_to  :: The segment emitter.                                   */
/*                                                                       */
/*    conic_to :: The second-order Bézier arc emitter.                   */
/*                                                                       */
/*    cubic_to :: The third-order Bézier arc emitter.                    */
/*                                                                       */
/*    shift    :: The shift that is applied to coordinates before they   */
/*                are sent to the emitter.                               */
/*                                                                       */
/*    delta    :: The delta that is applied to coordinates before they   */
/*                are sent to the emitter, but after the shift.          */
/*                                                                       */
/* <Note>                                                                */
/*    The point coordinates sent to the emitters are the transformed     */
/*    version of the original coordinates (this is important for high    */
/*    accuracy during scan-conversion).  The transformation is simple:   */
/*                                                                       */
/*    {                                                                  */
/*      x' = (x << shift) - delta                                        */
/*      y' = (x << shift) - delta                                        */
/*    }                                                                  */
/*                                                                       */
/*    Set the values of `shift' and `delta' to~0 to get the original     */
/*    point coordinates.                                                 */
/*                                                                       */
  typedef struct  FT_Outline_Funcs_
  {
    FT_Outline_MoveToFunc   move_to;
    FT_Outline_LineToFunc   line_to;
    FT_Outline_ConicToFunc  conic_to;
    FT_Outline_CubicToFunc  cubic_to;
    int                     shift;
    FT_Pos                  delta;
  } FT_Outline_Funcs;
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    basic_types                                                        */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_IMAGE_TAG                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    This macro converts four-letter tags to an unsigned long type.     */
/*                                                                       */
/* <Note>                                                                */
/*    Since many 16-bit compilers don't like 32-bit enumerations, you    */
/*    should redefine this macro in case of problems to something like   */
/*    this:                                                              */
/*                                                                       */
/*    {                                                                  */
/*      #define FT_IMAGE_TAG( value, _x1, _x2, _x3, _x4 )  value         */
/*    }                                                                  */
/*                                                                       */
/*    to get a simple enumeration without assigning special numbers.     */
/*                                                                       */
#ifndef FT_IMAGE_TAG
#define FT_IMAGE_TAG( value, _x1, _x2, _x3, _x4 )  \
          value = ( ( (unsigned long)_x1 << 24 ) | \
                    ( (unsigned long)_x2 << 16 ) | \
                    ( (unsigned long)_x3 << 8  ) | \
                      (unsigned long)_x4         )
/* FT_IMAGE_TAG */
#endif  
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_Glyph_Format                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    An enumeration type used to describe the format of a given glyph   */
/*    image.  Note that this version of FreeType only supports two image */
/*    formats, even though future font drivers will be able to register  */
/*    their own format.                                                  */
/*                                                                       */
/* <Values>                                                              */
/*    FT_GLYPH_FORMAT_NONE ::                                            */
/*      The value~0 is reserved.                                         */
/*                                                                       */
/*    FT_GLYPH_FORMAT_COMPOSITE ::                                       */
/*      The glyph image is a composite of several other images.  This    */
/*      format is _only_ used with @FT_LOAD_NO_RECURSE, and is used to   */
/*      report compound glyphs (like accented characters).               */
/*                                                                       */
/*    FT_GLYPH_FORMAT_BITMAP ::                                          */
/*      The glyph image is a bitmap, and can be described as an          */
/*      @FT_Bitmap.  You generally need to access the `bitmap' field of  */
/*      the @FT_GlyphSlotRec structure to read it.                       */
/*                                                                       */
/*    FT_GLYPH_FORMAT_OUTLINE ::                                         */
/*      The glyph image is a vectorial outline made of line segments     */
/*      and Bézier arcs; it can be described as an @FT_Outline; you      */
/*      generally want to access the `outline' field of the              */
/*      @FT_GlyphSlotRec structure to read it.                           */
/*                                                                       */
/*    FT_GLYPH_FORMAT_PLOTTER ::                                         */
/*      The glyph image is a vectorial path with no inside and outside   */
/*      contours.  Some Type~1 fonts, like those in the Hershey family,  */
/*      contain glyphs in this format.  These are described as           */
/*      @FT_Outline, but FreeType isn't currently capable of rendering   */
/*      them correctly.                                                  */
/*                                                                       */
  typedef enum  FT_Glyph_Format_
  {
    FT_IMAGE_TAG( FT_GLYPH_FORMAT_NONE, 0, 0, 0, 0 ),
    FT_IMAGE_TAG( FT_GLYPH_FORMAT_COMPOSITE, 'c', 'o', 'm', 'p' ),
    FT_IMAGE_TAG( FT_GLYPH_FORMAT_BITMAP,    'b', 'i', 't', 's' ),
    FT_IMAGE_TAG( FT_GLYPH_FORMAT_OUTLINE,   'o', 'u', 't', 'l' ),
    FT_IMAGE_TAG( FT_GLYPH_FORMAT_PLOTTER,   'p', 'l', 'o', 't' )
  } FT_Glyph_Format;
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    ft_glyph_format_xxx                                                */
/*                                                                       */
/* <Description>                                                         */
/*    A list of deprecated constants.  Use the corresponding             */
/*    @FT_Glyph_Format values instead.                                   */
/*                                                                       */
/* <Values>                                                              */
/*    ft_glyph_format_none      :: See @FT_GLYPH_FORMAT_NONE.            */
/*    ft_glyph_format_composite :: See @FT_GLYPH_FORMAT_COMPOSITE.       */
/*    ft_glyph_format_bitmap    :: See @FT_GLYPH_FORMAT_BITMAP.          */
/*    ft_glyph_format_outline   :: See @FT_GLYPH_FORMAT_OUTLINE.         */
/*    ft_glyph_format_plotter   :: See @FT_GLYPH_FORMAT_PLOTTER.         */
/*                                                                       */
#define ft_glyph_format_none       FT_GLYPH_FORMAT_NONE
#define ft_glyph_format_composite  FT_GLYPH_FORMAT_COMPOSITE
#define ft_glyph_format_bitmap     FT_GLYPH_FORMAT_BITMAP
#define ft_glyph_format_outline    FT_GLYPH_FORMAT_OUTLINE
#define ft_glyph_format_plotter    FT_GLYPH_FORMAT_PLOTTER
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*****                                                               *****/
/*****            R A S T E R   D E F I N I T I O N S                *****/
/*****                                                               *****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* A raster is a scan converter, in charge of rendering an outline into  */
/* a a bitmap.  This section contains the public API for rasters.        */
/*                                                                       */
/* Note that in FreeType 2, all rasters are now encapsulated within      */
/* specific modules called `renderers'.  See `freetype/ftrender.h' for   */
/* more details on renderers.                                            */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    raster                                                             */
/*                                                                       */
/* <Title>                                                               */
/*    Scanline Converter                                                 */
/*                                                                       */
/* <Abstract>                                                            */
/*    How vectorial outlines are converted into bitmaps and pixmaps.     */
/*                                                                       */
/* <Description>                                                         */
/*    This section contains technical definitions.                       */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Raster                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A handle (pointer) to a raster object.  Each object can be used    */
/*    independently to convert an outline into a bitmap or pixmap.       */
/*                                                                       */
  typedef struct FT_RasterRec_*  FT_Raster;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Span                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to model a single span of gray (or black) pixels  */
/*    when rendering a monochrome or anti-aliased bitmap.                */
/*                                                                       */
/* <Fields>                                                              */
/*    x        :: The span's horizontal start position.                  */
/*                                                                       */
/*    len      :: The span's length in pixels.                           */
/*                                                                       */
/*    coverage :: The span color/coverage, ranging from 0 (background)   */
/*                to 255 (foreground).  Only used for anti-aliased       */
/*                rendering.                                             */
/*                                                                       */
/* <Note>                                                                */
/*    This structure is used by the span drawing callback type named     */
/*    @FT_SpanFunc which takes the y~coordinate of the span as a         */
/*    a parameter.                                                       */
/*                                                                       */
/*    The coverage value is always between 0 and 255.  If you want less  */
/*    gray values, the callback function has to reduce them.             */
/*                                                                       */
  typedef struct  FT_Span_
  {
    short           x;
    unsigned short  len;
    unsigned char   coverage;
  } FT_Span;
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_SpanFunc                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    A function used as a call-back by the anti-aliased renderer in     */
/*    order to let client applications draw themselves the gray pixel    */
/*    spans on each scan line.                                           */
/*                                                                       */
/* <Input>                                                               */
/*    y     :: The scanline's y~coordinate.                              */
/*                                                                       */
/*    count :: The number of spans to draw on this scanline.             */
/*                                                                       */
/*    spans :: A table of `count' spans to draw on the scanline.         */
/*                                                                       */
/*    user  :: User-supplied data that is passed to the callback.        */
/*                                                                       */
/* <Note>                                                                */
/*    This callback allows client applications to directly render the    */
/*    gray spans of the anti-aliased bitmap to any kind of surfaces.     */
/*                                                                       */
/*    This can be used to write anti-aliased outlines directly to a      */
/*    given background bitmap, and even perform translucency.            */
/*                                                                       */
/*    Note that the `count' field cannot be greater than a fixed value   */
/*    defined by the `FT_MAX_GRAY_SPANS' configuration macro in          */
/*    `ftoption.h'.  By default, this value is set to~32, which means    */
/*    that if there are more than 32~spans on a given scanline, the      */
/*    callback is called several times with the same `y' parameter in    */
/*    order to draw all callbacks.                                       */
/*                                                                       */
/*    Otherwise, the callback is only called once per scan-line, and     */
/*    only for those scanlines that do have `gray' pixels on them.       */
/*                                                                       */
  typedef void
  (*FT_SpanFunc)( int             y,
                  int             count,
                  const FT_Span*  spans,
                  void*           user );
#define FT_Raster_Span_Func  FT_SpanFunc
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Raster_BitTest_Func                                             */
/*                                                                       */
/* <Description>                                                         */
/*    THIS TYPE IS DEPRECATED.  DO NOT USE IT.                           */
/*                                                                       */
/*    A function used as a call-back by the monochrome scan-converter    */
/*    to test whether a given target pixel is already set to the drawing */
/*    `color'.  These tests are crucial to implement drop-out control    */
/*    per-se the TrueType spec.                                          */
/*                                                                       */
/* <Input>                                                               */
/*    y     :: The pixel's y~coordinate.                                 */
/*                                                                       */
/*    x     :: The pixel's x~coordinate.                                 */
/*                                                                       */
/*    user  :: User-supplied data that is passed to the callback.        */
/*                                                                       */
/* <Return>                                                              */
/*   1~if the pixel is `set', 0~otherwise.                               */
/*                                                                       */
  typedef int
  (*FT_Raster_BitTest_Func)( int    y,
                             int    x,
                             void*  user );
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Raster_BitSet_Func                                              */
/*                                                                       */
/* <Description>                                                         */
/*    THIS TYPE IS DEPRECATED.  DO NOT USE IT.                           */
/*                                                                       */
/*    A function used as a call-back by the monochrome scan-converter    */
/*    to set an individual target pixel.  This is crucial to implement   */
/*    drop-out control according to the TrueType specification.          */
/*                                                                       */
/* <Input>                                                               */
/*    y     :: The pixel's y~coordinate.                                 */
/*                                                                       */
/*    x     :: The pixel's x~coordinate.                                 */
/*                                                                       */
/*    user  :: User-supplied data that is passed to the callback.        */
/*                                                                       */
/* <Return>                                                              */
/*    1~if the pixel is `set', 0~otherwise.                              */
/*                                                                       */
  typedef void
  (*FT_Raster_BitSet_Func)( int    y,
                            int    x,
                            void*  user );
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_RASTER_FLAG_XXX                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    A list of bit flag constants as used in the `flags' field of a     */
/*    @FT_Raster_Params structure.                                       */
/*                                                                       */
/* <Values>                                                              */
/*    FT_RASTER_FLAG_DEFAULT :: This value is 0.                         */
/*                                                                       */
/*    FT_RASTER_FLAG_AA      :: This flag is set to indicate that an     */
/*                              anti-aliased glyph image should be       */
/*                              generated.  Otherwise, it will be        */
/*                              monochrome (1-bit).                      */
/*                                                                       */
/*    FT_RASTER_FLAG_DIRECT  :: This flag is set to indicate direct      */
/*                              rendering.  In this mode, client         */
/*                              applications must provide their own span */
/*                              callback.  This lets them directly       */
/*                              draw or compose over an existing bitmap. */
/*                              If this bit is not set, the target       */
/*                              pixmap's buffer _must_ be zeroed before  */
/*                              rendering.                               */
/*                                                                       */
/*                              Note that for now, direct rendering is   */
/*                              only possible with anti-aliased glyphs.  */
/*                                                                       */
/*    FT_RASTER_FLAG_CLIP    :: This flag is only used in direct         */
/*                              rendering mode.  If set, the output will */
/*                              be clipped to a box specified in the     */
/*                              `clip_box' field of the                  */
/*                              @FT_Raster_Params structure.             */
/*                                                                       */
/*                              Note that by default, the glyph bitmap   */
/*                              is clipped to the target pixmap, except  */
/*                              in direct rendering mode where all spans */
/*                              are generated if no clipping box is set. */
/*                                                                       */
#define FT_RASTER_FLAG_DEFAULT  0x0
#define FT_RASTER_FLAG_AA       0x1
#define FT_RASTER_FLAG_DIRECT   0x2
#define FT_RASTER_FLAG_CLIP     0x4
/* deprecated */
#define ft_raster_flag_default  FT_RASTER_FLAG_DEFAULT
#define ft_raster_flag_aa       FT_RASTER_FLAG_AA
#define ft_raster_flag_direct   FT_RASTER_FLAG_DIRECT
#define ft_raster_flag_clip     FT_RASTER_FLAG_CLIP
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Raster_Params                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    A structure to hold the arguments used by a raster's render        */
/*    function.                                                          */
/*                                                                       */
/* <Fields>                                                              */
/*    target      :: The target bitmap.                                  */
/*                                                                       */
/*    source      :: A pointer to the source glyph image (e.g., an       */
/*                   @FT_Outline).                                       */
/*                                                                       */
/*    flags       :: The rendering flags.                                */
/*                                                                       */
/*    gray_spans  :: The gray span drawing callback.                     */
/*                                                                       */
/*    black_spans :: The black span drawing callback.  UNIMPLEMENTED!    */
/*                                                                       */
/*    bit_test    :: The bit test callback.  UNIMPLEMENTED!              */
/*                                                                       */
/*    bit_set     :: The bit set callback.  UNIMPLEMENTED!               */
/*                                                                       */
/*    user        :: User-supplied data that is passed to each drawing   */
/*                   callback.                                           */
/*                                                                       */
/*    clip_box    :: An optional clipping box.  It is only used in       */
/*                   direct rendering mode.  Note that coordinates here  */
/*                   should be expressed in _integer_ pixels (and not in */
/*                   26.6 fixed-point units).                            */
/*                                                                       */
/* <Note>                                                                */
/*    An anti-aliased glyph bitmap is drawn if the @FT_RASTER_FLAG_AA    */
/*    bit flag is set in the `flags' field, otherwise a monochrome       */
/*    bitmap is generated.                                               */
/*                                                                       */
/*    If the @FT_RASTER_FLAG_DIRECT bit flag is set in `flags', the      */
/*    raster will call the `gray_spans' callback to draw gray pixel      */
/*    spans, in the case of an aa glyph bitmap, it will call             */
/*    `black_spans', and `bit_test' and `bit_set' in the case of a       */
/*    monochrome bitmap.  This allows direct composition over a          */
/*    pre-existing bitmap through user-provided callbacks to perform the */
/*    span drawing/composition.                                          */
/*                                                                       */
/*    Note that the `bit_test' and `bit_set' callbacks are required when */
/*    rendering a monochrome bitmap, as they are crucial to implement    */
/*    correct drop-out control as defined in the TrueType specification. */
/*                                                                       */
  typedef struct  FT_Raster_Params_
  {
    const FT_Bitmap*        target;
    const void*             source;
    int                     flags;
    FT_SpanFunc             gray_spans;
/* doesn't work! */
    FT_SpanFunc             black_spans;   
/* doesn't work! */
    FT_Raster_BitTest_Func  bit_test;      
/* doesn't work! */
    FT_Raster_BitSet_Func   bit_set;       
    void*                   user;
    FT_BBox                 clip_box;
  } FT_Raster_Params;
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Raster_NewFunc                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to create a new raster object.                     */
/*                                                                       */
/* <Input>                                                               */
/*    memory :: A handle to the memory allocator.                        */
/*                                                                       */
/* <Output>                                                              */
/*    raster :: A handle to the new raster object.                       */
/*                                                                       */
/* <Return>                                                              */
/*    Error code.  0~means success.                                      */
/*                                                                       */
/* <Note>                                                                */
/*    The `memory' parameter is a typeless pointer in order to avoid     */
/*    un-wanted dependencies on the rest of the FreeType code.  In       */
/*    practice, it is an @FT_Memory object, i.e., a handle to the        */
/*    standard FreeType memory allocator.  However, this field can be    */
/*    completely ignored by a given raster implementation.               */
/*                                                                       */
  typedef int
  (*FT_Raster_NewFunc)( void*       memory,
                        FT_Raster*  raster );
#define FT_Raster_New_Func  FT_Raster_NewFunc
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Raster_DoneFunc                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to destroy a given raster object.                  */
/*                                                                       */
/* <Input>                                                               */
/*    raster :: A handle to the raster object.                           */
/*                                                                       */
  typedef void
  (*FT_Raster_DoneFunc)( FT_Raster  raster );
#define FT_Raster_Done_Func  FT_Raster_DoneFunc
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Raster_ResetFunc                                                */
/*                                                                       */
/* <Description>                                                         */
/*    FreeType provides an area of memory called the `render pool',      */
/*    available to all registered rasters.  This pool can be freely used */
/*    during a given scan-conversion but is shared by all rasters.  Its  */
/*    content is thus transient.                                         */
/*                                                                       */
/*    This function is called each time the render pool changes, or just */
/*    after a new raster object is created.                              */
/*                                                                       */
/* <Input>                                                               */
/*    raster    :: A handle to the new raster object.                    */
/*                                                                       */
/*    pool_base :: The address in memory of the render pool.             */
/*                                                                       */
/*    pool_size :: The size in bytes of the render pool.                 */
/*                                                                       */
/* <Note>                                                                */
/*    Rasters can ignore the render pool and rely on dynamic memory      */
/*    allocation if they want to (a handle to the memory allocator is    */
/*    passed to the raster constructor).  However, this is not           */
/*    recommended for efficiency purposes.                               */
/*                                                                       */
  typedef void
  (*FT_Raster_ResetFunc)( FT_Raster       raster,
                          unsigned char*  pool_base,
                          unsigned long   pool_size );
#define FT_Raster_Reset_Func  FT_Raster_ResetFunc
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Raster_SetModeFunc                                              */
/*                                                                       */
/* <Description>                                                         */
/*    This function is a generic facility to change modes or attributes  */
/*    in a given raster.  This can be used for debugging purposes, or    */
/*    simply to allow implementation-specific `features' in a given      */
/*    raster module.                                                     */
/*                                                                       */
/* <Input>                                                               */
/*    raster :: A handle to the new raster object.                       */
/*                                                                       */
/*    mode   :: A 4-byte tag used to name the mode or property.          */
/*                                                                       */
/*    args   :: A pointer to the new mode/property to use.               */
/*                                                                       */
  typedef int
  (*FT_Raster_SetModeFunc)( FT_Raster      raster,
                            unsigned long  mode,
                            void*          args );
#define FT_Raster_Set_Mode_Func  FT_Raster_SetModeFunc
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Raster_RenderFunc                                               */
/*                                                                       */
/* <Description>                                                         */
/*    Invoke a given raster to scan-convert a given glyph image into a   */
/*    target bitmap.                                                     */
/*                                                                       */
/* <Input>                                                               */
/*    raster :: A handle to the raster object.                           */
/*                                                                       */
/*    params :: A pointer to an @FT_Raster_Params structure used to      */
/*              store the rendering parameters.                          */
/*                                                                       */
/* <Return>                                                              */
/*    Error code.  0~means success.                                      */
/*                                                                       */
/* <Note>                                                                */
/*    The exact format of the source image depends on the raster's glyph */
/*    format defined in its @FT_Raster_Funcs structure.  It can be an    */
/*    @FT_Outline or anything else in order to support a large array of  */
/*    glyph formats.                                                     */
/*                                                                       */
/*    Note also that the render function can fail and return a           */
/*    `FT_Err_Unimplemented_Feature' error code if the raster used does  */
/*    not support direct composition.                                    */
/*                                                                       */
/*    XXX: For now, the standard raster doesn't support direct           */
/*         composition but this should change for the final release (see */
/*         the files `demos/src/ftgrays.c' and `demos/src/ftgrays2.c'    */
/*         for examples of distinct implementations which support direct */
/*         composition).                                                 */
/*                                                                       */
  typedef int
  (*FT_Raster_RenderFunc)( FT_Raster                raster,
                           const FT_Raster_Params*  params );
#define FT_Raster_Render_Func  FT_Raster_RenderFunc
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Raster_Funcs                                                    */
/*                                                                       */
/* <Description>                                                         */
/*   A structure used to describe a given raster class to the library.   */
/*                                                                       */
/* <Fields>                                                              */
/*    glyph_format  :: The supported glyph format for this raster.       */
/*                                                                       */
/*    raster_new    :: The raster constructor.                           */
/*                                                                       */
/*    raster_reset  :: Used to reset the render pool within the raster.  */
/*                                                                       */
/*    raster_render :: A function to render a glyph into a given bitmap. */
/*                                                                       */
/*    raster_done   :: The raster destructor.                            */
/*                                                                       */
  typedef struct  FT_Raster_Funcs_
  {
    FT_Glyph_Format        glyph_format;
    FT_Raster_NewFunc      raster_new;
    FT_Raster_ResetFunc    raster_reset;
    FT_Raster_SetModeFunc  raster_set_mode;
    FT_Raster_RenderFunc   raster_render;
    FT_Raster_DoneFunc     raster_done;
  } FT_Raster_Funcs;
/* */
FT_END_HEADER
/* END */
/* Local Variables: */
/* coding: utf-8    */
/* End:             */
#include <stddef.h>
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    basic_types                                                        */
/*                                                                       */
/* <Title>                                                               */
/*    Basic Data Types                                                   */
/*                                                                       */
/* <Abstract>                                                            */
/*    The basic data types defined by the library.                       */
/*                                                                       */
/* <Description>                                                         */
/*    This section contains the basic data types defined by FreeType~2,  */
/*    ranging from simple scalar types to bitmap descriptors.  More      */
/*    font-specific structures are defined in a different section.       */
/*                                                                       */
/* <Order>                                                               */
/*    FT_Byte                                                            */
/*    FT_Bytes                                                           */
/*    FT_Char                                                            */
/*    FT_Int                                                             */
/*    FT_UInt                                                            */
/*    FT_Int16                                                           */
/*    FT_UInt16                                                          */
/*    FT_Int32                                                           */
/*    FT_UInt32                                                          */
/*    FT_Short                                                           */
/*    FT_UShort                                                          */
/*    FT_Long                                                            */
/*    FT_ULong                                                           */
/*    FT_Bool                                                            */
/*    FT_Offset                                                          */
/*    FT_PtrDist                                                         */
/*    FT_String                                                          */
/*    FT_Tag                                                             */
/*    FT_Error                                                           */
/*    FT_Fixed                                                           */
/*    FT_Pointer                                                         */
/*    FT_Pos                                                             */
/*    FT_Vector                                                          */
/*    FT_BBox                                                            */
/*    FT_Matrix                                                          */
/*    FT_FWord                                                           */
/*    FT_UFWord                                                          */
/*    FT_F2Dot14                                                         */
/*    FT_UnitVector                                                      */
/*    FT_F26Dot6                                                         */
/*                                                                       */
/*                                                                       */
/*    FT_Generic                                                         */
/*    FT_Generic_Finalizer                                               */
/*                                                                       */
/*    FT_Bitmap                                                          */
/*    FT_Pixel_Mode                                                      */
/*    FT_Palette_Mode                                                    */
/*    FT_Glyph_Format                                                    */
/*    FT_IMAGE_TAG                                                       */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Bool                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef of unsigned char, used for simple booleans.  As usual,   */
/*    values 1 and~0 represent true and false, respectively.             */
/*                                                                       */
  typedef unsigned char  FT_Bool;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_FWord                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    A signed 16-bit integer used to store a distance in original font  */
/*    units.                                                             */
/*                                                                       */
/* distance in FUnits */
  typedef signed short  FT_FWord;    
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_UFWord                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    An unsigned 16-bit integer used to store a distance in original    */
/*    font units.                                                        */
/*                                                                       */
/* unsigned distance */
  typedef unsigned short  FT_UFWord;   
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Char                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A simple typedef for the _signed_ char type.                       */
/*                                                                       */
  typedef signed char  FT_Char;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Byte                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A simple typedef for the _unsigned_ char type.                     */
/*                                                                       */
  typedef unsigned char  FT_Byte;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Bytes                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for constant memory areas.                               */
/*                                                                       */
  typedef const FT_Byte*  FT_Bytes;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Tag                                                             */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for 32-bit tags (as used in the SFNT format).            */
/*                                                                       */
  typedef FT_UInt32  FT_Tag;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_String                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A simple typedef for the char type, usually used for strings.      */
/*                                                                       */
  typedef char  FT_String;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Short                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for signed short.                                        */
/*                                                                       */
  typedef signed short  FT_Short;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_UShort                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for unsigned short.                                      */
/*                                                                       */
  typedef unsigned short  FT_UShort;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Int                                                             */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for the int type.                                        */
/*                                                                       */
  typedef signed int  FT_Int;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_UInt                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for the unsigned int type.                               */
/*                                                                       */
  typedef unsigned int  FT_UInt;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Long                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for signed long.                                         */
/*                                                                       */
  typedef signed long  FT_Long;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_ULong                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    A typedef for unsigned long.                                       */
/*                                                                       */
  typedef unsigned long  FT_ULong;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_F2Dot14                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    A signed 2.14 fixed float type used for unit vectors.              */
/*                                                                       */
  typedef signed short  FT_F2Dot14;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_F26Dot6                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    A signed 26.6 fixed float type used for vectorial pixel            */
/*    coordinates.                                                       */
/*                                                                       */
  typedef signed long  FT_F26Dot6;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Fixed                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    This type is used to store 16.16 fixed float values, like scaling  */
/*    values or matrix coefficients.                                     */
/*                                                                       */
  typedef signed long  FT_Fixed;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Error                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    The FreeType error code type.  A value of~0 is always interpreted  */
/*    as a successful operation.                                         */
/*                                                                       */
  typedef int  FT_Error;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Pointer                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    A simple typedef for a typeless pointer.                           */
/*                                                                       */
  typedef void*  FT_Pointer;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Offset                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    This is equivalent to the ANSI~C `size_t' type, i.e., the largest  */
/*    _unsigned_ integer type used to express a file size or position,   */
/*    or a memory block size.                                            */
/*                                                                       */
  typedef size_t  FT_Offset;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_PtrDist                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    This is equivalent to the ANSI~C `ptrdiff_t' type, i.e., the       */
/*    largest _signed_ integer type used to express the distance         */
/*    between two pointers.                                              */
/*                                                                       */
  typedef ft_ptrdiff_t  FT_PtrDist;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_UnitVector                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    A simple structure used to store a 2D vector unit vector.  Uses    */
/*    FT_F2Dot14 types.                                                  */
/*                                                                       */
/* <Fields>                                                              */
/*    x :: Horizontal coordinate.                                        */
/*                                                                       */
/*    y :: Vertical coordinate.                                          */
/*                                                                       */
  typedef struct  FT_UnitVector_
  {
    FT_F2Dot14  x;
    FT_F2Dot14  y;
  } FT_UnitVector;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Matrix                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A simple structure used to store a 2x2 matrix.  Coefficients are   */
/*    in 16.16 fixed float format.  The computation performed is:        */
/*                                                                       */
/*       {                                                               */
/*          x' = x*xx + y*xy                                             */
/*          y' = x*yx + y*yy                                             */
/*       }                                                               */
/*                                                                       */
/* <Fields>                                                              */
/*    xx :: Matrix coefficient.                                          */
/*                                                                       */
/*    xy :: Matrix coefficient.                                          */
/*                                                                       */
/*    yx :: Matrix coefficient.                                          */
/*                                                                       */
/*    yy :: Matrix coefficient.                                          */
/*                                                                       */
  typedef struct  FT_Matrix_
  {
    FT_Fixed  xx, xy;
    FT_Fixed  yx, yy;
  } FT_Matrix;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Data                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    Read-only binary data represented as a pointer and a length.       */
/*                                                                       */
/* <Fields>                                                              */
/*    pointer :: The data.                                               */
/*                                                                       */
/*    length  :: The length of the data in bytes.                        */
/*                                                                       */
  typedef struct  FT_Data_
  {
    const FT_Byte*  pointer;
    FT_Int          length;
  } FT_Data;
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Generic_Finalizer                                               */
/*                                                                       */
/* <Description>                                                         */
/*    Describe a function used to destroy the `client' data of any       */
/*    FreeType object.  See the description of the @FT_Generic type for  */
/*    details of usage.                                                  */
/*                                                                       */
/* <Input>                                                               */
/*    The address of the FreeType object which is under finalization.    */
/*    Its client data is accessed through its `generic' field.           */
/*                                                                       */
  typedef void  (*FT_Generic_Finalizer)(void*  object);
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Generic                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    Client applications often need to associate their own data to a    */
/*    variety of FreeType core objects.  For example, a text layout API  */
/*    might want to associate a glyph cache to a given size object.      */
/*                                                                       */
/*    Some FreeType object contains a `generic' field, of type           */
/*    FT_Generic, which usage is left to client applications and font    */
/*    servers.                                                           */
/*                                                                       */
/*    It can be used to store a pointer to client-specific data, as well */
/*    as the address of a `finalizer' function, which will be called by  */
/*    FreeType when the object is destroyed (for example, the previous   */
/*    client example would put the address of the glyph cache destructor */
/*    in the `finalizer' field).                                         */
/*                                                                       */
/* <Fields>                                                              */
/*    data      :: A typeless pointer to any client-specified data. This */
/*                 field is completely ignored by the FreeType library.  */
/*                                                                       */
/*    finalizer :: A pointer to a `generic finalizer' function, which    */
/*                 will be called when the object is destroyed.  If this */
/*                 field is set to NULL, no code will be called.         */
/*                                                                       */
  typedef struct  FT_Generic_
  {
    void*                 data;
    FT_Generic_Finalizer  finalizer;
  } FT_Generic;
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_MAKE_TAG                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    This macro converts four-letter tags which are used to label       */
/*    TrueType tables into an unsigned long to be used within FreeType.  */
/*                                                                       */
/* <Note>                                                                */
/*    The produced values *must* be 32-bit integers.  Don't redefine     */
/*    this macro.                                                        */
/*                                                                       */
#define FT_MAKE_TAG( _x1, _x2, _x3, _x4 ) \
          (FT_Tag)                        \
          ( ( (FT_ULong)_x1 << 24 ) |     \
            ( (FT_ULong)_x2 << 16 ) |     \
            ( (FT_ULong)_x3 <<  8 ) |     \
              (FT_ULong)_x4         )
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/*                    L I S T   M A N A G E M E N T                      */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    list_processing                                                    */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_ListNode                                                        */
/*                                                                       */
/* <Description>                                                         */
/*     Many elements and objects in FreeType are listed through an       */
/*     @FT_List record (see @FT_ListRec).  As its name suggests, an      */
/*     FT_ListNode is a handle to a single list element.                 */
/*                                                                       */
  typedef struct FT_ListNodeRec_*  FT_ListNode;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_List                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a list record (see @FT_ListRec).                       */
/*                                                                       */
  typedef struct FT_ListRec_*  FT_List;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_ListNodeRec                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to hold a single list element.                    */
/*                                                                       */
/* <Fields>                                                              */
/*    prev :: The previous element in the list.  NULL if first.          */
/*                                                                       */
/*    next :: The next element in the list.  NULL if last.               */
/*                                                                       */
/*    data :: A typeless pointer to the listed object.                   */
/*                                                                       */
  typedef struct  FT_ListNodeRec_
  {
    FT_ListNode  prev;
    FT_ListNode  next;
    void*        data;
  } FT_ListNodeRec;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_ListRec                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to hold a simple doubly-linked list.  These are   */
/*    used in many parts of FreeType.                                    */
/*                                                                       */
/* <Fields>                                                              */
/*    head :: The head (first element) of doubly-linked list.            */
/*                                                                       */
/*    tail :: The tail (last element) of doubly-linked list.             */
/*                                                                       */
  typedef struct  FT_ListRec_
  {
    FT_ListNode  head;
    FT_ListNode  tail;
  } FT_ListRec;
/* */
#define FT_IS_EMPTY( list )  ( (list).head == 0 )
/* return base error code (without module-specific prefix) */
#define FT_ERROR_BASE( x )    ( (x) & 0xFF )
/* return module error code */
#define FT_ERROR_MODULE( x )  ( (x) & 0xFF00U )
#define FT_BOOL( x )  ( (FT_Bool)( x ) )
FT_END_HEADER
/* END */
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    user_allocation                                                    */
/*                                                                       */
/* <Title>                                                               */
/*    User allocation                                                    */
/*                                                                       */
/* <Abstract>                                                            */
/*    How client applications should allocate FreeType data structures.  */
/*                                                                       */
/* <Description>                                                         */
/*    FreeType assumes that structures allocated by the user and passed  */
/*    as arguments are zeroed out except for the actual data.  In other  */
/*    words, it is recommended to use `calloc' (or variants of it)       */
/*    instead of `malloc' for allocation.                                */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/*                        B A S I C   T Y P E S                          */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    base_interface                                                     */
/*                                                                       */
/* <Title>                                                               */
/*    Base Interface                                                     */
/*                                                                       */
/* <Abstract>                                                            */
/*    The FreeType~2 base font interface.                                */
/*                                                                       */
/* <Description>                                                         */
/*    This section describes the public high-level API of FreeType~2.    */
/*                                                                       */
/* <Order>                                                               */
/*    FT_Library                                                         */
/*    FT_Face                                                            */
/*    FT_Size                                                            */
/*    FT_GlyphSlot                                                       */
/*    FT_CharMap                                                         */
/*    FT_Encoding                                                        */
/*                                                                       */
/*    FT_FaceRec                                                         */
/*                                                                       */
/*    FT_FACE_FLAG_SCALABLE                                              */
/*    FT_FACE_FLAG_FIXED_SIZES                                           */
/*    FT_FACE_FLAG_FIXED_WIDTH                                           */
/*    FT_FACE_FLAG_HORIZONTAL                                            */
/*    FT_FACE_FLAG_VERTICAL                                              */
/*    FT_FACE_FLAG_SFNT                                                  */
/*    FT_FACE_FLAG_KERNING                                               */
/*    FT_FACE_FLAG_MULTIPLE_MASTERS                                      */
/*    FT_FACE_FLAG_GLYPH_NAMES                                           */
/*    FT_FACE_FLAG_EXTERNAL_STREAM                                       */
/*    FT_FACE_FLAG_FAST_GLYPHS                                           */
/*    FT_FACE_FLAG_HINTER                                                */
/*                                                                       */
/*    FT_STYLE_FLAG_BOLD                                                 */
/*    FT_STYLE_FLAG_ITALIC                                               */
/*                                                                       */
/*    FT_SizeRec                                                         */
/*    FT_Size_Metrics                                                    */
/*                                                                       */
/*    FT_GlyphSlotRec                                                    */
/*    FT_Glyph_Metrics                                                   */
/*    FT_SubGlyph                                                        */
/*                                                                       */
/*    FT_Bitmap_Size                                                     */
/*                                                                       */
/*    FT_Init_FreeType                                                   */
/*    FT_Done_FreeType                                                   */
/*                                                                       */
/*    FT_New_Face                                                        */
/*    FT_Done_Face                                                       */
/*    FT_New_Memory_Face                                                 */
/*    FT_Open_Face                                                       */
/*    FT_Open_Args                                                       */
/*    FT_Parameter                                                       */
/*    FT_Attach_File                                                     */
/*    FT_Attach_Stream                                                   */
/*                                                                       */
/*    FT_Set_Char_Size                                                   */
/*    FT_Set_Pixel_Sizes                                                 */
/*    FT_Request_Size                                                    */
/*    FT_Select_Size                                                     */
/*    FT_Size_Request_Type                                               */
/*    FT_Size_Request                                                    */
/*    FT_Set_Transform                                                   */
/*    FT_Load_Glyph                                                      */
/*    FT_Get_Char_Index                                                  */
/*    FT_Get_Name_Index                                                  */
/*    FT_Load_Char                                                       */
/*                                                                       */
/*    FT_OPEN_MEMORY                                                     */
/*    FT_OPEN_STREAM                                                     */
/*    FT_OPEN_PATHNAME                                                   */
/*    FT_OPEN_DRIVER                                                     */
/*    FT_OPEN_PARAMS                                                     */
/*                                                                       */
/*    FT_LOAD_DEFAULT                                                    */
/*    FT_LOAD_RENDER                                                     */
/*    FT_LOAD_MONOCHROME                                                 */
/*    FT_LOAD_LINEAR_DESIGN                                              */
/*    FT_LOAD_NO_SCALE                                                   */
/*    FT_LOAD_NO_HINTING                                                 */
/*    FT_LOAD_NO_BITMAP                                                  */
/*    FT_LOAD_CROP_BITMAP                                                */
/*                                                                       */
/*    FT_LOAD_VERTICAL_LAYOUT                                            */
/*    FT_LOAD_IGNORE_TRANSFORM                                           */
/*    FT_LOAD_IGNORE_GLOBAL_ADVANCE_WIDTH                                */
/*    FT_LOAD_FORCE_AUTOHINT                                             */
/*    FT_LOAD_NO_RECURSE                                                 */
/*    FT_LOAD_PEDANTIC                                                   */
/*                                                                       */
/*    FT_LOAD_TARGET_NORMAL                                              */
/*    FT_LOAD_TARGET_LIGHT                                               */
/*    FT_LOAD_TARGET_MONO                                                */
/*    FT_LOAD_TARGET_LCD                                                 */
/*    FT_LOAD_TARGET_LCD_V                                               */
/*                                                                       */
/*    FT_Render_Glyph                                                    */
/*    FT_Render_Mode                                                     */
/*    FT_Get_Kerning                                                     */
/*    FT_Kerning_Mode                                                    */
/*    FT_Get_Track_Kerning                                               */
/*    FT_Get_Glyph_Name                                                  */
/*    FT_Get_Postscript_Name                                             */
/*                                                                       */
/*    FT_CharMapRec                                                      */
/*    FT_Select_Charmap                                                  */
/*    FT_Set_Charmap                                                     */
/*    FT_Get_Charmap_Index                                               */
/*                                                                       */
/*    FT_FSTYPE_INSTALLABLE_EMBEDDING                                    */
/*    FT_FSTYPE_RESTRICTED_LICENSE_EMBEDDING                             */
/*    FT_FSTYPE_PREVIEW_AND_PRINT_EMBEDDING                              */
/*    FT_FSTYPE_EDITABLE_EMBEDDING                                       */
/*    FT_FSTYPE_NO_SUBSETTING                                            */
/*    FT_FSTYPE_BITMAP_EMBEDDING_ONLY                                    */
/*                                                                       */
/*    FT_Get_FSType_Flags                                                */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Glyph_Metrics                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to model the metrics of a single glyph.  The      */
/*    values are expressed in 26.6 fractional pixel format; if the flag  */
/*    @FT_LOAD_NO_SCALE has been used while loading the glyph, values    */
/*    are expressed in font units instead.                               */
/*                                                                       */
/* <Fields>                                                              */
/*    width ::                                                           */
/*      The glyph's width.                                               */
/*                                                                       */
/*    height ::                                                          */
/*      The glyph's height.                                              */
/*                                                                       */
/*    horiBearingX ::                                                    */
/*      Left side bearing for horizontal layout.                         */
/*                                                                       */
/*    horiBearingY ::                                                    */
/*      Top side bearing for horizontal layout.                          */
/*                                                                       */
/*    horiAdvance ::                                                     */
/*      Advance width for horizontal layout.                             */
/*                                                                       */
/*    vertBearingX ::                                                    */
/*      Left side bearing for vertical layout.                           */
/*                                                                       */
/*    vertBearingY ::                                                    */
/*      Top side bearing for vertical layout.  Larger positive values    */
/*      mean further below the vertical glyph origin.                    */
/*                                                                       */
/*    vertAdvance ::                                                     */
/*      Advance height for vertical layout.  Positive values mean the    */
/*      glyph has a positive advance downward.                           */
/*                                                                       */
/* <Note>                                                                */
/*    If not disabled with @FT_LOAD_NO_HINTING, the values represent     */
/*    dimensions of the hinted glyph (in case hinting is applicable).    */
/*                                                                       */
/*    Stroking a glyph with an outside border does not increase          */
/*    `horiAdvance' or `vertAdvance'; you have to manually adjust these  */
/*    values to account for the added width and height.                  */
/*                                                                       */
  typedef struct  FT_Glyph_Metrics_
  {
    FT_Pos  width;
    FT_Pos  height;
    FT_Pos  horiBearingX;
    FT_Pos  horiBearingY;
    FT_Pos  horiAdvance;
    FT_Pos  vertBearingX;
    FT_Pos  vertBearingY;
    FT_Pos  vertAdvance;
  } FT_Glyph_Metrics;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Bitmap_Size                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    This structure models the metrics of a bitmap strike (i.e., a set  */
/*    of glyphs for a given point size and resolution) in a bitmap font. */
/*    It is used for the `available_sizes' field of @FT_Face.            */
/*                                                                       */
/* <Fields>                                                              */
/*    height :: The vertical distance, in pixels, between two            */
/*              consecutive baselines.  It is always positive.           */
/*                                                                       */
/*    width  :: The average width, in pixels, of all glyphs in the       */
/*              strike.                                                  */
/*                                                                       */
/*    size   :: The nominal size of the strike in 26.6 fractional        */
/*              points.  This field is not very useful.                  */
/*                                                                       */
/*    x_ppem :: The horizontal ppem (nominal width) in 26.6 fractional   */
/*              pixels.                                                  */
/*                                                                       */
/*    y_ppem :: The vertical ppem (nominal height) in 26.6 fractional    */
/*              pixels.                                                  */
/*                                                                       */
/* <Note>                                                                */
/*    Windows FNT:                                                       */
/*      The nominal size given in a FNT font is not reliable.  Thus when */
/*      the driver finds it incorrect, it sets `size' to some calculated */
/*      values and sets `x_ppem' and `y_ppem' to the pixel width and     */
/*      height given in the font, respectively.                          */
/*                                                                       */
/*    TrueType embedded bitmaps:                                         */
/*      `size', `width', and `height' values are not contained in the    */
/*      bitmap strike itself.  They are computed from the global font    */
/*      parameters.                                                      */
/*                                                                       */
  typedef struct  FT_Bitmap_Size_
  {
    FT_Short  height;
    FT_Short  width;
    FT_Pos    size;
    FT_Pos    x_ppem;
    FT_Pos    y_ppem;
  } FT_Bitmap_Size;
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/*                     O B J E C T   C L A S S E S                       */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Library                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a FreeType library instance.  Each `library' is        */
/*    completely independent from the others; it is the `root' of a set  */
/*    of objects like fonts, faces, sizes, etc.                          */
/*                                                                       */
/*    It also embeds a memory manager (see @FT_Memory), as well as a     */
/*    scan-line converter object (see @FT_Raster).                       */
/*                                                                       */
/*    For multi-threading applications each thread should have its own   */
/*    FT_Library object.                                                 */
/*                                                                       */
/* <Note>                                                                */
/*    Library objects are normally created by @FT_Init_FreeType, and     */
/*    destroyed with @FT_Done_FreeType.                                  */
/*                                                                       */
  typedef struct FT_LibraryRec_  *FT_Library;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Module                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a given FreeType module object.  Each module can be a  */
/*    font driver, a renderer, or anything else that provides services   */
/*    to the formers.                                                    */
/*                                                                       */
  typedef struct FT_ModuleRec_*  FT_Module;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Driver                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a given FreeType font driver object.  Each font driver */
/*    is a special module capable of creating faces from font files.     */
/*                                                                       */
  typedef struct FT_DriverRec_*  FT_Driver;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Renderer                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a given FreeType renderer.  A renderer is a special    */
/*    module in charge of converting a glyph image to a bitmap, when     */
/*    necessary.  Each renderer supports a given glyph image format, and */
/*    one or more target surface depths.                                 */
/*                                                                       */
  typedef struct FT_RendererRec_*  FT_Renderer;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Face                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a given typographic face object.  A face object models */
/*    a given typeface, in a given style.                                */
/*                                                                       */
/* <Note>                                                                */
/*    Each face object also owns a single @FT_GlyphSlot object, as well  */
/*    as one or more @FT_Size objects.                                   */
/*                                                                       */
/*    Use @FT_New_Face or @FT_Open_Face to create a new face object from */
/*    a given filepathname or a custom input stream.                     */
/*                                                                       */
/*    Use @FT_Done_Face to destroy it (along with its slot and sizes).   */
/*                                                                       */
/* <Also>                                                                */
/*    See @FT_FaceRec for the publicly accessible fields of a given face */
/*    object.                                                            */
/*                                                                       */
  typedef struct FT_FaceRec_*  FT_Face;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Size                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to an object used to model a face scaled to a given       */
/*    character size.                                                    */
/*                                                                       */
/* <Note>                                                                */
/*    Each @FT_Face has an _active_ @FT_Size object that is used by      */
/*    functions like @FT_Load_Glyph to determine the scaling             */
/*    transformation which is used to load and hint glyphs and metrics.  */
/*                                                                       */
/*    You can use @FT_Set_Char_Size, @FT_Set_Pixel_Sizes,                */
/*    @FT_Request_Size or even @FT_Select_Size to change the content     */
/*    (i.e., the scaling values) of the active @FT_Size.                 */
/*                                                                       */
/*    You can use @FT_New_Size to create additional size objects for a   */
/*    given @FT_Face, but they won't be used by other functions until    */
/*    you activate it through @FT_Activate_Size.  Only one size can be   */
/*    activated at any given time per face.                              */
/*                                                                       */
/* <Also>                                                                */
/*    See @FT_SizeRec for the publicly accessible fields of a given size */
/*    object.                                                            */
/*                                                                       */
  typedef struct FT_SizeRec_*  FT_Size;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_GlyphSlot                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a given `glyph slot'.  A slot is a container where it  */
/*    is possible to load any of the glyphs contained in its parent      */
/*    face.                                                              */
/*                                                                       */
/*    In other words, each time you call @FT_Load_Glyph or               */
/*    @FT_Load_Char, the slot's content is erased by the new glyph data, */
/*    i.e., the glyph's metrics, its image (bitmap or outline), and      */
/*    other control information.                                         */
/*                                                                       */
/* <Also>                                                                */
/*    See @FT_GlyphSlotRec for the publicly accessible glyph fields.     */
/*                                                                       */
  typedef struct FT_GlyphSlotRec_*  FT_GlyphSlot;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_CharMap                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a given character map.  A charmap is used to translate */
/*    character codes in a given encoding into glyph indexes for its     */
/*    parent's face.  Some font formats may provide several charmaps per */
/*    font.                                                              */
/*                                                                       */
/*    Each face object owns zero or more charmaps, but only one of them  */
/*    can be `active' and used by @FT_Get_Char_Index or @FT_Load_Char.   */
/*                                                                       */
/*    The list of available charmaps in a face is available through the  */
/*    `face->num_charmaps' and `face->charmaps' fields of @FT_FaceRec.   */
/*                                                                       */
/*    The currently active charmap is available as `face->charmap'.      */
/*    You should call @FT_Set_Charmap to change it.                      */
/*                                                                       */
/* <Note>                                                                */
/*    When a new face is created (either through @FT_New_Face or         */
/*    @FT_Open_Face), the library looks for a Unicode charmap within     */
/*    the list and automatically activates it.                           */
/*                                                                       */
/* <Also>                                                                */
/*    See @FT_CharMapRec for the publicly accessible fields of a given   */
/*    character map.                                                     */
/*                                                                       */
  typedef struct FT_CharMapRec_*  FT_CharMap;
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_ENC_TAG                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    This macro converts four-letter tags into an unsigned long.  It is */
/*    used to define `encoding' identifiers (see @FT_Encoding).          */
/*                                                                       */
/* <Note>                                                                */
/*    Since many 16-bit compilers don't like 32-bit enumerations, you    */
/*    should redefine this macro in case of problems to something like   */
/*    this:                                                              */
/*                                                                       */
/*    {                                                                  */
/*      #define FT_ENC_TAG( value, a, b, c, d )  value                   */
/*    }                                                                  */
/*                                                                       */
/*    to get a simple enumeration without assigning special numbers.     */
/*                                                                       */
#ifndef FT_ENC_TAG
#define FT_ENC_TAG( value, a, b, c, d )         \
          value = ( ( (FT_UInt32)(a) << 24 ) |  \
                    ( (FT_UInt32)(b) << 16 ) |  \
                    ( (FT_UInt32)(c) <<  8 ) |  \
                      (FT_UInt32)(d)         )
/* FT_ENC_TAG */
#endif  
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_Encoding                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    An enumeration used to specify character sets supported by         */
/*    charmaps.  Used in the @FT_Select_Charmap API function.            */
/*                                                                       */
/* <Note>                                                                */
/*    Despite the name, this enumeration lists specific character        */
/*    repertories (i.e., charsets), and not text encoding methods (e.g., */
/*    UTF-8, UTF-16, etc.).                                              */
/*                                                                       */
/*    Other encodings might be defined in the future.                    */
/*                                                                       */
/* <Values>                                                              */
/*    FT_ENCODING_NONE ::                                                */
/*      The encoding value~0 is reserved.                                */
/*                                                                       */
/*    FT_ENCODING_UNICODE ::                                             */
/*      Corresponds to the Unicode character set.  This value covers     */
/*      all versions of the Unicode repertoire, including ASCII and      */
/*      Latin-1.  Most fonts include a Unicode charmap, but not all      */
/*      of them.                                                         */
/*                                                                       */
/*      For example, if you want to access Unicode value U+1F028 (and    */
/*      the font contains it), use value 0x1F028 as the input value for  */
/*      @FT_Get_Char_Index.                                              */
/*                                                                       */
/*    FT_ENCODING_MS_SYMBOL ::                                           */
/*      Corresponds to the Microsoft Symbol encoding, used to encode     */
/*      mathematical symbols in the 32..255 character code range.  For   */
/*      more information, see `http://www.ceviz.net/symbol.htm'.         */
/*                                                                       */
/*    FT_ENCODING_SJIS ::                                                */
/*      Corresponds to Japanese SJIS encoding.  More info at             */
/*      at `http://langsupport.japanreference.com/encoding.shtml'.       */
/*      See note on multi-byte encodings below.                          */
/*                                                                       */
/*    FT_ENCODING_GB2312 ::                                              */
/*      Corresponds to an encoding system for Simplified Chinese as used */
/*      used in mainland China.                                          */
/*                                                                       */
/*    FT_ENCODING_BIG5 ::                                                */
/*      Corresponds to an encoding system for Traditional Chinese as     */
/*      used in Taiwan and Hong Kong.                                    */
/*                                                                       */
/*    FT_ENCODING_WANSUNG ::                                             */
/*      Corresponds to the Korean encoding system known as Wansung.      */
/*      For more information see                                         */
/*      `http://www.microsoft.com/typography/unicode/949.txt'.           */
/*                                                                       */
/*    FT_ENCODING_JOHAB ::                                               */
/*      The Korean standard character set (KS~C 5601-1992), which        */
/*      corresponds to MS Windows code page 1361.  This character set    */
/*      includes all possible Hangeul character combinations.            */
/*                                                                       */
/*    FT_ENCODING_ADOBE_LATIN_1 ::                                       */
/*      Corresponds to a Latin-1 encoding as defined in a Type~1         */
/*      PostScript font.  It is limited to 256 character codes.          */
/*                                                                       */
/*    FT_ENCODING_ADOBE_STANDARD ::                                      */
/*      Corresponds to the Adobe Standard encoding, as found in Type~1,  */
/*      CFF, and OpenType/CFF fonts.  It is limited to 256 character     */
/*      codes.                                                           */
/*                                                                       */
/*    FT_ENCODING_ADOBE_EXPERT ::                                        */
/*      Corresponds to the Adobe Expert encoding, as found in Type~1,    */
/*      CFF, and OpenType/CFF fonts.  It is limited to 256 character     */
/*      codes.                                                           */
/*                                                                       */
/*    FT_ENCODING_ADOBE_CUSTOM ::                                        */
/*      Corresponds to a custom encoding, as found in Type~1, CFF, and   */
/*      OpenType/CFF fonts.  It is limited to 256 character codes.       */
/*                                                                       */
/*    FT_ENCODING_APPLE_ROMAN ::                                         */
/*      Corresponds to the 8-bit Apple roman encoding.  Many TrueType    */
/*      and OpenType fonts contain a charmap for this encoding, since    */
/*      older versions of Mac OS are able to use it.                     */
/*                                                                       */
/*    FT_ENCODING_OLD_LATIN_2 ::                                         */
/*      This value is deprecated and was never used nor reported by      */
/*      FreeType.  Don't use or test for it.                             */
/*                                                                       */
/*    FT_ENCODING_MS_SJIS ::                                             */
/*      Same as FT_ENCODING_SJIS.  Deprecated.                           */
/*                                                                       */
/*    FT_ENCODING_MS_GB2312 ::                                           */
/*      Same as FT_ENCODING_GB2312.  Deprecated.                         */
/*                                                                       */
/*    FT_ENCODING_MS_BIG5 ::                                             */
/*      Same as FT_ENCODING_BIG5.  Deprecated.                           */
/*                                                                       */
/*    FT_ENCODING_MS_WANSUNG ::                                          */
/*      Same as FT_ENCODING_WANSUNG.  Deprecated.                        */
/*                                                                       */
/*    FT_ENCODING_MS_JOHAB ::                                            */
/*      Same as FT_ENCODING_JOHAB.  Deprecated.                          */
/*                                                                       */
/* <Note>                                                                */
/*    By default, FreeType automatically synthesizes a Unicode charmap   */
/*    for PostScript fonts, using their glyph names dictionaries.        */
/*    However, it also reports the encodings defined explicitly in the   */
/*    font file, for the cases when they are needed, with the Adobe      */
/*    values as well.                                                    */
/*                                                                       */
/*    FT_ENCODING_NONE is set by the BDF and PCF drivers if the charmap  */
/*    is neither Unicode nor ISO-8859-1 (otherwise it is set to          */
/*    FT_ENCODING_UNICODE).  Use @FT_Get_BDF_Charset_ID to find out      */
/*    which encoding is really present.  If, for example, the            */
/*    `cs_registry' field is `KOI8' and the `cs_encoding' field is `R',  */
/*    the font is encoded in KOI8-R.                                     */
/*                                                                       */
/*    FT_ENCODING_NONE is always set (with a single exception) by the    */
/*    winfonts driver.  Use @FT_Get_WinFNT_Header and examine the        */
/*    `charset' field of the @FT_WinFNT_HeaderRec structure to find out  */
/*    which encoding is really present.  For example,                    */
/*    @FT_WinFNT_ID_CP1251 (204) means Windows code page 1251 (for       */
/*    Russian).                                                          */
/*                                                                       */
/*    FT_ENCODING_NONE is set if `platform_id' is @TT_PLATFORM_MACINTOSH */
/*    and `encoding_id' is not @TT_MAC_ID_ROMAN (otherwise it is set to  */
/*    FT_ENCODING_APPLE_ROMAN).                                          */
/*                                                                       */
/*    If `platform_id' is @TT_PLATFORM_MACINTOSH, use the function       */
/*    @FT_Get_CMap_Language_ID  to query the Mac language ID which may   */
/*    be needed to be able to distinguish Apple encoding variants.  See  */
/*                                                                       */
/*      http://www.unicode.org/Public/MAPPINGS/VENDORS/APPLE/README.TXT  */
/*                                                                       */
/*    to get an idea how to do that.  Basically, if the language ID      */
/*    is~0, don't use it, otherwise subtract 1 from the language ID.     */
/*    Then examine `encoding_id'.  If, for example, `encoding_id' is     */
/*    @TT_MAC_ID_ROMAN and the language ID (minus~1) is                  */
/*    `TT_MAC_LANGID_GREEK', it is the Greek encoding, not Roman.        */
/*    @TT_MAC_ID_ARABIC with `TT_MAC_LANGID_FARSI' means the Farsi       */
/*    variant the Arabic encoding.                                       */
/*                                                                       */
  typedef enum  FT_Encoding_
  {
    FT_ENC_TAG( FT_ENCODING_NONE, 0, 0, 0, 0 ),
    FT_ENC_TAG( FT_ENCODING_MS_SYMBOL, 's', 'y', 'm', 'b' ),
    FT_ENC_TAG( FT_ENCODING_UNICODE,   'u', 'n', 'i', 'c' ),
    FT_ENC_TAG( FT_ENCODING_SJIS,    's', 'j', 'i', 's' ),
    FT_ENC_TAG( FT_ENCODING_GB2312,  'g', 'b', ' ', ' ' ),
    FT_ENC_TAG( FT_ENCODING_BIG5,    'b', 'i', 'g', '5' ),
    FT_ENC_TAG( FT_ENCODING_WANSUNG, 'w', 'a', 'n', 's' ),
    FT_ENC_TAG( FT_ENCODING_JOHAB,   'j', 'o', 'h', 'a' ),
/* for backwards compatibility */
    FT_ENCODING_MS_SJIS    = FT_ENCODING_SJIS,
    FT_ENCODING_MS_GB2312  = FT_ENCODING_GB2312,
    FT_ENCODING_MS_BIG5    = FT_ENCODING_BIG5,
    FT_ENCODING_MS_WANSUNG = FT_ENCODING_WANSUNG,
    FT_ENCODING_MS_JOHAB   = FT_ENCODING_JOHAB,
    FT_ENC_TAG( FT_ENCODING_ADOBE_STANDARD, 'A', 'D', 'O', 'B' ),
    FT_ENC_TAG( FT_ENCODING_ADOBE_EXPERT,   'A', 'D', 'B', 'E' ),
    FT_ENC_TAG( FT_ENCODING_ADOBE_CUSTOM,   'A', 'D', 'B', 'C' ),
    FT_ENC_TAG( FT_ENCODING_ADOBE_LATIN_1,  'l', 'a', 't', '1' ),
    FT_ENC_TAG( FT_ENCODING_OLD_LATIN_2, 'l', 'a', 't', '2' ),
    FT_ENC_TAG( FT_ENCODING_APPLE_ROMAN, 'a', 'r', 'm', 'n' )
  } FT_Encoding;
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    ft_encoding_xxx                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    These constants are deprecated; use the corresponding @FT_Encoding */
/*    values instead.                                                    */
/*                                                                       */
#define ft_encoding_none            FT_ENCODING_NONE
#define ft_encoding_unicode         FT_ENCODING_UNICODE
#define ft_encoding_symbol          FT_ENCODING_MS_SYMBOL
#define ft_encoding_latin_1         FT_ENCODING_ADOBE_LATIN_1
#define ft_encoding_latin_2         FT_ENCODING_OLD_LATIN_2
#define ft_encoding_sjis            FT_ENCODING_SJIS
#define ft_encoding_gb2312          FT_ENCODING_GB2312
#define ft_encoding_big5            FT_ENCODING_BIG5
#define ft_encoding_wansung         FT_ENCODING_WANSUNG
#define ft_encoding_johab           FT_ENCODING_JOHAB
#define ft_encoding_adobe_standard  FT_ENCODING_ADOBE_STANDARD
#define ft_encoding_adobe_expert    FT_ENCODING_ADOBE_EXPERT
#define ft_encoding_adobe_custom    FT_ENCODING_ADOBE_CUSTOM
#define ft_encoding_apple_roman     FT_ENCODING_APPLE_ROMAN
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_CharMapRec                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    The base charmap structure.                                        */
/*                                                                       */
/* <Fields>                                                              */
/*    face        :: A handle to the parent face object.                 */
/*                                                                       */
/*    encoding    :: An @FT_Encoding tag identifying the charmap.  Use   */
/*                   this with @FT_Select_Charmap.                       */
/*                                                                       */
/*    platform_id :: An ID number describing the platform for the        */
/*                   following encoding ID.  This comes directly from    */
/*                   the TrueType specification and should be emulated   */
/*                   for other formats.                                  */
/*                                                                       */
/*    encoding_id :: A platform specific encoding number.  This also     */
/*                   comes from the TrueType specification and should be */
/*                   emulated similarly.                                 */
/*                                                                       */
  typedef struct  FT_CharMapRec_
  {
    FT_Face      face;
    FT_Encoding  encoding;
    FT_UShort    platform_id;
    FT_UShort    encoding_id;
  } FT_CharMapRec;
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/*                 B A S E   O B J E C T   C L A S S E S                 */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Face_Internal                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    An opaque handle to an `FT_Face_InternalRec' structure, used to    */
/*    model private data of a given @FT_Face object.                     */
/*                                                                       */
/*    This structure might change between releases of FreeType~2 and is  */
/*    not generally available to client applications.                    */
/*                                                                       */
  typedef struct FT_Face_InternalRec_*  FT_Face_Internal;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_FaceRec                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    FreeType root face class structure.  A face object models a        */
/*    typeface in a font file.                                           */
/*                                                                       */
/* <Fields>                                                              */
/*    num_faces           :: The number of faces in the font file.  Some */
/*                           font formats can have multiple faces in     */
/*                           a font file.                                */
/*                                                                       */
/*    face_index          :: The index of the face in the font file.  It */
/*                           is set to~0 if there is only one face in    */
/*                           the font file.                              */
/*                                                                       */
/*    face_flags          :: A set of bit flags that give important      */
/*                           information about the face; see             */
/*                           @FT_FACE_FLAG_XXX for the details.          */
/*                                                                       */
/*    style_flags         :: A set of bit flags indicating the style of  */
/*                           the face; see @FT_STYLE_FLAG_XXX for the    */
/*                           details.                                    */
/*                                                                       */
/*    num_glyphs          :: The number of glyphs in the face.  If the   */
/*                           face is scalable and has sbits (see         */
/*                           `num_fixed_sizes'), it is set to the number */
/*                           of outline glyphs.                          */
/*                                                                       */
/*                           For CID-keyed fonts, this value gives the   */
/*                           highest CID used in the font.               */
/*                                                                       */
/*    family_name         :: The face's family name.  This is an ASCII   */
/*                           string, usually in English, which describes */
/*                           the typeface's family (like `Times New      */
/*                           Roman', `Bodoni', `Garamond', etc).  This   */
/*                           is a least common denominator used to list  */
/*                           fonts.  Some formats (TrueType & OpenType)  */
/*                           provide localized and Unicode versions of   */
/*                           this string.  Applications should use the   */
/*                           format specific interface to access them.   */
/*                           Can be NULL (e.g., in fonts embedded in a   */
/*                           PDF file).                                  */
/*                                                                       */
/*    style_name          :: The face's style name.  This is an ASCII    */
/*                           string, usually in English, which describes */
/*                           the typeface's style (like `Italic',        */
/*                           `Bold', `Condensed', etc).  Not all font    */
/*                           formats provide a style name, so this field */
/*                           is optional, and can be set to NULL.  As    */
/*                           for `family_name', some formats provide     */
/*                           localized and Unicode versions of this      */
/*                           string.  Applications should use the format */
/*                           specific interface to access them.          */
/*                                                                       */
/*    num_fixed_sizes     :: The number of bitmap strikes in the face.   */
/*                           Even if the face is scalable, there might   */
/*                           still be bitmap strikes, which are called   */
/*                           `sbits' in that case.                       */
/*                                                                       */
/*    available_sizes     :: An array of @FT_Bitmap_Size for all bitmap  */
/*                           strikes in the face.  It is set to NULL if  */
/*                           there is no bitmap strike.                  */
/*                                                                       */
/*    num_charmaps        :: The number of charmaps in the face.         */
/*                                                                       */
/*    charmaps            :: An array of the charmaps of the face.       */
/*                                                                       */
/*    generic             :: A field reserved for client uses.  See the  */
/*                           @FT_Generic type description.               */
/*                                                                       */
/*    bbox                :: The font bounding box.  Coordinates are     */
/*                           expressed in font units (see                */
/*                           `units_per_EM').  The box is large enough   */
/*                           to contain any glyph from the font.  Thus,  */
/*                           `bbox.yMax' can be seen as the `maximum     */
/*                           ascender', and `bbox.yMin' as the `minimum  */
/*                           descender'.  Only relevant for scalable     */
/*                           formats.                                    */
/*                                                                       */
/*                           Note that the bounding box might be off by  */
/*                           (at least) one pixel for hinted fonts.  See */
/*                           @FT_Size_Metrics for further discussion.    */
/*                                                                       */
/*    units_per_EM        :: The number of font units per EM square for  */
/*                           this face.  This is typically 2048 for      */
/*                           TrueType fonts, and 1000 for Type~1 fonts.  */
/*                           Only relevant for scalable formats.         */
/*                                                                       */
/*    ascender            :: The typographic ascender of the face,       */
/*                           expressed in font units.  For font formats  */
/*                           not having this information, it is set to   */
/*                           `bbox.yMax'.  Only relevant for scalable    */
/*                           formats.                                    */
/*                                                                       */
/*    descender           :: The typographic descender of the face,      */
/*                           expressed in font units.  For font formats  */
/*                           not having this information, it is set to   */
/*                           `bbox.yMin'.  Note that this field is       */
/*                           usually negative.  Only relevant for        */
/*                           scalable formats.                           */
/*                                                                       */
/*    height              :: The height is the vertical distance         */
/*                           between two consecutive baselines,          */
/*                           expressed in font units.  It is always      */
/*                           positive.  Only relevant for scalable       */
/*                           formats.                                    */
/*                                                                       */
/*    max_advance_width   :: The maximum advance width, in font units,   */
/*                           for all glyphs in this face.  This can be   */
/*                           used to make word wrapping computations     */
/*                           faster.  Only relevant for scalable         */
/*                           formats.                                    */
/*                                                                       */
/*    max_advance_height  :: The maximum advance height, in font units,  */
/*                           for all glyphs in this face.  This is only  */
/*                           relevant for vertical layouts, and is set   */
/*                           to `height' for fonts that do not provide   */
/*                           vertical metrics.  Only relevant for        */
/*                           scalable formats.                           */
/*                                                                       */
/*    underline_position  :: The position, in font units, of the         */
/*                           underline line for this face.  It is the    */
/*                           center of the underlining stem.  Only       */
/*                           relevant for scalable formats.              */
/*                                                                       */
/*    underline_thickness :: The thickness, in font units, of the        */
/*                           underline for this face.  Only relevant for */
/*                           scalable formats.                           */
/*                                                                       */
/*    glyph               :: The face's associated glyph slot(s).        */
/*                                                                       */
/*    size                :: The current active size for this face.      */
/*                                                                       */
/*    charmap             :: The current active charmap for this face.   */
/*                                                                       */
/* <Note>                                                                */
/*    Fields may be changed after a call to @FT_Attach_File or           */
/*    @FT_Attach_Stream.                                                 */
/*                                                                       */
  typedef struct  FT_FaceRec_
  {
    FT_Long           num_faces;
    FT_Long           face_index;
    FT_Long           face_flags;
    FT_Long           style_flags;
    FT_Long           num_glyphs;
    FT_String*        family_name;
    FT_String*        style_name;
    FT_Int            num_fixed_sizes;
    FT_Bitmap_Size*   available_sizes;
    FT_Int            num_charmaps;
    FT_CharMap*       charmaps;
    FT_Generic        generic;
/*# The following member variables (down to `underline_thickness') */
/*# are only relevant to scalable outlines; cf. @FT_Bitmap_Size    */
/*# for bitmap fonts.                                              */
    FT_BBox           bbox;
    FT_UShort         units_per_EM;
    FT_Short          ascender;
    FT_Short          descender;
    FT_Short          height;
    FT_Short          max_advance_width;
    FT_Short          max_advance_height;
    FT_Short          underline_position;
    FT_Short          underline_thickness;
    FT_GlyphSlot      glyph;
    FT_Size           size;
    FT_CharMap        charmap;
/*@private begin */
    FT_Driver         driver;
    FT_Memory         memory;
    FT_Stream         stream;
    FT_ListRec        sizes_list;
/* face-specific auto-hinter data */
    FT_Generic        autohint;    
/* unused                         */
    void*             extensions;  
    FT_Face_Internal  internal;
/*@private end */
  } FT_FaceRec;
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_FACE_FLAG_XXX                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    A list of bit flags used in the `face_flags' field of the          */
/*    @FT_FaceRec structure.  They inform client applications of         */
/*    properties of the corresponding face.                              */
/*                                                                       */
/* <Values>                                                              */
/*    FT_FACE_FLAG_SCALABLE ::                                           */
/*      Indicates that the face contains outline glyphs.  This doesn't   */
/*      prevent bitmap strikes, i.e., a face can have both this and      */
/*      and @FT_FACE_FLAG_FIXED_SIZES set.                               */
/*                                                                       */
/*    FT_FACE_FLAG_FIXED_SIZES ::                                        */
/*      Indicates that the face contains bitmap strikes.  See also the   */
/*      `num_fixed_sizes' and `available_sizes' fields of @FT_FaceRec.   */
/*                                                                       */
/*    FT_FACE_FLAG_FIXED_WIDTH ::                                        */
/*      Indicates that the face contains fixed-width characters (like    */
/*      Courier, Lucido, MonoType, etc.).                                */
/*                                                                       */
/*    FT_FACE_FLAG_SFNT ::                                               */
/*      Indicates that the face uses the `sfnt' storage scheme.  For     */
/*      now, this means TrueType and OpenType.                           */
/*                                                                       */
/*    FT_FACE_FLAG_HORIZONTAL ::                                         */
/*      Indicates that the face contains horizontal glyph metrics.  This */
/*      should be set for all common formats.                            */
/*                                                                       */
/*    FT_FACE_FLAG_VERTICAL ::                                           */
/*      Indicates that the face contains vertical glyph metrics.  This   */
/*      is only available in some formats, not all of them.              */
/*                                                                       */
/*    FT_FACE_FLAG_KERNING ::                                            */
/*      Indicates that the face contains kerning information.  If set,   */
/*      the kerning distance can be retrieved through the function       */
/*      @FT_Get_Kerning.  Otherwise the function always return the       */
/*      vector (0,0).  Note that FreeType doesn't handle kerning data    */
/*      from the `GPOS' table (as present in some OpenType fonts).       */
/*                                                                       */
/*    FT_FACE_FLAG_FAST_GLYPHS ::                                        */
/*      THIS FLAG IS DEPRECATED.  DO NOT USE OR TEST IT.                 */
/*                                                                       */
/*    FT_FACE_FLAG_MULTIPLE_MASTERS ::                                   */
/*      Indicates that the font contains multiple masters and is capable */
/*      of interpolating between them.  See the multiple-masters         */
/*      specific API for details.                                        */
/*                                                                       */
/*    FT_FACE_FLAG_GLYPH_NAMES ::                                        */
/*      Indicates that the font contains glyph names that can be         */
/*      retrieved through @FT_Get_Glyph_Name.  Note that some TrueType   */
/*      fonts contain broken glyph name tables.  Use the function        */
/*      @FT_Has_PS_Glyph_Names when needed.                              */
/*                                                                       */
/*    FT_FACE_FLAG_EXTERNAL_STREAM ::                                    */
/*      Used internally by FreeType to indicate that a face's stream was */
/*      provided by the client application and should not be destroyed   */
/*      when @FT_Done_Face is called.  Don't read or test this flag.     */
/*                                                                       */
/*    FT_FACE_FLAG_HINTER ::                                             */
/*      Set if the font driver has a hinting machine of its own.  For    */
/*      example, with TrueType fonts, it makes sense to use data from    */
/*      the SFNT `gasp' table only if the native TrueType hinting engine */
/*      (with the bytecode interpreter) is available and active.         */
/*                                                                       */
/*    FT_FACE_FLAG_CID_KEYED ::                                          */
/*      Set if the font is CID-keyed.  In that case, the font is not     */
/*      accessed by glyph indices but by CID values.  For subsetted      */
/*      CID-keyed fonts this has the consequence that not all index      */
/*      values are a valid argument to FT_Load_Glyph.  Only the CID      */
/*      values for which corresponding glyphs in the subsetted font      */
/*      exist make FT_Load_Glyph return successfully; in all other cases */
/*      you get an `FT_Err_Invalid_Argument' error.                      */
/*                                                                       */
/*      Note that CID-keyed fonts which are in an SFNT wrapper don't     */
/*      have this flag set since the glyphs are accessed in the normal   */
/*      way (using contiguous indices); the `CID-ness' isn't visible to  */
/*      the application.                                                 */
/*                                                                       */
/*    FT_FACE_FLAG_TRICKY ::                                             */
/*      Set if the font is `tricky', this is, it always needs the        */
/*      font format's native hinting engine to get a reasonable result.  */
/*      A typical example is the Chinese font `mingli.ttf' which uses    */
/*      TrueType bytecode instructions to move and scale all of its      */
/*      subglyphs.                                                       */
/*                                                                       */
/*      It is not possible to autohint such fonts using                  */
/*      @FT_LOAD_FORCE_AUTOHINT; it will also ignore                     */
/*      @FT_LOAD_NO_HINTING.  You have to set both @FT_LOAD_NO_HINTING   */
/*      and @FT_LOAD_NO_AUTOHINT to really disable hinting; however, you */
/*      probably never want this except for demonstration purposes.      */
/*                                                                       */
/*      Currently, there are about a dozen TrueType fonts in the list of */
/*      tricky fonts; they are hard-coded in file `ttobjs.c'.            */
/*                                                                       */
#define FT_FACE_FLAG_SCALABLE          ( 1L <<  0 )
#define FT_FACE_FLAG_FIXED_SIZES       ( 1L <<  1 )
#define FT_FACE_FLAG_FIXED_WIDTH       ( 1L <<  2 )
#define FT_FACE_FLAG_SFNT              ( 1L <<  3 )
#define FT_FACE_FLAG_HORIZONTAL        ( 1L <<  4 )
#define FT_FACE_FLAG_VERTICAL          ( 1L <<  5 )
#define FT_FACE_FLAG_KERNING           ( 1L <<  6 )
#define FT_FACE_FLAG_FAST_GLYPHS       ( 1L <<  7 )
#define FT_FACE_FLAG_MULTIPLE_MASTERS  ( 1L <<  8 )
#define FT_FACE_FLAG_GLYPH_NAMES       ( 1L <<  9 )
#define FT_FACE_FLAG_EXTERNAL_STREAM   ( 1L << 10 )
#define FT_FACE_FLAG_HINTER            ( 1L << 11 )
#define FT_FACE_FLAG_CID_KEYED         ( 1L << 12 )
#define FT_FACE_FLAG_TRICKY            ( 1L << 13 )
/*************************************************************************
   *
   * @macro:
   *   FT_HAS_HORIZONTAL( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains
   *   horizontal metrics (this is true for all font formats though).
   *
   * @also:
   *   @FT_HAS_VERTICAL can be used to check for vertical metrics.
   *
   */
#define FT_HAS_HORIZONTAL( face ) \
          ( face->face_flags & FT_FACE_FLAG_HORIZONTAL )
/*************************************************************************
   *
   * @macro:
   *   FT_HAS_VERTICAL( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains real
   *   vertical metrics (and not only synthesized ones).
   *
   */
#define FT_HAS_VERTICAL( face ) \
          ( face->face_flags & FT_FACE_FLAG_VERTICAL )
/*************************************************************************
   *
   * @macro:
   *   FT_HAS_KERNING( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains kerning
   *   data that can be accessed with @FT_Get_Kerning.
   *
   */
#define FT_HAS_KERNING( face ) \
          ( face->face_flags & FT_FACE_FLAG_KERNING )
/*************************************************************************
   *
   * @macro:
   *   FT_IS_SCALABLE( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains a scalable
   *   font face (true for TrueType, Type~1, Type~42, CID, OpenType/CFF,
   *   and PFR font formats.
   *
   */
#define FT_IS_SCALABLE( face ) \
          ( face->face_flags & FT_FACE_FLAG_SCALABLE )
/*************************************************************************
   *
   * @macro:
   *   FT_IS_SFNT( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains a font
   *   whose format is based on the SFNT storage scheme.  This usually
   *   means: TrueType fonts, OpenType fonts, as well as SFNT-based embedded
   *   bitmap fonts.
   *
   *   If this macro is true, all functions defined in @FT_SFNT_NAMES_H and
   *   @FT_TRUETYPE_TABLES_H are available.
   *
   */
#define FT_IS_SFNT( face ) \
          ( face->face_flags & FT_FACE_FLAG_SFNT )
/*************************************************************************
   *
   * @macro:
   *   FT_IS_FIXED_WIDTH( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains a font face
   *   that contains fixed-width (or `monospace', `fixed-pitch', etc.)
   *   glyphs.
   *
   */
#define FT_IS_FIXED_WIDTH( face ) \
          ( face->face_flags & FT_FACE_FLAG_FIXED_WIDTH )
/*************************************************************************
   *
   * @macro:
   *   FT_HAS_FIXED_SIZES( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains some
   *   embedded bitmaps.  See the `available_sizes' field of the
   *   @FT_FaceRec structure.
   *
   */
#define FT_HAS_FIXED_SIZES( face ) \
          ( face->face_flags & FT_FACE_FLAG_FIXED_SIZES )
/*************************************************************************
   *
   * @macro:
   *   FT_HAS_FAST_GLYPHS( face )
   *
   * @description:
   *   Deprecated.
   *
   */
#define FT_HAS_FAST_GLYPHS( face )  0
/*************************************************************************
   *
   * @macro:
   *   FT_HAS_GLYPH_NAMES( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains some glyph
   *   names that can be accessed through @FT_Get_Glyph_Name.
   *
   */
#define FT_HAS_GLYPH_NAMES( face ) \
          ( face->face_flags & FT_FACE_FLAG_GLYPH_NAMES )
/*************************************************************************
   *
   * @macro:
   *   FT_HAS_MULTIPLE_MASTERS( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains some
   *   multiple masters.  The functions provided by @FT_MULTIPLE_MASTERS_H
   *   are then available to choose the exact design you want.
   *
   */
#define FT_HAS_MULTIPLE_MASTERS( face ) \
          ( face->face_flags & FT_FACE_FLAG_MULTIPLE_MASTERS )
/*************************************************************************
   *
   * @macro:
   *   FT_IS_CID_KEYED( face )
   *
   * @description:
   *   A macro that returns true whenever a face object contains a CID-keyed
   *   font.  See the discussion of @FT_FACE_FLAG_CID_KEYED for more
   *   details.
   *
   *   If this macro is true, all functions defined in @FT_CID_H are
   *   available.
   *
   */
#define FT_IS_CID_KEYED( face ) \
          ( face->face_flags & FT_FACE_FLAG_CID_KEYED )
/*************************************************************************
   *
   * @macro:
   *   FT_IS_TRICKY( face )
   *
   * @description:
   *   A macro that returns true whenever a face represents a `tricky' font.
   *   See the discussion of @FT_FACE_FLAG_TRICKY for more details.
   *
   */
#define FT_IS_TRICKY( face ) \
          ( face->face_flags & FT_FACE_FLAG_TRICKY )
/*************************************************************************/
/*                                                                       */
/* <Const>                                                               */
/*    FT_STYLE_FLAG_XXX                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    A list of bit-flags used to indicate the style of a given face.    */
/*    These are used in the `style_flags' field of @FT_FaceRec.          */
/*                                                                       */
/* <Values>                                                              */
/*    FT_STYLE_FLAG_ITALIC ::                                            */
/*      Indicates that a given face style is italic or oblique.          */
/*                                                                       */
/*    FT_STYLE_FLAG_BOLD ::                                              */
/*      Indicates that a given face is bold.                             */
/*                                                                       */
/* <Note>                                                                */
/*    The style information as provided by FreeType is very basic.  More */
/*    details are beyond the scope and should be done on a higher level  */
/*    (for example, by analyzing various fields of the `OS/2' table in   */
/*    SFNT based fonts).                                                 */
/*                                                                       */
#define FT_STYLE_FLAG_ITALIC  ( 1 << 0 )
#define FT_STYLE_FLAG_BOLD    ( 1 << 1 )
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Size_Internal                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    An opaque handle to an `FT_Size_InternalRec' structure, used to    */
/*    model private data of a given @FT_Size object.                     */
/*                                                                       */
  typedef struct FT_Size_InternalRec_*  FT_Size_Internal;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Size_Metrics                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    The size metrics structure gives the metrics of a size object.     */
/*                                                                       */
/* <Fields>                                                              */
/*    x_ppem       :: The width of the scaled EM square in pixels, hence */
/*                    the term `ppem' (pixels per EM).  It is also       */
/*                    referred to as `nominal width'.                    */
/*                                                                       */
/*    y_ppem       :: The height of the scaled EM square in pixels,      */
/*                    hence the term `ppem' (pixels per EM).  It is also */
/*                    referred to as `nominal height'.                   */
/*                                                                       */
/*    x_scale      :: A 16.16 fractional scaling value used to convert   */
/*                    horizontal metrics from font units to 26.6         */
/*                    fractional pixels.  Only relevant for scalable     */
/*                    font formats.                                      */
/*                                                                       */
/*    y_scale      :: A 16.16 fractional scaling value used to convert   */
/*                    vertical metrics from font units to 26.6           */
/*                    fractional pixels.  Only relevant for scalable     */
/*                    font formats.                                      */
/*                                                                       */
/*    ascender     :: The ascender in 26.6 fractional pixels.  See       */
/*                    @FT_FaceRec for the details.                       */
/*                                                                       */
/*    descender    :: The descender in 26.6 fractional pixels.  See      */
/*                    @FT_FaceRec for the details.                       */
/*                                                                       */
/*    height       :: The height in 26.6 fractional pixels.  See         */
/*                    @FT_FaceRec for the details.                       */
/*                                                                       */
/*    max_advance  :: The maximum advance width in 26.6 fractional       */
/*                    pixels.  See @FT_FaceRec for the details.          */
/*                                                                       */
/* <Note>                                                                */
/*    The scaling values, if relevant, are determined first during a     */
/*    size changing operation.  The remaining fields are then set by the */
/*    driver.  For scalable formats, they are usually set to scaled      */
/*    values of the corresponding fields in @FT_FaceRec.                 */
/*                                                                       */
/*    Note that due to glyph hinting, these values might not be exact    */
/*    for certain fonts.  Thus they must be treated as unreliable        */
/*    with an error margin of at least one pixel!                        */
/*                                                                       */
/*    Indeed, the only way to get the exact metrics is to render _all_   */
/*    glyphs.  As this would be a definite performance hit, it is up to  */
/*    client applications to perform such computations.                  */
/*                                                                       */
/*    The FT_Size_Metrics structure is valid for bitmap fonts also.      */
/*                                                                       */
  typedef struct  FT_Size_Metrics_
  {
/* horizontal pixels per EM               */
    FT_UShort  x_ppem;       
/* vertical pixels per EM                 */
    FT_UShort  y_ppem;       
/* scaling values used to convert font    */
    FT_Fixed   x_scale;      
/* units to 26.6 fractional pixels        */
    FT_Fixed   y_scale;      
/* ascender in 26.6 frac. pixels          */
    FT_Pos     ascender;     
/* descender in 26.6 frac. pixels         */
    FT_Pos     descender;    
/* text height in 26.6 frac. pixels       */
    FT_Pos     height;       
/* max horizontal advance, in 26.6 pixels */
    FT_Pos     max_advance;  
  } FT_Size_Metrics;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_SizeRec                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    FreeType root size class structure.  A size object models a face   */
/*    object at a given size.                                            */
/*                                                                       */
/* <Fields>                                                              */
/*    face    :: Handle to the parent face object.                       */
/*                                                                       */
/*    generic :: A typeless pointer, which is unused by the FreeType     */
/*               library or any of its drivers.  It can be used by       */
/*               client applications to link their own data to each size */
/*               object.                                                 */
/*                                                                       */
/*    metrics :: Metrics for this size object.  This field is read-only. */
/*                                                                       */
  typedef struct  FT_SizeRec_
  {
/* parent face object              */
    FT_Face           face;       
/* generic pointer for client uses */
    FT_Generic        generic;    
/* size metrics                    */
    FT_Size_Metrics   metrics;    
    FT_Size_Internal  internal;
  } FT_SizeRec;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_SubGlyph                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    The subglyph structure is an internal object used to describe      */
/*    subglyphs (for example, in the case of composites).                */
/*                                                                       */
/* <Note>                                                                */
/*    The subglyph implementation is not part of the high-level API,     */
/*    hence the forward structure declaration.                           */
/*                                                                       */
/*    You can however retrieve subglyph information with                 */
/*    @FT_Get_SubGlyph_Info.                                             */
/*                                                                       */
  typedef struct FT_SubGlyphRec_*  FT_SubGlyph;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Slot_Internal                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    An opaque handle to an `FT_Slot_InternalRec' structure, used to    */
/*    model private data of a given @FT_GlyphSlot object.                */
/*                                                                       */
  typedef struct FT_Slot_InternalRec_*  FT_Slot_Internal;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_GlyphSlotRec                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    FreeType root glyph slot class structure.  A glyph slot is a       */
/*    container where individual glyphs can be loaded, be they in        */
/*    outline or bitmap format.                                          */
/*                                                                       */
/* <Fields>                                                              */
/*    library           :: A handle to the FreeType library instance     */
/*                         this slot belongs to.                         */
/*                                                                       */
/*    face              :: A handle to the parent face object.           */
/*                                                                       */
/*    next              :: In some cases (like some font tools), several */
/*                         glyph slots per face object can be a good     */
/*                         thing.  As this is rare, the glyph slots are  */
/*                         listed through a direct, single-linked list   */
/*                         using its `next' field.                       */
/*                                                                       */
/*    generic           :: A typeless pointer which is unused by the     */
/*                         FreeType library or any of its drivers.  It   */
/*                         can be used by client applications to link    */
/*                         their own data to each glyph slot object.     */
/*                                                                       */
/*    metrics           :: The metrics of the last loaded glyph in the   */
/*                         slot.  The returned values depend on the last */
/*                         load flags (see the @FT_Load_Glyph API        */
/*                         function) and can be expressed either in 26.6 */
/*                         fractional pixels or font units.              */
/*                                                                       */
/*                         Note that even when the glyph image is        */
/*                         transformed, the metrics are not.             */
/*                                                                       */
/*    linearHoriAdvance :: The advance width of the unhinted glyph.      */
/*                         Its value is expressed in 16.16 fractional    */
/*                         pixels, unless @FT_LOAD_LINEAR_DESIGN is set  */
/*                         when loading the glyph.  This field can be    */
/*                         important to perform correct WYSIWYG layout.  */
/*                         Only relevant for outline glyphs.             */
/*                                                                       */
/*    linearVertAdvance :: The advance height of the unhinted glyph.     */
/*                         Its value is expressed in 16.16 fractional    */
/*                         pixels, unless @FT_LOAD_LINEAR_DESIGN is set  */
/*                         when loading the glyph.  This field can be    */
/*                         important to perform correct WYSIWYG layout.  */
/*                         Only relevant for outline glyphs.             */
/*                                                                       */
/*    advance           :: This shorthand is, depending on               */
/*                         @FT_LOAD_IGNORE_TRANSFORM, the transformed    */
/*                         advance width for the glyph (in 26.6          */
/*                         fractional pixel format).  As specified with  */
/*                         @FT_LOAD_VERTICAL_LAYOUT, it uses either the  */
/*                         `horiAdvance' or the `vertAdvance' value of   */
/*                         `metrics' field.                              */
/*                                                                       */
/*    format            :: This field indicates the format of the image  */
/*                         contained in the glyph slot.  Typically       */
/*                         @FT_GLYPH_FORMAT_BITMAP,                      */
/*                         @FT_GLYPH_FORMAT_OUTLINE, or                  */
/*                         @FT_GLYPH_FORMAT_COMPOSITE, but others are    */
/*                         possible.                                     */
/*                                                                       */
/*    bitmap            :: This field is used as a bitmap descriptor     */
/*                         when the slot format is                       */
/*                         @FT_GLYPH_FORMAT_BITMAP.  Note that the       */
/*                         address and content of the bitmap buffer can  */
/*                         change between calls of @FT_Load_Glyph and a  */
/*                         few other functions.                          */
/*                                                                       */
/*    bitmap_left       :: This is the bitmap's left bearing expressed   */
/*                         in integer pixels.  Of course, this is only   */
/*                         valid if the format is                        */
/*                         @FT_GLYPH_FORMAT_BITMAP.                      */
/*                                                                       */
/*    bitmap_top        :: This is the bitmap's top bearing expressed in */
/*                         integer pixels.  Remember that this is the    */
/*                         distance from the baseline to the top-most    */
/*                         glyph scanline, upwards y~coordinates being   */
/*                         *positive*.                                   */
/*                                                                       */
/*    outline           :: The outline descriptor for the current glyph  */
/*                         image if its format is                        */
/*                         @FT_GLYPH_FORMAT_OUTLINE.  Once a glyph is    */
/*                         loaded, `outline' can be transformed,         */
/*                         distorted, embolded, etc.  However, it must   */
/*                         not be freed.                                 */
/*                                                                       */
/*    num_subglyphs     :: The number of subglyphs in a composite glyph. */
/*                         This field is only valid for the composite    */
/*                         glyph format that should normally only be     */
/*                         loaded with the @FT_LOAD_NO_RECURSE flag.     */
/*                         For now this is internal to FreeType.         */
/*                                                                       */
/*    subglyphs         :: An array of subglyph descriptors for          */
/*                         composite glyphs.  There are `num_subglyphs'  */
/*                         elements in there.  Currently internal to     */
/*                         FreeType.                                     */
/*                                                                       */
/*    control_data      :: Certain font drivers can also return the      */
/*                         control data for a given glyph image (e.g.    */
/*                         TrueType bytecode, Type~1 charstrings, etc.). */
/*                         This field is a pointer to such data.         */
/*                                                                       */
/*    control_len       :: This is the length in bytes of the control    */
/*                         data.                                         */
/*                                                                       */
/*    other             :: Really wicked formats can use this pointer to */
/*                         present their own glyph image to client       */
/*                         applications.  Note that the application      */
/*                         needs to know about the image format.         */
/*                                                                       */
/*    lsb_delta         :: The difference between hinted and unhinted    */
/*                         left side bearing while autohinting is        */
/*                         active.  Zero otherwise.                      */
/*                                                                       */
/*    rsb_delta         :: The difference between hinted and unhinted    */
/*                         right side bearing while autohinting is       */
/*                         active.  Zero otherwise.                      */
/*                                                                       */
/* <Note>                                                                */
/*    If @FT_Load_Glyph is called with default flags (see                */
/*    @FT_LOAD_DEFAULT) the glyph image is loaded in the glyph slot in   */
/*    its native format (e.g., an outline glyph for TrueType and Type~1  */
/*    formats).                                                          */
/*                                                                       */
/*    This image can later be converted into a bitmap by calling         */
/*    @FT_Render_Glyph.  This function finds the current renderer for    */
/*    the native image's format, then invokes it.                        */
/*                                                                       */
/*    The renderer is in charge of transforming the native image through */
/*    the slot's face transformation fields, then converting it into a   */
/*    bitmap that is returned in `slot->bitmap'.                         */
/*                                                                       */
/*    Note that `slot->bitmap_left' and `slot->bitmap_top' are also used */
/*    to specify the position of the bitmap relative to the current pen  */
/*    position (e.g., coordinates (0,0) on the baseline).  Of course,    */
/*    `slot->format' is also changed to @FT_GLYPH_FORMAT_BITMAP.         */
/*                                                                       */
/* <Note>                                                                */
/*    Here a small pseudo code fragment which shows how to use           */
/*    `lsb_delta' and `rsb_delta':                                       */
/*                                                                       */
/*    {                                                                  */
/*      FT_Pos  origin_x       = 0;                                      */
/*      FT_Pos  prev_rsb_delta = 0;                                      */
/*                                                                       */
/*                                                                       */
/*      for all glyphs do                                                */
/*        <compute kern between current and previous glyph and add it to */
/*         `origin_x'>                                                   */
/*                                                                       */
/*        <load glyph with `FT_Load_Glyph'>                              */
/*                                                                       */
/*        if ( prev_rsb_delta - face->glyph->lsb_delta >= 32 )           */
/*          origin_x -= 64;                                              */
/*        else if ( prev_rsb_delta - face->glyph->lsb_delta < -32 )      */
/*          origin_x += 64;                                              */
/*                                                                       */
/*        prev_rsb_delta = face->glyph->rsb_delta;                       */
/*                                                                       */
/*        <save glyph image, or render glyph, or ...>                    */
/*                                                                       */
/*        origin_x += face->glyph->advance.x;                            */
/*      endfor                                                           */
/*    }                                                                  */
/*                                                                       */
  typedef struct  FT_GlyphSlotRec_
  {
    FT_Library        library;
    FT_Face           face;
    FT_GlyphSlot      next;
/* retained for binary compatibility */
    FT_UInt           reserved;        
    FT_Generic        generic;
    FT_Glyph_Metrics  metrics;
    FT_Fixed          linearHoriAdvance;
    FT_Fixed          linearVertAdvance;
    FT_Vector         advance;
    FT_Glyph_Format   format;
    FT_Bitmap         bitmap;
    FT_Int            bitmap_left;
    FT_Int            bitmap_top;
    FT_Outline        outline;
    FT_UInt           num_subglyphs;
    FT_SubGlyph       subglyphs;
    void*             control_data;
    long              control_len;
    FT_Pos            lsb_delta;
    FT_Pos            rsb_delta;
    void*             other;
    FT_Slot_Internal  internal;
  } FT_GlyphSlotRec;
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/*                         F U N C T I O N S                             */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Init_FreeType                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Initialize a new FreeType library object.  The set of modules      */
/*    that are registered by this function is determined at build time.  */
/*                                                                       */
/* <Output>                                                              */
/*    alibrary :: A handle to a new library object.                      */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    In case you want to provide your own memory allocating routines,   */
/*    use @FT_New_Library instead, followed by a call to                 */
/*    @FT_Add_Default_Modules (or a series of calls to @FT_Add_Module).  */
/*                                                                       */
/*    For multi-threading applications each thread should have its own   */
/*    FT_Library object.                                                 */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Init_FreeType( FT_Library  *alibrary );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Done_FreeType                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Destroy a given FreeType library object and all of its children,   */
/*    including resources, drivers, faces, sizes, etc.                   */
/*                                                                       */
/* <Input>                                                               */
/*    library :: A handle to the target library object.                  */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Done_FreeType( FT_Library  library );
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_OPEN_XXX                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    A list of bit-field constants used within the `flags' field of the */
/*    @FT_Open_Args structure.                                           */
/*                                                                       */
/* <Values>                                                              */
/*    FT_OPEN_MEMORY   :: This is a memory-based stream.                 */
/*                                                                       */
/*    FT_OPEN_STREAM   :: Copy the stream from the `stream' field.       */
/*                                                                       */
/*    FT_OPEN_PATHNAME :: Create a new input stream from a C~path        */
/*                        name.                                          */
/*                                                                       */
/*    FT_OPEN_DRIVER   :: Use the `driver' field.                        */
/*                                                                       */
/*    FT_OPEN_PARAMS   :: Use the `num_params' and `params' fields.      */
/*                                                                       */
/*    ft_open_memory   :: Deprecated; use @FT_OPEN_MEMORY instead.       */
/*                                                                       */
/*    ft_open_stream   :: Deprecated; use @FT_OPEN_STREAM instead.       */
/*                                                                       */
/*    ft_open_pathname :: Deprecated; use @FT_OPEN_PATHNAME instead.     */
/*                                                                       */
/*    ft_open_driver   :: Deprecated; use @FT_OPEN_DRIVER instead.       */
/*                                                                       */
/*    ft_open_params   :: Deprecated; use @FT_OPEN_PARAMS instead.       */
/*                                                                       */
/* <Note>                                                                */
/*    The `FT_OPEN_MEMORY', `FT_OPEN_STREAM', and `FT_OPEN_PATHNAME'     */
/*    flags are mutually exclusive.                                      */
/*                                                                       */
#define FT_OPEN_MEMORY    0x1
#define FT_OPEN_STREAM    0x2
#define FT_OPEN_PATHNAME  0x4
#define FT_OPEN_DRIVER    0x8
#define FT_OPEN_PARAMS    0x10
/* deprecated */
#define ft_open_memory    FT_OPEN_MEMORY      
/* deprecated */
#define ft_open_stream    FT_OPEN_STREAM      
/* deprecated */
#define ft_open_pathname  FT_OPEN_PATHNAME    
/* deprecated */
#define ft_open_driver    FT_OPEN_DRIVER      
/* deprecated */
#define ft_open_params    FT_OPEN_PARAMS      
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Parameter                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    A simple structure used to pass more or less generic parameters to */
/*    @FT_Open_Face.                                                     */
/*                                                                       */
/* <Fields>                                                              */
/*    tag  :: A four-byte identification tag.                            */
/*                                                                       */
/*    data :: A pointer to the parameter data.                           */
/*                                                                       */
/* <Note>                                                                */
/*    The ID and function of parameters are driver-specific.  See the    */
/*    various FT_PARAM_TAG_XXX flags for more information.               */
/*                                                                       */
  typedef struct  FT_Parameter_
  {
    FT_ULong    tag;
    FT_Pointer  data;
  } FT_Parameter;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Open_Args                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to indicate how to open a new font file or        */
/*    stream.  A pointer to such a structure can be used as a parameter  */
/*    for the functions @FT_Open_Face and @FT_Attach_Stream.             */
/*                                                                       */
/* <Fields>                                                              */
/*    flags       :: A set of bit flags indicating how to use the        */
/*                   structure.                                          */
/*                                                                       */
/*    memory_base :: The first byte of the file in memory.               */
/*                                                                       */
/*    memory_size :: The size in bytes of the file in memory.            */
/*                                                                       */
/*    pathname    :: A pointer to an 8-bit file pathname.                */
/*                                                                       */
/*    stream      :: A handle to a source stream object.                 */
/*                                                                       */
/*    driver      :: This field is exclusively used by @FT_Open_Face;    */
/*                   it simply specifies the font driver to use to open  */
/*                   the face.  If set to~0, FreeType tries to load the  */
/*                   face with each one of the drivers in its list.      */
/*                                                                       */
/*    num_params  :: The number of extra parameters.                     */
/*                                                                       */
/*    params      :: Extra parameters passed to the font driver when     */
/*                   opening a new face.                                 */
/*                                                                       */
/* <Note>                                                                */
/*    The stream type is determined by the contents of `flags' which     */
/*    are tested in the following order by @FT_Open_Face:                */
/*                                                                       */
/*    If the `FT_OPEN_MEMORY' bit is set, assume that this is a          */
/*    memory file of `memory_size' bytes, located at `memory_address'.   */
/*    The data are are not copied, and the client is responsible for     */
/*    releasing and destroying them _after_ the corresponding call to    */
/*    @FT_Done_Face.                                                     */
/*                                                                       */
/*    Otherwise, if the `FT_OPEN_STREAM' bit is set, assume that a       */
/*    custom input stream `stream' is used.                              */
/*                                                                       */
/*    Otherwise, if the `FT_OPEN_PATHNAME' bit is set, assume that this  */
/*    is a normal file and use `pathname' to open it.                    */
/*                                                                       */
/*    If the `FT_OPEN_DRIVER' bit is set, @FT_Open_Face only tries to    */
/*    open the file with the driver whose handler is in `driver'.        */
/*                                                                       */
/*    If the `FT_OPEN_PARAMS' bit is set, the parameters given by        */
/*    `num_params' and `params' is used.  They are ignored otherwise.    */
/*                                                                       */
/*    Ideally, both the `pathname' and `params' fields should be tagged  */
/*    as `const'; this is missing for API backwards compatibility.  In   */
/*    other words, applications should treat them as read-only.          */
/*                                                                       */
  typedef struct  FT_Open_Args_
  {
    FT_UInt         flags;
    const FT_Byte*  memory_base;
    FT_Long         memory_size;
    FT_String*      pathname;
    FT_Stream       stream;
    FT_Module       driver;
    FT_Int          num_params;
    FT_Parameter*   params;
  } FT_Open_Args;
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_New_Face                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    This function calls @FT_Open_Face to open a font by its pathname.  */
/*                                                                       */
/* <InOut>                                                               */
/*    library    :: A handle to the library resource.                    */
/*                                                                       */
/* <Input>                                                               */
/*    pathname   :: A path to the font file.                             */
/*                                                                       */
/*    face_index :: The index of the face within the font.  The first    */
/*                  face has index~0.                                    */
/*                                                                       */
/* <Output>                                                              */
/*    aface      :: A handle to a new face object.  If `face_index' is   */
/*                  greater than or equal to zero, it must be non-NULL.  */
/*                  See @FT_Open_Face for more details.                  */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_New_Face( FT_Library   library,
               const char*  filepathname,
               FT_Long      face_index,
               FT_Face     *aface );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_New_Memory_Face                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    This function calls @FT_Open_Face to open a font which has been    */
/*    loaded into memory.                                                */
/*                                                                       */
/* <InOut>                                                               */
/*    library    :: A handle to the library resource.                    */
/*                                                                       */
/* <Input>                                                               */
/*    file_base  :: A pointer to the beginning of the font data.         */
/*                                                                       */
/*    file_size  :: The size of the memory chunk used by the font data.  */
/*                                                                       */
/*    face_index :: The index of the face within the font.  The first    */
/*                  face has index~0.                                    */
/*                                                                       */
/* <Output>                                                              */
/*    aface      :: A handle to a new face object.  If `face_index' is   */
/*                  greater than or equal to zero, it must be non-NULL.  */
/*                  See @FT_Open_Face for more details.                  */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    You must not deallocate the memory before calling @FT_Done_Face.   */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_New_Memory_Face( FT_Library      library,
                      const FT_Byte*  file_base,
                      FT_Long         file_size,
                      FT_Long         face_index,
                      FT_Face        *aface );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Open_Face                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    Create a face object from a given resource described by            */
/*    @FT_Open_Args.                                                     */
/*                                                                       */
/* <InOut>                                                               */
/*    library    :: A handle to the library resource.                    */
/*                                                                       */
/* <Input>                                                               */
/*    args       :: A pointer to an `FT_Open_Args' structure which must  */
/*                  be filled by the caller.                             */
/*                                                                       */
/*    face_index :: The index of the face within the font.  The first    */
/*                  face has index~0.                                    */
/*                                                                       */
/* <Output>                                                              */
/*    aface      :: A handle to a new face object.  If `face_index' is   */
/*                  greater than or equal to zero, it must be non-NULL.  */
/*                  See note below.                                      */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    Unlike FreeType 1.x, this function automatically creates a glyph   */
/*    slot for the face object which can be accessed directly through    */
/*    `face->glyph'.                                                     */
/*                                                                       */
/*    FT_Open_Face can be used to quickly check whether the font         */
/*    format of a given font resource is supported by FreeType.  If the  */
/*    `face_index' field is negative, the function's return value is~0   */
/*    if the font format is recognized, or non-zero otherwise;           */
/*    the function returns a more or less empty face handle in `*aface'  */
/*    (if `aface' isn't NULL).  The only useful field in this special    */
/*    case is `face->num_faces' which gives the number of faces within   */
/*    the font file.  After examination, the returned @FT_Face structure */
/*    should be deallocated with a call to @FT_Done_Face.                */
/*                                                                       */
/*    Each new face object created with this function also owns a        */
/*    default @FT_Size object, accessible as `face->size'.               */
/*                                                                       */
/*    One @FT_Library instance can have multiple face objects, this is,  */
/*    @FT_Open_Face and its siblings can be called multiple times using  */
/*    the same `library' argument.                                       */
/*                                                                       */
/*    See the discussion of reference counters in the description of     */
/*    @FT_Reference_Face.                                                */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Open_Face( FT_Library           library,
                const FT_Open_Args*  args,
                FT_Long              face_index,
                FT_Face             *aface );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Attach_File                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    This function calls @FT_Attach_Stream to attach a file.            */
/*                                                                       */
/* <InOut>                                                               */
/*    face         :: The target face object.                            */
/*                                                                       */
/* <Input>                                                               */
/*    filepathname :: The pathname.                                      */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Attach_File( FT_Face      face,
                  const char*  filepathname );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Attach_Stream                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    `Attach' data to a face object.  Normally, this is used to read    */
/*    additional information for the face object.  For example, you can  */
/*    attach an AFM file that comes with a Type~1 font to get the        */
/*    kerning values and other metrics.                                  */
/*                                                                       */
/* <InOut>                                                               */
/*    face       :: The target face object.                              */
/*                                                                       */
/* <Input>                                                               */
/*    parameters :: A pointer to @FT_Open_Args which must be filled by   */
/*                  the caller.                                          */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    The meaning of the `attach' (i.e., what really happens when the    */
/*    new file is read) is not fixed by FreeType itself.  It really      */
/*    depends on the font format (and thus the font driver).             */
/*                                                                       */
/*    Client applications are expected to know what they are doing       */
/*    when invoking this function.  Most drivers simply do not implement */
/*    file attachments.                                                  */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Attach_Stream( FT_Face        face,
                    FT_Open_Args*  parameters );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Reference_Face                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    A counter gets initialized to~1 at the time an @FT_Face structure  */
/*    is created.  This function increments the counter.  @FT_Done_Face  */
/*    then only destroys a face if the counter is~1, otherwise it simply */
/*    decrements the counter.                                            */
/*                                                                       */
/*    This function helps in managing life-cycles of structures which    */
/*    reference @FT_Face objects.                                        */
/*                                                                       */
/* <Input>                                                               */
/*    face :: A handle to a target face object.                          */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Since>                                                               */
/*    2.4.2                                                              */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Reference_Face( FT_Face  face );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Done_Face                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    Discard a given face object, as well as all of its child slots and */
/*    sizes.                                                             */
/*                                                                       */
/* <Input>                                                               */
/*    face :: A handle to a target face object.                          */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    See the discussion of reference counters in the description of     */
/*    @FT_Reference_Face.                                                */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Done_Face( FT_Face  face );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Select_Size                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    Select a bitmap strike.                                            */
/*                                                                       */
/* <InOut>                                                               */
/*    face         :: A handle to a target face object.                  */
/*                                                                       */
/* <Input>                                                               */
/*    strike_index :: The index of the bitmap strike in the              */
/*                    `available_sizes' field of @FT_FaceRec structure.  */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Select_Size( FT_Face  face,
                  FT_Int   strike_index );
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_Size_Request_Type                                               */
/*                                                                       */
/* <Description>                                                         */
/*    An enumeration type that lists the supported size request types.   */
/*                                                                       */
/* <Values>                                                              */
/*    FT_SIZE_REQUEST_TYPE_NOMINAL ::                                    */
/*      The nominal size.  The `units_per_EM' field of @FT_FaceRec is    */
/*      used to determine both scaling values.                           */
/*                                                                       */
/*    FT_SIZE_REQUEST_TYPE_REAL_DIM ::                                   */
/*      The real dimension.  The sum of the the `ascender' and (minus    */
/*      of) the `descender' fields of @FT_FaceRec are used to determine  */
/*      both scaling values.                                             */
/*                                                                       */
/*    FT_SIZE_REQUEST_TYPE_BBOX ::                                       */
/*      The font bounding box.  The width and height of the `bbox' field */
/*      of @FT_FaceRec are used to determine the horizontal and vertical */
/*      scaling value, respectively.                                     */
/*                                                                       */
/*    FT_SIZE_REQUEST_TYPE_CELL ::                                       */
/*      The `max_advance_width' field of @FT_FaceRec is used to          */
/*      determine the horizontal scaling value; the vertical scaling     */
/*      value is determined the same way as                              */
/*      @FT_SIZE_REQUEST_TYPE_REAL_DIM does.  Finally, both scaling      */
/*      values are set to the smaller one.  This type is useful if you   */
/*      want to specify the font size for, say, a window of a given      */
/*      dimension and 80x24 cells.                                       */
/*                                                                       */
/*    FT_SIZE_REQUEST_TYPE_SCALES ::                                     */
/*      Specify the scaling values directly.                             */
/*                                                                       */
/* <Note>                                                                */
/*    The above descriptions only apply to scalable formats.  For bitmap */
/*    formats, the behaviour is up to the driver.                        */
/*                                                                       */
/*    See the note section of @FT_Size_Metrics if you wonder how size    */
/*    requesting relates to scaling values.                              */
/*                                                                       */
  typedef enum  FT_Size_Request_Type_
  {
    FT_SIZE_REQUEST_TYPE_NOMINAL,
    FT_SIZE_REQUEST_TYPE_REAL_DIM,
    FT_SIZE_REQUEST_TYPE_BBOX,
    FT_SIZE_REQUEST_TYPE_CELL,
    FT_SIZE_REQUEST_TYPE_SCALES,
    FT_SIZE_REQUEST_TYPE_MAX
  } FT_Size_Request_Type;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Size_RequestRec                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to model a size request.                          */
/*                                                                       */
/* <Fields>                                                              */
/*    type           :: See @FT_Size_Request_Type.                       */
/*                                                                       */
/*    width          :: The desired width.                               */
/*                                                                       */
/*    height         :: The desired height.                              */
/*                                                                       */
/*    horiResolution :: The horizontal resolution.  If set to zero,      */
/*                      `width' is treated as a 26.6 fractional pixel    */
/*                      value.                                           */
/*                                                                       */
/*    vertResolution :: The vertical resolution.  If set to zero,        */
/*                      `height' is treated as a 26.6 fractional pixel   */
/*                      value.                                           */
/*                                                                       */
/* <Note>                                                                */
/*    If `width' is zero, then the horizontal scaling value is set equal */
/*    to the vertical scaling value, and vice versa.                     */
/*                                                                       */
  typedef struct  FT_Size_RequestRec_
  {
    FT_Size_Request_Type  type;
    FT_Long               width;
    FT_Long               height;
    FT_UInt               horiResolution;
    FT_UInt               vertResolution;
  } FT_Size_RequestRec;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Size_Request                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to a size request structure.                              */
/*                                                                       */
  typedef struct FT_Size_RequestRec_  *FT_Size_Request;
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Request_Size                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Resize the scale of the active @FT_Size object in a face.          */
/*                                                                       */
/* <InOut>                                                               */
/*    face :: A handle to a target face object.                          */
/*                                                                       */
/* <Input>                                                               */
/*    req  :: A pointer to a @FT_Size_RequestRec.                        */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    Although drivers may select the bitmap strike matching the         */
/*    request, you should not rely on this if you intend to select a     */
/*    particular bitmap strike.  Use @FT_Select_Size instead in that     */
/*    case.                                                              */
/*                                                                       */
/*    The relation between the requested size and the resulting glyph    */
/*    size is dependent entirely on how the size is defined in the       */
/*    source face.  The font designer chooses the final size of each     */
/*    glyph relative to this size.  For more information refer to        */
/*    `http://www.freetype.org/freetype2/docs/glyphs/glyphs-2.html'      */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Request_Size( FT_Face          face,
                   FT_Size_Request  req );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Set_Char_Size                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    This function calls @FT_Request_Size to request the nominal size   */
/*    (in points).                                                       */
/*                                                                       */
/* <InOut>                                                               */
/*    face            :: A handle to a target face object.               */
/*                                                                       */
/* <Input>                                                               */
/*    char_width      :: The nominal width, in 26.6 fractional points.   */
/*                                                                       */
/*    char_height     :: The nominal height, in 26.6 fractional points.  */
/*                                                                       */
/*    horz_resolution :: The horizontal resolution in dpi.               */
/*                                                                       */
/*    vert_resolution :: The vertical resolution in dpi.                 */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    If either the character width or height is zero, it is set equal   */
/*    to the other value.                                                */
/*                                                                       */
/*    If either the horizontal or vertical resolution is zero, it is set */
/*    equal to the other value.                                          */
/*                                                                       */
/*    A character width or height smaller than 1pt is set to 1pt; if     */
/*    both resolution values are zero, they are set to 72dpi.            */
/*                                                                       */
/*    Don't use this function if you are using the FreeType cache API.   */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Set_Char_Size( FT_Face     face,
                    FT_F26Dot6  char_width,
                    FT_F26Dot6  char_height,
                    FT_UInt     horz_resolution,
                    FT_UInt     vert_resolution );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Set_Pixel_Sizes                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    This function calls @FT_Request_Size to request the nominal size   */
/*    (in pixels).                                                       */
/*                                                                       */
/* <InOut>                                                               */
/*    face         :: A handle to the target face object.                */
/*                                                                       */
/* <Input>                                                               */
/*    pixel_width  :: The nominal width, in pixels.                      */
/*                                                                       */
/*    pixel_height :: The nominal height, in pixels.                     */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    You should not rely on the resulting glyphs matching, or being     */
/*    constrained, to this pixel size.  Refer to @FT_Request_Size to     */
/*    understand how requested sizes relate to actual sizes.             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Set_Pixel_Sizes( FT_Face  face,
                      FT_UInt  pixel_width,
                      FT_UInt  pixel_height );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Load_Glyph                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to load a single glyph into the glyph slot of a    */
/*    face object.                                                       */
/*                                                                       */
/* <InOut>                                                               */
/*    face        :: A handle to the target face object where the glyph  */
/*                   is loaded.                                          */
/*                                                                       */
/* <Input>                                                               */
/*    glyph_index :: The index of the glyph in the font file.  For       */
/*                   CID-keyed fonts (either in PS or in CFF format)     */
/*                   this argument specifies the CID value.              */
/*                                                                       */
/*    load_flags  :: A flag indicating what to load for this glyph.  The */
/*                   @FT_LOAD_XXX constants can be used to control the   */
/*                   glyph loading process (e.g., whether the outline    */
/*                   should be scaled, whether to load bitmaps or not,   */
/*                   whether to hint the outline, etc).                  */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    The loaded glyph may be transformed.  See @FT_Set_Transform for    */
/*    the details.                                                       */
/*                                                                       */
/*    For subsetted CID-keyed fonts, `FT_Err_Invalid_Argument' is        */
/*    returned for invalid CID values (this is, for CID values which     */
/*    don't have a corresponding glyph in the font).  See the discussion */
/*    of the @FT_FACE_FLAG_CID_KEYED flag for more details.              */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Load_Glyph( FT_Face   face,
                 FT_UInt   glyph_index,
                 FT_Int32  load_flags );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Load_Char                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to load a single glyph into the glyph slot of a    */
/*    face object, according to its character code.                      */
/*                                                                       */
/* <InOut>                                                               */
/*    face        :: A handle to a target face object where the glyph    */
/*                   is loaded.                                          */
/*                                                                       */
/* <Input>                                                               */
/*    char_code   :: The glyph's character code, according to the        */
/*                   current charmap used in the face.                   */
/*                                                                       */
/*    load_flags  :: A flag indicating what to load for this glyph.  The */
/*                   @FT_LOAD_XXX constants can be used to control the   */
/*                   glyph loading process (e.g., whether the outline    */
/*                   should be scaled, whether to load bitmaps or not,   */
/*                   whether to hint the outline, etc).                  */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    This function simply calls @FT_Get_Char_Index and @FT_Load_Glyph.  */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Load_Char( FT_Face   face,
                FT_ULong  char_code,
                FT_Int32  load_flags );
/*************************************************************************
   *
   * @enum:
   *   FT_LOAD_XXX
   *
   * @description:
   *   A list of bit-field constants used with @FT_Load_Glyph to indicate
   *   what kind of operations to perform during glyph loading.
   *
   * @values:
   *   FT_LOAD_DEFAULT ::
   *     Corresponding to~0, this value is used as the default glyph load
   *     operation.  In this case, the following happens:
   *
   *     1. FreeType looks for a bitmap for the glyph corresponding to the
   *        face's current size.  If one is found, the function returns.
   *        The bitmap data can be accessed from the glyph slot (see note
   *        below).
   *
   *     2. If no embedded bitmap is searched or found, FreeType looks for a
   *        scalable outline.  If one is found, it is loaded from the font
   *        file, scaled to device pixels, then `hinted' to the pixel grid
   *        in order to optimize it.  The outline data can be accessed from
   *        the glyph slot (see note below).
   *
   *     Note that by default, the glyph loader doesn't render outlines into
   *     bitmaps.  The following flags are used to modify this default
   *     behaviour to more specific and useful cases.
   *
   *   FT_LOAD_NO_SCALE ::
   *     Don't scale the loaded outline glyph but keep it in font units.
   *
   *     This flag implies @FT_LOAD_NO_HINTING and @FT_LOAD_NO_BITMAP, and
   *     unsets @FT_LOAD_RENDER.
   *
   *     If the font is `tricky' (see @FT_FACE_FLAG_TRICKY for more), using
   *     FT_LOAD_NO_SCALE usually yields meaningless outlines because the
   *     subglyphs must be scaled and positioned with hinting instructions. 
   *     This can be solved by loading the font without FT_LOAD_NO_SCALE and
   *     setting the character size to `font->units_per_EM'.
   *
   *   FT_LOAD_NO_HINTING ::
   *     Disable hinting.  This generally generates `blurrier' bitmap glyphs
   *     when the glyph are rendered in any of the anti-aliased modes.  See
   *     also the note below.
   *
   *     This flag is implied by @FT_LOAD_NO_SCALE.
   *
   *   FT_LOAD_RENDER ::
   *     Call @FT_Render_Glyph after the glyph is loaded.  By default, the
   *     glyph is rendered in @FT_RENDER_MODE_NORMAL mode.  This can be
   *     overridden by @FT_LOAD_TARGET_XXX or @FT_LOAD_MONOCHROME.
   *
   *     This flag is unset by @FT_LOAD_NO_SCALE.
   *
   *   FT_LOAD_NO_BITMAP ::
   *     Ignore bitmap strikes when loading.  Bitmap-only fonts ignore this
   *     flag.
   *
   *     @FT_LOAD_NO_SCALE always sets this flag.
   *
   *   FT_LOAD_VERTICAL_LAYOUT ::
   *     Load the glyph for vertical text layout.  In particular, the
   *     `advance' value in the @FT_GlyphSlotRec structure is set to the
   *     `vertAdvance' value of the `metrics' field.
   *
   *     In case @FT_HAS_VERTICAL doesn't return true, you shouldn't use
   *     this flag currently.  Reason is that in this case vertical metrics
   *     get synthesized, and those values are not always consistent across
   *     various font formats.
   *
   *   FT_LOAD_FORCE_AUTOHINT ::
   *     Indicates that the auto-hinter is preferred over the font's native
   *     hinter.  See also the note below.
   *
   *   FT_LOAD_CROP_BITMAP ::
   *     Indicates that the font driver should crop the loaded bitmap glyph
   *     (i.e., remove all space around its black bits).  Not all drivers
   *     implement this.
   *
   *   FT_LOAD_PEDANTIC ::
   *     Indicates that the font driver should perform pedantic verifications
   *     during glyph loading.  This is mostly used to detect broken glyphs
   *     in fonts.  By default, FreeType tries to handle broken fonts also.
   *
   *     In particular, errors from the TrueType bytecode engine are not
   *     passed to the application if this flag is not set; this might
   *     result in partially hinted or distorted glyphs in case a glyph's
   *     bytecode is buggy.
   *
   *   FT_LOAD_IGNORE_GLOBAL_ADVANCE_WIDTH ::
   *     Ignored.  Deprecated.
   *
   *   FT_LOAD_NO_RECURSE ::
   *     This flag is only used internally.  It merely indicates that the
   *     font driver should not load composite glyphs recursively.  Instead,
   *     it should set the `num_subglyph' and `subglyphs' values of the
   *     glyph slot accordingly, and set `glyph->format' to
   *     @FT_GLYPH_FORMAT_COMPOSITE.
   *
   *     The description of sub-glyphs is not available to client
   *     applications for now.
   *
   *     This flag implies @FT_LOAD_NO_SCALE and @FT_LOAD_IGNORE_TRANSFORM.
   *
   *   FT_LOAD_IGNORE_TRANSFORM ::
   *     Indicates that the transform matrix set by @FT_Set_Transform should
   *     be ignored.
   *
   *   FT_LOAD_MONOCHROME ::
   *     This flag is used with @FT_LOAD_RENDER to indicate that you want to
   *     render an outline glyph to a 1-bit monochrome bitmap glyph, with
   *     8~pixels packed into each byte of the bitmap data.
   *
   *     Note that this has no effect on the hinting algorithm used.  You
   *     should rather use @FT_LOAD_TARGET_MONO so that the
   *     monochrome-optimized hinting algorithm is used.
   *
   *   FT_LOAD_LINEAR_DESIGN ::
   *     Indicates that the `linearHoriAdvance' and `linearVertAdvance'
   *     fields of @FT_GlyphSlotRec should be kept in font units.  See
   *     @FT_GlyphSlotRec for details.
   *
   *   FT_LOAD_NO_AUTOHINT ::
   *     Disable auto-hinter.  See also the note below.
   *
   * @note:
   *   By default, hinting is enabled and the font's native hinter (see
   *   @FT_FACE_FLAG_HINTER) is preferred over the auto-hinter.  You can
   *   disable hinting by setting @FT_LOAD_NO_HINTING or change the
   *   precedence by setting @FT_LOAD_FORCE_AUTOHINT.  You can also set
   *   @FT_LOAD_NO_AUTOHINT in case you don't want the auto-hinter to be
   *   used at all.
   *
   *   See the description of @FT_FACE_FLAG_TRICKY for a special exception
   *   (affecting only a handful of Asian fonts).
   *
   *   Besides deciding which hinter to use, you can also decide which
   *   hinting algorithm to use.  See @FT_LOAD_TARGET_XXX for details.
   *
   *   Note that the auto-hinter needs a valid Unicode cmap (either a native
   *   one or synthesized by FreeType) for producing correct results.  If a
   *   font provides an incorrect mapping (for example, assigning the
   *   character code U+005A, LATIN CAPITAL LETTER Z, to a glyph depicting a
   *   mathematical integral sign), the auto-hinter might produce useless
   *   results.
   *
   */
#define FT_LOAD_DEFAULT                      0x0
#define FT_LOAD_NO_SCALE                     ( 1L << 0 )
#define FT_LOAD_NO_HINTING                   ( 1L << 1 )
#define FT_LOAD_RENDER                       ( 1L << 2 )
#define FT_LOAD_NO_BITMAP                    ( 1L << 3 )
#define FT_LOAD_VERTICAL_LAYOUT              ( 1L << 4 )
#define FT_LOAD_FORCE_AUTOHINT               ( 1L << 5 )
#define FT_LOAD_CROP_BITMAP                  ( 1L << 6 )
#define FT_LOAD_PEDANTIC                     ( 1L << 7 )
#define FT_LOAD_IGNORE_GLOBAL_ADVANCE_WIDTH  ( 1L << 9 )
#define FT_LOAD_NO_RECURSE                   ( 1L << 10 )
#define FT_LOAD_IGNORE_TRANSFORM             ( 1L << 11 )
#define FT_LOAD_MONOCHROME                   ( 1L << 12 )
#define FT_LOAD_LINEAR_DESIGN                ( 1L << 13 )
#define FT_LOAD_NO_AUTOHINT                  ( 1L << 15 )
/* */
/* used internally only by certain font drivers! */
#define FT_LOAD_ADVANCE_ONLY                 ( 1L << 8 )
#define FT_LOAD_SBITS_ONLY                   ( 1L << 14 )
/**************************************************************************
   *
   * @enum:
   *   FT_LOAD_TARGET_XXX
   *
   * @description:
   *   A list of values that are used to select a specific hinting algorithm
   *   to use by the hinter.  You should OR one of these values to your
   *   `load_flags' when calling @FT_Load_Glyph.
   *
   *   Note that font's native hinters may ignore the hinting algorithm you
   *   have specified (e.g., the TrueType bytecode interpreter).  You can set
   *   @FT_LOAD_FORCE_AUTOHINT to ensure that the auto-hinter is used.
   *
   *   Also note that @FT_LOAD_TARGET_LIGHT is an exception, in that it
   *   always implies @FT_LOAD_FORCE_AUTOHINT.
   *
   * @values:
   *   FT_LOAD_TARGET_NORMAL ::
   *     This corresponds to the default hinting algorithm, optimized for
   *     standard gray-level rendering.  For monochrome output, use
   *     @FT_LOAD_TARGET_MONO instead.
   *
   *   FT_LOAD_TARGET_LIGHT ::
   *     A lighter hinting algorithm for non-monochrome modes.  Many
   *     generated glyphs are more fuzzy but better resemble its original
   *     shape.  A bit like rendering on Mac OS~X.
   *
   *     As a special exception, this target implies @FT_LOAD_FORCE_AUTOHINT.
   *
   *   FT_LOAD_TARGET_MONO ::
   *     Strong hinting algorithm that should only be used for monochrome
   *     output.  The result is probably unpleasant if the glyph is rendered
   *     in non-monochrome modes.
   *
   *   FT_LOAD_TARGET_LCD ::
   *     A variant of @FT_LOAD_TARGET_NORMAL optimized for horizontally
   *     decimated LCD displays.
   *
   *   FT_LOAD_TARGET_LCD_V ::
   *     A variant of @FT_LOAD_TARGET_NORMAL optimized for vertically
   *     decimated LCD displays.
   *
   * @note:
   *   You should use only _one_ of the FT_LOAD_TARGET_XXX values in your
   *   `load_flags'.  They can't be ORed.
   *
   *   If @FT_LOAD_RENDER is also set, the glyph is rendered in the
   *   corresponding mode (i.e., the mode which matches the used algorithm
   *   best).  An exeption is FT_LOAD_TARGET_MONO since it implies
   *   @FT_LOAD_MONOCHROME.
   *
   *   You can use a hinting algorithm that doesn't correspond to the same
   *   rendering mode.  As an example, it is possible to use the `light'
   *   hinting algorithm and have the results rendered in horizontal LCD
   *   pixel mode, with code like
   *
   *     {
   *       FT_Load_Glyph( face, glyph_index,
   *                      load_flags | FT_LOAD_TARGET_LIGHT );
   *
   *       FT_Render_Glyph( face->glyph, FT_RENDER_MODE_LCD );
   *     }
   *
   */
#define FT_LOAD_TARGET_( x )   ( (FT_Int32)( (x) & 15 ) << 16 )
#define FT_LOAD_TARGET_NORMAL  FT_LOAD_TARGET_( FT_RENDER_MODE_NORMAL )
#define FT_LOAD_TARGET_LIGHT   FT_LOAD_TARGET_( FT_RENDER_MODE_LIGHT  )
#define FT_LOAD_TARGET_MONO    FT_LOAD_TARGET_( FT_RENDER_MODE_MONO   )
#define FT_LOAD_TARGET_LCD     FT_LOAD_TARGET_( FT_RENDER_MODE_LCD    )
#define FT_LOAD_TARGET_LCD_V   FT_LOAD_TARGET_( FT_RENDER_MODE_LCD_V  )
/**************************************************************************
   *
   * @macro:
   *   FT_LOAD_TARGET_MODE
   *
   * @description:
   *   Return the @FT_Render_Mode corresponding to a given
   *   @FT_LOAD_TARGET_XXX value.
   *
   */
#define FT_LOAD_TARGET_MODE( x )  ( (FT_Render_Mode)( ( (x) >> 16 ) & 15 ) )
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Set_Transform                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to set the transformation that is applied to glyph */
/*    images when they are loaded into a glyph slot through              */
/*    @FT_Load_Glyph.                                                    */
/*                                                                       */
/* <InOut>                                                               */
/*    face   :: A handle to the source face object.                      */
/*                                                                       */
/* <Input>                                                               */
/*    matrix :: A pointer to the transformation's 2x2 matrix.  Use~0 for */
/*              the identity matrix.                                     */
/*    delta  :: A pointer to the translation vector.  Use~0 for the null */
/*              vector.                                                  */
/*                                                                       */
/* <Note>                                                                */
/*    The transformation is only applied to scalable image formats after */
/*    the glyph has been loaded.  It means that hinting is unaltered by  */
/*    the transformation and is performed on the character size given in */
/*    the last call to @FT_Set_Char_Size or @FT_Set_Pixel_Sizes.         */
/*                                                                       */
/*    Note that this also transforms the `face.glyph.advance' field, but */
/*    *not* the values in `face.glyph.metrics'.                          */
/*                                                                       */
  FT_EXPORT( void )
  FT_Set_Transform( FT_Face     face,
                    FT_Matrix*  matrix,
                    FT_Vector*  delta );
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_Render_Mode                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    An enumeration type that lists the render modes supported by       */
/*    FreeType~2.  Each mode corresponds to a specific type of scanline  */
/*    conversion performed on the outline.                               */
/*                                                                       */
/*    For bitmap fonts and embedded bitmaps the `bitmap->pixel_mode'     */
/*    field in the @FT_GlyphSlotRec structure gives the format of the    */
/*    returned bitmap.                                                   */
/*                                                                       */
/*    All modes except @FT_RENDER_MODE_MONO use 256 levels of opacity.   */
/*                                                                       */
/* <Values>                                                              */
/*    FT_RENDER_MODE_NORMAL ::                                           */
/*      This is the default render mode; it corresponds to 8-bit         */
/*      anti-aliased bitmaps.                                            */
/*                                                                       */
/*    FT_RENDER_MODE_LIGHT ::                                            */
/*      This is equivalent to @FT_RENDER_MODE_NORMAL.  It is only        */
/*      defined as a separate value because render modes are also used   */
/*      indirectly to define hinting algorithm selectors.  See           */
/*      @FT_LOAD_TARGET_XXX for details.                                 */
/*                                                                       */
/*    FT_RENDER_MODE_MONO ::                                             */
/*      This mode corresponds to 1-bit bitmaps (with 2~levels of         */
/*      opacity).                                                        */
/*                                                                       */
/*    FT_RENDER_MODE_LCD ::                                              */
/*      This mode corresponds to horizontal RGB and BGR sub-pixel        */
/*      displays like LCD screens.  It produces 8-bit bitmaps that are   */
/*      3~times the width of the original glyph outline in pixels, and   */
/*      which use the @FT_PIXEL_MODE_LCD mode.                           */
/*                                                                       */
/*    FT_RENDER_MODE_LCD_V ::                                            */
/*      This mode corresponds to vertical RGB and BGR sub-pixel displays */
/*      (like PDA screens, rotated LCD displays, etc.).  It produces     */
/*      8-bit bitmaps that are 3~times the height of the original        */
/*      glyph outline in pixels and use the @FT_PIXEL_MODE_LCD_V mode.   */
/*                                                                       */
/* <Note>                                                                */
/*    The LCD-optimized glyph bitmaps produced by FT_Render_Glyph can be */
/*    filtered to reduce color-fringes by using @FT_Library_SetLcdFilter */
/*    (not active in the default builds).  It is up to the caller to     */
/*    either call @FT_Library_SetLcdFilter (if available) or do the      */
/*    filtering itself.                                                  */
/*                                                                       */
/*    The selected render mode only affects vector glyphs of a font.     */
/*    Embedded bitmaps often have a different pixel mode like            */
/*    @FT_PIXEL_MODE_MONO.  You can use @FT_Bitmap_Convert to transform  */
/*    them into 8-bit pixmaps.                                           */
/*                                                                       */
  typedef enum  FT_Render_Mode_
  {
    FT_RENDER_MODE_NORMAL = 0,
    FT_RENDER_MODE_LIGHT,
    FT_RENDER_MODE_MONO,
    FT_RENDER_MODE_LCD,
    FT_RENDER_MODE_LCD_V,
    FT_RENDER_MODE_MAX
  } FT_Render_Mode;
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    ft_render_mode_xxx                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    These constants are deprecated.  Use the corresponding             */
/*    @FT_Render_Mode values instead.                                    */
/*                                                                       */
/* <Values>                                                              */
/*    ft_render_mode_normal :: see @FT_RENDER_MODE_NORMAL                */
/*    ft_render_mode_mono   :: see @FT_RENDER_MODE_MONO                  */
/*                                                                       */
#define ft_render_mode_normal  FT_RENDER_MODE_NORMAL
#define ft_render_mode_mono    FT_RENDER_MODE_MONO
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Render_Glyph                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Convert a given glyph image to a bitmap.  It does so by inspecting */
/*    the glyph image format, finding the relevant renderer, and         */
/*    invoking it.                                                       */
/*                                                                       */
/* <InOut>                                                               */
/*    slot        :: A handle to the glyph slot containing the image to  */
/*                   convert.                                            */
/*                                                                       */
/* <Input>                                                               */
/*    render_mode :: This is the render mode used to render the glyph    */
/*                   image into a bitmap.  See @FT_Render_Mode for a     */
/*                   list of possible values.                            */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Render_Glyph( FT_GlyphSlot    slot,
                   FT_Render_Mode  render_mode );
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_Kerning_Mode                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    An enumeration used to specify which kerning values to return in   */
/*    @FT_Get_Kerning.                                                   */
/*                                                                       */
/* <Values>                                                              */
/*    FT_KERNING_DEFAULT  :: Return scaled and grid-fitted kerning       */
/*                           distances (value is~0).                     */
/*                                                                       */
/*    FT_KERNING_UNFITTED :: Return scaled but un-grid-fitted kerning    */
/*                           distances.                                  */
/*                                                                       */
/*    FT_KERNING_UNSCALED :: Return the kerning vector in original font  */
/*                           units.                                      */
/*                                                                       */
  typedef enum  FT_Kerning_Mode_
  {
    FT_KERNING_DEFAULT  = 0,
    FT_KERNING_UNFITTED,
    FT_KERNING_UNSCALED
  } FT_Kerning_Mode;
/*************************************************************************/
/*                                                                       */
/* <Const>                                                               */
/*    ft_kerning_default                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    This constant is deprecated.  Please use @FT_KERNING_DEFAULT       */
/*    instead.                                                           */
/*                                                                       */
#define ft_kerning_default   FT_KERNING_DEFAULT
/*************************************************************************/
/*                                                                       */
/* <Const>                                                               */
/*    ft_kerning_unfitted                                                */
/*                                                                       */
/* <Description>                                                         */
/*    This constant is deprecated.  Please use @FT_KERNING_UNFITTED      */
/*    instead.                                                           */
/*                                                                       */
#define ft_kerning_unfitted  FT_KERNING_UNFITTED
/*************************************************************************/
/*                                                                       */
/* <Const>                                                               */
/*    ft_kerning_unscaled                                                */
/*                                                                       */
/* <Description>                                                         */
/*    This constant is deprecated.  Please use @FT_KERNING_UNSCALED      */
/*    instead.                                                           */
/*                                                                       */
#define ft_kerning_unscaled  FT_KERNING_UNSCALED
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Kerning                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    Return the kerning vector between two glyphs of a same face.       */
/*                                                                       */
/* <Input>                                                               */
/*    face        :: A handle to a source face object.                   */
/*                                                                       */
/*    left_glyph  :: The index of the left glyph in the kern pair.       */
/*                                                                       */
/*    right_glyph :: The index of the right glyph in the kern pair.      */
/*                                                                       */
/*    kern_mode   :: See @FT_Kerning_Mode for more information.          */
/*                   Determines the scale and dimension of the returned  */
/*                   kerning vector.                                     */
/*                                                                       */
/* <Output>                                                              */
/*    akerning    :: The kerning vector.  This is either in font units   */
/*                   or in pixels (26.6 format) for scalable formats,    */
/*                   and in pixels for fixed-sizes formats.              */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    Only horizontal layouts (left-to-right & right-to-left) are        */
/*    supported by this method.  Other layouts, or more sophisticated    */
/*    kernings, are out of the scope of this API function -- they can be */
/*    implemented through format-specific interfaces.                    */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Get_Kerning( FT_Face     face,
                  FT_UInt     left_glyph,
                  FT_UInt     right_glyph,
                  FT_UInt     kern_mode,
                  FT_Vector  *akerning );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Track_Kerning                                               */
/*                                                                       */
/* <Description>                                                         */
/*    Return the track kerning for a given face object at a given size.  */
/*                                                                       */
/* <Input>                                                               */
/*    face       :: A handle to a source face object.                    */
/*                                                                       */
/*    point_size :: The point size in 16.16 fractional points.           */
/*                                                                       */
/*    degree     :: The degree of tightness.  Increasingly negative      */
/*                  values represent tighter track kerning, while        */
/*                  increasingly positive values represent looser track  */
/*                  kerning.  Value zero means no track kerning.         */
/*                                                                       */
/* <Output>                                                              */
/*    akerning   :: The kerning in 16.16 fractional points, to be        */
/*                  uniformly applied between all glyphs.                */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    Currently, only the Type~1 font driver supports track kerning,     */
/*    using data from AFM files (if attached with @FT_Attach_File or     */
/*    @FT_Attach_Stream).                                                */
/*                                                                       */
/*    Only very few AFM files come with track kerning data; please refer */
/*    to the Adobe's AFM specification for more details.                 */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Get_Track_Kerning( FT_Face    face,
                        FT_Fixed   point_size,
                        FT_Int     degree,
                        FT_Fixed*  akerning );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Glyph_Name                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Retrieve the ASCII name of a given glyph in a face.  This only     */
/*    works for those faces where @FT_HAS_GLYPH_NAMES(face) returns~1.   */
/*                                                                       */
/* <Input>                                                               */
/*    face        :: A handle to a source face object.                   */
/*                                                                       */
/*    glyph_index :: The glyph index.                                    */
/*                                                                       */
/*    buffer_max  :: The maximum number of bytes available in the        */
/*                   buffer.                                             */
/*                                                                       */
/* <Output>                                                              */
/*    buffer      :: A pointer to a target buffer where the name is      */
/*                   copied to.                                          */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    An error is returned if the face doesn't provide glyph names or if */
/*    the glyph index is invalid.  In all cases of failure, the first    */
/*    byte of `buffer' is set to~0 to indicate an empty name.            */
/*                                                                       */
/*    The glyph name is truncated to fit within the buffer if it is too  */
/*    long.  The returned string is always zero-terminated.              */
/*                                                                       */
/*    Be aware that FreeType reorders glyph indices internally so that   */
/*    glyph index~0 always corresponds to the `missing glyph' (called    */
/*    `.notdef').                                                        */
/*                                                                       */
/*    This function is not compiled within the library if the config     */
/*    macro `FT_CONFIG_OPTION_NO_GLYPH_NAMES' is defined in              */
/*    `include/freetype/config/ftoptions.h'.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Get_Glyph_Name( FT_Face     face,
                     FT_UInt     glyph_index,
                     FT_Pointer  buffer,
                     FT_UInt     buffer_max );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Postscript_Name                                             */
/*                                                                       */
/* <Description>                                                         */
/*    Retrieve the ASCII PostScript name of a given face, if available.  */
/*    This only works with PostScript and TrueType fonts.                */
/*                                                                       */
/* <Input>                                                               */
/*    face :: A handle to the source face object.                        */
/*                                                                       */
/* <Return>                                                              */
/*    A pointer to the face's PostScript name.  NULL if unavailable.     */
/*                                                                       */
/* <Note>                                                                */
/*    The returned pointer is owned by the face and is destroyed with    */
/*    it.                                                                */
/*                                                                       */
  FT_EXPORT( const char* )
  FT_Get_Postscript_Name( FT_Face  face );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Select_Charmap                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Select a given charmap by its encoding tag (as listed in           */
/*    `freetype.h').                                                     */
/*                                                                       */
/* <InOut>                                                               */
/*    face     :: A handle to the source face object.                    */
/*                                                                       */
/* <Input>                                                               */
/*    encoding :: A handle to the selected encoding.                     */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    This function returns an error if no charmap in the face           */
/*    corresponds to the encoding queried here.                          */
/*                                                                       */
/*    Because many fonts contain more than a single cmap for Unicode     */
/*    encoding, this function has some special code to select the one    */
/*    which covers Unicode best (`best' in the sense that a UCS-4 cmap   */
/*    is preferred to a UCS-2 cmap).  It is thus preferable to           */
/*    @FT_Set_Charmap in this case.                                      */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Select_Charmap( FT_Face      face,
                     FT_Encoding  encoding );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Set_Charmap                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    Select a given charmap for character code to glyph index mapping.  */
/*                                                                       */
/* <InOut>                                                               */
/*    face    :: A handle to the source face object.                     */
/*                                                                       */
/* <Input>                                                               */
/*    charmap :: A handle to the selected charmap.                       */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    This function returns an error if the charmap is not part of       */
/*    the face (i.e., if it is not listed in the `face->charmaps'        */
/*    table).                                                            */
/*                                                                       */
/*    It also fails if a type~14 charmap is selected.                    */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Set_Charmap( FT_Face     face,
                  FT_CharMap  charmap );
/*************************************************************************
   *
   * @function:
   *   FT_Get_Charmap_Index
   *
   * @description:
   *   Retrieve index of a given charmap.
   *
   * @input:
   *   charmap ::
   *     A handle to a charmap.
   *
   * @return:
   *   The index into the array of character maps within the face to which
   *   `charmap' belongs.  If an error occurs, -1 is returned.
   *
   */
  FT_EXPORT( FT_Int )
  FT_Get_Charmap_Index( FT_CharMap  charmap );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Char_Index                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Return the glyph index of a given character code.  This function   */
/*    uses a charmap object to do the mapping.                           */
/*                                                                       */
/* <Input>                                                               */
/*    face     :: A handle to the source face object.                    */
/*                                                                       */
/*    charcode :: The character code.                                    */
/*                                                                       */
/* <Return>                                                              */
/*    The glyph index.  0~means `undefined character code'.              */
/*                                                                       */
/* <Note>                                                                */
/*    If you use FreeType to manipulate the contents of font files       */
/*    directly, be aware that the glyph index returned by this function  */
/*    doesn't always correspond to the internal indices used within the  */
/*    file.  This is done to ensure that value~0 always corresponds to   */
/*    the `missing glyph'.  If the first glyph is not named `.notdef',   */
/*    then for Type~1 and Type~42 fonts, `.notdef' will be moved into    */
/*    the glyph ID~0 position, and whatever was there will be moved to   */
/*    the position `.notdef' had.  For Type~1 fonts, if there is no      */
/*    `.notdef' glyph at all, then one will be created at index~0 and    */
/*    whatever was there will be moved to the last index -- Type~42      */
/*    fonts are considered invalid under this condition.                 */
/*                                                                       */
  FT_EXPORT( FT_UInt )
  FT_Get_Char_Index( FT_Face   face,
                     FT_ULong  charcode );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_First_Char                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    This function is used to return the first character code in the    */
/*    current charmap of a given face.  It also returns the              */
/*    corresponding glyph index.                                         */
/*                                                                       */
/* <Input>                                                               */
/*    face    :: A handle to the source face object.                     */
/*                                                                       */
/* <Output>                                                              */
/*    agindex :: Glyph index of first character code.  0~if charmap is   */
/*               empty.                                                  */
/*                                                                       */
/* <Return>                                                              */
/*    The charmap's first character code.                                */
/*                                                                       */
/* <Note>                                                                */
/*    You should use this function with @FT_Get_Next_Char to be able to  */
/*    parse all character codes available in a given charmap.  The code  */
/*    should look like this:                                             */
/*                                                                       */
/*    {                                                                  */
/*      FT_ULong  charcode;                                              */
/*      FT_UInt   gindex;                                                */
/*                                                                       */
/*                                                                       */
/*      charcode = FT_Get_First_Char( face, &gindex );                   */
/*      while ( gindex != 0 )                                            */
/*      {                                                                */
/*        ... do something with (charcode,gindex) pair ...               */
/*                                                                       */
/*        charcode = FT_Get_Next_Char( face, charcode, &gindex );        */
/*      }                                                                */
/*    }                                                                  */
/*                                                                       */
/*    Note that `*agindex' is set to~0 if the charmap is empty.  The     */
/*    result itself can be~0 in two cases: if the charmap is empty or    */
/*    if the value~0 is the first valid character code.                  */
/*                                                                       */
  FT_EXPORT( FT_ULong )
  FT_Get_First_Char( FT_Face   face,
                     FT_UInt  *agindex );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Next_Char                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    This function is used to return the next character code in the     */
/*    current charmap of a given face following the value `char_code',   */
/*    as well as the corresponding glyph index.                          */
/*                                                                       */
/* <Input>                                                               */
/*    face      :: A handle to the source face object.                   */
/*    char_code :: The starting character code.                          */
/*                                                                       */
/* <Output>                                                              */
/*    agindex   :: Glyph index of next character code.  0~if charmap     */
/*                 is empty.                                             */
/*                                                                       */
/* <Return>                                                              */
/*    The charmap's next character code.                                 */
/*                                                                       */
/* <Note>                                                                */
/*    You should use this function with @FT_Get_First_Char to walk       */
/*    over all character codes available in a given charmap.  See the    */
/*    note for this function for a simple code example.                  */
/*                                                                       */
/*    Note that `*agindex' is set to~0 when there are no more codes in   */
/*    the charmap.                                                       */
/*                                                                       */
  FT_EXPORT( FT_ULong )
  FT_Get_Next_Char( FT_Face    face,
                    FT_ULong   char_code,
                    FT_UInt   *agindex );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Name_Index                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Return the glyph index of a given glyph name.  This function uses  */
/*    driver specific objects to do the translation.                     */
/*                                                                       */
/* <Input>                                                               */
/*    face       :: A handle to the source face object.                  */
/*                                                                       */
/*    glyph_name :: The glyph name.                                      */
/*                                                                       */
/* <Return>                                                              */
/*    The glyph index.  0~means `undefined character code'.              */
/*                                                                       */
  FT_EXPORT( FT_UInt )
  FT_Get_Name_Index( FT_Face     face,
                     FT_String*  glyph_name );
/*************************************************************************
   *
   * @macro:
   *   FT_SUBGLYPH_FLAG_XXX
   *
   * @description:
   *   A list of constants used to describe subglyphs.  Please refer to the
   *   TrueType specification for the meaning of the various flags.
   *
   * @values:
   *   FT_SUBGLYPH_FLAG_ARGS_ARE_WORDS ::
   *   FT_SUBGLYPH_FLAG_ARGS_ARE_XY_VALUES ::
   *   FT_SUBGLYPH_FLAG_ROUND_XY_TO_GRID ::
   *   FT_SUBGLYPH_FLAG_SCALE ::
   *   FT_SUBGLYPH_FLAG_XY_SCALE ::
   *   FT_SUBGLYPH_FLAG_2X2 ::
   *   FT_SUBGLYPH_FLAG_USE_MY_METRICS ::
   *
   */
#define FT_SUBGLYPH_FLAG_ARGS_ARE_WORDS          1
#define FT_SUBGLYPH_FLAG_ARGS_ARE_XY_VALUES      2
#define FT_SUBGLYPH_FLAG_ROUND_XY_TO_GRID        4
#define FT_SUBGLYPH_FLAG_SCALE                   8
#define FT_SUBGLYPH_FLAG_XY_SCALE             0x40
#define FT_SUBGLYPH_FLAG_2X2                  0x80
#define FT_SUBGLYPH_FLAG_USE_MY_METRICS      0x200
/*************************************************************************
   *
   * @func:
   *   FT_Get_SubGlyph_Info
   *
   * @description:
   *   Retrieve a description of a given subglyph.  Only use it if
   *   `glyph->format' is @FT_GLYPH_FORMAT_COMPOSITE; an error is
   *   returned otherwise.
   *
   * @input:
   *   glyph ::
   *     The source glyph slot.
   *
   *   sub_index ::
   *     The index of the subglyph.  Must be less than
   *     `glyph->num_subglyphs'.
   *
   * @output:
   *   p_index ::
   *     The glyph index of the subglyph.
   *
   *   p_flags ::
   *     The subglyph flags, see @FT_SUBGLYPH_FLAG_XXX.
   *
   *   p_arg1 ::
   *     The subglyph's first argument (if any).
   *
   *   p_arg2 ::
   *     The subglyph's second argument (if any).
   *
   *   p_transform ::
   *     The subglyph transformation (if any).
   *
   * @return:
   *   FreeType error code.  0~means success.
   *
   * @note:
   *   The values of `*p_arg1', `*p_arg2', and `*p_transform' must be
   *   interpreted depending on the flags returned in `*p_flags'.  See the
   *   TrueType specification for details.
   *
   */
  FT_EXPORT( FT_Error )
  FT_Get_SubGlyph_Info( FT_GlyphSlot  glyph,
                        FT_UInt       sub_index,
                        FT_Int       *p_index,
                        FT_UInt      *p_flags,
                        FT_Int       *p_arg1,
                        FT_Int       *p_arg2,
                        FT_Matrix    *p_transform );
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_FSTYPE_XXX                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    A list of bit flags used in the `fsType' field of the OS/2 table   */
/*    in a TrueType or OpenType font and the `FSType' entry in a         */
/*    PostScript font.  These bit flags are returned by                  */
/*    @FT_Get_FSType_Flags; they inform client applications of embedding */
/*    and subsetting restrictions associated with a font.                */
/*                                                                       */
/*    See http://www.adobe.com/devnet/acrobat/pdfs/FontPolicies.pdf for  */
/*    more details.                                                      */
/*                                                                       */
/* <Values>                                                              */
/*    FT_FSTYPE_INSTALLABLE_EMBEDDING ::                                 */
/*      Fonts with no fsType bit set may be embedded and permanently     */
/*      installed on the remote system by an application.                */
/*                                                                       */
/*    FT_FSTYPE_RESTRICTED_LICENSE_EMBEDDING ::                          */
/*      Fonts that have only this bit set must not be modified, embedded */
/*      or exchanged in any manner without first obtaining permission of */
/*      the font software copyright owner.                               */
/*                                                                       */
/*    FT_FSTYPE_PREVIEW_AND_PRINT_EMBEDDING ::                           */
/*      If this bit is set, the font may be embedded and temporarily     */
/*      loaded on the remote system.  Documents containing Preview &     */
/*      Print fonts must be opened `read-only'; no edits can be applied  */
/*      to the document.                                                 */
/*                                                                       */
/*    FT_FSTYPE_EDITABLE_EMBEDDING ::                                    */
/*      If this bit is set, the font may be embedded but must only be    */
/*      installed temporarily on other systems.  In contrast to Preview  */
/*      & Print fonts, documents containing editable fonts may be opened */
/*      for reading, editing is permitted, and changes may be saved.     */
/*                                                                       */
/*    FT_FSTYPE_NO_SUBSETTING ::                                         */
/*      If this bit is set, the font may not be subsetted prior to       */
/*      embedding.                                                       */
/*                                                                       */
/*    FT_FSTYPE_BITMAP_EMBEDDING_ONLY ::                                 */
/*      If this bit is set, only bitmaps contained in the font may be    */
/*      embedded; no outline data may be embedded.  If there are no      */
/*      bitmaps available in the font, then the font is unembeddable.    */
/*                                                                       */
/* <Note>                                                                */
/*    While the fsType flags can indicate that a font may be embedded, a */
/*    license with the font vendor may be separately required to use the */
/*    font in this way.                                                  */
/*                                                                       */
#define FT_FSTYPE_INSTALLABLE_EMBEDDING         0x0000
#define FT_FSTYPE_RESTRICTED_LICENSE_EMBEDDING  0x0002
#define FT_FSTYPE_PREVIEW_AND_PRINT_EMBEDDING   0x0004
#define FT_FSTYPE_EDITABLE_EMBEDDING            0x0008
#define FT_FSTYPE_NO_SUBSETTING                 0x0100
#define FT_FSTYPE_BITMAP_EMBEDDING_ONLY         0x0200
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_FSType_Flags                                                */
/*                                                                       */
/* <Description>                                                         */
/*    Return the fsType flags for a font.                                */
/*                                                                       */
/* <Input>                                                               */
/*    face :: A handle to the source face object.                        */
/*                                                                       */
/* <Return>                                                              */
/*    The fsType flags, @FT_FSTYPE_XXX.                                  */
/*                                                                       */
/* <Note>                                                                */
/*    Use this function rather than directly reading the `fs_type' field */
/*    in the @PS_FontInfoRec structure which is only guaranteed to       */
/*    return the correct results for Type~1 fonts.                       */
/*                                                                       */
/* <Since>                                                               */
/*    2.3.8                                                              */
/*                                                                       */
  FT_EXPORT( FT_UShort )
  FT_Get_FSType_Flags( FT_Face  face );
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    glyph_variants                                                     */
/*                                                                       */
/* <Title>                                                               */
/*    Glyph Variants                                                     */
/*                                                                       */
/* <Abstract>                                                            */
/*    The FreeType~2 interface to Unicode Ideographic Variation          */
/*    Sequences (IVS), using the SFNT cmap format~14.                    */
/*                                                                       */
/* <Description>                                                         */
/*    Many CJK characters have variant forms.  They are a sort of grey   */
/*    area somewhere between being totally irrelevant and semantically   */
/*    distinct; for this reason, the Unicode consortium decided to       */
/*    introduce Ideographic Variation Sequences (IVS), consisting of a   */
/*    Unicode base character and one of 240 variant selectors            */
/*    (U+E0100-U+E01EF), instead of further extending the already huge   */
/*    code range for CJK characters.                                     */
/*                                                                       */
/*    An IVS is registered and unique; for further details please refer  */
/*    to Unicode Technical Standard #37, the Ideographic Variation       */
/*    Database:                                                          */
/*                                                                       */
/*      http://www.unicode.org/reports/tr37/                             */
/*                                                                       */
/*    To date (November 2012), the character with the most variants is   */
/*    U+9089, having 31 such IVS.                                        */
/*                                                                       */
/*    Adobe and MS decided to support IVS with a new cmap subtable       */
/*    (format~14).  It is an odd subtable because it is not a mapping of */
/*    input code points to glyphs, but contains lists of all variants    */
/*    supported by the font.                                             */
/*                                                                       */
/*    A variant may be either `default' or `non-default'.  A default     */
/*    variant is the one you will get for that code point if you look it */
/*    up in the standard Unicode cmap.  A non-default variant is a       */
/*    different glyph.                                                   */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Face_GetCharVariantIndex                                        */
/*                                                                       */
/* <Description>                                                         */
/*    Return the glyph index of a given character code as modified by    */
/*    the variation selector.                                            */
/*                                                                       */
/* <Input>                                                               */
/*    face ::                                                            */
/*      A handle to the source face object.                              */
/*                                                                       */
/*    charcode ::                                                        */
/*      The character code point in Unicode.                             */
/*                                                                       */
/*    variantSelector ::                                                 */
/*      The Unicode code point of the variation selector.                */
/*                                                                       */
/* <Return>                                                              */
/*    The glyph index.  0~means either `undefined character code', or    */
/*    `undefined selector code', or `no variation selector cmap          */
/*    subtable', or `current CharMap is not Unicode'.                    */
/*                                                                       */
/* <Note>                                                                */
/*    If you use FreeType to manipulate the contents of font files       */
/*    directly, be aware that the glyph index returned by this function  */
/*    doesn't always correspond to the internal indices used within      */
/*    the file.  This is done to ensure that value~0 always corresponds  */
/*    to the `missing glyph'.                                            */
/*                                                                       */
/*    This function is only meaningful if                                */
/*      a) the font has a variation selector cmap sub table,             */
/*    and                                                                */
/*      b) the current charmap has a Unicode encoding.                   */
/*                                                                       */
/* <Since>                                                               */
/*    2.3.6                                                              */
/*                                                                       */
  FT_EXPORT( FT_UInt )
  FT_Face_GetCharVariantIndex( FT_Face   face,
                               FT_ULong  charcode,
                               FT_ULong  variantSelector );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Face_GetCharVariantIsDefault                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Check whether this variant of this Unicode character is the one to */
/*    be found in the `cmap'.                                            */
/*                                                                       */
/* <Input>                                                               */
/*    face ::                                                            */
/*      A handle to the source face object.                              */
/*                                                                       */
/*    charcode ::                                                        */
/*      The character codepoint in Unicode.                              */
/*                                                                       */
/*    variantSelector ::                                                 */
/*      The Unicode codepoint of the variation selector.                 */
/*                                                                       */
/* <Return>                                                              */
/*    1~if found in the standard (Unicode) cmap, 0~if found in the       */
/*    variation selector cmap, or -1 if it is not a variant.             */
/*                                                                       */
/* <Note>                                                                */
/*    This function is only meaningful if the font has a variation       */
/*    selector cmap subtable.                                            */
/*                                                                       */
/* <Since>                                                               */
/*    2.3.6                                                              */
/*                                                                       */
  FT_EXPORT( FT_Int )
  FT_Face_GetCharVariantIsDefault( FT_Face   face,
                                   FT_ULong  charcode,
                                   FT_ULong  variantSelector );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Face_GetVariantSelectors                                        */
/*                                                                       */
/* <Description>                                                         */
/*    Return a zero-terminated list of Unicode variant selectors found   */
/*    in the font.                                                       */
/*                                                                       */
/* <Input>                                                               */
/*    face ::                                                            */
/*      A handle to the source face object.                              */
/*                                                                       */
/* <Return>                                                              */
/*    A pointer to an array of selector code points, or NULL if there is */
/*    no valid variant selector cmap subtable.                           */
/*                                                                       */
/* <Note>                                                                */
/*    The last item in the array is~0; the array is owned by the         */
/*    @FT_Face object but can be overwritten or released on the next     */
/*    call to a FreeType function.                                       */
/*                                                                       */
/* <Since>                                                               */
/*    2.3.6                                                              */
/*                                                                       */
  FT_EXPORT( FT_UInt32* )
  FT_Face_GetVariantSelectors( FT_Face  face );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Face_GetVariantsOfChar                                          */
/*                                                                       */
/* <Description>                                                         */
/*    Return a zero-terminated list of Unicode variant selectors found   */
/*    for the specified character code.                                  */
/*                                                                       */
/* <Input>                                                               */
/*    face ::                                                            */
/*      A handle to the source face object.                              */
/*                                                                       */
/*    charcode ::                                                        */
/*      The character codepoint in Unicode.                              */
/*                                                                       */
/* <Return>                                                              */
/*    A pointer to an array of variant selector code points which are    */
/*    active for the given character, or NULL if the corresponding list  */
/*    is empty.                                                          */
/*                                                                       */
/* <Note>                                                                */
/*    The last item in the array is~0; the array is owned by the         */
/*    @FT_Face object but can be overwritten or released on the next     */
/*    call to a FreeType function.                                       */
/*                                                                       */
/* <Since>                                                               */
/*    2.3.6                                                              */
/*                                                                       */
  FT_EXPORT( FT_UInt32* )
  FT_Face_GetVariantsOfChar( FT_Face   face,
                             FT_ULong  charcode );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Face_GetCharsOfVariant                                          */
/*                                                                       */
/* <Description>                                                         */
/*    Return a zero-terminated list of Unicode character codes found for */
/*    the specified variant selector.                                    */
/*                                                                       */
/* <Input>                                                               */
/*    face ::                                                            */
/*      A handle to the source face object.                              */
/*                                                                       */
/*    variantSelector ::                                                 */
/*      The variant selector code point in Unicode.                      */
/*                                                                       */
/* <Return>                                                              */
/*    A list of all the code points which are specified by this selector */
/*    (both default and non-default codes are returned) or NULL if there */
/*    is no valid cmap or the variant selector is invalid.               */
/*                                                                       */
/* <Note>                                                                */
/*    The last item in the array is~0; the array is owned by the         */
/*    @FT_Face object but can be overwritten or released on the next     */
/*    call to a FreeType function.                                       */
/*                                                                       */
/* <Since>                                                               */
/*    2.3.6                                                              */
/*                                                                       */
  FT_EXPORT( FT_UInt32* )
  FT_Face_GetCharsOfVariant( FT_Face   face,
                             FT_ULong  variantSelector );
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    computations                                                       */
/*                                                                       */
/* <Title>                                                               */
/*    Computations                                                       */
/*                                                                       */
/* <Abstract>                                                            */
/*    Crunching fixed numbers and vectors.                               */
/*                                                                       */
/* <Description>                                                         */
/*    This section contains various functions used to perform            */
/*    computations on 16.16 fixed-float numbers or 2d vectors.           */
/*                                                                       */
/* <Order>                                                               */
/*    FT_MulDiv                                                          */
/*    FT_MulFix                                                          */
/*    FT_DivFix                                                          */
/*    FT_RoundFix                                                        */
/*    FT_CeilFix                                                         */
/*    FT_FloorFix                                                        */
/*    FT_Vector_Transform                                                */
/*    FT_Matrix_Multiply                                                 */
/*    FT_Matrix_Invert                                                   */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_MulDiv                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A very simple function used to perform the computation `(a*b)/c'   */
/*    with maximum accuracy (it uses a 64-bit intermediate integer       */
/*    whenever necessary).                                               */
/*                                                                       */
/*    This function isn't necessarily as fast as some processor specific */
/*    operations, but is at least completely portable.                   */
/*                                                                       */
/* <Input>                                                               */
/*    a :: The first multiplier.                                         */
/*    b :: The second multiplier.                                        */
/*    c :: The divisor.                                                  */
/*                                                                       */
/* <Return>                                                              */
/*    The result of `(a*b)/c'.  This function never traps when trying to */
/*    divide by zero; it simply returns `MaxInt' or `MinInt' depending   */
/*    on the signs of `a' and `b'.                                       */
/*                                                                       */
  FT_EXPORT( FT_Long )
  FT_MulDiv( FT_Long  a,
             FT_Long  b,
             FT_Long  c );
/* */
/* The following #if 0 ... #endif is for the documentation formatter, */
/* hiding the internal `FT_MULFIX_INLINED' macro.                     */
#if 0
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_MulFix                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A very simple function used to perform the computation             */
/*    `(a*b)/0x10000' with maximum accuracy.  Most of the time this is   */
/*    used to multiply a given value by a 16.16 fixed float factor.      */
/*                                                                       */
/* <Input>                                                               */
/*    a :: The first multiplier.                                         */
/*    b :: The second multiplier.  Use a 16.16 factor here whenever      */
/*         possible (see note below).                                    */
/*                                                                       */
/* <Return>                                                              */
/*    The result of `(a*b)/0x10000'.                                     */
/*                                                                       */
/* <Note>                                                                */
/*    This function has been optimized for the case where the absolute   */
/*    value of `a' is less than 2048, and `b' is a 16.16 scaling factor. */
/*    As this happens mainly when scaling from notional units to         */
/*    fractional pixels in FreeType, it resulted in noticeable speed     */
/*    improvements between versions 2.x and 1.x.                         */
/*                                                                       */
/*    As a conclusion, always try to place a 16.16 factor as the         */
/*    _second_ argument of this function; this can make a great          */
/*    difference.                                                        */
/*                                                                       */
  FT_EXPORT( FT_Long )
  FT_MulFix( FT_Long  a,
             FT_Long  b );
/* */
#endif
#ifdef FT_MULFIX_INLINED
#define FT_MulFix( a, b )  FT_MULFIX_INLINED( a, b )
#else
  FT_EXPORT( FT_Long )
  FT_MulFix( FT_Long  a,
             FT_Long  b );
#endif
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_DivFix                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A very simple function used to perform the computation             */
/*    `(a*0x10000)/b' with maximum accuracy.  Most of the time, this is  */
/*    used to divide a given value by a 16.16 fixed float factor.        */
/*                                                                       */
/* <Input>                                                               */
/*    a :: The first multiplier.                                         */
/*    b :: The second multiplier.  Use a 16.16 factor here whenever      */
/*         possible (see note below).                                    */
/*                                                                       */
/* <Return>                                                              */
/*    The result of `(a*0x10000)/b'.                                     */
/*                                                                       */
/* <Note>                                                                */
/*    The optimization for FT_DivFix() is simple: If (a~<<~16) fits in   */
/*    32~bits, then the division is computed directly.  Otherwise, we    */
/*    use a specialized version of @FT_MulDiv.                           */
/*                                                                       */
  FT_EXPORT( FT_Long )
  FT_DivFix( FT_Long  a,
             FT_Long  b );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_RoundFix                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    A very simple function used to round a 16.16 fixed number.         */
/*                                                                       */
/* <Input>                                                               */
/*    a :: The number to be rounded.                                     */
/*                                                                       */
/* <Return>                                                              */
/*    The result of `(a + 0x8000) & -0x10000'.                           */
/*                                                                       */
  FT_EXPORT( FT_Fixed )
  FT_RoundFix( FT_Fixed  a );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_CeilFix                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    A very simple function used to compute the ceiling function of a   */
/*    16.16 fixed number.                                                */
/*                                                                       */
/* <Input>                                                               */
/*    a :: The number for which the ceiling function is to be computed.  */
/*                                                                       */
/* <Return>                                                              */
/*    The result of `(a + 0x10000 - 1) & -0x10000'.                      */
/*                                                                       */
  FT_EXPORT( FT_Fixed )
  FT_CeilFix( FT_Fixed  a );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_FloorFix                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    A very simple function used to compute the floor function of a     */
/*    16.16 fixed number.                                                */
/*                                                                       */
/* <Input>                                                               */
/*    a :: The number for which the floor function is to be computed.    */
/*                                                                       */
/* <Return>                                                              */
/*    The result of `a & -0x10000'.                                      */
/*                                                                       */
  FT_EXPORT( FT_Fixed )
  FT_FloorFix( FT_Fixed  a );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Vector_Transform                                                */
/*                                                                       */
/* <Description>                                                         */
/*    Transform a single vector through a 2x2 matrix.                    */
/*                                                                       */
/* <InOut>                                                               */
/*    vector :: The target vector to transform.                          */
/*                                                                       */
/* <Input>                                                               */
/*    matrix :: A pointer to the source 2x2 matrix.                      */
/*                                                                       */
/* <Note>                                                                */
/*    The result is undefined if either `vector' or `matrix' is invalid. */
/*                                                                       */
  FT_EXPORT( void )
  FT_Vector_Transform( FT_Vector*        vec,
                       const FT_Matrix*  matrix );
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    version                                                            */
/*                                                                       */
/* <Title>                                                               */
/*    FreeType Version                                                   */
/*                                                                       */
/* <Abstract>                                                            */
/*    Functions and macros related to FreeType versions.                 */
/*                                                                       */
/* <Description>                                                         */
/*    Note that those functions and macros are of limited use because    */
/*    even a new release of FreeType with only documentation changes     */
/*    increases the version number.                                      */
/*                                                                       */
/*************************************************************************/
/*************************************************************************
   *
   * @enum:
   *   FREETYPE_XXX
   *
   * @description:
   *   These three macros identify the FreeType source code version.
   *   Use @FT_Library_Version to access them at runtime.
   *
   * @values:
   *   FREETYPE_MAJOR :: The major version number.
   *   FREETYPE_MINOR :: The minor version number.
   *   FREETYPE_PATCH :: The patch level.
   *
   * @note:
   *   The version number of FreeType if built as a dynamic link library
   *   with the `libtool' package is _not_ controlled by these three
   *   macros.
   *
   */
#define FREETYPE_MAJOR  2
#define FREETYPE_MINOR  4
#define FREETYPE_PATCH  11
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Library_Version                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    Return the version of the FreeType library being used.  This is    */
/*    useful when dynamically linking to the library, since one cannot   */
/*    use the macros @FREETYPE_MAJOR, @FREETYPE_MINOR, and               */
/*    @FREETYPE_PATCH.                                                   */
/*                                                                       */
/* <Input>                                                               */
/*    library :: A source library handle.                                */
/*                                                                       */
/* <Output>                                                              */
/*    amajor  :: The major version number.                               */
/*                                                                       */
/*    aminor  :: The minor version number.                               */
/*                                                                       */
/*    apatch  :: The patch version number.                               */
/*                                                                       */
/* <Note>                                                                */
/*    The reason why this function takes a `library' argument is because */
/*    certain programs implement library initialization in a custom way  */
/*    that doesn't use @FT_Init_FreeType.                                */
/*                                                                       */
/*    In such cases, the library version might not be available before   */
/*    the library object has been created.                               */
/*                                                                       */
  FT_EXPORT( void )
  FT_Library_Version( FT_Library   library,
                      FT_Int      *amajor,
                      FT_Int      *aminor,
                      FT_Int      *apatch );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Face_CheckTrueTypePatents                                       */
/*                                                                       */
/* <Description>                                                         */
/*    Parse all bytecode instructions of a TrueType font file to check   */
/*    whether any of the patented opcodes are used.  This is only useful */
/*    if you want to be able to use the unpatented hinter with           */
/*    fonts that do *not* use these opcodes.                             */
/*                                                                       */
/*    Note that this function parses *all* glyph instructions in the     */
/*    font file, which may be slow.                                      */
/*                                                                       */
/* <Input>                                                               */
/*    face :: A face handle.                                             */
/*                                                                       */
/* <Return>                                                              */
/*    1~if this is a TrueType font that uses one of the patented         */
/*    opcodes, 0~otherwise.                                              */
/*                                                                       */
/* <Note>                                                                */
/*    Since May 2010, TrueType hinting is no longer patented.            */
/*                                                                       */
/* <Since>                                                               */
/*    2.3.5                                                              */
/*                                                                       */
  FT_EXPORT( FT_Bool )
  FT_Face_CheckTrueTypePatents( FT_Face  face );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Face_SetUnpatentedHinting                                       */
/*                                                                       */
/* <Description>                                                         */
/*    Enable or disable the unpatented hinter for a given face.          */
/*    Only enable it if you have determined that the face doesn't        */
/*    use any patented opcodes (see @FT_Face_CheckTrueTypePatents).      */
/*                                                                       */
/* <Input>                                                               */
/*    face  :: A face handle.                                            */
/*                                                                       */
/*    value :: New boolean setting.                                      */
/*                                                                       */
/* <Return>                                                              */
/*    The old setting value.  This will always be false if this is not   */
/*    an SFNT font, or if the unpatented hinter is not compiled in this  */
/*    instance of the library.                                           */
/*                                                                       */
/* <Note>                                                                */
/*    Since May 2010, TrueType hinting is no longer patented.            */
/*                                                                       */
/* <Since>                                                               */
/*    2.3.5                                                              */
/*                                                                       */
  FT_EXPORT( FT_Bool )
  FT_Face_SetUnpatentedHinting( FT_Face  face,
                                FT_Bool  value );
/* */
FT_END_HEADER
/* END */
FT_BEGIN_HEADER
/* force the definition of FT_DEBUG_LEVEL_ERROR if FT_DEBUG_LEVEL_TRACE */
/* is already defined; this simplifies the following #ifdefs            */
/*                                                                      */
/*************************************************************************/
/*                                                                       */
/* Define the trace enums as well as the trace levels array when they    */
/* are needed.                                                           */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Define the FT_TRACE macro                                             */
/*                                                                       */
/* IMPORTANT!                                                            */
/*                                                                       */
/* Each component must define the macro FT_COMPONENT to a valid FT_Trace */
/* value before using any TRACE macro.                                   */
/*                                                                       */
/*************************************************************************/
/* nothing */
#define FT_TRACE( level, varformat )  do { } while ( 0 )       
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Trace_Get_Count                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    Return the number of available trace components.                   */
/*                                                                       */
/* <Return>                                                              */
/*    The number of trace components.  0 if FreeType 2 is not built with */
/*    FT_DEBUG_LEVEL_TRACE definition.                                   */
/*                                                                       */
/* <Note>                                                                */
/*    This function may be useful if you want to access elements of      */
/*    the internal `ft_trace_levels' array by an index.                  */
/*                                                                       */
  FT_BASE( FT_Int )
  FT_Trace_Get_Count( void );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Trace_Get_Name                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Return the name of a trace component.                              */
/*                                                                       */
/* <Input>                                                               */
/*    The index of the trace component.                                  */
/*                                                                       */
/* <Return>                                                              */
/*    The name of the trace component.  This is a statically allocated   */
/*    C string, so do not free it after use.  NULL if FreeType 2 is not  */
/*    built with FT_DEBUG_LEVEL_TRACE definition.                        */
/*                                                                       */
/* <Note>                                                                */
/*    Use @FT_Trace_Get_Count to get the number of available trace       */
/*    components.                                                        */
/*                                                                       */
/*    This function may be useful if you want to control FreeType 2's    */
/*    debug level in your application.                                   */
/*                                                                       */
  FT_BASE( const char * )
  FT_Trace_Get_Name( FT_Int  idx );
/*************************************************************************/
/*                                                                       */
/* You need two opening and closing parentheses!                         */
/*                                                                       */
/* Example: FT_TRACE0(( "Value is %i", foo ))                            */
/*                                                                       */
/* Output of the FT_TRACEX macros is sent to stderr.                     */
/*                                                                       */
/*************************************************************************/
#define FT_TRACE0( varformat )  FT_TRACE( 0, varformat )
#define FT_TRACE1( varformat )  FT_TRACE( 1, varformat )
#define FT_TRACE2( varformat )  FT_TRACE( 2, varformat )
#define FT_TRACE3( varformat )  FT_TRACE( 3, varformat )
#define FT_TRACE4( varformat )  FT_TRACE( 4, varformat )
#define FT_TRACE5( varformat )  FT_TRACE( 5, varformat )
#define FT_TRACE6( varformat )  FT_TRACE( 6, varformat )
#define FT_TRACE7( varformat )  FT_TRACE( 7, varformat )
/*************************************************************************/
/*                                                                       */
/* Define the FT_ERROR macro.                                            */
/*                                                                       */
/* Output of this macro is sent to stderr.                               */
/*                                                                       */
/*************************************************************************/
/* nothing */
#define FT_ERROR( varformat )  do { } while ( 0 )       
/*************************************************************************/
/*                                                                       */
/* Define the FT_ASSERT macro.                                           */
/*                                                                       */
/*************************************************************************/
#define FT_ASSERT( condition )  do { } while ( 0 )
/*************************************************************************/
/*                                                                       */
/* Define `FT_Message' and `FT_Panic' when needed.                       */
/*                                                                       */
/*************************************************************************/
  FT_BASE( void )
  ft_debug_init( void );
/* Visual C++ (and Intel C++) */
#if defined( _MSC_VER )       
/* We disable the warning `conditional expression is constant' here */
/* in order to compile cleanly with the maximum level of warnings.  */
#pragma warning( disable : 4127 )
/* _MSC_VER */
#endif  
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftstream.h                                                             */
/*                                                                         */
/*    Stream handling (specification).                                     */
/*                                                                         */
/*  Copyright 1996-2002, 2004-2006, 2011 by                                */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTSTREAM_H__
/***************************************************************************/
/*                                                                         */
/*  ftobjs.h                                                               */
/*                                                                         */
/*    The FreeType private base classes (specification).                   */
/*                                                                         */
/*  Copyright 1996-2006, 2008, 2010, 2012 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/*  This file contains the definition of all internal FreeType classes.  */
/*                                                                       */
/*************************************************************************/
#define __FTOBJS_H__
/***************************************************************************/
/*                                                                         */
/*  ftrender.h                                                             */
/*                                                                         */
/*    FreeType renderer modules public interface (specification).          */
/*                                                                         */
/*  Copyright 1996-2001, 2005, 2006, 2010 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTRENDER_H__
/***************************************************************************/
/*                                                                         */
/*  ftmodapi.h                                                             */
/*                                                                         */
/*    FreeType modules public interface (specification).                   */
/*                                                                         */
/*  Copyright 1996-2003, 2006, 2008-2010, 2012 by                          */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTMODAPI_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    module_management                                                  */
/*                                                                       */
/* <Title>                                                               */
/*    Module Management                                                  */
/*                                                                       */
/* <Abstract>                                                            */
/*    How to add, upgrade, remove, and control modules from FreeType.    */
/*                                                                       */
/* <Description>                                                         */
/*    The definitions below are used to manage modules within FreeType.  */
/*    Modules can be added, upgraded, and removed at runtime.            */
/*    Additionally, some module properties can be controlled also.       */
/*                                                                       */
/*    Here is a list of possible values of the `module_name' field in    */
/*    the @FT_Module_Class structure.                                    */
/*                                                                       */
/*    {                                                                  */
/*      autofitter                                                       */
/*      bdf                                                              */
/*      cff                                                              */
/*      gxvalid                                                          */
/*      otvalid                                                          */
/*      pcf                                                              */
/*      pfr                                                              */
/*      psaux                                                            */
/*      pshinter                                                         */
/*      psnames                                                          */
/*      raster1, raster5                                                 */
/*      sfnt                                                             */
/*      smooth, smooth-lcd, smooth-lcdv                                  */
/*      truetype                                                         */
/*      type1                                                            */
/*      type42                                                           */
/*      t1cid                                                            */
/*      winfonts                                                         */
/*    }                                                                  */
/*                                                                       */
/*    Note that the FreeType Cache sub-system is not a FreeType module.  */
/*                                                                       */
/*************************************************************************/
/* module bit flags */
/* this module is a font driver  */
#define FT_MODULE_FONT_DRIVER         1   
/* this module is a renderer     */
#define FT_MODULE_RENDERER            2   
/* this module is a glyph hinter */
#define FT_MODULE_HINTER              4   
/* this module is a styler       */
#define FT_MODULE_STYLER              8   
/* the driver supports      */
#define FT_MODULE_DRIVER_SCALABLE     0x100    
/* scalable fonts           */
/* the driver does not      */
#define FT_MODULE_DRIVER_NO_OUTLINES  0x200    
/* support vector outlines  */
/* the driver provides its  */
#define FT_MODULE_DRIVER_HAS_HINTER   0x400    
/* own hinter               */
/* deprecated values */
#define ft_module_font_driver         FT_MODULE_FONT_DRIVER
#define ft_module_renderer            FT_MODULE_RENDERER
#define ft_module_hinter              FT_MODULE_HINTER
#define ft_module_styler              FT_MODULE_STYLER
#define ft_module_driver_scalable     FT_MODULE_DRIVER_SCALABLE
#define ft_module_driver_no_outlines  FT_MODULE_DRIVER_NO_OUTLINES
#define ft_module_driver_has_hinter   FT_MODULE_DRIVER_HAS_HINTER
  typedef FT_Pointer  FT_Module_Interface;
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Module_Constructor                                              */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to initialize (not create) a new module object.    */
/*                                                                       */
/* <Input>                                                               */
/*    module :: The module to initialize.                                */
/*                                                                       */
  typedef FT_Error
  (*FT_Module_Constructor)( FT_Module  module );
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Module_Destructor                                               */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to finalize (not destroy) a given module object.   */
/*                                                                       */
/* <Input>                                                               */
/*    module :: The module to finalize.                                  */
/*                                                                       */
  typedef void
  (*FT_Module_Destructor)( FT_Module  module );
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_Module_Requester                                                */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to query a given module for a specific interface.  */
/*                                                                       */
/* <Input>                                                               */
/*    module :: The module to be searched.                               */
/*                                                                       */
/*    name ::   The name of the interface in the module.                 */
/*                                                                       */
  typedef FT_Module_Interface
  (*FT_Module_Requester)( FT_Module    module,
                          const char*  name );
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Module_Class                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    The module class descriptor.                                       */
/*                                                                       */
/* <Fields>                                                              */
/*    module_flags    :: Bit flags describing the module.                */
/*                                                                       */
/*    module_size     :: The size of one module object/instance in       */
/*                       bytes.                                          */
/*                                                                       */
/*    module_name     :: The name of the module.                         */
/*                                                                       */
/*    module_version  :: The version, as a 16.16 fixed number            */
/*                       (major.minor).                                  */
/*                                                                       */
/*    module_requires :: The version of FreeType this module requires,   */
/*                       as a 16.16 fixed number (major.minor).  Starts  */
/*                       at version 2.0, i.e., 0x20000.                  */
/*                                                                       */
/*    module_init     :: The initializing function.                      */
/*                                                                       */
/*    module_done     :: The finalizing function.                        */
/*                                                                       */
/*    get_interface   :: The interface requesting function.              */
/*                                                                       */
  typedef struct  FT_Module_Class_
  {
    FT_ULong               module_flags;
    FT_Long                module_size;
    const FT_String*       module_name;
    FT_Fixed               module_version;
    FT_Fixed               module_requires;
    const void*            module_interface;
    FT_Module_Constructor  module_init;
    FT_Module_Destructor   module_done;
    FT_Module_Requester    get_interface;
  } FT_Module_Class;
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Add_Module                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    Add a new module to a given library instance.                      */
/*                                                                       */
/* <InOut>                                                               */
/*    library :: A handle to the library object.                         */
/*                                                                       */
/* <Input>                                                               */
/*    clazz   :: A pointer to class descriptor for the module.           */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    An error will be returned if a module already exists by that name, */
/*    or if the module requires a version of FreeType that is too great. */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Add_Module( FT_Library              library,
                 const FT_Module_Class*  clazz );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Module                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    Find a module by its name.                                         */
/*                                                                       */
/* <Input>                                                               */
/*    library     :: A handle to the library object.                     */
/*                                                                       */
/*    module_name :: The module's name (as an ASCII string).             */
/*                                                                       */
/* <Return>                                                              */
/*    A module handle.  0~if none was found.                             */
/*                                                                       */
/* <Note>                                                                */
/*    FreeType's internal modules aren't documented very well, and you   */
/*    should look up the source code for details.                        */
/*                                                                       */
  FT_EXPORT( FT_Module )
  FT_Get_Module( FT_Library   library,
                 const char*  module_name );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Remove_Module                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Remove a given module from a library instance.                     */
/*                                                                       */
/* <InOut>                                                               */
/*    library :: A handle to a library object.                           */
/*                                                                       */
/* <Input>                                                               */
/*    module  :: A handle to a module object.                            */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    The module object is destroyed by the function in case of success. */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Remove_Module( FT_Library  library,
                    FT_Module   module );
/**********************************************************************
   *
   * @function:
   *    FT_Property_Set
   *
   * @description:
   *    Set a property for a given module.
   *
   * @input:
   *    library ::
   *       A handle to the library the module is part of.
   *
   *    module_name ::
   *       The module name.
   *
   *    property_name ::
   *       The property name.  Properties are described in the `Synopsis'
   *       subsection of the module's documentation.
   *
   *       Note that only a few modules have properties.
   *
   *    value ::
   *       A generic pointer to a variable or structure which gives the new
   *       value of the property.  The exact definition of `value' is
   *       dependent on the property; see the `Synopsis' subsection of the
   *       module's documentation.
   *
   * @return:
   *   FreeType error code.  0~means success.
   *
   * @note:
   *    If `module_name' isn't a valid module name, or `property_name'
   *    doesn't specify a valid property, or if `value' doesn't represent a
   *    valid value for the given property, an error is returned.
   *
   *    The following example sets property `bar' (a simple integer) in
   *    module `foo' to value~1.
   *
   *    {
   *      FT_UInt  bar;
   *
   *
   *      bar = 1;
   *      FT_Property_Set( library, "foo", "bar", &bar );
   *    }
   *
   *    It is not possible to set properties of the FreeType Cache
   *    sub-system with FT_Property_Set; use @FTC_Property_Set instead.
   *
   *  @since:
   *    2.4.11
   *
   */
  FT_Error
  FT_Property_Set( FT_Library        library,
                   const FT_String*  module_name,
                   const FT_String*  property_name,
                   const void*       value );
/**********************************************************************
   *
   * @function:
   *    FT_Property_Get
   *
   * @description:
   *    Get a module's property value.
   *
   * @input:
   *    library ::
   *       A handle to the library the module is part of.
   *
   *    module_name ::
   *       The module name.
   *
   *    property_name ::
   *       The property name.  Properties are described in the `Synopsis'
   *       subsection of the module's documentation.
   *
   * @inout:
   *    value ::
   *       A generic pointer to a variable or structure which gives the
   *       value of the property.  The exact definition of `value' is
   *       dependent on the property; see the `Synopsis' subsection of the
   *       module's documentation.
   *
   * @return:
   *   FreeType error code.  0~means success.
   *
   * @note:
   *    If `module_name' isn't a valid module name, or `property_name'
   *    doesn't specify a valid property, or if `value' doesn't represent a
   *    valid value for the given property, an error is returned.
   *
   *    The following example gets property `baz' (a range) in module `foo'.
   *
   *    {
   *      typedef  range_
   *      {
   *        FT_Int32  min;
   *        FT_Int32  max;
   *
   *      } range;
   *
   *      range  baz;
   *
   *
   *      FT_Property_Get( library, "foo", "baz", &baz );
   *    }
   *
   *    It is not possible to retrieve properties of the FreeType Cache
   *    sub-system with FT_Property_Get; use @FTC_Property_Get instead.
   *
   *  @since:
   *    2.4.11
   *
   */
  FT_Error
  FT_Property_Get( FT_Library        library,
                   const FT_String*  module_name,
                   const FT_String*  property_name,
                   void*             value );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Reference_Library                                               */
/*                                                                       */
/* <Description>                                                         */
/*    A counter gets initialized to~1 at the time an @FT_Library         */
/*    structure is created.  This function increments the counter.       */
/*    @FT_Done_Library then only destroys a library if the counter is~1, */
/*    otherwise it simply decrements the counter.                        */
/*                                                                       */
/*    This function helps in managing life-cycles of structures which    */
/*    reference @FT_Library objects.                                     */
/*                                                                       */
/* <Input>                                                               */
/*    library :: A handle to a target library object.                    */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Since>                                                               */
/*    2.4.2                                                              */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Reference_Library( FT_Library  library );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_New_Library                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    This function is used to create a new FreeType library instance    */
/*    from a given memory object.  It is thus possible to use libraries  */
/*    with distinct memory allocators within the same program.           */
/*                                                                       */
/*    Normally, you would call this function (followed by a call to      */
/*    @FT_Add_Default_Modules or a series of calls to @FT_Add_Module)    */
/*    instead of @FT_Init_FreeType to initialize the FreeType library.   */
/*                                                                       */
/*    Don't use @FT_Done_FreeType but @FT_Done_Library to destroy a      */
/*    library instance.                                                  */
/*                                                                       */
/* <Input>                                                               */
/*    memory   :: A handle to the original memory object.                */
/*                                                                       */
/* <Output>                                                              */
/*    alibrary :: A pointer to handle of a new library object.           */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    See the discussion of reference counters in the description of     */
/*    @FT_Reference_Library.                                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_New_Library( FT_Memory    memory,
                  FT_Library  *alibrary );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Done_Library                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Discard a given library object.  This closes all drivers and       */
/*    discards all resource objects.                                     */
/*                                                                       */
/* <Input>                                                               */
/*    library :: A handle to the target library.                         */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    See the discussion of reference counters in the description of     */
/*    @FT_Reference_Library.                                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Done_Library( FT_Library  library );
/* */
  typedef void
  (*FT_DebugHook_Func)( void*  arg );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Set_Debug_Hook                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Set a debug hook function for debugging the interpreter of a font  */
/*    format.                                                            */
/*                                                                       */
/* <InOut>                                                               */
/*    library    :: A handle to the library object.                      */
/*                                                                       */
/* <Input>                                                               */
/*    hook_index :: The index of the debug hook.  You should use the     */
/*                  values defined in `ftobjs.h', e.g.,                  */
/*                  `FT_DEBUG_HOOK_TRUETYPE'.                            */
/*                                                                       */
/*    debug_hook :: The function used to debug the interpreter.          */
/*                                                                       */
/* <Note>                                                                */
/*    Currently, four debug hook slots are available, but only two (for  */
/*    the TrueType and the Type~1 interpreter) are defined.              */
/*                                                                       */
/*    Since the internal headers of FreeType are no longer installed,    */
/*    the symbol `FT_DEBUG_HOOK_TRUETYPE' isn't available publicly.      */
/*    This is a bug and will be fixed in a forthcoming release.          */
/*                                                                       */
  FT_EXPORT( void )
  FT_Set_Debug_Hook( FT_Library         library,
                     FT_UInt            hook_index,
                     FT_DebugHook_Func  debug_hook );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Add_Default_Modules                                             */
/*                                                                       */
/* <Description>                                                         */
/*    Add the set of default drivers to a given library object.          */
/*    This is only useful when you create a library object with          */
/*    @FT_New_Library (usually to plug a custom memory manager).         */
/*                                                                       */
/* <InOut>                                                               */
/*    library :: A handle to a new library object.                       */
/*                                                                       */
  FT_EXPORT( void )
  FT_Add_Default_Modules( FT_Library  library );
/**************************************************************************
   *
   * @section:
   *   truetype_engine
   *
   * @title:
   *   The TrueType Engine
   *
   * @abstract:
   *   TrueType bytecode support.
   *
   * @description:
   *   This section contains a function used to query the level of TrueType
   *   bytecode support compiled in this version of the library.
   *
   */
/**************************************************************************
   *
   *  @enum:
   *     FT_TrueTypeEngineType
   *
   *  @description:
   *     A list of values describing which kind of TrueType bytecode
   *     engine is implemented in a given FT_Library instance.  It is used
   *     by the @FT_Get_TrueType_Engine_Type function.
   *
   *  @values:
   *     FT_TRUETYPE_ENGINE_TYPE_NONE ::
   *       The library doesn't implement any kind of bytecode interpreter.
   *
   *     FT_TRUETYPE_ENGINE_TYPE_UNPATENTED ::
   *       The library implements a bytecode interpreter that doesn't
   *       support the patented operations of the TrueType virtual machine.
   *
   *       Its main use is to load certain Asian fonts which position and
   *       scale glyph components with bytecode instructions.  It produces
   *       bad output for most other fonts.
   *
   *     FT_TRUETYPE_ENGINE_TYPE_PATENTED ::
   *       The library implements a bytecode interpreter that covers
   *       the full instruction set of the TrueType virtual machine (this
   *       was governed by patents until May 2010, hence the name).
   *
   *  @since:
   *     2.2
   *
   */
  typedef enum  FT_TrueTypeEngineType_
  {
    FT_TRUETYPE_ENGINE_TYPE_NONE = 0,
    FT_TRUETYPE_ENGINE_TYPE_UNPATENTED,
    FT_TRUETYPE_ENGINE_TYPE_PATENTED
  } FT_TrueTypeEngineType;
/**************************************************************************
   *
   *  @func:
   *     FT_Get_TrueType_Engine_Type
   *
   *  @description:
   *     Return an @FT_TrueTypeEngineType value to indicate which level of
   *     the TrueType virtual machine a given library instance supports.
   *
   *  @input:
   *     library ::
   *       A library instance.
   *
   *  @return:
   *     A value indicating which level is supported.
   *
   *  @since:
   *     2.2
   *
   */
  FT_EXPORT( FT_TrueTypeEngineType )
  FT_Get_TrueType_Engine_Type( FT_Library  library );
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftglyph.h                                                              */
/*                                                                         */
/*    FreeType convenience functions to handle glyphs (specification).     */
/*                                                                         */
/*  Copyright 1996-2003, 2006, 2008, 2009, 2011 by                         */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This file contains the definition of several convenience functions    */
/* that can be used by client applications to easily retrieve glyph      */
/* bitmaps and outlines from a given face.                               */
/*                                                                       */
/* These functions should be optional if you are writing a font server   */
/* or text layout engine on top of FreeType.  However, they are pretty   */
/* handy for many other simple uses of the library.                      */
/*                                                                       */
/*************************************************************************/
#define __FTGLYPH_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    glyph_management                                                   */
/*                                                                       */
/* <Title>                                                               */
/*    Glyph Management                                                   */
/*                                                                       */
/* <Abstract>                                                            */
/*    Generic interface to manage individual glyph data.                 */
/*                                                                       */
/* <Description>                                                         */
/*    This section contains definitions used to manage glyph data        */
/*    through generic FT_Glyph objects.  Each of them can contain a      */
/*    bitmap, a vector outline, or even images in other formats.         */
/*                                                                       */
/*************************************************************************/
/* forward declaration to a private type */
  typedef struct FT_Glyph_Class_  FT_Glyph_Class;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_Glyph                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    Handle to an object used to model generic glyph images.  It is a   */
/*    pointer to the @FT_GlyphRec structure and can contain a glyph      */
/*    bitmap or pointer.                                                 */
/*                                                                       */
/* <Note>                                                                */
/*    Glyph objects are not owned by the library.  You must thus release */
/*    them manually (through @FT_Done_Glyph) _before_ calling            */
/*    @FT_Done_FreeType.                                                 */
/*                                                                       */
  typedef struct FT_GlyphRec_*  FT_Glyph;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_GlyphRec                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    The root glyph structure contains a given glyph image plus its     */
/*    advance width in 16.16 fixed float format.                         */
/*                                                                       */
/* <Fields>                                                              */
/*    library :: A handle to the FreeType library object.                */
/*                                                                       */
/*    clazz   :: A pointer to the glyph's class.  Private.               */
/*                                                                       */
/*    format  :: The format of the glyph's image.                        */
/*                                                                       */
/*    advance :: A 16.16 vector that gives the glyph's advance width.    */
/*                                                                       */
  typedef struct  FT_GlyphRec_
  {
    FT_Library             library;
    const FT_Glyph_Class*  clazz;
    FT_Glyph_Format        format;
    FT_Vector              advance;
  } FT_GlyphRec;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_BitmapGlyph                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to an object used to model a bitmap glyph image.  This is */
/*    a sub-class of @FT_Glyph, and a pointer to @FT_BitmapGlyphRec.     */
/*                                                                       */
  typedef struct FT_BitmapGlyphRec_*  FT_BitmapGlyph;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_BitmapGlyphRec                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used for bitmap glyph images.  This really is a        */
/*    `sub-class' of @FT_GlyphRec.                                       */
/*                                                                       */
/* <Fields>                                                              */
/*    root   :: The root @FT_Glyph fields.                               */
/*                                                                       */
/*    left   :: The left-side bearing, i.e., the horizontal distance     */
/*              from the current pen position to the left border of the  */
/*              glyph bitmap.                                            */
/*                                                                       */
/*    top    :: The top-side bearing, i.e., the vertical distance from   */
/*              the current pen position to the top border of the glyph  */
/*              bitmap.  This distance is positive for upwards~y!        */
/*                                                                       */
/*    bitmap :: A descriptor for the bitmap.                             */
/*                                                                       */
/* <Note>                                                                */
/*    You can typecast an @FT_Glyph to @FT_BitmapGlyph if you have       */
/*    `glyph->format == FT_GLYPH_FORMAT_BITMAP'.  This lets you access   */
/*    the bitmap's contents easily.                                      */
/*                                                                       */
/*    The corresponding pixel buffer is always owned by @FT_BitmapGlyph  */
/*    and is thus created and destroyed with it.                         */
/*                                                                       */
  typedef struct  FT_BitmapGlyphRec_
  {
    FT_GlyphRec  root;
    FT_Int       left;
    FT_Int       top;
    FT_Bitmap    bitmap;
  } FT_BitmapGlyphRec;
/*************************************************************************/
/*                                                                       */
/* <Type>                                                                */
/*    FT_OutlineGlyph                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    A handle to an object used to model an outline glyph image.  This  */
/*    is a sub-class of @FT_Glyph, and a pointer to @FT_OutlineGlyphRec. */
/*                                                                       */
  typedef struct FT_OutlineGlyphRec_*  FT_OutlineGlyph;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_OutlineGlyphRec                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used for outline (vectorial) glyph images.  This       */
/*    really is a `sub-class' of @FT_GlyphRec.                           */
/*                                                                       */
/* <Fields>                                                              */
/*    root    :: The root @FT_Glyph fields.                              */
/*                                                                       */
/*    outline :: A descriptor for the outline.                           */
/*                                                                       */
/* <Note>                                                                */
/*    You can typecast an @FT_Glyph to @FT_OutlineGlyph if you have      */
/*    `glyph->format == FT_GLYPH_FORMAT_OUTLINE'.  This lets you access  */
/*    the outline's content easily.                                      */
/*                                                                       */
/*    As the outline is extracted from a glyph slot, its coordinates are */
/*    expressed normally in 26.6 pixels, unless the flag                 */
/*    @FT_LOAD_NO_SCALE was used in @FT_Load_Glyph() or @FT_Load_Char(). */
/*                                                                       */
/*    The outline's tables are always owned by the object and are        */
/*    destroyed with it.                                                 */
/*                                                                       */
  typedef struct  FT_OutlineGlyphRec_
  {
    FT_GlyphRec  root;
    FT_Outline   outline;
  } FT_OutlineGlyphRec;
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Glyph                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to extract a glyph image from a slot.  Note that   */
/*    the created @FT_Glyph object must be released with @FT_Done_Glyph. */
/*                                                                       */
/* <Input>                                                               */
/*    slot   :: A handle to the source glyph slot.                       */
/*                                                                       */
/* <Output>                                                              */
/*    aglyph :: A handle to the glyph object.                            */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Get_Glyph( FT_GlyphSlot  slot,
                FT_Glyph     *aglyph );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Glyph_Copy                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    A function used to copy a glyph image.  Note that the created      */
/*    @FT_Glyph object must be released with @FT_Done_Glyph.             */
/*                                                                       */
/* <Input>                                                               */
/*    source :: A handle to the source glyph object.                     */
/*                                                                       */
/* <Output>                                                              */
/*    target :: A handle to the target glyph object.  0~in case of       */
/*              error.                                                   */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Glyph_Copy( FT_Glyph   source,
                 FT_Glyph  *target );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Glyph_Transform                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    Transform a glyph image if its format is scalable.                 */
/*                                                                       */
/* <InOut>                                                               */
/*    glyph  :: A handle to the target glyph object.                     */
/*                                                                       */
/* <Input>                                                               */
/*    matrix :: A pointer to a 2x2 matrix to apply.                      */
/*                                                                       */
/*    delta  :: A pointer to a 2d vector to apply.  Coordinates are      */
/*              expressed in 1/64th of a pixel.                          */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code (if not 0, the glyph format is not scalable).  */
/*                                                                       */
/* <Note>                                                                */
/*    The 2x2 transformation matrix is also applied to the glyph's       */
/*    advance vector.                                                    */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Glyph_Transform( FT_Glyph    glyph,
                      FT_Matrix*  matrix,
                      FT_Vector*  delta );
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    FT_Glyph_BBox_Mode                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    The mode how the values of @FT_Glyph_Get_CBox are returned.        */
/*                                                                       */
/* <Values>                                                              */
/*    FT_GLYPH_BBOX_UNSCALED ::                                          */
/*      Return unscaled font units.                                      */
/*                                                                       */
/*    FT_GLYPH_BBOX_SUBPIXELS ::                                         */
/*      Return unfitted 26.6 coordinates.                                */
/*                                                                       */
/*    FT_GLYPH_BBOX_GRIDFIT ::                                           */
/*      Return grid-fitted 26.6 coordinates.                             */
/*                                                                       */
/*    FT_GLYPH_BBOX_TRUNCATE ::                                          */
/*      Return coordinates in integer pixels.                            */
/*                                                                       */
/*    FT_GLYPH_BBOX_PIXELS ::                                            */
/*      Return grid-fitted pixel coordinates.                            */
/*                                                                       */
  typedef enum  FT_Glyph_BBox_Mode_
  {
    FT_GLYPH_BBOX_UNSCALED  = 0,
    FT_GLYPH_BBOX_SUBPIXELS = 0,
    FT_GLYPH_BBOX_GRIDFIT   = 1,
    FT_GLYPH_BBOX_TRUNCATE  = 2,
    FT_GLYPH_BBOX_PIXELS    = 3
  } FT_Glyph_BBox_Mode;
/*************************************************************************/
/*                                                                       */
/* <Enum>                                                                */
/*    ft_glyph_bbox_xxx                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    These constants are deprecated.  Use the corresponding             */
/*    @FT_Glyph_BBox_Mode values instead.                                */
/*                                                                       */
/* <Values>                                                              */
/*   ft_glyph_bbox_unscaled  :: See @FT_GLYPH_BBOX_UNSCALED.             */
/*   ft_glyph_bbox_subpixels :: See @FT_GLYPH_BBOX_SUBPIXELS.            */
/*   ft_glyph_bbox_gridfit   :: See @FT_GLYPH_BBOX_GRIDFIT.              */
/*   ft_glyph_bbox_truncate  :: See @FT_GLYPH_BBOX_TRUNCATE.             */
/*   ft_glyph_bbox_pixels    :: See @FT_GLYPH_BBOX_PIXELS.               */
/*                                                                       */
#define ft_glyph_bbox_unscaled   FT_GLYPH_BBOX_UNSCALED
#define ft_glyph_bbox_subpixels  FT_GLYPH_BBOX_SUBPIXELS
#define ft_glyph_bbox_gridfit    FT_GLYPH_BBOX_GRIDFIT
#define ft_glyph_bbox_truncate   FT_GLYPH_BBOX_TRUNCATE
#define ft_glyph_bbox_pixels     FT_GLYPH_BBOX_PIXELS
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Glyph_Get_CBox                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Return a glyph's `control box'.  The control box encloses all the  */
/*    outline's points, including Bézier control points.  Though it      */
/*    coincides with the exact bounding box for most glyphs, it can be   */
/*    slightly larger in some situations (like when rotating an outline  */
/*    which contains Bézier outside arcs).                               */
/*                                                                       */
/*    Computing the control box is very fast, while getting the bounding */
/*    box can take much more time as it needs to walk over all segments  */
/*    and arcs in the outline.  To get the latter, you can use the       */
/*    `ftbbox' component which is dedicated to this single task.         */
/*                                                                       */
/* <Input>                                                               */
/*    glyph :: A handle to the source glyph object.                      */
/*                                                                       */
/*    mode  :: The mode which indicates how to interpret the returned    */
/*             bounding box values.                                      */
/*                                                                       */
/* <Output>                                                              */
/*    acbox :: The glyph coordinate bounding box.  Coordinates are       */
/*             expressed in 1/64th of pixels if it is grid-fitted.       */
/*                                                                       */
/* <Note>                                                                */
/*    Coordinates are relative to the glyph origin, using the y~upwards  */
/*    convention.                                                        */
/*                                                                       */
/*    If the glyph has been loaded with @FT_LOAD_NO_SCALE, `bbox_mode'   */
/*    must be set to @FT_GLYPH_BBOX_UNSCALED to get unscaled font        */
/*    units in 26.6 pixel format.  The value @FT_GLYPH_BBOX_SUBPIXELS    */
/*    is another name for this constant.                                 */
/*                                                                       */
/*    If the font is tricky and the glyph has been loaded with           */
/*    @FT_LOAD_NO_SCALE, the resulting CBox is meaningless.  To get      */
/*    reasonable values for the CBox it is necessary to load the glyph   */
/*    at a large ppem value (so that the hinting instructions can        */
/*    properly shift and scale the subglyphs), then extracting the CBox  */
/*    which can be eventually converted back to font units.              */
/*                                                                       */
/*    Note that the maximum coordinates are exclusive, which means that  */
/*    one can compute the width and height of the glyph image (be it in  */
/*    integer or 26.6 pixels) as:                                        */
/*                                                                       */
/*    {                                                                  */
/*      width  = bbox.xMax - bbox.xMin;                                  */
/*      height = bbox.yMax - bbox.yMin;                                  */
/*    }                                                                  */
/*                                                                       */
/*    Note also that for 26.6 coordinates, if `bbox_mode' is set to      */
/*    @FT_GLYPH_BBOX_GRIDFIT, the coordinates will also be grid-fitted,  */
/*    which corresponds to:                                              */
/*                                                                       */
/*    {                                                                  */
/*      bbox.xMin = FLOOR(bbox.xMin);                                    */
/*      bbox.yMin = FLOOR(bbox.yMin);                                    */
/*      bbox.xMax = CEILING(bbox.xMax);                                  */
/*      bbox.yMax = CEILING(bbox.yMax);                                  */
/*    }                                                                  */
/*                                                                       */
/*    To get the bbox in pixel coordinates, set `bbox_mode' to           */
/*    @FT_GLYPH_BBOX_TRUNCATE.                                           */
/*                                                                       */
/*    To get the bbox in grid-fitted pixel coordinates, set `bbox_mode'  */
/*    to @FT_GLYPH_BBOX_PIXELS.                                          */
/*                                                                       */
  FT_EXPORT( void )
  FT_Glyph_Get_CBox( FT_Glyph  glyph,
                     FT_UInt   bbox_mode,
                     FT_BBox  *acbox );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Glyph_To_Bitmap                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    Convert a given glyph object to a bitmap glyph object.             */
/*                                                                       */
/* <InOut>                                                               */
/*    the_glyph   :: A pointer to a handle to the target glyph.          */
/*                                                                       */
/* <Input>                                                               */
/*    render_mode :: An enumeration that describes how the data is       */
/*                   rendered.                                           */
/*                                                                       */
/*    origin      :: A pointer to a vector used to translate the glyph   */
/*                   image before rendering.  Can be~0 (if no            */
/*                   translation).  The origin is expressed in           */
/*                   26.6 pixels.                                        */
/*                                                                       */
/*    destroy     :: A boolean that indicates that the original glyph    */
/*                   image should be destroyed by this function.  It is  */
/*                   never destroyed in case of error.                   */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    This function does nothing if the glyph format isn't scalable.     */
/*                                                                       */
/*    The glyph image is translated with the `origin' vector before      */
/*    rendering.                                                         */
/*                                                                       */
/*    The first parameter is a pointer to an @FT_Glyph handle, that will */
/*    be _replaced_ by this function (with newly allocated data).        */
/*    Typically, you would use (omitting error handling):                */
/*                                                                       */
/*                                                                       */
/*      {                                                                */
/*        FT_Glyph        glyph;                                         */
/*        FT_BitmapGlyph  glyph_bitmap;                                  */
/*                                                                       */
/*                                                                       */
/*        // load glyph                                                  */
/*        error = FT_Load_Char( face, glyph_index, FT_LOAD_DEFAUT );     */
/*                                                                       */
/*        // extract glyph image                                         */
/*        error = FT_Get_Glyph( face->glyph, &glyph );                   */
/*                                                                       */
/*        // convert to a bitmap (default render mode + destroying old)  */
/*        if ( glyph->format != FT_GLYPH_FORMAT_BITMAP )                 */
/*        {                                                              */
/*          error = FT_Glyph_To_Bitmap( &glyph, FT_RENDER_MODE_NORMAL,   */
/*                                      0, 1 );                          */
/*          if ( error ) // `glyph' unchanged                            */
/*            ...                                                        */
/*        }                                                              */
/*                                                                       */
/*        // access bitmap content by typecasting                        */
/*        glyph_bitmap = (FT_BitmapGlyph)glyph;                          */
/*                                                                       */
/*        // do funny stuff with it, like blitting/drawing               */
/*        ...                                                            */
/*                                                                       */
/*        // discard glyph image (bitmap or not)                         */
/*        FT_Done_Glyph( glyph );                                        */
/*      }                                                                */
/*                                                                       */
/*                                                                       */
/*    Here another example, again without error handling:                */
/*                                                                       */
/*                                                                       */
/*      {                                                                */
/*        FT_Glyph  glyphs[MAX_GLYPHS]                                   */
/*                                                                       */
/*                                                                       */
/*        ...                                                            */
/*                                                                       */
/*        for ( idx = 0; i < MAX_GLYPHS; i++ )                           */
/*          error = FT_Load_Glyph( face, idx, FT_LOAD_DEFAULT ) ||       */
/*                  FT_Get_Glyph ( face->glyph, &glyph[idx] );           */
/*                                                                       */
/*        ...                                                            */
/*                                                                       */
/*        for ( idx = 0; i < MAX_GLYPHS; i++ )                           */
/*        {                                                              */
/*          FT_Glyph  bitmap = glyphs[idx];                              */
/*                                                                       */
/*                                                                       */
/*          ...                                                          */
/*                                                                       */
/*          // after this call, `bitmap' no longer points into           */
/*          // the `glyphs' array (and the old value isn't destroyed)    */
/*          FT_Glyph_To_Bitmap( &bitmap, FT_RENDER_MODE_MONO, 0, 0 );    */
/*                                                                       */
/*          ...                                                          */
/*                                                                       */
/*          FT_Done_Glyph( bitmap );                                     */
/*        }                                                              */
/*                                                                       */
/*        ...                                                            */
/*                                                                       */
/*        for ( idx = 0; i < MAX_GLYPHS; i++ )                           */
/*          FT_Done_Glyph( glyphs[idx] );                                */
/*      }                                                                */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Glyph_To_Bitmap( FT_Glyph*       the_glyph,
                      FT_Render_Mode  render_mode,
                      FT_Vector*      origin,
                      FT_Bool         destroy );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Done_Glyph                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    Destroy a given glyph.                                             */
/*                                                                       */
/* <Input>                                                               */
/*    glyph :: A handle to the target glyph object.                      */
/*                                                                       */
  FT_EXPORT( void )
  FT_Done_Glyph( FT_Glyph  glyph );
/* */
/* other helpful functions */
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    computations                                                       */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Matrix_Multiply                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    Perform the matrix operation `b = a*b'.                            */
/*                                                                       */
/* <Input>                                                               */
/*    a :: A pointer to matrix `a'.                                      */
/*                                                                       */
/* <InOut>                                                               */
/*    b :: A pointer to matrix `b'.                                      */
/*                                                                       */
/* <Note>                                                                */
/*    The result is undefined if either `a' or `b' is zero.              */
/*                                                                       */
  FT_EXPORT( void )
  FT_Matrix_Multiply( const FT_Matrix*  a,
                      FT_Matrix*        b );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Matrix_Invert                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Invert a 2x2 matrix.  Return an error if it can't be inverted.     */
/*                                                                       */
/* <InOut>                                                               */
/*    matrix :: A pointer to the target matrix.  Remains untouched in    */
/*              case of error.                                           */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Matrix_Invert( FT_Matrix*  matrix );
/* */
FT_END_HEADER
/* END */
/* Local Variables: */
/* coding: utf-8    */
/* End:             */
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    module_management                                                  */
/*                                                                       */
/*************************************************************************/
/* create a new glyph object */
  typedef FT_Error
  (*FT_Glyph_InitFunc)( FT_Glyph      glyph,
                        FT_GlyphSlot  slot );
/* destroys a given glyph object */
  typedef void
  (*FT_Glyph_DoneFunc)( FT_Glyph  glyph );
  typedef void
  (*FT_Glyph_TransformFunc)( FT_Glyph          glyph,
                             const FT_Matrix*  matrix,
                             const FT_Vector*  delta );
  typedef void
  (*FT_Glyph_GetBBoxFunc)( FT_Glyph  glyph,
                           FT_BBox*  abbox );
  typedef FT_Error
  (*FT_Glyph_CopyFunc)( FT_Glyph   source,
                        FT_Glyph   target );
  typedef FT_Error
  (*FT_Glyph_PrepareFunc)( FT_Glyph      glyph,
                           FT_GlyphSlot  slot );
/* deprecated */
#define FT_Glyph_Init_Func       FT_Glyph_InitFunc
#define FT_Glyph_Done_Func       FT_Glyph_DoneFunc
#define FT_Glyph_Transform_Func  FT_Glyph_TransformFunc
#define FT_Glyph_BBox_Func       FT_Glyph_GetBBoxFunc
#define FT_Glyph_Copy_Func       FT_Glyph_CopyFunc
#define FT_Glyph_Prepare_Func    FT_Glyph_PrepareFunc
  struct  FT_Glyph_Class_
  {
    FT_Long                 glyph_size;
    FT_Glyph_Format         glyph_format;
    FT_Glyph_InitFunc       glyph_init;
    FT_Glyph_DoneFunc       glyph_done;
    FT_Glyph_CopyFunc       glyph_copy;
    FT_Glyph_TransformFunc  glyph_transform;
    FT_Glyph_GetBBoxFunc    glyph_bbox;
    FT_Glyph_PrepareFunc    glyph_prepare;
  };
  typedef FT_Error
  (*FT_Renderer_RenderFunc)( FT_Renderer       renderer,
                             FT_GlyphSlot      slot,
                             FT_UInt           mode,
                             const FT_Vector*  origin );
  typedef FT_Error
  (*FT_Renderer_TransformFunc)( FT_Renderer       renderer,
                                FT_GlyphSlot      slot,
                                const FT_Matrix*  matrix,
                                const FT_Vector*  delta );
  typedef void
  (*FT_Renderer_GetCBoxFunc)( FT_Renderer   renderer,
                              FT_GlyphSlot  slot,
                              FT_BBox*      cbox );
  typedef FT_Error
  (*FT_Renderer_SetModeFunc)( FT_Renderer  renderer,
                              FT_ULong     mode_tag,
                              FT_Pointer   mode_ptr );
/* deprecated identifiers */
#define FTRenderer_render  FT_Renderer_RenderFunc
#define FTRenderer_transform  FT_Renderer_TransformFunc
#define FTRenderer_getCBox  FT_Renderer_GetCBoxFunc
#define FTRenderer_setMode  FT_Renderer_SetModeFunc
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Renderer_Class                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    The renderer module class descriptor.                              */
/*                                                                       */
/* <Fields>                                                              */
/*    root            :: The root @FT_Module_Class fields.               */
/*                                                                       */
/*    glyph_format    :: The glyph image format this renderer handles.   */
/*                                                                       */
/*    render_glyph    :: A method used to render the image that is in a  */
/*                       given glyph slot into a bitmap.                 */
/*                                                                       */
/*    transform_glyph :: A method used to transform the image that is in */
/*                       a given glyph slot.                             */
/*                                                                       */
/*    get_glyph_cbox  :: A method used to access the glyph's cbox.       */
/*                                                                       */
/*    set_mode        :: A method used to pass additional parameters.    */
/*                                                                       */
/*    raster_class    :: For @FT_GLYPH_FORMAT_OUTLINE renderers only.    */
/*                       This is a pointer to its raster's class.        */
/*                                                                       */
  typedef struct  FT_Renderer_Class_
  {
    FT_Module_Class            root;
    FT_Glyph_Format            glyph_format;
    FT_Renderer_RenderFunc     render_glyph;
    FT_Renderer_TransformFunc  transform_glyph;
    FT_Renderer_GetCBoxFunc    get_glyph_cbox;
    FT_Renderer_SetModeFunc    set_mode;
    FT_Raster_Funcs*           raster_class;
  } FT_Renderer_Class;
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Renderer                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Retrieve the current renderer for a given glyph format.            */
/*                                                                       */
/* <Input>                                                               */
/*    library :: A handle to the library object.                         */
/*                                                                       */
/*    format  :: The glyph format.                                       */
/*                                                                       */
/* <Return>                                                              */
/*    A renderer handle.  0~if none found.                               */
/*                                                                       */
/* <Note>                                                                */
/*    An error will be returned if a module already exists by that name, */
/*    or if the module requires a version of FreeType that is too great. */
/*                                                                       */
/*    To add a new renderer, simply use @FT_Add_Module.  To retrieve a   */
/*    renderer by its name, use @FT_Get_Module.                          */
/*                                                                       */
  FT_EXPORT( FT_Renderer )
  FT_Get_Renderer( FT_Library       library,
                   FT_Glyph_Format  format );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Set_Renderer                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Set the current renderer to use, and set additional mode.          */
/*                                                                       */
/* <InOut>                                                               */
/*    library    :: A handle to the library object.                      */
/*                                                                       */
/* <Input>                                                               */
/*    renderer   :: A handle to the renderer object.                     */
/*                                                                       */
/*    num_params :: The number of additional parameters.                 */
/*                                                                       */
/*    parameters :: Additional parameters.                               */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    In case of success, the renderer will be used to convert glyph     */
/*    images in the renderer's known format into bitmaps.                */
/*                                                                       */
/*    This doesn't change the current renderer for other formats.        */
/*                                                                       */
/*    Currently, only the B/W renderer, if compiled with                 */
/*    FT_RASTER_OPTION_ANTI_ALIASING (providing a 5-levels               */
/*    anti-aliasing mode; this option must be set directly in            */
/*    `ftraster.c' and is undefined by default) accepts a single tag     */
/*    `pal5' to set its gray palette as a character string with          */
/*    5~elements.  Consequently, the third and fourth argument are zero  */
/*    normally.                                                          */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Set_Renderer( FT_Library     library,
                   FT_Renderer    renderer,
                   FT_UInt        num_params,
                   FT_Parameter*  parameters );
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftsizes.h                                                              */
/*                                                                         */
/*    FreeType size objects management (specification).                    */
/*                                                                         */
/*  Copyright 1996-2001, 2003, 2004, 2006, 2009 by                         */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Typical application would normally not need to use these functions.   */
/* However, they have been placed in a public API for the rare cases     */
/* where they are needed.                                                */
/*                                                                       */
/*************************************************************************/
#define __FTSIZES_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    sizes_management                                                   */
/*                                                                       */
/* <Title>                                                               */
/*    Size Management                                                    */
/*                                                                       */
/* <Abstract>                                                            */
/*    Managing multiple sizes per face.                                  */
/*                                                                       */
/* <Description>                                                         */
/*    When creating a new face object (e.g., with @FT_New_Face), an      */
/*    @FT_Size object is automatically created and used to store all     */
/*    pixel-size dependent information, available in the `face->size'    */
/*    field.                                                             */
/*                                                                       */
/*    It is however possible to create more sizes for a given face,      */
/*    mostly in order to manage several character pixel sizes of the     */
/*    same font family and style.  See @FT_New_Size and @FT_Done_Size.   */
/*                                                                       */
/*    Note that @FT_Set_Pixel_Sizes and @FT_Set_Char_Size only           */
/*    modify the contents of the current `active' size; you thus need    */
/*    to use @FT_Activate_Size to change it.                             */
/*                                                                       */
/*    99% of applications won't need the functions provided here,        */
/*    especially if they use the caching sub-system, so be cautious      */
/*    when using these.                                                  */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_New_Size                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    Create a new size object from a given face object.                 */
/*                                                                       */
/* <Input>                                                               */
/*    face :: A handle to a parent face object.                          */
/*                                                                       */
/* <Output>                                                              */
/*    asize :: A handle to a new size object.                            */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    You need to call @FT_Activate_Size in order to select the new size */
/*    for upcoming calls to @FT_Set_Pixel_Sizes, @FT_Set_Char_Size,      */
/*    @FT_Load_Glyph, @FT_Load_Char, etc.                                */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_New_Size( FT_Face   face,
               FT_Size*  size );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Done_Size                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    Discard a given size object.  Note that @FT_Done_Face              */
/*    automatically discards all size objects allocated with             */
/*    @FT_New_Size.                                                      */
/*                                                                       */
/* <Input>                                                               */
/*    size :: A handle to a target size object.                          */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Done_Size( FT_Size  size );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Activate_Size                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Even though it is possible to create several size objects for a    */
/*    given face (see @FT_New_Size for details), functions like          */
/*    @FT_Load_Glyph or @FT_Load_Char only use the one which has been    */
/*    activated last to determine the `current character pixel size'.    */
/*                                                                       */
/*    This function can be used to `activate' a previously created size  */
/*    object.                                                            */
/*                                                                       */
/* <Input>                                                               */
/*    size :: A handle to a target size object.                          */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    If `face' is the size's parent face object, this function changes  */
/*    the value of `face->size' to the input size handle.                */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Activate_Size( FT_Size  size );
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftlcdfil.h                                                             */
/*                                                                         */
/*    FreeType API for color filtering of subpixel bitmap glyphs           */
/*    (specification).                                                     */
/*                                                                         */
/*  Copyright 2006, 2007, 2008, 2010 by                                    */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#ifndef __FT_LCD_FILTER_H__
#define __FT_LCD_FILTER_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/***************************************************************************
   *
   * @section:
   *   lcd_filtering
   *
   * @title:
   *   LCD Filtering
   *
   * @abstract:
   *   Reduce color fringes of LCD-optimized bitmaps.
   *
   * @description:
   *   The @FT_Library_SetLcdFilter API can be used to specify a low-pass
   *   filter which is then applied to LCD-optimized bitmaps generated
   *   through @FT_Render_Glyph.  This is useful to reduce color fringes
   *   which would occur with unfiltered rendering.
   *
   *   Note that no filter is active by default, and that this function is
   *   *not* implemented in default builds of the library.  You need to
   *   #define FT_CONFIG_OPTION_SUBPIXEL_RENDERING in your `ftoption.h' file
   *   in order to activate it.
   */
/****************************************************************************
   *
   * @enum:
   *   FT_LcdFilter
   *
   * @description:
   *   A list of values to identify various types of LCD filters.
   *
   * @values:
   *   FT_LCD_FILTER_NONE ::
   *     Do not perform filtering.  When used with subpixel rendering, this
   *     results in sometimes severe color fringes.
   *
   *   FT_LCD_FILTER_DEFAULT ::
   *     The default filter reduces color fringes considerably, at the cost
   *     of a slight blurriness in the output.
   *
   *   FT_LCD_FILTER_LIGHT ::
   *     The light filter is a variant that produces less blurriness at the
   *     cost of slightly more color fringes than the default one.  It might
   *     be better, depending on taste, your monitor, or your personal vision.
   *
   *   FT_LCD_FILTER_LEGACY ::
   *     This filter corresponds to the original libXft color filter.  It
   *     provides high contrast output but can exhibit really bad color
   *     fringes if glyphs are not extremely well hinted to the pixel grid.
   *     In other words, it only works well if the TrueType bytecode
   *     interpreter is enabled *and* high-quality hinted fonts are used.
   *
   *     This filter is only provided for comparison purposes, and might be
   *     disabled or stay unsupported in the future.
   *
   * @since:
   *   2.3.0
   */
  typedef enum  FT_LcdFilter_
  {
    FT_LCD_FILTER_NONE    = 0,
    FT_LCD_FILTER_DEFAULT = 1,
    FT_LCD_FILTER_LIGHT   = 2,
    FT_LCD_FILTER_LEGACY  = 16,
/* do not remove */
    FT_LCD_FILTER_MAX    
  } FT_LcdFilter;
/**************************************************************************
   *
   * @func:
   *   FT_Library_SetLcdFilter
   *
   * @description:
   *   This function is used to apply color filtering to LCD decimated
   *   bitmaps, like the ones used when calling @FT_Render_Glyph with
   *   @FT_RENDER_MODE_LCD or @FT_RENDER_MODE_LCD_V.
   *
   * @input:
   *   library ::
   *     A handle to the target library instance.
   *
   *   filter ::
   *     The filter type.
   *
   *     You can use @FT_LCD_FILTER_NONE here to disable this feature, or
   *     @FT_LCD_FILTER_DEFAULT to use a default filter that should work
   *     well on most LCD screens.
   *
   * @return:
   *   FreeType error code.  0~means success.
   *
   * @note:
   *   This feature is always disabled by default.  Clients must make an
   *   explicit call to this function with a `filter' value other than
   *   @FT_LCD_FILTER_NONE in order to enable it.
   *
   *   Due to *PATENTS* covering subpixel rendering, this function doesn't
   *   do anything except returning `FT_Err_Unimplemented_Feature' if the
   *   configuration macro FT_CONFIG_OPTION_SUBPIXEL_RENDERING is not
   *   defined in your build of the library, which should correspond to all
   *   default builds of FreeType.
   *
   *   The filter affects glyph bitmaps rendered through @FT_Render_Glyph,
   *   @FT_Outline_Get_Bitmap, @FT_Load_Glyph, and @FT_Load_Char.
   *
   *   It does _not_ affect the output of @FT_Outline_Render and
   *   @FT_Outline_Get_Bitmap.
   *
   *   If this feature is activated, the dimensions of LCD glyph bitmaps are
   *   either larger or taller than the dimensions of the corresponding
   *   outline with regards to the pixel grid.  For example, for
   *   @FT_RENDER_MODE_LCD, the filter adds up to 3~pixels to the left, and
   *   up to 3~pixels to the right.
   *
   *   The bitmap offset values are adjusted correctly, so clients shouldn't
   *   need to modify their layout and glyph positioning code when enabling
   *   the filter.
   *
   * @since:
   *   2.3.0
   */
  FT_EXPORT( FT_Error )
  FT_Library_SetLcdFilter( FT_Library    library,
                           FT_LcdFilter  filter );
/**************************************************************************
   *
   * @func:
   *   FT_Library_SetLcdFilterWeights
   *
   * @description:
   *   Use this function to override the filter weights selected by
   *   @FT_Library_SetLcdFilter.  By default, FreeType uses the quintuple
   *   (0x00, 0x55, 0x56, 0x55, 0x00) for FT_LCD_FILTER_LIGHT, and (0x10,
   *   0x40, 0x70, 0x40, 0x10) for FT_LCD_FILTER_DEFAULT and
   *   FT_LCD_FILTER_LEGACY.
   *
   * @input:
   *   library ::
   *     A handle to the target library instance.
   *
   *   weights ::
   *     A pointer to an array; the function copies the first five bytes and
   *     uses them to specify the filter weights.
   *
   * @return:
   *   FreeType error code.  0~means success.
   *
   * @note:
   *   Due to *PATENTS* covering subpixel rendering, this function doesn't
   *   do anything except returning `FT_Err_Unimplemented_Feature' if the
   *   configuration macro FT_CONFIG_OPTION_SUBPIXEL_RENDERING is not
   *   defined in your build of the library, which should correspond to all
   *   default builds of FreeType.
   *
   *   This function must be called after @FT_Library_SetLcdFilter to have
   *   any effect.
   *
   * @since:
   *   2.4.0
   */
  FT_EXPORT( FT_Error )
  FT_Library_SetLcdFilterWeights( FT_Library      library,
                                  unsigned char  *weights );
/* */
FT_END_HEADER
/* __FT_LCD_FILTER_H__ */
#endif  
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftmemory.h                                                             */
/*                                                                         */
/*    The FreeType memory management macros (specification).               */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2004, 2005, 2006, 2007, 2010 by             */
/*  David Turner, Robert Wilhelm, and Werner Lemberg                       */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTMEMORY_H__
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_SET_ERROR                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    This macro is used to set an implicit `error' variable to a given  */
/*    expression's value (usually a function call), and convert it to a  */
/*    boolean which is set whenever the value is != 0.                   */
/*                                                                       */
#undef  FT_SET_ERROR
#define FT_SET_ERROR( expression ) \
          ( ( error = (expression) ) != 0 )
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****                           M E M O R Y                           ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*
   *  C++ refuses to handle statements like p = (void*)anything, with `p' a
   *  typed pointer.  Since we don't have a `typeof' operator in standard
   *  C++, we have to use a template to emulate it.
   */
#ifdef __cplusplus
  extern "C++"
  template <typename T> inline T*
  cplusplus_typeof(        T*,
                    void  *v )
  {
    return static_cast <T*> ( v );
  }
#define FT_ASSIGNP( p, val )  (p) = cplusplus_typeof( (p), (val) )
#else
#define FT_ASSIGNP( p, val )  (p) = (val)
#endif
#define FT_DEBUG_INNER( exp )       (exp)
#define FT_ASSIGNP_INNER( p, exp )  FT_ASSIGNP( p, exp )
/*
   *  The allocation functions return a pointer, and the error code
   *  is written to through the `p_error' parameter.  See below for
   *  for documentation.
   */
  FT_BASE( FT_Pointer )
  ft_mem_alloc( FT_Memory  memory,
                FT_Long    size,
                FT_Error  *p_error );
  FT_BASE( FT_Pointer )
  ft_mem_qalloc( FT_Memory  memory,
                 FT_Long    size,
                 FT_Error  *p_error );
  FT_BASE( FT_Pointer )
  ft_mem_realloc( FT_Memory  memory,
                  FT_Long    item_size,
                  FT_Long    cur_count,
                  FT_Long    new_count,
                  void*      block,
                  FT_Error  *p_error );
  FT_BASE( FT_Pointer )
  ft_mem_qrealloc( FT_Memory  memory,
                   FT_Long    item_size,
                   FT_Long    cur_count,
                   FT_Long    new_count,
                   void*      block,
                   FT_Error  *p_error );
  FT_BASE( void )
  ft_mem_free( FT_Memory    memory,
               const void*  P );
#define FT_MEM_ALLOC( ptr, size )                                         \
          FT_ASSIGNP_INNER( ptr, ft_mem_alloc( memory, (size), &error ) )
#define FT_MEM_FREE( ptr )                \
          FT_BEGIN_STMNT                  \
            ft_mem_free( memory, (ptr) ); \
            (ptr) = NULL;                 \
          FT_END_STMNT
#define FT_MEM_NEW( ptr )                        \
          FT_MEM_ALLOC( ptr, sizeof ( *(ptr) ) )
#define FT_MEM_REALLOC( ptr, cursz, newsz )                        \
          FT_ASSIGNP_INNER( ptr, ft_mem_realloc( memory, 1,        \
                                                 (cursz), (newsz), \
                                                 (ptr), &error ) )
#define FT_MEM_QALLOC( ptr, size )                                         \
          FT_ASSIGNP_INNER( ptr, ft_mem_qalloc( memory, (size), &error ) )
#define FT_MEM_QNEW( ptr )                        \
          FT_MEM_QALLOC( ptr, sizeof ( *(ptr) ) )
#define FT_MEM_QREALLOC( ptr, cursz, newsz )                         \
          FT_ASSIGNP_INNER( ptr, ft_mem_qrealloc( memory, 1,        \
                                                  (cursz), (newsz), \
                                                  (ptr), &error ) )
#define FT_MEM_QRENEW_ARRAY( ptr, cursz, newsz )                             \
          FT_ASSIGNP_INNER( ptr, ft_mem_qrealloc( memory, sizeof ( *(ptr) ), \
                                                  (cursz), (newsz),          \
                                                  (ptr), &error ) )
#define FT_MEM_ALLOC_MULT( ptr, count, item_size )                    \
          FT_ASSIGNP_INNER( ptr, ft_mem_realloc( memory, (item_size), \
                                                 0, (count),          \
                                                 NULL, &error ) )
#define FT_MEM_REALLOC_MULT( ptr, oldcnt, newcnt, itmsz )            \
          FT_ASSIGNP_INNER( ptr, ft_mem_realloc( memory, (itmsz),    \
                                                 (oldcnt), (newcnt), \
                                                 (ptr), &error ) )
#define FT_MEM_QALLOC_MULT( ptr, count, item_size )                    \
          FT_ASSIGNP_INNER( ptr, ft_mem_qrealloc( memory, (item_size), \
                                                  0, (count),          \
                                                  NULL, &error ) )
#define FT_MEM_QREALLOC_MULT( ptr, oldcnt, newcnt, itmsz)             \
          FT_ASSIGNP_INNER( ptr, ft_mem_qrealloc( memory, (itmsz),    \
                                                  (oldcnt), (newcnt), \
                                                  (ptr), &error ) )
#define FT_MEM_SET_ERROR( cond )  ( (cond), error != 0 )
#define FT_MEM_SET( dest, byte, count )     ft_memset( dest, byte, count )
#define FT_MEM_COPY( dest, source, count )  ft_memcpy( dest, source, count )
#define FT_MEM_MOVE( dest, source, count )  ft_memmove( dest, source, count )
#define FT_MEM_ZERO( dest, count )  FT_MEM_SET( dest, 0, count )
#define FT_ZERO( p )                FT_MEM_ZERO( p, sizeof ( *(p) ) )
#define FT_ARRAY_ZERO( dest, count )                        \
          FT_MEM_ZERO( dest, (count) * sizeof ( *(dest) ) )
#define FT_ARRAY_COPY( dest, source, count )                        \
          FT_MEM_COPY( dest, source, (count) * sizeof ( *(dest) ) )
#define FT_ARRAY_MOVE( dest, source, count )                        \
          FT_MEM_MOVE( dest, source, (count) * sizeof ( *(dest) ) )
/*
   *  Return the maximum number of addressable elements in an array.
   *  We limit ourselves to INT_MAX, rather than UINT_MAX, to avoid
   *  any problems.
   */
#define FT_ARRAY_MAX( ptr )           ( FT_INT_MAX / sizeof ( *(ptr) ) )
#define FT_ARRAY_CHECK( ptr, count )  ( (count) <= FT_ARRAY_MAX( ptr ) )
/*************************************************************************/
/*                                                                       */
/* The following functions macros expect that their pointer argument is  */
/* _typed_ in order to automatically compute array element sizes.        */
/*                                                                       */
#define FT_MEM_NEW_ARRAY( ptr, count )                                      \
          FT_ASSIGNP_INNER( ptr, ft_mem_realloc( memory, sizeof ( *(ptr) ), \
                                                 0, (count),                \
                                                 NULL, &error ) )
#define FT_MEM_RENEW_ARRAY( ptr, cursz, newsz )                             \
          FT_ASSIGNP_INNER( ptr, ft_mem_realloc( memory, sizeof ( *(ptr) ), \
                                                 (cursz), (newsz),          \
                                                 (ptr), &error ) )
#define FT_MEM_QNEW_ARRAY( ptr, count )                                      \
          FT_ASSIGNP_INNER( ptr, ft_mem_qrealloc( memory, sizeof ( *(ptr) ), \
                                                  0, (count),                \
                                                  NULL, &error ) )
#define FT_MEM_QRENEW_ARRAY( ptr, cursz, newsz )                             \
          FT_ASSIGNP_INNER( ptr, ft_mem_qrealloc( memory, sizeof ( *(ptr) ), \
                                                  (cursz), (newsz),          \
                                                  (ptr), &error ) )
#define FT_ALLOC( ptr, size )                           \
          FT_MEM_SET_ERROR( FT_MEM_ALLOC( ptr, size ) )
#define FT_REALLOC( ptr, cursz, newsz )                           \
          FT_MEM_SET_ERROR( FT_MEM_REALLOC( ptr, cursz, newsz ) )
#define FT_ALLOC_MULT( ptr, count, item_size )                           \
          FT_MEM_SET_ERROR( FT_MEM_ALLOC_MULT( ptr, count, item_size ) )
#define FT_REALLOC_MULT( ptr, oldcnt, newcnt, itmsz )              \
          FT_MEM_SET_ERROR( FT_MEM_REALLOC_MULT( ptr, oldcnt,      \
                                                 newcnt, itmsz ) )
#define FT_QALLOC( ptr, size )                           \
          FT_MEM_SET_ERROR( FT_MEM_QALLOC( ptr, size ) )
#define FT_QREALLOC( ptr, cursz, newsz )                           \
          FT_MEM_SET_ERROR( FT_MEM_QREALLOC( ptr, cursz, newsz ) )
#define FT_QALLOC_MULT( ptr, count, item_size )                           \
          FT_MEM_SET_ERROR( FT_MEM_QALLOC_MULT( ptr, count, item_size ) )
#define FT_QREALLOC_MULT( ptr, oldcnt, newcnt, itmsz )              \
          FT_MEM_SET_ERROR( FT_MEM_QREALLOC_MULT( ptr, oldcnt,      \
                                                  newcnt, itmsz ) )
#define FT_FREE( ptr )  FT_MEM_FREE( ptr )
#define FT_NEW( ptr )  FT_MEM_SET_ERROR( FT_MEM_NEW( ptr ) )
#define FT_NEW_ARRAY( ptr, count )                           \
          FT_MEM_SET_ERROR( FT_MEM_NEW_ARRAY( ptr, count ) )
#define FT_RENEW_ARRAY( ptr, curcnt, newcnt )                           \
          FT_MEM_SET_ERROR( FT_MEM_RENEW_ARRAY( ptr, curcnt, newcnt ) )
#define FT_QNEW( ptr )                           \
          FT_MEM_SET_ERROR( FT_MEM_QNEW( ptr ) )
#define FT_QNEW_ARRAY( ptr, count )                          \
          FT_MEM_SET_ERROR( FT_MEM_NEW_ARRAY( ptr, count ) )
#define FT_QRENEW_ARRAY( ptr, curcnt, newcnt )                          \
          FT_MEM_SET_ERROR( FT_MEM_RENEW_ARRAY( ptr, curcnt, newcnt ) )
  FT_BASE( FT_Pointer )
  ft_mem_strdup( FT_Memory    memory,
                 const char*  str,
                 FT_Error    *p_error );
  FT_BASE( FT_Pointer )
  ft_mem_dup( FT_Memory    memory,
              const void*  address,
              FT_ULong     size,
              FT_Error    *p_error );
#define FT_MEM_STRDUP( dst, str )                                            \
          (dst) = (char*)ft_mem_strdup( memory, (const char*)(str), &error )
#define FT_STRDUP( dst, str )                           \
          FT_MEM_SET_ERROR( FT_MEM_STRDUP( dst, str ) )
#define FT_MEM_DUP( dst, address, size )                                    \
          (dst) = ft_mem_dup( memory, (address), (FT_ULong)(size), &error )
#define FT_DUP( dst, address, size )                           \
          FT_MEM_SET_ERROR( FT_MEM_DUP( dst, address, size ) )
/* Return >= 1 if a truncation occurs.            */
/* Return 0 if the source string fits the buffer. */
/* This is *not* the same as strlcpy().           */
  FT_BASE( FT_Int )
  ft_mem_strcpyn( char*        dst,
                  const char*  src,
                  FT_ULong     size );
#define FT_STRCPYN( dst, src, size )                                         \
          ft_mem_strcpyn( (char*)dst, (const char*)(src), (FT_ULong)(size) )
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftgloadr.h                                                             */
/*                                                                         */
/*    The FreeType glyph loader (specification).                           */
/*                                                                         */
/*  Copyright 2002, 2003, 2005, 2006 by                                    */
/*  David Turner, Robert Wilhelm, and Werner Lemberg                       */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTGLOADR_H__
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_GlyphLoader                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    The glyph loader is an internal object used to load several glyphs */
/*    together (for example, in the case of composites).                 */
/*                                                                       */
/* <Note>                                                                */
/*    The glyph loader implementation is not part of the high-level API, */
/*    hence the forward structure declaration.                           */
/*                                                                       */
  typedef struct FT_GlyphLoaderRec_*  FT_GlyphLoader ;
/* moved to freetype.h in version 2.2 */
#if 0   
#define FT_SUBGLYPH_FLAG_ARGS_ARE_WORDS          1
#define FT_SUBGLYPH_FLAG_ARGS_ARE_XY_VALUES      2
#define FT_SUBGLYPH_FLAG_ROUND_XY_TO_GRID        4
#define FT_SUBGLYPH_FLAG_SCALE                   8
#define FT_SUBGLYPH_FLAG_XY_SCALE             0x40
#define FT_SUBGLYPH_FLAG_2X2                  0x80
#define FT_SUBGLYPH_FLAG_USE_MY_METRICS      0x200
#endif
  typedef struct  FT_SubGlyphRec_
  {
    FT_Int     index;
    FT_UShort  flags;
    FT_Int     arg1;
    FT_Int     arg2;
    FT_Matrix  transform;
  } FT_SubGlyphRec;
  typedef struct  FT_GlyphLoadRec_
  {
/* outline                   */
    FT_Outline   outline;        
/* extra points table        */
    FT_Vector*   extra_points;   
/* second extra points table */
    FT_Vector*   extra_points2;  
/* number of subglyphs       */
    FT_UInt      num_subglyphs;  
/* subglyphs                 */
    FT_SubGlyph  subglyphs;      
  } FT_GlyphLoadRec, *FT_GlyphLoad;
  typedef struct  FT_GlyphLoaderRec_
  {
    FT_Memory        memory;
    FT_UInt          max_points;
    FT_UInt          max_contours;
    FT_UInt          max_subglyphs;
    FT_Bool          use_extra;
    FT_GlyphLoadRec  base;
    FT_GlyphLoadRec  current;
/* for possible future extension? */
    void*            other;             
  } FT_GlyphLoaderRec;
/* create new empty glyph loader */
  FT_BASE( FT_Error )
  FT_GlyphLoader_New( FT_Memory        memory,
                      FT_GlyphLoader  *aloader );
/* add an extra points table to a glyph loader */
  FT_BASE( FT_Error )
  FT_GlyphLoader_CreateExtra( FT_GlyphLoader  loader );
/* destroy a glyph loader */
  FT_BASE( void )
  FT_GlyphLoader_Done( FT_GlyphLoader  loader );
/* reset a glyph loader (frees everything int it) */
  FT_BASE( void )
  FT_GlyphLoader_Reset( FT_GlyphLoader  loader );
/* rewind a glyph loader */
  FT_BASE( void )
  FT_GlyphLoader_Rewind( FT_GlyphLoader  loader );
/* check that there is enough space to add `n_points' and `n_contours' */
/* to the glyph loader                                                 */
  FT_BASE( FT_Error )
  FT_GlyphLoader_CheckPoints( FT_GlyphLoader  loader,
                              FT_UInt         n_points,
                              FT_UInt         n_contours );
#define FT_GLYPHLOADER_CHECK_P( _loader, _count )                         \
   ( (_count) == 0 || ((_loader)->base.outline.n_points    +              \
                       (_loader)->current.outline.n_points +              \
                       (unsigned long)(_count)) <= (_loader)->max_points )
#define FT_GLYPHLOADER_CHECK_C( _loader, _count )                          \
  ( (_count) == 0 || ((_loader)->base.outline.n_contours    +              \
                      (_loader)->current.outline.n_contours +              \
                      (unsigned long)(_count)) <= (_loader)->max_contours )
#define FT_GLYPHLOADER_CHECK_POINTS( _loader, _points,_contours )      \
  ( ( FT_GLYPHLOADER_CHECK_P( _loader, _points )   &&                  \
      FT_GLYPHLOADER_CHECK_C( _loader, _contours ) )                   \
    ? 0                                                                \
    : FT_GlyphLoader_CheckPoints( (_loader), (_points), (_contours) ) )
/* check that there is enough space to add `n_subs' sub-glyphs to */
/* a glyph loader                                                 */
  FT_BASE( FT_Error )
  FT_GlyphLoader_CheckSubGlyphs( FT_GlyphLoader  loader,
                                 FT_UInt         n_subs );
/* prepare a glyph loader, i.e. empty the current glyph */
  FT_BASE( void )
  FT_GlyphLoader_Prepare( FT_GlyphLoader  loader );
/* add the current glyph to the base glyph */
  FT_BASE( void )
  FT_GlyphLoader_Add( FT_GlyphLoader  loader );
/* copy points from one glyph loader to another */
  FT_BASE( FT_Error )
  FT_GlyphLoader_CopyPoints( FT_GlyphLoader  target,
                             FT_GlyphLoader  source );
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftdriver.h                                                             */
/*                                                                         */
/*    FreeType font driver interface (specification).                      */
/*                                                                         */
/*  Copyright 1996-2003, 2006, 2008, 2011-2012 by                          */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTDRIVER_H__
FT_BEGIN_HEADER
  typedef FT_Error
  (*FT_Face_InitFunc)( FT_Stream      stream,
                       FT_Face        face,
                       FT_Int         typeface_index,
                       FT_Int         num_params,
                       FT_Parameter*  parameters );
  typedef void
  (*FT_Face_DoneFunc)( FT_Face  face );
  typedef FT_Error
  (*FT_Size_InitFunc)( FT_Size  size );
  typedef void
  (*FT_Size_DoneFunc)( FT_Size  size );
  typedef FT_Error
  (*FT_Slot_InitFunc)( FT_GlyphSlot  slot );
  typedef void
  (*FT_Slot_DoneFunc)( FT_GlyphSlot  slot );
  typedef FT_Error
  (*FT_Size_RequestFunc)( FT_Size          size,
                          FT_Size_Request  req );
  typedef FT_Error
  (*FT_Size_SelectFunc)( FT_Size   size,
                         FT_ULong  size_index );
  typedef FT_Error
  (*FT_Slot_LoadFunc)( FT_GlyphSlot  slot,
                       FT_Size       size,
                       FT_UInt       glyph_index,
                       FT_Int32      load_flags );
  typedef FT_UInt
  (*FT_CharMap_CharIndexFunc)( FT_CharMap  charmap,
                               FT_Long     charcode );
  typedef FT_Long
  (*FT_CharMap_CharNextFunc)( FT_CharMap  charmap,
                              FT_Long     charcode );
  typedef FT_Error
  (*FT_Face_GetKerningFunc)( FT_Face     face,
                             FT_UInt     left_glyph,
                             FT_UInt     right_glyph,
                             FT_Vector*  kerning );
  typedef FT_Error
  (*FT_Face_AttachFunc)( FT_Face    face,
                         FT_Stream  stream );
  typedef FT_Error
  (*FT_Face_GetAdvancesFunc)( FT_Face    face,
                              FT_UInt    first,
                              FT_UInt    count,
                              FT_Int32   flags,
                              FT_Fixed*  advances );
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Driver_ClassRec                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    The font driver class.  This structure mostly contains pointers to */
/*    driver methods.                                                    */
/*                                                                       */
/* <Fields>                                                              */
/*    root             :: The parent module.                             */
/*                                                                       */
/*    face_object_size :: The size of a face object in bytes.            */
/*                                                                       */
/*    size_object_size :: The size of a size object in bytes.            */
/*                                                                       */
/*    slot_object_size :: The size of a glyph object in bytes.           */
/*                                                                       */
/*    init_face        :: The format-specific face constructor.          */
/*                                                                       */
/*    done_face        :: The format-specific face destructor.           */
/*                                                                       */
/*    init_size        :: The format-specific size constructor.          */
/*                                                                       */
/*    done_size        :: The format-specific size destructor.           */
/*                                                                       */
/*    init_slot        :: The format-specific slot constructor.          */
/*                                                                       */
/*    done_slot        :: The format-specific slot destructor.           */
/*                                                                       */
/*                                                                       */
/*    load_glyph       :: A function handle to load a glyph to a slot.   */
/*                        This field is mandatory!                       */
/*                                                                       */
/*    get_kerning      :: A function handle to return the unscaled       */
/*                        kerning for a given pair of glyphs.  Can be    */
/*                        set to 0 if the format doesn't support         */
/*                        kerning.                                       */
/*                                                                       */
/*    attach_file      :: This function handle is used to read           */
/*                        additional data for a face from another        */
/*                        file/stream.  For example, this can be used to */
/*                        add data from AFM or PFM files on a Type 1     */
/*                        face, or a CIDMap on a CID-keyed face.         */
/*                                                                       */
/*    get_advances     :: A function handle used to return advance       */
/*                        widths of `count' glyphs (in font units),      */
/*                        starting at `first'.  The `vertical' flag must */
/*                        be set to get vertical advance heights.  The   */
/*                        `advances' buffer is caller-allocated.         */
/*                        The idea of this function is to be able to     */
/*                        perform device-independent text layout without */
/*                        loading a single glyph image.                  */
/*                                                                       */
/*    request_size     :: A handle to a function used to request the new */
/*                        character size.  Can be set to 0 if the        */
/*                        scaling done in the base layer suffices.       */
/*                                                                       */
/*    select_size      :: A handle to a function used to select a new    */
/*                        fixed size.  It is used only if                */
/*                        @FT_FACE_FLAG_FIXED_SIZES is set.  Can be set  */
/*                        to 0 if the scaling done in the base layer     */
/*                        suffices.                                      */
/* <Note>                                                                */
/*    Most function pointers, with the exception of `load_glyph', can be */
/*    set to 0 to indicate a default behaviour.                          */
/*                                                                       */
  typedef struct  FT_Driver_ClassRec_
  {
    FT_Module_Class          root;
    FT_Long                  face_object_size;
    FT_Long                  size_object_size;
    FT_Long                  slot_object_size;
    FT_Face_InitFunc         init_face;
    FT_Face_DoneFunc         done_face;
    FT_Size_InitFunc         init_size;
    FT_Size_DoneFunc         done_size;
    FT_Slot_InitFunc         init_slot;
    FT_Slot_DoneFunc         done_slot;
    FT_Slot_LoadFunc         load_glyph;
    FT_Face_GetKerningFunc   get_kerning;
    FT_Face_AttachFunc       attach_file;
    FT_Face_GetAdvancesFunc  get_advances;
/* since version 2.2 */
    FT_Size_RequestFunc      request_size;
    FT_Size_SelectFunc       select_size;
  } FT_Driver_ClassRec, *FT_Driver_Class;
/*
   *  The following functions are used as stubs for `set_char_sizes' and
   *  `set_pixel_sizes'; the code uses `request_size' and `select_size'
   *  functions instead.
   *
   *  Implementation is in `src/base/ftobjs.c'.
   */
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DECLARE_DRIVER                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Used to create a forward declaration of an FT_Driver_ClassRec      */
/*    struct instance.                                                   */
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DEFINE_DRIVER                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Used to initialize an instance of FT_Driver_ClassRec struct.       */
/*                                                                       */
/*    When FT_CONFIG_OPTION_PIC is defined a `create' function has to be */
/*    called with a pointer where the allocated structure is returned.   */
/*    And when it is no longer needed a `destroy' function needs to be   */
/*    called to release that allocation.                                 */
/*                                                                       */
/*    `fcinit.c' (ft_create_default_module_classes) already contains a   */
/*    mechanism to call these functions for the default modules          */
/*    described in `ftmodule.h'.                                         */
/*                                                                       */
/*    Notice that the created `create' and `destroy' functions call      */
/*    `pic_init' and `pic_free' to allow you to manually allocate and    */
/*    initialize any additional global data, like a module specific      */
/*    interface, and put them in the global pic container defined in     */
/*    `ftpic.h'.  If you don't need them just implement the functions as */
/*    empty to resolve the link error.  Also the `pic_init' and          */
/*    `pic_free' functions should be declared in `pic.h', to be referred */
/*    by driver definition calling `FT_DEFINE_DRIVER' in following.      */
/*                                                                       */
/*    When FT_CONFIG_OPTION_PIC is not defined the struct will be        */
/*    allocated in the global scope (or the scope where the macro is     */
/*    used).                                                             */
/*                                                                       */
/* empty */
#define FT_DEFINE_DRIVERS_OLD_INTERNALS( a_, b_ )   
#define FT_DECLARE_DRIVER( class_ )  \
  FT_CALLBACK_TABLE                   \
  const FT_Driver_ClassRec  class_;
#define FT_DEFINE_DRIVER(                                    \
          class_,                                            \
          flags_,                                            \
          size_,                                             \
          name_,                                             \
          version_,                                          \
          requires_,                                         \
          interface_,                                        \
          init_,                                             \
          done_,                                             \
          get_interface_,                                    \
          face_object_size_,                                 \
          size_object_size_,                                 \
          slot_object_size_,                                 \
          init_face_,                                        \
          done_face_,                                        \
          init_size_,                                        \
          done_size_,                                        \
          init_slot_,                                        \
          done_slot_,                                        \
          old_set_char_sizes_,                               \
          old_set_pixel_sizes_,                              \
          load_glyph_,                                       \
          get_kerning_,                                      \
          attach_file_,                                      \
          get_advances_,                                     \
          request_size_,                                     \
          select_size_ )                                     \
  FT_CALLBACK_TABLE_DEF                                      \
  const FT_Driver_ClassRec  class_ =                         \
  {                                                          \
    FT_DEFINE_ROOT_MODULE( flags_,                           \
                           size_,                            \
                           name_,                            \
                           version_,                         \
                           requires_,                        \
                           interface_,                       \
                           init_,                            \
                           done_,                            \
                           get_interface_ )                  \
                                                             \
    face_object_size_,                                       \
    size_object_size_,                                       \
    slot_object_size_,                                       \
                                                             \
    init_face_,                                              \
    done_face_,                                              \
                                                             \
    init_size_,                                              \
    done_size_,                                              \
                                                             \
    init_slot_,                                              \
    done_slot_,                                              \
                                                             \
    FT_DEFINE_DRIVERS_OLD_INTERNALS( old_set_char_sizes_,    \
                                     old_set_pixel_sizes_ )  \
                                                             \
    load_glyph_,                                             \
                                                             \
    get_kerning_,                                            \
    attach_file_,                                            \
    get_advances_,                                           \
                                                             \
    request_size_,                                           \
    select_size_                                             \
  };
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  autohint.h                                                             */
/*                                                                         */
/*    High-level `autohint' module-specific interface (specification).     */
/*                                                                         */
/*  Copyright 1996-2002, 2007, 2009, 2012 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* The auto-hinter is used to load and automatically hint glyphs if a    */
/* format-specific hinter isn't available.                               */
/*                                                                       */
/*************************************************************************/
#define __AUTOHINT_H__
/*************************************************************************/
/*                                                                       */
/* A small technical note regarding automatic hinting in order to        */
/* clarify this module interface.                                        */
/*                                                                       */
/* An automatic hinter might compute two kinds of data for a given face: */
/*                                                                       */
/* - global hints: Usually some metrics that describe global properties  */
/*                 of the face.  It is computed by scanning more or less */
/*                 aggressively the glyphs in the face, and thus can be  */
/*                 very slow to compute (even if the size of global      */
/*                 hints is really small).                               */
/*                                                                       */
/* - glyph hints:  These describe some important features of the glyph   */
/*                 outline, as well as how to align them.  They are      */
/*                 generally much faster to compute than global hints.   */
/*                                                                       */
/* The current FreeType auto-hinter does a pretty good job while         */
/* performing fast computations for both global and glyph hints.         */
/* However, we might be interested in introducing more complex and       */
/* powerful algorithms in the future, like the one described in the John */
/* D. Hobby paper, which unfortunately requires a lot more horsepower.   */
/*                                                                       */
/* Because a sufficiently sophisticated font management system would     */
/* typically implement an LRU cache of opened face objects to reduce     */
/* memory usage, it is a good idea to be able to avoid recomputing       */
/* global hints every time the same face is re-opened.                   */
/*                                                                       */
/* We thus provide the ability to cache global hints outside of the face */
/* object, in order to speed up font re-opening time.  Of course, this   */
/* feature is purely optional, so most client programs won't even notice */
/* it.                                                                   */
/*                                                                       */
/* I initially thought that it would be a good idea to cache the glyph   */
/* hints too.  However, my general idea now is that if you really need   */
/* to cache these too, you are simply in need of a new font format,      */
/* where all this information could be stored within the font file and   */
/* decoded on the fly.                                                   */
/*                                                                       */
/*************************************************************************/
FT_BEGIN_HEADER
  typedef struct FT_AutoHinterRec_  *FT_AutoHinter;
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_AutoHinter_GlobalGetFunc                                        */
/*                                                                       */
/* <Description>                                                         */
/*    Retrieve the global hints computed for a given face object.  The   */
/*    resulting data is dissociated from the face and will survive a     */
/*    call to FT_Done_Face().  It must be discarded through the API      */
/*    FT_AutoHinter_GlobalDoneFunc().                                    */
/*                                                                       */
/* <Input>                                                               */
/*    hinter       :: A handle to the source auto-hinter.                */
/*                                                                       */
/*    face         :: A handle to the source face object.                */
/*                                                                       */
/* <Output>                                                              */
/*    global_hints :: A typeless pointer to the global hints.            */
/*                                                                       */
/*    global_len   :: The size in bytes of the global hints.             */
/*                                                                       */
  typedef void
  (*FT_AutoHinter_GlobalGetFunc)( FT_AutoHinter  hinter,
                                  FT_Face        face,
                                  void**         global_hints,
                                  long*          global_len );
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_AutoHinter_GlobalDoneFunc                                       */
/*                                                                       */
/* <Description>                                                         */
/*    Discard the global hints retrieved through                         */
/*    FT_AutoHinter_GlobalGetFunc().  This is the only way these hints   */
/*    are freed from memory.                                             */
/*                                                                       */
/* <Input>                                                               */
/*    hinter :: A handle to the auto-hinter module.                      */
/*                                                                       */
/*    global :: A pointer to retrieved global hints to discard.          */
/*                                                                       */
  typedef void
  (*FT_AutoHinter_GlobalDoneFunc)( FT_AutoHinter  hinter,
                                   void*          global );
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_AutoHinter_GlobalResetFunc                                      */
/*                                                                       */
/* <Description>                                                         */
/*    This function is used to recompute the global metrics in a given   */
/*    font.  This is useful when global font data changes (e.g. Multiple */
/*    Masters fonts where blend coordinates change).                     */
/*                                                                       */
/* <Input>                                                               */
/*    hinter :: A handle to the source auto-hinter.                      */
/*                                                                       */
/*    face   :: A handle to the face.                                    */
/*                                                                       */
  typedef void
  (*FT_AutoHinter_GlobalResetFunc)( FT_AutoHinter  hinter,
                                    FT_Face        face );
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_AutoHinter_GlyphLoadFunc                                        */
/*                                                                       */
/* <Description>                                                         */
/*    This function is used to load, scale, and automatically hint a     */
/*    glyph from a given face.                                           */
/*                                                                       */
/* <Input>                                                               */
/*    face        :: A handle to the face.                               */
/*                                                                       */
/*    glyph_index :: The glyph index.                                    */
/*                                                                       */
/*    load_flags  :: The load flags.                                     */
/*                                                                       */
/* <Note>                                                                */
/*    This function is capable of loading composite glyphs by hinting    */
/*    each sub-glyph independently (which improves quality).             */
/*                                                                       */
/*    It will call the font driver with @FT_Load_Glyph, with             */
/*    @FT_LOAD_NO_SCALE set.                                             */
/*                                                                       */
  typedef FT_Error
  (*FT_AutoHinter_GlyphLoadFunc)( FT_AutoHinter  hinter,
                                  FT_GlyphSlot   slot,
                                  FT_Size        size,
                                  FT_UInt        glyph_index,
                                  FT_Int32       load_flags );
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_AutoHinter_InterfaceRec                                         */
/*                                                                       */
/* <Description>                                                         */
/*    The auto-hinter module's interface.                                */
/*                                                                       */
  typedef struct  FT_AutoHinter_InterfaceRec_
  {
    FT_AutoHinter_GlobalResetFunc  reset_face;
    FT_AutoHinter_GlobalGetFunc    get_global_hints;
    FT_AutoHinter_GlobalDoneFunc   done_global_hints;
    FT_AutoHinter_GlyphLoadFunc    load_glyph;
  } FT_AutoHinter_InterfaceRec, *FT_AutoHinter_Interface;
#define FT_DEFINE_AUTOHINTER_INTERFACE(       \
          class_,                             \
          reset_face_,                        \
          get_global_hints_,                  \
          done_global_hints_,                 \
          load_glyph_ )                       \
  FT_CALLBACK_TABLE_DEF                       \
  const FT_AutoHinter_InterfaceRec  class_ =  \
  {                                           \
    reset_face_,                              \
    get_global_hints_,                        \
    done_global_hints_,                       \
    load_glyph_                               \
  };
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftserv.h                                                               */
/*                                                                         */
/*    The FreeType services (specification only).                          */
/*                                                                         */
/*  Copyright 2003-2007, 2009, 2012 by                                     */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/*  Each module can export one or more `services'.  Each service is      */
/*  identified by a constant string and modeled by a pointer; the latter */
/*  generally corresponds to a structure containing function pointers.   */
/*                                                                       */
/*  Note that a service's data cannot be a mere function pointer because */
/*  in C it is possible that function pointers might be implemented      */
/*  differently than data pointers (e.g. 48 bits instead of 32).         */
/*                                                                       */
/*************************************************************************/
#define __FTSERV_H__
FT_BEGIN_HEADER
/* Visual C++ (and Intel C++) */
#if defined( _MSC_VER )       
/* we disable the warning `conditional expression is constant' here */
/* in order to compile cleanly with the maximum level of warnings   */
#pragma warning( disable : 4127 )
/* _MSC_VER */
#endif  
/*
   * @macro:
   *   FT_FACE_FIND_SERVICE
   *
   * @description:
   *   This macro is used to look up a service from a face's driver module.
   *
   * @input:
   *   face ::
   *     The source face handle.
   *
   *   id ::
   *     A string describing the service as defined in the service's
   *     header files (e.g. FT_SERVICE_ID_MULTI_MASTERS which expands to
   *     `multi-masters').  It is automatically prefixed with
   *     `FT_SERVICE_ID_'.
   *
   * @output:
   *   ptr ::
   *     A variable that receives the service pointer.  Will be NULL
   *     if not found.
   */
#ifdef __cplusplus
#define FT_FACE_FIND_SERVICE( face, ptr, id )                               \
  FT_BEGIN_STMNT                                                            \
    FT_Module    module = FT_MODULE( FT_FACE( face )->driver );             \
    FT_Pointer   _tmp_  = NULL;                                             \
    FT_Pointer*  _pptr_ = (FT_Pointer*)&(ptr);                              \
                                                                            \
                                                                            \
    if ( module->clazz->get_interface )                                     \
      _tmp_ = module->clazz->get_interface( module, FT_SERVICE_ID_ ## id ); \
    *_pptr_ = _tmp_;                                                        \
  FT_END_STMNT
/* !C++ */
#else  
#define FT_FACE_FIND_SERVICE( face, ptr, id )                               \
  FT_BEGIN_STMNT                                                            \
    FT_Module   module = FT_MODULE( FT_FACE( face )->driver );              \
    FT_Pointer  _tmp_  = NULL;                                              \
                                                                            \
    if ( module->clazz->get_interface )                                     \
      _tmp_ = module->clazz->get_interface( module, FT_SERVICE_ID_ ## id ); \
    ptr = _tmp_;                                                            \
  FT_END_STMNT
/* !C++ */
#endif  
/*
   * @macro:
   *   FT_FACE_FIND_GLOBAL_SERVICE
   *
   * @description:
   *   This macro is used to look up a service from all modules.
   *
   * @input:
   *   face ::
   *     The source face handle.
   *
   *   id ::
   *     A string describing the service as defined in the service's
   *     header files (e.g. FT_SERVICE_ID_MULTI_MASTERS which expands to
   *     `multi-masters').  It is automatically prefixed with
   *     `FT_SERVICE_ID_'.
   *
   * @output:
   *   ptr ::
   *     A variable that receives the service pointer.  Will be NULL
   *     if not found.
   */
#ifdef __cplusplus
#define FT_FACE_FIND_GLOBAL_SERVICE( face, ptr, id )               \
  FT_BEGIN_STMNT                                                   \
    FT_Module    module = FT_MODULE( FT_FACE( face )->driver );    \
    FT_Pointer   _tmp_;                                            \
    FT_Pointer*  _pptr_ = (FT_Pointer*)&(ptr);                     \
                                                                   \
                                                                   \
    _tmp_ = ft_module_get_service( module, FT_SERVICE_ID_ ## id ); \
    *_pptr_ = _tmp_;                                               \
  FT_END_STMNT
/* !C++ */
#else  
#define FT_FACE_FIND_GLOBAL_SERVICE( face, ptr, id )               \
  FT_BEGIN_STMNT                                                   \
    FT_Module   module = FT_MODULE( FT_FACE( face )->driver );     \
    FT_Pointer  _tmp_;                                             \
                                                                   \
                                                                   \
    _tmp_ = ft_module_get_service( module, FT_SERVICE_ID_ ## id ); \
    ptr   = _tmp_;                                                 \
  FT_END_STMNT
/* !C++ */
#endif  
/*************************************************************************/
/*************************************************************************/
/*****                                                               *****/
/*****         S E R V I C E   D E S C R I P T O R S                 *****/
/*****                                                               *****/
/*************************************************************************/
/*************************************************************************/
/*
   *  The following structure is used to _describe_ a given service
   *  to the library.  This is useful to build simple static service lists.
   */
  typedef struct  FT_ServiceDescRec_
  {
/* service name         */
    const char*  serv_id;      
/* service pointer/data */
    const void*  serv_data;    
  } FT_ServiceDescRec;
  typedef const FT_ServiceDescRec*  FT_ServiceDesc;
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DEFINE_SERVICEDESCREC1                                          */
/*    FT_DEFINE_SERVICEDESCREC2                                          */
/*    FT_DEFINE_SERVICEDESCREC3                                          */
/*    FT_DEFINE_SERVICEDESCREC4                                          */
/*    FT_DEFINE_SERVICEDESCREC5                                          */
/*    FT_DEFINE_SERVICEDESCREC6                                          */
/*                                                                       */
/* <Description>                                                         */
/*    Used to initialize an array of FT_ServiceDescRec structures.       */
/*                                                                       */
/*    When FT_CONFIG_OPTION_PIC is defined a `create' function needs to  */
/*    be called with a pointer to return an allocated array.  As soon as */
/*    it is no longer needed, a `destroy' function needs to be called to */
/*    release that allocation.                                           */
/*                                                                       */
/*    These functions should be manually called from the `pic_init' and  */
/*    `pic_free' functions of your module (see FT_DEFINE_MODULE).        */
/*                                                                       */
/*    When FT_CONFIG_OPTION_PIC is not defined the array will be         */
/*    allocated in the global scope (or the scope where the macro is     */
/*    used).                                                             */
/*                                                                       */
#define FT_DEFINE_SERVICEDESCREC1( class_,                                  \
                                   serv_id_1, serv_data_1 )                 \
  static const FT_ServiceDescRec  class_[] =                                \
  {                                                                         \
    { serv_id_1, serv_data_1 },                                             \
    { NULL, NULL }                                                          \
  };
#define FT_DEFINE_SERVICEDESCREC2( class_,                                  \
                                   serv_id_1, serv_data_1,                  \
                                   serv_id_2, serv_data_2 )                 \
  static const FT_ServiceDescRec  class_[] =                                \
  {                                                                         \
    { serv_id_1, serv_data_1 },                                             \
    { serv_id_2, serv_data_2 },                                             \
    { NULL, NULL }                                                          \
  };
#define FT_DEFINE_SERVICEDESCREC3( class_,                                  \
                                   serv_id_1, serv_data_1,                  \
                                   serv_id_2, serv_data_2,                  \
                                   serv_id_3, serv_data_3 )                 \
  static const FT_ServiceDescRec  class_[] =                                \
  {                                                                         \
    { serv_id_1, serv_data_1 },                                             \
    { serv_id_2, serv_data_2 },                                             \
    { serv_id_3, serv_data_3 },                                             \
    { NULL, NULL }                                                          \
  };
#define FT_DEFINE_SERVICEDESCREC4( class_,                                  \
                                   serv_id_1, serv_data_1,                  \
                                   serv_id_2, serv_data_2,                  \
                                   serv_id_3, serv_data_3,                  \
                                   serv_id_4, serv_data_4 )                 \
  static const FT_ServiceDescRec  class_[] =                                \
  {                                                                         \
    { serv_id_1, serv_data_1 },                                             \
    { serv_id_2, serv_data_2 },                                             \
    { serv_id_3, serv_data_3 },                                             \
    { serv_id_4, serv_data_4 },                                             \
    { NULL, NULL }                                                          \
  };
#define FT_DEFINE_SERVICEDESCREC5( class_,                                  \
                                   serv_id_1, serv_data_1,                  \
                                   serv_id_2, serv_data_2,                  \
                                   serv_id_3, serv_data_3,                  \
                                   serv_id_4, serv_data_4,                  \
                                   serv_id_5, serv_data_5 )                 \
  static const FT_ServiceDescRec  class_[] =                                \
  {                                                                         \
    { serv_id_1, serv_data_1 },                                             \
    { serv_id_2, serv_data_2 },                                             \
    { serv_id_3, serv_data_3 },                                             \
    { serv_id_4, serv_data_4 },                                             \
    { serv_id_5, serv_data_5 },                                             \
    { NULL, NULL }                                                          \
  };
#define FT_DEFINE_SERVICEDESCREC6( class_,                                  \
                                   serv_id_1, serv_data_1,                  \
                                   serv_id_2, serv_data_2,                  \
                                   serv_id_3, serv_data_3,                  \
                                   serv_id_4, serv_data_4,                  \
                                   serv_id_5, serv_data_5,                  \
                                   serv_id_6, serv_data_6 )                 \
  static const FT_ServiceDescRec  class_[] =                                \
  {                                                                         \
    { serv_id_1, serv_data_1 },                                             \
    { serv_id_2, serv_data_2 },                                             \
    { serv_id_3, serv_data_3 },                                             \
    { serv_id_4, serv_data_4 },                                             \
    { serv_id_5, serv_data_5 },                                             \
    { serv_id_6, serv_data_6 },                                             \
    { NULL, NULL }                                                          \
  };
/*
   *  Parse a list of FT_ServiceDescRec descriptors and look for
   *  a specific service by ID.  Note that the last element in the
   *  array must be { NULL, NULL }, and that the function should
   *  return NULL if the service isn't available.
   *
   *  This function can be used by modules to implement their
   *  `get_service' method.
   */
  FT_BASE( FT_Pointer )
  ft_service_list_lookup( FT_ServiceDesc  service_descriptors,
                          const char*     service_id );
/*************************************************************************/
/*************************************************************************/
/*****                                                               *****/
/*****             S E R V I C E S   C A C H E                       *****/
/*****                                                               *****/
/*************************************************************************/
/*************************************************************************/
/*
   *  This structure is used to store a cache for several frequently used
   *  services.  It is the type of `face->internal->services'.  You
   *  should only use FT_FACE_LOOKUP_SERVICE to access it.
   *
   *  All fields should have the type FT_Pointer to relax compilation
   *  dependencies.  We assume the developer isn't completely stupid.
   *
   *  Each field must be named `service_XXXX' where `XXX' corresponds to
   *  the correct FT_SERVICE_ID_XXXX macro.  See the definition of
   *  FT_FACE_LOOKUP_SERVICE below how this is implemented.
   *
   */
  typedef struct  FT_ServiceCacheRec_
  {
    FT_Pointer  service_POSTSCRIPT_FONT_NAME;
    FT_Pointer  service_MULTI_MASTERS;
    FT_Pointer  service_GLYPH_DICT;
    FT_Pointer  service_PFR_METRICS;
    FT_Pointer  service_WINFNT;
  } FT_ServiceCacheRec, *FT_ServiceCache;
/*
   *  A magic number used within the services cache.
   */
/* magic number */
#define FT_SERVICE_UNAVAILABLE  ((FT_Pointer)~1)   
/*
   * @macro:
   *   FT_FACE_LOOKUP_SERVICE
   *
   * @description:
   *   This macro is used to lookup a service from a face's driver module
   *   using its cache.
   *
   * @input:
   *   face::
   *     The source face handle containing the cache.
   *
   *   field ::
   *     The field name in the cache.
   *
   *   id ::
   *     The service ID.
   *
   * @output:
   *   ptr ::
   *     A variable receiving the service data.  NULL if not available.
   */
#ifdef __cplusplus
#define FT_FACE_LOOKUP_SERVICE( face, ptr, id )                \
  FT_BEGIN_STMNT                                               \
    FT_Pointer   svc;                                          \
    FT_Pointer*  Pptr = (FT_Pointer*)&(ptr);                   \
                                                               \
                                                               \
    svc = FT_FACE( face )->internal->services. service_ ## id; \
    if ( svc == FT_SERVICE_UNAVAILABLE )                       \
      svc = NULL;                                              \
    else if ( svc == NULL )                                    \
    {                                                          \
      FT_FACE_FIND_SERVICE( face, svc, id );                   \
                                                               \
      FT_FACE( face )->internal->services. service_ ## id =    \
        (FT_Pointer)( svc != NULL ? svc                        \
                                  : FT_SERVICE_UNAVAILABLE );  \
    }                                                          \
    *Pptr = svc;                                               \
  FT_END_STMNT
/* !C++ */
#else  
#define FT_FACE_LOOKUP_SERVICE( face, ptr, id )                \
  FT_BEGIN_STMNT                                               \
    FT_Pointer  svc;                                           \
                                                               \
                                                               \
    svc = FT_FACE( face )->internal->services. service_ ## id; \
    if ( svc == FT_SERVICE_UNAVAILABLE )                       \
      svc = NULL;                                              \
    else if ( svc == NULL )                                    \
    {                                                          \
      FT_FACE_FIND_SERVICE( face, svc, id );                   \
                                                               \
      FT_FACE( face )->internal->services. service_ ## id =    \
        (FT_Pointer)( svc != NULL ? svc                        \
                                  : FT_SERVICE_UNAVAILABLE );  \
    }                                                          \
    ptr = svc;                                                 \
  FT_END_STMNT
/* !C++ */
#endif  
/*
   *  A macro used to define new service structure types.
   */
#define FT_DEFINE_SERVICE( name )            \
  typedef struct FT_Service_ ## name ## Rec_ \
    FT_Service_ ## name ## Rec ;             \
  typedef struct FT_Service_ ## name ## Rec_ \
    const * FT_Service_ ## name ;            \
  struct FT_Service_ ## name ## Rec_
/* */
/*
   *  The header files containing the services.
   */
#define FT_SERVICE_BDF_H                <freetype/internal/services/svbdf.h>
#define FT_SERVICE_CID_H                <freetype/internal/services/svcid.h>
#define FT_SERVICE_GLYPH_DICT_H         <freetype/internal/services/svgldict.h>
#define FT_SERVICE_GX_VALIDATE_H        <freetype/internal/services/svgxval.h>
#define FT_SERVICE_KERNING_H            <freetype/internal/services/svkern.h>
#define FT_SERVICE_MULTIPLE_MASTERS_H   <freetype/internal/services/svmm.h>
#define FT_SERVICE_OPENTYPE_VALIDATE_H  <freetype/internal/services/svotval.h>
#define FT_SERVICE_PFR_H                <freetype/internal/services/svpfr.h>
#define FT_SERVICE_POSTSCRIPT_CMAPS_H   <freetype/internal/services/svpscmap.h>
#define FT_SERVICE_POSTSCRIPT_INFO_H    <freetype/internal/services/svpsinfo.h>
#define FT_SERVICE_POSTSCRIPT_NAME_H    <freetype/internal/services/svpostnm.h>
#define FT_SERVICE_PROPERTIES_H         <freetype/internal/services/svprop.h>
#define FT_SERVICE_SFNT_H               <freetype/internal/services/svsfnt.h>
#define FT_SERVICE_TRUETYPE_ENGINE_H    <freetype/internal/services/svtteng.h>
#define FT_SERVICE_TT_CMAP_H            <freetype/internal/services/svttcmap.h>
#define FT_SERVICE_WINFNT_H             <freetype/internal/services/svwinfnt.h>
#define FT_SERVICE_XFREE86_NAME_H       <freetype/internal/services/svxf86nm.h>
#define FT_SERVICE_TRUETYPE_GLYF_H      <freetype/internal/services/svttglyf.h>
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftpic.h                                                                */
/*                                                                         */
/*    The FreeType position independent code services (declaration).       */
/*                                                                         */
/*  Copyright 2009, 2012 by                                                */
/*  Oran Agra and Mickey Gabel.                                            */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/*  Modules that ordinarily have const global data that need address     */
/*  can instead define pointers here.                                    */
/*                                                                       */
/*************************************************************************/
#define __FTPIC_H__
FT_BEGIN_HEADER
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftincrem.h                                                             */
/*                                                                         */
/*    FreeType incremental loading (specification).                        */
/*                                                                         */
/*  Copyright 2002, 2003, 2006, 2007, 2008, 2010 by                        */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTINCREM_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/***************************************************************************
   *
   * @section:
   *    incremental
   *
   * @title:
   *    Incremental Loading
   *
   * @abstract:
   *    Custom Glyph Loading.
   *
   * @description:
   *   This section contains various functions used to perform so-called
   *   `incremental' glyph loading.  This is a mode where all glyphs loaded
   *   from a given @FT_Face are provided by the client application,
   *
   *   Apart from that, all other tables are loaded normally from the font
   *   file.  This mode is useful when FreeType is used within another
   *   engine, e.g., a PostScript Imaging Processor.
   *
   *   To enable this mode, you must use @FT_Open_Face, passing an
   *   @FT_Parameter with the @FT_PARAM_TAG_INCREMENTAL tag and an
   *   @FT_Incremental_Interface value.  See the comments for
   *   @FT_Incremental_InterfaceRec for an example.
   *
   */
/***************************************************************************
   *
   * @type:
   *   FT_Incremental
   *
   * @description:
   *   An opaque type describing a user-provided object used to implement
   *   `incremental' glyph loading within FreeType.  This is used to support
   *   embedded fonts in certain environments (e.g., PostScript interpreters),
   *   where the glyph data isn't in the font file, or must be overridden by
   *   different values.
   *
   * @note:
   *   It is up to client applications to create and implement @FT_Incremental
   *   objects, as long as they provide implementations for the methods
   *   @FT_Incremental_GetGlyphDataFunc, @FT_Incremental_FreeGlyphDataFunc
   *   and @FT_Incremental_GetGlyphMetricsFunc.
   *
   *   See the description of @FT_Incremental_InterfaceRec to understand how
   *   to use incremental objects with FreeType.
   *
   */
  typedef struct FT_IncrementalRec_*  FT_Incremental;
/***************************************************************************
   *
   * @struct:
   *   FT_Incremental_MetricsRec
   *
   * @description:
   *   A small structure used to contain the basic glyph metrics returned
   *   by the @FT_Incremental_GetGlyphMetricsFunc method.
   *
   * @fields:
   *   bearing_x ::
   *     Left bearing, in font units.
   *
   *   bearing_y ::
   *     Top bearing, in font units.
   *
   *   advance ::
   *     Horizontal component of glyph advance, in font units.
   *
   *   advance_v ::
   *     Vertical component of glyph advance, in font units.
   *
   * @note:
   *   These correspond to horizontal or vertical metrics depending on the
   *   value of the `vertical' argument to the function
   *   @FT_Incremental_GetGlyphMetricsFunc.
   *
   */
  typedef struct  FT_Incremental_MetricsRec_
  {
    FT_Long  bearing_x;
    FT_Long  bearing_y;
    FT_Long  advance;
/* since 2.3.12 */
    FT_Long  advance_v;      
  } FT_Incremental_MetricsRec;
/***************************************************************************
   *
   * @struct:
   *   FT_Incremental_Metrics
   *
   * @description:
   *   A handle to an @FT_Incremental_MetricsRec structure.
   *
   */
   typedef struct FT_Incremental_MetricsRec_*  FT_Incremental_Metrics;
/***************************************************************************
   *
   * @type:
   *   FT_Incremental_GetGlyphDataFunc
   *
   * @description:
   *   A function called by FreeType to access a given glyph's data bytes
   *   during @FT_Load_Glyph or @FT_Load_Char if incremental loading is
   *   enabled.
   *
   *   Note that the format of the glyph's data bytes depends on the font
   *   file format.  For TrueType, it must correspond to the raw bytes within
   *   the `glyf' table.  For PostScript formats, it must correspond to the
   *   *unencrypted* charstring bytes, without any `lenIV' header.  It is
   *   undefined for any other format.
   *
   * @input:
   *   incremental ::
   *     Handle to an opaque @FT_Incremental handle provided by the client
   *     application.
   *
   *   glyph_index ::
   *     Index of relevant glyph.
   *
   * @output:
   *   adata ::
   *     A structure describing the returned glyph data bytes (which will be
   *     accessed as a read-only byte block).
   *
   * @return:
   *   FreeType error code.  0~means success.
   *
   * @note:
   *   If this function returns successfully the method
   *   @FT_Incremental_FreeGlyphDataFunc will be called later to release
   *   the data bytes.
   *
   *   Nested calls to @FT_Incremental_GetGlyphDataFunc can happen for
   *   compound glyphs.
   *
   */
  typedef FT_Error
  (*FT_Incremental_GetGlyphDataFunc)( FT_Incremental  incremental,
                                      FT_UInt         glyph_index,
                                      FT_Data*        adata );
/***************************************************************************
   *
   * @type:
   *   FT_Incremental_FreeGlyphDataFunc
   *
   * @description:
   *   A function used to release the glyph data bytes returned by a
   *   successful call to @FT_Incremental_GetGlyphDataFunc.
   *
   * @input:
   *   incremental ::
   *     A handle to an opaque @FT_Incremental handle provided by the client
   *     application.
   *
   *   data ::
   *     A structure describing the glyph data bytes (which will be accessed
   *     as a read-only byte block).
   *
   */
  typedef void
  (*FT_Incremental_FreeGlyphDataFunc)( FT_Incremental  incremental,
                                       FT_Data*        data );
/***************************************************************************
   *
   * @type:
   *   FT_Incremental_GetGlyphMetricsFunc
   *
   * @description:
   *   A function used to retrieve the basic metrics of a given glyph index
   *   before accessing its data.  This is necessary because, in certain
   *   formats like TrueType, the metrics are stored in a different place from
   *   the glyph images proper.
   *
   * @input:
   *   incremental ::
   *     A handle to an opaque @FT_Incremental handle provided by the client
   *     application.
   *
   *   glyph_index ::
   *     Index of relevant glyph.
   *
   *   vertical ::
   *     If true, return vertical metrics.
   *
   *   ametrics ::
   *     This parameter is used for both input and output.
   *     The original glyph metrics, if any, in font units.  If metrics are
   *     not available all the values must be set to zero.
   *
   * @output:
   *   ametrics ::
   *     The replacement glyph metrics in font units.
   *
   */
  typedef FT_Error
  (*FT_Incremental_GetGlyphMetricsFunc)
                      ( FT_Incremental              incremental,
                        FT_UInt                     glyph_index,
                        FT_Bool                     vertical,
                        FT_Incremental_MetricsRec  *ametrics );
/**************************************************************************
   *
   * @struct:
   *   FT_Incremental_FuncsRec
   *
   * @description:
   *   A table of functions for accessing fonts that load data
   *   incrementally.  Used in @FT_Incremental_InterfaceRec.
   *
   * @fields:
   *   get_glyph_data ::
   *     The function to get glyph data.  Must not be null.
   *
   *   free_glyph_data ::
   *     The function to release glyph data.  Must not be null.
   *
   *   get_glyph_metrics ::
   *     The function to get glyph metrics.  May be null if the font does
   *     not provide overriding glyph metrics.
   *
   */
  typedef struct  FT_Incremental_FuncsRec_
  {
    FT_Incremental_GetGlyphDataFunc     get_glyph_data;
    FT_Incremental_FreeGlyphDataFunc    free_glyph_data;
    FT_Incremental_GetGlyphMetricsFunc  get_glyph_metrics;
  } FT_Incremental_FuncsRec;
/***************************************************************************
   *
   * @struct:
   *   FT_Incremental_InterfaceRec
   *
   * @description:
   *   A structure to be used with @FT_Open_Face to indicate that the user
   *   wants to support incremental glyph loading.  You should use it with
   *   @FT_PARAM_TAG_INCREMENTAL as in the following example:
   *
   *     {
   *       FT_Incremental_InterfaceRec  inc_int;
   *       FT_Parameter                 parameter;
   *       FT_Open_Args                 open_args;
   *
   *
   *       // set up incremental descriptor
   *       inc_int.funcs  = my_funcs;
   *       inc_int.object = my_object;
   *
   *       // set up optional parameter
   *       parameter.tag  = FT_PARAM_TAG_INCREMENTAL;
   *       parameter.data = &inc_int;
   *
   *       // set up FT_Open_Args structure
   *       open_args.flags      = FT_OPEN_PATHNAME | FT_OPEN_PARAMS;
   *       open_args.pathname   = my_font_pathname;
   *       open_args.num_params = 1;
   *       open_args.params     = &parameter; // we use one optional argument
   *
   *       // open the font
   *       error = FT_Open_Face( library, &open_args, index, &face );
   *       ...
   *     }
   *
   */
  typedef struct  FT_Incremental_InterfaceRec_
  {
    const FT_Incremental_FuncsRec*  funcs;
    FT_Incremental                  object;
  } FT_Incremental_InterfaceRec;
/***************************************************************************
   *
   * @type:
   *   FT_Incremental_Interface
   *
   * @description:
   *   A pointer to an @FT_Incremental_InterfaceRec structure.
   *
   */
  typedef FT_Incremental_InterfaceRec*   FT_Incremental_Interface;
/***************************************************************************
   *
   * @constant:
   *   FT_PARAM_TAG_INCREMENTAL
   *
   * @description:
   *   A constant used as the tag of @FT_Parameter structures to indicate
   *   an incremental loading object to be used by FreeType.
   *
   */
#define FT_PARAM_TAG_INCREMENTAL  FT_MAKE_TAG( 'i', 'n', 'c', 'r' )
/* */
FT_END_HEADER
/* END */
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* Some generic definitions.                                             */
/*                                                                       */
#ifndef TRUE
#define TRUE  1
#endif
#ifndef FALSE
#define FALSE  0
#endif
#ifndef NULL
#define NULL  (void*)0
#endif
/*************************************************************************/
/*                                                                       */
/* The min and max functions missing in C.  As usual, be careful not to  */
/* write things like FT_MIN( a++, b++ ) to avoid side effects.           */
/*                                                                       */
#define FT_MIN( a, b )  ( (a) < (b) ? (a) : (b) )
#define FT_MAX( a, b )  ( (a) > (b) ? (a) : (b) )
#define FT_ABS( a )     ( (a) < 0 ? -(a) : (a) )
#define FT_PAD_FLOOR( x, n )  ( (x) & ~((n)-1) )
#define FT_PAD_ROUND( x, n )  FT_PAD_FLOOR( (x) + ((n)/2), n )
#define FT_PAD_CEIL( x, n )   FT_PAD_FLOOR( (x) + ((n)-1), n )
#define FT_PIX_FLOOR( x )     ( (x) & ~63 )
#define FT_PIX_ROUND( x )     FT_PIX_FLOOR( (x) + 32 )
#define FT_PIX_CEIL( x )      FT_PIX_FLOOR( (x) + 63 )
/*
   *  Return the highest power of 2 that is <= value; this correspond to
   *  the highest bit in a given 32-bit value.
   */
  FT_BASE( FT_UInt32 )
  ft_highpow2( FT_UInt32  value );
/*
   *  character classification functions -- since these are used to parse
   *  font files, we must not use those in <ctypes.h> which are
   *  locale-dependent
   */
#define  ft_isdigit( x )   ( ( (unsigned)(x) - '0' ) < 10U )
#define  ft_isxdigit( x )  ( ( (unsigned)(x) - '0' ) < 10U || \
                             ( (unsigned)(x) - 'a' ) < 6U  || \
                             ( (unsigned)(x) - 'A' ) < 6U  )
/* the next two macros assume ASCII representation */
#define  ft_isupper( x )  ( ( (unsigned)(x) - 'A' ) < 26U )
#define  ft_islower( x )  ( ( (unsigned)(x) - 'a' ) < 26U )
#define  ft_isalpha( x )  ( ft_isupper( x ) || ft_islower( x ) )
#define  ft_isalnum( x )  ( ft_isdigit( x ) || ft_isalpha( x ) )
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****                       C H A R M A P S                           ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* handle to internal charmap object */
  typedef struct FT_CMapRec_*              FT_CMap;
/* handle to charmap class structure */
  typedef const struct FT_CMap_ClassRec_*  FT_CMap_Class;
/* internal charmap object structure */
  typedef struct  FT_CMapRec_
  {
    FT_CharMapRec  charmap;
    FT_CMap_Class  clazz;
  } FT_CMapRec;
/* typecase any pointer to a charmap handle */
#define FT_CMAP( x )              ((FT_CMap)( x ))
/* obvious macros */
#define FT_CMAP_PLATFORM_ID( x )  FT_CMAP( x )->charmap.platform_id
#define FT_CMAP_ENCODING_ID( x )  FT_CMAP( x )->charmap.encoding_id
#define FT_CMAP_ENCODING( x )     FT_CMAP( x )->charmap.encoding
#define FT_CMAP_FACE( x )         FT_CMAP( x )->charmap.face
/* class method definitions */
  typedef FT_Error
  (*FT_CMap_InitFunc)( FT_CMap     cmap,
                       FT_Pointer  init_data );
  typedef void
  (*FT_CMap_DoneFunc)( FT_CMap  cmap );
  typedef FT_UInt
  (*FT_CMap_CharIndexFunc)( FT_CMap    cmap,
                            FT_UInt32  char_code );
  typedef FT_UInt
  (*FT_CMap_CharNextFunc)( FT_CMap     cmap,
                           FT_UInt32  *achar_code );
  typedef FT_UInt
  (*FT_CMap_CharVarIndexFunc)( FT_CMap    cmap,
                               FT_CMap    unicode_cmap,
                               FT_UInt32  char_code,
                               FT_UInt32  variant_selector );
  typedef FT_Bool
  (*FT_CMap_CharVarIsDefaultFunc)( FT_CMap    cmap,
                                   FT_UInt32  char_code,
                                   FT_UInt32  variant_selector );
  typedef FT_UInt32 *
  (*FT_CMap_VariantListFunc)( FT_CMap    cmap,
                              FT_Memory  mem );
  typedef FT_UInt32 *
  (*FT_CMap_CharVariantListFunc)( FT_CMap    cmap,
                                  FT_Memory  mem,
                                  FT_UInt32  char_code );
  typedef FT_UInt32 *
  (*FT_CMap_VariantCharListFunc)( FT_CMap    cmap,
                                  FT_Memory  mem,
                                  FT_UInt32  variant_selector );
  typedef struct  FT_CMap_ClassRec_
  {
    FT_ULong               size;
    FT_CMap_InitFunc       init;
    FT_CMap_DoneFunc       done;
    FT_CMap_CharIndexFunc  char_index;
    FT_CMap_CharNextFunc   char_next;
/* Subsequent entries are special ones for format 14 -- the variant */
/* selector subtable which behaves like no other                    */
    FT_CMap_CharVarIndexFunc      char_var_index;
    FT_CMap_CharVarIsDefaultFunc  char_var_default;
    FT_CMap_VariantListFunc       variant_list;
    FT_CMap_CharVariantListFunc   charvariant_list;
    FT_CMap_VariantCharListFunc   variantchar_list;
  } FT_CMap_ClassRec;
#define FT_DECLARE_CMAP_CLASS( class_ )              \
  FT_CALLBACK_TABLE const  FT_CMap_ClassRec class_;
#define FT_DEFINE_CMAP_CLASS(       \
          class_,                   \
          size_,                    \
          init_,                    \
          done_,                    \
          char_index_,              \
          char_next_,               \
          char_var_index_,          \
          char_var_default_,        \
          variant_list_,            \
          charvariant_list_,        \
          variantchar_list_ )       \
  FT_CALLBACK_TABLE_DEF             \
  const FT_CMap_ClassRec  class_ =  \
  {                                 \
    size_,                          \
    init_,                          \
    done_,                          \
    char_index_,                    \
    char_next_,                     \
    char_var_index_,                \
    char_var_default_,              \
    variant_list_,                  \
    charvariant_list_,              \
    variantchar_list_               \
  };
/* create a new charmap and add it to charmap->face */
  FT_BASE( FT_Error )
  FT_CMap_New( FT_CMap_Class  clazz,
               FT_Pointer     init_data,
               FT_CharMap     charmap,
               FT_CMap       *acmap );
/* destroy a charmap and remove it from face's list */
  FT_BASE( void )
  FT_CMap_Done( FT_CMap  cmap );
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Face_InternalRec                                                */
/*                                                                       */
/* <Description>                                                         */
/*    This structure contains the internal fields of each FT_Face        */
/*    object.  These fields may change between different releases of     */
/*    FreeType.                                                          */
/*                                                                       */
/* <Fields>                                                              */
/*    max_points ::                                                      */
/*      The maximum number of points used to store the vectorial outline */
/*      of any glyph in this face.  If this value cannot be known in     */
/*      advance, or if the face isn't scalable, this should be set to 0. */
/*      Only relevant for scalable formats.                              */
/*                                                                       */
/*    max_contours ::                                                    */
/*      The maximum number of contours used to store the vectorial       */
/*      outline of any glyph in this face.  If this value cannot be      */
/*      known in advance, or if the face isn't scalable, this should be  */
/*      set to 0.  Only relevant for scalable formats.                   */
/*                                                                       */
/*    transform_matrix ::                                                */
/*      A 2x2 matrix of 16.16 coefficients used to transform glyph       */
/*      outlines after they are loaded from the font.  Only used by the  */
/*      convenience functions.                                           */
/*                                                                       */
/*    transform_delta ::                                                 */
/*      A translation vector used to transform glyph outlines after they */
/*      are loaded from the font.  Only used by the convenience          */
/*      functions.                                                       */
/*                                                                       */
/*    transform_flags ::                                                 */
/*      Some flags used to classify the transform.  Only used by the     */
/*      convenience functions.                                           */
/*                                                                       */
/*    services ::                                                        */
/*      A cache for frequently used services.  It should be only         */
/*      accessed with the macro `FT_FACE_LOOKUP_SERVICE'.                */
/*                                                                       */
/*    incremental_interface ::                                           */
/*      If non-null, the interface through which glyph data and metrics  */
/*      are loaded incrementally for faces that do not provide all of    */
/*      this data when first opened.  This field exists only if          */
/*      @FT_CONFIG_OPTION_INCREMENTAL is defined.                        */
/*                                                                       */
/*    ignore_unpatented_hinter ::                                        */
/*      This boolean flag instructs the glyph loader to ignore the       */
/*      native font hinter, if one is found.  This is exclusively used   */
/*      in the case when the unpatented hinter is compiled within the    */
/*      library.                                                         */
/*                                                                       */
/*    refcount ::                                                        */
/*      A counter initialized to~1 at the time an @FT_Face structure is  */
/*      created.  @FT_Reference_Face increments this counter, and        */
/*      @FT_Done_Face only destroys a face if the counter is~1,          */
/*      otherwise it simply decrements it.                               */
/*                                                                       */
  typedef struct  FT_Face_InternalRec_
  {
    FT_Matrix           transform_matrix;
    FT_Vector           transform_delta;
    FT_Int              transform_flags;
    FT_ServiceCacheRec  services;
    FT_Incremental_InterfaceRec*  incremental_interface;
    FT_Bool             ignore_unpatented_hinter;
    FT_UInt             refcount;
  } FT_Face_InternalRec;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Slot_InternalRec                                                */
/*                                                                       */
/* <Description>                                                         */
/*    This structure contains the internal fields of each FT_GlyphSlot   */
/*    object.  These fields may change between different releases of     */
/*    FreeType.                                                          */
/*                                                                       */
/* <Fields>                                                              */
/*    loader            :: The glyph loader object used to load outlines */
/*                         into the glyph slot.                          */
/*                                                                       */
/*    flags             :: Possible values are zero or                   */
/*                         FT_GLYPH_OWN_BITMAP.  The latter indicates    */
/*                         that the FT_GlyphSlot structure owns the      */
/*                         bitmap buffer.                                */
/*                                                                       */
/*    glyph_transformed :: Boolean.  Set to TRUE when the loaded glyph   */
/*                         must be transformed through a specific        */
/*                         font transformation.  This is _not_ the same  */
/*                         as the face transform set through             */
/*                         FT_Set_Transform().                           */
/*                                                                       */
/*    glyph_matrix      :: The 2x2 matrix corresponding to the glyph     */
/*                         transformation, if necessary.                 */
/*                                                                       */
/*    glyph_delta       :: The 2d translation vector corresponding to    */
/*                         the glyph transformation, if necessary.       */
/*                                                                       */
/*    glyph_hints       :: Format-specific glyph hints management.       */
/*                                                                       */
#define FT_GLYPH_OWN_BITMAP  0x1
  typedef struct  FT_Slot_InternalRec_
  {
    FT_GlyphLoader  loader;
    FT_UInt         flags;
    FT_Bool         glyph_transformed;
    FT_Matrix       glyph_matrix;
    FT_Vector       glyph_delta;
    void*           glyph_hints;
  } FT_GlyphSlot_InternalRec;
#if 0
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_Size_InternalRec                                                */
/*                                                                       */
/* <Description>                                                         */
/*    This structure contains the internal fields of each FT_Size        */
/*    object.  Currently, it's empty.                                    */
/*                                                                       */
/*************************************************************************/
  typedef struct  FT_Size_InternalRec_
  {
/* empty */
  } FT_Size_InternalRec;
#endif
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****                         M O D U L E S                           ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_ModuleRec                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    A module object instance.                                          */
/*                                                                       */
/* <Fields>                                                              */
/*    clazz   :: A pointer to the module's class.                        */
/*                                                                       */
/*    library :: A handle to the parent library object.                  */
/*                                                                       */
/*    memory  :: A handle to the memory manager.                         */
/*                                                                       */
  typedef struct  FT_ModuleRec_
  {
    FT_Module_Class*  clazz;
    FT_Library        library;
    FT_Memory         memory;
  } FT_ModuleRec;
/* typecast an object to an FT_Module */
#define FT_MODULE( x )          ((FT_Module)( x ))
#define FT_MODULE_CLASS( x )    FT_MODULE( x )->clazz
#define FT_MODULE_LIBRARY( x )  FT_MODULE( x )->library
#define FT_MODULE_MEMORY( x )   FT_MODULE( x )->memory
#define FT_MODULE_IS_DRIVER( x )  ( FT_MODULE_CLASS( x )->module_flags & \
                                    FT_MODULE_FONT_DRIVER )
#define FT_MODULE_IS_RENDERER( x )  ( FT_MODULE_CLASS( x )->module_flags & \
                                      FT_MODULE_RENDERER )
#define FT_MODULE_IS_HINTER( x )  ( FT_MODULE_CLASS( x )->module_flags & \
                                    FT_MODULE_HINTER )
#define FT_MODULE_IS_STYLER( x )  ( FT_MODULE_CLASS( x )->module_flags & \
                                    FT_MODULE_STYLER )
#define FT_DRIVER_IS_SCALABLE( x )  ( FT_MODULE_CLASS( x )->module_flags & \
                                      FT_MODULE_DRIVER_SCALABLE )
#define FT_DRIVER_USES_OUTLINES( x )  !( FT_MODULE_CLASS( x )->module_flags & \
                                         FT_MODULE_DRIVER_NO_OUTLINES )
#define FT_DRIVER_HAS_HINTER( x )  ( FT_MODULE_CLASS( x )->module_flags & \
                                     FT_MODULE_DRIVER_HAS_HINTER )
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Module_Interface                                            */
/*                                                                       */
/* <Description>                                                         */
/*    Finds a module and returns its specific interface as a typeless    */
/*    pointer.                                                           */
/*                                                                       */
/* <Input>                                                               */
/*    library     :: A handle to the library object.                     */
/*                                                                       */
/*    module_name :: The module's name (as an ASCII string).             */
/*                                                                       */
/* <Return>                                                              */
/*    A module-specific interface if available, 0 otherwise.             */
/*                                                                       */
/* <Note>                                                                */
/*    You should better be familiar with FreeType internals to know      */
/*    which module to look for, and what its interface is :-)            */
/*                                                                       */
  FT_BASE( const void* )
  FT_Get_Module_Interface( FT_Library   library,
                           const char*  mod_name );
  FT_BASE( FT_Pointer )
  ft_module_get_service( FT_Module    module,
                         const char*  service_id );
/* */
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****   F A C E,   S I Z E   &   G L Y P H   S L O T   O B J E C T S  ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* a few macros used to perform easy typecasts with minimal brain damage */
#define FT_FACE( x )          ((FT_Face)(x))
#define FT_SIZE( x )          ((FT_Size)(x))
#define FT_SLOT( x )          ((FT_GlyphSlot)(x))
#define FT_FACE_DRIVER( x )   FT_FACE( x )->driver
#define FT_FACE_LIBRARY( x )  FT_FACE_DRIVER( x )->root.library
#define FT_FACE_MEMORY( x )   FT_FACE( x )->memory
#define FT_FACE_STREAM( x )   FT_FACE( x )->stream
#define FT_SIZE_FACE( x )     FT_SIZE( x )->face
#define FT_SLOT_FACE( x )     FT_SLOT( x )->face
#define FT_FACE_SLOT( x )     FT_FACE( x )->glyph
#define FT_FACE_SIZE( x )     FT_FACE( x )->size
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_New_GlyphSlot                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    It is sometimes useful to have more than one glyph slot for a      */
/*    given face object.  This function is used to create additional     */
/*    slots.  All of them are automatically discarded when the face is   */
/*    destroyed.                                                         */
/*                                                                       */
/* <Input>                                                               */
/*    face  :: A handle to a parent face object.                         */
/*                                                                       */
/* <Output>                                                              */
/*    aslot :: A handle to a new glyph slot object.                      */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0 means success.                             */
/*                                                                       */
  FT_BASE( FT_Error )
  FT_New_GlyphSlot( FT_Face        face,
                    FT_GlyphSlot  *aslot );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Done_GlyphSlot                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Destroys a given glyph slot.  Remember however that all slots are  */
/*    automatically destroyed with its parent.  Using this function is   */
/*    not always mandatory.                                              */
/*                                                                       */
/* <Input>                                                               */
/*    slot :: A handle to a target glyph slot.                           */
/*                                                                       */
  FT_BASE( void )
  FT_Done_GlyphSlot( FT_GlyphSlot  slot );
/* */
#define FT_REQUEST_WIDTH( req )                                            \
          ( (req)->horiResolution                                          \
              ? (FT_Pos)( (req)->width * (req)->horiResolution + 36 ) / 72 \
              : (req)->width )
#define FT_REQUEST_HEIGHT( req )                                            \
          ( (req)->vertResolution                                           \
              ? (FT_Pos)( (req)->height * (req)->vertResolution + 36 ) / 72 \
              : (req)->height )
/* Set the metrics according to a bitmap strike. */
  FT_BASE( void )
  FT_Select_Metrics( FT_Face   face,
                     FT_ULong  strike_index );
/* Set the metrics according to a size request. */
  FT_BASE( void )
  FT_Request_Metrics( FT_Face          face,
                      FT_Size_Request  req );
/* Match a size request against `available_sizes'. */
  FT_BASE( FT_Error )
  FT_Match_Size( FT_Face          face,
                 FT_Size_Request  req,
                 FT_Bool          ignore_width,
                 FT_ULong*        size_index );
/* Use the horizontal metrics to synthesize the vertical metrics. */
/* If `advance' is zero, it is also synthesized.                  */
  FT_BASE( void )
  ft_synthesize_vertical_metrics( FT_Glyph_Metrics*  metrics,
                                  FT_Pos             advance );
/* Free the bitmap of a given glyphslot when needed (i.e., only when it */
/* was allocated with ft_glyphslot_alloc_bitmap).                       */
  FT_BASE( void )
  ft_glyphslot_free_bitmap( FT_GlyphSlot  slot );
/* Allocate a new bitmap buffer in a glyph slot. */
  FT_BASE( FT_Error )
  ft_glyphslot_alloc_bitmap( FT_GlyphSlot  slot,
                             FT_ULong      size );
/* Set the bitmap buffer in a glyph slot to a given pointer.  The buffer */
/* will not be freed by a later call to ft_glyphslot_free_bitmap.        */
  FT_BASE( void )
  ft_glyphslot_set_bitmap( FT_GlyphSlot  slot,
                           FT_Byte*      buffer );
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****                        R E N D E R E R S                        ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
#define FT_RENDERER( x )      ((FT_Renderer)( x ))
#define FT_GLYPH( x )         ((FT_Glyph)( x ))
#define FT_BITMAP_GLYPH( x )  ((FT_BitmapGlyph)( x ))
#define FT_OUTLINE_GLYPH( x ) ((FT_OutlineGlyph)( x ))
  typedef struct  FT_RendererRec_
  {
    FT_ModuleRec            root;
    FT_Renderer_Class*      clazz;
    FT_Glyph_Format         glyph_format;
    FT_Glyph_Class          glyph_class;
    FT_Raster               raster;
    FT_Raster_Render_Func   raster_render;
    FT_Renderer_RenderFunc  render;
  } FT_RendererRec;
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****                    F O N T   D R I V E R S                      ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* typecast a module into a driver easily */
#define FT_DRIVER( x )        ((FT_Driver)(x))
/* typecast a module as a driver, and get its driver class */
#define FT_DRIVER_CLASS( x )  FT_DRIVER( x )->clazz
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_DriverRec                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    The root font driver class.  A font driver is responsible for      */
/*    managing and loading font files of a given format.                 */
/*                                                                       */
/*  <Fields>                                                             */
/*     root         :: Contains the fields of the root module class.     */
/*                                                                       */
/*     clazz        :: A pointer to the font driver's class.  Note that  */
/*                     this is NOT root.clazz.  `class' wasn't used      */
/*                     as it is a reserved word in C++.                  */
/*                                                                       */
/*     faces_list   :: The list of faces currently opened by this        */
/*                     driver.                                           */
/*                                                                       */
/*     glyph_loader :: The glyph loader for all faces managed by this    */
/*                     driver.  This object isn't defined for unscalable */
/*                     formats.                                          */
/*                                                                       */
  typedef struct  FT_DriverRec_
  {
    FT_ModuleRec     root;
    FT_Driver_Class  clazz;
    FT_ListRec       faces_list;
    FT_GlyphLoader   glyph_loader;
  } FT_DriverRec;
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****                       L I B R A R I E S                         ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* This hook is used by the TrueType debugger.  It must be set to an */
/* alternate truetype bytecode interpreter function.                 */
#define FT_DEBUG_HOOK_TRUETYPE            0
/* Set this debug hook to a non-null pointer to force unpatented hinting */
/* for all faces when both TT_USE_BYTECODE_INTERPRETER and               */
/* TT_CONFIG_OPTION_UNPATENTED_HINTING are defined.  This is only used   */
/* during debugging.                                                     */
#define FT_DEBUG_HOOK_UNPATENTED_HINTING  1
  typedef void  (*FT_Bitmap_LcdFilterFunc)( FT_Bitmap*      bitmap,
                                            FT_Render_Mode  render_mode,
                                            FT_Library      library );
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    FT_LibraryRec                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    The FreeType library class.  This is the root of all FreeType      */
/*    data.  Use FT_New_Library() to create a library object, and        */
/*    FT_Done_Library() to discard it and all child objects.             */
/*                                                                       */
/* <Fields>                                                              */
/*    memory           :: The library's memory object.  Manages memory   */
/*                        allocation.                                    */
/*                                                                       */
/*    version_major    :: The major version number of the library.       */
/*                                                                       */
/*    version_minor    :: The minor version number of the library.       */
/*                                                                       */
/*    version_patch    :: The current patch level of the library.        */
/*                                                                       */
/*    num_modules      :: The number of modules currently registered     */
/*                        within this library.  This is set to 0 for new */
/*                        libraries.  New modules are added through the  */
/*                        FT_Add_Module() API function.                  */
/*                                                                       */
/*    modules          :: A table used to store handles to the currently */
/*                        registered modules. Note that each font driver */
/*                        contains a list of its opened faces.           */
/*                                                                       */
/*    renderers        :: The list of renderers currently registered     */
/*                        within the library.                            */
/*                                                                       */
/*    cur_renderer     :: The current outline renderer.  This is a       */
/*                        shortcut used to avoid parsing the list on     */
/*                        each call to FT_Outline_Render().  It is a     */
/*                        handle to the current renderer for the         */
/*                        FT_GLYPH_FORMAT_OUTLINE format.                */
/*                                                                       */
/*    auto_hinter      :: XXX                                            */
/*                                                                       */
/*    raster_pool      :: The raster object's render pool.  This can     */
/*                        ideally be changed dynamically at run-time.    */
/*                                                                       */
/*    raster_pool_size :: The size of the render pool in bytes.          */
/*                                                                       */
/*    debug_hooks      :: XXX                                            */
/*                                                                       */
/*    lcd_filter       :: If subpixel rendering is activated, the        */
/*                        selected LCD filter mode.                      */
/*                                                                       */
/*    lcd_extra        :: If subpixel rendering is activated, the number */
/*                        of extra pixels needed for the LCD filter.     */
/*                                                                       */
/*    lcd_weights      :: If subpixel rendering is activated, the LCD    */
/*                        filter weights, if any.                        */
/*                                                                       */
/*    lcd_filter_func  :: If subpixel rendering is activated, the LCD    */
/*                        filtering callback function.                   */
/*                                                                       */
/*    pic_container    :: Contains global structs and tables, instead    */
/*                        of defining them globallly.                    */
/*                                                                       */
/*    refcount         :: A counter initialized to~1 at the time an      */
/*                        @FT_Library structure is created.              */
/*                        @FT_Reference_Library increments this counter, */
/*                        and @FT_Done_Library only destroys a library   */
/*                        if the counter is~1, otherwise it simply       */
/*                        decrements it.                                 */
/*                                                                       */
  typedef struct  FT_LibraryRec_
  {
/* library's memory manager */
    FT_Memory          memory;            
    FT_Int             version_major;
    FT_Int             version_minor;
    FT_Int             version_patch;
    FT_UInt            num_modules;
/* module objects  */
    FT_Module          modules[FT_MAX_MODULES];   
/* list of renderers        */
    FT_ListRec         renderers;         
/* current outline renderer */
    FT_Renderer        cur_renderer;      
    FT_Module          auto_hinter;
/* scan-line conversion */
    FT_Byte*           raster_pool;       
/* render pool          */
/* size of render pool in bytes */
    FT_ULong           raster_pool_size;  
    FT_DebugHook_Func  debug_hooks[4];
    FT_LcdFilter             lcd_filter;
/* number of extra pixels */
    FT_Int                   lcd_extra;         
/* filter weights, if any */
    FT_Byte                  lcd_weights[7];    
/* filtering callback     */
    FT_Bitmap_LcdFilterFunc  lcd_filter_func;   
    FT_UInt            refcount;
  } FT_LibraryRec;
  FT_BASE( FT_Renderer )
  FT_Lookup_Renderer( FT_Library       library,
                      FT_Glyph_Format  format,
                      FT_ListNode*     node );
  FT_BASE( FT_Error )
  FT_Render_Glyph_Internal( FT_Library      library,
                            FT_GlyphSlot    slot,
                            FT_Render_Mode  render_mode );
  typedef const char*
  (*FT_Face_GetPostscriptNameFunc)( FT_Face  face );
  typedef FT_Error
  (*FT_Face_GetGlyphNameFunc)( FT_Face     face,
                               FT_UInt     glyph_index,
                               FT_Pointer  buffer,
                               FT_UInt     buffer_max );
  typedef FT_UInt
  (*FT_Face_GetGlyphNameIndexFunc)( FT_Face     face,
                                    FT_String*  glyph_name );
#ifndef FT_CONFIG_OPTION_NO_DEFAULT_SYSTEM
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_New_Memory                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    Creates a new memory object.                                       */
/*                                                                       */
/* <Return>                                                              */
/*    A pointer to the new memory object.  0 in case of error.           */
/*                                                                       */
  FT_BASE( FT_Memory )
  FT_New_Memory( void );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Done_Memory                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    Discards memory manager.                                           */
/*                                                                       */
/* <Input>                                                               */
/*    memory :: A handle to the memory manager.                          */
/*                                                                       */
  FT_BASE( void )
  FT_Done_Memory( FT_Memory  memory );
/* !FT_CONFIG_OPTION_NO_DEFAULT_SYSTEM */
#endif  
/* Define default raster's interface.  The default raster is located in  */
/* `src/base/ftraster.c'.                                                */
/*                                                                       */
/* Client applications can register new rasters through the              */
/* FT_Set_Raster() API.                                                  */
#ifndef FT_NO_DEFAULT_RASTER
  FT_EXPORT_VAR( FT_Raster_Funcs )  ft_default_raster;
#endif
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****                      P I C   S U P P O R T                      ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* PIC support macros for ftimage.h */
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DEFINE_OUTLINE_FUNCS                                            */
/*                                                                       */
/* <Description>                                                         */
/*    Used to initialize an instance of FT_Outline_Funcs struct.         */
/*    When FT_CONFIG_OPTION_PIC is defined an init funtion will need to  */
/*    be called with a pre-allocated structure to be filled.             */
/*    When FT_CONFIG_OPTION_PIC is not defined the struct will be        */
/*    allocated in the global scope (or the scope where the macro        */
/*    is used).                                                          */
/*                                                                       */
#define FT_DEFINE_OUTLINE_FUNCS(           \
          class_,                          \
          move_to_,                        \
          line_to_,                        \
          conic_to_,                       \
          cubic_to_,                       \
          shift_,                          \
          delta_ )                         \
  static const  FT_Outline_Funcs class_ =  \
  {                                        \
    move_to_,                              \
    line_to_,                              \
    conic_to_,                             \
    cubic_to_,                             \
    shift_,                                \
    delta_                                 \
  };
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DEFINE_RASTER_FUNCS                                             */
/*                                                                       */
/* <Description>                                                         */
/*    Used to initialize an instance of FT_Raster_Funcs struct.          */
/*    When FT_CONFIG_OPTION_PIC is defined an init funtion will need to  */
/*    be called with a pre-allocated structure to be filled.             */
/*    When FT_CONFIG_OPTION_PIC is not defined the struct will be        */
/*    allocated in the global scope (or the scope where the macro        */
/*    is used).                                                          */
/*                                                                       */
#define FT_DEFINE_RASTER_FUNCS(    \
          class_,                  \
          glyph_format_,           \
          raster_new_,             \
          raster_reset_,           \
          raster_set_mode_,        \
          raster_render_,          \
          raster_done_ )           \
  const FT_Raster_Funcs  class_ =  \
  {                                \
    glyph_format_,                 \
    raster_new_,                   \
    raster_reset_,                 \
    raster_set_mode_,              \
    raster_render_,                \
    raster_done_                   \
  };
/* PIC support macros for ftrender.h */
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DEFINE_GLYPH                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Used to initialize an instance of FT_Glyph_Class struct.           */
/*    When FT_CONFIG_OPTION_PIC is defined an init funtion will need to  */
/*    be called with a pre-allocated stcture to be filled.               */
/*    When FT_CONFIG_OPTION_PIC is not defined the struct will be        */
/*    allocated in the global scope (or the scope where the macro        */
/*    is used).                                                          */
/*                                                                       */
#define FT_DEFINE_GLYPH(          \
          class_,                 \
          size_,                  \
          format_,                \
          init_,                  \
          done_,                  \
          copy_,                  \
          transform_,             \
          bbox_,                  \
          prepare_ )              \
  FT_CALLBACK_TABLE_DEF           \
  const FT_Glyph_Class  class_ =  \
  {                               \
    size_,                        \
    format_,                      \
    init_,                        \
    done_,                        \
    copy_,                        \
    transform_,                   \
    bbox_,                        \
    prepare_                      \
  };
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DECLARE_RENDERER                                                */
/*                                                                       */
/* <Description>                                                         */
/*    Used to create a forward declaration of a                          */
/*    FT_Renderer_Class struct instance.                                 */
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DEFINE_RENDERER                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    Used to initialize an instance of FT_Renderer_Class struct.        */
/*                                                                       */
/*    When FT_CONFIG_OPTION_PIC is defined a `create' funtion will need  */
/*    to be called with a pointer where the allocated structure is       */
/*    returned.  And when it is no longer needed a `destroy' function    */
/*    needs to be called to release that allocation.                     */
/*    `fcinit.c' (ft_create_default_module_classes) already contains     */
/*    a mechanism to call these functions for the default modules        */
/*    described in `ftmodule.h'.                                         */
/*                                                                       */
/*    Notice that the created `create' and `destroy' functions call      */
/*    `pic_init' and `pic_free' to allow you to manually allocate and    */
/*    initialize any additional global data, like a module specific      */
/*    interface, and put them in the global pic container defined in     */
/*    `ftpic.h'.  If you don't need them just implement the functions as */
/*    empty to resolve the link error.  Also the `pic_init' and          */
/*    `pic_free' functions should be declared in `pic.h', to be referred */
/*    by the renderer definition calling `FT_DEFINE_RENDERER' in the     */
/*    following.                                                         */
/*                                                                       */
/*    When FT_CONFIG_OPTION_PIC is not defined the struct will be        */
/*    allocated in the global scope (or the scope where the macro        */
/*    is used).                                                          */
/*                                                                       */
#define FT_DECLARE_RENDERER( class_ )               \
  FT_EXPORT_VAR( const FT_Renderer_Class ) class_;
#define FT_DEFINE_RENDERER(                  \
          class_,                            \
          flags_,                            \
          size_,                             \
          name_,                             \
          version_,                          \
          requires_,                         \
          interface_,                        \
          init_,                             \
          done_,                             \
          get_interface_,                    \
          glyph_format_,                     \
          render_glyph_,                     \
          transform_glyph_,                  \
          get_glyph_cbox_,                   \
          set_mode_,                         \
          raster_class_ )                    \
  FT_CALLBACK_TABLE_DEF                      \
  const FT_Renderer_Class  class_ =          \
  {                                          \
    FT_DEFINE_ROOT_MODULE( flags_,           \
                           size_,            \
                           name_,            \
                           version_,         \
                           requires_,        \
                           interface_,       \
                           init_,            \
                           done_,            \
                           get_interface_ )  \
    glyph_format_,                           \
                                             \
    render_glyph_,                           \
    transform_glyph_,                        \
    get_glyph_cbox_,                         \
    set_mode_,                               \
                                             \
    raster_class_                            \
  };
/* PIC support macros for ftmodapi.h **/
/*************************************************************************/
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DECLARE_MODULE                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Used to create a forward declaration of a                          */
/*    FT_Module_Class struct instance.                                   */
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DEFINE_MODULE                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Used to initialize an instance of an FT_Module_Class struct.       */
/*                                                                       */
/*    When FT_CONFIG_OPTION_PIC is defined a `create' funtion needs to   */
/*    be called with a pointer where the allocated structure is          */
/*    returned.  And when it is no longer needed a `destroy' function    */
/*    needs to be called to release that allocation.                     */
/*    `fcinit.c' (ft_create_default_module_classes) already contains     */
/*    a mechanism to call these functions for the default modules        */
/*    described in `ftmodule.h'.                                         */
/*                                                                       */
/*    Notice that the created `create' and `destroy' functions call      */
/*    `pic_init' and `pic_free' to allow you to manually allocate and    */
/*    initialize any additional global data, like a module specific      */
/*    interface, and put them in the global pic container defined in     */
/*    `ftpic.h'.  If you don't need them just implement the functions as */
/*    empty to resolve the link error.  Also the `pic_init' and          */
/*    `pic_free' functions should be declared in `pic.h', to be referred */
/*    by the module definition calling `FT_DEFINE_MODULE' in the         */
/*    following.                                                         */
/*                                                                       */
/*    When FT_CONFIG_OPTION_PIC is not defined the struct will be        */
/*    allocated in the global scope (or the scope where the macro        */
/*    is used).                                                          */
/*                                                                       */
/* <Macro>                                                               */
/*    FT_DEFINE_ROOT_MODULE                                              */
/*                                                                       */
/* <Description>                                                         */
/*    Used to initialize an instance of an FT_Module_Class struct inside */
/*    another struct that contains it or in a function that initializes  */
/*    that containing struct.                                            */
/*                                                                       */
#define FT_DECLARE_MODULE( class_ )  \
  FT_CALLBACK_TABLE                  \
  const FT_Module_Class  class_;
#define FT_DEFINE_ROOT_MODULE(  \
          flags_,               \
          size_,                \
          name_,                \
          version_,             \
          requires_,            \
          interface_,           \
          init_,                \
          done_,                \
          get_interface_ )      \
  {                             \
    flags_,                     \
    size_,                      \
                                \
    name_,                      \
    version_,                   \
    requires_,                  \
                                \
    interface_,                 \
                                \
    init_,                      \
    done_,                      \
    get_interface_,             \
  },
#define FT_DEFINE_MODULE(         \
          class_,                 \
          flags_,                 \
          size_,                  \
          name_,                  \
          version_,               \
          requires_,              \
          interface_,             \
          init_,                  \
          done_,                  \
          get_interface_ )        \
  FT_CALLBACK_TABLE_DEF           \
  const FT_Module_Class class_ =  \
  {                               \
    flags_,                       \
    size_,                        \
                                  \
    name_,                        \
    version_,                     \
    requires_,                    \
                                  \
    interface_,                   \
                                  \
    init_,                        \
    done_,                        \
    get_interface_,               \
  };
FT_END_HEADER
/* END */
FT_BEGIN_HEADER
/* format of an 8-bit frame_op value:           */
/*                                              */
/* bit  76543210                                */
/*      xxxxxxes                                */
/*                                              */
/* s is set to 1 if the value is signed.        */
/* e is set to 1 if the value is little-endian. */
/* xxx is a command.                            */
#define FT_FRAME_OP_SHIFT         2
#define FT_FRAME_OP_SIGNED        1
#define FT_FRAME_OP_LITTLE        2
#define FT_FRAME_OP_COMMAND( x )  ( x >> FT_FRAME_OP_SHIFT )
#define FT_MAKE_FRAME_OP( command, little, sign ) \
          ( ( command << FT_FRAME_OP_SHIFT ) | ( little << 1 ) | sign )
#define FT_FRAME_OP_END    0
/* start a new frame     */
#define FT_FRAME_OP_START  1   
/* read 1-byte value     */
#define FT_FRAME_OP_BYTE   2   
/* read 2-byte value     */
#define FT_FRAME_OP_SHORT  3   
/* read 4-byte value     */
#define FT_FRAME_OP_LONG   4   
/* read 3-byte value     */
#define FT_FRAME_OP_OFF3   5   
/* read a bytes sequence */
#define FT_FRAME_OP_BYTES  6   
  typedef enum  FT_Frame_Op_
  {
    ft_frame_end       = 0,
    ft_frame_start     = FT_MAKE_FRAME_OP( FT_FRAME_OP_START, 0, 0 ),
    ft_frame_byte      = FT_MAKE_FRAME_OP( FT_FRAME_OP_BYTE,  0, 0 ),
    ft_frame_schar     = FT_MAKE_FRAME_OP( FT_FRAME_OP_BYTE,  0, 1 ),
    ft_frame_ushort_be = FT_MAKE_FRAME_OP( FT_FRAME_OP_SHORT, 0, 0 ),
    ft_frame_short_be  = FT_MAKE_FRAME_OP( FT_FRAME_OP_SHORT, 0, 1 ),
    ft_frame_ushort_le = FT_MAKE_FRAME_OP( FT_FRAME_OP_SHORT, 1, 0 ),
    ft_frame_short_le  = FT_MAKE_FRAME_OP( FT_FRAME_OP_SHORT, 1, 1 ),
    ft_frame_ulong_be  = FT_MAKE_FRAME_OP( FT_FRAME_OP_LONG, 0, 0 ),
    ft_frame_long_be   = FT_MAKE_FRAME_OP( FT_FRAME_OP_LONG, 0, 1 ),
    ft_frame_ulong_le  = FT_MAKE_FRAME_OP( FT_FRAME_OP_LONG, 1, 0 ),
    ft_frame_long_le   = FT_MAKE_FRAME_OP( FT_FRAME_OP_LONG, 1, 1 ),
    ft_frame_uoff3_be  = FT_MAKE_FRAME_OP( FT_FRAME_OP_OFF3, 0, 0 ),
    ft_frame_off3_be   = FT_MAKE_FRAME_OP( FT_FRAME_OP_OFF3, 0, 1 ),
    ft_frame_uoff3_le  = FT_MAKE_FRAME_OP( FT_FRAME_OP_OFF3, 1, 0 ),
    ft_frame_off3_le   = FT_MAKE_FRAME_OP( FT_FRAME_OP_OFF3, 1, 1 ),
    ft_frame_bytes     = FT_MAKE_FRAME_OP( FT_FRAME_OP_BYTES, 0, 0 ),
    ft_frame_skip      = FT_MAKE_FRAME_OP( FT_FRAME_OP_BYTES, 0, 1 )
  } FT_Frame_Op;
  typedef struct  FT_Frame_Field_
  {
    FT_Byte    value;
    FT_Byte    size;
    FT_UShort  offset;
  } FT_Frame_Field;
/* Construct an FT_Frame_Field out of a structure type and a field name. */
/* The structure type must be set in the FT_STRUCTURE macro before       */
/* calling the FT_FRAME_START() macro.                                   */
/*                                                                       */
#define FT_FIELD_SIZE( f ) \
          (FT_Byte)sizeof ( ((FT_STRUCTURE*)0)->f )
#define FT_FIELD_SIZE_DELTA( f ) \
          (FT_Byte)sizeof ( ((FT_STRUCTURE*)0)->f[0] )
#define FT_FIELD_OFFSET( f ) \
          (FT_UShort)( offsetof( FT_STRUCTURE, f ) )
#define FT_FRAME_FIELD( frame_op, field ) \
          {                               \
            frame_op,                     \
            FT_FIELD_SIZE( field ),       \
            FT_FIELD_OFFSET( field )      \
          }
#define FT_MAKE_EMPTY_FIELD( frame_op )  { frame_op, 0, 0 }
#define FT_FRAME_START( size )   { ft_frame_start, 0, size }
#define FT_FRAME_END             { ft_frame_end, 0, 0 }
#define FT_FRAME_LONG( f )       FT_FRAME_FIELD( ft_frame_long_be, f )
#define FT_FRAME_ULONG( f )      FT_FRAME_FIELD( ft_frame_ulong_be, f )
#define FT_FRAME_SHORT( f )      FT_FRAME_FIELD( ft_frame_short_be, f )
#define FT_FRAME_USHORT( f )     FT_FRAME_FIELD( ft_frame_ushort_be, f )
#define FT_FRAME_OFF3( f )       FT_FRAME_FIELD( ft_frame_off3_be, f )
#define FT_FRAME_UOFF3( f )      FT_FRAME_FIELD( ft_frame_uoff3_be, f )
#define FT_FRAME_BYTE( f )       FT_FRAME_FIELD( ft_frame_byte, f )
#define FT_FRAME_CHAR( f )       FT_FRAME_FIELD( ft_frame_schar, f )
#define FT_FRAME_LONG_LE( f )    FT_FRAME_FIELD( ft_frame_long_le, f )
#define FT_FRAME_ULONG_LE( f )   FT_FRAME_FIELD( ft_frame_ulong_le, f )
#define FT_FRAME_SHORT_LE( f )   FT_FRAME_FIELD( ft_frame_short_le, f )
#define FT_FRAME_USHORT_LE( f )  FT_FRAME_FIELD( ft_frame_ushort_le, f )
#define FT_FRAME_OFF3_LE( f )    FT_FRAME_FIELD( ft_frame_off3_le, f )
#define FT_FRAME_UOFF3_LE( f )   FT_FRAME_FIELD( ft_frame_uoff3_le, f )
#define FT_FRAME_SKIP_LONG       { ft_frame_long_be, 0, 0 }
#define FT_FRAME_SKIP_SHORT      { ft_frame_short_be, 0, 0 }
#define FT_FRAME_SKIP_BYTE       { ft_frame_byte, 0, 0 }
#define FT_FRAME_BYTES( field, count ) \
          {                            \
            ft_frame_bytes,            \
            count,                     \
            FT_FIELD_OFFSET( field )   \
          }
#define FT_FRAME_SKIP_BYTES( count )  { ft_frame_skip, count, 0 }
/*************************************************************************/
/*                                                                       */
/* Integer extraction macros -- the `buffer' parameter must ALWAYS be of */
/* type `char*' or equivalent (1-byte elements).                         */
/*                                                                       */
#define FT_BYTE_( p, i )  ( ((const FT_Byte*)(p))[(i)] )
#define FT_INT8_( p, i )  ( ((const FT_Char*)(p))[(i)] )
#define FT_INT16( x )   ( (FT_Int16)(x)  )
#define FT_UINT16( x )  ( (FT_UInt16)(x) )
#define FT_INT32( x )   ( (FT_Int32)(x)  )
#define FT_UINT32( x )  ( (FT_UInt32)(x) )
#define FT_BYTE_I16( p, i, s )  ( FT_INT16(  FT_BYTE_( p, i ) ) << (s) )
#define FT_BYTE_U16( p, i, s )  ( FT_UINT16( FT_BYTE_( p, i ) ) << (s) )
#define FT_BYTE_I32( p, i, s )  ( FT_INT32(  FT_BYTE_( p, i ) ) << (s) )
#define FT_BYTE_U32( p, i, s )  ( FT_UINT32( FT_BYTE_( p, i ) ) << (s) )
#define FT_INT8_I16( p, i, s )  ( FT_INT16(  FT_INT8_( p, i ) ) << (s) )
#define FT_INT8_U16( p, i, s )  ( FT_UINT16( FT_INT8_( p, i ) ) << (s) )
#define FT_INT8_I32( p, i, s )  ( FT_INT32(  FT_INT8_( p, i ) ) << (s) )
#define FT_INT8_U32( p, i, s )  ( FT_UINT32( FT_INT8_( p, i ) ) << (s) )
#define FT_PEEK_SHORT( p )  FT_INT16( FT_INT8_I16( p, 0, 8) | \
                                      FT_BYTE_I16( p, 1, 0) )
#define FT_PEEK_USHORT( p )  FT_UINT16( FT_BYTE_U16( p, 0, 8 ) | \
                                        FT_BYTE_U16( p, 1, 0 ) )
#define FT_PEEK_LONG( p )  FT_INT32( FT_INT8_I32( p, 0, 24 ) | \
                                     FT_BYTE_I32( p, 1, 16 ) | \
                                     FT_BYTE_I32( p, 2,  8 ) | \
                                     FT_BYTE_I32( p, 3,  0 ) )
#define FT_PEEK_ULONG( p )  FT_UINT32( FT_BYTE_U32( p, 0, 24 ) | \
                                       FT_BYTE_U32( p, 1, 16 ) | \
                                       FT_BYTE_U32( p, 2,  8 ) | \
                                       FT_BYTE_U32( p, 3,  0 ) )
#define FT_PEEK_OFF3( p )  FT_INT32( FT_INT8_I32( p, 0, 16 ) | \
                                     FT_BYTE_I32( p, 1,  8 ) | \
                                     FT_BYTE_I32( p, 2,  0 ) )
#define FT_PEEK_UOFF3( p )  FT_UINT32( FT_BYTE_U32( p, 0, 16 ) | \
                                       FT_BYTE_U32( p, 1,  8 ) | \
                                       FT_BYTE_U32( p, 2,  0 ) )
#define FT_PEEK_SHORT_LE( p )  FT_INT16( FT_INT8_I16( p, 1, 8 ) | \
                                         FT_BYTE_I16( p, 0, 0 ) )
#define FT_PEEK_USHORT_LE( p )  FT_UINT16( FT_BYTE_U16( p, 1, 8 ) |  \
                                           FT_BYTE_U16( p, 0, 0 ) )
#define FT_PEEK_LONG_LE( p )  FT_INT32( FT_INT8_I32( p, 3, 24 ) | \
                                        FT_BYTE_I32( p, 2, 16 ) | \
                                        FT_BYTE_I32( p, 1,  8 ) | \
                                        FT_BYTE_I32( p, 0,  0 ) )
#define FT_PEEK_ULONG_LE( p )  FT_UINT32( FT_BYTE_U32( p, 3, 24 ) | \
                                          FT_BYTE_U32( p, 2, 16 ) | \
                                          FT_BYTE_U32( p, 1,  8 ) | \
                                          FT_BYTE_U32( p, 0,  0 ) )
#define FT_PEEK_OFF3_LE( p )  FT_INT32( FT_INT8_I32( p, 2, 16 ) | \
                                        FT_BYTE_I32( p, 1,  8 ) | \
                                        FT_BYTE_I32( p, 0,  0 ) )
#define FT_PEEK_UOFF3_LE( p )  FT_UINT32( FT_BYTE_U32( p, 2, 16 ) | \
                                          FT_BYTE_U32( p, 1,  8 ) | \
                                          FT_BYTE_U32( p, 0,  0 ) )
#define FT_NEXT_CHAR( buffer )       \
          ( (signed char)*buffer++ )
#define FT_NEXT_BYTE( buffer )         \
          ( (unsigned char)*buffer++ )
#define FT_NEXT_SHORT( buffer )                                   \
          ( (short)( buffer += 2, FT_PEEK_SHORT( buffer - 2 ) ) )
#define FT_NEXT_USHORT( buffer )                                            \
          ( (unsigned short)( buffer += 2, FT_PEEK_USHORT( buffer - 2 ) ) )
#define FT_NEXT_OFF3( buffer )                                  \
          ( (long)( buffer += 3, FT_PEEK_OFF3( buffer - 3 ) ) )
#define FT_NEXT_UOFF3( buffer )                                           \
          ( (unsigned long)( buffer += 3, FT_PEEK_UOFF3( buffer - 3 ) ) )
#define FT_NEXT_LONG( buffer )                                  \
          ( (long)( buffer += 4, FT_PEEK_LONG( buffer - 4 ) ) )
#define FT_NEXT_ULONG( buffer )                                           \
          ( (unsigned long)( buffer += 4, FT_PEEK_ULONG( buffer - 4 ) ) )
#define FT_NEXT_SHORT_LE( buffer )                                   \
          ( (short)( buffer += 2, FT_PEEK_SHORT_LE( buffer - 2 ) ) )
#define FT_NEXT_USHORT_LE( buffer )                                            \
          ( (unsigned short)( buffer += 2, FT_PEEK_USHORT_LE( buffer - 2 ) ) )
#define FT_NEXT_OFF3_LE( buffer )                                  \
          ( (long)( buffer += 3, FT_PEEK_OFF3_LE( buffer - 3 ) ) )
#define FT_NEXT_UOFF3_LE( buffer )                                           \
          ( (unsigned long)( buffer += 3, FT_PEEK_UOFF3_LE( buffer - 3 ) ) )
#define FT_NEXT_LONG_LE( buffer )                                  \
          ( (long)( buffer += 4, FT_PEEK_LONG_LE( buffer - 4 ) ) )
#define FT_NEXT_ULONG_LE( buffer )                                           \
          ( (unsigned long)( buffer += 4, FT_PEEK_ULONG_LE( buffer - 4 ) ) )
/*************************************************************************/
/*                                                                       */
/* Each GET_xxxx() macro uses an implicit `stream' variable.             */
/*                                                                       */
#if 0
#define FT_GET_MACRO( type )    FT_NEXT_ ## type ( stream->cursor )
#define FT_GET_CHAR()       FT_GET_MACRO( CHAR )
#define FT_GET_BYTE()       FT_GET_MACRO( BYTE )
#define FT_GET_SHORT()      FT_GET_MACRO( SHORT )
#define FT_GET_USHORT()     FT_GET_MACRO( USHORT )
#define FT_GET_OFF3()       FT_GET_MACRO( OFF3 )
#define FT_GET_UOFF3()      FT_GET_MACRO( UOFF3 )
#define FT_GET_LONG()       FT_GET_MACRO( LONG )
#define FT_GET_ULONG()      FT_GET_MACRO( ULONG )
#define FT_GET_TAG4()       FT_GET_MACRO( ULONG )
#define FT_GET_SHORT_LE()   FT_GET_MACRO( SHORT_LE )
#define FT_GET_USHORT_LE()  FT_GET_MACRO( USHORT_LE )
#define FT_GET_LONG_LE()    FT_GET_MACRO( LONG_LE )
#define FT_GET_ULONG_LE()   FT_GET_MACRO( ULONG_LE )
#else
#define FT_GET_MACRO( func, type )        ( (type)func( stream ) )
#define FT_GET_CHAR()       FT_GET_MACRO( FT_Stream_GetChar, FT_Char )
#define FT_GET_BYTE()       FT_GET_MACRO( FT_Stream_GetChar, FT_Byte )
#define FT_GET_SHORT()      FT_GET_MACRO( FT_Stream_GetUShort, FT_Short )
#define FT_GET_USHORT()     FT_GET_MACRO( FT_Stream_GetUShort, FT_UShort )
#define FT_GET_OFF3()       FT_GET_MACRO( FT_Stream_GetUOffset, FT_Long )
#define FT_GET_UOFF3()      FT_GET_MACRO( FT_Stream_GetUOffset, FT_ULong )
#define FT_GET_LONG()       FT_GET_MACRO( FT_Stream_GetULong, FT_Long )
#define FT_GET_ULONG()      FT_GET_MACRO( FT_Stream_GetULong, FT_ULong )
#define FT_GET_TAG4()       FT_GET_MACRO( FT_Stream_GetULong, FT_ULong )
#define FT_GET_SHORT_LE()   FT_GET_MACRO( FT_Stream_GetUShortLE, FT_Short )
#define FT_GET_USHORT_LE()  FT_GET_MACRO( FT_Stream_GetUShortLE, FT_UShort )
#define FT_GET_LONG_LE()    FT_GET_MACRO( FT_Stream_GetULongLE, FT_Long )
#define FT_GET_ULONG_LE()   FT_GET_MACRO( FT_Stream_GetULongLE, FT_ULong )
#endif
#define FT_READ_MACRO( func, type, var )        \
          ( var = (type)func( stream, &error ), \
            error != FT_Err_Ok )
#define FT_READ_BYTE( var )       FT_READ_MACRO( FT_Stream_ReadChar, FT_Byte, var )
#define FT_READ_CHAR( var )       FT_READ_MACRO( FT_Stream_ReadChar, FT_Char, var )
#define FT_READ_SHORT( var )      FT_READ_MACRO( FT_Stream_ReadUShort, FT_Short, var )
#define FT_READ_USHORT( var )     FT_READ_MACRO( FT_Stream_ReadUShort, FT_UShort, var )
#define FT_READ_OFF3( var )       FT_READ_MACRO( FT_Stream_ReadUOffset, FT_Long, var )
#define FT_READ_UOFF3( var )      FT_READ_MACRO( FT_Stream_ReadUOffset, FT_ULong, var )
#define FT_READ_LONG( var )       FT_READ_MACRO( FT_Stream_ReadULong, FT_Long, var )
#define FT_READ_ULONG( var )      FT_READ_MACRO( FT_Stream_ReadULong, FT_ULong, var )
#define FT_READ_SHORT_LE( var )   FT_READ_MACRO( FT_Stream_ReadUShortLE, FT_Short, var )
#define FT_READ_USHORT_LE( var )  FT_READ_MACRO( FT_Stream_ReadUShortLE, FT_UShort, var )
#define FT_READ_LONG_LE( var )    FT_READ_MACRO( FT_Stream_ReadULongLE, FT_Long, var )
#define FT_READ_ULONG_LE( var )   FT_READ_MACRO( FT_Stream_ReadULongLE, FT_ULong, var )
#ifndef FT_CONFIG_OPTION_NO_DEFAULT_SYSTEM
/* initialize a stream for reading a regular system stream */
  FT_BASE( FT_Error )
  FT_Stream_Open( FT_Stream    stream,
                  const char*  filepathname );
/* FT_CONFIG_OPTION_NO_DEFAULT_SYSTEM */
#endif  
/* create a new (input) stream from an FT_Open_Args structure */
  FT_BASE( FT_Error )
  FT_Stream_New( FT_Library           library,
                 const FT_Open_Args*  args,
                 FT_Stream           *astream );
/* free a stream */
  FT_BASE( void )
  FT_Stream_Free( FT_Stream  stream,
                  FT_Int     external );
/* initialize a stream for reading in-memory data */
  FT_BASE( void )
  FT_Stream_OpenMemory( FT_Stream       stream,
                        const FT_Byte*  base,
                        FT_ULong        size );
/* close a stream (does not destroy the stream structure) */
  FT_BASE( void )
  FT_Stream_Close( FT_Stream  stream );
/* seek within a stream. position is relative to start of stream */
  FT_BASE( FT_Error )
  FT_Stream_Seek( FT_Stream  stream,
                  FT_ULong   pos );
/* skip bytes in a stream */
  FT_BASE( FT_Error )
  FT_Stream_Skip( FT_Stream  stream,
                  FT_Long    distance );
/* return current stream position */
  FT_BASE( FT_Long )
  FT_Stream_Pos( FT_Stream  stream );
/* read bytes from a stream into a user-allocated buffer, returns an */
/* error if not all bytes could be read.                             */
  FT_BASE( FT_Error )
  FT_Stream_Read( FT_Stream  stream,
                  FT_Byte*   buffer,
                  FT_ULong   count );
/* read bytes from a stream at a given position */
  FT_BASE( FT_Error )
  FT_Stream_ReadAt( FT_Stream  stream,
                    FT_ULong   pos,
                    FT_Byte*   buffer,
                    FT_ULong   count );
/* try to read bytes at the end of a stream; return number of bytes */
/* really available                                                 */
  FT_BASE( FT_ULong )
  FT_Stream_TryRead( FT_Stream  stream,
                     FT_Byte*   buffer,
                     FT_ULong   count );
/* Enter a frame of `count' consecutive bytes in a stream.  Returns an */
/* error if the frame could not be read/accessed.  The caller can use  */
/* the FT_Stream_Get_XXX functions to retrieve frame data without      */
/* error checks.                                                       */
/*                                                                     */
/* You must _always_ call FT_Stream_ExitFrame() once you have entered  */
/* a stream frame!                                                     */
/*                                                                     */
  FT_BASE( FT_Error )
  FT_Stream_EnterFrame( FT_Stream  stream,
                        FT_ULong   count );
/* exit a stream frame */
  FT_BASE( void )
  FT_Stream_ExitFrame( FT_Stream  stream );
/* Extract a stream frame.  If the stream is disk-based, a heap block */
/* is allocated and the frame bytes are read into it.  If the stream  */
/* is memory-based, this function simply set a pointer to the data.   */
/*                                                                    */
/* Useful to optimize access to memory-based streams transparently.   */
/*                                                                    */
/* All extracted frames must be `freed' with a call to the function   */
/* FT_Stream_ReleaseFrame().                                          */
/*                                                                    */
  FT_BASE( FT_Error )
  FT_Stream_ExtractFrame( FT_Stream  stream,
                          FT_ULong   count,
                          FT_Byte**  pbytes );
/* release an extract frame (see FT_Stream_ExtractFrame) */
  FT_BASE( void )
  FT_Stream_ReleaseFrame( FT_Stream  stream,
                          FT_Byte**  pbytes );
/* read a byte from an entered frame */
  FT_BASE( FT_Char )
  FT_Stream_GetChar( FT_Stream  stream );
/* read a 16-bit big-endian unsigned integer from an entered frame */
  FT_BASE( FT_UShort )
  FT_Stream_GetUShort( FT_Stream  stream );
/* read a 24-bit big-endian unsigned integer from an entered frame */
  FT_BASE( FT_ULong )
  FT_Stream_GetUOffset( FT_Stream  stream );
/* read a 32-bit big-endian unsigned integer from an entered frame */
  FT_BASE( FT_ULong )
  FT_Stream_GetULong( FT_Stream  stream );
/* read a 16-bit little-endian unsigned integer from an entered frame */
  FT_BASE( FT_UShort )
  FT_Stream_GetUShortLE( FT_Stream  stream );
/* read a 32-bit little-endian unsigned integer from an entered frame */
  FT_BASE( FT_ULong )
  FT_Stream_GetULongLE( FT_Stream  stream );
/* read a byte from a stream */
  FT_BASE( FT_Char )
  FT_Stream_ReadChar( FT_Stream  stream,
                      FT_Error*  error );
/* read a 16-bit big-endian unsigned integer from a stream */
  FT_BASE( FT_UShort )
  FT_Stream_ReadUShort( FT_Stream  stream,
                        FT_Error*  error );
/* read a 24-bit big-endian unsigned integer from a stream */
  FT_BASE( FT_ULong )
  FT_Stream_ReadUOffset( FT_Stream  stream,
                         FT_Error*  error );
/* read a 32-bit big-endian integer from a stream */
  FT_BASE( FT_ULong )
  FT_Stream_ReadULong( FT_Stream  stream,
                       FT_Error*  error );
/* read a 16-bit little-endian unsigned integer from a stream */
  FT_BASE( FT_UShort )
  FT_Stream_ReadUShortLE( FT_Stream  stream,
                          FT_Error*  error );
/* read a 32-bit little-endian unsigned integer from a stream */
  FT_BASE( FT_ULong )
  FT_Stream_ReadULongLE( FT_Stream  stream,
                         FT_Error*  error );
/* Read a structure from a stream.  The structure must be described */
/* by an array of FT_Frame_Field records.                           */
  FT_BASE( FT_Error )
  FT_Stream_ReadFields( FT_Stream              stream,
                        const FT_Frame_Field*  fields,
                        void*                  structure );
#define FT_STREAM_POS()           \
          FT_Stream_Pos( stream )
#define FT_STREAM_SEEK( position )                           \
          FT_SET_ERROR( FT_Stream_Seek( stream, position ) )
#define FT_STREAM_SKIP( distance )                           \
          FT_SET_ERROR( FT_Stream_Skip( stream, distance ) )
#define FT_STREAM_READ( buffer, count )                   \
          FT_SET_ERROR( FT_Stream_Read( stream,           \
                                        (FT_Byte*)buffer, \
                                        count ) )
#define FT_STREAM_READ_AT( position, buffer, count )         \
          FT_SET_ERROR( FT_Stream_ReadAt( stream,            \
                                           position,         \
                                           (FT_Byte*)buffer, \
                                           count ) )
#define FT_STREAM_READ_FIELDS( fields, object )                          \
          FT_SET_ERROR( FT_Stream_ReadFields( stream, fields, object ) )
#define FT_FRAME_ENTER( size )                                       \
          FT_SET_ERROR(                                              \
            FT_DEBUG_INNER( FT_Stream_EnterFrame( stream, size ) ) )
#define FT_FRAME_EXIT()                 \
          FT_DEBUG_INNER( FT_Stream_ExitFrame( stream ) )
#define FT_FRAME_EXTRACT( size, bytes )                                       \
          FT_SET_ERROR(                                                       \
            FT_DEBUG_INNER( FT_Stream_ExtractFrame( stream, size,             \
                                                    (FT_Byte**)&(bytes) ) ) )
#define FT_FRAME_RELEASE( bytes )                                         \
          FT_DEBUG_INNER( FT_Stream_ReleaseFrame( stream,                 \
                                                  (FT_Byte**)&(bytes) ) )
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  fterrors.h                                                             */
/*                                                                         */
/*    FreeType error code handling (specification).                        */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2004, 2007 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This special header file is used to define the handling of FT2        */
/* enumeration constants.  It can also be used to generate error message */
/* strings with a small macro trick explained below.                     */
/*                                                                       */
/* I - Error Formats                                                     */
/* -----------------                                                     */
/*                                                                       */
/*   The configuration macro FT_CONFIG_OPTION_USE_MODULE_ERRORS can be   */
/*   defined in ftoption.h in order to make the higher byte indicate     */
/*   the module where the error has happened (this is not compatible     */
/*   with standard builds of FreeType 2).  You can then use the macro    */
/*   FT_ERROR_BASE macro to extract the generic error code from an       */
/*   FT_Error value.                                                     */
/*                                                                       */
/*                                                                       */
/* II - Error Message strings                                            */
/* --------------------------                                            */
/*                                                                       */
/*   The error definitions below are made through special macros that    */
/*   allow client applications to build a table of error message strings */
/*   if they need it.  The strings are not included in a normal build of */
/*   FreeType 2 to save space (most client applications do not use       */
/*   them).                                                              */
/*                                                                       */
/*   To do so, you have to define the following macros before including  */
/*   this file:                                                          */
/*                                                                       */
/*   FT_ERROR_START_LIST ::                                              */
/*     This macro is called before anything else to define the start of  */
/*     the error list.  It is followed by several FT_ERROR_DEF calls     */
/*     (see below).                                                      */
/*                                                                       */
/*   FT_ERROR_DEF( e, v, s ) ::                                          */
/*     This macro is called to define one single error.                  */
/*     `e' is the error code identifier (e.g. FT_Err_Invalid_Argument).  */
/*     `v' is the error numerical value.                                 */
/*     `s' is the corresponding error string.                            */
/*                                                                       */
/*   FT_ERROR_END_LIST ::                                                */
/*     This macro ends the list.                                         */
/*                                                                       */
/*   Additionally, you have to undefine __FTERRORS_H__ before #including */
/*   this file.                                                          */
/*                                                                       */
/*   Here is a simple example:                                           */
/*                                                                       */
/*     {                                                                 */
/*       #undef __FTERRORS_H__                                           */
/*       #define FT_ERRORDEF( e, v, s )  { e, s },                       */
/*       #define FT_ERROR_START_LIST     {                               */
/*       #define FT_ERROR_END_LIST       { 0, 0 } };                     */
/*                                                                       */
/*       const struct                                                    */
/*       {                                                               */
/*         int          err_code;                                        */
/*         const char*  err_msg;                                         */
/*       } ft_errors[] =                                                 */
/*                                                                       */
/*       #include FT_ERRORS_H                                            */
/*     }                                                                 */
/*                                                                       */
/*************************************************************************/
#ifndef __FTERRORS_H__
#define __FTERRORS_H__
/* include module base error codes */
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                       SETUP MACROS                      *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#undef  FT_NEED_EXTERN_C
#undef  FT_ERR_XCAT
#undef  FT_ERR_CAT
#define FT_ERR_XCAT( x, y )  x ## y
#define FT_ERR_CAT( x, y )   FT_ERR_XCAT( x, y )
/* FT_ERR_PREFIX is used as a prefix for error identifiers. */
/* By default, we use `FT_Err_'.                            */
/*                                                          */
#ifndef FT_ERR_PREFIX
#define FT_ERR_PREFIX  FT_Err_
#endif
/* FT_ERR_BASE is used as the base for module-specific errors. */
/*                                                             */
#undef FT_ERR_BASE
#define FT_ERR_BASE  0
/* If FT_ERRORDEF is not defined, we need to define a simple */
/* enumeration type.                                         */
/*                                                           */
#ifndef FT_ERRORDEF
#define FT_ERRORDEF( e, v, s )  e = v,
#define FT_ERROR_START_LIST     enum {
#define FT_ERROR_END_LIST       FT_ERR_CAT( FT_ERR_PREFIX, Max ) };
#ifdef __cplusplus
#define FT_NEED_EXTERN_C
  extern "C" {
#endif
/* !FT_ERRORDEF */
#endif  
/* this macro is used to define an error */
#define FT_ERRORDEF_( e, v, s )   \
          FT_ERRORDEF( FT_ERR_CAT( FT_ERR_PREFIX, e ), v + FT_ERR_BASE, s )
/* this is only used for <module>_Err_Ok, which must be 0! */
#define FT_NOERRORDEF_( e, v, s ) \
          FT_ERRORDEF( FT_ERR_CAT( FT_ERR_PREFIX, e ), v, s )
#ifdef FT_ERROR_START_LIST
  FT_ERROR_START_LIST
#endif
/* now include the error codes */
/***************************************************************************/
/*                                                                         */
/*  fterrdef.h                                                             */
/*                                                                         */
/*    FreeType error codes (specification).                                */
/*                                                                         */
/*  Copyright 2002, 2004, 2006, 2007, 2010-2012 by                         */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                LIST OF ERROR CODES/MESSAGES             *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
/* You need to define both FT_ERRORDEF_ and FT_NOERRORDEF_ before */
/* including this file.                                           */
/* generic errors */
  FT_NOERRORDEF_( Ok,                                        0x00, \
                  "no error" )
  FT_ERRORDEF_( Cannot_Open_Resource,                        0x01, \
                "cannot open resource" )
  FT_ERRORDEF_( Unknown_File_Format,                         0x02, \
                "unknown file format" )
  FT_ERRORDEF_( Invalid_File_Format,                         0x03, \
                "broken file" )
  FT_ERRORDEF_( Invalid_Version,                             0x04, \
                "invalid FreeType version" )
  FT_ERRORDEF_( Lower_Module_Version,                        0x05, \
                "module version is too low" )
  FT_ERRORDEF_( Invalid_Argument,                            0x06, \
                "invalid argument" )
  FT_ERRORDEF_( Unimplemented_Feature,                       0x07, \
                "unimplemented feature" )
  FT_ERRORDEF_( Invalid_Table,                               0x08, \
                "broken table" )
  FT_ERRORDEF_( Invalid_Offset,                              0x09, \
                "broken offset within table" )
  FT_ERRORDEF_( Array_Too_Large,                             0x0A, \
                "array allocation size too large" )
  FT_ERRORDEF_( Missing_Module,                              0x0B, \
                "missing module" )
  FT_ERRORDEF_( Missing_Property,                            0x0C, \
                "missing property" )
/* glyph/character errors */
  FT_ERRORDEF_( Invalid_Glyph_Index,                         0x10, \
                "invalid glyph index" )
  FT_ERRORDEF_( Invalid_Character_Code,                      0x11, \
                "invalid character code" )
  FT_ERRORDEF_( Invalid_Glyph_Format,                        0x12, \
                "unsupported glyph image format" )
  FT_ERRORDEF_( Cannot_Render_Glyph,                         0x13, \
                "cannot render this glyph format" )
  FT_ERRORDEF_( Invalid_Outline,                             0x14, \
                "invalid outline" )
  FT_ERRORDEF_( Invalid_Composite,                           0x15, \
                "invalid composite glyph" )
  FT_ERRORDEF_( Too_Many_Hints,                              0x16, \
                "too many hints" )
  FT_ERRORDEF_( Invalid_Pixel_Size,                          0x17, \
                "invalid pixel size" )
/* handle errors */
  FT_ERRORDEF_( Invalid_Handle,                              0x20, \
                "invalid object handle" )
  FT_ERRORDEF_( Invalid_Library_Handle,                      0x21, \
                "invalid library handle" )
  FT_ERRORDEF_( Invalid_Driver_Handle,                       0x22, \
                "invalid module handle" )
  FT_ERRORDEF_( Invalid_Face_Handle,                         0x23, \
                "invalid face handle" )
  FT_ERRORDEF_( Invalid_Size_Handle,                         0x24, \
                "invalid size handle" )
  FT_ERRORDEF_( Invalid_Slot_Handle,                         0x25, \
                "invalid glyph slot handle" )
  FT_ERRORDEF_( Invalid_CharMap_Handle,                      0x26, \
                "invalid charmap handle" )
  FT_ERRORDEF_( Invalid_Cache_Handle,                        0x27, \
                "invalid cache manager handle" )
  FT_ERRORDEF_( Invalid_Stream_Handle,                       0x28, \
                "invalid stream handle" )
/* driver errors */
  FT_ERRORDEF_( Too_Many_Drivers,                            0x30, \
                "too many modules" )
  FT_ERRORDEF_( Too_Many_Extensions,                         0x31, \
                "too many extensions" )
/* memory errors */
  FT_ERRORDEF_( Out_Of_Memory,                               0x40, \
                "out of memory" )
  FT_ERRORDEF_( Unlisted_Object,                             0x41, \
                "unlisted object" )
/* stream errors */
  FT_ERRORDEF_( Cannot_Open_Stream,                          0x51, \
                "cannot open stream" )
  FT_ERRORDEF_( Invalid_Stream_Seek,                         0x52, \
                "invalid stream seek" )
  FT_ERRORDEF_( Invalid_Stream_Skip,                         0x53, \
                "invalid stream skip" )
  FT_ERRORDEF_( Invalid_Stream_Read,                         0x54, \
                "invalid stream read" )
  FT_ERRORDEF_( Invalid_Stream_Operation,                    0x55, \
                "invalid stream operation" )
  FT_ERRORDEF_( Invalid_Frame_Operation,                     0x56, \
                "invalid frame operation" )
  FT_ERRORDEF_( Nested_Frame_Access,                         0x57, \
                "nested frame access" )
  FT_ERRORDEF_( Invalid_Frame_Read,                          0x58, \
                "invalid frame read" )
/* raster errors */
  FT_ERRORDEF_( Raster_Uninitialized,                        0x60, \
                "raster uninitialized" )
  FT_ERRORDEF_( Raster_Corrupted,                            0x61, \
                "raster corrupted" )
  FT_ERRORDEF_( Raster_Overflow,                             0x62, \
                "raster overflow" )
  FT_ERRORDEF_( Raster_Negative_Height,                      0x63, \
                "negative height while rastering" )
/* cache errors */
  FT_ERRORDEF_( Too_Many_Caches,                             0x70, \
                "too many registered caches" )
/* TrueType and SFNT errors */
  FT_ERRORDEF_( Invalid_Opcode,                              0x80, \
                "invalid opcode" )
  FT_ERRORDEF_( Too_Few_Arguments,                           0x81, \
                "too few arguments" )
  FT_ERRORDEF_( Stack_Overflow,                              0x82, \
                "stack overflow" )
  FT_ERRORDEF_( Code_Overflow,                               0x83, \
                "code overflow" )
  FT_ERRORDEF_( Bad_Argument,                                0x84, \
                "bad argument" )
  FT_ERRORDEF_( Divide_By_Zero,                              0x85, \
                "division by zero" )
  FT_ERRORDEF_( Invalid_Reference,                           0x86, \
                "invalid reference" )
  FT_ERRORDEF_( Debug_OpCode,                                0x87, \
                "found debug opcode" )
  FT_ERRORDEF_( ENDF_In_Exec_Stream,                         0x88, \
                "found ENDF opcode in execution stream" )
  FT_ERRORDEF_( Nested_DEFS,                                 0x89, \
                "nested DEFS" )
  FT_ERRORDEF_( Invalid_CodeRange,                           0x8A, \
                "invalid code range" )
  FT_ERRORDEF_( Execution_Too_Long,                          0x8B, \
                "execution context too long" )
  FT_ERRORDEF_( Too_Many_Function_Defs,                      0x8C, \
                "too many function definitions" )
  FT_ERRORDEF_( Too_Many_Instruction_Defs,                   0x8D, \
                "too many instruction definitions" )
  FT_ERRORDEF_( Table_Missing,                               0x8E, \
                "SFNT font table missing" )
  FT_ERRORDEF_( Horiz_Header_Missing,                        0x8F, \
                "horizontal header (hhea) table missing" )
  FT_ERRORDEF_( Locations_Missing,                           0x90, \
                "locations (loca) table missing" )
  FT_ERRORDEF_( Name_Table_Missing,                          0x91, \
                "name table missing" )
  FT_ERRORDEF_( CMap_Table_Missing,                          0x92, \
                "character map (cmap) table missing" )
  FT_ERRORDEF_( Hmtx_Table_Missing,                          0x93, \
                "horizontal metrics (hmtx) table missing" )
  FT_ERRORDEF_( Post_Table_Missing,                          0x94, \
                "PostScript (post) table missing" )
  FT_ERRORDEF_( Invalid_Horiz_Metrics,                       0x95, \
                "invalid horizontal metrics" )
  FT_ERRORDEF_( Invalid_CharMap_Format,                      0x96, \
                "invalid character map (cmap) format" )
  FT_ERRORDEF_( Invalid_PPem,                                0x97, \
                "invalid ppem value" )
  FT_ERRORDEF_( Invalid_Vert_Metrics,                        0x98, \
                "invalid vertical metrics" )
  FT_ERRORDEF_( Could_Not_Find_Context,                      0x99, \
                "could not find context" )
  FT_ERRORDEF_( Invalid_Post_Table_Format,                   0x9A, \
                "invalid PostScript (post) table format" )
  FT_ERRORDEF_( Invalid_Post_Table,                          0x9B, \
                "invalid PostScript (post) table" )
/* CFF, CID, and Type 1 errors */
  FT_ERRORDEF_( Syntax_Error,                                0xA0, \
                "opcode syntax error" )
  FT_ERRORDEF_( Stack_Underflow,                             0xA1, \
                "argument stack underflow" )
  FT_ERRORDEF_( Ignore,                                      0xA2, \
                "ignore" )
  FT_ERRORDEF_( No_Unicode_Glyph_Name,                       0xA3, \
                "no Unicode glyph name found" )
/* BDF errors */
  FT_ERRORDEF_( Missing_Startfont_Field,                     0xB0, \
                "`STARTFONT' field missing" )
  FT_ERRORDEF_( Missing_Font_Field,                          0xB1, \
                "`FONT' field missing" )
  FT_ERRORDEF_( Missing_Size_Field,                          0xB2, \
                "`SIZE' field missing" )
  FT_ERRORDEF_( Missing_Fontboundingbox_Field,               0xB3, \
                "`FONTBOUNDINGBOX' field missing" )
  FT_ERRORDEF_( Missing_Chars_Field,                         0xB4, \
                "`CHARS' field missing" )
  FT_ERRORDEF_( Missing_Startchar_Field,                     0xB5, \
                "`STARTCHAR' field missing" )
  FT_ERRORDEF_( Missing_Encoding_Field,                      0xB6, \
                "`ENCODING' field missing" )
  FT_ERRORDEF_( Missing_Bbx_Field,                           0xB7, \
                "`BBX' field missing" )
  FT_ERRORDEF_( Bbx_Too_Big,                                 0xB8, \
                "`BBX' too big" )
  FT_ERRORDEF_( Corrupted_Font_Header,                       0xB9, \
                "Font header corrupted or missing fields" )
  FT_ERRORDEF_( Corrupted_Font_Glyphs,                       0xBA, \
                "Font glyphs corrupted or missing fields" )
/* END */
#ifdef FT_ERROR_END_LIST
  FT_ERROR_END_LIST
#endif
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                      SIMPLE CLEANUP                     *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#ifdef FT_NEED_EXTERN_C
  }
#endif
#undef FT_ERROR_START_LIST
#undef FT_ERROR_END_LIST
#undef FT_ERRORDEF
#undef FT_ERRORDEF_
#undef FT_NOERRORDEF_
#undef FT_NEED_EXTERN_C
#undef FT_ERR_BASE
/* FT_KEEP_ERR_PREFIX is needed for ftvalid.h */
#ifndef FT_KEEP_ERR_PREFIX
#undef FT_ERR_PREFIX
#else
#undef FT_KEEP_ERR_PREFIX
#endif
/* __FTERRORS_H__ */
#endif  
/* END */
/*************************************************************************/
/*                                                                       */
/*                       MEMORY MANAGEMENT INTERFACE                     */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* It is not necessary to do any error checking for the                  */
/* allocation-related functions.  This will be done by the higher level  */
/* routines like ft_mem_alloc() or ft_mem_realloc().                     */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    ft_alloc                                                           */
/*                                                                       */
/* <Description>                                                         */
/*    The memory allocation function.                                    */
/*                                                                       */
/* <Input>                                                               */
/*    memory :: A pointer to the memory object.                          */
/*                                                                       */
/*    size   :: The requested size in bytes.                             */
/*                                                                       */
/* <Return>                                                              */
/*    The address of newly allocated block.                              */
/*                                                                       */
  FT_CALLBACK_DEF( void* )
  ft_alloc( FT_Memory  memory,
            long       size )
  {
    FT_UNUSED( memory );
    return ft_smalloc( size );
  }
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    ft_realloc                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    The memory reallocation function.                                  */
/*                                                                       */
/* <Input>                                                               */
/*    memory   :: A pointer to the memory object.                        */
/*                                                                       */
/*    cur_size :: The current size of the allocated memory block.        */
/*                                                                       */
/*    new_size :: The newly requested size in bytes.                     */
/*                                                                       */
/*    block    :: The current address of the block in memory.            */
/*                                                                       */
/* <Return>                                                              */
/*    The address of the reallocated memory block.                       */
/*                                                                       */
  FT_CALLBACK_DEF( void* )
  ft_realloc( FT_Memory  memory,
              long       cur_size,
              long       new_size,
              void*      block )
  {
    FT_UNUSED( memory );
    FT_UNUSED( cur_size );
    return ft_srealloc( block, new_size );
  }
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    ft_free                                                            */
/*                                                                       */
/* <Description>                                                         */
/*    The memory release function.                                       */
/*                                                                       */
/* <Input>                                                               */
/*    memory  :: A pointer to the memory object.                         */
/*                                                                       */
/*    block   :: The address of block in memory to be freed.             */
/*                                                                       */
  FT_CALLBACK_DEF( void )
  ft_free( FT_Memory  memory,
           void*      block )
  {
    FT_UNUSED( memory );
    ft_sfree( block );
  }
/*************************************************************************/
/*                                                                       */
/*                     RESOURCE MANAGEMENT INTERFACE                     */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* The macro FT_COMPONENT is used in trace mode.  It is an implicit      */
/* parameter of the FT_TRACE() and FT_ERROR() macros, used to print/log  */
/* messages during execution.                                            */
/*                                                                       */
#undef  FT_COMPONENT
#define FT_COMPONENT  trace_io
/* We use the macro STREAM_FILE for convenience to extract the       */
/* system-specific stream handle from a given FreeType stream object */
#define STREAM_FILE( stream )  ( (FT_FILE*)stream->descriptor.pointer )
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    ft_ansi_stream_close                                               */
/*                                                                       */
/* <Description>                                                         */
/*    The function to close a stream.                                    */
/*                                                                       */
/* <Input>                                                               */
/*    stream :: A pointer to the stream object.                          */
/*                                                                       */
  FT_CALLBACK_DEF( void )
  ft_ansi_stream_close( FT_Stream  stream )
  {
    ft_fclose( STREAM_FILE( stream ) );
    stream->descriptor.pointer = NULL;
    stream->size               = 0;
    stream->base               = 0;
  }
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    ft_ansi_stream_io                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    The function to open a stream.                                     */
/*                                                                       */
/* <Input>                                                               */
/*    stream :: A pointer to the stream object.                          */
/*                                                                       */
/*    offset :: The position in the data stream to start reading.        */
/*                                                                       */
/*    buffer :: The address of buffer to store the read data.            */
/*                                                                       */
/*    count  :: The number of bytes to read from the stream.             */
/*                                                                       */
/* <Return>                                                              */
/*    The number of bytes actually read.  If `count' is zero (this is,   */
/*    the function is used for seeking), a non-zero return value         */
/*    indicates an error.                                                */
/*                                                                       */
  FT_CALLBACK_DEF( unsigned long )
  ft_ansi_stream_io( FT_Stream       stream,
                     unsigned long   offset,
                     unsigned char*  buffer,
                     unsigned long   count )
  {
    FT_FILE*  file;
    if ( !count && offset > stream->size )
      return 1;
    file = STREAM_FILE( stream );
    if ( stream->pos != offset )
      ft_fseek( file, offset, SEEK_SET );
    return (unsigned long)ft_fread( buffer, 1, count, file );
  }
/* documentation is in ftstream.h */
  FT_BASE_DEF( FT_Error )
  FT_Stream_Open( FT_Stream    stream,
                  const char*  filepathname )
  {
    FT_FILE*  file;
    if ( !stream )
      return FT_Err_Invalid_Stream_Handle;
    stream->descriptor.pointer = NULL;
    stream->pathname.pointer   = (char*)filepathname;
    stream->base               = 0;
    stream->pos                = 0;
    stream->read               = NULL;
    stream->close              = NULL;
    file = ft_fopen( filepathname, "rb" );
    if ( !file )
    {
      FT_ERROR(( "FT_Stream_Open:"
                 " could not open `%s'\n", filepathname ));
      return FT_Err_Cannot_Open_Resource;
    }
    ft_fseek( file, 0, SEEK_END );
    stream->size = ft_ftell( file );
    if ( !stream->size )
    {
      FT_ERROR(( "FT_Stream_Open:" ));
      FT_ERROR(( " opened `%s' but zero-sized\n", filepathname ));
      ft_fclose( file );
      return FT_Err_Cannot_Open_Stream;
    }
    ft_fseek( file, 0, SEEK_SET );
    stream->descriptor.pointer = file;
    stream->read  = ft_ansi_stream_io;
    stream->close = ft_ansi_stream_close;
    FT_TRACE1(( "FT_Stream_Open:" ));
    FT_TRACE1(( " opened `%s' (%d bytes) successfully\n",
                filepathname, stream->size ));
    return FT_Err_Ok;
  }
/* documentation is in ftobjs.h */
  FT_BASE_DEF( FT_Memory )
  FT_New_Memory( void )
  {
    FT_Memory  memory;
    memory = (FT_Memory)ft_smalloc( sizeof ( *memory ) );
    if ( memory )
    {
      memory->user    = 0;
      memory->alloc   = ft_alloc;
      memory->realloc = ft_realloc;
      memory->free    = ft_free;
    }
    return memory;
  }
/* documentation is in ftobjs.h */
  FT_BASE_DEF( void )
  FT_Done_Memory( FT_Memory  memory )
  {
    ft_sfree( memory );
  }
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftinit.c                                                               */
/*                                                                         */
/*    FreeType initialization layer (body).                                */
/*                                                                         */
/*  Copyright 1996-2002, 2005, 2007, 2009, 2012 by                         */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/*  The purpose of this file is to implement the following two           */
/*  functions:                                                           */
/*                                                                       */
/*  FT_Add_Default_Modules():                                            */
/*     This function is used to add the set of default modules to a      */
/*     fresh new library object.  The set is taken from the header file  */
/*     `freetype/config/ftmodule.h'.  See the document `FreeType 2.0     */
/*     Build System' for more information.                               */
/*                                                                       */
/*  FT_Init_FreeType():                                                  */
/*     This function creates a system object for the current platform,   */
/*     builds a library out of it, then calls FT_Default_Drivers().      */
/*                                                                       */
/*  Note that even if FT_Init_FreeType() uses the implementation of the  */
/*  system object defined at build time, client applications are still   */
/*  able to provide their own `ftsystem.c'.                              */
/*                                                                       */
/*************************************************************************/
/***************************************************************************/
/*                                                                         */
/*  basepic.h                                                              */
/*                                                                         */
/*    The FreeType position independent code services for base.            */
/*                                                                         */
/*  Copyright 2009 by                                                      */
/*  Oran Agra and Mickey Gabel.                                            */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __BASEPIC_H__
FT_BEGIN_HEADER
#define FT_OUTLINE_GLYPH_CLASS_GET &ft_outline_glyph_class
#define FT_BITMAP_GLYPH_CLASS_GET  &ft_bitmap_glyph_class
#define FT_DEFAULT_MODULES_GET     ft_default_modules
#define FT_RACCESS_GUESS_TABLE_GET ft_raccess_guess_table
/* */
FT_END_HEADER
/* END */
/*************************************************************************/
/*                                                                       */
/* The macro FT_COMPONENT is used in trace mode.  It is an implicit      */
/* parameter of the FT_TRACE() and FT_ERROR() macros, used to print/log  */
/* messages during execution.                                            */
/*                                                                       */
#undef  FT_COMPONENT
#define FT_COMPONENT  trace_init
#undef  FT_USE_MODULE
#ifdef __cplusplus
#define FT_USE_MODULE( type, x )  extern "C" const type  x;
#else
#define FT_USE_MODULE( type, x )  extern const type  x;
#endif
/*
 *  This file registers the FreeType modules compiled into the library.
 *
 *  If you use GNU make, this file IS NOT USED!  Instead, it is created in
 *  the objects directory (normally `<topdir>/objs/') based on information
 *  from `<topdir>/modules.cfg'.
 *
 *  Please read `docs/INSTALL.ANY' and `docs/CUSTOMIZE' how to compile
 *  FreeType without GNU make.
 *
 */
FT_USE_MODULE( FT_Module_Class, autofit_module_class )
FT_USE_MODULE( FT_Driver_ClassRec, tt_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, t1_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, cff_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, t1cid_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, pfr_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, t42_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, winfnt_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, pcf_driver_class )
FT_USE_MODULE( FT_Module_Class, psaux_module_class )
FT_USE_MODULE( FT_Module_Class, psnames_module_class )
FT_USE_MODULE( FT_Module_Class, pshinter_module_class )
FT_USE_MODULE( FT_Renderer_Class, ft_raster1_renderer_class )
FT_USE_MODULE( FT_Module_Class, sfnt_module_class )
FT_USE_MODULE( FT_Renderer_Class, ft_smooth_renderer_class )
FT_USE_MODULE( FT_Renderer_Class, ft_smooth_lcd_renderer_class )
FT_USE_MODULE( FT_Renderer_Class, ft_smooth_lcdv_renderer_class )
FT_USE_MODULE( FT_Driver_ClassRec, bdf_driver_class )
/* EOF */
#undef  FT_USE_MODULE
#define FT_USE_MODULE( type, x )  (const FT_Module_Class*)&(x),
  static
  const FT_Module_Class*  const ft_default_modules[] =
  {
/*
 *  This file registers the FreeType modules compiled into the library.
 *
 *  If you use GNU make, this file IS NOT USED!  Instead, it is created in
 *  the objects directory (normally `<topdir>/objs/') based on information
 *  from `<topdir>/modules.cfg'.
 *
 *  Please read `docs/INSTALL.ANY' and `docs/CUSTOMIZE' how to compile
 *  FreeType without GNU make.
 *
 */
FT_USE_MODULE( FT_Module_Class, autofit_module_class )
FT_USE_MODULE( FT_Driver_ClassRec, tt_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, t1_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, cff_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, t1cid_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, pfr_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, t42_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, winfnt_driver_class )
FT_USE_MODULE( FT_Driver_ClassRec, pcf_driver_class )
FT_USE_MODULE( FT_Module_Class, psaux_module_class )
FT_USE_MODULE( FT_Module_Class, psnames_module_class )
FT_USE_MODULE( FT_Module_Class, pshinter_module_class )
FT_USE_MODULE( FT_Renderer_Class, ft_raster1_renderer_class )
FT_USE_MODULE( FT_Module_Class, sfnt_module_class )
FT_USE_MODULE( FT_Renderer_Class, ft_smooth_renderer_class )
FT_USE_MODULE( FT_Renderer_Class, ft_smooth_lcd_renderer_class )
FT_USE_MODULE( FT_Renderer_Class, ft_smooth_lcdv_renderer_class )
FT_USE_MODULE( FT_Driver_ClassRec, bdf_driver_class )
/* EOF */
    0
  };
/* documentation is in ftmodapi.h */
  FT_EXPORT_DEF( void )
  FT_Add_Default_Modules( FT_Library  library )
  {
    FT_Error                       error;
    const FT_Module_Class* const*  cur;
/* FT_DEFAULT_MODULES_GET dereferences `library' in PIC mode */
/* GCC 4.6 warns the type difference:
     *   FT_Module_Class** != const FT_Module_Class* const*
     */
    cur = (const FT_Module_Class* const*)FT_DEFAULT_MODULES_GET;
/* test for valid `library' delayed to FT_Add_Module() */
    while ( *cur )
    {
      error = FT_Add_Module( library, *cur );
/* notify errors, but don't stop */
      if ( error )
        FT_TRACE0(( "FT_Add_Default_Module:"
                    " Cannot install `%s', error = 0x%x\n",
                    (*cur)->module_name, error ));
      cur++;
    }
  }
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Error )
  FT_Init_FreeType( FT_Library  *alibrary )
  {
    FT_Error   error;
    FT_Memory  memory;
/* First of all, allocate a new system object -- this function is part */
/* of the system-specific component, i.e. `ftsystem.c'.                */
    memory = FT_New_Memory();
    if ( !memory )
    {
      FT_ERROR(( "FT_Init_FreeType: cannot find memory manager\n" ));
      return FT_Err_Unimplemented_Feature;
    }
/* build a library out of it, then fill it with the set of */
/* default drivers.                                        */
    error = FT_New_Library( memory, alibrary );
    if ( error )
      FT_Done_Memory( memory );
    else
      FT_Add_Default_Modules( *alibrary );
    return error;
  }
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Error )
  FT_Done_FreeType( FT_Library  library )
  {
    if ( library )
    {
      FT_Memory  memory = library->memory;
/* Discard the library object */
      FT_Done_Library( library );
/* discard memory manager */
      FT_Done_Memory( memory );
    }
    return FT_Err_Ok;
  }
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftdebug.c                                                              */
/*                                                                         */
/*    Debugging and logging component (body).                              */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2004, 2008 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This component contains various macros and functions used to ease the */
/* debugging of the FreeType engine.  Its main purpose is in assertion   */
/* checking, tracing, and error detection.                               */
/*                                                                       */
/* There are now three debugging modes:                                  */
/*                                                                       */
/* - trace mode                                                          */
/*                                                                       */
/*   Error and trace messages are sent to the log file (which can be the */
/*   standard error output).                                             */
/*                                                                       */
/* - error mode                                                          */
/*                                                                       */
/*   Only error messages are generated.                                  */
/*                                                                       */
/* - release mode:                                                       */
/*                                                                       */
/*   No error message is sent or generated.  The code is free from any   */
/*   debugging parts.                                                    */
/*                                                                       */
/*************************************************************************/
  FT_BASE_DEF( void )
  ft_debug_init( void )
  {
/* nothing */
  }
  FT_BASE_DEF( FT_Int )
  FT_Trace_Get_Count( void )
  {
    return 0;
  }
  FT_BASE_DEF( const char * )
  FT_Trace_Get_Name( FT_Int  idx )
  {
    FT_UNUSED( idx );
    return NULL;
  }
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftbase.c                                                               */
/*                                                                         */
/*    Single object library component (body only).                         */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2003, 2004, 2006, 2007, 2008, 2009 by       */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define  FT_MAKE_OPTION_SINGLE_OBJECT
/***************************************************************************/
/*                                                                         */
/*  ftpic.c                                                                */
/*                                                                         */
/*    The FreeType position independent code services (body).              */
/*                                                                         */
/*  Copyright 2009 by                                                      */
/*  Oran Agra and Mickey Gabel.                                            */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/* END */
/***************************************************************************/
/*                                                                         */
/*  basepic.c                                                              */
/*                                                                         */
/*    The FreeType position independent code services for base.            */
/*                                                                         */
/*  Copyright 2009, 2012 by                                                */
/*  Oran Agra and Mickey Gabel.                                            */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftadvanc.c                                                             */
/*                                                                         */
/*    Quick computation of advance widths (body).                          */
/*                                                                         */
/*  Copyright 2008, 2009, 2011 by                                          */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*  ftadvanc.h                                                             */
/*                                                                         */
/*    Quick computation of advance widths (specification only).            */
/*                                                                         */
/*  Copyright 2008 by                                                      */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTADVANC_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/**************************************************************************
   *
   * @section:
   *   quick_advance
   *
   * @title:
   *   Quick retrieval of advance values
   *
   * @abstract:
   *   Retrieve horizontal and vertical advance values without processing
   *   glyph outlines, if possible.
   *
   * @description:
   *   This section contains functions to quickly extract advance values
   *   without handling glyph outlines, if possible.
   */
/*************************************************************************/
/*                                                                       */
/* <Const>                                                               */
/*    FT_ADVANCE_FLAG_FAST_ONLY                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A bit-flag to be OR-ed with the `flags' parameter of the           */
/*    @FT_Get_Advance and @FT_Get_Advances functions.                    */
/*                                                                       */
/*    If set, it indicates that you want these functions to fail if the  */
/*    corresponding hinting mode or font driver doesn't allow for very   */
/*    quick advance computation.                                         */
/*                                                                       */
/*    Typically, glyphs which are either unscaled, unhinted, bitmapped,  */
/*    or light-hinted can have their advance width computed very         */
/*    quickly.                                                           */
/*                                                                       */
/*    Normal and bytecode hinted modes, which require loading, scaling,  */
/*    and hinting of the glyph outline, are extremely slow by            */
/*    comparison.                                                        */
/*                                                                       */
#define FT_ADVANCE_FLAG_FAST_ONLY  0x20000000UL
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Advance                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    Retrieve the advance value of a given glyph outline in an          */
/*    @FT_Face.  By default, the unhinted advance is returned in font    */
/*    units.                                                             */
/*                                                                       */
/* <Input>                                                               */
/*    face       :: The source @FT_Face handle.                          */
/*                                                                       */
/*    gindex     :: The glyph index.                                     */
/*                                                                       */
/*    load_flags :: A set of bit flags similar to those used when        */
/*                  calling @FT_Load_Glyph, used to determine what kind  */
/*                  of advances you need.                                */
/* <Output>                                                              */
/*    padvance :: The advance value, in either font units or 16.16       */
/*                format.                                                */
/*                                                                       */
/*                If @FT_LOAD_VERTICAL_LAYOUT is set, this is the        */
/*                vertical advance corresponding to a vertical layout.   */
/*                Otherwise, it is the horizontal advance in a           */
/*                horizontal layout.                                     */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0 means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    This function may fail if you use @FT_ADVANCE_FLAG_FAST_ONLY and   */
/*    if the corresponding font backend doesn't have a quick way to      */
/*    retrieve the advances.                                             */
/*                                                                       */
/*    A scaled advance is returned in 16.16 format but isn't transformed */
/*    by the affine transformation specified by @FT_Set_Transform.       */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Get_Advance( FT_Face    face,
                  FT_UInt    gindex,
                  FT_Int32   load_flags,
                  FT_Fixed  *padvance );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Get_Advances                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Retrieve the advance values of several glyph outlines in an        */
/*    @FT_Face.  By default, the unhinted advances are returned in font  */
/*    units.                                                             */
/*                                                                       */
/* <Input>                                                               */
/*    face        :: The source @FT_Face handle.                         */
/*                                                                       */
/*    start       :: The first glyph index.                              */
/*                                                                       */
/*    count       :: The number of advance values you want to retrieve.  */
/*                                                                       */
/*    load_flags  :: A set of bit flags similar to those used when       */
/*                   calling @FT_Load_Glyph.                             */
/*                                                                       */
/* <Output>                                                              */
/*    padvance :: The advances, in either font units or 16.16 format.    */
/*                This array must contain at least `count' elements.     */
/*                                                                       */
/*                If @FT_LOAD_VERTICAL_LAYOUT is set, these are the      */
/*                vertical advances corresponding to a vertical layout.  */
/*                Otherwise, they are the horizontal advances in a       */
/*                horizontal layout.                                     */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0 means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    This function may fail if you use @FT_ADVANCE_FLAG_FAST_ONLY and   */
/*    if the corresponding font backend doesn't have a quick way to      */
/*    retrieve the advances.                                             */
/*                                                                       */
/*    Scaled advances are returned in 16.16 format but aren't            */
/*    transformed by the affine transformation specified by              */
/*    @FT_Set_Transform.                                                 */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Get_Advances( FT_Face    face,
                   FT_UInt    start,
                   FT_UInt    count,
                   FT_Int32   load_flags,
                   FT_Fixed  *padvances );
/* */
FT_END_HEADER
/* END */
  static FT_Error
  _ft_face_scale_advances( FT_Face    face,
                           FT_Fixed*  advances,
                           FT_UInt    count,
                           FT_Int32   flags )
  {
    FT_Fixed  scale;
    FT_UInt   nn;
    if ( flags & FT_LOAD_NO_SCALE )
      return FT_Err_Ok;
    if ( face->size == NULL )
      return FT_Err_Invalid_Size_Handle;
    if ( flags & FT_LOAD_VERTICAL_LAYOUT )
      scale = face->size->metrics.y_scale;
    else
      scale = face->size->metrics.x_scale;
/* this must be the same scaling as to get linear{Hori,Vert}Advance */
/* (see `FT_Load_Glyph' implementation in src/base/ftobjs.c)        */
    for ( nn = 0; nn < count; nn++ )
      advances[nn] = FT_MulDiv( advances[nn], scale, 64 );
    return FT_Err_Ok;
  }
/* at the moment, we can perform fast advance retrieval only in */
/* the following cases:                                         */
/*                                                              */
/*  - unscaled load                                             */
/*  - unhinted load                                             */
/*  - light-hinted load                                         */
#define LOAD_ADVANCE_FAST_CHECK( flags )                            \
          ( flags & ( FT_LOAD_NO_SCALE | FT_LOAD_NO_HINTING )    || \
            FT_LOAD_TARGET_MODE( flags ) == FT_RENDER_MODE_LIGHT )
/* documentation is in ftadvanc.h */
  FT_EXPORT_DEF( FT_Error )
  FT_Get_Advance( FT_Face    face,
                  FT_UInt    gindex,
                  FT_Int32   flags,
                  FT_Fixed  *padvance )
  {
    FT_Face_GetAdvancesFunc  func;
    if ( !face )
      return FT_Err_Invalid_Face_Handle;
    if ( gindex >= (FT_UInt)face->num_glyphs )
      return FT_Err_Invalid_Glyph_Index;
    func = face->driver->clazz->get_advances;
    if ( func && LOAD_ADVANCE_FAST_CHECK( flags ) )
    {
      FT_Error  error;
      error = func( face, gindex, 1, flags, padvance );
      if ( !error )
        return _ft_face_scale_advances( face, padvance, 1, flags );
      if ( error != FT_ERROR_BASE( FT_Err_Unimplemented_Feature ) )
        return error;
    }
    return FT_Get_Advances( face, gindex, 1, flags, padvance );
  }
/* documentation is in ftadvanc.h */
  FT_EXPORT_DEF( FT_Error )
  FT_Get_Advances( FT_Face    face,
                   FT_UInt    start,
                   FT_UInt    count,
                   FT_Int32   flags,
                   FT_Fixed  *padvances )
  {
    FT_Face_GetAdvancesFunc  func;
    FT_UInt                  num, end, nn;
    FT_Error                 error = FT_Err_Ok;
    if ( !face )
      return FT_Err_Invalid_Face_Handle;
    num = (FT_UInt)face->num_glyphs;
    end = start + count;
    if ( start >= num || end < start || end > num )
      return FT_Err_Invalid_Glyph_Index;
    if ( count == 0 )
      return FT_Err_Ok;
    func = face->driver->clazz->get_advances;
    if ( func && LOAD_ADVANCE_FAST_CHECK( flags ) )
    {
      error = func( face, start, count, flags, padvances );
      if ( !error )
        return _ft_face_scale_advances( face, padvances, count, flags );
      if ( error != FT_ERROR_BASE( FT_Err_Unimplemented_Feature ) )
        return error;
    }
    error = FT_Err_Ok;
    if ( flags & FT_ADVANCE_FLAG_FAST_ONLY )
      return FT_Err_Unimplemented_Feature;
    flags |= (FT_UInt32)FT_LOAD_ADVANCE_ONLY;
    for ( nn = 0; nn < count; nn++ )
    {
      error = FT_Load_Glyph( face, start + nn, flags );
      if ( error )
        break;
/* scale from 26.6 to 16.16 */
      padvances[nn] = ( flags & FT_LOAD_VERTICAL_LAYOUT )
                      ? face->glyph->advance.y << 10
                      : face->glyph->advance.x << 10;
    }
    return error;
  }
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftcalc.c                                                               */
/*                                                                         */
/*    Arithmetic computations (body).                                      */
/*                                                                         */
/*  Copyright 1996-2006, 2008, 2012 by                                     */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Support for 1-complement arithmetic has been totally dropped in this  */
/* release.  You can still write your own code if you need it.           */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* Implementing basic computation routines.                              */
/*                                                                       */
/* FT_MulDiv(), FT_MulFix(), FT_DivFix(), FT_RoundFix(), FT_CeilFix(),   */
/* and FT_FloorFix() are declared in freetype.h.                         */
/*                                                                       */
/*************************************************************************/
/***************************************************************************/
/*                                                                         */
/*  ftcalc.h                                                               */
/*                                                                         */
/*    Arithmetic computations (specification).                             */
/*                                                                         */
/*  Copyright 1996-2006, 2008, 2009, 2012 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTCALC_H__
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_FixedSqrt                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    Computes the square root of a 16.16 fixed point value.             */
/*                                                                       */
/* <Input>                                                               */
/*    x :: The value to compute the root for.                            */
/*                                                                       */
/* <Return>                                                              */
/*    The result of `sqrt(x)'.                                           */
/*                                                                       */
/* <Note>                                                                */
/*    This function is not very fast.                                    */
/*                                                                       */
  FT_BASE( FT_Int32 )
  FT_SqrtFixed( FT_Int32  x );
/*************************************************************************/
/*                                                                       */
/* FT_MulDiv() and FT_MulFix() are declared in freetype.h.               */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_MulDiv_No_Round                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    A very simple function used to perform the computation `(a*b)/c'   */
/*    (without rounding) with maximum accuracy (it uses a 64-bit         */
/*    intermediate integer whenever necessary).                          */
/*                                                                       */
/*    This function isn't necessarily as fast as some processor specific */
/*    operations, but is at least completely portable.                   */
/*                                                                       */
/* <Input>                                                               */
/*    a :: The first multiplier.                                         */
/*    b :: The second multiplier.                                        */
/*    c :: The divisor.                                                  */
/*                                                                       */
/* <Return>                                                              */
/*    The result of `(a*b)/c'.  This function never traps when trying to */
/*    divide by zero; it simply returns `MaxInt' or `MinInt' depending   */
/*    on the signs of `a' and `b'.                                       */
/*                                                                       */
  FT_BASE( FT_Long )
  FT_MulDiv_No_Round( FT_Long  a,
                      FT_Long  b,
                      FT_Long  c );
/*
   *  A variant of FT_Matrix_Multiply which scales its result afterwards.
   *  The idea is that both `a' and `b' are scaled by factors of 10 so that
   *  the values are as precise as possible to get a correct result during
   *  the 64bit multiplication.  Let `sa' and `sb' be the scaling factors of
   *  `a' and `b', respectively, then the scaling factor of the result is
   *  `sa*sb'.
   */
  FT_BASE( void )
  FT_Matrix_Multiply_Scaled( const FT_Matrix*  a,
                             FT_Matrix        *b,
                             FT_Long           scaling );
/*
   *  A variant of FT_Vector_Transform.  See comments for
   *  FT_Matrix_Multiply_Scaled.
   */
  FT_BASE( void )
  FT_Vector_Transform_Scaled( FT_Vector*        vector,
                              const FT_Matrix*  matrix,
                              FT_Long           scaling );
/*
   *  Return -1, 0, or +1, depending on the orientation of a given corner.
   *  We use the Cartesian coordinate system, with positive vertical values
   *  going upwards.  The function returns +1 if the corner turns to the
   *  left, -1 to the right, and 0 for undecidable cases.
   */
  FT_BASE( FT_Int )
  ft_corner_orientation( FT_Pos  in_x,
                         FT_Pos  in_y,
                         FT_Pos  out_x,
                         FT_Pos  out_y );
/*
   *  Return TRUE if a corner is flat or nearly flat.  This is equivalent to
   *  saying that the angle difference between the `in' and `out' vectors is
   *  very small.
   */
  FT_BASE( FT_Int )
  ft_corner_is_flat( FT_Pos  in_x,
                     FT_Pos  in_y,
                     FT_Pos  out_x,
                     FT_Pos  out_y );
#define INT_TO_F26DOT6( x )    ( (FT_Long)(x) << 6  )
#define INT_TO_F2DOT14( x )    ( (FT_Long)(x) << 14 )
#define INT_TO_FIXED( x )      ( (FT_Long)(x) << 16 )
#define F2DOT14_TO_FIXED( x )  ( (FT_Long)(x) << 2  )
#define FLOAT_TO_FIXED( x )    ( (FT_Long)( x * 65536.0 ) )
#define FIXED_TO_INT( x )      ( FT_RoundFix( x ) >> 16 )
#define ROUND_F26DOT6( x )     ( x >= 0 ? (    ( (x) + 32 ) & -64 )     \
                                        : ( -( ( 32 - (x) ) & -64 ) ) )
FT_END_HEADER
/* END */
#ifdef FT_MULFIX_INLINED
#undef FT_MulFix
#endif
/* we need to define a 64-bits data type here */
#ifdef FT_LONG64
  typedef FT_INT64  FT_Int64;
#else
  typedef struct  FT_Int64_
  {
    FT_UInt32  lo;
    FT_UInt32  hi;
  } FT_Int64;
/* FT_LONG64 */
#endif  
/*************************************************************************/
/*                                                                       */
/* The macro FT_COMPONENT is used in trace mode.  It is an implicit      */
/* parameter of the FT_TRACE() and FT_ERROR() macros, used to print/log  */
/* messages during execution.                                            */
/*                                                                       */
#undef  FT_COMPONENT
#define FT_COMPONENT  trace_calc
/* The following three functions are available regardless of whether */
/* FT_LONG64 is defined.                                             */
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Fixed )
  FT_RoundFix( FT_Fixed  a )
  {
    return ( a >= 0 ) ?   ( a + 0x8000L ) & ~0xFFFFL
                      : -((-a + 0x8000L ) & ~0xFFFFL );
  }
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Fixed )
  FT_CeilFix( FT_Fixed  a )
  {
    return ( a >= 0 ) ?   ( a + 0xFFFFL ) & ~0xFFFFL
                      : -((-a + 0xFFFFL ) & ~0xFFFFL );
  }
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Fixed )
  FT_FloorFix( FT_Fixed  a )
  {
    return ( a >= 0 ) ?   a & ~0xFFFFL
                      : -((-a) & ~0xFFFFL );
  }
#ifdef FT_LONG64
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Long )
  FT_MulDiv( FT_Long  a,
             FT_Long  b,
             FT_Long  c )
  {
    FT_Int   s;
    FT_Long  d;
    s = 1;
    if ( a < 0 ) { a = -a; s = -1; }
    if ( b < 0 ) { b = -b; s = -s; }
    if ( c < 0 ) { c = -c; s = -s; }
    d = (FT_Long)( c > 0 ? ( (FT_Int64)a * b + ( c >> 1 ) ) / c
                         : 0x7FFFFFFFL );
    return ( s > 0 ) ? d : -d;
  }
/* documentation is in ftcalc.h */
  FT_BASE_DEF( FT_Long )
  FT_MulDiv_No_Round( FT_Long  a,
                      FT_Long  b,
                      FT_Long  c )
  {
    FT_Int   s;
    FT_Long  d;
    s = 1;
    if ( a < 0 ) { a = -a; s = -1; }
    if ( b < 0 ) { b = -b; s = -s; }
    if ( c < 0 ) { c = -c; s = -s; }
    d = (FT_Long)( c > 0 ? (FT_Int64)a * b / c
                         : 0x7FFFFFFFL );
    return ( s > 0 ) ? d : -d;
  }
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Long )
  FT_MulFix( FT_Long  a,
             FT_Long  b )
  {
#ifdef FT_MULFIX_ASSEMBLER
    return FT_MULFIX_ASSEMBLER( a, b );
#else
    FT_Int   s = 1;
    FT_Long  c;
    if ( a < 0 )
    {
      a = -a;
      s = -1;
    }
    if ( b < 0 )
    {
      b = -b;
      s = -s;
    }
    c = (FT_Long)( ( (FT_Int64)a * b + 0x8000L ) >> 16 );
    return ( s > 0 ) ? c : -c;
/* FT_MULFIX_ASSEMBLER */
#endif  
  }
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Long )
  FT_DivFix( FT_Long  a,
             FT_Long  b )
  {
    FT_Int32   s;
    FT_UInt32  q;
    s = 1;
    if ( a < 0 ) { a = -a; s = -1; }
    if ( b < 0 ) { b = -b; s = -s; }
    if ( b == 0 )
/* check for division by 0 */
      q = 0x7FFFFFFFL;
    else
/* compute result directly */
      q = (FT_UInt32)( ( ( (FT_Int64)a << 16 ) + ( b >> 1 ) ) / b );
    return ( s < 0 ? -(FT_Long)q : (FT_Long)q );
  }
/* !FT_LONG64 */
#else  
  static void
  ft_multo64( FT_UInt32  x,
              FT_UInt32  y,
              FT_Int64  *z )
  {
    FT_UInt32  lo1, hi1, lo2, hi2, lo, hi, i1, i2;
    lo1 = x & 0x0000FFFFU;  hi1 = x >> 16;
    lo2 = y & 0x0000FFFFU;  hi2 = y >> 16;
    lo = lo1 * lo2;
    i1 = lo1 * hi2;
    i2 = lo2 * hi1;
    hi = hi1 * hi2;
/* Check carry overflow of i1 + i2 */
    i1 += i2;
    hi += (FT_UInt32)( i1 < i2 ) << 16;
    hi += i1 >> 16;
    i1  = i1 << 16;
/* Check carry overflow of i1 + lo */
    lo += i1;
    hi += ( lo < i1 );
    z->lo = lo;
    z->hi = hi;
  }
  static FT_UInt32
  ft_div64by32( FT_UInt32  hi,
                FT_UInt32  lo,
                FT_UInt32  y )
  {
    FT_UInt32  r, q;
    FT_Int     i;
    q = 0;
    r = hi;
    if ( r >= y )
      return (FT_UInt32)0x7FFFFFFFL;
    i = 32;
    do
    {
      r <<= 1;
      q <<= 1;
      r  |= lo >> 31;
      if ( r >= y )
      {
        r -= y;
        q |= 1;
      }
      lo <<= 1;
    } while ( --i );
    return q;
  }
  static void
  FT_Add64( FT_Int64*  x,
            FT_Int64*  y,
            FT_Int64  *z )
  {
    register FT_UInt32  lo, hi;
    lo = x->lo + y->lo;
    hi = x->hi + y->hi + ( lo < x->lo );
    z->lo = lo;
    z->hi = hi;
  }
/* documentation is in freetype.h */
/* The FT_MulDiv function has been optimized thanks to ideas from      */
/* Graham Asher.  The trick is to optimize computation when everything */
/* fits within 32-bits (a rather common case).                         */
/*                                                                     */
/*  we compute 'a*b+c/2', then divide it by 'c'. (positive values)     */
/*                                                                     */
/*  46340 is FLOOR(SQRT(2^31-1)).                                      */
/*                                                                     */
/*  if ( a <= 46340 && b <= 46340 ) then ( a*b <= 0x7FFEA810 )         */
/*                                                                     */
/*  0x7FFFFFFF - 0x7FFEA810 = 0x157F0                                  */
/*                                                                     */
/*  if ( c < 0x157F0*2 ) then ( a*b+c/2 <= 0x7FFFFFFF )                */
/*                                                                     */
/*  and 2*0x157F0 = 176096                                             */
/*                                                                     */
  FT_EXPORT_DEF( FT_Long )
  FT_MulDiv( FT_Long  a,
             FT_Long  b,
             FT_Long  c )
  {
    long  s;
/* XXX: this function does not allow 64-bit arguments */
    if ( a == 0 || b == c )
      return a;
    s  = a; a = FT_ABS( a );
    s ^= b; b = FT_ABS( b );
    s ^= c; c = FT_ABS( c );
    if ( a <= 46340L && b <= 46340L && c <= 176095L && c > 0 )
      a = ( a * b + ( c >> 1 ) ) / c;
    else if ( (FT_Int32)c > 0 )
    {
      FT_Int64  temp, temp2;
      ft_multo64( (FT_Int32)a, (FT_Int32)b, &temp );
      temp2.hi = 0;
      temp2.lo = (FT_UInt32)(c >> 1);
      FT_Add64( &temp, &temp2, &temp );
      a = ft_div64by32( temp.hi, temp.lo, (FT_Int32)c );
    }
    else
      a = 0x7FFFFFFFL;
    return ( s < 0 ? -a : a );
  }
  FT_BASE_DEF( FT_Long )
  FT_MulDiv_No_Round( FT_Long  a,
                      FT_Long  b,
                      FT_Long  c )
  {
    long  s;
    if ( a == 0 || b == c )
      return a;
    s  = a; a = FT_ABS( a );
    s ^= b; b = FT_ABS( b );
    s ^= c; c = FT_ABS( c );
    if ( a <= 46340L && b <= 46340L && c > 0 )
      a = a * b / c;
    else if ( (FT_Int32)c > 0 )
    {
      FT_Int64  temp;
      ft_multo64( (FT_Int32)a, (FT_Int32)b, &temp );
      a = ft_div64by32( temp.hi, temp.lo, (FT_Int32)c );
    }
    else
      a = 0x7FFFFFFFL;
    return ( s < 0 ? -a : a );
  }
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Long )
  FT_MulFix( FT_Long  a,
             FT_Long  b )
  {
#ifdef FT_MULFIX_ASSEMBLER
    return FT_MULFIX_ASSEMBLER( a, b );
#elif 0
/*
     *  This code is nonportable.  See comment below.
     *
     *  However, on a platform where right-shift of a signed quantity fills
     *  the leftmost bits by copying the sign bit, it might be faster.
     */
    FT_Long   sa, sb;
    FT_ULong  ua, ub;
    if ( a == 0 || b == 0x10000L )
      return a;
/*
     *  This is a clever way of converting a signed number `a' into its
     *  absolute value (stored back into `a') and its sign.  The sign is
     *  stored in `sa'; 0 means `a' was positive or zero, and -1 means `a'
     *  was negative.  (Similarly for `b' and `sb').
     *
     *  Unfortunately, it doesn't work (at least not portably).
     *
     *  It makes the assumption that right-shift on a negative signed value
     *  fills the leftmost bits by copying the sign bit.  This is wrong.
     *  According to K&R 2nd ed, section `A7.8 Shift Operators' on page 206,
     *  the result of right-shift of a negative signed value is
     *  implementation-defined.  At least one implementation fills the
     *  leftmost bits with 0s (i.e., it is exactly the same as an unsigned
     *  right shift).  This means that when `a' is negative, `sa' ends up
     *  with the value 1 rather than -1.  After that, everything else goes
     *  wrong.
     */
    sa = ( a >> ( sizeof ( a ) * 8 - 1 ) );
    a  = ( a ^ sa ) - sa;
    sb = ( b >> ( sizeof ( b ) * 8 - 1 ) );
    b  = ( b ^ sb ) - sb;
    ua = (FT_ULong)a;
    ub = (FT_ULong)b;
    if ( ua <= 2048 && ub <= 1048576L )
      ua = ( ua * ub + 0x8000U ) >> 16;
    else
    {
      FT_ULong  al = ua & 0xFFFFU;
      ua = ( ua >> 16 ) * ub +  al * ( ub >> 16 ) +
           ( ( al * ( ub & 0xFFFFU ) + 0x8000U ) >> 16 );
    }
    sa ^= sb,
    ua  = (FT_ULong)(( ua ^ sa ) - sa);
    return (FT_Long)ua;
/* 0 */
#else  
    FT_Long   s;
    FT_ULong  ua, ub;
    if ( a == 0 || b == 0x10000L )
      return a;
    s  = a; a = FT_ABS( a );
    s ^= b; b = FT_ABS( b );
    ua = (FT_ULong)a;
    ub = (FT_ULong)b;
    if ( ua <= 2048 && ub <= 1048576L )
      ua = ( ua * ub + 0x8000UL ) >> 16;
    else
    {
      FT_ULong  al = ua & 0xFFFFUL;
      ua = ( ua >> 16 ) * ub +  al * ( ub >> 16 ) +
           ( ( al * ( ub & 0xFFFFUL ) + 0x8000UL ) >> 16 );
    }
    return ( s < 0 ? -(FT_Long)ua : (FT_Long)ua );
/* 0 */
#endif  
  }
/* documentation is in freetype.h */
  FT_EXPORT_DEF( FT_Long )
  FT_DivFix( FT_Long  a,
             FT_Long  b )
  {
    FT_Int32   s;
    FT_UInt32  q;
/* XXX: this function does not allow 64-bit arguments */
    s  = (FT_Int32)a; a = FT_ABS( a );
    s ^= (FT_Int32)b; b = FT_ABS( b );
    if ( (FT_UInt32)b == 0 )
    {
/* check for division by 0 */
      q = (FT_UInt32)0x7FFFFFFFL;
    }
    else if ( ( a >> 16 ) == 0 )
    {
/* compute result directly */
      q = (FT_UInt32)( ( a << 16 ) + ( b >> 1 ) ) / (FT_UInt32)b;
    }
    else
    {
/* we need more bits; we have to do it by hand */
      FT_Int64  temp, temp2;
      temp.hi  = (FT_Int32) ( a >> 16 );
      temp.lo  = (FT_UInt32)( a << 16 );
      temp2.hi = 0;
      temp2.lo = (FT_UInt32)( b >> 1 );
      FT_Add64( &temp, &temp2, &temp );
      q = ft_div64by32( temp.hi, temp.lo, (FT_Int32)b );
    }
    return ( s < 0 ? -(FT_Int32)q : (FT_Int32)q );
  }
#if 0
/* documentation is in ftcalc.h */
  FT_EXPORT_DEF( void )
  FT_MulTo64( FT_Int32   x,
              FT_Int32   y,
              FT_Int64  *z )
  {
    FT_Int32  s;
    s  = x; x = FT_ABS( x );
    s ^= y; y = FT_ABS( y );
    ft_multo64( x, y, z );
    if ( s < 0 )
    {
      z->lo = (FT_UInt32)-(FT_Int32)z->lo;
      z->hi = ~z->hi + !( z->lo );
    }
  }
/* apparently, the second version of this code is not compiled correctly */
/* on Mac machines with the MPW C compiler..  tsk, tsk, tsk...           */
#if 1
  FT_EXPORT_DEF( FT_Int32 )
  FT_Div64by32( FT_Int64*  x,
                FT_Int32   y )
  {
    FT_Int32   s;
    FT_UInt32  q, r, i, lo;
    s  = x->hi;
    if ( s < 0 )
    {
      x->lo = (FT_UInt32)-(FT_Int32)x->lo;
      x->hi = ~x->hi + !x->lo;
    }
    s ^= y;  y = FT_ABS( y );
/* Shortcut */
    if ( x->hi == 0 )
    {
      if ( y > 0 )
        q = x->lo / y;
      else
        q = 0x7FFFFFFFL;
      return ( s < 0 ? -(FT_Int32)q : (FT_Int32)q );
    }
    r  = x->hi;
    lo = x->lo;
/* we know y is to be treated as unsigned here */
    if ( r >= (FT_UInt32)y )  
      return ( s < 0 ? 0x80000001UL : 0x7FFFFFFFUL );
/* Return Max/Min Int32 if division overflow. */
/* This includes division by zero!            */
    q = 0;
    for ( i = 0; i < 32; i++ )
    {
      r <<= 1;
      q <<= 1;
      r  |= lo >> 31;
      if ( r >= (FT_UInt32)y )
      {
        r -= y;
        q |= 1;
      }
      lo <<= 1;
    }
    return ( s < 0 ? -(FT_Int32)q : (FT_Int32)q );
  }
/* 0 */
#else  
  FT_EXPORT_DEF( FT_Int32 )
  FT_Div64by32( FT_Int64*  x,
                FT_Int32   y )
  {
    FT_Int32   s;
    FT_UInt32  q;
    s  = x->hi;
    if ( s < 0 )
    {
      x->lo = (FT_UInt32)-(FT_Int32)x->lo;
      x->hi = ~x->hi + !x->lo;
    }
    s ^= y;  y = FT_ABS( y );
/* Shortcut */
    if ( x->hi == 0 )
    {
      if ( y > 0 )
        q = ( x->lo + ( y >> 1 ) ) / y;
      else
        q = 0x7FFFFFFFL;
      return ( s < 0 ? -(FT_Int32)q : (FT_Int32)q );
    }
    q = ft_div64by32( x->hi, x->lo, y );
    return ( s < 0 ? -(FT_Int32)q : (FT_Int32)q );
  }
/* 0 */
#endif  
/* 0 */
#endif  
/* FT_LONG64 */
#endif  
/* documentation is in ftglyph.h */
  FT_EXPORT_DEF( void )
  FT_Matrix_Multiply( const FT_Matrix*  a,
                      FT_Matrix        *b )
  {
    FT_Fixed  xx, xy, yx, yy;
    if ( !a || !b )
      return;
    xx = FT_MulFix( a->xx, b->xx ) + FT_MulFix( a->xy, b->yx );
    xy = FT_MulFix( a->xx, b->xy ) + FT_MulFix( a->xy, b->yy );
    yx = FT_MulFix( a->yx, b->xx ) + FT_MulFix( a->yy, b->yx );
    yy = FT_MulFix( a->yx, b->xy ) + FT_MulFix( a->yy, b->yy );
    b->xx = xx;  b->xy = xy;
    b->yx = yx;  b->yy = yy;
  }
/* documentation is in ftglyph.h */
  FT_EXPORT_DEF( FT_Error )
  FT_Matrix_Invert( FT_Matrix*  matrix )
  {
    FT_Pos  delta, xx, yy;
    if ( !matrix )
      return FT_Err_Invalid_Argument;
/* compute discriminant */
    delta = FT_MulFix( matrix->xx, matrix->yy ) -
            FT_MulFix( matrix->xy, matrix->yx );
    if ( !delta )
/* matrix can't be inverted */
      return FT_Err_Invalid_Argument;   
    matrix->xy = - FT_DivFix( matrix->xy, delta );
    matrix->yx = - FT_DivFix( matrix->yx, delta );
    xx = matrix->xx;
    yy = matrix->yy;
    matrix->xx = FT_DivFix( yy, delta );
    matrix->yy = FT_DivFix( xx, delta );
    return FT_Err_Ok;
  }
/* documentation is in ftcalc.h */
  FT_BASE_DEF( void )
  FT_Matrix_Multiply_Scaled( const FT_Matrix*  a,
                             FT_Matrix        *b,
                             FT_Long           scaling )
  {
    FT_Fixed  xx, xy, yx, yy;
    FT_Long   val = 0x10000L * scaling;
    if ( !a || !b )
      return;
    xx = FT_MulDiv( a->xx, b->xx, val ) + FT_MulDiv( a->xy, b->yx, val );
    xy = FT_MulDiv( a->xx, b->xy, val ) + FT_MulDiv( a->xy, b->yy, val );
    yx = FT_MulDiv( a->yx, b->xx, val ) + FT_MulDiv( a->yy, b->yx, val );
    yy = FT_MulDiv( a->yx, b->xy, val ) + FT_MulDiv( a->yy, b->yy, val );
    b->xx = xx;  b->xy = xy;
    b->yx = yx;  b->yy = yy;
  }
/* documentation is in ftcalc.h */
  FT_BASE_DEF( void )
  FT_Vector_Transform_Scaled( FT_Vector*        vector,
                              const FT_Matrix*  matrix,
                              FT_Long           scaling )
  {
    FT_Pos   xz, yz;
    FT_Long  val = 0x10000L * scaling;
    if ( !vector || !matrix )
      return;
    xz = FT_MulDiv( vector->x, matrix->xx, val ) +
         FT_MulDiv( vector->y, matrix->xy, val );
    yz = FT_MulDiv( vector->x, matrix->yx, val ) +
         FT_MulDiv( vector->y, matrix->yy, val );
    vector->x = xz;
    vector->y = yz;
  }
/* documentation is in ftcalc.h */
  FT_BASE_DEF( FT_Int32 )
  FT_SqrtFixed( FT_Int32  x )
  {
    FT_UInt32  root, rem_hi, rem_lo, test_div;
    FT_Int     count;
    root = 0;
    if ( x > 0 )
    {
      rem_hi = 0;
      rem_lo = x;
      count  = 24;
      do
      {
        rem_hi   = ( rem_hi << 2 ) | ( rem_lo >> 30 );
        rem_lo <<= 2;
        root   <<= 1;
        test_div = ( root << 1 ) + 1;
        if ( rem_hi >= test_div )
        {
          rem_hi -= test_div;
          root   += 1;
        }
      } while ( --count );
    }
    return (FT_Int32)root;
  }
/* documentation is in ftcalc.h */
  FT_BASE_DEF( FT_Int )
  ft_corner_orientation( FT_Pos  in_x,
                         FT_Pos  in_y,
                         FT_Pos  out_x,
                         FT_Pos  out_y )
  {
/* avoid overflow on 16-bit system */
    FT_Long  result;  
/* deal with the trivial cases quickly */
    if ( in_y == 0 )
    {
      if ( in_x >= 0 )
        result = out_y;
      else
        result = -out_y;
    }
    else if ( in_x == 0 )
    {
      if ( in_y >= 0 )
        result = -out_x;
      else
        result = out_x;
    }
    else if ( out_y == 0 )
    {
      if ( out_x >= 0 )
        result = in_y;
      else
        result = -in_y;
    }
    else if ( out_x == 0 )
    {
      if ( out_y >= 0 )
        result = -in_x;
      else
        result =  in_x;
    }
/* general case */
    else  
    {
#ifdef FT_LONG64
      FT_Int64  delta = (FT_Int64)in_x * out_y - (FT_Int64)in_y * out_x;
      if ( delta == 0 )
        result = 0;
      else
        result = 1 - 2 * ( delta < 0 );
#else
      FT_Int64  z1, z2;
/* XXX: this function does not allow 64-bit arguments */
      ft_multo64( (FT_Int32)in_x, (FT_Int32)out_y, &z1 );
      ft_multo64( (FT_Int32)in_y, (FT_Int32)out_x, &z2 );
      if ( z1.hi > z2.hi )
        result = +1;
      else if ( z1.hi < z2.hi )
        result = -1;
      else if ( z1.lo > z2.lo )
        result = +1;
      else if ( z1.lo < z2.lo )
        result = -1;
      else
        result = 0;
#endif
    }
/* XXX: only the sign of return value, +1/0/-1 must be used */
    return (FT_Int)result;
  }
/* documentation is in ftcalc.h */
  FT_BASE_DEF( FT_Int )
  ft_corner_is_flat( FT_Pos  in_x,
                     FT_Pos  in_y,
                     FT_Pos  out_x,
                     FT_Pos  out_y )
  {
    FT_Pos  ax = in_x;
    FT_Pos  ay = in_y;
    FT_Pos  d_in, d_out, d_corner;
    if ( ax < 0 )
      ax = -ax;
    if ( ay < 0 )
      ay = -ay;
    d_in = ax + ay;
    ax = out_x;
    if ( ax < 0 )
      ax = -ax;
    ay = out_y;
    if ( ay < 0 )
      ay = -ay;
    d_out = ax + ay;
    ax = out_x + in_x;
    if ( ax < 0 )
      ax = -ax;
    ay = out_y + in_y;
    if ( ay < 0 )
      ay = -ay;
    d_corner = ax + ay;
    return ( d_in + d_out - d_corner ) < ( d_corner >> 4 );
  }
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftdbgmem.c                                                             */
/*                                                                         */
/*    Memory debugger (body).                                              */
/*                                                                         */
/*  Copyright 2001, 2002, 2003, 2004, 2005, 2006, 2009 by                  */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*  fterrors.h                                                             */
/*                                                                         */
/*    FreeType error code handling (specification).                        */
/*                                                                         */
/*  Copyright 1996-2001, 2002, 2004, 2007 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This special header file is used to define the handling of FT2        */
/* enumeration constants.  It can also be used to generate error message */
/* strings with a small macro trick explained below.                     */
/*                                                                       */
/* I - Error Formats                                                     */
/* -----------------                                                     */
/*                                                                       */
/*   The configuration macro FT_CONFIG_OPTION_USE_MODULE_ERRORS can be   */
/*   defined in ftoption.h in order to make the higher byte indicate     */
/*   the module where the error has happened (this is not compatible     */
/*   with standard builds of FreeType 2).  You can then use the macro    */
/*   FT_ERROR_BASE macro to extract the generic error code from an       */
/*   FT_Error value.                                                     */
/*                                                                       */
/*                                                                       */
/* II - Error Message strings                                            */
/* --------------------------                                            */
/*                                                                       */
/*   The error definitions below are made through special macros that    */
/*   allow client applications to build a table of error message strings */
/*   if they need it.  The strings are not included in a normal build of */
/*   FreeType 2 to save space (most client applications do not use       */
/*   them).                                                              */
/*                                                                       */
/*   To do so, you have to define the following macros before including  */
/*   this file:                                                          */
/*                                                                       */
/*   FT_ERROR_START_LIST ::                                              */
/*     This macro is called before anything else to define the start of  */
/*     the error list.  It is followed by several FT_ERROR_DEF calls     */
/*     (see below).                                                      */
/*                                                                       */
/*   FT_ERROR_DEF( e, v, s ) ::                                          */
/*     This macro is called to define one single error.                  */
/*     `e' is the error code identifier (e.g. FT_Err_Invalid_Argument).  */
/*     `v' is the error numerical value.                                 */
/*     `s' is the corresponding error string.                            */
/*                                                                       */
/*   FT_ERROR_END_LIST ::                                                */
/*     This macro ends the list.                                         */
/*                                                                       */
/*   Additionally, you have to undefine __FTERRORS_H__ before #including */
/*   this file.                                                          */
/*                                                                       */
/*   Here is a simple example:                                           */
/*                                                                       */
/*     {                                                                 */
/*       #undef __FTERRORS_H__                                           */
/*       #define FT_ERRORDEF( e, v, s )  { e, s },                       */
/*       #define FT_ERROR_START_LIST     {                               */
/*       #define FT_ERROR_END_LIST       { 0, 0 } };                     */
/*                                                                       */
/*       const struct                                                    */
/*       {                                                               */
/*         int          err_code;                                        */
/*         const char*  err_msg;                                         */
/*       } ft_errors[] =                                                 */
/*                                                                       */
/*       #include FT_ERRORS_H                                            */
/*     }                                                                 */
/*                                                                       */
/*************************************************************************/
#ifndef __FTERRORS_H__
#define __FTERRORS_H__
/* include module base error codes */
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                       SETUP MACROS                      *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#undef  FT_NEED_EXTERN_C
#undef  FT_ERR_XCAT
#undef  FT_ERR_CAT
#define FT_ERR_XCAT( x, y )  x ## y
#define FT_ERR_CAT( x, y )   FT_ERR_XCAT( x, y )
/* FT_ERR_PREFIX is used as a prefix for error identifiers. */
/* By default, we use `FT_Err_'.                            */
/*                                                          */
#ifndef FT_ERR_PREFIX
#define FT_ERR_PREFIX  FT_Err_
#endif
/* FT_ERR_BASE is used as the base for module-specific errors. */
/*                                                             */
#undef FT_ERR_BASE
#define FT_ERR_BASE  0
/* If FT_ERRORDEF is not defined, we need to define a simple */
/* enumeration type.                                         */
/*                                                           */
#ifndef FT_ERRORDEF
#define FT_ERRORDEF( e, v, s )  e = v,
#define FT_ERROR_START_LIST     enum {
#define FT_ERROR_END_LIST       FT_ERR_CAT( FT_ERR_PREFIX, Max ) };
#ifdef __cplusplus
#define FT_NEED_EXTERN_C
  extern "C" {
#endif
/* !FT_ERRORDEF */
#endif  
/* this macro is used to define an error */
#define FT_ERRORDEF_( e, v, s )   \
          FT_ERRORDEF( FT_ERR_CAT( FT_ERR_PREFIX, e ), v + FT_ERR_BASE, s )
/* this is only used for <module>_Err_Ok, which must be 0! */
#define FT_NOERRORDEF_( e, v, s ) \
          FT_ERRORDEF( FT_ERR_CAT( FT_ERR_PREFIX, e ), v, s )
#ifdef FT_ERROR_START_LIST
  FT_ERROR_START_LIST
#endif
/* now include the error codes */
/***************************************************************************/
/*                                                                         */
/*  fterrdef.h                                                             */
/*                                                                         */
/*    FreeType error codes (specification).                                */
/*                                                                         */
/*  Copyright 2002, 2004, 2006, 2007, 2010-2012 by                         */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                LIST OF ERROR CODES/MESSAGES             *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
/* You need to define both FT_ERRORDEF_ and FT_NOERRORDEF_ before */
/* including this file.                                           */
/* generic errors */
  FT_NOERRORDEF_( Ok,                                        0x00, \
                  "no error" )
  FT_ERRORDEF_( Cannot_Open_Resource,                        0x01, \
                "cannot open resource" )
  FT_ERRORDEF_( Unknown_File_Format,                         0x02, \
                "unknown file format" )
  FT_ERRORDEF_( Invalid_File_Format,                         0x03, \
                "broken file" )
  FT_ERRORDEF_( Invalid_Version,                             0x04, \
                "invalid FreeType version" )
  FT_ERRORDEF_( Lower_Module_Version,                        0x05, \
                "module version is too low" )
  FT_ERRORDEF_( Invalid_Argument,                            0x06, \
                "invalid argument" )
  FT_ERRORDEF_( Unimplemented_Feature,                       0x07, \
                "unimplemented feature" )
  FT_ERRORDEF_( Invalid_Table,                               0x08, \
                "broken table" )
  FT_ERRORDEF_( Invalid_Offset,                              0x09, \
                "broken offset within table" )
  FT_ERRORDEF_( Array_Too_Large,                             0x0A, \
                "array allocation size too large" )
  FT_ERRORDEF_( Missing_Module,                              0x0B, \
                "missing module" )
  FT_ERRORDEF_( Missing_Property,                            0x0C, \
                "missing property" )
/* glyph/character errors */
  FT_ERRORDEF_( Invalid_Glyph_Index,                         0x10, \
                "invalid glyph index" )
  FT_ERRORDEF_( Invalid_Character_Code,                      0x11, \
                "invalid character code" )
  FT_ERRORDEF_( Invalid_Glyph_Format,                        0x12, \
                "unsupported glyph image format" )
  FT_ERRORDEF_( Cannot_Render_Glyph,                         0x13, \
                "cannot render this glyph format" )
  FT_ERRORDEF_( Invalid_Outline,                             0x14, \
                "invalid outline" )
  FT_ERRORDEF_( Invalid_Composite,                           0x15, \
                "invalid composite glyph" )
  FT_ERRORDEF_( Too_Many_Hints,                              0x16, \
                "too many hints" )
  FT_ERRORDEF_( Invalid_Pixel_Size,                          0x17, \
                "invalid pixel size" )
/* handle errors */
  FT_ERRORDEF_( Invalid_Handle,                              0x20, \
                "invalid object handle" )
  FT_ERRORDEF_( Invalid_Library_Handle,                      0x21, \
                "invalid library handle" )
  FT_ERRORDEF_( Invalid_Driver_Handle,                       0x22, \
                "invalid module handle" )
  FT_ERRORDEF_( Invalid_Face_Handle,                         0x23, \
                "invalid face handle" )
  FT_ERRORDEF_( Invalid_Size_Handle,                         0x24, \
                "invalid size handle" )
  FT_ERRORDEF_( Invalid_Slot_Handle,                         0x25, \
                "invalid glyph slot handle" )
  FT_ERRORDEF_( Invalid_CharMap_Handle,                      0x26, \
                "invalid charmap handle" )
  FT_ERRORDEF_( Invalid_Cache_Handle,                        0x27, \
                "invalid cache manager handle" )
  FT_ERRORDEF_( Invalid_Stream_Handle,                       0x28, \
                "invalid stream handle" )
/* driver errors */
  FT_ERRORDEF_( Too_Many_Drivers,                            0x30, \
                "too many modules" )
  FT_ERRORDEF_( Too_Many_Extensions,                         0x31, \
                "too many extensions" )
/* memory errors */
  FT_ERRORDEF_( Out_Of_Memory,                               0x40, \
                "out of memory" )
  FT_ERRORDEF_( Unlisted_Object,                             0x41, \
                "unlisted object" )
/* stream errors */
  FT_ERRORDEF_( Cannot_Open_Stream,                          0x51, \
                "cannot open stream" )
  FT_ERRORDEF_( Invalid_Stream_Seek,                         0x52, \
                "invalid stream seek" )
  FT_ERRORDEF_( Invalid_Stream_Skip,                         0x53, \
                "invalid stream skip" )
  FT_ERRORDEF_( Invalid_Stream_Read,                         0x54, \
                "invalid stream read" )
  FT_ERRORDEF_( Invalid_Stream_Operation,                    0x55, \
                "invalid stream operation" )
  FT_ERRORDEF_( Invalid_Frame_Operation,                     0x56, \
                "invalid frame operation" )
  FT_ERRORDEF_( Nested_Frame_Access,                         0x57, \
                "nested frame access" )
  FT_ERRORDEF_( Invalid_Frame_Read,                          0x58, \
                "invalid frame read" )
/* raster errors */
  FT_ERRORDEF_( Raster_Uninitialized,                        0x60, \
                "raster uninitialized" )
  FT_ERRORDEF_( Raster_Corrupted,                            0x61, \
                "raster corrupted" )
  FT_ERRORDEF_( Raster_Overflow,                             0x62, \
                "raster overflow" )
  FT_ERRORDEF_( Raster_Negative_Height,                      0x63, \
                "negative height while rastering" )
/* cache errors */
  FT_ERRORDEF_( Too_Many_Caches,                             0x70, \
                "too many registered caches" )
/* TrueType and SFNT errors */
  FT_ERRORDEF_( Invalid_Opcode,                              0x80, \
                "invalid opcode" )
  FT_ERRORDEF_( Too_Few_Arguments,                           0x81, \
                "too few arguments" )
  FT_ERRORDEF_( Stack_Overflow,                              0x82, \
                "stack overflow" )
  FT_ERRORDEF_( Code_Overflow,                               0x83, \
                "code overflow" )
  FT_ERRORDEF_( Bad_Argument,                                0x84, \
                "bad argument" )
  FT_ERRORDEF_( Divide_By_Zero,                              0x85, \
                "division by zero" )
  FT_ERRORDEF_( Invalid_Reference,                           0x86, \
                "invalid reference" )
  FT_ERRORDEF_( Debug_OpCode,                                0x87, \
                "found debug opcode" )
  FT_ERRORDEF_( ENDF_In_Exec_Stream,                         0x88, \
                "found ENDF opcode in execution stream" )
  FT_ERRORDEF_( Nested_DEFS,                                 0x89, \
                "nested DEFS" )
  FT_ERRORDEF_( Invalid_CodeRange,                           0x8A, \
                "invalid code range" )
  FT_ERRORDEF_( Execution_Too_Long,                          0x8B, \
                "execution context too long" )
  FT_ERRORDEF_( Too_Many_Function_Defs,                      0x8C, \
                "too many function definitions" )
  FT_ERRORDEF_( Too_Many_Instruction_Defs,                   0x8D, \
                "too many instruction definitions" )
  FT_ERRORDEF_( Table_Missing,                               0x8E, \
                "SFNT font table missing" )
  FT_ERRORDEF_( Horiz_Header_Missing,                        0x8F, \
                "horizontal header (hhea) table missing" )
  FT_ERRORDEF_( Locations_Missing,                           0x90, \
                "locations (loca) table missing" )
  FT_ERRORDEF_( Name_Table_Missing,                          0x91, \
                "name table missing" )
  FT_ERRORDEF_( CMap_Table_Missing,                          0x92, \
                "character map (cmap) table missing" )
  FT_ERRORDEF_( Hmtx_Table_Missing,                          0x93, \
                "horizontal metrics (hmtx) table missing" )
  FT_ERRORDEF_( Post_Table_Missing,                          0x94, \
                "PostScript (post) table missing" )
  FT_ERRORDEF_( Invalid_Horiz_Metrics,                       0x95, \
                "invalid horizontal metrics" )
  FT_ERRORDEF_( Invalid_CharMap_Format,                      0x96, \
                "invalid character map (cmap) format" )
  FT_ERRORDEF_( Invalid_PPem,                                0x97, \
                "invalid ppem value" )
  FT_ERRORDEF_( Invalid_Vert_Metrics,                        0x98, \
                "invalid vertical metrics" )
  FT_ERRORDEF_( Could_Not_Find_Context,                      0x99, \
                "could not find context" )
  FT_ERRORDEF_( Invalid_Post_Table_Format,                   0x9A, \
                "invalid PostScript (post) table format" )
  FT_ERRORDEF_( Invalid_Post_Table,                          0x9B, \
                "invalid PostScript (post) table" )
/* CFF, CID, and Type 1 errors */
  FT_ERRORDEF_( Syntax_Error,                                0xA0, \
                "opcode syntax error" )
  FT_ERRORDEF_( Stack_Underflow,                             0xA1, \
                "argument stack underflow" )
  FT_ERRORDEF_( Ignore,                                      0xA2, \
                "ignore" )
  FT_ERRORDEF_( No_Unicode_Glyph_Name,                       0xA3, \
                "no Unicode glyph name found" )
/* BDF errors */
  FT_ERRORDEF_( Missing_Startfont_Field,                     0xB0, \
                "`STARTFONT' field missing" )
  FT_ERRORDEF_( Missing_Font_Field,                          0xB1, \
                "`FONT' field missing" )
  FT_ERRORDEF_( Missing_Size_Field,                          0xB2, \
                "`SIZE' field missing" )
  FT_ERRORDEF_( Missing_Fontboundingbox_Field,               0xB3, \
                "`FONTBOUNDINGBOX' field missing" )
  FT_ERRORDEF_( Missing_Chars_Field,                         0xB4, \
                "`CHARS' field missing" )
  FT_ERRORDEF_( Missing_Startchar_Field,                     0xB5, \
                "`STARTCHAR' field missing" )
  FT_ERRORDEF_( Missing_Encoding_Field,                      0xB6, \
                "`ENCODING' field missing" )
  FT_ERRORDEF_( Missing_Bbx_Field,                           0xB7, \
                "`BBX' field missing" )
  FT_ERRORDEF_( Bbx_Too_Big,                                 0xB8, \
                "`BBX' too big" )
  FT_ERRORDEF_( Corrupted_Font_Header,                       0xB9, \
                "Font header corrupted or missing fields" )
  FT_ERRORDEF_( Corrupted_Font_Glyphs,                       0xBA, \
                "Font glyphs corrupted or missing fields" )
/* END */
#ifdef FT_ERROR_END_LIST
  FT_ERROR_END_LIST
#endif
/*******************************************************************/
/*******************************************************************/
/*****                                                         *****/
/*****                      SIMPLE CLEANUP                     *****/
/*****                                                         *****/
/*******************************************************************/
/*******************************************************************/
#ifdef FT_NEED_EXTERN_C
  }
#endif
#undef FT_ERROR_START_LIST
#undef FT_ERROR_END_LIST
#undef FT_ERRORDEF
#undef FT_ERRORDEF_
#undef FT_NOERRORDEF_
#undef FT_NEED_EXTERN_C
#undef FT_ERR_BASE
/* FT_KEEP_ERR_PREFIX is needed for ftvalid.h */
#ifndef FT_KEEP_ERR_PREFIX
#undef FT_ERR_PREFIX
#else
#undef FT_KEEP_ERR_PREFIX
#endif
/* __FTERRORS_H__ */
#endif  
/* END */
/* ANSI C doesn't like empty source files */
  typedef int  _debug_mem_dummy;
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftgloadr.c                                                             */
/*                                                                         */
/*    The FreeType glyph loader (body).                                    */
/*                                                                         */
/*  Copyright 2002, 2003, 2004, 2005, 2006, 2010 by                        */
/*  David Turner, Robert Wilhelm, and Werner Lemberg                       */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#undef  FT_COMPONENT
#define FT_COMPONENT  trace_gloader
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*****                                                               *****/
/*****                                                               *****/
/*****                    G L Y P H   L O A D E R                    *****/
/*****                                                               *****/
/*****                                                               *****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* The glyph loader is a simple object which is used to load a set of    */
/* glyphs easily.  It is critical for the correct loading of composites. */
/*                                                                       */
/* Ideally, one can see it as a stack of abstract `glyph' objects.       */
/*                                                                       */
/*   loader.base     Is really the bottom of the stack.  It describes a  */
/*                   single glyph image made of the juxtaposition of     */
/*                   several glyphs (those `in the stack').              */
/*                                                                       */
/*   loader.current  Describes the top of the stack, on which a new      */
/*                   glyph can be loaded.                                */
/*                                                                       */
/*   Rewind          Clears the stack.                                   */
/*   Prepare         Set up `loader.current' for addition of a new glyph */
/*                   image.                                              */
/*   Add             Add the `current' glyph image to the `base' one,    */
/*                   and prepare for another one.                        */
/*                                                                       */
/* The glyph loader is now a base object.  Each driver used to           */
/* re-implement it in one way or the other, which wasted code and        */
/* energy.                                                               */
/*                                                                       */
/*************************************************************************/
/* create a new glyph loader */
  FT_BASE_DEF( FT_Error )
  FT_GlyphLoader_New( FT_Memory        memory,
                      FT_GlyphLoader  *aloader )
  {
    FT_GlyphLoader  loader = NULL;
    FT_Error        error;
    if ( !FT_NEW( loader ) )
    {
      loader->memory = memory;
      *aloader       = loader;
    }
    return error;
  }
/* rewind the glyph loader - reset counters to 0 */
  FT_BASE_DEF( void )
  FT_GlyphLoader_Rewind( FT_GlyphLoader  loader )
  {
    FT_GlyphLoad  base    = &loader->base;
    FT_GlyphLoad  current = &loader->current;
    base->outline.n_points   = 0;
    base->outline.n_contours = 0;
    base->num_subglyphs      = 0;
    *current = *base;
  }
/* reset the glyph loader, frees all allocated tables */
/* and starts from zero                               */
  FT_BASE_DEF( void )
  FT_GlyphLoader_Reset( FT_GlyphLoader  loader )
  {
    FT_Memory memory = loader->memory;
    FT_FREE( loader->base.outline.points );
    FT_FREE( loader->base.outline.tags );
    FT_FREE( loader->base.outline.contours );
    FT_FREE( loader->base.extra_points );
    FT_FREE( loader->base.subglyphs );
    loader->base.extra_points2 = NULL;
    loader->max_points    = 0;
    loader->max_contours  = 0;
    loader->max_subglyphs = 0;
    FT_GlyphLoader_Rewind( loader );
  }
/* delete a glyph loader */
  FT_BASE_DEF( void )
  FT_GlyphLoader_Done( FT_GlyphLoader  loader )
  {
    if ( loader )
    {
      FT_Memory memory = loader->memory;
      FT_GlyphLoader_Reset( loader );
      FT_FREE( loader );
    }
  }
/* re-adjust the `current' outline fields */
  static void
  FT_GlyphLoader_Adjust_Points( FT_GlyphLoader  loader )
  {
    FT_Outline*  base    = &loader->base.outline;
    FT_Outline*  current = &loader->current.outline;
    current->points   = base->points   + base->n_points;
    current->tags     = base->tags     + base->n_points;
    current->contours = base->contours + base->n_contours;
/* handle extra points table - if any */
    if ( loader->use_extra )
    {
      loader->current.extra_points  = loader->base.extra_points +
                                      base->n_points;
      loader->current.extra_points2 = loader->base.extra_points2 +
                                      base->n_points;
    }
  }
  FT_BASE_DEF( FT_Error )
  FT_GlyphLoader_CreateExtra( FT_GlyphLoader  loader )
  {
    FT_Error   error;
    FT_Memory  memory = loader->memory;
    if ( !FT_NEW_ARRAY( loader->base.extra_points, 2 * loader->max_points ) )
    {
      loader->use_extra          = 1;
      loader->base.extra_points2 = loader->base.extra_points +
                                   loader->max_points;
      FT_GlyphLoader_Adjust_Points( loader );
    }
    return error;
  }
/* re-adjust the `current' subglyphs field */
  static void
  FT_GlyphLoader_Adjust_Subglyphs( FT_GlyphLoader  loader )
  {
    FT_GlyphLoad  base    = &loader->base;
    FT_GlyphLoad  current = &loader->current;
    current->subglyphs = base->subglyphs + base->num_subglyphs;
  }
/* Ensure that we can add `n_points' and `n_contours' to our glyph.      */
/* This function reallocates its outline tables if necessary.  Note that */
/* it DOESN'T change the number of points within the loader!             */
/*                                                                       */
  FT_BASE_DEF( FT_Error )
  FT_GlyphLoader_CheckPoints( FT_GlyphLoader  loader,
                              FT_UInt         n_points,
                              FT_UInt         n_contours )
  {
    FT_Memory    memory  = loader->memory;
    FT_Error     error   = FT_Err_Ok;
    FT_Outline*  base    = &loader->base.outline;
    FT_Outline*  current = &loader->current.outline;
    FT_Bool      adjust  = 0;
    FT_UInt      new_max, old_max;
/* check points & tags */
    new_max = base->n_points + current->n_points + n_points;
    old_max = loader->max_points;
    if ( new_max > old_max )
    {
      new_max = FT_PAD_CEIL( new_max, 8 );
      if ( new_max > FT_OUTLINE_POINTS_MAX )
        return FT_Err_Array_Too_Large;
      if ( FT_RENEW_ARRAY( base->points, old_max, new_max ) ||
           FT_RENEW_ARRAY( base->tags,   old_max, new_max ) )
        goto Exit;
      if ( loader->use_extra )
      {
        if ( FT_RENEW_ARRAY( loader->base.extra_points,
                             old_max * 2, new_max * 2 ) )
          goto Exit;
        FT_ARRAY_MOVE( loader->base.extra_points + new_max,
                       loader->base.extra_points + old_max,
                       old_max );
        loader->base.extra_points2 = loader->base.extra_points + new_max;
      }
      adjust = 1;
      loader->max_points = new_max;
    }
/* check contours */
    old_max = loader->max_contours;
    new_max = base->n_contours + current->n_contours +
              n_contours;
    if ( new_max > old_max )
    {
      new_max = FT_PAD_CEIL( new_max, 4 );
      if ( new_max > FT_OUTLINE_CONTOURS_MAX )
        return FT_Err_Array_Too_Large;
      if ( FT_RENEW_ARRAY( base->contours, old_max, new_max ) )
        goto Exit;
      adjust = 1;
      loader->max_contours = new_max;
    }
    if ( adjust )
      FT_GlyphLoader_Adjust_Points( loader );
  Exit:
    return error;
  }
/* Ensure that we can add `n_subglyphs' to our glyph. this function */
/* reallocates its subglyphs table if necessary.  Note that it DOES */
/* NOT change the number of subglyphs within the loader!            */
/*                                                                  */
  FT_BASE_DEF( FT_Error )
  FT_GlyphLoader_CheckSubGlyphs( FT_GlyphLoader  loader,
                                 FT_UInt         n_subs )
  {
    FT_Memory     memory = loader->memory;
    FT_Error      error  = FT_Err_Ok;
    FT_UInt       new_max, old_max;
    FT_GlyphLoad  base    = &loader->base;
    FT_GlyphLoad  current = &loader->current;
    new_max = base->num_subglyphs + current->num_subglyphs + n_subs;
    old_max = loader->max_subglyphs;
    if ( new_max > old_max )
    {
      new_max = FT_PAD_CEIL( new_max, 2 );
      if ( FT_RENEW_ARRAY( base->subglyphs, old_max, new_max ) )
        goto Exit;
      loader->max_subglyphs = new_max;
      FT_GlyphLoader_Adjust_Subglyphs( loader );
    }
  Exit:
    return error;
  }
/* prepare loader for the addition of a new glyph on top of the base one */
  FT_BASE_DEF( void )
  FT_GlyphLoader_Prepare( FT_GlyphLoader  loader )
  {
    FT_GlyphLoad  current = &loader->current;
    current->outline.n_points   = 0;
    current->outline.n_contours = 0;
    current->num_subglyphs      = 0;
    FT_GlyphLoader_Adjust_Points   ( loader );
    FT_GlyphLoader_Adjust_Subglyphs( loader );
  }
/* add current glyph to the base image -- and prepare for another */
  FT_BASE_DEF( void )
  FT_GlyphLoader_Add( FT_GlyphLoader  loader )
  {
    FT_GlyphLoad  base;
    FT_GlyphLoad  current;
    FT_UInt       n_curr_contours;
    FT_UInt       n_base_points;
    FT_UInt       n;
    if ( !loader )
      return;
    base    = &loader->base;
    current = &loader->current;
    n_curr_contours = current->outline.n_contours;
    n_base_points   = base->outline.n_points;
    base->outline.n_points =
      (short)( base->outline.n_points + current->outline.n_points );
    base->outline.n_contours =
      (short)( base->outline.n_contours + current->outline.n_contours );
    base->num_subglyphs += current->num_subglyphs;
/* adjust contours count in newest outline */
    for ( n = 0; n < n_curr_contours; n++ )
      current->outline.contours[n] =
        (short)( current->outline.contours[n] + n_base_points );
/* prepare for another new glyph image */
    FT_GlyphLoader_Prepare( loader );
  }
  FT_BASE_DEF( FT_Error )
  FT_GlyphLoader_CopyPoints( FT_GlyphLoader  target,
                             FT_GlyphLoader  source )
  {
    FT_Error  error;
    FT_UInt   num_points   = source->base.outline.n_points;
    FT_UInt   num_contours = source->base.outline.n_contours;
    error = FT_GlyphLoader_CheckPoints( target, num_points, num_contours );
    if ( !error )
    {
      FT_Outline*  out = &target->base.outline;
      FT_Outline*  in  = &source->base.outline;
      FT_ARRAY_COPY( out->points, in->points,
                     num_points );
      FT_ARRAY_COPY( out->tags, in->tags,
                     num_points );
      FT_ARRAY_COPY( out->contours, in->contours,
                     num_contours );
/* do we need to copy the extra points? */
      if ( target->use_extra && source->use_extra )
      {
        FT_ARRAY_COPY( target->base.extra_points, source->base.extra_points,
                       num_points );
        FT_ARRAY_COPY( target->base.extra_points2, source->base.extra_points2,
                       num_points );
      }
      out->n_points   = (short)num_points;
      out->n_contours = (short)num_contours;
      FT_GlyphLoader_Adjust_Points( target );
    }
    return error;
  }
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftobjs.c                                                               */
/*                                                                         */
/*    The FreeType private base classes (body).                            */
/*                                                                         */
/*  Copyright 1996-2012 by                                                 */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*  ftlist.h                                                               */
/*                                                                         */
/*    Generic list support for FreeType (specification).                   */
/*                                                                         */
/*  Copyright 1996-2001, 2003, 2007, 2010 by                               */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/*************************************************************************/
/*                                                                       */
/*  This file implements functions relative to list processing.  Its     */
/*  data structures are defined in `freetype.h'.                         */
/*                                                                       */
/*************************************************************************/
#define __FTLIST_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    list_processing                                                    */
/*                                                                       */
/* <Title>                                                               */
/*    List Processing                                                    */
/*                                                                       */
/* <Abstract>                                                            */
/*    Simple management of lists.                                        */
/*                                                                       */
/* <Description>                                                         */
/*    This section contains various definitions related to list          */
/*    processing using doubly-linked nodes.                              */
/*                                                                       */
/* <Order>                                                               */
/*    FT_List                                                            */
/*    FT_ListNode                                                        */
/*    FT_ListRec                                                         */
/*    FT_ListNodeRec                                                     */
/*                                                                       */
/*    FT_List_Add                                                        */
/*    FT_List_Insert                                                     */
/*    FT_List_Find                                                       */
/*    FT_List_Remove                                                     */
/*    FT_List_Up                                                         */
/*    FT_List_Iterate                                                    */
/*    FT_List_Iterator                                                   */
/*    FT_List_Finalize                                                   */
/*    FT_List_Destructor                                                 */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_List_Find                                                       */
/*                                                                       */
/* <Description>                                                         */
/*    Find the list node for a given listed object.                      */
/*                                                                       */
/* <Input>                                                               */
/*    list :: A pointer to the parent list.                              */
/*    data :: The address of the listed object.                          */
/*                                                                       */
/* <Return>                                                              */
/*    List node.  NULL if it wasn't found.                               */
/*                                                                       */
  FT_EXPORT( FT_ListNode )
  FT_List_Find( FT_List  list,
                void*    data );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_List_Add                                                        */
/*                                                                       */
/* <Description>                                                         */
/*    Append an element to the end of a list.                            */
/*                                                                       */
/* <InOut>                                                               */
/*    list :: A pointer to the parent list.                              */
/*    node :: The node to append.                                        */
/*                                                                       */
  FT_EXPORT( void )
  FT_List_Add( FT_List      list,
               FT_ListNode  node );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_List_Insert                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    Insert an element at the head of a list.                           */
/*                                                                       */
/* <InOut>                                                               */
/*    list :: A pointer to parent list.                                  */
/*    node :: The node to insert.                                        */
/*                                                                       */
  FT_EXPORT( void )
  FT_List_Insert( FT_List      list,
                  FT_ListNode  node );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_List_Remove                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    Remove a node from a list.  This function doesn't check whether    */
/*    the node is in the list!                                           */
/*                                                                       */
/* <Input>                                                               */
/*    node :: The node to remove.                                        */
/*                                                                       */
/* <InOut>                                                               */
/*    list :: A pointer to the parent list.                              */
/*                                                                       */
  FT_EXPORT( void )
  FT_List_Remove( FT_List      list,
                  FT_ListNode  node );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_List_Up                                                         */
/*                                                                       */
/* <Description>                                                         */
/*    Move a node to the head/top of a list.  Used to maintain LRU       */
/*    lists.                                                             */
/*                                                                       */
/* <InOut>                                                               */
/*    list :: A pointer to the parent list.                              */
/*    node :: The node to move.                                          */
/*                                                                       */
  FT_EXPORT( void )
  FT_List_Up( FT_List      list,
              FT_ListNode  node );
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_List_Iterator                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    An FT_List iterator function which is called during a list parse   */
/*    by @FT_List_Iterate.                                               */
/*                                                                       */
/* <Input>                                                               */
/*    node :: The current iteration list node.                           */
/*                                                                       */
/*    user :: A typeless pointer passed to @FT_List_Iterate.             */
/*            Can be used to point to the iteration's state.             */
/*                                                                       */
  typedef FT_Error
  (*FT_List_Iterator)( FT_ListNode  node,
                       void*        user );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_List_Iterate                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Parse a list and calls a given iterator function on each element.  */
/*    Note that parsing is stopped as soon as one of the iterator calls  */
/*    returns a non-zero value.                                          */
/*                                                                       */
/* <Input>                                                               */
/*    list     :: A handle to the list.                                  */
/*    iterator :: An iterator function, called on each node of the list. */
/*    user     :: A user-supplied field which is passed as the second    */
/*                argument to the iterator.                              */
/*                                                                       */
/* <Return>                                                              */
/*    The result (a FreeType error code) of the last iterator call.      */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_List_Iterate( FT_List           list,
                   FT_List_Iterator  iterator,
                   void*             user );
/*************************************************************************/
/*                                                                       */
/* <FuncType>                                                            */
/*    FT_List_Destructor                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    An @FT_List iterator function which is called during a list        */
/*    finalization by @FT_List_Finalize to destroy all elements in a     */
/*    given list.                                                        */
/*                                                                       */
/* <Input>                                                               */
/*    system :: The current system object.                               */
/*                                                                       */
/*    data   :: The current object to destroy.                           */
/*                                                                       */
/*    user   :: A typeless pointer passed to @FT_List_Iterate.  It can   */
/*              be used to point to the iteration's state.               */
/*                                                                       */
  typedef void
  (*FT_List_Destructor)( FT_Memory  memory,
                         void*      data,
                         void*      user );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_List_Finalize                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Destroy all elements in the list as well as the list itself.       */
/*                                                                       */
/* <Input>                                                               */
/*    list    :: A handle to the list.                                   */
/*                                                                       */
/*    destroy :: A list destructor that will be applied to each element  */
/*               of the list.                                            */
/*                                                                       */
/*    memory  :: The current memory object which handles deallocation.   */
/*                                                                       */
/*    user    :: A user-supplied field which is passed as the last       */
/*               argument to the destructor.                             */
/*                                                                       */
/* <Note>                                                                */
/*    This function expects that all nodes added by @FT_List_Add or      */
/*    @FT_List_Insert have been dynamically allocated.                   */
/*                                                                       */
  FT_EXPORT( void )
  FT_List_Finalize( FT_List             list,
                    FT_List_Destructor  destroy,
                    FT_Memory           memory,
                    void*               user );
/* */
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftoutln.h                                                              */
/*                                                                         */
/*    Support for the FT_Outline type used to store glyph shapes of        */
/*    most scalable font formats (specification).                          */
/*                                                                         */
/*  Copyright 1996-2003, 2005-2012 by                                      */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTOUTLN_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    outline_processing                                                 */
/*                                                                       */
/* <Title>                                                               */
/*    Outline Processing                                                 */
/*                                                                       */
/* <Abstract>                                                            */
/*    Functions to create, transform, and render vectorial glyph images. */
/*                                                                       */
/* <Description>                                                         */
/*    This section contains routines used to create and destroy scalable */
/*    glyph images known as `outlines'.  These can also be measured,     */
/*    transformed, and converted into bitmaps and pixmaps.               */
/*                                                                       */
/* <Order>                                                               */
/*    FT_Outline                                                         */
/*    FT_OUTLINE_FLAGS                                                   */
/*    FT_Outline_New                                                     */
/*    FT_Outline_Done                                                    */
/*    FT_Outline_Copy                                                    */
/*    FT_Outline_Translate                                               */
/*    FT_Outline_Transform                                               */
/*    FT_Outline_Embolden                                                */
/*    FT_Outline_EmboldenXY                                              */
/*    FT_Outline_Reverse                                                 */
/*    FT_Outline_Check                                                   */
/*                                                                       */
/*    FT_Outline_Get_CBox                                                */
/*    FT_Outline_Get_BBox                                                */
/*                                                                       */
/*    FT_Outline_Get_Bitmap                                              */
/*    FT_Outline_Render                                                  */
/*                                                                       */
/*    FT_Outline_Decompose                                               */
/*    FT_Outline_Funcs                                                   */
/*    FT_Outline_MoveTo_Func                                             */
/*    FT_Outline_LineTo_Func                                             */
/*    FT_Outline_ConicTo_Func                                            */
/*    FT_Outline_CubicTo_Func                                            */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Decompose                                               */
/*                                                                       */
/* <Description>                                                         */
/*    Walk over an outline's structure to decompose it into individual   */
/*    segments and Bézier arcs.  This function also emits `move to'      */
/*    operations to indicate the start of new contours in the outline.   */
/*                                                                       */
/* <Input>                                                               */
/*    outline        :: A pointer to the source target.                  */
/*                                                                       */
/*    func_interface :: A table of `emitters', i.e., function pointers   */
/*                      called during decomposition to indicate path     */
/*                      operations.                                      */
/*                                                                       */
/* <InOut>                                                               */
/*    user           :: A typeless pointer which is passed to each       */
/*                      emitter during the decomposition.  It can be     */
/*                      used to store the state during the               */
/*                      decomposition.                                   */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_Decompose( FT_Outline*              outline,
                        const FT_Outline_Funcs*  func_interface,
                        void*                    user );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_New                                                     */
/*                                                                       */
/* <Description>                                                         */
/*    Create a new outline of a given size.                              */
/*                                                                       */
/* <Input>                                                               */
/*    library     :: A handle to the library object from where the       */
/*                   outline is allocated.  Note however that the new    */
/*                   outline will *not* necessarily be *freed*, when     */
/*                   destroying the library, by @FT_Done_FreeType.       */
/*                                                                       */
/*    numPoints   :: The maximum number of points within the outline.    */
/*                                                                       */
/*    numContours :: The maximum number of contours within the outline.  */
/*                                                                       */
/* <Output>                                                              */
/*    anoutline   :: A handle to the new outline.                        */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    The reason why this function takes a `library' parameter is simply */
/*    to use the library's memory allocator.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_New( FT_Library   library,
                  FT_UInt      numPoints,
                  FT_Int       numContours,
                  FT_Outline  *anoutline );
  FT_EXPORT( FT_Error )
  FT_Outline_New_Internal( FT_Memory    memory,
                           FT_UInt      numPoints,
                           FT_Int       numContours,
                           FT_Outline  *anoutline );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Done                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Destroy an outline created with @FT_Outline_New.                   */
/*                                                                       */
/* <Input>                                                               */
/*    library :: A handle of the library object used to allocate the     */
/*               outline.                                                */
/*                                                                       */
/*    outline :: A pointer to the outline object to be discarded.        */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    If the outline's `owner' field is not set, only the outline        */
/*    descriptor will be released.                                       */
/*                                                                       */
/*    The reason why this function takes an `library' parameter is       */
/*    simply to use ft_mem_free().                                       */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_Done( FT_Library   library,
                   FT_Outline*  outline );
  FT_EXPORT( FT_Error )
  FT_Outline_Done_Internal( FT_Memory    memory,
                            FT_Outline*  outline );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Check                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Check the contents of an outline descriptor.                       */
/*                                                                       */
/* <Input>                                                               */
/*    outline :: A handle to a source outline.                           */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_Check( FT_Outline*  outline );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Get_CBox                                                */
/*                                                                       */
/* <Description>                                                         */
/*    Return an outline's `control box'.  The control box encloses all   */
/*    the outline's points, including Bézier control points.  Though it  */
/*    coincides with the exact bounding box for most glyphs, it can be   */
/*    slightly larger in some situations (like when rotating an outline  */
/*    which contains Bézier outside arcs).                               */
/*                                                                       */
/*    Computing the control box is very fast, while getting the bounding */
/*    box can take much more time as it needs to walk over all segments  */
/*    and arcs in the outline.  To get the latter, you can use the       */
/*    `ftbbox' component which is dedicated to this single task.         */
/*                                                                       */
/* <Input>                                                               */
/*    outline :: A pointer to the source outline descriptor.             */
/*                                                                       */
/* <Output>                                                              */
/*    acbox   :: The outline's control box.                              */
/*                                                                       */
/* <Note>                                                                */
/*    See @FT_Glyph_Get_CBox for a discussion of tricky fonts.           */
/*                                                                       */
  FT_EXPORT( void )
  FT_Outline_Get_CBox( const FT_Outline*  outline,
                       FT_BBox           *acbox );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Translate                                               */
/*                                                                       */
/* <Description>                                                         */
/*    Apply a simple translation to the points of an outline.            */
/*                                                                       */
/* <InOut>                                                               */
/*    outline :: A pointer to the target outline descriptor.             */
/*                                                                       */
/* <Input>                                                               */
/*    xOffset :: The horizontal offset.                                  */
/*                                                                       */
/*    yOffset :: The vertical offset.                                    */
/*                                                                       */
  FT_EXPORT( void )
  FT_Outline_Translate( const FT_Outline*  outline,
                        FT_Pos             xOffset,
                        FT_Pos             yOffset );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Copy                                                    */
/*                                                                       */
/* <Description>                                                         */
/*    Copy an outline into another one.  Both objects must have the      */
/*    same sizes (number of points & number of contours) when this       */
/*    function is called.                                                */
/*                                                                       */
/* <Input>                                                               */
/*    source :: A handle to the source outline.                          */
/*                                                                       */
/* <Output>                                                              */
/*    target :: A handle to the target outline.                          */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_Copy( const FT_Outline*  source,
                   FT_Outline        *target );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Transform                                               */
/*                                                                       */
/* <Description>                                                         */
/*    Apply a simple 2x2 matrix to all of an outline's points.  Useful   */
/*    for applying rotations, slanting, flipping, etc.                   */
/*                                                                       */
/* <InOut>                                                               */
/*    outline :: A pointer to the target outline descriptor.             */
/*                                                                       */
/* <Input>                                                               */
/*    matrix  :: A pointer to the transformation matrix.                 */
/*                                                                       */
/* <Note>                                                                */
/*    You can use @FT_Outline_Translate if you need to translate the     */
/*    outline's points.                                                  */
/*                                                                       */
  FT_EXPORT( void )
  FT_Outline_Transform( const FT_Outline*  outline,
                        const FT_Matrix*   matrix );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Embolden                                                */
/*                                                                       */
/* <Description>                                                         */
/*    Embolden an outline.  The new outline will be at most 4~times      */
/*    `strength' pixels wider and higher.  You may think of the left and */
/*    bottom borders as unchanged.                                       */
/*                                                                       */
/*    Negative `strength' values to reduce the outline thickness are     */
/*    possible also.                                                     */
/*                                                                       */
/* <InOut>                                                               */
/*    outline  :: A handle to the target outline.                        */
/*                                                                       */
/* <Input>                                                               */
/*    strength :: How strong the glyph is emboldened.  Expressed in      */
/*                26.6 pixel format.                                     */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    The used algorithm to increase or decrease the thickness of the    */
/*    glyph doesn't change the number of points; this means that certain */
/*    situations like acute angles or intersections are sometimes        */
/*    handled incorrectly.                                               */
/*                                                                       */
/*    If you need `better' metrics values you should call                */
/*    @FT_Outline_Get_CBox or @FT_Outline_Get_BBox.                      */
/*                                                                       */
/*    Example call:                                                      */
/*                                                                       */
/*    {                                                                  */
/*      FT_Load_Glyph( face, index, FT_LOAD_DEFAULT );                   */
/*      if ( face->slot->format == FT_GLYPH_FORMAT_OUTLINE )             */
/*        FT_Outline_Embolden( &face->slot->outline, strength );         */
/*    }                                                                  */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_Embolden( FT_Outline*  outline,
                       FT_Pos       strength );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_EmboldenXY                                              */
/*                                                                       */
/* <Description>                                                         */
/*    Embolden an outline.  The new outline will be `xstrength' pixels   */
/*    wider and `ystrength' pixels higher.  Otherwise, it is similar to  */
/*    @FT_Outline_Embolden, which uses the same strength in both         */
/*    directions.                                                        */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_EmboldenXY( FT_Outline*  outline,
                         FT_Pos       xstrength,
                         FT_Pos       ystrength );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Reverse                                                 */
/*                                                                       */
/* <Description>                                                         */
/*    Reverse the drawing direction of an outline.  This is used to      */
/*    ensure consistent fill conventions for mirrored glyphs.            */
/*                                                                       */
/* <InOut>                                                               */
/*    outline :: A pointer to the target outline descriptor.             */
/*                                                                       */
/* <Note>                                                                */
/*    This function toggles the bit flag @FT_OUTLINE_REVERSE_FILL in     */
/*    the outline's `flags' field.                                       */
/*                                                                       */
/*    It shouldn't be used by a normal client application, unless it     */
/*    knows what it is doing.                                            */
/*                                                                       */
  FT_EXPORT( void )
  FT_Outline_Reverse( FT_Outline*  outline );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Get_Bitmap                                              */
/*                                                                       */
/* <Description>                                                         */
/*    Render an outline within a bitmap.  The outline's image is simply  */
/*    OR-ed to the target bitmap.                                        */
/*                                                                       */
/* <Input>                                                               */
/*    library :: A handle to a FreeType library object.                  */
/*                                                                       */
/*    outline :: A pointer to the source outline descriptor.             */
/*                                                                       */
/* <InOut>                                                               */
/*    abitmap :: A pointer to the target bitmap descriptor.              */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    This function does NOT CREATE the bitmap, it only renders an       */
/*    outline image within the one you pass to it!  Consequently, the    */
/*    various fields in `abitmap' should be set accordingly.             */
/*                                                                       */
/*    It will use the raster corresponding to the default glyph format.  */
/*                                                                       */
/*    The value of the `num_grays' field in `abitmap' is ignored.  If    */
/*    you select the gray-level rasterizer, and you want less than 256   */
/*    gray levels, you have to use @FT_Outline_Render directly.          */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_Get_Bitmap( FT_Library        library,
                         FT_Outline*       outline,
                         const FT_Bitmap  *abitmap );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Outline_Render                                                  */
/*                                                                       */
/* <Description>                                                         */
/*    Render an outline within a bitmap using the current scan-convert.  */
/*    This function uses an @FT_Raster_Params structure as an argument,  */
/*    allowing advanced features like direct composition, translucency,  */
/*    etc.                                                               */
/*                                                                       */
/* <Input>                                                               */
/*    library :: A handle to a FreeType library object.                  */
/*                                                                       */
/*    outline :: A pointer to the source outline descriptor.             */
/*                                                                       */
/* <InOut>                                                               */
/*    params  :: A pointer to an @FT_Raster_Params structure used to     */
/*               describe the rendering operation.                       */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  0~means success.                             */
/*                                                                       */
/* <Note>                                                                */
/*    You should know what you are doing and how @FT_Raster_Params works */
/*    to use this function.                                              */
/*                                                                       */
/*    The field `params.source' will be set to `outline' before the scan */
/*    converter is called, which means that the value you give to it is  */
/*    actually ignored.                                                  */
/*                                                                       */
/*    The gray-level rasterizer always uses 256 gray levels.  If you     */
/*    want less gray levels, you have to provide your own span callback. */
/*    See the @FT_RASTER_FLAG_DIRECT value of the `flags' field in the   */
/*    @FT_Raster_Params structure for more details.                      */
/*                                                                       */
  FT_EXPORT( FT_Error )
  FT_Outline_Render( FT_Library         library,
                     FT_Outline*        outline,
                     FT_Raster_Params*  params );
/**************************************************************************
  *
  * @enum:
  *   FT_Orientation
  *
  * @description:
  *   A list of values used to describe an outline's contour orientation.
  *
  *   The TrueType and PostScript specifications use different conventions
  *   to determine whether outline contours should be filled or unfilled.
  *
  * @values:
  *   FT_ORIENTATION_TRUETYPE ::
  *     According to the TrueType specification, clockwise contours must
  *     be filled, and counter-clockwise ones must be unfilled.
  *
  *   FT_ORIENTATION_POSTSCRIPT ::
  *     According to the PostScript specification, counter-clockwise contours
  *     must be filled, and clockwise ones must be unfilled.
  *
  *   FT_ORIENTATION_FILL_RIGHT ::
  *     This is identical to @FT_ORIENTATION_TRUETYPE, but is used to
  *     remember that in TrueType, everything that is to the right of
  *     the drawing direction of a contour must be filled.
  *
  *   FT_ORIENTATION_FILL_LEFT ::
  *     This is identical to @FT_ORIENTATION_POSTSCRIPT, but is used to
  *     remember that in PostScript, everything that is to the left of
  *     the drawing direction of a contour must be filled.
  *
  *   FT_ORIENTATION_NONE ::
  *     The orientation cannot be determined.  That is, different parts of
  *     the glyph have different orientation.
  *
  */
  typedef enum  FT_Orientation_
  {
    FT_ORIENTATION_TRUETYPE   = 0,
    FT_ORIENTATION_POSTSCRIPT = 1,
    FT_ORIENTATION_FILL_RIGHT = FT_ORIENTATION_TRUETYPE,
    FT_ORIENTATION_FILL_LEFT  = FT_ORIENTATION_POSTSCRIPT,
    FT_ORIENTATION_NONE
  } FT_Orientation;
/**************************************************************************
  *
  * @function:
  *   FT_Outline_Get_Orientation
  *
  * @description:
  *   This function analyzes a glyph outline and tries to compute its
  *   fill orientation (see @FT_Orientation).  This is done by computing
  *   the direction of each global horizontal and/or vertical extrema
  *   within the outline.
  *
  *   Note that this will return @FT_ORIENTATION_TRUETYPE for empty
  *   outlines.
  *
  * @input:
  *   outline ::
  *     A handle to the source outline.
  *
  * @return:
  *   The orientation.
  *
  */
  FT_EXPORT( FT_Orientation )
  FT_Outline_Get_Orientation( FT_Outline*  outline );
/* */
FT_END_HEADER
/* END */
/* Local Variables: */
/* coding: utf-8    */
/* End:             */
/***************************************************************************/
/*                                                                         */
/*  ftvalid.h                                                              */
/*                                                                         */
/*    FreeType validation support (specification).                         */
/*                                                                         */
/*  Copyright 2004 by                                                      */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __FTVALID_H__
/* for ft_setjmp and ft_longjmp */
FT_BEGIN_HEADER
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/****                                                                 ****/
/****                                                                 ****/
/****                    V A L I D A T I O N                          ****/
/****                                                                 ****/
/****                                                                 ****/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* handle to a validation object */
  typedef struct FT_ValidatorRec_ volatile*  FT_Validator;
/*************************************************************************/
/*                                                                       */
/* There are three distinct validation levels defined here:              */
/*                                                                       */
/* FT_VALIDATE_DEFAULT ::                                                */
/*   A table that passes this validation level can be used reliably by   */
/*   FreeType.  It generally means that all offsets have been checked to */
/*   prevent out-of-bound reads, that array counts are correct, etc.     */
/*                                                                       */
/* FT_VALIDATE_TIGHT ::                                                  */
/*   A table that passes this validation level can be used reliably and  */
/*   doesn't contain invalid data.  For example, a charmap table that    */
/*   returns invalid glyph indices will not pass, even though it can     */
/*   be used with FreeType in default mode (the library will simply      */
/*   return an error later when trying to load the glyph).               */
/*                                                                       */
/*   It also checks that fields which must be a multiple of 2, 4, or 8,  */
/*   don't have incorrect values, etc.                                   */
/*                                                                       */
/* FT_VALIDATE_PARANOID ::                                               */
/*   Only for font debugging.  Checks that a table follows the           */
/*   specification by 100%.  Very few fonts will be able to pass this    */
/*   level anyway but it can be useful for certain tools like font       */
/*   editors/converters.                                                 */
/*                                                                       */
  typedef enum  FT_ValidationLevel_
  {
    FT_VALIDATE_DEFAULT = 0,
    FT_VALIDATE_TIGHT,
    FT_VALIDATE_PARANOID
  } FT_ValidationLevel;
/* validator structure */
  typedef struct  FT_ValidatorRec_
  {
/* address of table in memory       */
    const FT_Byte*      base;         
/* `base' + sizeof(table) in memory */
    const FT_Byte*      limit;        
/* validation level                 */
    FT_ValidationLevel  level;        
/* error returned. 0 means success  */
    FT_Error            error;        
/* used for exception handling      */
    ft_jmp_buf          jump_buffer;  
  } FT_ValidatorRec;
#define FT_VALIDATOR( x )  ((FT_Validator)( x ))
  FT_BASE( void )
  ft_validator_init( FT_Validator        valid,
                     const FT_Byte*      base,
                     const FT_Byte*      limit,
                     FT_ValidationLevel  level );
/* Do not use this. It's broken and will cause your validator to crash */
/* if you run it on an invalid font.                                   */
  FT_BASE( FT_Int )
  ft_validator_run( FT_Validator  valid );
/* Sets the error field in a validator, then calls `longjmp' to return */
/* to high-level caller.  Using `setjmp/longjmp' avoids many stupid    */
/* error checks within the validation routines.                        */
/*                                                                     */
  FT_BASE( void )
  ft_validator_error( FT_Validator  valid,
                      FT_Error      error );
/* Calls ft_validate_error.  Assumes that the `valid' local variable */
/* holds a pointer to the current validator object.                  */
/*                                                                   */
/* Use preprocessor prescan to pass FT_ERR_PREFIX.                   */
/*                                                                   */
#define FT_INVALID( _prefix, _error )  FT_INVALID_( _prefix, _error )
#define FT_INVALID_( _prefix, _error ) \
          ft_validator_error( valid, _prefix ## _error )
/* called when a broken table is detected */
#define FT_INVALID_TOO_SHORT \
          FT_INVALID( FT_ERR_PREFIX, Invalid_Table )
/* called when an invalid offset is detected */
#define FT_INVALID_OFFSET \
          FT_INVALID( FT_ERR_PREFIX, Invalid_Offset )
/* called when an invalid format/value is detected */
#define FT_INVALID_FORMAT \
          FT_INVALID( FT_ERR_PREFIX, Invalid_Table )
/* called when an invalid glyph index is detected */
#define FT_INVALID_GLYPH_ID \
          FT_INVALID( FT_ERR_PREFIX, Invalid_Glyph_Index )
/* called when an invalid field value is detected */
#define FT_INVALID_DATA \
          FT_INVALID( FT_ERR_PREFIX, Invalid_Table )
FT_END_HEADER
/* END */
/***************************************************************************/
/*                                                                         */
/*  ftrfork.h                                                              */
/*                                                                         */
/*    Embedded resource forks accessor (specification).                    */
/*                                                                         */
/*  Copyright 2004, 2006, 2007, 2012 by                                    */
/*  Masatake YAMATO and Redhat K.K.                                        */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
/* Development of the code in this file is support of                      */
/* Information-technology Promotion Agency, Japan.                         */
/***************************************************************************/
#define __FTRFORK_H__
FT_BEGIN_HEADER
/* Number of guessing rules supported in `FT_Raccess_Guess'.            */
/* Don't forget to increment the number if you add a new guessing rule. */
#define FT_RACCESS_N_RULES  9
/* A structure to describe a reference in a resource by its resource ID */
/* and internal offset.  The `POST' resource expects to be concatenated */
/* by the order of resource IDs instead of its appearance in the file.  */
  typedef struct  FT_RFork_Ref_
  {
    FT_UShort  res_id;
    FT_ULong   offset;
  } FT_RFork_Ref;
  typedef FT_Error
  (*ft_raccess_guess_func)( FT_Library  library,
                            FT_Stream   stream,
                            char       *base_file_name,
                            char      **result_file_name,
                            FT_Long    *result_offset );
  typedef enum  FT_RFork_Rule_ {
    FT_RFork_Rule_invalid = -2,
/* -1 */
    FT_RFork_Rule_uknown,  
    FT_RFork_Rule_apple_double,
    FT_RFork_Rule_apple_single,
    FT_RFork_Rule_darwin_ufs_export,
    FT_RFork_Rule_darwin_newvfs,
    FT_RFork_Rule_darwin_hfsplus,
    FT_RFork_Rule_vfat,
    FT_RFork_Rule_linux_cap,
    FT_RFork_Rule_linux_double,
    FT_RFork_Rule_linux_netatalk
  } FT_RFork_Rule;
/* For fast translation between rule index and rule type,
   * the macros FT_RFORK_xxx should be kept consistent with
   * the raccess_guess_funcs table
   */
  typedef struct ft_raccess_guess_rec_ {
    ft_raccess_guess_func  func;
    FT_RFork_Rule          type;
  } ft_raccess_guess_rec;
/* this array is a storage in non-PIC mode, so ; is needed in END */
#define CONST_FT_RFORK_RULE_ARRAY_BEGIN( name, type )  \
          const type name[] = {
#define CONST_FT_RFORK_RULE_ARRAY_ENTRY( func_suffix, type_suffix )  \
          { raccess_guess_ ## func_suffix,                           \
            FT_RFork_Rule_ ## type_suffix },
#define CONST_FT_RFORK_RULE_ARRAY_END  };
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Raccess_Guess                                                   */
/*                                                                       */
/* <Description>                                                         */
/*    Guess a file name and offset where the actual resource fork is     */
/*    stored.  The macro FT_RACCESS_N_RULES holds the number of          */
/*    guessing rules;  the guessed result for the Nth rule is            */
/*    represented as a triplet: a new file name (new_names[N]), a file   */
/*    offset (offsets[N]), and an error code (errors[N]).                */
/*                                                                       */
/* <Input>                                                               */
/*    library ::                                                         */
/*      A FreeType library instance.                                     */
/*                                                                       */
/*    stream ::                                                          */
/*      A file stream containing the resource fork.                      */
/*                                                                       */
/*    base_name ::                                                       */
/*      The (base) file name of the resource fork used for some          */
/*      guessing rules.                                                  */
/*                                                                       */
/* <Output>                                                              */
/*    new_names ::                                                       */
/*      An array of guessed file names in which the resource forks may   */
/*      exist.  If `new_names[N]' is NULL, the guessed file name is      */
/*      equal to `base_name'.                                            */
/*                                                                       */
/*    offsets ::                                                         */
/*      An array of guessed file offsets.  `offsets[N]' holds the file   */
/*      offset of the possible start of the resource fork in file        */
/*      `new_names[N]'.                                                  */
/*                                                                       */
/*    errors ::                                                          */
/*      An array of FreeType error codes.  `errors[N]' is the error      */
/*      code of Nth guessing rule function.  If `errors[N]' is not       */
/*      FT_Err_Ok, `new_names[N]' and `offsets[N]' are meaningless.      */
/*                                                                       */
  FT_BASE( void )
  FT_Raccess_Guess( FT_Library  library,
                    FT_Stream   stream,
                    char*       base_name,
                    char**      new_names,
                    FT_Long*    offsets,
                    FT_Error*   errors );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Raccess_Get_HeaderInfo                                          */
/*                                                                       */
/* <Description>                                                         */
/*    Get the information from the header of resource fork.  The         */
/*    information includes the file offset where the resource map        */
/*    starts, and the file offset where the resource data starts.        */
/*    `FT_Raccess_Get_DataOffsets' requires these two data.              */
/*                                                                       */
/* <Input>                                                               */
/*    library ::                                                         */
/*      A FreeType library instance.                                     */
/*                                                                       */
/*    stream ::                                                          */
/*      A file stream containing the resource fork.                      */
/*                                                                       */
/*    rfork_offset ::                                                    */
/*      The file offset where the resource fork starts.                  */
/*                                                                       */
/* <Output>                                                              */
/*    map_offset ::                                                      */
/*      The file offset where the resource map starts.                   */
/*                                                                       */
/*    rdata_pos ::                                                       */
/*      The file offset where the resource data starts.                  */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  FT_Err_Ok means success.                     */
/*                                                                       */
  FT_BASE( FT_Error )
  FT_Raccess_Get_HeaderInfo( FT_Library  library,
                             FT_Stream   stream,
                             FT_Long     rfork_offset,
                             FT_Long    *map_offset,
                             FT_Long    *rdata_pos );
/*************************************************************************/
/*                                                                       */
/* <Function>                                                            */
/*    FT_Raccess_Get_DataOffsets                                         */
/*                                                                       */
/* <Description>                                                         */
/*    Get the data offsets for a tag in a resource fork.  Offsets are    */
/*    stored in an array because, in some cases, resources in a resource */
/*    fork have the same tag.                                            */
/*                                                                       */
/* <Input>                                                               */
/*    library ::                                                         */
/*      A FreeType library instance.                                     */
/*                                                                       */
/*    stream ::                                                          */
/*      A file stream containing the resource fork.                      */
/*                                                                       */
/*    map_offset ::                                                      */
/*      The file offset where the resource map starts.                   */
/*                                                                       */
/*    rdata_pos ::                                                       */
/*      The file offset where the resource data starts.                  */
/*                                                                       */
/*    tag ::                                                             */
/*      The resource tag.                                                */
/*                                                                       */
/* <Output>                                                              */
/*    offsets ::                                                         */
/*      The stream offsets for the resource data specified by `tag'.     */
/*      This array is allocated by the function, so you have to call     */
/*      @ft_mem_free after use.                                          */
/*                                                                       */
/*    count ::                                                           */
/*      The length of offsets array.                                     */
/*                                                                       */
/* <Return>                                                              */
/*    FreeType error code.  FT_Err_Ok means success.                     */
/*                                                                       */
/* <Note>                                                                */
/*    Normally you should use `FT_Raccess_Get_HeaderInfo' to get the     */
/*    value for `map_offset' and `rdata_pos'.                            */
/*                                                                       */
  FT_BASE( FT_Error )
  FT_Raccess_Get_DataOffsets( FT_Library  library,
                              FT_Stream   stream,
                              FT_Long     map_offset,
                              FT_Long     rdata_pos,
                              FT_Long     tag,
                              FT_Long   **offsets,
                              FT_Long    *count );
FT_END_HEADER
/* END */
/* for SFNT_Load_Table_Func */
/***************************************************************************/
/*                                                                         */
/*  sfnt.h                                                                 */
/*                                                                         */
/*    High-level `sfnt' driver interface (specification).                  */
/*                                                                         */
/*  Copyright 1996-2006, 2009, 2012 by                                     */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __SFNT_H__
/***************************************************************************/
/*                                                                         */
/*  tttypes.h                                                              */
/*                                                                         */
/*    Basic SFNT/TrueType type definitions and interface (specification    */
/*    only).                                                               */
/*                                                                         */
/*  Copyright 1996-2002, 2004-2008, 2012 by                                */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __TTTYPES_H__
/***************************************************************************/
/*                                                                         */
/*  tttables.h                                                             */
/*                                                                         */
/*    Basic SFNT/TrueType tables definitions and interface                 */
/*    (specification only).                                                */
/*                                                                         */
/*  Copyright 1996-2005, 2008-2012 by                                      */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/
#define __TTTABLES_H__
#ifdef FREETYPE_H
#error "freetype.h of FreeType 1 has been loaded!"
#error "Please fix the directory search order for header files"
#error "so that freetype.h of FreeType 2 is found first."
#endif
FT_BEGIN_HEADER
/*************************************************************************/
/*                                                                       */
/* <Section>                                                             */
/*    truetype_tables                                                    */
/*                                                                       */
/* <Title>                                                               */
/*    TrueType Tables                                                    */
/*                                                                       */
/* <Abstract>                                                            */
/*    TrueType specific table types and functions.                       */
/*                                                                       */
/* <Description>                                                         */
/*    This section contains the definition of TrueType-specific tables   */
/*    as well as some routines used to access and process them.          */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    TT_Header                                                          */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to model a TrueType font header table.  All       */
/*    fields follow the TrueType specification.                          */
/*                                                                       */
  typedef struct  TT_Header_
  {
    FT_Fixed   Table_Version;
    FT_Fixed   Font_Revision;
    FT_Long    CheckSum_Adjust;
    FT_Long    Magic_Number;
    FT_UShort  Flags;
    FT_UShort  Units_Per_EM;
    FT_Long    Created [2];
    FT_Long    Modified[2];
    FT_Short   xMin;
    FT_Short   yMin;
    FT_Short   xMax;
    FT_Short   yMax;
    FT_UShort  Mac_Style;
    FT_UShort  Lowest_Rec_PPEM;
    FT_Short   Font_Direction;
    FT_Short   Index_To_Loc_Format;
    FT_Short   Glyph_Data_Format;
  } TT_Header;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    TT_HoriHeader                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to model a TrueType horizontal header, the `hhea' */
/*    table, as well as the corresponding horizontal metrics table,      */
/*    i.e., the `hmtx' table.                                            */
/*                                                                       */
/* <Fields>                                                              */
/*    Version                :: The table version.                       */
/*                                                                       */
/*    Ascender               :: The font's ascender, i.e., the distance  */
/*                              from the baseline to the top-most of all */
/*                              glyph points found in the font.          */
/*                                                                       */
/*                              This value is invalid in many fonts, as  */
/*                              it is usually set by the font designer,  */
/*                              and often reflects only a portion of the */
/*                              glyphs found in the font (maybe ASCII).  */
/*                                                                       */
/*                              You should use the `sTypoAscender' field */
/*                              of the OS/2 table instead if you want    */
/*                              the correct one.                         */
/*                                                                       */
/*    Descender              :: The font's descender, i.e., the distance */
/*                              from the baseline to the bottom-most of  */
/*                              all glyph points found in the font.  It  */
/*                              is negative.                             */
/*                                                                       */
/*                              This value is invalid in many fonts, as  */
/*                              it is usually set by the font designer,  */
/*                              and often reflects only a portion of the */
/*                              glyphs found in the font (maybe ASCII).  */
/*                                                                       */
/*                              You should use the `sTypoDescender'      */
/*                              field of the OS/2 table instead if you   */
/*                              want the correct one.                    */
/*                                                                       */
/*    Line_Gap               :: The font's line gap, i.e., the distance  */
/*                              to add to the ascender and descender to  */
/*                              get the BTB, i.e., the                   */
/*                              baseline-to-baseline distance for the    */
/*                              font.                                    */
/*                                                                       */
/*    advance_Width_Max      :: This field is the maximum of all advance */
/*                              widths found in the font.  It can be     */
/*                              used to compute the maximum width of an  */
/*                              arbitrary string of text.                */
/*                                                                       */
/*    min_Left_Side_Bearing  :: The minimum left side bearing of all     */
/*                              glyphs within the font.                  */
/*                                                                       */
/*    min_Right_Side_Bearing :: The minimum right side bearing of all    */
/*                              glyphs within the font.                  */
/*                                                                       */
/*    xMax_Extent            :: The maximum horizontal extent (i.e., the */
/*                              `width' of a glyph's bounding box) for   */
/*                              all glyphs in the font.                  */
/*                                                                       */
/*    caret_Slope_Rise       :: The rise coefficient of the cursor's     */
/*                              slope of the cursor (slope=rise/run).    */
/*                                                                       */
/*    caret_Slope_Run        :: The run coefficient of the cursor's      */
/*                              slope.                                   */
/*                                                                       */
/*    Reserved               :: 8~reserved bytes.                        */
/*                                                                       */
/*    metric_Data_Format     :: Always~0.                                */
/*                                                                       */
/*    number_Of_HMetrics     :: Number of HMetrics entries in the `hmtx' */
/*                              table -- this value can be smaller than  */
/*                              the total number of glyphs in the font.  */
/*                                                                       */
/*    long_metrics           :: A pointer into the `hmtx' table.         */
/*                                                                       */
/*    short_metrics          :: A pointer into the `hmtx' table.         */
/*                                                                       */
/* <Note>                                                                */
/*    IMPORTANT: The TT_HoriHeader and TT_VertHeader structures should   */
/*               be identical except for the names of their fields which */
/*               are different.                                          */
/*                                                                       */
/*               This ensures that a single function in the `ttload'     */
/*               module is able to read both the horizontal and vertical */
/*               headers.                                                */
/*                                                                       */
  typedef struct  TT_HoriHeader_
  {
    FT_Fixed   Version;
    FT_Short   Ascender;
    FT_Short   Descender;
    FT_Short   Line_Gap;
/* advance width maximum */
    FT_UShort  advance_Width_Max;       
/* minimum left-sb       */
    FT_Short   min_Left_Side_Bearing;   
/* minimum right-sb      */
    FT_Short   min_Right_Side_Bearing;  
/* xmax extents          */
    FT_Short   xMax_Extent;             
    FT_Short   caret_Slope_Rise;
    FT_Short   caret_Slope_Run;
    FT_Short   caret_Offset;
    FT_Short   Reserved[4];
    FT_Short   metric_Data_Format;
    FT_UShort  number_Of_HMetrics;
/* The following fields are not defined by the TrueType specification */
/* but they are used to connect the metrics header to the relevant    */
/* `HMTX' table.                                                      */
    void*      long_metrics;
    void*      short_metrics;
  } TT_HoriHeader;
/*************************************************************************/
/*                                                                       */
/* <Struct>                                                              */
/*    TT_VertHeader                                                      */
/*                                                                       */
/* <Description>                                                         */
/*    A structure used to model a TrueType vertical header, the `vhea'   */
/*    table, as well as the corresponding vertical metrics table, i.e.,  */
/*    the `vmtx' table.                                                  */
/*                                                                       */
/* <Fields>                                                              */
/*    Version                 :: The table version.                      */
/*                                                                       */
/*    Ascender                :: The font's ascender, i.e., the distance */
/*                               from the baseline to the top-most of    */
/*                               all glyph points found in the font.     */
/*                                                                       */
/*                               This value is invalid in many fonts, as */
/*                               it is usually set by the font designer, */
/*                               and often reflects only a portion of    */
/*                               the glyphs found in the font (maybe     */
/*                               ASCII).                                 */
/*                                                                       */
/*                               You should use the `sTypoAscender'      */
/*                               field of the OS/2 table instead if you  */
/*                               want the correct one.                   */
/*                                                                       */
/*    Descender               :: The font's descender, i.e., the         */
/*                               distance from the baseline to the       */
/*                               bottom-most of all glyph points found   */
/*                               in the font.  It is negative.           */
/*                                                                       */
/*                               This value is invalid in many fonts, as */
/*                               it is usually set by the font designer, */
/*                               and often reflects only a portion of    */
/*                               the glyphs found in the font (maybe     */
/*                               ASCII).                                 */
/*                                                                       */
/*                               You should use the `sTypoDescender'     */
/*                               field of the OS/2 table instead if you  */
/*                               want the correct one.                   */
/*                                                                       */
/*    Line_Gap                :: The font's line gap, i.e., the distance */
/*                               to add to the ascender and descender to */
/*                               get the BTB, i.e., the                  */
/*                               baseline-to-baseline distance for the   */
/*                               font.                                   */
/*                                                                       */
/*    advance_Height_Max      :: This field is the maximum of all        */
/*                               advance heights found in the font.  It  */
/*                               can be used to compute the maximum      */
/*                               height of an arbitrary string of text.  */
/*                                                                       */
/*    min_Top_Side_Bearing    :: The minimum top side bearing of all     */
/*                               glyphs within the font.                 */
/*                                                                       */
/*    min_Bottom_Side_Bearing :: The minimum bottom side bearing of all  */
/*                               glyphs within the font.                 */
/*                                                                       */
/*    yMax_Extent             :: The maximum vertical extent (i.e., the  */
/*                               `height' of a glyph's bounding box) for */
/*                               all glyphs in the font.                 */
/*                                                                       */
/*    caret_Slope_Rise        :: The rise coefficient of the cursor's    */
/*                               slope of the cursor (slope=rise/run).   */
/*                                                                       */
/*    caret_Slope_Run         :: The run coefficient of the cursor's     */
/*                               slope.                                  */
/*                                                                       */
/*    caret_Offset            :: The cursor's offset for slanted fonts.  */
/*                               This value is `reserved' in vmtx        */
/*                               version 1.0.                            */
/*                                                                       */
/*    Reserved                :: 8~reserved bytes.                       */
/*                                                                       */
/*    metric_Data_Format      :: Always~0.                               */
/*                                                                       */
/*    number_Of_HMetrics      :: Number of VMetrics entries in the       */
/*                               `vmtx' table -- this value can be       */
/*                               smaller than the total number of glyphs */
/*                               in the font.                            */
/*                                                                       */
/*    long_metrics           :: A pointer into the `vmtx' table.         */
/*                                                                       */
/*    short_metrics          :: A pointer into the `vmtx' table.         */
/*                                                                       */
/* <Note>                                                                */
/*    IMPORTANT: The TT_HoriHeader and TT_VertHeader structures should   */
/*               be identical except for the names of their fields which */
/*               are different.                                          */
/*                                                                       */
/*               This ensures that a single function in the `ttload'     */
/*               module is able to read both the horizontal and vertical */
/*               headers.                                                */
/*                                                                       */
  typedef struct  TT_VertHeader_
  {
    FT_Fixed   Version;
    FT_Short   Ascender;
    FT_Short   Descender;
    FT_Short   Line_Gap;
/* advance height maximum */
    FT_UShort  advance_Height_Max;       
/* minimum left-sb or top-sb       */
    FT_Short   min_Top_Side_Bearing;     
/* minimum right-sb or bottom-sb   */
    FT_Short   min_Bottom_Side_Bearing;  
/* xmax or ymax extents            */
    FT_Short   yMax_Extent;              
    FT_Short   caret_Slope_Rise;
    FT_Short   caret_Slope_Run;
    FT_Short   caret_Offset;
    FT_Short   Reserved[4];
    FT_Short   metric_Data_Format;
    FT_UShort  number_Of_VMetrics;
/* The following fields are not defined by the TrueType specification */
/* but they're used to connect the metrics header to the relevant     */
/* 