/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_ASSOCIATEDPROCESSORCORECACHEMEMORY_H_
#define OPENDRIM_ASSOCIATEDPROCESSORCORECACHEMEMORY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_Memory.h"
#include "CIM_MemoryAccess.h"
#include "cmpiCIM_LogicalElement.h"
#include "CIM_LogicalElementAccess.h"
*/

const static char* OpenDRIM_AssociatedProcessorCoreCacheMemory_classnames[] = {"OpenDRIM_AssociatedProcessorCoreCacheMemory"};
static string OpenDRIM_AssociatedProcessorCoreCacheMemory_NAMESPACE = _NAMESPACE;
const static string Antecedent_role = "Antecedent";
const static char* Antecedent_classnames[] = {"OpenDRIM_CacheMemory"};
const static string Antecedent_NAMESPACE = _NAMESPACE;

const static string Dependent_role = "Dependent";
const static char* Dependent_classnames[] = {"OpenDRIM_ProcessorCore"};
const static string Dependent_NAMESPACE = _NAMESPACE;

class OpenDRIM_AssociatedProcessorCoreCacheMemory {

public:
	
	Objectpath Antecedent;
	bool Antecedent_isNULL;
	
	Objectpath Dependent;
	bool Dependent_isNULL;
	
	unsigned short Level;
	bool Level_isNULL;
	
	string OtherLevelDescription;
	bool OtherLevelDescription_isNULL;
	
	unsigned short WritePolicy;
	bool WritePolicy_isNULL;
	
	string OtherWritePolicyDescription;
	bool OtherWritePolicyDescription_isNULL;
	
	unsigned short CacheType;
	bool CacheType_isNULL;
	
	string OtherCacheTypeDescription;
	bool OtherCacheTypeDescription_isNULL;
	
	unsigned int LineSize;
	bool LineSize_isNULL;
	
	unsigned short ReplacementPolicy;
	bool ReplacementPolicy_isNULL;
	
	string OtherReplacementPolicyDescription;
	bool OtherReplacementPolicyDescription_isNULL;
	
	unsigned short ReadPolicy;
	bool ReadPolicy_isNULL;
	
	string OtherReadPolicyDescription;
	bool OtherReadPolicyDescription_isNULL;
	
	unsigned int FlushTimer;
	bool FlushTimer_isNULL;
	
	unsigned short Associativity;
	bool Associativity_isNULL;
	
	string OtherAssociativityDescription;
	bool OtherAssociativityDescription_isNULL;
	
	OpenDRIM_AssociatedProcessorCoreCacheMemory() {
		Antecedent_isNULL = true;
		Dependent_isNULL = true;
		Level_isNULL = true;
		OtherLevelDescription_isNULL = true;
		WritePolicy_isNULL = true;
		OtherWritePolicyDescription_isNULL = true;
		CacheType_isNULL = true;
		OtherCacheTypeDescription_isNULL = true;
		LineSize_isNULL = true;
		ReplacementPolicy_isNULL = true;
		OtherReplacementPolicyDescription_isNULL = true;
		ReadPolicy_isNULL = true;
		OtherReadPolicyDescription_isNULL = true;
		FlushTimer_isNULL = true;
		Associativity_isNULL = true;
		OtherAssociativityDescription_isNULL = true;
	}
	
	~OpenDRIM_AssociatedProcessorCoreCacheMemory() {}
	
	string getKeys() const {
		return CF_toLowCase(".Antecedent=\"" + CF_quoteString(Antecedent.toString()) + "\""".Dependent=\"" + CF_quoteString(Dependent.toString()) + "\"");
	}

	int getAntecedent(Objectpath& value) const {
		if (Antecedent_isNULL==true)
			return NOT_FOUND;
		value = Antecedent;
		return OK;
	}
	
	int setAntecedent(const Objectpath& newValue) {
		Antecedent = newValue;
		Antecedent.setNamespace(Antecedent_NAMESPACE);
		Antecedent_isNULL = false;
		return OK;
	}

	int getDependent(Objectpath& value) const {
		if (Dependent_isNULL==true)
			return NOT_FOUND;
		value = Dependent;
		return OK;
	}
	
	int setDependent(const Objectpath& newValue) {
		Dependent = newValue;
		Dependent.setNamespace(Dependent_NAMESPACE);
		Dependent_isNULL = false;
		return OK;
	}

	int getLevel(unsigned short& value) const {
		if (Level_isNULL==true)
			return NOT_FOUND;
		value = Level;
		return OK;
	}
	
	int setLevel(const unsigned short& newValue) {
		Level = newValue;
		Level_isNULL = false;
		return OK;
	}

	int getOtherLevelDescription(string& value) const {
		if (OtherLevelDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherLevelDescription;
		return OK;
	}
	
	int setOtherLevelDescription(const string& newValue) {
		OtherLevelDescription = newValue;
		OtherLevelDescription_isNULL = false;
		return OK;
	}

	int getWritePolicy(unsigned short& value) const {
		if (WritePolicy_isNULL==true)
			return NOT_FOUND;
		value = WritePolicy;
		return OK;
	}
	
	int setWritePolicy(const unsigned short& newValue) {
		WritePolicy = newValue;
		WritePolicy_isNULL = false;
		return OK;
	}

	int getOtherWritePolicyDescription(string& value) const {
		if (OtherWritePolicyDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherWritePolicyDescription;
		return OK;
	}
	
	int setOtherWritePolicyDescription(const string& newValue) {
		OtherWritePolicyDescription = newValue;
		OtherWritePolicyDescription_isNULL = false;
		return OK;
	}

	int getCacheType(unsigned short& value) const {
		if (CacheType_isNULL==true)
			return NOT_FOUND;
		value = CacheType;
		return OK;
	}
	
	int setCacheType(const unsigned short& newValue) {
		CacheType = newValue;
		CacheType_isNULL = false;
		return OK;
	}

	int getOtherCacheTypeDescription(string& value) const {
		if (OtherCacheTypeDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherCacheTypeDescription;
		return OK;
	}
	
	int setOtherCacheTypeDescription(const string& newValue) {
		OtherCacheTypeDescription = newValue;
		OtherCacheTypeDescription_isNULL = false;
		return OK;
	}

	int getLineSize(unsigned int& value) const {
		if (LineSize_isNULL==true)
			return NOT_FOUND;
		value = LineSize;
		return OK;
	}
	
	int setLineSize(const unsigned int& newValue) {
		LineSize = newValue;
		LineSize_isNULL = false;
		return OK;
	}

	int getReplacementPolicy(unsigned short& value) const {
		if (ReplacementPolicy_isNULL==true)
			return NOT_FOUND;
		value = ReplacementPolicy;
		return OK;
	}
	
	int setReplacementPolicy(const unsigned short& newValue) {
		ReplacementPolicy = newValue;
		ReplacementPolicy_isNULL = false;
		return OK;
	}

	int getOtherReplacementPolicyDescription(string& value) const {
		if (OtherReplacementPolicyDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherReplacementPolicyDescription;
		return OK;
	}
	
	int setOtherReplacementPolicyDescription(const string& newValue) {
		OtherReplacementPolicyDescription = newValue;
		OtherReplacementPolicyDescription_isNULL = false;
		return OK;
	}

	int getReadPolicy(unsigned short& value) const {
		if (ReadPolicy_isNULL==true)
			return NOT_FOUND;
		value = ReadPolicy;
		return OK;
	}
	
	int setReadPolicy(const unsigned short& newValue) {
		ReadPolicy = newValue;
		ReadPolicy_isNULL = false;
		return OK;
	}

	int getOtherReadPolicyDescription(string& value) const {
		if (OtherReadPolicyDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherReadPolicyDescription;
		return OK;
	}
	
	int setOtherReadPolicyDescription(const string& newValue) {
		OtherReadPolicyDescription = newValue;
		OtherReadPolicyDescription_isNULL = false;
		return OK;
	}

	int getFlushTimer(unsigned int& value) const {
		if (FlushTimer_isNULL==true)
			return NOT_FOUND;
		value = FlushTimer;
		return OK;
	}
	
	int setFlushTimer(const unsigned int& newValue) {
		FlushTimer = newValue;
		FlushTimer_isNULL = false;
		return OK;
	}

	int getAssociativity(unsigned short& value) const {
		if (Associativity_isNULL==true)
			return NOT_FOUND;
		value = Associativity;
		return OK;
	}
	
	int setAssociativity(const unsigned short& newValue) {
		Associativity = newValue;
		Associativity_isNULL = false;
		return OK;
	}

	int getOtherAssociativityDescription(string& value) const {
		if (OtherAssociativityDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherAssociativityDescription;
		return OK;
	}
	
	int setOtherAssociativityDescription(const string& newValue) {
		OtherAssociativityDescription = newValue;
		OtherAssociativityDescription_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_ASSOCIATEDPROCESSORCORECACHEMEMORY_H_*/
