#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Harry Potter and the Mysterious Thief Part 1
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220805.2

GAME_ID='harry-potter-and-the-mysterious-thief-part1'
GAME_NAME='Harry Potter and the Mysterious Thief Part 1'

ARCHIVE_BASE_0='eng_nc17_HarryPotterAndTheMysteriousThiefpartI-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='0735c70f1836158cd5310c3b5e04b10f'
ARCHIVE_BASE_0_SIZE='170000'
ARCHIVE_BASE_0_VERSION='1.0-itch'
ARCHIVE_BASE_0_URL='https://rivarsstudio.itch.io/hpatmt'

CONTENT_PATH_DEFAULT='HarryPotterAndTheMysteriousThiefpartI-linux'
ARCHIVE_DOC_DATA_FILES='
README.html'
ARCHIVE_GAME_BIN32_FILES='
lib/linux-i686
HarryPotterAndTheMysteriousThiefpartI.sh'
ARCHIVE_GAME_BIN64_FILES='
lib/linux-x86_64'
ARCHIVE_GAME_DATA_FILES='
lib/pythonlib2.7
game
HarryPotterAndTheMysteriousThiefpartI.py
renpy'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='HarryPotterAndTheMysteriousThiefpartI.sh'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Use persistent storage for user data

USER_PERSISTENT_DIRECTORIES='
game/saves'

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Copy launcher script between the binaries packages

application_exe=$(application_exe 'APP_MAIN')

package_source='PKG_BIN32'
package_source_path=$(package_get_path "$package_source")
application_exe_source_path="${package_source_path}${PATH_GAME}/${application_exe}"

package_destination='PKG_BIN64'
package_destination_path=$(package_get_path "$package_destination")
application_exe_destination_path="${package_destination_path}${PATH_GAME}/${application_exe}"

mkdir --parents "$(dirname "$application_exe_destination_path")"
cp "$application_exe_source_path" "$application_exe_destination_path"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
