#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# If Not Us
# send your bug reports to contact@dotslashplay.it
###

script_version=20230915.1

GAME_ID='if-not-us'
GAME_NAME='If Not Us'

ARCHIVE_BASE_32BIT_0='if not us - Linux32.zip'
ARCHIVE_BASE_32BIT_0_MD5='e18811fde9e2a096cca93ac990764255'
ARCHIVE_BASE_32BIT_0_SIZE='240000'
ARCHIVE_BASE_32BIT_0_VERSION='1.0-itch'
ARCHIVE_BASE_32BIT_0_URL='https://ub4q.itch.io/ifnotus'

ARCHIVE_BASE_64BIT_0='if not us - Linux64.zip'
ARCHIVE_BASE_64BIT_0_MD5='216690ba3a752f8a5548e38b933f7bc4'
ARCHIVE_BASE_64BIT_0_SIZE='240000'
ARCHIVE_BASE_64BIT_0_VERSION='1.0-itch'
ARCHIVE_BASE_64BIT_0_URL='https://ub4q.itch.io/ifnotus'

CONTENT_PATH_DEFAULT='.'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_BIN_FILES='
libffmpeg.so
libnode.so
libnw.so'
CONTENT_GAME_BIN_FILES='
chromedriver
if not us
minidump_stackwalk
nacl_helper
nacl_helper_bootstrap
nacl_irt_x86_64.nexe
nwjc
payload
pnacl
snapshot_blob.bin'
CONTENT_GAME_DATA_FILES='
Gallery
locales
icudtl.dat
natives_blob.bin
nw_100_percent.pak
nw_200_percent.pak
nw_material_100_percent.pak
nw_material_200_percent.pak
resources.pak'
CONTENT_DOC_DATA_FILES='
credits.html'

APP_MAIN_EXE='if not us'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH_32BIT='32'
PKG_BIN_ARCH_64BIT='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libasound.so.2
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libcups.so.2
libdbus-1.so.3
libdl.so.2
libexpat.so.1
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgconf-2.so.4
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libgio-2.0.so.0
libglib-2.0.so.0
libgmodule-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libnspr4.so
libnss3.so
libnssutil3.so
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpthread.so.0
librt.so.1
libsmime3.so
libstdc++.so.6
libX11.so.6
libXcomposite.so.1
libXcursor.so.1
libXdamage.so.1
libXext.so.6
libXfixes.so.3
libXi.so.6
libXrandr.so.2
libXrender.so.1
libXss.so.1
libXtst.so.6'

# Load common functions

target_version='2.25'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game files

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
