#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Softporn Adventure
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220709.1

# Set game-specific variables

GAME_ID='softporn-adventure'
GAME_NAME='Softporn Adventure'

# This DRM-free installer is no longer distributed by GOG
ARCHIVE_BASE_0='gog_softporn_adventure_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='1e51094f928757140c5a0dacc70773c0'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='11000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.1'

CONTENT_PATH_DEFAULT='data/noarch/data'
ARCHIVE_GAME_MAIN_FILES='
*'
ARCHIVE_DOC_MAIN_PATH="${CONTENT_PATH_DEFAULT}/../docs"
ARCHIVE_DOC_MAIN_FILES='
SOFTPORN.DOC'

APP_MAIN_TYPE='dosbox'
APP_MAIN_EXE='softporn.exe'
APP_MAIN_ICON='data/noarch/support/icon.png'

PKG_MAIN_DEPS='dosbox'

# Use persistent storage for user data

DATA_FILES='*.GAM'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
content_path=$(content_path_default)
tolower "${PLAYIT_WORKDIR}/gamedata/${content_path}"
prepare_package_layout

# Include game icon

icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
