#ifndef HARMONICS_H
#define HARMONICS_H

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <QtWidgets/QWidget>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QVBoxLayout>
#include <QtGui/QMouseEvent>
#include <QtCore/QString>
#include <QtCore/QPoint> 
#include "model.h"

class Harmonics : public QWidget
{
  Q_OBJECT

  private:
    Model *model;
    int leftBorder, rightBorder, topBorder, bottomBorder;
    int index;
    double scaleX, scaleY;
    int mousePos;
    double mouseVal;
    QPoint upperControlPoints[MAX_HARMONIC_GROUPS][NUM_CONTROLPOINTS + 2]; // +2 für Lower und Upper Harmonics
    int activeControlPoint;
    QString unitLabel;
    bool showPolygonFlag;

  private:
    void updateUpperHarmonics();

  public:
    Harmonics(Model *p_model, QString p_unitLabel, int p_index, QWidget* parent=0, int w=300, int h=200);
    ~Harmonics();
    void setHarmonic(int objectType, int objectIndex, int voiceIndex, int value);
    int getHarmonic(int objectType, int objectIndex, int voiceIndex);
    QPoint getControlPoint(int index1, int index2);
    void setControlPointY(int index1, int index2, int value);
    void setShowPolygon(bool on);
    void randomizeHarmonics(int lowerRandomLevel, int upperRandomLevel, bool addRandomFlag);

  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void viewportResizeEvent (QResizeEvent *ev);
    virtual void mousePressEvent (QMouseEvent* );
    virtual void mouseReleaseEvent (QMouseEvent* );
    virtual void mouseMoveEvent (QMouseEvent* );

  public slots: 
};
  
#endif
