/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgColumnPrivilege;
import cz.startnet.utils.pgdiff.schema.PgColumnUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PgColumn {
    private static final Pattern PATTERN_NULL = Pattern.compile("^(.+)[\\s]+NULL$", 2);
    private static final Pattern PATTERN_NOT_NULL = Pattern.compile("^(.+)[\\s]+NOT[\\s]+NULL$", 2);
    private static final Pattern PATTERN_DEFAULT = Pattern.compile("^(.+)[\\s]+DEFAULT[\\s]+(.+)$", 2);
    private Integer statistics;
    private String defaultValue;
    private String name;
    private String type;
    private boolean nullValue = true;
    private String storage;
    private String comment;
    private final List<PgColumnPrivilege> privileges = new ArrayList<PgColumnPrivilege>();
    private String generated;

    public PgColumn(String string) {
        this.name = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFullDefinition(boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        stringBuilder.append(' ');
        stringBuilder.append(this.type);
        if (this.defaultValue != null && !this.defaultValue.isEmpty()) {
            stringBuilder.append(" DEFAULT ");
            stringBuilder.append(this.defaultValue);
        } else if (!this.nullValue && bl && (string = PgColumnUtils.getDefaultValue(this.type)) != null) {
            stringBuilder.append(" DEFAULT ");
            stringBuilder.append(string);
        }
        if (!this.nullValue) {
            stringBuilder.append(" NOT NULL");
        }
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setNullValue(boolean bl) {
        this.nullValue = bl;
    }

    public boolean getNullValue() {
        return this.nullValue;
    }

    public void setStatistics(Integer n) {
        this.statistics = n;
    }

    public Integer getStatistics() {
        return this.statistics;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String string) {
        this.storage = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void addPrivilege(PgColumnPrivilege pgColumnPrivilege) {
        this.privileges.add(pgColumnPrivilege);
    }

    public PgColumnPrivilege getPrivilege(String string) {
        for (PgColumnPrivilege pgColumnPrivilege : this.privileges) {
            if (!pgColumnPrivilege.getRoleName().equals(string)) continue;
            return pgColumnPrivilege;
        }
        return null;
    }

    public List<PgColumnPrivilege> getPrivileges() {
        return Collections.unmodifiableList(this.privileges);
    }

    public void parseDefinition(String string) {
        String string2 = string;
        Matcher matcher = PATTERN_NOT_NULL.matcher(string2);
        if (matcher.matches()) {
            string2 = matcher.group(1).trim();
            this.setNullValue(false);
        } else {
            matcher = PATTERN_NULL.matcher(string2);
            if (matcher.matches()) {
                string2 = matcher.group(1).trim();
                this.setNullValue(true);
            }
        }
        matcher = PATTERN_DEFAULT.matcher(string2);
        if (matcher.matches()) {
            string2 = matcher.group(1).trim();
            this.setDefaultValue(matcher.group(2).trim());
        }
        this.setType(string2);
    }

    public String getGenerated() {
        return this.generated;
    }

    public void setGenerated(String string) {
        this.generated = string;
    }
}

