# coding=utf-8
# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# --------------------------------------------------------------------------------------------

from knack.help_files import helps  # pylint: disable=unused-import
# pylint: disable=line-too-long, too-many-lines

helps['monitor'] = """
type: group
short-summary: Manage the Azure Monitor Service.
"""

helps['monitor action-group'] = """
type: group
short-summary: Manage action groups
"""

helps['monitor action-group create'] = """
type: command
short-summary: Create a new action group
parameters:
  - name: --action -a
    short-summary: Add receivers to the action group during the creation
    long-summary: |
        Usage:   --action TYPE NAME [ARG ...]
        Email:
            Format:     --action email NAME EMAIL_ADDRESS [usecommonalertschema]
            Example:    --action email bob bob@contoso.com
        SMS:
            Format:     --action sms NAME COUNTRY_CODE PHONE_NUMBER
            Example:    --action sms charli 1 5551234567
        Webhook:
            Format:     --action webhook NAME URI [useaadauth OBJECT_ID IDENTIFIER URI] [usecommonalertschema]
            Example:    --action webhook alert_hook https://www.contoso.com/alert useaadauth testobj http://identifier usecommonalertschema
        Arm Role:
            Format:     --action armrole NAME ROLE_ID [usecommonalertschema]
            Example:    --action armole owner_role 8e3af657-a8ff-443c-a75c-2fe8c4bcb635
        Azure App Push:
            Format:     --action azureapppush NAME EMAIL_ADDRESS
            Example:    --action azureapppush test_apppush bob@contoso.com
        ITSM:
            Format:     --action itsm NAME WORKSPACE_ID CONNECTION_ID TICKET_CONFIGURATION REGION
            Example:    --action itsm test_itsm test_workspace test_conn ticket_blob useast
        Automation runbook:
            Format:     --action automationrunbook NAME AUTOMATION_ACCOUNT_ID RUNBOOK_NAME WEBHOOK_RESOURCE_ID SERVICE_URI [isglobalrunbook] [usecommonalertschema]
            Example:    --action automationrunbook test_runbook test_acc test_book test_webhook test_rsrc http://example.com isglobalrunbook usecommonalertschema
        Voice:
            Format:     --action voice NAME COUNTRY_CODE PHONE_NUMBER
            Example:    --action voice charli 1 4441234567
        Logic App:
            Format:     --action logicapp NAME RESOURCE_ID CALLBACK_URL [usecommonalertschema]
            Example:    --action logicapp test_logicapp test_rsrc http://callback
        Azure Function:
            Format:     --action azurefunction NAME FUNCTION_APP_RESOURCE_ID FUNCTION_NAME HTTP_TRIGGER_URL [usecommonalertschema]
            Example:    --action azurefunction test_function test_rsrc test_func http://trigger usecommonalertschema
        Multiple actions can be specified by using more than one `--add-action` argument.
        'useaadauth', 'isglobalrunbook' and 'usecommonalertschema' are optional arguements that only need to be passed to set the respective parameter to True.
        If the 'useaadauth' argument is passed, then the OBJECT_ID and IDENTIFIER_URI values are required as well.
  - name: --short-name
    short-summary: The short name of the action group
examples:
  - name: Create a new action group (autogenerated)
    text: az monitor action-group create --action webhook https://alerts.contoso.com apiKey={APIKey} type=HighCPU --name MyActionGroup --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor action-group list'] = """
type: command
short-summary: List action groups under a resource group or the current subscription
parameters:
  - name: --resource-group -g
    type: string
    short-summary: >
        Name of the resource group under which the action groups are being listed. If it is omitted, all the action groups under
        the current subscription are listed.
"""

helps['monitor action-group show'] = """
type: command
short-summary: Show the details of an action group
examples:
  - name: Show the details of an action group (commonly used with --output and --query). (autogenerated)
    text: az monitor action-group show --name MyActionGroup --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor action-group update'] = """
type: command
short-summary: Update an action group
parameters:
  - name: --short-name
    short-summary: Update the group short name of the action group
  - name: --add-action -a
    short-summary: Add receivers to the action group
    long-summary: |
        Usage:   --add-action TYPE NAME [ARG ...]
        Email:
            Format:     --add-action email NAME EMAIL_ADDRESS [usecommonalertschema]
            Example:    --add-action email bob bob@contoso.com
        SMS:
            Format:     --add-action sms NAME COUNTRY_CODE PHONE_NUMBER
            Example:    --add-action sms charli 1 5551234567
        Webhook:
            Format:     --add-action webhook NAME URI [useaadauth OBJECT_ID IDENTIFIER URI] [usecommonalertschema]
            Example:    --add-action https://www.contoso.com/alert useaadauth testobj http://identifier usecommonalertschema
        Arm Role:
            Format:     --add-action armrole NAME ROLE_ID [usecommonalertschema]
            Example:    --add-action armole owner_role 8e3af657-a8ff-443c-a75c-2fe8c4bcb635
        Azure App Push:
            Format:     --add-action azureapppush NAME EMAIL_ADDRESS
            Example:    --add-action azureapppush test_apppush bob@contoso.com
        ITSM:
            Format:     --add-action itsm NAME WORKSPACE_ID CONNECTION_ID TICKET_CONFIGURATION REGION
            Example:    --add-action itsm test_itsm test_workspace test_conn ticket_blob useast
        Automation runbook:
            Format:     --add-action automationrunbook NAME AUTOMATION_ACCOUNT_ID RUNBOOK_NAME WEBHOOK_RESOURCE_ID SERVICE_URI [isglobalrunbook] [usecommonalertschema]
            Example:    --add-action automationrunbook test_runbook test_acc test_book test_webhook test_rsrc http://example.com isglobalrunbook usecommonalertschema
        Voice:
            Format:     --add-action voice NAME COUNTRY_CODE PHONE_NUMBER
            Example:    --add-action voice charli 1 4441234567
        Logic App:
            Format:     --add-action logicapp NAME RESOURCE_ID CALLBACK_URL [usecommonalertschema]
            Example:    --add-action logicapp test_logicapp test_rsrc http://callback
        Azure Function:
            Format:     --add-action azurefunction NAME FUNCTION_APP_RESOURCE_ID FUNCTION_NAME HTTP_TRIGGER_URL [usecommonalertschema]
            Example:    --add-action azurefunction test_function test_rsrc test_func http://trigger usecommonalertschema
        Multiple actions can be specified by using more than one `--add-action` argument.
        'useaadauth', 'isglobalrunbook' and 'usecommonalertschema' are optional arguements that only need to be passed to set the respective parameter to True.
        If the 'useaadauth' argument is passed, then the OBJECT_ID and IDENTIFIER_URI values are required as well.
  - name: --remove-action -r
    short-summary: Remove receivers from the action group. Accept space-separated list of receiver names.
examples:
  - name: Update an action group (autogenerated)
    text: az monitor action-group update --name MyActionGroup --resource-group MyResourceGroup --set retentionPolicy.days=365 --subscription MySubscription
    crafted: true
"""

helps['monitor activity-log'] = """
type: group
short-summary: Manage activity logs.
"""

helps['monitor activity-log alert'] = """
type: group
short-summary: Manage activity log alerts
"""

helps['monitor activity-log alert action-group'] = """
type: group
short-summary: Manage action groups for activity log alerts
"""

helps['monitor activity-log alert action-group add'] = """
type: command
short-summary: Add action groups to this activity log alert. It can also be used to overwrite existing webhook properties of particular action groups.
parameters:
  - name: --name -n
    short-summary: Name of the activity log alerts
  - name: --action-group -a
    short-summary: The names or the resource ids of the action groups to be added.
  - name: --reset
    short-summary: Remove all the existing action groups before add new conditions.
  - name: --webhook-properties -w
    short-summary: >
        Space-separated webhook properties in 'key[=value]' format. These properties will be associated with
        the action groups added in this command.
    long-summary: >
        For any webhook receiver in these action group, these data are appended to the webhook payload.
        To attach different webhook properties to different action groups, add the action groups in separate update-action commands.
  - name: --strict
    short-summary: Fails the command if an action group to be added will change existing webhook properties.
examples:
  - name: Add an action group and specify webhook properties.
    text: |
        az monitor activity-log alert action-group add -n {AlertName} -g {ResourceGroup} \\
          --action /subscriptions/{SubID}/resourceGroups/{ResourceGroup}/providers/microsoft.insights/actionGroups/{ActionGroup} \\
          --webhook-properties usage=test owner=jane
  - name: Overwite an existing action group's webhook properties.
    text: |
        az monitor activity-log alert action-group add -n {AlertName} -g {ResourceGroup} \\
          -a /subscriptions/{SubID}/resourceGroups/{ResourceGroup}/providers/microsoft.insights/actionGroups/{ActionGroup} \\
          --webhook-properties usage=test owner=john
  - name: Remove webhook properties from an existing action group.
    text: |
        az monitor activity-log alert action-group add -n {AlertName} -g {ResourceGroup} \\
          -a /subscriptions/{SubID}/resourceGroups/{ResourceGroup}/providers/microsoft.insights/actionGroups/{ActionGroup}
  - name: Add new action groups but prevent the command from accidently overwrite existing webhook properties
    text: |
        az monitor activity-log alert action-group add -n {AlertName} -g {ResourceGroup} --strict \\
          --action-group {ResourceIDList}
"""

helps['monitor activity-log alert action-group remove'] = """
type: command
short-summary: Remove action groups from this activity log alert
parameters:
  - name: --name -n
    short-summary: Name of the activity log alerts
  - name: --action-group -a
    short-summary: The names or the resource ids of the action groups to be added.
"""

helps['monitor activity-log alert create'] = """
type: command
short-summary: Create a default activity log alert
long-summary: This command will create a default activity log with one condition which compares if the activities logs 'category' field equals to 'ServiceHealth'. The newly created activity log alert does not have any action groups attached to it.
parameters:
  - name: --name -n
    short-summary: Name of the activity log alerts
  - name: --scope -s
    short-summary: A list of strings that will be used as prefixes.
    long-summary: >
        The alert will only apply to activity logs with resourceIDs that fall under one of these prefixes.
        If not provided, the path to the resource group will be used.
  - name: --disable
    short-summary: Disable the activity log alert after it is created.
  - name: --description
    short-summary: A description of this activity log alert
  - name: --condition -c
    short-summary: The condition that will cause the alert to activate. The format is FIELD=VALUE[ and FIELD=VALUE...].
    long-summary: >
        The possible values for the field are 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup',
        'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties.'.
  - name: --action-group -a
    short-summary: >
        Add an action group. Accepts space-separated action group identifiers. The identifier can be the action group's name
        or its resource ID.
  - name: --webhook-properties -w
    short-summary: >
        Space-separated webhook properties in 'key[=value]' format. These properties are associated with the action groups
        added in this command.
    long-summary: >
        For any webhook receiver in these action group, this data is appended to the webhook payload. To attach different webhook
        properties to different action groups, add the action groups in separate update-action commands.
examples:
  - name: Create an alert with default settings.
    text: >
        az monitor activity-log alert create -n {AlertName} -g {ResourceGroup}
  - name: Create an alert with condition about error level service health log.
    text: >
        az monitor activity-log alert create -n {AlertName} -g {ResourceGroup} \\
          --condition category=ServiceHealth and level=Error
  - name: Create an alert with an action group and specify webhook properties.
    text: >
        az monitor activity-log alert create -n {AlertName} -g {ResourceGroup} \\
          -a /subscriptions/{SubID}/resourceGroups/{ResourceGroup}/providers/microsoft.insights/actionGroups/{ActionGroup} \\
          -w usage=test owner=jane
  - name: Create an alert which is initially disabled.
    text: >
        az monitor activity-log alert create -n {AlertName} -g {ResourceGroup} --disable
"""

helps['monitor activity-log alert list'] = """
type: command
short-summary: List activity log alerts under a resource group or the current subscription.
parameters:
  - name: --resource-group -g
    short-summary: Name of the resource group under which the activity log alerts are being listed. If it is omitted, all the activity log alerts under the current subscription are listed.
"""

helps['monitor activity-log alert scope'] = """
type: group
short-summary: Manage scopes for activity log alerts
"""

helps['monitor activity-log alert scope add'] = """
type: command
short-summary: Add scopes to this activity log alert.
parameters:
  - name: --name -n
    short-summary: Name of the activity log alerts
  - name: --scope -s
    short-summary: List of scopes to add. Each scope could be a resource ID, a resource group ID or a subscription ID.
  - name: --reset
    short-summary: Remove all the existing scopes before add new scopes.
examples:
  - name: Add three levels of scopes into activity-log alert.
    text: >
        az monitor activity-log alert scope add -n {AlertName} -g {ResourceGroup} -s /subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx \\
        /subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myRG \\
        /subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myRG/Microsoft.KeyVault/vaults/mykey
"""

helps['monitor activity-log alert scope remove'] = """
type: command
short-summary: Removes scopes from this activity log alert.
parameters:
  - name: --name -n
    short-summary: Name of the activity log alerts
  - name: --scope -s
    short-summary: The scopes to remove
"""

helps['monitor activity-log alert update'] = """
type: command
short-summary: Update the details of this activity log alert
parameters:
  - name: --description
    short-summary: A description of this activity log alert.
  - name: --condition -c
    short-summary: The conditional expression that will cause the alert to activate. The format is FIELD=VALUE[ and FIELD=VALUE...].
    long-summary: >
        The possible values for the field are 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup',
        'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties.'.
examples:
  - name: Update the condition
    text: >
        az monitor activity-log alert update -n {AlertName} -g {ResourceGroup} \\
          --condition category=ServiceHealth and level=Error
  - name: Disable an alert
    text: >
        az monitor activity-log alert update -n {AlertName} -g {ResourceGroup} --enable false
  - name: Update the details of this activity log alert (autogenerated)
    text: az monitor activity-log alert update --enabled true --name MyActivityLogAlerts --resource-group MyResourceGroup --subscription MySubscription
    crafted: true
"""

helps['monitor activity-log list'] = """
type: command
short-summary: List and query activity log events.
parameters:
  - name: --correlation-id
    short-summary: Correlation ID to query.
  - name: --resource-id
    short-summary: ARM ID of a resource.
  - name: --namespace
    short-summary: Resource provider namespace.
  - name: --caller
    short-summary: Caller to query for, such as an e-mail address or service principal ID.
  - name: --status
    short-summary: >
        Status to query for (ex: Failed)
  - name: --max-events
    short-summary: Maximum number of records to return.
  - name: --select
    short-summary: Space-separated list of properties to return.
  - name: --offset
    short-summary: >
        Time offset of the query range, in ##d##h format.
    long-summary: >
        Can be used with either --start-time or --end-time. If used with --start-time, then
        the end time will be calculated by adding the offset. If used with --end-time (default), then
        the start time will be calculated by subtracting the offset. If --start-time and --end-time are
        provided, then --offset will be ignored.
examples:
  - name: List all events from July 1st, looking forward one week.
    text: az monitor activity-log list --start-time 2018-07-01 --offset 7d
  - name: List events within the past six hours based on a correlation ID.
    text: az monitor activity-log list --correlation-id b5eac9d2-e829-4c9a-9efb-586d19417c5f
  - name: List events within the past hour based on resource group.
    text: az monitor activity-log list -g {ResourceGroup} --offset 1h
"""

helps['monitor activity-log list-categories'] = """
type: command
short-summary: List the event categories of activity logs.
"""

helps['monitor alert'] = """
type: group
short-summary: Manage classic metric-based alert rules.
"""

helps['monitor alert create'] = """
type: command
short-summary: Create a classic metric-based alert rule.
parameters:
  - name: --action -a
    short-summary: Add an action to fire when the alert is triggered.
    long-summary: |
        Usage:   --action TYPE KEY [ARG ...]
        Email:   --action email bob@contoso.com ann@contoso.com
        Webhook: --action webhook https://www.contoso.com/alert apiKey=value
        Webhook: --action webhook https://www.contoso.com/alert?apiKey=value
        Multiple actions can be specified by using more than one `--action` argument.
  - name: --description
    short-summary: Free-text description of the rule. Defaults to the condition expression.
  - name: --disabled
    short-summary: Create the rule in a disabled state.
  - name: --condition
    short-summary: The condition which triggers the rule.
    long-summary: >
        The form of a condition is "METRIC {>,>=,<,<=} THRESHOLD {avg,min,max,total,last} PERIOD".
        Values for METRIC and appropriate THRESHOLD values can be obtained from `az monitor metric` commands,
        and PERIOD is of the form "##h##m##s".
  - name: --email-service-owners
    short-summary: Email the service owners if an alert is triggered.
examples:
  - name: Create a high CPU usage alert on a VM with no actions.
    text: >
        az monitor alert create -n rule1 -g {ResourceGroup} --target {VirtualMachineID} --condition "Percentage CPU > 90 avg 5m"
  - name: Create a high CPU usage alert on a VM with email and webhook actions.
    text: |
        az monitor alert create -n rule1 -g {ResourceGroup} --target {VirtualMachineID} \\
            --condition "Percentage CPU > 90 avg 5m" \\
            --action email bob@contoso.com ann@contoso.com --email-service-owners \\
            --action webhook https://www.contoso.com/alerts?type=HighCPU \\
            --action webhook https://alerts.contoso.com apiKey={APIKey} type=HighCPU
"""

helps['monitor alert delete'] = """
type: command
short-summary: Delete an alert rule.
examples:
  - name: Delete an alert rule. (autogenerated)
    text: az monitor alert delete --name MyAlertRule --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor alert list'] = """
type: command
short-summary: List alert rules in a resource group.
examples:
  - name: List alert rules in a resource group. (autogenerated)
    text: az monitor alert list --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor alert list-incidents'] = """
type: command
short-summary: List all incidents for an alert rule.
examples:
  - name: List all incidents for an alert rule. (autogenerated)
    text: az monitor alert list-incidents --resource-group MyResourceGroup --rule-name MyRule
    crafted: true
"""

helps['monitor alert show'] = """
type: command
short-summary: Show an alert rule.
examples:
  - name: Show an alert rule. (autogenerated)
    text: az monitor alert show --name MyAlertRule --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor alert show-incident'] = """
type: command
short-summary: Get the details of an alert rule incident.
"""

helps['monitor alert update'] = """
type: command
short-summary: Update a classic metric-based alert rule.
parameters:
  - name: --description
    short-summary: Description of the rule.
  - name: --condition
    short-summary: The condition which triggers the rule.
    long-summary: >
        The form of a condition is "METRIC {>,>=,<,<=} THRESHOLD {avg,min,max,total,last} PERIOD".
        Values for METRIC and appropriate THRESHOLD values can be obtained from `az monitor metric` commands,
        and PERIOD is of the form "##h##m##s".
  - name: --add-action -a
    short-summary: Add an action to fire when the alert is triggered.
    long-summary: |
        Usage:   --add-action TYPE KEY [ARG ...]
        Email:   --add-action email bob@contoso.com ann@contoso.com
        Webhook: --add-action webhook https://www.contoso.com/alert apiKey=value
        Webhook: --add-action webhook https://www.contoso.com/alert?apiKey=value
        Multiple actions can be specified by using more than one `--add-action` argument.
  - name: --remove-action -r
    short-summary: Remove one or more actions.
    long-summary: |
        Usage:   --remove-action TYPE KEY [KEY ...]
        Email:   --remove-action email bob@contoso.com ann@contoso.com
        Webhook: --remove-action webhook https://contoso.com/alert https://alerts.contoso.com
  - name: --email-service-owners
    short-summary: Email the service owners if an alert is triggered.
  - name: --metric
    short-summary: Name of the metric to base the rule on.
    populator-commands:
      - az monitor metrics list-definitions
  - name: --operator
    short-summary: How to compare the metric against the threshold.
  - name: --threshold
    short-summary: Numeric threshold at which to trigger the alert.
  - name: --aggregation
    short-summary: Type of aggregation to apply based on --period.
  - name: --period
    short-summary: >
        Time span over which to apply --aggregation, in nDnHnMnS shorthand or full ISO8601 format.
examples:
  - name: Update a classic metric-based alert rule. (autogenerated)
    text: az monitor alert update --email-service-owners true --name MyAlertRule --resource-group MyResourceGroup
    crafted: true
  - name: Update a classic metric-based alert rule. (autogenerated)
    text: az monitor alert update --name MyAlertRule --remove-action email bob@contoso.com --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor autoscale'] = """
type: group
short-summary: Manage autoscale settings.
long-summary: >
    For more information on autoscaling, visit: https://docs.microsoft.com/azure/monitoring-and-diagnostics/monitoring-understanding-autoscale-settings
"""

helps['monitor autoscale create'] = """
type: command
short-summary: Create new autoscale settings.
long-summary: >
    For more information on autoscaling, visit: https://docs.microsoft.com/azure/monitoring-and-diagnostics/monitoring-understanding-autoscale-settings
parameters:
  - name: --action -a
    short-summary: Add an action to fire when a scaling event occurs.
    long-summary: |
        Usage:   --action TYPE KEY [ARG ...]
        Email:   --action email bob@contoso.com ann@contoso.com
        Webhook: --action webhook https://www.contoso.com/alert apiKey=value
        Webhook: --action webhook https://www.contoso.com/alert?apiKey=value
        Multiple actions can be specified by using more than one `--action` argument.
examples:
  - name: Create autoscale settings to scale between 2 and 5 instances (3 as default). Email the administrator when scaling occurs.
    text: |
        az monitor autoscale create -g {myrg} --resource {resource-id} --min-count 2 --max-count 5 \\
          --count 3 --email-administrator

        az monitor autoscale rule create -g {myrg} --autoscale-name {resource-name} --scale out 1 \\
          --condition "Percentage CPU > 75 avg 5m"

        az monitor autoscale rule create -g {myrg} --autoscale-name {resource-name} --scale in 1 \\
          --condition "Percentage CPU < 25 avg 5m"
  - name: Create autoscale settings for exactly 4 instances.
    text: >
        az monitor autoscale create -g {myrg} --resource {resource-id} --count 4
  - name: Create new autoscale settings. (autogenerated)
    text: az monitor autoscale create --count 3 --max-count 5 --min-count 2 --name MyAutoscaleSettings --resource myScaleSet --resource-group MyResourceGroup --resource-type Microsoft.Compute/virtualMachineScaleSets
    crafted: true
"""

helps['monitor autoscale profile'] = """
type: group
short-summary: Manage autoscaling profiles.
long-summary: >
    For more information on autoscaling, visit: https://docs.microsoft.com/azure/monitoring-and-diagnostics/monitoring-understanding-autoscale-settings
"""

helps['monitor autoscale profile create'] = """
type: command
short-summary: Create a fixed or recurring autoscale profile.
long-summary: >
    For more information on autoscaling, visit: https://docs.microsoft.com/azure/monitoring-and-diagnostics/monitoring-understanding-autoscale-settings
parameters:
  - name: --timezone
    short-summary: Timezone name.
    populator-commands:
      - az monitor autoscale profile list-timezones
  - name: --recurrence -r
    short-summary: When the profile recurs. If omitted, a fixed (non-recurring) profile is created.
    long-summary: |
        Usage:     --recurrence {week} [ARG ARG ...]
        Weekly:    --recurrence week Sat Sun
  - name: --start
    short-summary: When the autoscale profile begins. Format depends on the type of profile.
    long-summary: |
        Fixed:  --start yyyy-mm-dd [hh:mm:ss]
        Weekly: [--start hh:mm]
  - name: --end
    short-summary: When the autoscale profile ends. Format depends on the type of profile.
    long-summary: |
        Fixed:  --end yyyy-mm-dd [hh:mm:ss]
        Weekly: [--end hh:mm]
examples:
  - name: Create a fixed date profile, inheriting the default scaling rules but changing the capacity.
    text: |
        az monitor autoscale create -g {myrg} --resource {resource-id} --min-count 2 --count 3 \\
          --max-count 5

        az monitor autoscale rule create -g {myrg} --autoscale-name {name} --scale out 1 \\
          --condition "Percentage CPU > 75 avg 5m"

        az monitor autoscale rule create -g {myrg} --autoscale-name {name} --scale in 1 \\
          --condition "Percentage CPU < 25 avg 5m"

        az monitor autoscale profile create -g {myrg} --autoscale-name {name} -n Christmas \\
          --copy-rules default --min-count 3 --count 6 --max-count 10 --start 2018-12-24 \\
          --end 2018-12-26 --timezone "Pacific Standard Time"
  - name: Create a recurring weekend profile, inheriting the default scaling rules but changing the capacity.
    text: |
        az monitor autoscale create -g {myrg} --resource {resource-id} --min-count 2 --count 3 \\
          --max-count 5

        az monitor autoscale rule create -g {myrg} --autoscale-name {name} --scale out 1 \\
          --condition "Percentage CPU > 75 avg 5m"

        az monitor autoscale rule create -g {myrg} --autoscale-name {name} --scale in 1 \\
          --condition "Percentage CPU < 25 avg 5m"

        az monitor autoscale profile create -g {myrg} --autoscale-name {name} -n weeekend \\
          --copy-rules default --min-count 1 --count 2 --max-count 2 \\
          --recurrence week sat sun --timezone "Pacific Standard Time"
"""

helps['monitor autoscale profile delete'] = """
type: command
short-summary: Delete an autoscale profile.
examples:
  - name: Delete an autoscale profile. (autogenerated)
    text: az monitor autoscale profile delete --autoscale-name MyAutoscale --name MyAutoscaleProfile --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor autoscale profile list'] = """
type: command
short-summary: List autoscale profiles.
examples:
  - name: List autoscale profiles. (autogenerated)
    text: az monitor autoscale profile list --autoscale-name MyAutoscale --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor autoscale profile list-timezones'] = """
type: command
short-summary: Look up time zone information.
"""

helps['monitor autoscale profile show'] = """
type: command
short-summary: Show details of an autoscale profile.
"""

helps['monitor autoscale rule'] = """
type: group
short-summary: Manage autoscale scaling rules.
long-summary: >
    For more information on autoscaling, visit: https://docs.microsoft.com/azure/monitoring-and-diagnostics/monitoring-understanding-autoscale-settings
"""

helps['monitor autoscale rule copy'] = """
type: command
short-summary: Copy autoscale rules from one profile to another.
"""

helps['monitor autoscale rule create'] = """
type: command
short-summary: Add a new autoscale rule.
long-summary: >
    For more information on autoscaling, visit: https://docs.microsoft.com/azure/monitoring-and-diagnostics/monitoring-understanding-autoscale-settings
parameters:
  - name: --condition
    short-summary: The condition which triggers the scaling action.
    long-summary: >
        The form of a condition is "METRIC {==,!=,>,>=,<,<=} THRESHOLD {avg,min,max,total,count} PERIOD".
        Values for METRIC and appropriate THRESHOLD values can be obtained from the `az monitor metric` command.
        Format of PERIOD is "##h##m##s".
  - name: --scale
    short-summary: The direction and amount to scale.
    long-summary: |
        Usage:          --scale {to,in,out} VAL[%]
        Fixed Count:    --scale to 5
        In by Count:    --scale in 2
        Out by Percent: --scale out 10%
  - name: --timegrain
    short-summary: >
        The way metrics are polled across instances.
    long-summary: >
        The form of the timegrain is {avg,min,max,sum} VALUE. Values can be obtained from the `az monitor metric` command.
        Format of VALUE is "##h##m##s".
examples:
  - name: Scale to 5 instances when the CPU Percentage across instances is greater than 75 averaged over 10 minutes.
    text: |
        az monitor autoscale rule create -g {myrg} --autoscale-name {myvmss} \\
          --scale to 5 --condition "Percentage CPU > 75 avg 10m"
  - name: Scale up 2 instances when the CPU Percentage across instances is greater than 75 averaged over 5 minutes.
    text: |
        az monitor autoscale rule create -g {myrg} --autoscale-name {myvmss} \\
          --scale out 2 --condition "Percentage CPU > 75 avg 5m"
  - name: Scale down 50% when the CPU Percentage across instances is less than 25 averaged over 15 minutes.
    text: |
        az monitor autoscale rule create -g {myrg} --autoscale-name {myvmss} \\
          --scale in 50% --condition "Percentage CPU < 25 avg 15m"
"""

helps['monitor autoscale rule delete'] = """
type: command
short-summary: Remove autoscale rules from a profile.
"""

helps['monitor autoscale rule list'] = """
type: command
short-summary: List autoscale rules for a profile.
examples:
  - name: List autoscale rules for a profile. (autogenerated)
    text: az monitor autoscale rule list --autoscale-name MyAutoscale --profile-name MyProfile --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor autoscale show'] = """
type: command
short-summary: Show autoscale setting details.
examples:
  - name: Show autoscale setting details. (autogenerated)
    text: az monitor autoscale show --name MyAutoscaleSettings --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor autoscale update'] = """
type: command
short-summary: Update autoscale settings.
long-summary: >
    For more information on autoscaling, visit: https://docs.microsoft.com/azure/monitoring-and-diagnostics/monitoring-understanding-autoscale-settings
parameters:
  - name: --add-action -a
    short-summary: Add an action to fire when a scaling event occurs.
    long-summary: |
        Usage:   --add-action TYPE KEY [ARG ...]
        Email:   --add-action email bob@contoso.com ann@contoso.com
        Webhook: --add-action webhook https://www.contoso.com/alert apiKey=value
        Webhook: --add-action webhook https://www.contoso.com/alert?apiKey=value
        Multiple actions can be specified by using more than one `--add-action` argument.
  - name: --remove-action -r
    short-summary: Remove one or more actions.
    long-summary: |
        Usage:   --remove-action TYPE KEY [KEY ...]
        Email:   --remove-action email bob@contoso.com ann@contoso.com
        Webhook: --remove-action webhook https://contoso.com/alert https://alerts.contoso.com
examples:
  - name: Update autoscale settings to use a fixed 3 instances by default.
    text: |
        az monitor autoscale update -g {myrg} -n {autoscale-name} --count 3
  - name: Update autoscale settings to remove an email notification.
    text: |
        az monitor autoscale update -g {myrg} -n {autoscale-name} \\
          --remove-action email bob@contoso.com
  - name: Update autoscale settings. (autogenerated)
    text: az monitor autoscale update --count 3 --email-administrator true --enabled true --max-count 5 --min-count 2 --name MyAutoscaleSettings --resource-group MyResourceGroup --tags key[=value]
    crafted: true
"""

helps['monitor autoscale-settings'] = """
type: group
short-summary: Manage autoscale settings.
"""

helps['monitor autoscale-settings update'] = """
type: command
short-summary: Updates an autoscale setting.
examples:
  - name: Updates an autoscale setting. (autogenerated)
    text: az monitor autoscale-settings update --name MyAutoscaleSetting --resource-group MyResourceGroup --set retentionPolicy.days=365
    crafted: true
"""

helps['monitor diagnostic-settings'] = """
type: group
short-summary: Manage service diagnostic settings.
"""

helps['monitor diagnostic-settings categories'] = """
type: group
short-summary: Retrieve service diagnostic settings categories.
"""

helps['monitor diagnostic-settings categories list'] = """
type: command
short-summary:  List the diagnostic settings categories for the specified resource.
examples:
  - name: List diagnostic settings categories by using resource ID
    text: az monitor diagnostic-settings categories list --resource /subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myRG/providers/microsoft.logic/workflows/myWorkflow
  - name: List diagnostic settings categories by using resource name
    text: az monitor diagnostic-settings categories list -g myRG --resource-type microsoft.logic/workflows --resource myWorkflow

"""

helps['monitor diagnostic-settings create'] = """
type: command
short-summary: Create diagnostic settings for the specified resource.
long-summary: >
    For more information, visit: https://docs.microsoft.com/rest/api/monitor/diagnosticsettings/createorupdate#metricsettings
parameters:
  - name: --name -n
    short-summary: The name of the diagnostic settings.
  - name: --resource-group -g
    type: string
    short-summary: Name of the resource group for the Log Analytics and Storage Account when the name of the service instead of a full resource ID is given.
  - name: --logs
    type: string
    short-summary: JSON encoded list of logs settings. Use '@{file}' to load from a file.
  - name: --metrics
    type: string
    short-summary: JSON encoded list of metric settings. Use '@{file}' to load from a file.
  - name: --storage-account
    type: string
    short-summary: Name or ID of the storage account to send diagnostic logs to.
  - name: --workspace
    type: string
    short-summary: Name or ID of the Log Analytics workspace to send diagnostic logs to.
  - name: --event-hub
    type: string
    short-summary: >
        Name or ID an event hub. If none is specified, the default event hub will be selected.
  - name: --event-hub-rule
    short-summary: Name or ID of the event hub authorization rule.
examples:
  - name: Create diagnostic settings with EventHub.
    text: |
        az monitor diagnostic-settings create --resource {ID} -n {name}
           --event-hub-rule {eventHubRuleID} --storage-account {storageAccount}
           --logs '[
             {
               "category": "WorkflowRuntime",
               "enabled": true,
               "retentionPolicy": {
                 "enabled": false,
                 "days": 0
               }
             }
           ]'
           --metrics '[
             {
               "category": "WorkflowRuntime",
               "enabled": true,
               "retentionPolicy": {
                 "enabled": false,
                 "days": 0
               }
             }
           ]'
"""

helps['monitor diagnostic-settings update'] = """
type: command
short-summary: Update diagnostic settings.
examples:
  - name: Update diagnostic settings. (autogenerated)
    text: az monitor diagnostic-settings update --name MyDiagnosticSetting --resource myScaleSet --set retentionPolicy.days=365
    crafted: true
"""

helps['monitor log-analytics'] = """
type: group
short-summary: Manage Azure log analytics
"""

helps['monitor log-analytics workspace'] = """
type: group
short-summary: Manage Azure log analytics workspace
"""

helps['monitor log-analytics workspace create'] = """
type: command
short-summary: Create a workspace instance
examples:
  - name: Create a workspace instance
    text: az monitor log-analytics workspace create -g MyResourceGroup -n MyWorkspace
"""

helps['monitor log-analytics workspace delete'] = """
type: command
short-summary: Delete a workspace instance.
"""

helps['monitor log-analytics workspace get-schema'] = """
type: command
short-summary: Get the schema for a given workspace.
long-summary: >
    Schema represents the internal structure of the workspace, which can be used during the query.
    For more information, visit: https://docs.microsoft.com/en-us/rest/api/loganalytics/workspaces%202015-03-20/getschema
"""

helps['monitor log-analytics workspace get-shared-keys'] = """
type: command
short-summary: Get the shared keys for a workspace.
"""

helps['monitor log-analytics workspace list'] = """
type: command
short-summary: Get a list of workspaces under a resource group or a subscription.
"""

helps['monitor log-analytics workspace list-management-groups'] = """
type: command
short-summary: Get a list of management groups connected to a workspace.
"""

helps['monitor log-analytics workspace list-usages'] = """
type: command
short-summary: Get a list of usage metrics for a workspace.
"""

helps['monitor log-analytics workspace pack'] = """
type: group
short-summary: Manage intelligent packs for log analytics workspace.
"""

helps['monitor log-analytics workspace pack disable'] = """
type: command
short-summary: Disable an intelligence pack for a given workspace.
"""

helps['monitor log-analytics workspace pack enable'] = """
type: command
short-summary: Enable an intelligence pack for a given workspace.
"""

helps['monitor log-analytics workspace pack list'] = """
type: command
short-summary: List all the intelligence packs possible and whether they are enabled or disabled for a given workspace.
"""

helps['monitor log-analytics workspace show'] = """
type: command
short-summary: Show a workspace instance.
"""

helps['monitor log-analytics workspace update'] = """
type: command
short-summary: Update a workspace instance
"""

helps['monitor log-profiles'] = """
type: group
short-summary: Manage log profiles.
"""

helps['monitor log-profiles create'] = """
type: command
short-summary: Create a log profile.
parameters:
  - name: --name -n
    short-summary: The name of the log profile.
  - name: --locations
    short-summary: Space-separated list of regions for which Activity Log events should be stored.
  - name: --categories
    short-summary: Space-separated categories of the logs. These categories are created as is convenient to the user. Some values are Write, Delete, and/or Action.
  - name: --storage-account-id
    short-summary: The resource id of the storage account to which you would like to send the Activity Log.
  - name: --service-bus-rule-id
    short-summary: The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format '{service bus resource ID}/authorizationrules/{key name}'.
  - name: --days
    short-summary: The number of days for the retention in days. A value of 0 will retain the events indefinitely
  - name: --enabled
    short-summary: Whether the retention policy is enabled.
examples:
  - name: Create a log profile. (autogenerated)
    text: |
        az monitor log-profiles create --categories "Delete" --days 0 --enabled true --location westus2 --locations westus --name MyLogProfile --service-bus-rule-id "/subscriptions/{YOUR SUBSCRIPTION ID}/resourceGroups/{RESOURCE GROUP NAME}/providers/Microsoft.EventHub/namespaces/{EVENT HUB NAME SPACE}/authorizationrules/RootManageSharedAccessKey"
    crafted: true
"""

helps['monitor log-profiles update'] = """
type: command
short-summary: Update a log profile.
examples:
  - name: Update a log profile. (autogenerated)
    text: az monitor log-profiles update --name MyLogProfile --set retentionPolicy.days=365
    crafted: true
"""

helps['monitor metrics'] = """
type: group
short-summary: View Azure resource metrics.
"""

helps['monitor metrics alert'] = """
type: group
short-summary: Manage near-realtime metric alert rules.
"""

helps['monitor metrics alert create'] = """
type: command
short-summary: Create a metric-based alert rule.
parameters:
  - name: --action -a
    short-summary: Add an action group and optional webhook properties to fire when the alert is triggered.
    long-summary: |
        Usage:   --action ACTION_GROUP_NAME_OR_ID [KEY=VAL [KEY=VAL ...]]

        Multiple action groups can be specified by using more than one `--action` argument.
  - name: --disabled
    short-summary: Create the rule in a disabled state.
  - name: --condition
    short-summary: The condition which triggers the rule.
    long-summary: |
        Usage:  --condition {avg,min,max,total,count} [NAMESPACE.]METRIC {=,!=,>,>=,<,<=} THRESHOLD
                           [where DIMENSION {includes,excludes} VALUE [or VALUE ...]
                           [and   DIMENSION {includes,excludes} VALUE [or VALUE ...] ...]]

        Dimensions can be queried by adding the 'where' keyword and multiple dimensions can be queried by combining them with the 'and' keyword.

        Values for METRIC, DIMENSION and appropriate THRESHOLD values can be obtained from `az monitor metrics list-definitions` command.

        Multiple conditions can be specified by using more than one `--condition` argument.
examples:
  - name: Create a high CPU usage alert on a VM with no actions.
    text: >
        az monitor metrics alert create -n alert1 -g {ResourceGroup} --scopes {VirtualMachineID} --condition "avg Percentage CPU > 90" --description "High CPU"
  - name: Create a high CPU usage alert on a VM with email and webhook actions.
    text: |
        az monitor metrics alert create -n alert1 -g {ResourceGroup} --scopes {VirtualMachineID} \\
            --condition "avg Percentage CPU > 90" --window-size 5m --evaluation-frequency 1m \\
            --action {actionGroupId} apiKey={APIKey} type=HighCPU --description "High CPU"
  - name: Create an alert when a storage account shows a high number of slow transactions, using multi-dimensional filters.
    text: |
        az monitor metrics alert create -g {ResourceGroup} -n alert1 --scopes {StorageAccountId} \\
            --description "Storage Slow Transactions" \\
            --condition "total transactions > 5 where ResponseType includes Success" \\
            --condition "avg SuccessE2ELatency > 250 where ApiName includes GetBlob or PutBlob"
"""

helps['monitor metrics alert delete'] = """
type: command
short-summary: Delete a metrics-based alert rule.
examples:
  - name: Delete a metrics-based alert rule. (autogenerated)
    text: az monitor metrics alert delete --name MyAlertRule --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor metrics alert list'] = """
type: command
short-summary: List metric-based alert rules.
examples:
  - name: List metric-based alert rules. (autogenerated)
    text: az monitor metrics alert list --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor metrics alert show'] = """
type: command
short-summary: Show a metrics-based alert rule.
examples:
  - name: Show a metrics-based alert rule. (autogenerated)
    text: az monitor metrics alert show --name MyAlertRule --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor metrics alert update'] = """
type: command
short-summary: Update a metric-based alert rule.
parameters:
  - name: --add-condition
    short-summary: Add a condition which triggers the rule.
    long-summary: |
        Usage:  --add-condition {avg,min,max,total,count} [NAMESPACE.]METRIC {=,!=,>,>=,<,<=} THRESHOLD
                               [where DIMENSION {includes,excludes} VALUE [or VALUE ...]
                               [and   DIMENSION {includes,excludes} VALUE [or VALUE ...] ...]]

        Dimensions can be queried by adding the 'where' keyword and multiple dimensions can be queried by combining them with the 'and' keyword.

        Values for METRIC, DIMENSION and appropriate THRESHOLD values can be obtained from `az monitor metrics list-definitions` command.

        Multiple conditions can be specified by using more than one `--condition` argument.
  - name: --remove-conditions
    short-summary: Space-separated list of condition names to remove.
  - name: --add-action
    short-summary: Add an action group and optional webhook properties to fire when the alert is triggered.
    long-summary: |
        Usage:   --add-action ACTION_GROUP_NAME_OR_ID [KEY=VAL [KEY=VAL ...]]

        Multiple action groups can be specified by using more than one `--action` argument.
  - name: --remove-actions
    short-summary: Space-separated list of action group names to remove.
examples:
  - name: Update a metric-based alert rule. (autogenerated)
    text: az monitor metrics alert update --enabled true --name MyAlertRule --resource-group MyResourceGroup
    crafted: true
"""

helps['monitor metrics list'] = """
type: command
short-summary: List the metric values for a resource.
parameters:
  - name: --aggregation
    short-summary: The list of aggregation types (space-separated) to retrieve.
    populator-commands:
      - az monitor metrics list-definitions
  - name: --interval
    short-summary: >
        The interval over which to aggregate metrics, in ##h##m format.
  - name: --filter
    short-summary: A string used to reduce the set of metric data returned. eg. "BlobType eq '*'"
    long-summary: 'For a full list of filters, see the filter string reference at https://docs.microsoft.com/rest/api/monitor/metrics/list'
  - name: --metadata
    short-summary: Returns the metadata values instead of metric data
  - name: --dimension
    short-summary: The list of dimensions (space-separated) the metrics are queried into.
    populator-commands:
      - az monitor metrics list-definitions
  - name: --namespace
    short-summary: Namespace to query metric definitions for.
    populator-commands:
      - az monitor metrics list-definitions
  - name: --offset
    short-summary: >
        Time offset of the query range, in ##d##h format.
    long-summary: >
        Can be used with either --start-time or --end-time. If used with --start-time, then
        the end time will be calculated by adding the offset. If used with --end-time (default), then
        the start time will be calculated by subtracting the offset. If --start-time and --end-time are
        provided, then --offset will be ignored.
  - name: --metrics
    short-summary: >
        Space-separated list of metric names to retrieve.
    populator-commands:
      - az monitor metrics list-definitions

examples:
  - name: List a VM's CPU usage for the past hour
    text: >
        az monitor metrics list --resource {ResourceName} --metric "Percentage CPU"
  - name: List success E2E latency of a storage account and split the data series based on API name
    text: >
        az monitor metrics list --resource {ResourceName} --metric SuccessE2ELatency \\
                                --dimension ApiName
  - name: List success E2E latency of a storage account and split the data series based on both API name and geo type
    text: >
        az monitor metrics list --resource {ResourceName} --metric SuccessE2ELatency \\
                                --dimension ApiName GeoType
  - name: List success E2E latency of a storage account and split the data series based on both API name and geo type using "--filter" parameter
    text: >
        az monitor metrics list --resource {ResourceName} --metric SuccessE2ELatency \\
                                --filter "ApiName eq '*' and GeoType eq '*'"
  - name: List success E2E latency of a storage account and split the data series based on both API name and geo type. Limits the api name to 'DeleteContainer'
    text: >
        az monitor metrics list --resource {ResourceName} --metric SuccessE2ELatency \\
                                --filter "ApiName eq 'DeleteContainer' and GeoType eq '*'"
  - name: List transactions of a storage account per day since 2017-01-01
    text: >
        az monitor metrics list --resource {ResourceName} --metric Transactions \\
                                --start-time 2017-01-01T00:00:00Z \\
                                --interval PT24H
  - name: List the metadata values for a storage account under transaction metric's api name dimension since 2017
    text: >
        az monitor metrics list --resource {ResourceName} --metric Transactions \\
                                --filter "ApiName eq '*'" \\
                                --start-time 2017-01-01T00:00:00Z
"""

helps['monitor metrics list-definitions'] = """
type: command
short-summary: Lists the metric definitions for the resource.
examples:
  - name: Lists the metric definitions for the resource. (autogenerated)
    text: az monitor metrics list-definitions --resource /subscriptions/{subscriptionID}/resourceGroups/Space1999/providers/Microsoft.Network/networkSecurityGroups/ADDS-NSG
    crafted: true
"""
