
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsebus.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bsebus.hh>
#include <bse/bsetrack.hh>
#include <bse/bsesong.hh>
#include <bse/bseundostack.hh>
/* --- connect-track --- */
static void
connect_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 10 "bsebus.proc"
 {
#line 12 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("sbus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", NULL, NULL, BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 17 "bsebus.proc"
 }
static BseErrorType
#line 17 "bsebus.proc"
connect_track_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 20 "bsebus.proc"
{
#line 21 "bsebus.proc"
  
  BseBus *self = (BseBus*) bse_value_get_object (in_values++);
  BseTrack *track = (BseTrack*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 25 "bsebus.proc"
  
  if (!BSE_IS_BUS (self) || !BSE_IS_TRACK (track))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 28 "bsebus.proc"
  
  if (!BSE_ITEM (self)->parent || BSE_ITEM (self)->parent != BSE_ITEM (track)->parent)
    error = BSE_ERROR_SOURCE_PARENT_MISMATCH;
  else
    {
      error = bse_bus_connect (self, BSE_ITEM (track));
      if (!error)
        bse_item_push_undo_proc (self, "disconnect-track", track);
    }
#line 37 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- disconnect-track --- */
static void
disconnect_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 41 "bsebus.proc"
 {
#line 43 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("sbus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", NULL, NULL, BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 48 "bsebus.proc"
 }
static BseErrorType
#line 48 "bsebus.proc"
disconnect_track_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 51 "bsebus.proc"
{
#line 52 "bsebus.proc"
  
  BseBus *self = (BseBus*) bse_value_get_object (in_values++);
  BseTrack *track = (BseTrack*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 56 "bsebus.proc"
  
  if (!BSE_IS_BUS (self) || !BSE_IS_TRACK (track))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 59 "bsebus.proc"
  
  if (!BSE_ITEM (self)->parent || BSE_ITEM (self)->parent != BSE_ITEM (track)->parent)
    error = BSE_ERROR_SOURCE_PARENT_MISMATCH;
  else
    {
      error = bse_bus_disconnect (self, BSE_ITEM (track));
      if (!error)
        bse_item_push_undo_proc (self, "connect-track", track);
    }
#line 68 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- connect-bus --- */
static void
connect_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 72 "bsebus.proc"
 {
#line 74 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("sbus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 79 "bsebus.proc"
 }
static BseErrorType
#line 79 "bsebus.proc"
connect_bus_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 82 "bsebus.proc"
{
#line 83 "bsebus.proc"
  
  BseBus *self = (BseBus*) bse_value_get_object (in_values++);
  BseBus *bus = (BseBus*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 87 "bsebus.proc"
  
  if (!BSE_IS_BUS (self) || !BSE_IS_BUS (bus))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 90 "bsebus.proc"
  
  if (!BSE_ITEM (self)->parent || BSE_ITEM (self)->parent != BSE_ITEM (bus)->parent)
    error = BSE_ERROR_SOURCE_PARENT_MISMATCH;
  else
    {
      error = bse_bus_connect (self, BSE_ITEM (bus));
      if (!error)
        bse_item_push_undo_proc (self, "disconnect-bus", bus);
    }
#line 99 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- disconnect-bus --- */
static void
disconnect_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 103 "bsebus.proc"
 {
#line 105 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("sbus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 110 "bsebus.proc"
 }
static BseErrorType
#line 110 "bsebus.proc"
disconnect_bus_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 113 "bsebus.proc"
{
#line 114 "bsebus.proc"
  
  BseBus *self = (BseBus*) bse_value_get_object (in_values++);
  BseBus *bus = (BseBus*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 118 "bsebus.proc"
  
  if (!BSE_IS_BUS (self) || !BSE_IS_BUS (bus))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 121 "bsebus.proc"
  
  if (!BSE_ITEM (self)->parent || BSE_ITEM (self)->parent != BSE_ITEM (bus)->parent)
    error = BSE_ERROR_SOURCE_PARENT_MISMATCH;
  else
    {
      error = bse_bus_disconnect (self, BSE_ITEM (bus));
      if (!error)
        bse_item_push_undo_proc (self, "connect-bus", bus);
    }
#line 130 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- ensure-output --- */
static void
ensure_output_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 134 "bsebus.proc"
 {
#line 136 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 140 "bsebus.proc"
 }
static BseErrorType
#line 140 "bsebus.proc"
ensure_output_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 143 "bsebus.proc"
{
#line 144 "bsebus.proc"
  
  BseBus *self = (BseBus*) bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 147 "bsebus.proc"
  
  if (!BSE_IS_BUS (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 150 "bsebus.proc"
  
  BseItem *parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent) && !self->bus_outputs)
    {
      BseSong *song = BSE_SONG (parent);
      BseBus *master = bse_song_find_master (song);
      if (master && self != master)
        {
          error = bse_bus_connect (master, BSE_ITEM (self));
          if (!error)
            bse_item_push_undo_proc (master, "disconnect-bus", self);
        }
    }
#line 163 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_connect_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Add a track to the input list of a bus.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 11;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_connect_track = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseBus+connect-track", 
    NULL,
    "/Methods/BseBus/General/Connect Track",
    NULL,
    __enode_connect_track__fill_strings,
  },
  0, connect_track_setup, connect_track_exec, 
};
static void
__enode_disconnect_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Remove a track from the input list of a bus.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 42;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_disconnect_track = {
  { (BseExportNode*) &__enode_connect_track, BSE_EXPORT_NODE_PROC,
    "BseBus+disconnect-track", 
    NULL,
    "/Methods/BseBus/General/Disconnect Track",
    NULL,
    __enode_disconnect_track__fill_strings,
  },
  0, disconnect_track_setup, disconnect_track_exec, 
};
static void
__enode_connect_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Add a bus to the input list of a bus.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 73;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_connect_bus = {
  { (BseExportNode*) &__enode_disconnect_track, BSE_EXPORT_NODE_PROC,
    "BseBus+connect-bus", 
    NULL,
    "/Methods/BseBus/General/Connect Bus",
    NULL,
    __enode_connect_bus__fill_strings,
  },
  0, connect_bus_setup, connect_bus_exec, 
};
static void
__enode_disconnect_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Remove a bus from the input list of a bus.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 104;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_disconnect_bus = {
  { (BseExportNode*) &__enode_connect_bus, BSE_EXPORT_NODE_PROC,
    "BseBus+disconnect-bus", 
    NULL,
    "/Methods/BseBus/General/Disconnect Bus",
    NULL,
    __enode_disconnect_bus__fill_strings,
  },
  0, disconnect_bus_setup, disconnect_bus_exec, 
};
static void
__enode_ensure_output__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Ensure that a bus has an output connection.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 135;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_ensure_output = {
  { (BseExportNode*) &__enode_disconnect_bus, BSE_EXPORT_NODE_PROC,
    "BseBus+ensure-output", 
    NULL,
    "/Methods/BseBus/General/Ensure Output",
    NULL,
    __enode_ensure_output__fill_strings,
  },
  0, ensure_output_setup, ensure_output_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsebus_genprc_cc (void)
{
  return (BseExportNode*) &__enode_ensure_output;
}

/*
 * Generated data ends here
 */
