###########################################################
#
# Licensed Material - Property of IBM
#
# BogoSec - Source Code Security Quality Metric Calculator
#
# (C) Copyright IBM Corp. 2004-2008
#
# HISTORY:
#	07/2004 originated by Tony Petz (petz.agoston@gmail.com)
#	07/2004 Dustin Kirkland (dustin.kirkland@us.ibm.com) - consistency improvements
#	01/2005 Loulwa Salem (loulwa@us.ibm.com) - added does_compile() 
#	01/2005 Loulwa Salem (loulwa@us.ibm.com) - Changed global variable to all CAPS
#	07/2005 Loulwa Salem - Code to exclude vulnerabilities and track their type
###########################################################

package BogoITS4;

use strict;
use File::Temp;

my $SCANNER = "its4";
my $DEFAULT_ARGS = "--severity-cutoff=1";
my @RESULTS = ();

sub exists() {
	`which $SCANNER`;
	my $exists = !$?;
	if (!$exists) {
		print "Warning: cannot find $SCANNER binary (please include location in PATH if you wish to use it)\n";
		return undef;
	}
	return 1;
}

# this function simply returns 1 if scanner is compiler based, and 0 otherwise.
sub does_compile() {
        return 0;
}

sub get_args() {
	return $DEFAULT_ARGS;
}

sub name() {
	return $SCANNER;
}

sub analyze($$$$) {
	my ($logfile, $target, $sev_range_max, $ex_vuln) = @_;
	my $sloc = undef;
	my $ignore = undef;

	my @Excl_vuln = split(/:/, $ex_vuln);

# open temp file
	open(FH, $logfile);

	foreach (<FH>) {
		if (m/^$target.*:[0-9]+:\(.*\)/) {
			chomp;
			my @temp = split(/:/);
			($temp[2], $temp[3]) = $temp[2] =~ m/\((.*)\)\s*(.*)/;
# The statement below handles case where there are >2 fields in temp[2]
# it splits the line and puts the vulnerability found in variable temp[3]
# example record: <filename>:line:(Low Risk) sprintf (see above)
			if ($temp[3] eq '') {
				($temp[2], $temp[3]) = $temp[2] =~ m/(.*)\)\s*(.*)\s\((.*)/;
			}
			foreach my $vuln (@Excl_vuln) {
				if ($vuln eq $temp[3]) {
					#print "ITS: Ignoring $temp[3]\n";
					$ignore = 1;
					last;
				}
			}
			if ($ignore==undef) {
				$temp[2] = calc_score($temp[2],$sev_range_max);
			} else {
				$temp[2] = 0;
			}
			my $temp = join(":", @temp);
			push(@RESULTS, $temp);
		}
	$ignore = undef;
	}
# push SLOC onto front of results array
	unshift @RESULTS, $sloc;
	close(FH);
	return \@RESULTS;
}

sub calc_score($$) {
	($_, my $max) = @_;
	if ( m/^Low Risk$/i ) {
		return (1/5) * $max;
	}
	if ( m/^Some risk$/i ) {
		return (2/5) * $max;
	}
	if ( m/^Risky$/i ) {
		return (3/5) * $max;
	}
	if ( m/^Very Risky$/i ) {
		return (4/5) * $max;
	}
	if ( m/^Urgent$/i ) {
		return $max;
	}
	return 0;
}

sub debug {
	foreach (@RESULTS) {
		print "$_\n";
	}
}

1;
