#ifndef __cmtk_NrrdIO_mangle_h
#define __cmtk_NrrdIO_mangle_h

/*

This header file mangles all symbols exported from the
NrrdIO library. It is included in all files while building
the NrrdIO library.  Due to namespace pollution, no NrrdIO
headers should be included in .h files in CMTK.

This file was created via the mangle.pl script in the
NrrdIO distribution:

  perl mangle.pl cmtk > cmtk_NrrdIO_mangle.h

This uses nm to list all text (T), data (D) symbols, as well
read-only (R) things (seen on Linux) and "other" (S) things
(seen on Mac).  On Macs, the preceeding underscore is removed.
*/

/*
 * Modified 11-Apr-2011 by Torsten Rohlfing for CMTK, 
 * (C) 2011 SRI International
 */


#define airExists cmtk_airExists
#define airFPClass_d cmtk_airFPClass_d
#define airFPClass_f cmtk_airFPClass_f
#define airFPFprintf_d cmtk_airFPFprintf_d
#define airFPFprintf_f cmtk_airFPFprintf_f
#define airFPGen_d cmtk_airFPGen_d
#define airFPGen_f cmtk_airFPGen_f
#define airFPPartsToVal_d cmtk_airFPPartsToVal_d
#define airFPPartsToVal_f cmtk_airFPPartsToVal_f
#define airFPValToParts_d cmtk_airFPValToParts_d
#define airFPValToParts_f cmtk_airFPValToParts_f
#define airFloatNegInf cmtk_airFloatNegInf
#define airFloatPosInf cmtk_airFloatPosInf
#define airFloatQNaN cmtk_airFloatQNaN
#define airFloatSNaN cmtk_airFloatSNaN
#define airIsInf_d cmtk_airIsInf_d
#define airIsInf_f cmtk_airIsInf_f
#define airIsNaN cmtk_airIsNaN
#define airMyQNaNHiBit cmtk_airMyQNaNHiBit
#define airNaN cmtk_airNaN
#define _airMopPrint cmtk__airMopPrint
#define _airMopWhenStr cmtk__airMopWhenStr
#define airMopAdd cmtk_airMopAdd
#define airMopDebug cmtk_airMopDebug
#define airMopDone cmtk_airMopDone
#define airMopError cmtk_airMopError
#define airMopMem cmtk_airMopMem
#define airMopNew cmtk_airMopNew
#define airMopOkay cmtk_airMopOkay
#define airMopPrint cmtk_airMopPrint
#define airMopSub cmtk_airMopSub
#define airMopUnMem cmtk_airMopUnMem
#define _airLenSet cmtk__airLenSet
#define _airSetData cmtk__airSetData
#define airArrayLenIncr cmtk_airArrayLenIncr
#define airArrayLenPreSet cmtk_airArrayLenPreSet
#define airArrayLenSet cmtk_airArrayLenSet
#define airArrayNew cmtk_airArrayNew
#define airArrayNix cmtk_airArrayNix
#define airArrayNuke cmtk_airArrayNuke
#define airArrayPointerCB cmtk_airArrayPointerCB
#define airArrayStructCB cmtk_airArrayStructCB
#define _airBool cmtk__airBool
#define _airBoolDesc cmtk__airBoolDesc
#define _airBoolStr cmtk__airBoolStr
#define _airBoolStrEqv cmtk__airBoolStrEqv
#define _airBoolVal cmtk__airBoolVal
#define _airBoolValEqv cmtk__airBoolValEqv
#define airAtod cmtk_airAtod
#define airBool cmtk_airBool
#define airParseStr cmtk_airParseStr
#define airParseStrB cmtk_airParseStrB
#define airParseStrC cmtk_airParseStrC
#define airParseStrD cmtk_airParseStrD
#define airParseStrE cmtk_airParseStrE
#define airParseStrF cmtk_airParseStrF
#define airParseStrI cmtk_airParseStrI
#define airParseStrLI cmtk_airParseStrLI
#define airParseStrS cmtk_airParseStrS
#define airParseStrUI cmtk_airParseStrUI
#define airParseStrZ cmtk_airParseStrZ
#define airSingleSscanf cmtk_airSingleSscanf
#define _airNoDioErr cmtk__airNoDioErr
#define airDioInfo cmtk_airDioInfo
#define airDioMalloc cmtk_airDioMalloc
#define airDioRead cmtk_airDioRead
#define airDioTest cmtk_airDioTest
#define airDioWrite cmtk_airDioWrite
#define airDisableDio cmtk_airDisableDio
#define airMyDio cmtk_airMyDio
#define airNoDioErr cmtk_airNoDioErr
#define _airBadInsane cmtk__airBadInsane
#define _airInsaneErr cmtk__airInsaneErr
#define airInsaneErr cmtk_airInsaneErr
#define airSanity cmtk_airSanity
#define _airEndian cmtk__airEndian
#define _airEndianDesc cmtk__airEndianDesc
#define _airEndianStr cmtk__airEndianStr
#define _airEndianVal cmtk__airEndianVal
#define airEndian cmtk_airEndian
#define airMyEndian cmtk_airMyEndian
#define airEndsWith cmtk_airEndsWith
#define airOneLine cmtk_airOneLine
#define airOneLinify cmtk_airOneLinify
#define airStrdup cmtk_airStrdup
#define airStrlen cmtk_airStrlen
#define airStrntok cmtk_airStrntok
#define airStrtok cmtk_airStrtok
#define airStrtokQuoting cmtk_airStrtokQuoting
#define airStrtrans cmtk_airStrtrans
#define airToLower cmtk_airToLower
#define airToUpper cmtk_airToUpper
#define airUnescape cmtk_airUnescape
#define _airEnumIndex cmtk__airEnumIndex
#define _enumPrintVal cmtk__enumPrintVal
#define airEnumDesc cmtk_airEnumDesc
#define airEnumFmtDesc cmtk_airEnumFmtDesc
#define airEnumLast cmtk_airEnumLast
#define airEnumPrint cmtk_airEnumPrint
#define airEnumStr cmtk_airEnumStr
#define airEnumUnknown cmtk_airEnumUnknown
#define airEnumVal cmtk_airEnumVal
#define airEnumValCheck cmtk_airEnumValCheck
#define _airSanityHelper cmtk__airSanityHelper
#define airFclose cmtk_airFclose
#define airFopen cmtk_airFopen
#define airFree cmtk_airFree
#define airMy32Bit cmtk_airMy32Bit
#define airNull cmtk_airNull
#define airSetNull cmtk_airSetNull
#define airSinglePrintf cmtk_airSinglePrintf
#define airTeemReleaseDate cmtk_airTeemReleaseDate
#define airTeemVersion cmtk_airTeemVersion
#define _bmsg cmtk__bmsg
#define _bmsgAdd cmtk__bmsgAdd
#define _bmsgArr cmtk__bmsgArr
#define _bmsgFind cmtk__bmsgFind
#define _bmsgFindIdx cmtk__bmsgFindIdx
#define _bmsgFinish cmtk__bmsgFinish
#define _bmsgNum cmtk__bmsgNum
#define _bmsgStart cmtk__bmsgStart
#define biffAdd cmtk_biffAdd
#define biffAddVL cmtk_biffAddVL
#define biffAddf cmtk_biffAddf
#define biffCheck cmtk_biffCheck
#define biffDone cmtk_biffDone
#define biffGet cmtk_biffGet
#define biffGetDone cmtk_biffGetDone
#define biffGetStrlen cmtk_biffGetStrlen
#define biffMaybeAdd cmtk_biffMaybeAdd
#define biffMaybeAddf cmtk_biffMaybeAddf
#define biffMove cmtk_biffMove
#define biffMoveVL cmtk_biffMoveVL
#define biffMovef cmtk_biffMovef
#define biffSetStr cmtk_biffSetStr
#define biffSetStrDone cmtk_biffSetStrDone
#define _biffMsgNoop cmtk__biffMsgNoop
#define biffMsgAdd cmtk_biffMsgAdd
#define biffMsgAddVL cmtk_biffMsgAddVL
#define biffMsgAddf cmtk_biffMsgAddf
#define biffMsgClear cmtk_biffMsgClear
#define biffMsgLineLenMax cmtk_biffMsgLineLenMax
#define biffMsgMove cmtk_biffMsgMove
#define biffMsgMoveVL cmtk_biffMsgMoveVL
#define biffMsgMovef cmtk_biffMsgMovef
#define biffMsgNew cmtk_biffMsgNew
#define biffMsgNix cmtk_biffMsgNix
#define biffMsgNoop cmtk_biffMsgNoop
#define biffMsgStrAlloc cmtk_biffMsgStrAlloc
#define biffMsgStrGet cmtk_biffMsgStrGet
#define biffMsgStrSet cmtk_biffMsgStrSet
#define biffMsgStrlen cmtk_biffMsgStrlen
#define _nrrdInsertDBCH cmtk__nrrdInsertDBCH
#define _nrrdInsertDBDB cmtk__nrrdInsertDBDB
#define _nrrdInsertDBFL cmtk__nrrdInsertDBFL
#define _nrrdInsertDBJN cmtk__nrrdInsertDBJN
#define _nrrdInsertDBLL cmtk__nrrdInsertDBLL
#define _nrrdInsertDBSH cmtk__nrrdInsertDBSH
#define _nrrdInsertDBUC cmtk__nrrdInsertDBUC
#define _nrrdInsertDBUI cmtk__nrrdInsertDBUI
#define _nrrdInsertDBUL cmtk__nrrdInsertDBUL
#define _nrrdInsertDBUS cmtk__nrrdInsertDBUS
#define _nrrdInsertFLCH cmtk__nrrdInsertFLCH
#define _nrrdInsertFLDB cmtk__nrrdInsertFLDB
#define _nrrdInsertFLFL cmtk__nrrdInsertFLFL
#define _nrrdInsertFLJN cmtk__nrrdInsertFLJN
#define _nrrdInsertFLLL cmtk__nrrdInsertFLLL
#define _nrrdInsertFLSH cmtk__nrrdInsertFLSH
#define _nrrdInsertFLUC cmtk__nrrdInsertFLUC
#define _nrrdInsertFLUI cmtk__nrrdInsertFLUI
#define _nrrdInsertFLUL cmtk__nrrdInsertFLUL
#define _nrrdInsertFLUS cmtk__nrrdInsertFLUS
#define _nrrdInsertJNCH cmtk__nrrdInsertJNCH
#define _nrrdInsertJNDB cmtk__nrrdInsertJNDB
#define _nrrdInsertJNFL cmtk__nrrdInsertJNFL
#define _nrrdInsertJNJN cmtk__nrrdInsertJNJN
#define _nrrdInsertJNLL cmtk__nrrdInsertJNLL
#define _nrrdInsertJNSH cmtk__nrrdInsertJNSH
#define _nrrdInsertJNUC cmtk__nrrdInsertJNUC
#define _nrrdInsertJNUI cmtk__nrrdInsertJNUI
#define _nrrdInsertJNUL cmtk__nrrdInsertJNUL
#define _nrrdInsertJNUS cmtk__nrrdInsertJNUS
#define _nrrdInsertUICH cmtk__nrrdInsertUICH
#define _nrrdInsertUIDB cmtk__nrrdInsertUIDB
#define _nrrdInsertUIFL cmtk__nrrdInsertUIFL
#define _nrrdInsertUIJN cmtk__nrrdInsertUIJN
#define _nrrdInsertUILL cmtk__nrrdInsertUILL
#define _nrrdInsertUISH cmtk__nrrdInsertUISH
#define _nrrdInsertUIUC cmtk__nrrdInsertUIUC
#define _nrrdInsertUIUI cmtk__nrrdInsertUIUI
#define _nrrdInsertUIUL cmtk__nrrdInsertUIUL
#define _nrrdInsertUIUS cmtk__nrrdInsertUIUS
#define _nrrdLoadDBCH cmtk__nrrdLoadDBCH
#define _nrrdLoadDBDB cmtk__nrrdLoadDBDB
#define _nrrdLoadDBFL cmtk__nrrdLoadDBFL
#define _nrrdLoadDBJN cmtk__nrrdLoadDBJN
#define _nrrdLoadDBLL cmtk__nrrdLoadDBLL
#define _nrrdLoadDBSH cmtk__nrrdLoadDBSH
#define _nrrdLoadDBUC cmtk__nrrdLoadDBUC
#define _nrrdLoadDBUI cmtk__nrrdLoadDBUI
#define _nrrdLoadDBUL cmtk__nrrdLoadDBUL
#define _nrrdLoadDBUS cmtk__nrrdLoadDBUS
#define _nrrdLoadFLCH cmtk__nrrdLoadFLCH
#define _nrrdLoadFLDB cmtk__nrrdLoadFLDB
#define _nrrdLoadFLFL cmtk__nrrdLoadFLFL
#define _nrrdLoadFLJN cmtk__nrrdLoadFLJN
#define _nrrdLoadFLLL cmtk__nrrdLoadFLLL
#define _nrrdLoadFLSH cmtk__nrrdLoadFLSH
#define _nrrdLoadFLUC cmtk__nrrdLoadFLUC
#define _nrrdLoadFLUI cmtk__nrrdLoadFLUI
#define _nrrdLoadFLUL cmtk__nrrdLoadFLUL
#define _nrrdLoadFLUS cmtk__nrrdLoadFLUS
#define _nrrdLoadJNCH cmtk__nrrdLoadJNCH
#define _nrrdLoadJNDB cmtk__nrrdLoadJNDB
#define _nrrdLoadJNFL cmtk__nrrdLoadJNFL
#define _nrrdLoadJNJN cmtk__nrrdLoadJNJN
#define _nrrdLoadJNLL cmtk__nrrdLoadJNLL
#define _nrrdLoadJNSH cmtk__nrrdLoadJNSH
#define _nrrdLoadJNUC cmtk__nrrdLoadJNUC
#define _nrrdLoadJNUI cmtk__nrrdLoadJNUI
#define _nrrdLoadJNUL cmtk__nrrdLoadJNUL
#define _nrrdLoadJNUS cmtk__nrrdLoadJNUS
#define _nrrdLoadUICH cmtk__nrrdLoadUICH
#define _nrrdLoadUIDB cmtk__nrrdLoadUIDB
#define _nrrdLoadUIFL cmtk__nrrdLoadUIFL
#define _nrrdLoadUIJN cmtk__nrrdLoadUIJN
#define _nrrdLoadUILL cmtk__nrrdLoadUILL
#define _nrrdLoadUISH cmtk__nrrdLoadUISH
#define _nrrdLoadUIUC cmtk__nrrdLoadUIUC
#define _nrrdLoadUIUI cmtk__nrrdLoadUIUI
#define _nrrdLoadUIUL cmtk__nrrdLoadUIUL
#define _nrrdLoadUIUS cmtk__nrrdLoadUIUS
#define _nrrdLookupDBCH cmtk__nrrdLookupDBCH
#define _nrrdLookupDBDB cmtk__nrrdLookupDBDB
#define _nrrdLookupDBFL cmtk__nrrdLookupDBFL
#define _nrrdLookupDBJN cmtk__nrrdLookupDBJN
#define _nrrdLookupDBLL cmtk__nrrdLookupDBLL
#define _nrrdLookupDBSH cmtk__nrrdLookupDBSH
#define _nrrdLookupDBUC cmtk__nrrdLookupDBUC
#define _nrrdLookupDBUI cmtk__nrrdLookupDBUI
#define _nrrdLookupDBUL cmtk__nrrdLookupDBUL
#define _nrrdLookupDBUS cmtk__nrrdLookupDBUS
#define _nrrdLookupFLCH cmtk__nrrdLookupFLCH
#define _nrrdLookupFLDB cmtk__nrrdLookupFLDB
#define _nrrdLookupFLFL cmtk__nrrdLookupFLFL
#define _nrrdLookupFLJN cmtk__nrrdLookupFLJN
#define _nrrdLookupFLLL cmtk__nrrdLookupFLLL
#define _nrrdLookupFLSH cmtk__nrrdLookupFLSH
#define _nrrdLookupFLUC cmtk__nrrdLookupFLUC
#define _nrrdLookupFLUI cmtk__nrrdLookupFLUI
#define _nrrdLookupFLUL cmtk__nrrdLookupFLUL
#define _nrrdLookupFLUS cmtk__nrrdLookupFLUS
#define _nrrdLookupJNCH cmtk__nrrdLookupJNCH
#define _nrrdLookupJNDB cmtk__nrrdLookupJNDB
#define _nrrdLookupJNFL cmtk__nrrdLookupJNFL
#define _nrrdLookupJNJN cmtk__nrrdLookupJNJN
#define _nrrdLookupJNLL cmtk__nrrdLookupJNLL
#define _nrrdLookupJNSH cmtk__nrrdLookupJNSH
#define _nrrdLookupJNUC cmtk__nrrdLookupJNUC
#define _nrrdLookupJNUI cmtk__nrrdLookupJNUI
#define _nrrdLookupJNUL cmtk__nrrdLookupJNUL
#define _nrrdLookupJNUS cmtk__nrrdLookupJNUS
#define _nrrdLookupUICH cmtk__nrrdLookupUICH
#define _nrrdLookupUIDB cmtk__nrrdLookupUIDB
#define _nrrdLookupUIFL cmtk__nrrdLookupUIFL
#define _nrrdLookupUIJN cmtk__nrrdLookupUIJN
#define _nrrdLookupUILL cmtk__nrrdLookupUILL
#define _nrrdLookupUISH cmtk__nrrdLookupUISH
#define _nrrdLookupUIUC cmtk__nrrdLookupUIUC
#define _nrrdLookupUIUI cmtk__nrrdLookupUIUI
#define _nrrdLookupUIUL cmtk__nrrdLookupUIUL
#define _nrrdLookupUIUS cmtk__nrrdLookupUIUS
#define _nrrdSprintCH cmtk__nrrdSprintCH
#define _nrrdSprintDB cmtk__nrrdSprintDB
#define _nrrdSprintFL cmtk__nrrdSprintFL
#define _nrrdSprintIN cmtk__nrrdSprintIN
#define _nrrdSprintLL cmtk__nrrdSprintLL
#define _nrrdSprintSH cmtk__nrrdSprintSH
#define _nrrdSprintUC cmtk__nrrdSprintUC
#define _nrrdSprintUI cmtk__nrrdSprintUI
#define _nrrdSprintUL cmtk__nrrdSprintUL
#define _nrrdSprintUS cmtk__nrrdSprintUS
#define _nrrdStoreDBCH cmtk__nrrdStoreDBCH
#define _nrrdStoreDBDB cmtk__nrrdStoreDBDB
#define _nrrdStoreDBFL cmtk__nrrdStoreDBFL
#define _nrrdStoreDBJN cmtk__nrrdStoreDBJN
#define _nrrdStoreDBLL cmtk__nrrdStoreDBLL
#define _nrrdStoreDBSH cmtk__nrrdStoreDBSH
#define _nrrdStoreDBUC cmtk__nrrdStoreDBUC
#define _nrrdStoreDBUI cmtk__nrrdStoreDBUI
#define _nrrdStoreDBUL cmtk__nrrdStoreDBUL
#define _nrrdStoreDBUS cmtk__nrrdStoreDBUS
#define _nrrdStoreFLCH cmtk__nrrdStoreFLCH
#define _nrrdStoreFLDB cmtk__nrrdStoreFLDB
#define _nrrdStoreFLFL cmtk__nrrdStoreFLFL
#define _nrrdStoreFLJN cmtk__nrrdStoreFLJN
#define _nrrdStoreFLLL cmtk__nrrdStoreFLLL
#define _nrrdStoreFLSH cmtk__nrrdStoreFLSH
#define _nrrdStoreFLUC cmtk__nrrdStoreFLUC
#define _nrrdStoreFLUI cmtk__nrrdStoreFLUI
#define _nrrdStoreFLUL cmtk__nrrdStoreFLUL
#define _nrrdStoreFLUS cmtk__nrrdStoreFLUS
#define _nrrdStoreJNCH cmtk__nrrdStoreJNCH
#define _nrrdStoreJNDB cmtk__nrrdStoreJNDB
#define _nrrdStoreJNFL cmtk__nrrdStoreJNFL
#define _nrrdStoreJNJN cmtk__nrrdStoreJNJN
#define _nrrdStoreJNLL cmtk__nrrdStoreJNLL
#define _nrrdStoreJNSH cmtk__nrrdStoreJNSH
#define _nrrdStoreJNUC cmtk__nrrdStoreJNUC
#define _nrrdStoreJNUI cmtk__nrrdStoreJNUI
#define _nrrdStoreJNUL cmtk__nrrdStoreJNUL
#define _nrrdStoreJNUS cmtk__nrrdStoreJNUS
#define _nrrdStoreUICH cmtk__nrrdStoreUICH
#define _nrrdStoreUIDB cmtk__nrrdStoreUIDB
#define _nrrdStoreUIFL cmtk__nrrdStoreUIFL
#define _nrrdStoreUIJN cmtk__nrrdStoreUIJN
#define _nrrdStoreUILL cmtk__nrrdStoreUILL
#define _nrrdStoreUISH cmtk__nrrdStoreUISH
#define _nrrdStoreUIUC cmtk__nrrdStoreUIUC
#define _nrrdStoreUIUI cmtk__nrrdStoreUIUI
#define _nrrdStoreUIUL cmtk__nrrdStoreUIUL
#define _nrrdStoreUIUS cmtk__nrrdStoreUIUS
#define nrrdDInsert cmtk_nrrdDInsert
#define nrrdDLoad cmtk_nrrdDLoad
#define nrrdDLookup cmtk_nrrdDLookup
#define nrrdDStore cmtk_nrrdDStore
#define nrrdFInsert cmtk_nrrdFInsert
#define nrrdFLoad cmtk_nrrdFLoad
#define nrrdFLookup cmtk_nrrdFLookup
#define nrrdFStore cmtk_nrrdFStore
#define nrrdIInsert cmtk_nrrdIInsert
#define nrrdILoad cmtk_nrrdILoad
#define nrrdILookup cmtk_nrrdILookup
#define nrrdIStore cmtk_nrrdIStore
#define nrrdSprint cmtk_nrrdSprint
#define nrrdUIInsert cmtk_nrrdUIInsert
#define nrrdUILoad cmtk_nrrdUILoad
#define nrrdUILookup cmtk_nrrdUILookup
#define nrrdUIStore cmtk_nrrdUIStore
#define nrrdDefaultCenter cmtk_nrrdDefaultCenter
#define nrrdDefaultSpacing cmtk_nrrdDefaultSpacing
#define nrrdDefaultWriteBareText cmtk_nrrdDefaultWriteBareText
#define nrrdDefaultWriteCharsPerLine cmtk_nrrdDefaultWriteCharsPerLine
#define nrrdDefaultWriteEncodingType cmtk_nrrdDefaultWriteEncodingType
#define nrrdDefaultWriteValsPerLine cmtk_nrrdDefaultWriteValsPerLine
#define nrrdStateAlwaysSetContent cmtk_nrrdStateAlwaysSetContent
#define nrrdStateDisableContent cmtk_nrrdStateDisableContent
#define nrrdStateGrayscaleImage3D cmtk_nrrdStateGrayscaleImage3D
#define nrrdStateKeyValuePairsPropagate cmtk_nrrdStateKeyValuePairsPropagate
#define nrrdStateKeyValueReturnInternalPointers cmtk_nrrdStateKeyValueReturnInternalPointers
#define nrrdStateKindNoop cmtk_nrrdStateKindNoop
#define nrrdStateUnknownContent cmtk_nrrdStateUnknownContent
#define nrrdStateVerboseIO cmtk_nrrdStateVerboseIO
#define _nrrdCenterDesc cmtk__nrrdCenterDesc
#define _nrrdCenterStr cmtk__nrrdCenterStr
#define _nrrdCenter_enum cmtk__nrrdCenter_enum
#define _nrrdEncodingType cmtk__nrrdEncodingType
#define _nrrdEncodingTypeDesc cmtk__nrrdEncodingTypeDesc
#define _nrrdEncodingTypeStr cmtk__nrrdEncodingTypeStr
#define _nrrdEncodingTypeStrEqv cmtk__nrrdEncodingTypeStrEqv
#define _nrrdEncodingTypeValEqv cmtk__nrrdEncodingTypeValEqv
#define _nrrdField cmtk__nrrdField
#define _nrrdFieldDesc cmtk__nrrdFieldDesc
#define _nrrdFieldStr cmtk__nrrdFieldStr
#define _nrrdFieldStrEqv cmtk__nrrdFieldStrEqv
#define _nrrdFieldValEqv cmtk__nrrdFieldValEqv
#define _nrrdFormatType cmtk__nrrdFormatType
#define _nrrdFormatTypeDesc cmtk__nrrdFormatTypeDesc
#define _nrrdFormatTypeStr cmtk__nrrdFormatTypeStr
#define _nrrdFormatTypeStrEqv cmtk__nrrdFormatTypeStrEqv
#define _nrrdFormatTypeValEqv cmtk__nrrdFormatTypeValEqv
#define _nrrdKindDesc cmtk__nrrdKindDesc
#define _nrrdKindStr cmtk__nrrdKindStr
#define _nrrdKindStr_Eqv cmtk__nrrdKindStr_Eqv
#define _nrrdKindVal_Eqv cmtk__nrrdKindVal_Eqv
#define _nrrdKind_enum cmtk__nrrdKind_enum
#define _nrrdSpace cmtk__nrrdSpace
#define _nrrdSpaceDesc cmtk__nrrdSpaceDesc
#define _nrrdSpaceStr cmtk__nrrdSpaceStr
#define _nrrdSpaceStrEqv cmtk__nrrdSpaceStrEqv
#define _nrrdSpaceValEqv cmtk__nrrdSpaceValEqv
#define _nrrdSpacingStatus cmtk__nrrdSpacingStatus
#define _nrrdSpacingStatusDesc cmtk__nrrdSpacingStatusDesc
#define _nrrdSpacingStatusStr cmtk__nrrdSpacingStatusStr
#define _nrrdType cmtk__nrrdType
#define _nrrdTypeDesc cmtk__nrrdTypeDesc
#define _nrrdTypeStr cmtk__nrrdTypeStr
#define _nrrdTypeStrEqv cmtk__nrrdTypeStrEqv
#define _nrrdTypeValEqv cmtk__nrrdTypeValEqv
#define nrrdCenter cmtk_nrrdCenter
#define nrrdEncodingType cmtk_nrrdEncodingType
#define nrrdField cmtk_nrrdField
#define nrrdFormatType cmtk_nrrdFormatType
#define nrrdKind cmtk_nrrdKind
#define nrrdSpace cmtk_nrrdSpace
#define nrrdSpacingStatus cmtk_nrrdSpacingStatus
#define nrrdType cmtk_nrrdType
#define _nrrdFieldOnePerAxis cmtk__nrrdFieldOnePerAxis
#define _nrrdFieldRequired cmtk__nrrdFieldRequired
#define _nrrdFieldValidInImage cmtk__nrrdFieldValidInImage
#define _nrrdFieldValidInText cmtk__nrrdFieldValidInText
#define nrrdTypeIsIntegral cmtk_nrrdTypeIsIntegral
#define nrrdTypeIsUnsigned cmtk_nrrdTypeIsUnsigned
#define nrrdTypeMax cmtk_nrrdTypeMax
#define nrrdTypeMin cmtk_nrrdTypeMin
#define nrrdTypeNumberOfValues cmtk_nrrdTypeNumberOfValues
#define nrrdTypePrintfStr cmtk_nrrdTypePrintfStr
#define nrrdTypeSize cmtk_nrrdTypeSize
#define _nrrdAxisInfoInit cmtk__nrrdAxisInfoInit
#define _nrrdAxisInfoNewInit cmtk__nrrdAxisInfoNewInit
#define _nrrdCopy cmtk__nrrdCopy
#define _nrrdSizeCheck cmtk__nrrdSizeCheck
#define nrrdAlloc_nva cmtk_nrrdAlloc_nva
#define nrrdAlloc_va cmtk_nrrdAlloc_va
#define nrrdAxisInfoCopy cmtk_nrrdAxisInfoCopy
#define nrrdAxisInfoGet_nva cmtk_nrrdAxisInfoGet_nva
#define nrrdAxisInfoSet_nva cmtk_nrrdAxisInfoSet_nva
#define nrrdBasicInfoCopy cmtk_nrrdBasicInfoCopy
#define nrrdBasicInfoInit cmtk_nrrdBasicInfoInit
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdCommentClear cmtk_nrrdCommentClear
#define nrrdCommentCopy cmtk_nrrdCommentCopy
#define nrrdCopy cmtk_nrrdCopy
#define nrrdDefaultWriteBareText cmtk_nrrdDefaultWriteBareText
#define nrrdDefaultWriteCharsPerLine cmtk_nrrdDefaultWriteCharsPerLine
#define nrrdDefaultWriteValsPerLine cmtk_nrrdDefaultWriteValsPerLine
#define nrrdElementNumber cmtk_nrrdElementNumber
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEmpty cmtk_nrrdEmpty
#define nrrdEncodingUnknown cmtk_nrrdEncodingUnknown
#define nrrdFormatUnknown cmtk_nrrdFormatUnknown
#define nrrdInit cmtk_nrrdInit
#define nrrdIoStateInit cmtk_nrrdIoStateInit
#define nrrdIoStateNew cmtk_nrrdIoStateNew
#define nrrdIoStateNix cmtk_nrrdIoStateNix
#define nrrdKeyValueClear cmtk_nrrdKeyValueClear
#define nrrdKeyValueCopy cmtk_nrrdKeyValueCopy
#define nrrdMaybeAlloc_nva cmtk_nrrdMaybeAlloc_nva
#define nrrdMaybeAlloc_va cmtk_nrrdMaybeAlloc_va
#define nrrdNew cmtk_nrrdNew
#define nrrdNix cmtk_nrrdNix
#define nrrdNuke cmtk_nrrdNuke
#define nrrdPGM cmtk_nrrdPGM
#define nrrdPPM cmtk_nrrdPPM
#define nrrdType cmtk_nrrdType
#define nrrdTypeSize cmtk_nrrdTypeSize
#define nrrdWrap_nva cmtk_nrrdWrap_nva
#define nrrdWrap_va cmtk_nrrdWrap_va
#define _nrrdAxisInfoCopy cmtk__nrrdAxisInfoCopy
#define _nrrdAxisInfoInit cmtk__nrrdAxisInfoInit
#define _nrrdCopy cmtk__nrrdCopy
#define _nrrdKindAltered cmtk__nrrdKindAltered
#define nrrdAxesInsert cmtk_nrrdAxesInsert
#define nrrdAxesPermute cmtk_nrrdAxesPermute
#define nrrdAxisInfoCopy cmtk_nrrdAxisInfoCopy
#define nrrdAxisInfoGet_nva cmtk_nrrdAxisInfoGet_nva
#define nrrdBasicInfoCopy cmtk_nrrdBasicInfoCopy
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdContentSet_va cmtk_nrrdContentSet_va
#define nrrdCopy cmtk_nrrdCopy
#define nrrdElementNumber cmtk_nrrdElementNumber
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdInvertPerm cmtk_nrrdInvertPerm
#define nrrdKindSize cmtk_nrrdKindSize
#define nrrdMaybeAlloc_nva cmtk_nrrdMaybeAlloc_nva
#define nrrdShuffle cmtk_nrrdShuffle
#define nrrdStateKeyValuePairsPropagate cmtk_nrrdStateKeyValuePairsPropagate
#define nrrdStateKindNoop cmtk_nrrdStateKindNoop
#define _nrrdAxisInfoCopy cmtk__nrrdAxisInfoCopy
#define _nrrdAxisInfoInit cmtk__nrrdAxisInfoInit
#define _nrrdAxisInfoNewInit cmtk__nrrdAxisInfoNewInit
#define _nrrdCenter cmtk__nrrdCenter
#define _nrrdCenter2 cmtk__nrrdCenter2
#define _nrrdCheck cmtk__nrrdCheck
#define _nrrdKindAltered cmtk__nrrdKindAltered
#define _nrrdSpaceVecExists cmtk__nrrdSpaceVecExists
#define nrrdAxisInfoCopy cmtk_nrrdAxisInfoCopy
#define nrrdAxisInfoGet_nva cmtk_nrrdAxisInfoGet_nva
#define nrrdAxisInfoGet_va cmtk_nrrdAxisInfoGet_va
#define nrrdAxisInfoIdx cmtk_nrrdAxisInfoIdx
#define nrrdAxisInfoIdxRange cmtk_nrrdAxisInfoIdxRange
#define nrrdAxisInfoMinMaxSet cmtk_nrrdAxisInfoMinMaxSet
#define nrrdAxisInfoPos cmtk_nrrdAxisInfoPos
#define nrrdAxisInfoPosRange cmtk_nrrdAxisInfoPosRange
#define nrrdAxisInfoSet_nva cmtk_nrrdAxisInfoSet_nva
#define nrrdAxisInfoSet_va cmtk_nrrdAxisInfoSet_va
#define nrrdAxisInfoSpacingSet cmtk_nrrdAxisInfoSpacingSet
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdCopy cmtk_nrrdCopy
#define nrrdDefaultCenter cmtk_nrrdDefaultCenter
#define nrrdDefaultSpacing cmtk_nrrdDefaultSpacing
#define nrrdDomainAxesGet cmtk_nrrdDomainAxesGet
#define nrrdKindIsDomain cmtk_nrrdKindIsDomain
#define nrrdKindSize cmtk_nrrdKindSize
#define nrrdNonSpatialAxesGet cmtk_nrrdNonSpatialAxesGet
#define nrrdOrientationReduce cmtk_nrrdOrientationReduce
#define nrrdRangeAxesGet cmtk_nrrdRangeAxesGet
#define nrrdSpaceSet cmtk_nrrdSpaceSet
#define nrrdSpaceVecNorm cmtk_nrrdSpaceVecNorm
#define nrrdSpaceVecScale cmtk_nrrdSpaceVecScale
#define nrrdSpaceVecSetNaN cmtk_nrrdSpaceVecSetNaN
#define nrrdSpacingCalculate cmtk_nrrdSpacingCalculate
#define nrrdSpatialAxesGet cmtk_nrrdSpatialAxesGet
#define nrrdStateKindNoop cmtk_nrrdStateKindNoop
#define _nrrdCheck cmtk__nrrdCheck
#define _nrrdCheckEnums cmtk__nrrdCheckEnums
#define _nrrdContentGet cmtk__nrrdContentGet
#define _nrrdContentSet_nva cmtk__nrrdContentSet_nva
#define _nrrdContentSet_va cmtk__nrrdContentSet_va
#define _nrrdFieldCheck cmtk__nrrdFieldCheck
#define _nrrdFieldCheckSpaceInfo cmtk__nrrdFieldCheckSpaceInfo
#define _nrrdFieldCheck_axis_maxs cmtk__nrrdFieldCheck_axis_maxs
#define _nrrdFieldCheck_axis_mins cmtk__nrrdFieldCheck_axis_mins
#define _nrrdFieldCheck_block_size cmtk__nrrdFieldCheck_block_size
#define _nrrdFieldCheck_centers cmtk__nrrdFieldCheck_centers
#define _nrrdFieldCheck_dimension cmtk__nrrdFieldCheck_dimension
#define _nrrdFieldCheck_keyvalue cmtk__nrrdFieldCheck_keyvalue
#define _nrrdFieldCheck_kinds cmtk__nrrdFieldCheck_kinds
#define _nrrdFieldCheck_labels cmtk__nrrdFieldCheck_labels
#define _nrrdFieldCheck_measurement_frame cmtk__nrrdFieldCheck_measurement_frame
#define _nrrdFieldCheck_noop cmtk__nrrdFieldCheck_noop
#define _nrrdFieldCheck_old_max cmtk__nrrdFieldCheck_old_max
#define _nrrdFieldCheck_old_min cmtk__nrrdFieldCheck_old_min
#define _nrrdFieldCheck_sizes cmtk__nrrdFieldCheck_sizes
#define _nrrdFieldCheck_space cmtk__nrrdFieldCheck_space
#define _nrrdFieldCheck_space_dimension cmtk__nrrdFieldCheck_space_dimension
#define _nrrdFieldCheck_space_directions cmtk__nrrdFieldCheck_space_directions
#define _nrrdFieldCheck_space_origin cmtk__nrrdFieldCheck_space_origin
#define _nrrdFieldCheck_space_units cmtk__nrrdFieldCheck_space_units
#define _nrrdFieldCheck_spacings cmtk__nrrdFieldCheck_spacings
#define _nrrdFieldCheck_thicknesses cmtk__nrrdFieldCheck_thicknesses
#define _nrrdFieldCheck_type cmtk__nrrdFieldCheck_type
#define _nrrdFieldCheck_units cmtk__nrrdFieldCheck_units
#define _nrrdSizeCheck cmtk__nrrdSizeCheck
#define _nrrdSplitSizes cmtk__nrrdSplitSizes
#define nrrdAxisInfoGet_nva cmtk_nrrdAxisInfoGet_nva
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdCenter cmtk_nrrdCenter
#define nrrdCheck cmtk_nrrdCheck
#define nrrdContentSet_va cmtk_nrrdContentSet_va
#define nrrdDefaultCenter cmtk_nrrdDefaultCenter
#define nrrdDefaultWriteEncodingType cmtk_nrrdDefaultWriteEncodingType
#define nrrdDescribe cmtk_nrrdDescribe
#define nrrdElementNumber cmtk_nrrdElementNumber
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEncodingType cmtk_nrrdEncodingType
#define nrrdField cmtk_nrrdField
#define nrrdKind cmtk_nrrdKind
#define nrrdKindSize cmtk_nrrdKindSize
#define nrrdOriginCalculate cmtk_nrrdOriginCalculate
#define nrrdSameSize cmtk_nrrdSameSize
#define nrrdSanity cmtk_nrrdSanity
#define nrrdSpace cmtk_nrrdSpace
#define nrrdSpaceDimension cmtk_nrrdSpaceDimension
#define nrrdSpaceDimensionSet cmtk_nrrdSpaceDimensionSet
#define nrrdSpaceOriginGet cmtk_nrrdSpaceOriginGet
#define nrrdSpaceOriginSet cmtk_nrrdSpaceOriginSet
#define nrrdSpaceSet cmtk_nrrdSpaceSet
#define nrrdSpaceVecCopy cmtk_nrrdSpaceVecCopy
#define nrrdSpaceVecNorm cmtk_nrrdSpaceVecNorm
#define nrrdSpaceVecScale cmtk_nrrdSpaceVecScale
#define nrrdSpaceVecScaleAdd2 cmtk_nrrdSpaceVecScaleAdd2
#define nrrdSpaceVecSetNaN cmtk_nrrdSpaceVecSetNaN
#define nrrdStateAlwaysSetContent cmtk_nrrdStateAlwaysSetContent
#define nrrdStateDisableContent cmtk_nrrdStateDisableContent
#define nrrdStateUnknownContent cmtk_nrrdStateUnknownContent
#define nrrdType cmtk_nrrdType
#define nrrdTypeIsIntegral cmtk_nrrdTypeIsIntegral
#define nrrdTypeSize cmtk_nrrdTypeSize
#define _nrrdFormatURLLine0 cmtk__nrrdFormatURLLine0
#define _nrrdFormatURLLine1 cmtk__nrrdFormatURLLine1
#define nrrdCommentAdd cmtk_nrrdCommentAdd
#define nrrdCommentClear cmtk_nrrdCommentClear
#define nrrdCommentCopy cmtk_nrrdCommentCopy
#define _nrrdKeyValueIdxFind cmtk__nrrdKeyValueIdxFind
#define _nrrdKeyValueWrite cmtk__nrrdKeyValueWrite
#define _nrrdWriteEscaped cmtk__nrrdWriteEscaped
#define nrrdKeyValueAdd cmtk_nrrdKeyValueAdd
#define nrrdKeyValueClear cmtk_nrrdKeyValueClear
#define nrrdKeyValueCopy cmtk_nrrdKeyValueCopy
#define nrrdKeyValueErase cmtk_nrrdKeyValueErase
#define nrrdKeyValueGet cmtk_nrrdKeyValueGet
#define nrrdKeyValueIndex cmtk_nrrdKeyValueIndex
#define nrrdKeyValueSize cmtk_nrrdKeyValueSize
#define nrrdStateKeyValueReturnInternalPointers cmtk_nrrdStateKeyValueReturnInternalPointers
#define _nrrdBlockEndian cmtk__nrrdBlockEndian
#define _nrrdNoopEndian cmtk__nrrdNoopEndian
#define _nrrdSwap16Endian cmtk__nrrdSwap16Endian
#define _nrrdSwap32Endian cmtk__nrrdSwap32Endian
#define _nrrdSwap64Endian cmtk__nrrdSwap64Endian
#define _nrrdSwapEndian cmtk__nrrdSwapEndian
#define nrrdElementNumber cmtk_nrrdElementNumber
#define nrrdSwapEndian cmtk_nrrdSwapEndian
#define nrrdType cmtk_nrrdType
#define _nrrdContainsPercentThisAndMore cmtk__nrrdContainsPercentThisAndMore
#define _nrrdDataFNCheck cmtk__nrrdDataFNCheck
#define _nrrdDataFNNumber cmtk__nrrdDataFNNumber
#define _nrrdFieldCheck cmtk__nrrdFieldCheck
#define _nrrdFieldSep cmtk__nrrdFieldSep
#define _nrrdGetQuotedString cmtk__nrrdGetQuotedString
#define _nrrdHeaderCheck cmtk__nrrdHeaderCheck
#define _nrrdNoSpaceVector cmtk__nrrdNoSpaceVector
#define _nrrdOneLine cmtk__nrrdOneLine
#define _nrrdReadNrrdParseField cmtk__nrrdReadNrrdParseField
#define _nrrdReadNrrdParse_axis_maxs cmtk__nrrdReadNrrdParse_axis_maxs
#define _nrrdReadNrrdParse_axis_mins cmtk__nrrdReadNrrdParse_axis_mins
#define _nrrdReadNrrdParse_block_size cmtk__nrrdReadNrrdParse_block_size
#define _nrrdReadNrrdParse_byte_skip cmtk__nrrdReadNrrdParse_byte_skip
#define _nrrdReadNrrdParse_centers cmtk__nrrdReadNrrdParse_centers
#define _nrrdReadNrrdParse_comment cmtk__nrrdReadNrrdParse_comment
#define _nrrdReadNrrdParse_content cmtk__nrrdReadNrrdParse_content
#define _nrrdReadNrrdParse_data_file cmtk__nrrdReadNrrdParse_data_file
#define _nrrdReadNrrdParse_dimension cmtk__nrrdReadNrrdParse_dimension
#define _nrrdReadNrrdParse_encoding cmtk__nrrdReadNrrdParse_encoding
#define _nrrdReadNrrdParse_endian cmtk__nrrdReadNrrdParse_endian
#define _nrrdReadNrrdParse_keyvalue cmtk__nrrdReadNrrdParse_keyvalue
#define _nrrdReadNrrdParse_kinds cmtk__nrrdReadNrrdParse_kinds
#define _nrrdReadNrrdParse_labels cmtk__nrrdReadNrrdParse_labels
#define _nrrdReadNrrdParse_line_skip cmtk__nrrdReadNrrdParse_line_skip
#define _nrrdReadNrrdParse_max cmtk__nrrdReadNrrdParse_max
#define _nrrdReadNrrdParse_measurement_frame cmtk__nrrdReadNrrdParse_measurement_frame
#define _nrrdReadNrrdParse_min cmtk__nrrdReadNrrdParse_min
#define _nrrdReadNrrdParse_nonfield cmtk__nrrdReadNrrdParse_nonfield
#define _nrrdReadNrrdParse_number cmtk__nrrdReadNrrdParse_number
#define _nrrdReadNrrdParse_old_max cmtk__nrrdReadNrrdParse_old_max
#define _nrrdReadNrrdParse_old_min cmtk__nrrdReadNrrdParse_old_min
#define _nrrdReadNrrdParse_sample_units cmtk__nrrdReadNrrdParse_sample_units
#define _nrrdReadNrrdParse_sizes cmtk__nrrdReadNrrdParse_sizes
#define _nrrdReadNrrdParse_space cmtk__nrrdReadNrrdParse_space
#define _nrrdReadNrrdParse_space_dimension cmtk__nrrdReadNrrdParse_space_dimension
#define _nrrdReadNrrdParse_space_directions cmtk__nrrdReadNrrdParse_space_directions
#define _nrrdReadNrrdParse_space_origin cmtk__nrrdReadNrrdParse_space_origin
#define _nrrdReadNrrdParse_space_units cmtk__nrrdReadNrrdParse_space_units
#define _nrrdReadNrrdParse_spacings cmtk__nrrdReadNrrdParse_spacings
#define _nrrdReadNrrdParse_thicknesses cmtk__nrrdReadNrrdParse_thicknesses
#define _nrrdReadNrrdParse_type cmtk__nrrdReadNrrdParse_type
#define _nrrdReadNrrdParse_units cmtk__nrrdReadNrrdParse_units
#define _nrrdSpaceVectorParse cmtk__nrrdSpaceVectorParse
#define _nrrdSplitSizes cmtk__nrrdSplitSizes
#define nrrdAxisInfoSet_nva cmtk_nrrdAxisInfoSet_nva
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdCenter cmtk_nrrdCenter
#define nrrdCommentAdd cmtk_nrrdCommentAdd
#define nrrdEncodingArray cmtk_nrrdEncodingArray
#define nrrdEncodingType cmtk_nrrdEncodingType
#define nrrdField cmtk_nrrdField
#define nrrdFieldInfoParse cmtk_nrrdFieldInfoParse
#define nrrdKeyValueAdd cmtk_nrrdKeyValueAdd
#define nrrdKind cmtk_nrrdKind
#define nrrdSpace cmtk_nrrdSpace
#define nrrdSpaceSet cmtk_nrrdSpaceSet
#define nrrdType cmtk_nrrdType
#define _nrrdGzCheckHeader cmtk__nrrdGzCheckHeader
#define _nrrdGzClose cmtk__nrrdGzClose
#define _nrrdGzDestroy cmtk__nrrdGzDestroy
#define _nrrdGzDummySymbol cmtk__nrrdGzDummySymbol
#define _nrrdGzErrMsg cmtk__nrrdGzErrMsg
#define _nrrdGzGetByte cmtk__nrrdGzGetByte
#define _nrrdGzOpen cmtk__nrrdGzOpen
#define _nrrdGzRead cmtk__nrrdGzRead
#define _nrrdGzWrite cmtk__nrrdGzWrite
#define nrrdBiffKey cmtk_nrrdBiffKey
#define _nrrdCalloc cmtk__nrrdCalloc
#define _nrrdCheck cmtk__nrrdCheck
#define _nrrdContainsPercentThisAndMore cmtk__nrrdContainsPercentThisAndMore
#define _nrrdDataFNNumber cmtk__nrrdDataFNNumber
#define _nrrdFieldSep cmtk__nrrdFieldSep
#define _nrrdHeaderStringOneLine cmtk__nrrdHeaderStringOneLine
#define _nrrdHeaderStringOneLineStrlen cmtk__nrrdHeaderStringOneLineStrlen
#define _nrrdLineSep cmtk__nrrdLineSep
#define _nrrdNoSpaceVector cmtk__nrrdNoSpaceVector
#define _nrrdOneLine cmtk__nrrdOneLine
#define _nrrdRead cmtk__nrrdRead
#define _nrrdRelativePathFlag cmtk__nrrdRelativePathFlag
#define _nrrdSplitName cmtk__nrrdSplitName
#define _nrrdTextSep cmtk__nrrdTextSep
#define nrrdAxesInsert cmtk_nrrdAxesInsert
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdByteSkip cmtk_nrrdByteSkip
#define nrrdElementNumber cmtk_nrrdElementNumber
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEncodingRaw cmtk_nrrdEncodingRaw
#define nrrdFormatArray cmtk_nrrdFormatArray
#define nrrdFormatNRRD cmtk_nrrdFormatNRRD
#define nrrdFormatUnknown cmtk_nrrdFormatUnknown
#define nrrdInit cmtk_nrrdInit
#define nrrdIoStateNew cmtk_nrrdIoStateNew
#define nrrdIoStateNix cmtk_nrrdIoStateNix
#define nrrdLineSkip cmtk_nrrdLineSkip
#define nrrdLoad cmtk_nrrdLoad
#define nrrdLoadMulti cmtk_nrrdLoadMulti
#define nrrdRead cmtk_nrrdRead
#define nrrdSanity cmtk_nrrdSanity
#define nrrdStateGrayscaleImage3D cmtk_nrrdStateGrayscaleImage3D
#define nrrdStateVerboseIO cmtk_nrrdStateVerboseIO
#define nrrdStringRead cmtk_nrrdStringRead
#define _nrrdContainsPercentThisAndMore cmtk__nrrdContainsPercentThisAndMore
#define _nrrdEncodingMaybeSet cmtk__nrrdEncodingMaybeSet
#define _nrrdFieldInteresting cmtk__nrrdFieldInteresting
#define _nrrdFormatMaybeGuess cmtk__nrrdFormatMaybeGuess
#define _nrrdFormatMaybeSet cmtk__nrrdFormatMaybeSet
#define _nrrdFormatNRRD_whichVersion cmtk__nrrdFormatNRRD_whichVersion
#define _nrrdFprintFieldInfo cmtk__nrrdFprintFieldInfo
#define _nrrdNoSpaceVector cmtk__nrrdNoSpaceVector
#define _nrrdSplitName cmtk__nrrdSplitName
#define _nrrdSprintFieldInfo cmtk__nrrdSprintFieldInfo
#define _nrrdStrcatSpaceVector cmtk__nrrdStrcatSpaceVector
#define _nrrdWrite cmtk__nrrdWrite
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdCenter cmtk_nrrdCenter
#define nrrdCheck cmtk_nrrdCheck
#define nrrdDefaultWriteEncodingType cmtk_nrrdDefaultWriteEncodingType
#define nrrdElementNumber cmtk_nrrdElementNumber
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEncodingArray cmtk_nrrdEncodingArray
#define nrrdEncodingUnknown cmtk_nrrdEncodingUnknown
#define nrrdField cmtk_nrrdField
#define nrrdFormatArray cmtk_nrrdFormatArray
#define nrrdFormatNRRD cmtk_nrrdFormatNRRD
#define nrrdFormatUnknown cmtk_nrrdFormatUnknown
#define nrrdIoStateEncodingGet cmtk_nrrdIoStateEncodingGet
#define nrrdIoStateEncodingSet cmtk_nrrdIoStateEncodingSet
#define nrrdIoStateFormatGet cmtk_nrrdIoStateFormatGet
#define nrrdIoStateFormatSet cmtk_nrrdIoStateFormatSet
#define nrrdIoStateGet cmtk_nrrdIoStateGet
#define nrrdIoStateNew cmtk_nrrdIoStateNew
#define nrrdIoStateNix cmtk_nrrdIoStateNix
#define nrrdIoStateSet cmtk_nrrdIoStateSet
#define nrrdKind cmtk_nrrdKind
#define nrrdSave cmtk_nrrdSave
#define nrrdSaveMulti cmtk_nrrdSaveMulti
#define nrrdSpace cmtk_nrrdSpace
#define nrrdStateVerboseIO cmtk_nrrdStateVerboseIO
#define nrrdStringWrite cmtk_nrrdStringWrite
#define nrrdType cmtk_nrrdType
#define nrrdWrite cmtk_nrrdWrite
#define _nrrdFormatEPS cmtk__nrrdFormatEPS
#define _nrrdFormatNRRD cmtk__nrrdFormatNRRD
#define _nrrdFormatPNG cmtk__nrrdFormatPNG
#define _nrrdFormatPNM cmtk__nrrdFormatPNM
#define _nrrdFormatText cmtk__nrrdFormatText
#define _nrrdFormatUnknown cmtk__nrrdFormatUnknown
#define _nrrdFormatUnknown_available cmtk__nrrdFormatUnknown_available
#define _nrrdFormatUnknown_contentStartsLike cmtk__nrrdFormatUnknown_contentStartsLike
#define _nrrdFormatUnknown_fitsInto cmtk__nrrdFormatUnknown_fitsInto
#define _nrrdFormatUnknown_nameLooksLike cmtk__nrrdFormatUnknown_nameLooksLike
#define _nrrdFormatUnknown_read cmtk__nrrdFormatUnknown_read
#define _nrrdFormatUnknown_write cmtk__nrrdFormatUnknown_write
#define _nrrdFormatVTK cmtk__nrrdFormatVTK
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdFormatArray cmtk_nrrdFormatArray
#define nrrdFormatUnknown cmtk_nrrdFormatUnknown
#define _nrrdCalloc cmtk__nrrdCalloc
#define _nrrdDataFNNumber cmtk__nrrdDataFNNumber
#define _nrrdFieldInteresting cmtk__nrrdFieldInteresting
#define _nrrdFieldRequired cmtk__nrrdFieldRequired
#define _nrrdFormatNRRD cmtk__nrrdFormatNRRD
#define _nrrdFormatNRRD_available cmtk__nrrdFormatNRRD_available
#define _nrrdFormatNRRD_contentStartsLike cmtk__nrrdFormatNRRD_contentStartsLike
#define _nrrdFormatNRRD_fitsInto cmtk__nrrdFormatNRRD_fitsInto
#define _nrrdFormatNRRD_nameLooksLike cmtk__nrrdFormatNRRD_nameLooksLike
#define _nrrdFormatNRRD_read cmtk__nrrdFormatNRRD_read
#define _nrrdFormatNRRD_whichVersion cmtk__nrrdFormatNRRD_whichVersion
#define _nrrdFormatNRRD_write cmtk__nrrdFormatNRRD_write
#define _nrrdFormatURLLine0 cmtk__nrrdFormatURLLine0
#define _nrrdFormatURLLine1 cmtk__nrrdFormatURLLine1
#define _nrrdFprintFieldInfo cmtk__nrrdFprintFieldInfo
#define _nrrdHeaderCheck cmtk__nrrdHeaderCheck
#define _nrrdKeyValueWrite cmtk__nrrdKeyValueWrite
#define _nrrdOneLine cmtk__nrrdOneLine
#define _nrrdReadNrrdParseField cmtk__nrrdReadNrrdParseField
#define _nrrdSprintFieldInfo cmtk__nrrdSprintFieldInfo
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdByteSkip cmtk_nrrdByteSkip
#define nrrdElementNumber cmtk_nrrdElementNumber
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEncodingAscii cmtk_nrrdEncodingAscii
#define nrrdField cmtk_nrrdField
#define nrrdFieldInfoParse cmtk_nrrdFieldInfoParse
#define nrrdFormatNRRD cmtk_nrrdFormatNRRD
#define nrrdIoStateDataFileIterBegin cmtk_nrrdIoStateDataFileIterBegin
#define nrrdIoStateDataFileIterNext cmtk_nrrdIoStateDataFileIterNext
#define nrrdKeyValueSize cmtk_nrrdKeyValueSize
#define nrrdLineSkip cmtk_nrrdLineSkip
#define nrrdStateVerboseIO cmtk_nrrdStateVerboseIO
#define nrrdSwapEndian cmtk_nrrdSwapEndian
#define nrrdType cmtk_nrrdType
#define _nrrdEncodingAscii cmtk__nrrdEncodingAscii
#define _nrrdEncodingBzip2 cmtk__nrrdEncodingBzip2
#define _nrrdEncodingGzip cmtk__nrrdEncodingGzip
#define _nrrdEncodingHex cmtk__nrrdEncodingHex
#define _nrrdEncodingRaw cmtk__nrrdEncodingRaw
#define _nrrdEncodingUnknown cmtk__nrrdEncodingUnknown
#define _nrrdEncodingUnknown_available cmtk__nrrdEncodingUnknown_available
#define _nrrdEncodingUnknown_read cmtk__nrrdEncodingUnknown_read
#define _nrrdEncodingUnknown_write cmtk__nrrdEncodingUnknown_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdEncodingArray cmtk_nrrdEncodingArray
#define nrrdEncodingUnknown cmtk_nrrdEncodingUnknown
#define _nrrdEncodingRaw cmtk__nrrdEncodingRaw
#define _nrrdEncodingRaw_available cmtk__nrrdEncodingRaw_available
#define _nrrdEncodingRaw_read cmtk__nrrdEncodingRaw_read
#define _nrrdEncodingRaw_write cmtk__nrrdEncodingRaw_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEncodingRaw cmtk_nrrdEncodingRaw
#define nrrdStateVerboseIO cmtk_nrrdStateVerboseIO
#define _nrrdEncodingAscii cmtk__nrrdEncodingAscii
#define _nrrdEncodingAscii_available cmtk__nrrdEncodingAscii_available
#define _nrrdEncodingAscii_read cmtk__nrrdEncodingAscii_read
#define _nrrdEncodingAscii_write cmtk__nrrdEncodingAscii_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEncodingAscii cmtk_nrrdEncodingAscii
#define nrrdIInsert cmtk_nrrdIInsert
#define nrrdSprint cmtk_nrrdSprint
#define nrrdType cmtk_nrrdType
#define nrrdTypePrintfStr cmtk_nrrdTypePrintfStr
#define _nrrdEncodingHex cmtk__nrrdEncodingHex
#define _nrrdEncodingHex_available cmtk__nrrdEncodingHex_available
#define _nrrdEncodingHex_read cmtk__nrrdEncodingHex_read
#define _nrrdEncodingHex_write cmtk__nrrdEncodingHex_write
#define _nrrdReadHexTable cmtk__nrrdReadHexTable
#define _nrrdWriteHexTable cmtk__nrrdWriteHexTable
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEncodingHex cmtk_nrrdEncodingHex
#define _nrrdEncodingGzip cmtk__nrrdEncodingGzip
#define _nrrdEncodingGzip_available cmtk__nrrdEncodingGzip_available
#define _nrrdEncodingGzip_read cmtk__nrrdEncodingGzip_read
#define _nrrdEncodingGzip_write cmtk__nrrdEncodingGzip_write
#define _nrrdGzClose cmtk__nrrdGzClose
#define _nrrdGzOpen cmtk__nrrdGzOpen
#define _nrrdGzRead cmtk__nrrdGzRead
#define _nrrdGzWrite cmtk__nrrdGzWrite
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdEncodingGzip cmtk_nrrdEncodingGzip
#define _nrrdKindAltered cmtk__nrrdKindAltered
#define nrrdAxisInfoCopy cmtk_nrrdAxisInfoCopy
#define nrrdAxisInfoGet_nva cmtk_nrrdAxisInfoGet_nva
#define nrrdAxisInfoPosRange cmtk_nrrdAxisInfoPosRange
#define nrrdBasicInfoCopy cmtk_nrrdBasicInfoCopy
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdContentSet_va cmtk_nrrdContentSet_va
#define nrrdCrop cmtk_nrrdCrop
#define nrrdElementSize cmtk_nrrdElementSize
#define nrrdMaybeAlloc_nva cmtk_nrrdMaybeAlloc_nva
#define nrrdSlice cmtk_nrrdSlice
#define nrrdSpaceVecCopy cmtk_nrrdSpaceVecCopy
#define nrrdSpaceVecScaleAdd2 cmtk_nrrdSpaceVecScaleAdd2
#define nrrdStateKeyValuePairsPropagate cmtk_nrrdStateKeyValuePairsPropagate
#define nrrdStateKindNoop cmtk_nrrdStateKindNoop
#define _nrrdEncodingBzip2 cmtk__nrrdEncodingBzip2
#define _nrrdEncodingBzip2_available cmtk__nrrdEncodingBzip2_available
#define _nrrdEncodingBzip2_read cmtk__nrrdEncodingBzip2_read
#define _nrrdEncodingBzip2_write cmtk__nrrdEncodingBzip2_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdEncodingBzip2 cmtk_nrrdEncodingBzip2
#define _nrrdFormatEPS cmtk__nrrdFormatEPS
#define _nrrdFormatEPS_available cmtk__nrrdFormatEPS_available
#define _nrrdFormatEPS_contentStartsLike cmtk__nrrdFormatEPS_contentStartsLike
#define _nrrdFormatEPS_fitsInto cmtk__nrrdFormatEPS_fitsInto
#define _nrrdFormatEPS_nameLooksLike cmtk__nrrdFormatEPS_nameLooksLike
#define _nrrdFormatEPS_read cmtk__nrrdFormatEPS_read
#define _nrrdFormatEPS_write cmtk__nrrdFormatEPS_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdFormatEPS cmtk_nrrdFormatEPS
#define _nrrdFormatPNG cmtk__nrrdFormatPNG
#define _nrrdFormatPNG_available cmtk__nrrdFormatPNG_available
#define _nrrdFormatPNG_contentStartsLike cmtk__nrrdFormatPNG_contentStartsLike
#define _nrrdFormatPNG_fitsInto cmtk__nrrdFormatPNG_fitsInto
#define _nrrdFormatPNG_nameLooksLike cmtk__nrrdFormatPNG_nameLooksLike
#define _nrrdFormatPNG_read cmtk__nrrdFormatPNG_read
#define _nrrdFormatPNG_write cmtk__nrrdFormatPNG_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdFormatPNG cmtk_nrrdFormatPNG
#define _nrrdFormatPNM cmtk__nrrdFormatPNM
#define _nrrdFormatPNM_available cmtk__nrrdFormatPNM_available
#define _nrrdFormatPNM_contentStartsLike cmtk__nrrdFormatPNM_contentStartsLike
#define _nrrdFormatPNM_fitsInto cmtk__nrrdFormatPNM_fitsInto
#define _nrrdFormatPNM_nameLooksLike cmtk__nrrdFormatPNM_nameLooksLike
#define _nrrdFormatPNM_read cmtk__nrrdFormatPNM_read
#define _nrrdFormatPNM_write cmtk__nrrdFormatPNM_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdFormatPNM cmtk_nrrdFormatPNM
#define _nrrdFormatText cmtk__nrrdFormatText
#define _nrrdFormatText_available cmtk__nrrdFormatText_available
#define _nrrdFormatText_contentStartsLike cmtk__nrrdFormatText_contentStartsLike
#define _nrrdFormatText_fitsInto cmtk__nrrdFormatText_fitsInto
#define _nrrdFormatText_nameLooksLike cmtk__nrrdFormatText_nameLooksLike
#define _nrrdFormatText_read cmtk__nrrdFormatText_read
#define _nrrdFormatText_write cmtk__nrrdFormatText_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdFormatText cmtk_nrrdFormatText
#define _nrrdFormatVTK cmtk__nrrdFormatVTK
#define _nrrdFormatVTK_available cmtk__nrrdFormatVTK_available
#define _nrrdFormatVTK_contentStartsLike cmtk__nrrdFormatVTK_contentStartsLike
#define _nrrdFormatVTK_fitsInto cmtk__nrrdFormatVTK_fitsInto
#define _nrrdFormatVTK_nameLooksLike cmtk__nrrdFormatVTK_nameLooksLike
#define _nrrdFormatVTK_read cmtk__nrrdFormatVTK_read
#define _nrrdFormatVTK_write cmtk__nrrdFormatVTK_write
#define nrrdBiffKey cmtk_nrrdBiffKey
#define nrrdFormatVTK cmtk_nrrdFormatVTK
#endif  /* __cmtk_NrrdIO_mangle_h */ 
