/****************************************************************************
 *    lib/c_taid/compiler.h - This file is part of coala					*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#undef yyFlexLexer
#define yyFlexLexer ctaidFlexLexer
#include <FlexLexer.h>
#include <string.h>

#include "../main.h"
#include "../options.h"
#include "parser.h"

namespace C_taid {

class Compiler : public Coala::AbstractCompiler, public CtaidParser {
	private:
		ctaidFlexLexer lexer;
	public:
		Compiler(Coala::CompilerOptions*);
		virtual ~Compiler();
		int compile();
		int yylex();
		void yyerror(char*);
		void change_input(std::istream*);
};

};
