<CsoundSynthesizer>
<CsOptions>
--midi-key-cps=4 --midi-velocity=5
</CsOptions>
<CsInstruments>

sr = 44100
ksmps = 128
nchnls = 2
0dbfs = 1

; Make sure CsOptions are not ignored in the preferences,
; Otherwise Realtime MIDI input will not work.

giatttimemax = 2
gidectimemax = 2
gireltimemax = 4

instr 1  ;Subtractive synth
kosctype invalue "osctype"

kftype invalue "ftype"
kffreq invalue "ffreq"
kffreq portk kffreq, 0.02 ;smooth signal
kfres invalue "fres"
kfres portk kfres, 0.02 ;smooth signal
kfatt invalue "fatt"
kfdec invalue "fdec"
kfsus invalue "fsus"
kfrel invalue "frel"
kfenvamt invalue "fenvamt"

kaatt invalue "aatt"
kadec invalue "adec"
kasus invalue "asus"
karel invalue "arel"

klvl invalue "lvl"

ifreq = p4  ;in cps
iamp = (p5/127) ;MIDI velocity to linear amp

itype = i(kosctype)

if (itype == 0) then
	aosc oscil iamp, ifreq, 1
elseif (itype == 1) then
	aosc oscil iamp, ifreq, 2
elseif (itype == 2) then
	aosc vco2 iamp, ifreq
elseif (itype == 3) then
	aosc vco2 iamp, ifreq, 2, 0.5
endif

kfenv madsr giatttimemax*i(kfatt), gidectimemax*i(kfdec), i(kfsus), gireltimemax*i(kfrel)
kfenv = (kfenv*kfenvamt) + 1

if (kftype == 0) then
	aosc moogladder aosc, kffreq*kfenv, kfres
elseif (kftype == 1) then
	aosc moogvcf2 aosc, kffreq*kfenv, kfres
elseif (kftype == 2) then
	aosc rezzy aosc, kffreq*kfenv, kfres*100
elseif (kftype == 3) then
	aosc lowresx aosc, kffreq*kfenv, kfres/3
endif

aenv madsr giatttimemax*i(kaatt), gidectimemax*i(kadec), i(kasus), gireltimemax*i(karel)

outs aosc*aenv*klvl, aosc*aenv*klvl
endin

instr 98 ; Play note
	koscfreq invalue "oscfreq"
	event "i", 1, 0, 3, i(koscfreq), 100
	turnoff
endin

instr 99 ; Always on

kcont invalue "cont"
koscfreq invalue "oscfreq"

if kcont == 1 then
	ktrig metro 0.5
	schedkwhen ktrig, 0.1, 10, 1, 0, 1, koscfreq, 100
endif
endin


</CsInstruments>
<CsScore>
f 1 0 1024 7 -1 1024 1 ;Saw wave
f 2 0 1024 7 1 512 1 0 -1 512 -1 ;Square wave

i 99 0 3600
</CsScore>
</CsoundSynthesizer>
<bsbPanel>
 <label>Widgets</label>
 <objectName/>
 <x>502</x>
 <y>203</y>
 <width>613</width>
 <height>433</height>
 <visible>true</visible>
 <uuid/>
 <bgcolor mode="background">
  <r>125</r>
  <g>162</g>
  <b>160</b>
 </bgcolor>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>216</x>
  <y>44</y>
  <width>243</width>
  <height>189</height>
  <uuid>{b542d9ea-d625-4ba4-8f8c-b250b4c6d3ca}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Filter</label>
  <alignment>center</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>ffreq</objectName>
  <x>228</x>
  <y>52</y>
  <width>56</width>
  <height>49</height>
  <uuid>{e077a857-fca6-48f0-ba58-0e8ed2a8eb99}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>100.00000000</minimum>
  <maximum>5000.00000000</maximum>
  <value>495.95959600</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>232</x>
  <y>95</y>
  <width>58</width>
  <height>26</height>
  <uuid>{fcf41807-f149-4dfe-ac5c-47576b9933a2}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Cut Freq</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>fres</objectName>
  <x>230</x>
  <y>117</y>
  <width>55</width>
  <height>48</height>
  <uuid>{bc1eac8b-d1bd-4aae-939d-6ebd3ad98585}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000000</minimum>
  <maximum>1.00000000</maximum>
  <value>0.42424200</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>220</x>
  <y>160</y>
  <width>77</width>
  <height>24</height>
  <uuid>{eda74469-1888-4351-93c2-f8e464611280}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Resonance</label>
  <alignment>center</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDropdown">
  <objectName>ftype</objectName>
  <x>339</x>
  <y>67</y>
  <width>110</width>
  <height>25</height>
  <uuid>{6fbb28f4-5242-4967-ac09-2e2f8a9f296e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <bsbDropdownItemList>
   <bsbDropdownItem>
    <name>moogladder</name>
    <value>0</value>
    <stringvalue/>
   </bsbDropdownItem>
   <bsbDropdownItem>
    <name> moogvcf2</name>
    <value>1</value>
    <stringvalue/>
   </bsbDropdownItem>
   <bsbDropdownItem>
    <name> rezzy</name>
    <value>2</value>
    <stringvalue/>
   </bsbDropdownItem>
   <bsbDropdownItem>
    <name> lowresx</name>
    <value>3</value>
    <stringvalue/>
   </bsbDropdownItem>
  </bsbDropdownItemList>
  <selectedIndex>1</selectedIndex>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>292</x>
  <y>69</y>
  <width>53</width>
  <height>25</height>
  <uuid>{d640e32c-b354-4946-9dff-620a2e3b23a1}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Opcode </label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBVSlider">
  <objectName>fatt</objectName>
  <x>331</x>
  <y>100</y>
  <width>20</width>
  <height>100</height>
  <uuid>{1547e11c-c289-4a0f-9bbc-f6ee054dae98}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000100</minimum>
  <maximum>1.00000000</maximum>
  <value>0.27000100</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBVSlider">
  <objectName>fdec</objectName>
  <x>358</x>
  <y>100</y>
  <width>20</width>
  <height>100</height>
  <uuid>{f8b9b548-92dc-412a-82ea-e6e678dddfc1}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000100</minimum>
  <maximum>1.00000000</maximum>
  <value>0.24000100</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBVSlider">
  <objectName>fsus</objectName>
  <x>383</x>
  <y>100</y>
  <width>20</width>
  <height>100</height>
  <uuid>{7afe30e7-06f5-4f94-8806-3e36833df753}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000000</minimum>
  <maximum>1.00000000</maximum>
  <value>0.28000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBVSlider">
  <objectName>frel</objectName>
  <x>410</x>
  <y>100</y>
  <width>20</width>
  <height>100</height>
  <uuid>{a40e816b-1b4e-4093-b0ff-ba3930ffa741}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000100</minimum>
  <maximum>1.00000000</maximum>
  <value>0.02000100</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>331</x>
  <y>200</y>
  <width>18</width>
  <height>24</height>
  <uuid>{18226ee2-5436-49f1-a2d2-a2e7c33c2a9f}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>A</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>359</x>
  <y>200</y>
  <width>18</width>
  <height>24</height>
  <uuid>{d49c4838-e7af-43e7-8e86-b4374c49a2d9}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>D</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>384</x>
  <y>200</y>
  <width>18</width>
  <height>24</height>
  <uuid>{1522064a-d37e-436e-b2f6-6c9bfdd16df9}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>S</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>410</x>
  <y>199</y>
  <width>18</width>
  <height>24</height>
  <uuid>{b485842b-80e7-4e4c-9ccf-e3cf104f187f}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>R</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>465</x>
  <y>44</y>
  <width>124</width>
  <height>189</height>
  <uuid>{9e3d556f-e489-435d-bc7c-97a868c27d64}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Amp Env</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>9</x>
  <y>44</y>
  <width>200</width>
  <height>189</height>
  <uuid>{73adfc9f-4df8-45e4-86c8-6a71a4dadc3b}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Oscillator</label>
  <alignment>center</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBDropdown">
  <objectName>osctype</objectName>
  <x>18</x>
  <y>70</y>
  <width>154</width>
  <height>24</height>
  <uuid>{174520cb-035b-421b-935b-dcf96933287e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <bsbDropdownItemList>
   <bsbDropdownItem>
    <name>Saw</name>
    <value>0</value>
    <stringvalue/>
   </bsbDropdownItem>
   <bsbDropdownItem>
    <name>Square</name>
    <value>1</value>
    <stringvalue/>
   </bsbDropdownItem>
   <bsbDropdownItem>
    <name>Band-Lim. Saw</name>
    <value>2</value>
    <stringvalue/>
   </bsbDropdownItem>
   <bsbDropdownItem>
    <name>Band-lim Square</name>
    <value>3</value>
    <stringvalue/>
   </bsbDropdownItem>
  </bsbDropdownItemList>
  <selectedIndex>2</selectedIndex>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBVSlider">
  <objectName>aatt</objectName>
  <x>479</x>
  <y>65</y>
  <width>20</width>
  <height>100</height>
  <uuid>{9c20c1f0-dac8-49c8-a022-14477e73432e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000100</minimum>
  <maximum>1.00000000</maximum>
  <value>0.00000100</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBVSlider">
  <objectName>adec</objectName>
  <x>506</x>
  <y>65</y>
  <width>20</width>
  <height>100</height>
  <uuid>{3e1a333a-8f89-4086-bfb2-0db2e61e1a89}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000100</minimum>
  <maximum>1.00000000</maximum>
  <value>0.00000100</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBVSlider">
  <objectName>asus</objectName>
  <x>531</x>
  <y>65</y>
  <width>20</width>
  <height>100</height>
  <uuid>{02d697b0-77e4-4d0c-add5-30e36794ece0}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000000</minimum>
  <maximum>1.00000000</maximum>
  <value>0.52000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBVSlider">
  <objectName>arel</objectName>
  <x>558</x>
  <y>65</y>
  <width>20</width>
  <height>100</height>
  <uuid>{2e9cf2ae-7997-4391-9363-0ea7ba3fe217}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000100</minimum>
  <maximum>1.00000000</maximum>
  <value>0.10000100</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>480</x>
  <y>164</y>
  <width>18</width>
  <height>24</height>
  <uuid>{ed8bc21e-980d-438e-a004-8797008451b4}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>A</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>508</x>
  <y>164</y>
  <width>18</width>
  <height>24</height>
  <uuid>{9db192c7-a3b1-452d-ab86-7bc39b5a097e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>D</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>533</x>
  <y>164</y>
  <width>18</width>
  <height>24</height>
  <uuid>{6e841111-90a7-44e2-94df-541c3d28aed5}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>S</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>559</x>
  <y>163</y>
  <width>18</width>
  <height>24</height>
  <uuid>{90de043d-9e1a-484e-86c1-2cf0d364f1d8}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>R</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>7</x>
  <y>7</y>
  <width>583</width>
  <height>29</height>
  <uuid>{5e72b2e3-b9d2-462e-ba03-7d05e8ca2d8b}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Simple subtractive synth</label>
  <alignment>center</alignment>
  <font>DejaVu Sans</font>
  <fontsize>14</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="background">
   <r>192</r>
   <g>231</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBButton">
  <objectName/>
  <x>19</x>
  <y>124</y>
  <width>93</width>
  <height>28</height>
  <uuid>{c54488fe-3549-4ff1-b78d-04f3503fb0ac}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <type>event</type>
  <pressedValue>1.00000000</pressedValue>
  <stringvalue/>
  <text>Note</text>
  <image>/</image>
  <eventLine>i98 0 3</eventLine>
  <latch>false</latch>
  <latched>false</latched>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>oscfreq</objectName>
  <x>111</x>
  <y>110</y>
  <width>83</width>
  <height>50</height>
  <uuid>{310cd814-0603-4752-be69-051bb802ff29}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>110.00000000</minimum>
  <maximum>880.00000000</maximum>
  <value>366.66666700</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>160</x>
  <y>165</y>
  <width>36</width>
  <height>22</height>
  <uuid>{41877dd4-4755-4d3f-8496-df8ae5a5377d}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Hz</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>lvl</objectName>
  <x>529</x>
  <y>183</y>
  <width>56</width>
  <height>50</height>
  <uuid>{bafb9667-fb81-4451-9ea9-12b70119e65a}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000000</minimum>
  <maximum>1.00000000</maximum>
  <value>0.57575800</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>485</x>
  <y>198</y>
  <width>45</width>
  <height>26</height>
  <uuid>{aa166cf5-67fa-49f5-aaee-33408c17c8b8}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Level</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBScrollNumber">
  <objectName>oscfreq</objectName>
  <x>112</x>
  <y>165</y>
  <width>49</width>
  <height>23</height>
  <uuid>{6dd018b2-ea3a-4d42-870d-50132353231e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <alignment>right</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <value>374.40000000</value>
  <resolution>0.10000000</resolution>
  <minimum>-999999999999.00000000</minimum>
  <maximum>99999999999999.00000000</maximum>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
  <randomizable group="0">false</randomizable>
  <mouseControl act="continuous"/>
 </bsbObject>
 <bsbObject version="2" type="BSBScope">
  <objectName/>
  <x>9</x>
  <y>241</y>
  <width>580</width>
  <height>148</height>
  <uuid>{731d1212-45ea-43d2-9703-84c12261bdd9}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <value>1.00000000</value>
  <type>scope</type>
  <zoomx>2.00000000</zoomx>
  <zoomy>1.00000000</zoomy>
  <dispx>1.00000000</dispx>
  <dispy>1.00000000</dispy>
  <mode>0.00000000</mode>
 </bsbObject>
 <bsbObject version="2" type="BSBKnob">
  <objectName>fenvamt</objectName>
  <x>286</x>
  <y>188</y>
  <width>47</width>
  <height>38</height>
  <uuid>{c0ba12ff-f822-4db9-b0cd-23cfd062a63e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <minimum>0.00000000</minimum>
  <maximum>4.00000000</maximum>
  <value>4.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>0.01000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>219</x>
  <y>196</y>
  <width>77</width>
  <height>24</height>
  <uuid>{1755a6b9-28ba-49b2-b7ef-6529543f27f1}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Env Amount</label>
  <alignment>center</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBCheckBox">
  <objectName>cont</objectName>
  <x>23</x>
  <y>192</y>
  <width>20</width>
  <height>20</height>
  <uuid>{832c39a1-c6e6-4455-bbd7-5e2df1a01f51}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <selected>false</selected>
  <label/>
  <pressedValue>1</pressedValue>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>37</x>
  <y>192</y>
  <width>114</width>
  <height>25</height>
  <uuid>{59143ad4-f7e2-4a17-9d87-3e522b91b13e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <label>Continuous notes</label>
  <alignment>left</alignment>
  <font>DejaVu Sans</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
</bsbPanel>
<bsbPresets>
</bsbPresets>
<MacOptions>
Version: 3
Render: Real
Ask: Yes
Functions: ioObject
Listing: Window
WindowBounds: 502 203 613 433
CurrentView: io
IOViewEdit: On
Options: -b128 -A -s -m167 -R
</MacOptions>
<MacGUI>
ioView background {32125, 41634, 41120}
ioText {216, 38} {243, 189} label 0.000000 0.00100 "" center "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Filter
ioKnob {228, 52} {56, 49} 5000.000000 100.000000 0.010000 495.959596 ffreq
ioText {232, 89} {58, 26} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Cut Freq
ioKnob {230, 117} {55, 48} 1.000000 0.000000 0.010000 0.424242 fres
ioText {220, 154} {77, 24} label 0.000000 0.00100 "" center "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Resonance
ioMenu {339, 67} {110, 25} 1 303 "moogladder, moogvcf2, rezzy, lowresx" ftype
ioText {292, 63} {53, 25} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Opcode 
ioSlider {331, 100} {20, 100} 0.000001 1.000000 0.270001 fatt
ioSlider {358, 100} {20, 100} 0.000001 1.000000 0.240001 fdec
ioSlider {383, 100} {20, 100} 0.000000 1.000000 0.280000 fsus
ioSlider {410, 100} {20, 100} 0.000001 1.000000 0.020001 frel
ioText {331, 194} {18, 24} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder A
ioText {359, 194} {18, 24} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder D
ioText {384, 194} {18, 24} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder S
ioText {410, 193} {18, 24} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder R
ioText {465, 38} {124, 189} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Amp Env
ioText {9, 38} {200, 189} label 0.000000 0.00100 "" center "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Oscillator
ioMenu {18, 70} {154, 24} 2 303 "Saw,Square,Band-Lim. Saw,Band-lim Square" osctype
ioSlider {479, 65} {20, 100} 0.000001 1.000000 0.000001 aatt
ioSlider {506, 65} {20, 100} 0.000001 1.000000 0.000001 adec
ioSlider {531, 65} {20, 100} 0.000000 1.000000 0.520000 asus
ioSlider {558, 65} {20, 100} 0.000001 1.000000 0.100001 arel
ioText {480, 158} {18, 24} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder A
ioText {508, 158} {18, 24} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder D
ioText {533, 158} {18, 24} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder S
ioText {559, 157} {18, 24} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder R
ioText {7, 1} {583, 29} label 0.000000 0.00100 "" center "DejaVu Sans" 14 {0, 0, 0} {49152, 59136, 65280} nobackground noborder Simple subtractive synth
ioButton {19, 124} {93, 28} event 1.000000 "" "Note" "/" i98 0 3
ioKnob {111, 110} {83, 50} 880.000000 110.000000 0.010000 366.666667 oscfreq
ioText {160, 154} {35, 25} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Hz
ioKnob {529, 183} {56, 50} 1.000000 0.000000 0.010000 0.575758 lvl
ioText {485, 192} {45, 26} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Level
ioText {112, 165} {49, 23} scroll 374.400000 0.100000 "oscfreq" right "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder 
ioGraph {9, 241} {580, 148} scope 2.000000 1 
ioKnob {286, 188} {47, 38} 4.000000 0.000000 0.010000 4.000000 fenvamt
ioText {219, 190} {77, 24} label 0.000000 0.00100 "" center "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Env Amount
ioCheckbox {23, 192} {20, 20} off cont
ioText {36, 185} {80, 25} label 0.000000 0.00100 "" left "DejaVu Sans" 10 {0, 0, 0} {65280, 65280, 65280} nobackground noborder Continuous notes
</MacGUI>
