//
// C++ Interface: session
//
// Description: 
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SESSION_H
#define SESSION_H

#include <boost/shared_ptr.hpp>

#include <QWidget>
#include "ui_hub.h"

class QMennu;

class UserListModel;
class User;

/**
	Holds the session ui.
	@author Rikard Bjorklind <olof@users.sourceforge.net>
*/
class Session : public QWidget
{
Q_OBJECT
public:
    Session(int aId,
			QWidget *parent = 0);
    ~Session();
	int getId() {return myId;}
	qint64 getTotalShared() {return shared;}
	
public slots:
	void onFailed(const QString&);
	void onPrivateChatMessage(const QString& from,const QString& msg);
	void onUsersUpdated(QList<User*> users);
	void onChatMessage(const QString&);
	void onUserRemoved(int id);
	void onHubStats(qint64 totshared);
	
	void onGetFileList();
	void onOpenChat() {}
	void onAddFav() {}
	
	// Auto-slots
	void on_chatEdit_returnPressed();
	void on_userView_doubleClicked( const QModelIndex& index);
	void on_userView_customContextMenuRequested( const QPoint& pos );
	
private:
	void createMenu();
	
	void getFileList( const QModelIndex& index );
	
	Ui::HubForm ui;
	UserListModel* userModel;
	
	boost::shared_ptr<QMenu> contextMenu;
	
	int myId;
	qint64 shared;	
signals:
	void sendChat(int,const QString&);
	void getUserFileList(int);
};

#endif
