# Find iconv library
#
# Released under BSD license
#
#  LIBICONV_INCLUDE_DIRS - where to find iconv.h, etc
#  LIBICONV_LIBRARIES    - Lists of libraries when using iconv
#  LIBICONV_FOUND        - True if iconv found

INCLUDE(FindPackageHandleStandardArgs)
INCLUDE(dcmtkTryCompile)

# Look for the header file
FIND_PATH(LIBICONV_INCLUDE_DIR NAMES iconv.h)
MARK_AS_ADVANCED(LIBICONV_INCLUDE_DIR)

# Look for the library
SET(LIBICONV_LIBS iconv)
FIND_LIBRARY(LIBICONV_LIBRARY NAMES ${LIBICONV_LIBS})
MARK_AS_ADVANCED(LIBICONV_LIBRARY)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(LIBICONV REQUIRED_VARS LIBICONV_LIBRARY LIBICONV_INCLUDE_DIR)

# Copy the result to output variables
IF(LIBICONV_FOUND)
  SET(LIBICONV_LIBRARIES ${LIBICONV_LIBRARY})
  SET(LIBICONV_INCLUDE_DIRS ${LIBICONV_INCLUDE_DIR})
ELSE(LIBICONV_FOUND)
  SET(LIBICONV_LIBS)
  SET(LIBICONV_LIBRARY)
  SET(LIBICONV_LIBRARIES)
  SET(LIBICONV_INCLUDE_DIR)
  SET(LIBICONV_INCLUDE_DIRS)
ENDIF(LIBICONV_FOUND)
