/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "markdown.h"

Markdown::Markdown(QObject *parent) :  QObject(parent)
{
    // Creating object not required
}



QString Markdown::toHtml(QString markdownString)
{
    //qDebug() << "Markdown::toHtml():" << markdownString;
    int foundMatch;

    // Remove DOCTYPE part
    markdownString.remove("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">");
    // FIXME: it's hardcoded for now


    ///////////////////////////////////////////////////////// Headers


    // Header 1
    QRegExp header1RE(">#\\s(.+)<");  // Match after ">", since it comes from HTML
    header1RE.setMinimal(true);       // so either <p> or <br> or some tag
    do
    {
        foundMatch = header1RE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            markdownString.replace(header1RE.cap(0),
                                   "><h1>" + header1RE.cap(1) +"</h1><");
        }                           // restore the matched ">" and "<" too!!
    }
    while (foundMatch != -1);



    // Header 2
    QRegExp header2RE(">##\\s(.+)<");
    header2RE.setMinimal(true);
    do
    {
        foundMatch = header2RE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            markdownString.replace(header2RE.cap(0),
                                   "><h2>" + header2RE.cap(1) +"</h2><");
        }
    }
    while (foundMatch != -1);



    // Header 3
    QRegExp header3RE(">###\\s(.+)<");
    header3RE.setMinimal(true);
    do
    {
        foundMatch = header3RE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            markdownString.replace(header3RE.cap(0),
                                   "><h3>" + header3RE.cap(1) +"</h3><");
        }
    }
    while (foundMatch != -1);



    // Header 4
    QRegExp header4RE(">####\\s(.+)<");
    header4RE.setMinimal(true);
    do
    {
        foundMatch = header4RE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            markdownString.replace(header4RE.cap(0),
                                   "><h4>" + header4RE.cap(1) +"</h4><");
        }
    }
    while (foundMatch != -1);


    ///////////////////////////////////////////////////////// Bold, italic



    // bold + italic: ***text***
    QRegExp boldItalicRE("\\*\\*\\*([^\\\\]+)\\*\\*\\*");
    boldItalicRE.setMinimal(true);
    do
    {
        foundMatch = boldItalicRE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            markdownString.replace(boldItalicRE.cap(0),
                                   "<b><i>" + boldItalicRE.cap(1) + "</i></b>");
        }
    }
    while (foundMatch != -1);



    // bold: **text**
    QRegExp boldRE("\\*\\*([^\\\\]+)\\*\\*");
    boldRE.setMinimal(true);
    do
    {
        foundMatch = boldRE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            markdownString.replace(boldRE.cap(0),
                                   "<b>" + boldRE.cap(1) + "</b>");
        }
    }
    while (foundMatch != -1);


    // italic: *text*
    QRegExp italicRE("\\*([^\\\\]+)\\*");
    italicRE.setMinimal(true);
    do
    {
        foundMatch = italicRE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            markdownString.replace(italicRE.cap(0),
                                   "<i>" + italicRE.cap(1) +"</i>");
        }
    }
    while (foundMatch != -1);






    // Image+link: [ ![image-alt-text](image-url) ](URL)
    QRegExp imagelinkRE("\\[\\s*!\\[(.*)\\]\\((.*)\\)\\s*\\]\\((.*)\\)");
    imagelinkRE.setMinimal(true);
    do
    {
        foundMatch = imagelinkRE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            QString imageURL = imagelinkRE.cap(2).trimmed();
            QString imageFilename = MiscHelpers::getCachedImageFilename(imageURL);

            QString linkURL = imagelinkRE.cap(3).trimmed();

            //qDebug() << "image+link found:" << imagelinkRE.cap(0) << imagelinkRE.cap(1) << imagelinkRE.cap(2) << imagelinkRE.cap(3);

            markdownString.replace(imagelinkRE.cap(0),
                                   "<a href=\"" + linkURL
                                   + "\"><img alt=\"" + imagelinkRE.cap(1)
                                   + "\" width=\"420\" src=\""
                                   + imageFilename +"\" /></a>");
//////////////////////
//////////////////////
//////////////////////
//////////////////////
// TODO: FIX THIS!
//////////////////////
//////////////////////
//////////////////////
//////////////////////
        }
    }
    while (foundMatch != -1);




    // Image: ![alt-text](URL)
    QRegExp imageRE("!\\[(.*)\\]\\((.*)\\)");
    imageRE.setMinimal(true);
    do
    {
        foundMatch = imageRE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            QString imageURL = imageRE.cap(2).trimmed();
            //qDebug() << "Post with image:=" << imageURL;

            //QString imageFilename = "file:///cache.path/" + imageURL.toUtf8().toBase64();
            QString imageFilename = MiscHelpers::getCachedImageFilename(imageURL);
            //qDebug() << "Local filename:" << imageFilename;

            // TODO
            // Send SIGNAL() to get imageURL and store as imageFilename
            // done in ::imageList() method for now / FIXME?

            markdownString.replace(imageRE.cap(0),
                                   "<img alt=\"" + imageRE.cap(1) + "\" width=\"420\" src=\""
                                   + imageFilename +"\"></img>");
        }
    }
    while (foundMatch != -1);

    qDebug() << "markdown::tohtml after image";




    /*
     * Non-markdown links (bare links) conversion to HTML links comes first,
     * to avoid messing the markdown-links
     * Some other checks are needed, like checking there's no "(" before "http"
     * --- FIXME ---
     */

    // Non-markdown link: http://something...
    // "http" preceded by space or ;"> from Qt's toHtml() conversion (FIXME!)
    QRegExp bareLinkRE("(\\s+|;\">)(https?://.+)(\\s+|<)");
    bareLinkRE.setMinimal(true);
    foundMatch = 0;
    do
    {
        foundMatch = bareLinkRE.indexIn(markdownString, foundMatch);
        //qDebug() << "\n\n---\n\nfoundMatch:" << foundMatch;
        //qDebug() << markdownString;

        if (foundMatch > -1)
        {
            QString htmlLink = "<a href=\"" + bareLinkRE.cap(2) + "\">"
                               + bareLinkRE.cap(2) +"</a>";

            //qDebug() << "barelinkRE, about to replace()";
            //qDebug() << "foundMatch = " << foundMatch;
            //qDebug() << "markdownString length:" << markdownString.length();

            markdownString.replace(bareLinkRE.cap(2), // replace only the link itself
                                   htmlLink);

            foundMatch += htmlLink.length(); // skip the just-changed link
            //qDebug() << htmlLink;

#if 0
            if (markdownString.length() > 5000) break; //TMP
#endif
        }

        qDebug() << "barelinkRE loop";
    }
    while (foundMatch != -1);

    qDebug() << "markdown::tohtml after barelink";



    // Link: [text](URL)
    QRegExp linkRE("\\[(.*)\\]\\((.*)\\)");
    linkRE.setMinimal(true);
    do
    {
        foundMatch = linkRE.indexIn(markdownString);
        if (foundMatch > -1)
        {
            markdownString.replace(linkRE.cap(0),
                                   "<a href=\"" + linkRE.cap(2) + "\">"
                                   + linkRE.cap(1) +"</a>");
            // FIXME: fails with URL's with parentheses in it, like
            // http://en.wikipedia.org/wiki/Diaspora_(software)
        }
    }
    while (foundMatch != -1);




    //qDebug() << "After conversion:" << markdownString;

    return markdownString;
}





/*
 *  Get list of URL's of images inserted via ![]() sintax
 *
 */
QStringList Markdown::imageList(QString markdownString)
{
    QStringList images;
    int matchPosition = 0;

    QRegExp imageRE("!\\[(.*)\\]\\((.*)\\)");
    imageRE.setMinimal(true);
    do
    {
        matchPosition = imageRE.indexIn(markdownString, matchPosition);
        //qDebug() << "matchPosition:" << matchPosition;

        if (matchPosition > -1)
        {
            matchPosition += imageRE.matchedLength();

            QString imageURL = imageRE.cap(2).trimmed();
            images.append(imageURL);
        }
    }
    while (matchPosition != -1);


    return images;
}
