`plotjointICC.dRm` <-
function(object, item.subset = "all", legend=TRUE, xlim=c(-4,4),ylim=c(0,1),
         xlab="Latent Dimension",ylab="Probability to Solve",lty=1,legpos="left",
         main="ICC plot",col=NULL,...)


#produces one common ICC plot for Rasch models only
#object of class "dRm"
#item.subset...specify items that have to be plotted; if NA, all items are used
#legend...if legend should be plotted

{
  theta <- seq(xlim[1],xlim[2],by=0.1)

  if (any(item.subset=="all")) {
    it.legend <- 1:dim(object$X)[2]
  } else {
    if (is.character(item.subset)) {
      it.legend <- item.subset
      betatemp <- t(as.matrix(object$betapar))
      colnames(betatemp) <- colnames(object$X)
      object$betapar <- betatemp[,item.subset]
    } else {
      it.legend <- colnames(object$X)[item.subset]
      object$betapar <- object$betapar[item.subset]
    }
    object$X <- object$X[,item.subset]                            #pick out items defined in itemvec
  }


  th.ord <- order(theta)

  p.list <- plist.internal(object,theta)
  p.list <- lapply(p.list,function(x) {x[,-1]})               #Delete 0-probabilites
  p.mat <- matrix(unlist(p.list),ncol=length(p.list))
  text.ylab <- p.mat[(1:length(theta))[theta==median(theta)],]

  #dev.new()

  if(is.null(main)) main=""
  if(is.null(col)) col=1:(dim(p.mat)[2])
  #pmICCs<-cbind(sort(theta),p.mat[th.ord,])
  matplot(sort(theta),p.mat[th.ord,],type="l",lty=lty,col=col,
          main=main,xlim=xlim,ylim=ylim,xlab=xlab,ylab=ylab,...)
  if (is.character(legpos)){
     if (!legend) {
         #text(x=median(theta),y=text.ylab,labels=paste("I",1:(dim(p.mat)[2]),sep=""),col=1:(dim(p.mat)[2]))
         text(x=median(theta),y=text.ylab,labels=it.legend,col=1:(dim(p.mat)[2]))
     } else {
         legend(legpos,legend=paste("Item",it.legend),col=1:(dim(p.mat)[2]),lty=lty,...)
     }
  }
}

