/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __VISCWALLINTERACTION_H
#define __VISCWALLINTERACTION_H

#include "Model/WallInteraction.h"
#include "Model/Wall.h"

/*!
  \class CViscWallInteraction
  \brief bonded elastic interaction between a particle and a wall

  \author Steffen Abe
  $Revision$
  $Date$  
*/
template <class T>
class CViscWallInteraction : public AWallInteraction<T>
{
protected:
  double m_nu; //!< viscosity

public:
  //  CViscWallInteraction();
  CViscWallInteraction(T*,CWall*,double,bool);
  virtual ~CViscWallInteraction(){};

  virtual void calcForces();
  virtual Vec3 getForce();
  virtual void setPP(const vector<T*>){};
};

#include "Model/ViscWallInteraction.hpp"

#endif //__VISCWALLINTERACTION_H
