/* $Id: cim_serial.h,v 1.8 2009-01-27 17:44:18 potyra Exp $ 
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CIM_SERIAL_H_INCLUDED
#define __CIM_SERIAL_H_INCLUDED

#include "bridge.h"
#include "sig_serial.h"

/* Maximum data length of a RAW packet. */
#define UMSER_RAW_DATA_LENGTH 508 

/* Serial port RAW protocol packet definition. */
struct umser_msg_raw {
	unsigned int len;				/* lenght of data */
	unsigned char data[UMSER_RAW_DATA_LENGTH];	/* actual data */
};

/* Not used yet. FIXME VOSSI */
struct umser_header {
	unsigned command:2;	/* 0x0 normal data, 0x1 break */
	unsigned parity:3;	/* see line control register */
	unsigned wordlen:2;	/* see line control register */
	unsigned stoplen:1;	/* see line control register */
	unsigned datalen:16;	/* length of the whole frame */
	unsigned char dll;
	unsigned char dlh;
};

#define CMD_DATA	0x0
#define CMD_BREAK	0x1

struct cim_serial {
	struct bridge bridge;

	struct sig_serial *sig_serial;
};

extern void
cim_serial_init(struct cim_serial *css, struct sig_serial *sig_serial);

extern void
cim_serial_create(struct cim_serial *css);
extern void
cim_serial_destroy(struct cim_serial *css);

#endif /* __CIM_SERIAL_H_INCLUDED */
