/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.Components.ListItems 0.1 as ListItem
import Ubuntu.Components.Popups 0.1

Column {
    id: details
    height: childrenRect.height

    function reset() {
        replyArea.reset()
    }

    Image {
        id: mapimage
        width: visible ? Math.round(Math.min(parent.width * 0.8, units.gu(20))) : 0
        height: visible ? Math.round(Math.min(parent.width * 0.8, units.gu(20))) : 0
        anchors.horizontalCenter: parent.horizontalCenter

        source: {
            return "http://open.mapquestapi.com/staticmap/v4/getmap?size=" +
                    Math.round(Math.min(parent.width * 0.8, units.gu(20))) + "," +
                    Math.round(Math.min(parent.width * 0.8, units.gu(20))) +
                    "&zoom=12&center=" + latitude + "," + longitude

        }
        visible: location.length > 0
    }

    ThreadView {
        id: threadView
        width: parent.width
    }

    Item {
        id: bottom

        width: parent.width
        height: childrenRect.height

        ReplyArea {
            id: replyArea

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
                topMargin: units.gu(2)
            }
        }

        // Back button (much faster than using the toolbar)
        // At the bottom so it doesn't steal any space (content is flickable)
        Button {
            id: returnButton

            anchors {
                top: replyArea.bottom
                left: parent.left
                margins: units.gu(5)
            }

            width: parent.width > units.gu(50) ? units.gu(40) : parent.width - units.gu(10)

            text: i18n.tr("Return to feed")

            height: units.gu(6)

            onClicked: {
                conversationPage.close()
            }
        }
    }

    Component {
        id: errorPopover
        Popover {
            Column {
                anchors {
                    left: parent.left
                    top: parent.top
                    right: parent.right
                }
                ListItem.Standard {
                    text: i18n.tr("An error occured")
                }
            }
        }
    }
}
