/*
 * purple - Xfire Protocol Plugin
 *
 * This file is part of Gfire.
 *
 * See the AUTHORS file distributed with Gfire for a full list of
 * all contributors and this files copyright holders.
 *
 * Gfire is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Gfire.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _GF_BUDDIES_PROTO_H
#define _GF_BUDDIES_PROTO_H

#include "gf_base.h"
#include "gf_games.h"
#include "gfire.h"

// Packet creation
guint16 gfire_buddy_proto_create_advanced_info_request(guint32 p_userid);
guint16 gfire_buddy_proto_create_typing_notification(const guint8 *p_sid, guint32 p_imindex, gboolean p_typing);
guint16 gfire_buddy_proto_create_send_im(const guint8 *p_sid, guint32 p_imindex, const gchar *p_msg);
guint16 gfire_buddy_proto_create_fof_request(GList *p_sids);
guint16 gfire_buddy_proto_create_ack(const guint8 *p_sid, guint32 p_imindex);
guint16 gfire_buddy_proto_create_p2p(const guint8 *p_sid, guint32 p_ip, guint16 p_port, guint32 p_local_ip, guint16 p_local_port, guint32 p_nat_type, const gchar *p_salt);

// Packet parsing
void gfire_buddy_proto_on_off(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_game_status(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_voip_status(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_status_msg(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_alias_change(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_changed_avatar(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_clans(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_im(gfire_data *p_gfire, guint16 packet_len);
void gfire_buddy_proto_fof_list(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_clan_alias_change(gfire_data *p_gfire, guint16 p_packet_len);
void gfire_buddy_proto_game_client_data(gfire_data *p_gfire, guint16 p_packet_len);

#endif // _GF_BUDDIES_PROTO_H
