# -*- coding: UTF-8 -*-
#
# generated by wxGlade
#

import wx

# begin wxGlade: dependencies
import gettext
# end wxGlade

# begin wxGlade: extracode
# end wxGlade


class wxgAllergyManagerDlg(wx.Dialog):
	def __init__(self, *args, **kwds):
		# begin wxGlade: wxgAllergyManagerDlg.__init__
		kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE | wx.MAXIMIZE_BOX | wx.MINIMIZE_BOX | wx.RESIZE_BORDER
		wx.Dialog.__init__(self, *args, **kwds)
		self.SetSize((650, 500))
		self._TXT_current_state = wx.StaticText(self, wx.ID_ANY, _("<current allergy state>"))
		self._TXT_last_confirmed = wx.StaticText(self, wx.ID_ANY, _("<last confirmed>"))
		self._RBTN_unknown = wx.RadioButton(self, wx.ID_ANY, _("Unknown"))
		self._RBTN_none = wx.RadioButton(self, wx.ID_ANY, _("No known allergies"))
		self._RBTN_some = wx.RadioButton(self, wx.ID_ANY, _("Has allergies"))
		self._TCTRL_state_comment = wx.TextCtrl(self, wx.ID_ANY, "")
		self._BTN_confirm = wx.Button(self, wx.ID_ANY, _("&Update / Confirm"))
		from Gnumed.wxpython.gmListWidgets import cReportListCtrl
		self._LCTRL_allergies = cReportListCtrl(self, wx.ID_ANY, style=wx.BORDER_NONE | wx.LC_REPORT | wx.LC_SINGLE_SEL)
		self._LBL_message = wx.StaticText(self, wx.ID_ANY, _("Input new allergy, or select from among existing allergy items to edit them:"))
		from Gnumed.wxpython.gmAllergyWidgets import cAllergyEditAreaPnl
		self._PNL_edit_area = cAllergyEditAreaPnl(self, wx.ID_ANY, style=wx.BORDER_NONE | wx.TAB_TRAVERSAL)
		self._BTN_save_details = wx.Button(self, wx.ID_SAVE, "", style=wx.BU_EXACTFIT)
		self._BTN_clear = wx.Button(self, wx.ID_CLEAR, "", style=wx.BU_EXACTFIT)
		self._BTN_delete = wx.Button(self, wx.ID_DELETE, "", style=wx.BU_EXACTFIT)
		self.__hline_bottom = wx.StaticLine(self, wx.ID_ANY)
		self._BTN_dismiss = wx.Button(self, wx.ID_CLOSE, "")

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_BUTTON, self._on_confirm_button_pressed, self._BTN_confirm)
		self.Bind(wx.EVT_LIST_ITEM_SELECTED, self._on_list_item_selected, self._LCTRL_allergies)
		self.Bind(wx.EVT_BUTTON, self._on_save_details_button_pressed, self._BTN_save_details)
		self.Bind(wx.EVT_BUTTON, self._on_clear_button_pressed, self._BTN_clear)
		self.Bind(wx.EVT_BUTTON, self._on_delete_button_pressed, self._BTN_delete)
		self.Bind(wx.EVT_BUTTON, self._on_dismiss_button_pressed, self._BTN_dismiss)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: wxgAllergyManagerDlg.__set_properties
		self.SetTitle(_("Allergy Manager"))
		self.SetSize((650, 500))
		self._TXT_current_state.SetToolTip(_("This displays the current allergy state as saved in the database."))
		self._TXT_last_confirmed.SetToolTip(_("When was the allergy state last confirmed."))
		self._RBTN_unknown.SetToolTip(_("Select this if there is no information available on whether the patient has any allergies or not."))
		self._RBTN_none.SetToolTip(_("Select this if the patient has no known allergies."))
		self._RBTN_some.SetToolTip(_("Select this if the patient has known allergies."))
		self._TCTRL_state_comment.SetToolTip(_("A comment on the allergy state."))
		self._BTN_confirm.SetFont(wx.Font(10, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
		self._BTN_confirm.SetToolTip(_("Save and confirm the allergy state."))
		self._LCTRL_allergies.SetToolTip(_("Lists the allergies known for this patient if any."))
		self._BTN_save_details.SetToolTip(_("Save the allergy details in the edit area as either a new allergy or as an update to the existing allergy selected above."))
		self._BTN_clear.SetToolTip(_("Clear the fields of the edit area. Will discard unsaved data."))
		self._BTN_delete.SetToolTip(_("Delete the allergy selected in the list from the database."))
		self._BTN_delete.Enable(False)
		self._BTN_dismiss.SetToolTip(_("Close the dialag. Will discard unsaved data."))
		self._BTN_dismiss.SetDefault()
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: wxgAllergyManagerDlg.__do_layout
		__szr_main = wx.BoxSizer(wx.VERTICAL)
		__szr_bottom = wx.BoxSizer(wx.HORIZONTAL)
		__szr_details = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Allergy details")), wx.VERTICAL)
		__szr_buttons = wx.BoxSizer(wx.HORIZONTAL)
		__szr_state = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Allergy state")), wx.VERTICAL)
		__szr_state_button = wx.BoxSizer(wx.HORIZONTAL)
		__gszr_state = wx.FlexGridSizer(3, 2, 2, 10)
		__szr_new_state = wx.BoxSizer(wx.HORIZONTAL)
		__szr_current_state = wx.BoxSizer(wx.HORIZONTAL)
		__LBL_state = wx.StaticText(self, wx.ID_ANY, _("Currently:"))
		__gszr_state.Add(__LBL_state, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_current_state.Add(self._TXT_current_state, 1, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 15)
		__LBL_confirmed = wx.StaticText(self, wx.ID_ANY, _("Last confirmed:"))
		__szr_current_state.Add(__LBL_confirmed, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		__szr_current_state.Add(self._TXT_last_confirmed, 1, wx.ALIGN_CENTER_VERTICAL, 0)
		__gszr_state.Add(__szr_current_state, 1, wx.EXPAND, 0)
		__LBL_set_state = wx.StaticText(self, wx.ID_ANY, _("Set to:"))
		__gszr_state.Add(__LBL_set_state, 0, wx.ALIGN_CENTER_VERTICAL, 15)
		__szr_new_state.Add(self._RBTN_unknown, 0, wx.EXPAND | wx.RIGHT, 10)
		__szr_new_state.Add(self._RBTN_none, 0, wx.EXPAND | wx.RIGHT, 10)
		__szr_new_state.Add(self._RBTN_some, 0, wx.EXPAND, 10)
		__gszr_state.Add(__szr_new_state, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 5)
		__LBL_comment = wx.StaticText(self, wx.ID_ANY, _("Comment:"))
		__gszr_state.Add(__LBL_comment, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__gszr_state.Add(self._TCTRL_state_comment, 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__gszr_state.AddGrowableCol(1)
		__szr_state.Add(__gszr_state, 1, wx.BOTTOM | wx.EXPAND, 5)
		__szr_state_button.Add((20, 20), 1, wx.EXPAND, 0)
		__szr_state_button.Add(self._BTN_confirm, 0, wx.EXPAND, 0)
		__szr_state_button.Add((20, 20), 1, wx.EXPAND, 0)
		__szr_state.Add(__szr_state_button, 0, wx.EXPAND, 0)
		__szr_main.Add(__szr_state, 0, wx.ALL | wx.EXPAND, 5)
		__szr_details.Add(self._LCTRL_allergies, 2, wx.BOTTOM | wx.EXPAND, 10)
		__szr_details.Add(self._LBL_message, 0, wx.ALIGN_CENTER_VERTICAL | wx.BOTTOM, 3)
		__szr_details.Add(self._PNL_edit_area, 2, wx.BOTTOM | wx.EXPAND, 5)
		__szr_buttons.Add(self._BTN_save_details, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.RIGHT, 5)
		__szr_buttons.Add(self._BTN_clear, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.RIGHT, 5)
		__szr_buttons.Add(self._BTN_delete, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 5)
		__szr_buttons.Add((20, 20), 2, wx.EXPAND, 0)
		__szr_details.Add(__szr_buttons, 0, wx.EXPAND, 5)
		__szr_main.Add(__szr_details, 1, wx.BOTTOM | wx.EXPAND | wx.LEFT | wx.RIGHT, 5)
		__szr_main.Add(self.__hline_bottom, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.LEFT | wx.RIGHT, 2)
		__szr_bottom.Add((20, 20), 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_bottom.Add(self._BTN_dismiss, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_bottom.Add((20, 20), 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_main.Add(__szr_bottom, 0, wx.EXPAND | wx.TOP, 5)
		self.SetSizer(__szr_main)
		self.Layout()
		self.Centre()
		# end wxGlade

	def _on_confirm_button_pressed(self, event):  # wxGlade: wxgAllergyManagerDlg.<event_handler>
		print("Event handler '_on_confirm_button_pressed' not implemented!")
		event.Skip()

	def _on_list_item_selected(self, event):  # wxGlade: wxgAllergyManagerDlg.<event_handler>
		print("Event handler '_on_list_item_selected' not implemented!")
		event.Skip()

	def _on_save_details_button_pressed(self, event):  # wxGlade: wxgAllergyManagerDlg.<event_handler>
		print("Event handler '_on_save_details_button_pressed' not implemented!")
		event.Skip()

	def _on_clear_button_pressed(self, event):  # wxGlade: wxgAllergyManagerDlg.<event_handler>
		print("Event handler '_on_clear_button_pressed' not implemented!")
		event.Skip()

	def _on_delete_button_pressed(self, event):  # wxGlade: wxgAllergyManagerDlg.<event_handler>
		print("Event handler '_on_delete_button_pressed' not implemented!")
		event.Skip()

	def _on_dismiss_button_pressed(self, event):  # wxGlade: wxgAllergyManagerDlg.<event_handler>
		print("Event handler '_on_dismiss_button_pressed' not implemented!")
		event.Skip()

# end of class wxgAllergyManagerDlg
