// Code generated by smithy-go-codegen DO NOT EDIT.

package qldbsession

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/qldbsession/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpSendCommand struct {
}

func (*validateOpSendCommand) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSendCommand) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SendCommandInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSendCommandInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpSendCommandValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSendCommand{}, middleware.After)
}

func validateCommitTransactionRequest(v *types.CommitTransactionRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CommitTransactionRequest"}
	if v.TransactionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TransactionId"))
	}
	if v.CommitDigest == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CommitDigest"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExecuteStatementRequest(v *types.ExecuteStatementRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExecuteStatementRequest"}
	if v.TransactionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TransactionId"))
	}
	if v.Statement == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Statement"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFetchPageRequest(v *types.FetchPageRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FetchPageRequest"}
	if v.TransactionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TransactionId"))
	}
	if v.NextPageToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NextPageToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStartSessionRequest(v *types.StartSessionRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartSessionRequest"}
	if v.LedgerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LedgerName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSendCommandInput(v *SendCommandInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SendCommandInput"}
	if v.StartSession != nil {
		if err := validateStartSessionRequest(v.StartSession); err != nil {
			invalidParams.AddNested("StartSession", err.(smithy.InvalidParamsError))
		}
	}
	if v.CommitTransaction != nil {
		if err := validateCommitTransactionRequest(v.CommitTransaction); err != nil {
			invalidParams.AddNested("CommitTransaction", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExecuteStatement != nil {
		if err := validateExecuteStatementRequest(v.ExecuteStatement); err != nil {
			invalidParams.AddNested("ExecuteStatement", err.(smithy.InvalidParamsError))
		}
	}
	if v.FetchPage != nil {
		if err := validateFetchPageRequest(v.FetchPage); err != nil {
			invalidParams.AddNested("FetchPage", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
