// Copyright 2013 Canonical Ltd.
// Licensed under the LGPLv3, see LICENCE file for details.

package names

import (
	gc "gopkg.in/check.v1"
)

var tagEqualityTests = []struct {
	expected Tag
	want     Tag
}{
	{NewMachineTag("0"), MachineTag{id: "0"}},
	{NewMachineTag("10/lxc/1"), MachineTag{id: "10-lxc-1"}},
	{NewUnitTag("mysql/1"), UnitTag{name: "mysql-1"}},
	{NewApplicationTag("ceph"), ApplicationTag{Name: "ceph"}},
	{NewRelationTag("wordpress:haproxy"), RelationTag{key: "wordpress.haproxy"}},
	{NewEnvironTag("deadbeef-0123-4567-89ab-feedfacebeef"), EnvironTag{uuid: "deadbeef-0123-4567-89ab-feedfacebeef"}},
	{NewUserTag("admin"), UserTag{name: "admin"}},
	{NewUserTag("admin@local"), UserTag{name: "admin", domain: ""}},
	{NewUserTag("admin@foobar"), UserTag{name: "admin", domain: "foobar"}},
	{NewActionTag("01234567-aaaa-4bbb-8ccc-012345678901"), ActionTag{ID: "01234567-aaaa-4bbb-8ccc-012345678901"}},
	{NewActionTag("1"), ActionTag{ID: "1"}},
	{NewControllerAgentTag("1"), ControllerAgentTag{id: "1"}},
}

type equalitySuite struct{}

var _ = gc.Suite(&equalitySuite{})

func (s *equalitySuite) TestTagEquality(c *gc.C) {
	for _, tt := range tagEqualityTests {
		c.Check(tt.want, gc.Equals, tt.expected)
	}
}
