/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://discord.gg/8naAwJfWN6
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// ReadResponse struct for ReadResponse
type ReadResponse struct {
	Tuples []Tuple `json:"tuples"yaml:"tuples"`
	// The continuation token will be empty if there are no more tuples.
	ContinuationToken string `json:"continuation_token"yaml:"continuation_token"`
}

// NewReadResponse instantiates a new ReadResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewReadResponse(tuples []Tuple, continuationToken string) *ReadResponse {
	this := ReadResponse{}
	this.Tuples = tuples
	this.ContinuationToken = continuationToken
	return &this
}

// NewReadResponseWithDefaults instantiates a new ReadResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewReadResponseWithDefaults() *ReadResponse {
	this := ReadResponse{}
	return &this
}

// GetTuples returns the Tuples field value
func (o *ReadResponse) GetTuples() []Tuple {
	if o == nil {
		var ret []Tuple
		return ret
	}

	return o.Tuples
}

// GetTuplesOk returns a tuple with the Tuples field value
// and a boolean to check if the value has been set.
func (o *ReadResponse) GetTuplesOk() (*[]Tuple, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Tuples, true
}

// SetTuples sets field value
func (o *ReadResponse) SetTuples(v []Tuple) {
	o.Tuples = v
}

// GetContinuationToken returns the ContinuationToken field value
func (o *ReadResponse) GetContinuationToken() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ContinuationToken
}

// GetContinuationTokenOk returns a tuple with the ContinuationToken field value
// and a boolean to check if the value has been set.
func (o *ReadResponse) GetContinuationTokenOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ContinuationToken, true
}

// SetContinuationToken sets field value
func (o *ReadResponse) SetContinuationToken(v string) {
	o.ContinuationToken = v
}

func (o ReadResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["tuples"] = o.Tuples
	toSerialize["continuation_token"] = o.ContinuationToken
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableReadResponse struct {
	value *ReadResponse
	isSet bool
}

func (v NullableReadResponse) Get() *ReadResponse {
	return v.value
}

func (v *NullableReadResponse) Set(val *ReadResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableReadResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableReadResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableReadResponse(val *ReadResponse) *NullableReadResponse {
	return &NullableReadResponse{value: val, isSet: true}
}

func (v NullableReadResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableReadResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
