<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

	  const Err1 = "Security error: Call to private object member not allowed";
	  const Err2 = "Security error: Call to dynamic object member not allowed";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
				$this->block_nesting_level = 0;
				if ($this->security = isset($this->smarty->security_policy)) {
              $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
              $this->php_handling = $this->smarty->php_handling;
        }
				$this->is_xml = false;
				$this->asp_tags = (ini_get('asp_tags') != '0');
				$this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       return '?<?php ?>>';
    }


#line 121 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_OTHER                          = 10;
    const TP_LINEBREAK                      = 11;
    const TP_LITERALSTART                   = 12;
    const TP_LITERALEND                     = 13;
    const TP_LITERAL                        = 14;
    const TP_LDEL                           = 15;
    const TP_RDEL                           = 16;
    const TP_DOLLAR                         = 17;
    const TP_ID                             = 18;
    const TP_EQUAL                          = 19;
    const TP_PTR                            = 20;
    const TP_LDELIF                         = 21;
    const TP_LDELFOR                        = 22;
    const TP_SEMICOLON                      = 23;
    const TP_INCDEC                         = 24;
    const TP_TO                             = 25;
    const TP_STEP                           = 26;
    const TP_LDELFOREACH                    = 27;
    const TP_SPACE                          = 28;
    const TP_AS                             = 29;
    const TP_APTR                           = 30;
    const TP_SMARTYBLOCKCHILD               = 31;
    const TP_LDELSLASH                      = 32;
    const TP_INTEGER                        = 33;
    const TP_COMMA                          = 34;
    const TP_OPENP                          = 35;
    const TP_CLOSEP                         = 36;
    const TP_MATH                           = 37;
    const TP_UNIMATH                        = 38;
    const TP_ANDSYM                         = 39;
    const TP_ISIN                           = 40;
    const TP_ISDIVBY                        = 41;
    const TP_ISNOTDIVBY                     = 42;
    const TP_ISEVEN                         = 43;
    const TP_ISNOTEVEN                      = 44;
    const TP_ISEVENBY                       = 45;
    const TP_ISNOTEVENBY                    = 46;
    const TP_ISODD                          = 47;
    const TP_ISNOTODD                       = 48;
    const TP_ISODDBY                        = 49;
    const TP_ISNOTODDBY                     = 50;
    const TP_INSTANCEOF                     = 51;
    const TP_QMARK                          = 52;
    const TP_NOT                            = 53;
    const TP_TYPECAST                       = 54;
    const TP_HEX                            = 55;
    const TP_DOT                            = 56;
    const TP_SINGLEQUOTESTRING              = 57;
    const TP_DOUBLECOLON                    = 58;
    const TP_AT                             = 59;
    const TP_HATCH                          = 60;
    const TP_OPENB                          = 61;
    const TP_CLOSEB                         = 62;
    const TP_EQUALS                         = 63;
    const TP_NOTEQUALS                      = 64;
    const TP_GREATERTHAN                    = 65;
    const TP_LESSTHAN                       = 66;
    const TP_GREATEREQUAL                   = 67;
    const TP_LESSEQUAL                      = 68;
    const TP_IDENTITY                       = 69;
    const TP_NONEIDENTITY                   = 70;
    const TP_MOD                            = 71;
    const TP_LAND                           = 72;
    const TP_LOR                            = 73;
    const TP_LXOR                           = 74;
    const TP_QUOTE                          = 75;
    const TP_BACKTICK                       = 76;
    const TP_DOLLARID                       = 77;
    const YY_NO_ACTION = 590;
    const YY_ACCEPT_ACTION = 589;
    const YY_ERROR_ACTION = 588;

    const YY_SZ_ACTTAB = 2637;
static public $yy_action = array(
 /*     0 */   223,  300,  294,  293,  288,  287,  286,  290,  291,  301,
 /*    10 */   197,   13,  211,   40,  283,  373,  284,    8,   13,    7,
 /*    20 */   107,  283,   41,  203,   16,  147,  234,   16,   16,  276,
 /*    30 */   245,  589,   97,  296,  297,  299,   50,   46,   48,   45,
 /*    40 */    14,   28,  330,  352,   38,   32,  353,  371,   36,   34,
 /*    50 */   223,  311,  306,  307,  285,  303,  295,  297,  299,  197,
 /*    60 */   312,  316,  379,  359,  358,  357,  366,  319,  274,  270,
 /*    70 */   267,  255,  256,  258,  362,   35,   21,   16,  141,  169,
 /*    80 */   223,  199,   17,    3,  146,  337,   50,   46,   48,   45,
 /*    90 */    14,   28,  330,  352,   38,   32,  353,  371,   36,   34,
 /*   100 */   341,  109,  180,   25,  242,  161,  137,  206,    3,   26,
 /*   110 */   360,  259,  379,  359,  358,  357,  366,  319,  274,  270,
 /*   120 */   267,  255,  256,  258,  223,  304,  347,  206,  172,  142,
 /*   130 */    47,  137,  244,   75,  127,  454,  262,  259,   19,  356,
 /*   140 */    13,  329,  266,  283,   41,  343,  321,  454,  310,  104,
 /*   150 */   163,   16,  383,  203,    3,  217,  236,  237,  220,  259,
 /*   160 */    50,   46,   48,   45,   14,   28,  330,  352,   38,   32,
 /*   170 */   353,  371,   36,   34,  191,  206,   13,  137,    4,  283,
 /*   180 */    24,  200,  332,  259,  227,  263,  379,  359,  358,  357,
 /*   190 */   366,  319,  274,  270,  267,  255,  256,  258,  223,  304,
 /*   200 */   110,  162,  223,  142,  192,  332,  244,   75,  127,  451,
 /*   210 */   259,   13,  223,  260,  283,  329,  266,  384,  161,  343,
 /*   220 */   321,  451,  310,  108,  183,   16,  206,  268,    3,  216,
 /*   230 */    27,  246,  174,  259,   50,   46,   48,   45,   14,   28,
 /*   240 */   330,  352,   38,   32,  353,  371,   36,   34,  173,  206,
 /*   250 */     5,  137,   47,   13,  211,  227,  283,  259,  381,    8,
 /*   260 */   379,  359,  358,  357,  366,  319,  274,  270,  267,  255,
 /*   270 */   256,  258,  223,  304,  170,  181,  324,  142,  196,  332,
 /*   280 */   244,   66,  118,  238,  259,   13,  335,  204,  283,  329,
 /*   290 */   266,   39,  161,  343,  321,  281,  310,  243,   16,  232,
 /*   300 */   239,    3,   23,   23,  386,  365,  251,  231,   50,   46,
 /*   310 */    48,   45,   14,   28,  330,  352,   38,   32,  353,  371,
 /*   320 */    36,   34,  111,  326,  137,   23,   13,  376,  223,  283,
 /*   330 */   136,  198,   42,  161,  379,  359,  358,  357,  366,  319,
 /*   340 */   274,  270,  267,  255,  256,  258,  223,  304,  166,  188,
 /*   350 */   178,  142,  281,  298,  244,   75,  127,  259,  259,   13,
 /*   360 */   223,  368,  283,  329,  266,   16,  278,  343,  321,  281,
 /*   370 */   310,  136,   16,  203,    2,  272,   13,  215,   16,  252,
 /*   380 */   138,  247,   50,   46,   48,   45,   14,   28,  330,  352,
 /*   390 */    38,   32,  353,  371,   36,   34,  223,  177,  317,  223,
 /*   400 */   314,  190,  327,  236,  238,  248,  259,  148,  379,  359,
 /*   410 */   358,  357,  366,  319,  274,  270,  267,  255,  256,  258,
 /*   420 */   195,  310,  203,  106,  236,  261,   13,  206,  184,  218,
 /*   430 */   103,  250,   50,   46,   48,   45,   14,   28,  330,  352,
 /*   440 */    38,   32,  353,  371,   36,   34,  223,   22,  176,   47,
 /*   450 */   235,  362,  132,   13,  206,  320,  226,  259,  379,  359,
 /*   460 */   358,  357,  366,  319,  274,  270,  267,  255,  256,  258,
 /*   470 */   133,  322,  185,  203,   13,  223,  345,  230,  149,  241,
 /*   480 */   145,  259,   50,   46,   48,   45,   14,   28,  330,  352,
 /*   490 */    38,   32,  353,  371,   36,   34,  223,  203,  175,  134,
 /*   500 */   281,  354,   16,  121,  131,   37,  202,  119,  379,  359,
 /*   510 */   358,  357,  366,  319,  274,  270,  267,  255,  256,  258,
 /*   520 */   338,  171,  377,   96,  382,  385,  305,   31,  328,  149,
 /*   530 */   259,  367,   50,   46,   48,   45,   14,   28,  330,  352,
 /*   540 */    38,   32,  353,  371,   36,   34,  223,  224,    9,  374,
 /*   550 */   228,  140,    5,  129,   42,  139,  372,  370,  379,  359,
 /*   560 */   358,  357,  366,  319,  274,  270,  267,  255,  256,  258,
 /*   570 */   193,  309,  168,  279,  324,   12,  281,   20,   16,   44,
 /*   580 */   378,  135,   50,   46,   48,   45,   14,   28,  330,  352,
 /*   590 */    38,   32,  353,  371,   36,   34,  223,  112,  313,  323,
 /*   600 */   323,  323,  323,  323,  323,  323,  323,   99,  379,  359,
 /*   610 */   358,  357,  366,  319,  274,  270,  267,  255,  256,  258,
 /*   620 */   338,  348,  323,   16,  323,  323,  323,  323,  323,  323,
 /*   630 */   323,  323,   50,   46,   48,   45,   14,   28,  330,  352,
 /*   640 */    38,   32,  353,  371,   36,   34,  323,  323,  323,  323,
 /*   650 */   323,  323,  323,  323,  323,  323,  323,  323,  379,  359,
 /*   660 */   358,  357,  366,  319,  274,  270,  267,  255,  256,  258,
 /*   670 */   223,  223,  323,  304,  101,  165,  223,  142,  228,  323,
 /*   680 */   244,   53,  118,  126,  259,   11,  456,   29,   15,  329,
 /*   690 */   266,  456,  201,  343,  321,   30,  310,  323,  456,  233,
 /*   700 */   206,  323,  323,  456,  323,  223,   50,   46,   48,   45,
 /*   710 */    14,   28,  330,  352,   38,   32,  353,  371,   36,   34,
 /*   720 */   269,   47,  224,  323,  323,  323,   47,  323,  323,  323,
 /*   730 */   323,  323,  379,  359,  358,  357,  366,  319,  274,  270,
 /*   740 */   267,  255,  256,  258,  223,  323,  323,  323,  194,  186,
 /*   750 */   323,  257,  363,  289,  323,  325,  264,  254,  259,  205,
 /*   760 */    43,   29,   15,   16,   16,   16,    7,  107,   16,   16,
 /*   770 */   323,  323,  147,  323,  206,  323,  276,  245,  323,  323,
 /*   780 */    50,   46,   48,   45,   14,   28,  330,  352,   38,   32,
 /*   790 */   353,  371,   36,   34,  223,  323,  323,  323,  323,  323,
 /*   800 */   323,  323,  323,  323,  323,  124,  379,  359,  358,  357,
 /*   810 */   366,  319,  274,  270,  267,  255,  256,  258,  338,  323,
 /*   820 */   344,   18,  336,  323,  323,  323,  323,  323,  323,  323,
 /*   830 */    50,   46,   48,   45,   14,   28,  330,  352,   38,   32,
 /*   840 */   353,  371,   36,   34,  323,  323,  323,  323,  323,  323,
 /*   850 */   323,  323,  323,  323,  323,  369,  379,  359,  358,  357,
 /*   860 */   366,  319,  274,  270,  267,  255,  256,  258,  223,  304,
 /*   870 */   323,  164,  361,  142,  323,  339,  244,   80,  127,  167,
 /*   880 */   259,  342,  375,  275,   16,  329,  266,   16,  259,  343,
 /*   890 */   321,  281,  310,   16,   16,  323,  323,  323,  323,  281,
 /*   900 */   323,  323,  323,  323,   50,   46,   48,   45,   14,   28,
 /*   910 */   330,  352,   38,   32,  353,  371,   36,   34,  223,  323,
 /*   920 */   323,  323,  323,  323,  323,  323,  323,  323,  323,  117,
 /*   930 */   379,  359,  358,  357,  366,  319,  274,  270,  267,  255,
 /*   940 */   256,  258,  338,  323,  323,  323,  240,  323,  323,  323,
 /*   950 */   323,  323,  323,  323,   50,   46,   48,   45,   14,   28,
 /*   960 */   330,  352,   38,   32,  353,  371,   36,   34,  223,  323,
 /*   970 */   323,  323,  323,  323,  323,  323,  323,  323,  323,  102,
 /*   980 */   379,  359,  358,  357,  366,  319,  274,  270,  267,  255,
 /*   990 */   256,  258,  338,  323,  323,  323,  323,  323,  323,  323,
 /*  1000 */   323,  323,  323,  323,   50,   46,   48,   45,   14,   28,
 /*  1010 */   330,  352,   38,   32,  353,  371,   36,   34,  323,  335,
 /*  1020 */   323,  323,  323,  323,  323,  323,  161,  323,  323,  323,
 /*  1030 */   379,  359,  358,  357,  366,  319,  274,  270,  267,  255,
 /*  1040 */   256,  258,   50,   46,   48,   45,   14,   28,  330,  352,
 /*  1050 */    38,   32,  353,  371,   36,   34,  351,  323,  323,  323,
 /*  1060 */   323,  323,  323,  323,  136,  323,  223,  323,  379,  359,
 /*  1070 */   358,  357,  366,  319,  274,  270,  267,  255,  256,  258,
 /*  1080 */   150,  271,  160,  323,   40,  323,  143,  210,  323,  323,
 /*  1090 */     7,  107,  281,  302,  253,  338,  147,  323,  325,  323,
 /*  1100 */   276,  245,  229,   43,   33,   16,   16,   51,  323,    7,
 /*  1110 */   107,  323,  323,  323,  323,  147,  323,  323,  323,  276,
 /*  1120 */   245,  194,   52,   49,  380,  225,  349,  105,  323,  106,
 /*  1130 */     1,  355,  323,  223,   29,   15,  323,  280,  315,   40,
 /*  1140 */   338,  143,  214,  223,   98,    7,  107,  206,  453,   16,
 /*  1150 */    16,  147,  323,  323,  323,  276,  245,  229,  450,   33,
 /*  1160 */   453,  265,   51,  350,   18,  336,  362,  304,  323,  115,
 /*  1170 */    16,  152,  323,   16,  244,  323,  127,   52,   49,  380,
 /*  1180 */   225,  349,  338,   47,  106,    1,  323,  343,  321,  223,
 /*  1190 */   310,  318,  323,  323,   40,  323,  138,  214,  304,   98,
 /*  1200 */     7,  107,  159,   16,  346,  244,  147,  127,  249,  323,
 /*  1210 */   276,  245,  229,  340,   10,  273,   16,   51,  343,  321,
 /*  1220 */   323,  310,  304,    3,  323,   16,  153,  323,  323,  244,
 /*  1230 */   323,  127,   52,   49,  380,  225,  349,  323,  331,  106,
 /*  1240 */     1,  323,  343,  321,  223,  310,  137,  223,  277,   40,
 /*  1250 */    16,  128,   92,  223,   98,    7,  107,  323,  323,  450,
 /*  1260 */    16,  147,  282,  323,  292,  276,  245,  229,  308,   33,
 /*  1270 */   362,   16,   51,  323,   16,   16,   16,  304,  323,  144,
 /*  1280 */    16,  157,  323,  323,  244,  323,  127,   52,   49,  380,
 /*  1290 */   225,  349,  338,  323,  106,    1,  323,  343,  321,  100,
 /*  1300 */   310,  323,  323,   47,   40,  323,  143,  212,  323,   98,
 /*  1310 */     7,  107,  338,  323,  323,  323,  147,  323,  323,  323,
 /*  1320 */   276,  245,  229,  323,   33,  323,  323,   51,  323,  323,
 /*  1330 */   323,  323,  304,  323,  323,  323,  151,  323,  323,  244,
 /*  1340 */   323,  127,   52,   49,  380,  225,  349,  323,  323,  106,
 /*  1350 */     1,  323,  343,  321,  323,  310,  323,  323,  323,   40,
 /*  1360 */   323,  125,  214,  323,   98,    7,  107,  323,  323,  323,
 /*  1370 */   323,  147,  323,  323,  323,  276,  245,  229,  323,   33,
 /*  1380 */   323,  323,   51,  323,  323,  323,  323,  304,  323,  323,
 /*  1390 */   323,  155,  323,  323,  244,  323,  127,   52,   49,  380,
 /*  1400 */   225,  349,  323,  323,  106,    1,  323,  343,  321,  323,
 /*  1410 */   310,  323,  323,  323,   40,  323,  130,  214,  323,   98,
 /*  1420 */     7,  107,  323,  323,  323,  323,  147,  323,  323,  323,
 /*  1430 */   276,  245,  229,  323,    6,  323,  323,   51,  323,  323,
 /*  1440 */   323,  323,  304,  323,  323,  323,  154,  323,  323,  244,
 /*  1450 */   323,  127,   52,   49,  380,  225,  349,  323,  323,  106,
 /*  1460 */     1,  323,  343,  321,  323,  310,  323,  323,  323,   40,
 /*  1470 */   323,  143,  209,  323,   98,    7,  107,  323,  323,  323,
 /*  1480 */   323,  147,  323,  323,  323,  276,  245,  229,  323,   33,
 /*  1490 */   323,  323,   51,  323,  323,  323,  323,  304,  323,  323,
 /*  1500 */   323,  158,  323,  323,  244,  323,  127,   52,   49,  380,
 /*  1510 */   225,  349,  323,  323,  106,    1,  323,  343,  321,  323,
 /*  1520 */   310,  323,  323,  323,   40,  323,  143,  208,  323,   98,
 /*  1530 */     7,  107,  323,  323,  323,  323,  147,  323,  323,  323,
 /*  1540 */   276,  245,  222,  323,   33,  323,  323,   51,  323,  323,
 /*  1550 */   323,  323,  323,  323,  323,  323,  323,  323,  323,  323,
 /*  1560 */   323,  323,   52,   49,  380,  225,  349,  323,  323,  106,
 /*  1570 */     1,  323,  323,  323,  323,  323,  323,  323,  323,   40,
 /*  1580 */   323,  143,  207,  323,   98,    7,  107,  323,  323,  323,
 /*  1590 */   323,  147,  323,  323,  323,  276,  245,  229,  323,   33,
 /*  1600 */   323,  323,   51,  323,  323,  323,  323,  323,  323,  323,
 /*  1610 */   323,  323,  323,  323,  323,  323,  323,   52,   49,  380,
 /*  1620 */   225,  349,  323,  323,  106,    1,  323,  323,  323,  323,
 /*  1630 */   323,  323,  323,  323,   40,  323,  138,  214,  323,   98,
 /*  1640 */     7,  107,  323,  323,  323,  323,  147,  323,  323,  323,
 /*  1650 */   276,  245,  229,  323,   10,  323,  323,   51,  323,  323,
 /*  1660 */   323,  323,  323,  323,  323,  323,  323,  194,  182,  323,
 /*  1670 */   323,  323,   52,   49,  380,  225,  349,  259,  323,  106,
 /*  1680 */    29,   15,  323,  323,  323,  323,  323,  323,  323,   40,
 /*  1690 */   323,  138,  213,  206,   98,    7,  107,  323,  323,  323,
 /*  1700 */   323,  147,  323,  323,  323,  276,  245,  229,  323,   10,
 /*  1710 */   323,  323,   51,  323,  323,  323,  323,  323,  323,  323,
 /*  1720 */   323,  323,  323,  323,  323,  323,  499,   52,   49,  380,
 /*  1730 */   225,  349,  323,  499,  106,  499,  499,  323,  499,  499,
 /*  1740 */   323,  323,  323,  323,  499,    3,  499,  323,  323,   98,
 /*  1750 */   323,  323,  323,  323,  323,  323,  323,  323,  304,  323,
 /*  1760 */   323,  499,  120,  323,  323,  244,   73,  127,  137,  323,
 /*  1770 */   323,  323,  499,  323,  329,  266,  323,  323,  343,  321,
 /*  1780 */   323,  310,  323,  323,  323,  323,  499,  323,  323,  323,
 /*  1790 */   304,  323,  219,  334,  120,  323,  323,  244,   73,  127,
 /*  1800 */   323,  323,  323,  323,  323,  323,  329,  266,  323,  323,
 /*  1810 */   343,  321,  304,  310,  323,  323,  114,  323,  323,  244,
 /*  1820 */    77,  127,  323,  323,  323,  333,  194,  187,  329,  266,
 /*  1830 */   323,  323,  343,  321,  323,  310,  259,  323,  323,   29,
 /*  1840 */    15,  304,  323,  323,  323,  142,  323,  323,  221,   68,
 /*  1850 */   127,  323,  206,  194,  179,  323,  323,  329,  266,  323,
 /*  1860 */   323,  343,  321,  259,  310,  323,   29,   15,  323,  304,
 /*  1870 */   323,  323,  323,  142,  323,  323,  244,   64,  127,  206,
 /*  1880 */   323,  194,  189,  323,  323,  329,  266,  323,  323,  343,
 /*  1890 */   321,  259,  310,  304,   29,   15,  323,  113,  323,  323,
 /*  1900 */   244,   62,  127,  323,  323,  323,  323,  206,  323,  329,
 /*  1910 */   266,  304,  323,  343,  321,  142,  310,  323,  244,   69,
 /*  1920 */   127,  323,  323,  323,  323,  323,  323,  329,  266,  323,
 /*  1930 */   323,  343,  321,  304,  310,  323,  323,  142,  323,  323,
 /*  1940 */   244,   88,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  1950 */   266,  323,  323,  343,  321,  323,  310,  323,  323,  304,
 /*  1960 */   323,  323,  323,  142,  323,  323,  244,   90,  127,  323,
 /*  1970 */   323,  323,  323,  323,  323,  329,  266,  323,  323,  343,
 /*  1980 */   321,  323,  310,  304,  323,  323,  323,  116,  323,  323,
 /*  1990 */   244,   82,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2000 */   266,  304,  323,  343,  321,  142,  310,  323,  244,   72,
 /*  2010 */   127,  323,  323,  323,  323,  323,  323,  329,  266,  323,
 /*  2020 */   323,  343,  321,  304,  310,  323,  323,  142,  323,  323,
 /*  2030 */   244,   63,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2040 */   266,  323,  323,  343,  321,  323,  310,  323,  323,  304,
 /*  2050 */   323,  323,  323,  142,  323,  323,  244,   91,  127,  323,
 /*  2060 */   323,  323,  323,  323,  323,  329,  266,  323,  323,  343,
 /*  2070 */   321,  323,  310,  304,  323,  323,  323,  142,  323,  323,
 /*  2080 */   244,   60,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2090 */   266,  304,  323,  343,  321,  142,  310,  323,  244,   89,
 /*  2100 */   127,  323,  323,  323,  323,  323,  323,  329,  266,  323,
 /*  2110 */   323,  343,  321,  304,  310,  323,  323,  142,  323,  323,
 /*  2120 */   244,   70,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2130 */   266,  323,  323,  343,  321,  323,  310,  323,  323,  304,
 /*  2140 */   323,  323,  323,  142,  323,  323,  244,   78,  127,  323,
 /*  2150 */   323,  323,  323,  323,  323,  329,  266,  323,  323,  343,
 /*  2160 */   321,  323,  310,  304,  323,  323,  323,  142,  323,  323,
 /*  2170 */   244,   61,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2180 */   266,  304,  323,  343,  321,  142,  310,  323,  244,   76,
 /*  2190 */   127,  323,  323,  323,  323,  323,  323,  329,  266,  323,
 /*  2200 */   323,  343,  321,  304,  310,  323,  323,  142,  323,  323,
 /*  2210 */   244,   74,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2220 */   266,  323,  323,  343,  321,  323,  310,  323,  323,  304,
 /*  2230 */   323,  323,  323,  142,  323,  323,  244,   87,  127,  323,
 /*  2240 */   323,  323,  323,  323,  323,  329,  266,  323,  323,  343,
 /*  2250 */   321,  323,  310,  304,  323,  323,  323,  142,  323,  323,
 /*  2260 */   244,   67,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2270 */   266,  304,  323,  343,  321,  142,  310,  323,  244,   83,
 /*  2280 */   127,  323,  323,  323,  323,  323,  323,  329,  266,  323,
 /*  2290 */   323,  343,  321,  304,  310,  323,  323,  142,  323,  323,
 /*  2300 */   244,   58,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2310 */   266,  323,  323,  343,  321,  323,  310,  323,  323,  304,
 /*  2320 */   323,  323,  323,   94,  323,  323,   93,   59,  123,  323,
 /*  2330 */   323,  323,  323,  323,  323,  329,  266,  323,  323,  343,
 /*  2340 */   321,  323,  310,  304,  323,  323,  323,  142,  323,  323,
 /*  2350 */   244,   86,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2360 */   266,  304,  323,  343,  321,  142,  310,  323,  244,   85,
 /*  2370 */   127,  323,  323,  323,  323,  323,  323,  329,  266,  323,
 /*  2380 */   323,  343,  321,  304,  310,  323,  323,  142,  323,  323,
 /*  2390 */   244,   57,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2400 */   266,  323,  323,  343,  321,  323,  310,  323,  323,  304,
 /*  2410 */   323,  323,  323,  142,  323,  323,  244,   66,  127,  323,
 /*  2420 */   323,  323,  323,  323,  323,  329,  266,  323,  323,  343,
 /*  2430 */   321,  323,  310,  304,  323,  323,  323,  142,  323,  323,
 /*  2440 */   244,   79,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2450 */   266,  304,  323,  343,  321,  142,  310,  323,  244,   65,
 /*  2460 */   127,  323,  323,  323,  323,  323,  323,  329,  266,  323,
 /*  2470 */   323,  343,  321,  304,  310,  323,  323,  142,  323,  323,
 /*  2480 */   244,   81,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2490 */   266,  323,  323,  343,  321,  323,  310,  323,  323,  304,
 /*  2500 */   323,  323,  323,   94,  323,  323,   95,   56,  123,  323,
 /*  2510 */   323,  323,  323,  323,  323,  329,  266,  323,  323,  343,
 /*  2520 */   321,  323,  310,  304,  323,  323,  323,  142,  323,  323,
 /*  2530 */   244,   71,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2540 */   266,  304,  323,  343,  321,  142,  310,  323,  244,   54,
 /*  2550 */   127,  323,  323,  323,  323,  323,  323,  329,  266,  323,
 /*  2560 */   323,  343,  321,  304,  310,  323,  323,  122,  323,  323,
 /*  2570 */   244,   55,  127,  323,  323,  323,  323,  323,  323,  329,
 /*  2580 */   266,  323,  323,  343,  321,  323,  310,  323,  323,  304,
 /*  2590 */   323,  323,  323,  142,  323,  323,  244,   84,  127,  323,
 /*  2600 */   323,  323,  323,  323,  323,  329,  266,  323,  323,  343,
 /*  2610 */   321,  323,  310,  304,  323,  323,  323,  156,  323,  323,
 /*  2620 */   244,  323,  127,  323,  323,  323,  323,  323,  323,  323,
 /*  2630 */   364,  323,  323,  343,  321,  323,  310,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,    3,    4,    5,    6,    7,    8,    9,   10,   11,
 /*    10 */    12,   15,   56,   15,   18,   16,   16,   61,   15,   21,
 /*    20 */    22,   18,   19,  113,   28,   27,   30,   28,   28,   31,
 /*    30 */    32,   79,   80,   81,   82,   83,   37,   38,   39,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*    50 */     1,    4,    5,    6,    7,    8,   81,   82,   83,   12,
 /*    60 */    13,   14,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,   24,   26,   15,   28,   17,   18,
 /*    80 */     1,   87,   15,   35,   17,   18,   37,   38,   39,   40,
 /*    90 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   100 */    33,   87,   88,   30,   56,   20,   58,  113,   35,   30,
 /*   110 */    62,   97,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   120 */    71,   72,   73,   74,    1,   82,   76,  113,   88,   86,
 /*   130 */    51,   58,   89,   90,   91,   16,   28,   97,   19,   16,
 /*   140 */    15,   98,   99,   18,   19,  102,  103,   28,  105,   87,
 /*   150 */    88,   28,  110,  113,   35,  112,   91,   92,   93,   97,
 /*   160 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   170 */    47,   48,   49,   50,   88,  113,   15,   58,   35,   18,
 /*   180 */    19,  109,  110,   97,   59,   24,   63,   64,   65,   66,
 /*   190 */    67,   68,   69,   70,   71,   72,   73,   74,    1,   82,
 /*   200 */    87,   88,    1,   86,  109,  110,   89,   90,   91,   16,
 /*   210 */    97,   15,    1,   16,   18,   98,   99,   16,   20,  102,
 /*   220 */   103,   28,  105,   87,   88,   28,  113,   16,   35,  112,
 /*   230 */    15,   20,  106,   97,   37,   38,   39,   40,   41,   42,
 /*   240 */    43,   44,   45,   46,   47,   48,   49,   50,   88,  113,
 /*   250 */    35,   58,   51,   15,   56,   59,   18,   97,   18,   61,
 /*   260 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   270 */    73,   74,    1,   82,  106,   88,  107,   86,  109,  110,
 /*   280 */    89,   90,   91,   92,   97,   15,   82,   16,   18,   98,
 /*   290 */    99,   19,   20,  102,  103,  108,  105,   59,   28,   59,
 /*   300 */    30,   35,   34,   34,   36,   36,   17,   18,   37,   38,
 /*   310 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   320 */    49,   50,  118,  119,   58,   34,   15,   36,    1,   18,
 /*   330 */    58,  114,   19,   20,   63,   64,   65,   66,   67,   68,
 /*   340 */    69,   70,   71,   72,   73,   74,    1,   82,   88,   88,
 /*   350 */   106,   86,  108,   16,   89,   90,   91,   97,   97,   15,
 /*   360 */     1,   16,   18,   98,   99,   28,   16,  102,  103,  108,
 /*   370 */   105,   58,   28,  113,   34,   16,   15,  112,   28,   18,
 /*   380 */    17,   18,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   390 */    45,   46,   47,   48,   49,   50,    1,   88,   83,    1,
 /*   400 */    85,   87,   62,   91,   92,   89,   97,   91,   63,   64,
 /*   410 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   420 */   114,  105,  113,   60,   91,   92,   15,  113,   87,   18,
 /*   430 */   106,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   440 */    45,   46,   47,   48,   49,   50,    1,    2,   88,   51,
 /*   450 */    94,   24,   17,   15,  113,   18,   18,   97,   63,   64,
 /*   460 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   470 */    35,  104,   88,  113,   15,    1,   18,   18,  111,   18,
 /*   480 */    17,   97,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   490 */    45,   46,   47,   48,   49,   50,    1,  113,  106,   17,
 /*   500 */   108,   62,   28,   18,   18,   52,   18,   95,   63,   64,
 /*   510 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   520 */   108,   88,  104,   18,   60,   60,   36,   25,   18,  111,
 /*   530 */    97,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   540 */    45,   46,   47,   48,   49,   50,    1,   56,    2,   33,
 /*   550 */     2,   17,   35,   17,   19,   17,   33,   18,   63,   64,
 /*   560 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   570 */    23,  115,  106,   97,  107,   94,  108,   28,   28,    2,
 /*   580 */   111,   34,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   590 */    45,   46,   47,   48,   49,   50,    1,   84,   13,  120,
 /*   600 */   120,  120,  120,  120,  120,  120,  120,   95,   63,   64,
 /*   610 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   620 */   108,   76,  120,   28,  120,  120,  120,  120,  120,  120,
 /*   630 */   120,  120,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   640 */    45,   46,   47,   48,   49,   50,  120,  120,  120,  120,
 /*   650 */   120,  120,  120,  120,  120,  120,  120,  120,   63,   64,
 /*   660 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   670 */     1,    1,  120,   82,   87,   88,    1,   86,    2,  120,
 /*   680 */    89,   90,   91,   92,   97,   19,   16,  100,  101,   98,
 /*   690 */    99,   16,   23,  102,  103,   19,  105,  120,   28,   29,
 /*   700 */   113,  120,  120,   28,  120,    1,   37,   38,   39,   40,
 /*   710 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   720 */    16,   51,   56,  120,  120,  120,   51,  120,  120,  120,
 /*   730 */   120,  120,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   740 */    71,   72,   73,   74,    1,  120,  120,  120,   87,   88,
 /*   750 */   120,   16,   16,   16,  120,   10,   16,   16,   97,   16,
 /*   760 */    15,  100,  101,   28,   28,   28,   21,   22,   28,   28,
 /*   770 */   120,  120,   27,  120,  113,  120,   31,   32,  120,  120,
 /*   780 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   790 */    47,   48,   49,   50,    1,  120,  120,  120,  120,  120,
 /*   800 */   120,  120,  120,  120,  120,   95,   63,   64,   65,   66,
 /*   810 */    67,   68,   69,   70,   71,   72,   73,   74,  108,  120,
 /*   820 */    75,   76,   77,  120,  120,  120,  120,  120,  120,  120,
 /*   830 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   840 */    47,   48,   49,   50,  120,  120,  120,  120,  120,  120,
 /*   850 */   120,  120,  120,  120,  120,   62,   63,   64,   65,   66,
 /*   860 */    67,   68,   69,   70,   71,   72,   73,   74,    1,   82,
 /*   870 */   120,   88,   16,   86,  120,   16,   89,   90,   91,   88,
 /*   880 */    97,   16,   16,   16,   28,   98,   99,   28,   97,  102,
 /*   890 */   103,  108,  105,   28,   28,  120,  120,  120,  120,  108,
 /*   900 */   120,  120,  120,  120,   37,   38,   39,   40,   41,   42,
 /*   910 */    43,   44,   45,   46,   47,   48,   49,   50,    1,  120,
 /*   920 */   120,  120,  120,  120,  120,  120,  120,  120,  120,   95,
 /*   930 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   940 */    73,   74,  108,  120,  120,  120,   29,  120,  120,  120,
 /*   950 */   120,  120,  120,  120,   37,   38,   39,   40,   41,   42,
 /*   960 */    43,   44,   45,   46,   47,   48,   49,   50,    1,  120,
 /*   970 */   120,  120,  120,  120,  120,  120,  120,  120,  120,   95,
 /*   980 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   990 */    73,   74,  108,  120,  120,  120,  120,  120,  120,  120,
 /*  1000 */   120,  120,  120,  120,   37,   38,   39,   40,   41,   42,
 /*  1010 */    43,   44,   45,   46,   47,   48,   49,   50,  120,   82,
 /*  1020 */   120,  120,  120,  120,  120,  120,   20,  120,  120,  120,
 /*  1030 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*  1040 */    73,   74,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  1050 */    45,   46,   47,   48,   49,   50,  119,  120,  120,  120,
 /*  1060 */   120,  120,  120,  120,   58,  120,    1,  120,   63,   64,
 /*  1070 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*  1080 */    96,   16,   95,  120,   15,  120,   17,   18,  120,  120,
 /*  1090 */    21,   22,  108,   16,   16,  108,   27,  120,   10,  120,
 /*  1100 */    31,   32,   33,   15,   35,   28,   28,   38,  120,   21,
 /*  1110 */    22,  120,  120,  120,  120,   27,  120,  120,  120,   31,
 /*  1120 */    32,   87,   53,   54,   55,   56,   57,   95,  120,   60,
 /*  1130 */    61,   62,  120,    1,  100,  101,  120,   16,   16,   15,
 /*  1140 */   108,   17,   18,    1,   75,   21,   22,  113,   16,   28,
 /*  1150 */    28,   27,  120,  120,  120,   31,   32,   33,   16,   35,
 /*  1160 */    28,   16,   38,   75,   76,   77,   24,   82,  120,   95,
 /*  1170 */    28,   86,  120,   28,   89,  120,   91,   53,   54,   55,
 /*  1180 */    56,   57,  108,   51,   60,   61,  120,  102,  103,    1,
 /*  1190 */   105,   16,  120,  120,   15,  120,   17,   18,   82,   75,
 /*  1200 */    21,   22,   86,   28,   16,   89,   27,   91,   20,  120,
 /*  1210 */    31,   32,   33,   16,   35,   99,   28,   38,  102,  103,
 /*  1220 */   120,  105,   82,   35,  120,   28,   86,  120,  120,   89,
 /*  1230 */   120,   91,   53,   54,   55,   56,   57,  120,   16,   60,
 /*  1240 */    61,  120,  102,  103,    1,  105,   58,    1,   16,   15,
 /*  1250 */    28,   17,   18,    1,   75,   21,   22,  120,  120,   16,
 /*  1260 */    28,   27,   16,   16,   16,   31,   32,   33,   16,   35,
 /*  1270 */    24,   28,   38,  120,   28,   28,   28,   82,  120,   95,
 /*  1280 */    28,   86,  120,  120,   89,  120,   91,   53,   54,   55,
 /*  1290 */    56,   57,  108,  120,   60,   61,  120,  102,  103,   95,
 /*  1300 */   105,  120,  120,   51,   15,  120,   17,   18,  120,   75,
 /*  1310 */    21,   22,  108,  120,  120,  120,   27,  120,  120,  120,
 /*  1320 */    31,   32,   33,  120,   35,  120,  120,   38,  120,  120,
 /*  1330 */   120,  120,   82,  120,  120,  120,   86,  120,  120,   89,
 /*  1340 */   120,   91,   53,   54,   55,   56,   57,  120,  120,   60,
 /*  1350 */    61,  120,  102,  103,  120,  105,  120,  120,  120,   15,
 /*  1360 */   120,   17,   18,  120,   75,   21,   22,  120,  120,  120,
 /*  1370 */   120,   27,  120,  120,  120,   31,   32,   33,  120,   35,
 /*  1380 */   120,  120,   38,  120,  120,  120,  120,   82,  120,  120,
 /*  1390 */   120,   86,  120,  120,   89,  120,   91,   53,   54,   55,
 /*  1400 */    56,   57,  120,  120,   60,   61,  120,  102,  103,  120,
 /*  1410 */   105,  120,  120,  120,   15,  120,   17,   18,  120,   75,
 /*  1420 */    21,   22,  120,  120,  120,  120,   27,  120,  120,  120,
 /*  1430 */    31,   32,   33,  120,   35,  120,  120,   38,  120,  120,
 /*  1440 */   120,  120,   82,  120,  120,  120,   86,  120,  120,   89,
 /*  1450 */   120,   91,   53,   54,   55,   56,   57,  120,  120,   60,
 /*  1460 */    61,  120,  102,  103,  120,  105,  120,  120,  120,   15,
 /*  1470 */   120,   17,   18,  120,   75,   21,   22,  120,  120,  120,
 /*  1480 */   120,   27,  120,  120,  120,   31,   32,   33,  120,   35,
 /*  1490 */   120,  120,   38,  120,  120,  120,  120,   82,  120,  120,
 /*  1500 */   120,   86,  120,  120,   89,  120,   91,   53,   54,   55,
 /*  1510 */    56,   57,  120,  120,   60,   61,  120,  102,  103,  120,
 /*  1520 */   105,  120,  120,  120,   15,  120,   17,   18,  120,   75,
 /*  1530 */    21,   22,  120,  120,  120,  120,   27,  120,  120,  120,
 /*  1540 */    31,   32,   33,  120,   35,  120,  120,   38,  120,  120,
 /*  1550 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1560 */   120,  120,   53,   54,   55,   56,   57,  120,  120,   60,
 /*  1570 */    61,  120,  120,  120,  120,  120,  120,  120,  120,   15,
 /*  1580 */   120,   17,   18,  120,   75,   21,   22,  120,  120,  120,
 /*  1590 */   120,   27,  120,  120,  120,   31,   32,   33,  120,   35,
 /*  1600 */   120,  120,   38,  120,  120,  120,  120,  120,  120,  120,
 /*  1610 */   120,  120,  120,  120,  120,  120,  120,   53,   54,   55,
 /*  1620 */    56,   57,  120,  120,   60,   61,  120,  120,  120,  120,
 /*  1630 */   120,  120,  120,  120,   15,  120,   17,   18,  120,   75,
 /*  1640 */    21,   22,  120,  120,  120,  120,   27,  120,  120,  120,
 /*  1650 */    31,   32,   33,  120,   35,  120,  120,   38,  120,  120,
 /*  1660 */   120,  120,  120,  120,  120,  120,  120,   87,   88,  120,
 /*  1670 */   120,  120,   53,   54,   55,   56,   57,   97,  120,   60,
 /*  1680 */   100,  101,  120,  120,  120,  120,  120,  120,  120,   15,
 /*  1690 */   120,   17,   18,  113,   75,   21,   22,  120,  120,  120,
 /*  1700 */   120,   27,  120,  120,  120,   31,   32,   33,  120,   35,
 /*  1710 */   120,  120,   38,  120,  120,  120,  120,  120,  120,  120,
 /*  1720 */   120,  120,  120,  120,  120,  120,   16,   53,   54,   55,
 /*  1730 */    56,   57,  120,   23,   60,   25,   26,  120,   28,   29,
 /*  1740 */   120,  120,  120,  120,   34,   35,   36,  120,  120,   75,
 /*  1750 */   120,  120,  120,  120,  120,  120,  120,  120,   82,  120,
 /*  1760 */   120,   51,   86,  120,  120,   89,   90,   91,   58,  120,
 /*  1770 */   120,  120,   62,  120,   98,   99,  120,  120,  102,  103,
 /*  1780 */   120,  105,  120,  120,  120,  120,   76,  120,  120,  120,
 /*  1790 */    82,  120,  116,  117,   86,  120,  120,   89,   90,   91,
 /*  1800 */   120,  120,  120,  120,  120,  120,   98,   99,  120,  120,
 /*  1810 */   102,  103,   82,  105,  120,  120,   86,  120,  120,   89,
 /*  1820 */    90,   91,  120,  120,  120,  117,   87,   88,   98,   99,
 /*  1830 */   120,  120,  102,  103,  120,  105,   97,  120,  120,  100,
 /*  1840 */   101,   82,  120,  120,  120,   86,  120,  120,   89,   90,
 /*  1850 */    91,  120,  113,   87,   88,  120,  120,   98,   99,  120,
 /*  1860 */   120,  102,  103,   97,  105,  120,  100,  101,  120,   82,
 /*  1870 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  113,
 /*  1880 */   120,   87,   88,  120,  120,   98,   99,  120,  120,  102,
 /*  1890 */   103,   97,  105,   82,  100,  101,  120,   86,  120,  120,
 /*  1900 */    89,   90,   91,  120,  120,  120,  120,  113,  120,   98,
 /*  1910 */    99,   82,  120,  102,  103,   86,  105,  120,   89,   90,
 /*  1920 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  1930 */   120,  102,  103,   82,  105,  120,  120,   86,  120,  120,
 /*  1940 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  1950 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   82,
 /*  1960 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  120,
 /*  1970 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  1980 */   103,  120,  105,   82,  120,  120,  120,   86,  120,  120,
 /*  1990 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2000 */    99,   82,  120,  102,  103,   86,  105,  120,   89,   90,
 /*  2010 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  2020 */   120,  102,  103,   82,  105,  120,  120,   86,  120,  120,
 /*  2030 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2040 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   82,
 /*  2050 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  120,
 /*  2060 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2070 */   103,  120,  105,   82,  120,  120,  120,   86,  120,  120,
 /*  2080 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2090 */    99,   82,  120,  102,  103,   86,  105,  120,   89,   90,
 /*  2100 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  2110 */   120,  102,  103,   82,  105,  120,  120,   86,  120,  120,
 /*  2120 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2130 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   82,
 /*  2140 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  120,
 /*  2150 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2160 */   103,  120,  105,   82,  120,  120,  120,   86,  120,  120,
 /*  2170 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2180 */    99,   82,  120,  102,  103,   86,  105,  120,   89,   90,
 /*  2190 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  2200 */   120,  102,  103,   82,  105,  120,  120,   86,  120,  120,
 /*  2210 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2220 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   82,
 /*  2230 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  120,
 /*  2240 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2250 */   103,  120,  105,   82,  120,  120,  120,   86,  120,  120,
 /*  2260 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2270 */    99,   82,  120,  102,  103,   86,  105,  120,   89,   90,
 /*  2280 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  2290 */   120,  102,  103,   82,  105,  120,  120,   86,  120,  120,
 /*  2300 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2310 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   82,
 /*  2320 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  120,
 /*  2330 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2340 */   103,  120,  105,   82,  120,  120,  120,   86,  120,  120,
 /*  2350 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2360 */    99,   82,  120,  102,  103,   86,  105,  120,   89,   90,
 /*  2370 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  2380 */   120,  102,  103,   82,  105,  120,  120,   86,  120,  120,
 /*  2390 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2400 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   82,
 /*  2410 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  120,
 /*  2420 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2430 */   103,  120,  105,   82,  120,  120,  120,   86,  120,  120,
 /*  2440 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2450 */    99,   82,  120,  102,  103,   86,  105,  120,   89,   90,
 /*  2460 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  2470 */   120,  102,  103,   82,  105,  120,  120,   86,  120,  120,
 /*  2480 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2490 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   82,
 /*  2500 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  120,
 /*  2510 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2520 */   103,  120,  105,   82,  120,  120,  120,   86,  120,  120,
 /*  2530 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2540 */    99,   82,  120,  102,  103,   86,  105,  120,   89,   90,
 /*  2550 */    91,  120,  120,  120,  120,  120,  120,   98,   99,  120,
 /*  2560 */   120,  102,  103,   82,  105,  120,  120,   86,  120,  120,
 /*  2570 */    89,   90,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2580 */    99,  120,  120,  102,  103,  120,  105,  120,  120,   82,
 /*  2590 */   120,  120,  120,   86,  120,  120,   89,   90,   91,  120,
 /*  2600 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2610 */   103,  120,  105,   82,  120,  120,  120,   86,  120,  120,
 /*  2620 */    89,  120,   91,  120,  120,  120,  120,  120,  120,  120,
 /*  2630 */    99,  120,  120,  102,  103,  120,  105,
);
    const YY_SHIFT_USE_DFLT = -45;
    const YY_SHIFT_MAX = 252;
    static public $yy_shift_ofst = array(
 /*     0 */    -2, 1289, 1289, 1124, 1124, 1124, 1399, 1399, 1069, 1564,
 /*    10 */  1124, 1124, 1124, 1124, 1124, 1124, 1509, 1124, 1124, 1454,
 /*    20 */  1509, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124,
 /*    30 */  1124, 1124, 1124, 1124, 1124, 1124, 1124, 1344, 1124, 1124,
 /*    40 */  1234, 1124, 1124, 1234, 1179, 1179, 1619, 1674, 1619, 1619,
 /*    50 */  1619, 1619, 1619,  197,   49,   -1,  123,  595,  595,  595,
 /*    60 */   793,  867,  917,  495,  345,  271,  395,  445,  545,  743,
 /*    70 */   669,  967,  967,  967,  967,  967,  967,  967,  967,  967,
 /*    80 */   967,  967,  967,  967,  967,  967,  967,  967,  967,  967,
 /*    90 */  1005, 1005, 1188, 1142, 1252, 1246,  474,   -2,  745,  270,
 /*   100 */    -4, 1243,  344,  198, 1243,  344,  363,  435,  474,  474,
 /*   110 */   474, 1088,   47,  670, 1132,  161,  675,  125,  313,    3,
 /*   120 */    79,  211,  201,  272,  196,  361, 1248, 1006,  411,  311,
 /*   130 */   438, 1065,  311,  435,  311,  435,  289,  289,  311,  311,
 /*   140 */   311,  459,  398,  438,  311,  311,  311,  549,   85,   85,
 /*   150 */   550,  327,  327,  327,  327,  327,  327,  327,  327,  -45,
 /*   160 */   238,   61,  350,  337,    0,  856,  736,  741,  -44,  215,
 /*   170 */   -44,  737,  740,  735,  -44,  -44, 1197, 1175,  -44, 1222,
 /*   180 */  1247, 1232, 1145,  865,  359,  859,  866, 1122, 1121, 1077,
 /*   190 */   704, 1078,   85,  108,  327,  577,   85,  585,  577,  327,
 /*   200 */    85,  108,  143,  -45,  -45,  -45,  -45, 1710,  119,  193,
 /*   210 */    48,   67,   73,  266,  266,  268,  269,  291,  676,  340,
 /*   220 */   547,   50,  666,  240,  523,  516,  548,  437,  510,  491,
 /*   230 */   143,  517,  539,  538,  536,  534,  535,  502,  490,  463,
 /*   240 */   482,  439,  461,  458,  427,  485,  486,  465,  464,  505,
 /*   250 */   453,  488,  546,
);
    const YY_REDUCE_USE_DFLT = -91;
    const YY_REDUCE_MAX = 206;
    static public $yy_reduce_ofst = array(
 /*     0 */   -48, 1676, 1708,  117,   43,  265,  191,  591, 1991, 1967,
 /*    10 */  1941, 2009, 2031, 2081, 2057, 1919, 1901, 1787, 1759, 1730,
 /*    20 */  1811, 1829, 1877, 1851, 2099, 2121, 2391, 2369, 2351, 2441,
 /*    30 */  2481, 2459, 2507, 2327,  787, 2301, 2189, 2171, 2147, 2211,
 /*    40 */  2237, 2279, 2261, 2417, 1116, 2531, 1250, 1305, 1085, 1195,
 /*    50 */  1140, 1360, 1415, 1580, 1739,  661,  587, 1794, 1766,  587,
 /*    60 */  1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034,
 /*    70 */  1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034,
 /*    80 */  1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034,
 /*    90 */  1034, 1034,   14,  113,   62,  113,  136,  -25,  204,  187,
 /*   100 */   783,  260,  261,  169,  309,  791,  316,   65,  360,  384,
 /*   110 */    40,  937,  315,   -6,   -6,  984,   -6,  244,   95,  244,
 /*   120 */    -6,  341,   -6,   95,  244,  710,  433,   95,  710,  884,
 /*   130 */   834,  314,  412,  312,  512,  333,  367,  418,  710, 1204,
 /*   140 */  1074, 1184,   -6,  710,  392, 1032,  987,  160,   95,   72,
 /*   150 */    86,   -6,   -6,   -6,   -6,   -6,   -6,   -6,   -6,   -6,
 /*   160 */   468,  469,  476,  476,  476,  476,  476,  476,  467,  466,
 /*   170 */   467,  476,  476,  476,  467,  467,  476,  476,  467,  476,
 /*   180 */   476,  476,  476,  476,  -90,  476,  476,  476,  476,  476,
 /*   190 */   -90,  476,   42,  481,  -90,  456,   42,  513,  456,  -90,
 /*   200 */    42,  356,  324,  217,  126,  168,  306,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 22, 27, 31, 32, ),
        /* 1 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 2 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 3 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 4 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 5 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 6 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 7 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 8 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 62, 75, ),
        /* 9 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 10 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 11 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 12 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 13 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 14 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 15 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 16 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 17 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 18 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 19 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 20 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 21 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 22 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 23 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 24 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 25 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 26 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 27 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 28 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 29 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 30 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 31 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 32 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 33 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 34 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 35 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 36 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 37 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 38 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 39 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 40 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 41 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 42 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 43 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 44 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 45 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 46 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 47 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 48 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 49 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 50 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 51 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 52 */ array(15, 17, 18, 21, 22, 27, 31, 32, 33, 35, 38, 53, 54, 55, 56, 57, 60, 75, ),
        /* 53 */ array(1, 16, 28, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 54 */ array(1, 26, 28, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 55 */ array(1, 16, 28, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 56 */ array(1, 16, 28, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 57 */ array(1, 28, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 58 */ array(1, 28, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 59 */ array(1, 28, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 60 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 61 */ array(1, 16, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 62 */ array(1, 29, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 63 */ array(1, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 64 */ array(1, 16, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 65 */ array(1, 16, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 66 */ array(1, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 67 */ array(1, 2, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 68 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 76, ),
        /* 69 */ array(1, 16, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 70 */ array(1, 23, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 71 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 72 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 73 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 74 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 75 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 76 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 77 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 78 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 79 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 80 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 81 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 82 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 83 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 84 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 85 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 86 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 87 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 88 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 89 */ array(1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 90 */ array(37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 91 */ array(37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 92 */ array(1, 16, 20, 28, 35, 58, ),
        /* 93 */ array(1, 16, 24, 28, ),
        /* 94 */ array(1, 16, 28, 51, ),
        /* 95 */ array(1, 16, 24, 28, ),
        /* 96 */ array(1, 28, ),
        /* 97 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 22, 27, 31, 32, ),
        /* 98 */ array(10, 15, 21, 22, 27, 31, 32, 75, 76, 77, ),
        /* 99 */ array(15, 18, 28, 30, ),
        /* 100 */ array(15, 18, 28, 30, ),
        /* 101 */ array(1, 16, 28, ),
        /* 102 */ array(15, 18, 28, ),
        /* 103 */ array(20, 56, 61, ),
        /* 104 */ array(1, 16, 28, ),
        /* 105 */ array(15, 18, 28, ),
        /* 106 */ array(17, 18, 60, ),
        /* 107 */ array(17, 35, ),
        /* 108 */ array(1, 28, ),
        /* 109 */ array(1, 28, ),
        /* 110 */ array(1, 28, ),
        /* 111 */ array(10, 15, 21, 22, 27, 31, 32, 75, 76, 77, ),
        /* 112 */ array(4, 5, 6, 7, 8, 12, 13, 14, ),
        /* 113 */ array(1, 16, 28, 29, 51, ),
        /* 114 */ array(1, 16, 28, 51, ),
        /* 115 */ array(15, 18, 19, 24, ),
        /* 116 */ array(1, 16, 28, 51, ),
        /* 117 */ array(15, 18, 19, 59, ),
        /* 118 */ array(19, 20, 58, ),
        /* 119 */ array(15, 18, 19, ),
        /* 120 */ array(1, 30, 51, ),
        /* 121 */ array(1, 16, 20, ),
        /* 122 */ array(1, 16, 51, ),
        /* 123 */ array(19, 20, 58, ),
        /* 124 */ array(15, 18, 59, ),
        /* 125 */ array(15, 18, ),
        /* 126 */ array(16, 28, ),
        /* 127 */ array(20, 58, ),
        /* 128 */ array(15, 18, ),
        /* 129 */ array(15, 18, ),
        /* 130 */ array(15, 18, ),
        /* 131 */ array(1, 16, ),
        /* 132 */ array(15, 18, ),
        /* 133 */ array(17, 35, ),
        /* 134 */ array(15, 18, ),
        /* 135 */ array(17, 35, ),
        /* 136 */ array(17, 18, ),
        /* 137 */ array(17, 18, ),
        /* 138 */ array(15, 18, ),
        /* 139 */ array(15, 18, ),
        /* 140 */ array(15, 18, ),
        /* 141 */ array(15, 18, ),
        /* 142 */ array(1, 51, ),
        /* 143 */ array(15, 18, ),
        /* 144 */ array(15, 18, ),
        /* 145 */ array(15, 18, ),
        /* 146 */ array(15, 18, ),
        /* 147 */ array(28, ),
        /* 148 */ array(20, ),
        /* 149 */ array(20, ),
        /* 150 */ array(28, ),
        /* 151 */ array(1, ),
        /* 152 */ array(1, ),
        /* 153 */ array(1, ),
        /* 154 */ array(1, ),
        /* 155 */ array(1, ),
        /* 156 */ array(1, ),
        /* 157 */ array(1, ),
        /* 158 */ array(1, ),
        /* 159 */ array(),
        /* 160 */ array(15, 18, 59, ),
        /* 161 */ array(15, 17, 18, ),
        /* 162 */ array(16, 28, ),
        /* 163 */ array(16, 28, ),
        /* 164 */ array(16, 28, ),
        /* 165 */ array(16, 28, ),
        /* 166 */ array(16, 28, ),
        /* 167 */ array(16, 28, ),
        /* 168 */ array(56, 61, ),
        /* 169 */ array(15, 35, ),
        /* 170 */ array(56, 61, ),
        /* 171 */ array(16, 28, ),
        /* 172 */ array(16, 28, ),
        /* 173 */ array(16, 28, ),
        /* 174 */ array(56, 61, ),
        /* 175 */ array(56, 61, ),
        /* 176 */ array(16, 28, ),
        /* 177 */ array(16, 28, ),
        /* 178 */ array(56, 61, ),
        /* 179 */ array(16, 28, ),
        /* 180 */ array(16, 28, ),
        /* 181 */ array(16, 28, ),
        /* 182 */ array(16, 28, ),
        /* 183 */ array(16, 28, ),
        /* 184 */ array(1, 16, ),
        /* 185 */ array(16, 28, ),
        /* 186 */ array(16, 28, ),
        /* 187 */ array(16, 28, ),
        /* 188 */ array(16, 28, ),
        /* 189 */ array(16, 28, ),
        /* 190 */ array(1, 16, ),
        /* 191 */ array(16, 28, ),
        /* 192 */ array(20, ),
        /* 193 */ array(28, ),
        /* 194 */ array(1, ),
        /* 195 */ array(2, ),
        /* 196 */ array(20, ),
        /* 197 */ array(13, ),
        /* 198 */ array(2, ),
        /* 199 */ array(1, ),
        /* 200 */ array(20, ),
        /* 201 */ array(28, ),
        /* 202 */ array(35, ),
        /* 203 */ array(),
        /* 204 */ array(),
        /* 205 */ array(),
        /* 206 */ array(),
        /* 207 */ array(16, 23, 25, 26, 28, 29, 34, 35, 36, 51, 58, 62, 76, ),
        /* 208 */ array(16, 19, 28, 35, 58, ),
        /* 209 */ array(16, 28, 35, 58, ),
        /* 210 */ array(35, 56, 58, 62, ),
        /* 211 */ array(15, 17, 18, 33, ),
        /* 212 */ array(30, 35, 58, ),
        /* 213 */ array(35, 58, ),
        /* 214 */ array(35, 58, ),
        /* 215 */ array(34, 36, ),
        /* 216 */ array(34, 36, ),
        /* 217 */ array(34, 36, ),
        /* 218 */ array(2, 19, ),
        /* 219 */ array(34, 62, ),
        /* 220 */ array(23, 34, ),
        /* 221 */ array(24, 76, ),
        /* 222 */ array(19, 56, ),
        /* 223 */ array(18, 59, ),
        /* 224 */ array(33, ),
        /* 225 */ array(33, ),
        /* 226 */ array(2, ),
        /* 227 */ array(18, ),
        /* 228 */ array(18, ),
        /* 229 */ array(56, ),
        /* 230 */ array(35, ),
        /* 231 */ array(35, ),
        /* 232 */ array(18, ),
        /* 233 */ array(17, ),
        /* 234 */ array(17, ),
        /* 235 */ array(17, ),
        /* 236 */ array(19, ),
        /* 237 */ array(25, ),
        /* 238 */ array(36, ),
        /* 239 */ array(17, ),
        /* 240 */ array(17, ),
        /* 241 */ array(62, ),
        /* 242 */ array(18, ),
        /* 243 */ array(18, ),
        /* 244 */ array(24, ),
        /* 245 */ array(18, ),
        /* 246 */ array(18, ),
        /* 247 */ array(60, ),
        /* 248 */ array(60, ),
        /* 249 */ array(18, ),
        /* 250 */ array(52, ),
        /* 251 */ array(18, ),
        /* 252 */ array(2, ),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
        /* 375 */ array(),
        /* 376 */ array(),
        /* 377 */ array(),
        /* 378 */ array(),
        /* 379 */ array(),
        /* 380 */ array(),
        /* 381 */ array(),
        /* 382 */ array(),
        /* 383 */ array(),
        /* 384 */ array(),
        /* 385 */ array(),
        /* 386 */ array(),
);
    static public $yy_default = array(
 /*     0 */   390,  571,  588,  542,  542,  542,  588,  588,  588,  588,
 /*    10 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*    20 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*    30 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*    40 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*    50 */   588,  588,  588,  588,  450,  588,  588,  450,  450,  450,
 /*    60 */   588,  588,  455,  588,  588,  588,  588,  588,  588,  588,
 /*    70 */   588,  471,  474,  574,  573,  541,  434,  452,  475,  476,
 /*    80 */   484,  572,  455,  483,  480,  460,  461,  479,  540,  457,
 /*    90 */   488,  487,  499,  489,  463,  489,  450,  387,  588,  450,
 /*   100 */   450,  470,  450,  554,  507,  450,  588,  588,  450,  450,
 /*   110 */   450,  588,  588,  463,  463,  588,  463,  515,  508,  515,
 /*   120 */   463,  588,  463,  508,  515,  588,  588,  508,  588,  588,
 /*   130 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*   140 */   588,  588,  463,  588,  515,  588,  588,  450,  508,  551,
 /*   150 */   450,  467,  468,  466,  490,  486,  473,  492,  491,  549,
 /*   160 */   516,  588,  588,  588,  588,  588,  588,  588,  532,  515,
 /*   170 */   534,  588,  588,  588,  535,  533,  588,  588,  513,  588,
 /*   180 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*   190 */   588,  588,  529,  587,  470,  544,  555,  405,  543,  507,
 /*   200 */   552,  587,  515,  548,  515,  515,  548,  465,  499,  499,
 /*   210 */   499,  588,  499,  485,  499,  588,  588,  588,  527,  588,
 /*   220 */   588,  489,  495,  588,  497,  588,  527,  588,  588,  495,
 /*   230 */   527,  553,  588,  588,  588,  588,  588,  458,  588,  588,
 /*   240 */   588,  588,  588,  588,  489,  588,  588,  588,  588,  588,
 /*   250 */   501,  588,  527,  433,  442,  565,  566,  438,  567,  449,
 /*   260 */   429,  459,  586,  435,  416,  430,  469,  564,  444,  447,
 /*   270 */   563,  446,  445,  550,  562,  528,  443,  441,  417,  448,
 /*   280 */   440,  526,  582,  527,  439,  412,  398,  397,  396,  432,
 /*   290 */   399,  400,  431,  395,  394,  389,  388,  391,  415,  393,
 /*   300 */   392,  401,  437,  409,  506,  462,  410,  411,  413,  547,
 /*   310 */   510,  408,  403,  402,  404,  436,  407,  406,  414,  561,
 /*   320 */   509,  503,  505,  424,  514,  585,  578,  568,  465,  464,
 /*   330 */   477,  423,  530,  570,  569,  584,  581,  518,  525,  427,
 /*   340 */   428,  519,  426,  500,  575,  517,  425,  579,  580,  502,
 /*   350 */   576,  577,  478,  481,  522,  524,  583,  559,  558,  557,
 /*   360 */   521,  419,  493,  418,  472,  537,  560,  501,  520,  523,
 /*   370 */   545,  482,  496,  421,  498,  422,  539,  504,  536,  556,
 /*   380 */   494,  546,  512,  531,  420,  511,  538,
);
    const YYNOCODE = 121;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 387;
    const YYNRULE = 201;
    const YYERRORSYMBOL = 78;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'VERT',          'COLON',         'COMMENT',
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',
  'FAKEPHPSTARTTAG',  'XMLTAG',        'OTHER',         'LINEBREAK',
  'LITERALSTART',  'LITERALEND',    'LITERAL',       'LDEL',
  'RDEL',          'DOLLAR',        'ID',            'EQUAL',
  'PTR',           'LDELIF',        'LDELFOR',       'SEMICOLON',
  'INCDEC',        'TO',            'STEP',          'LDELFOREACH',
  'SPACE',         'AS',            'APTR',          'SMARTYBLOCKCHILD',
  'LDELSLASH',     'INTEGER',       'COMMA',         'OPENP',
  'CLOSEP',        'MATH',          'UNIMATH',       'ANDSYM',
  'ISIN',          'ISDIVBY',       'ISNOTDIVBY',    'ISEVEN',
  'ISNOTEVEN',     'ISEVENBY',      'ISNOTEVENBY',   'ISODD',
  'ISNOTODD',      'ISODDBY',       'ISNOTODDBY',    'INSTANCEOF',
  'QMARK',         'NOT',           'TYPECAST',      'HEX',
  'DOT',           'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',
  'HATCH',         'OPENB',         'CLOSEB',        'EQUALS',
  'NOTEQUALS',     'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',
  'LESSEQUAL',     'IDENTITY',      'NONEIDENTITY',  'MOD',
  'LAND',          'LOR',           'LXOR',          'QUOTE',
  'BACKTICK',      'DOLLARID',      'error',         'start',
  'template',      'template_element',  'smartytag',     'literal',
  'literal_elements',  'literal_element',  'value',         'modifierlist',
  'attributes',    'variable',      'expr',          'varindexed',
  'statement',     'statements',    'optspace',      'varvar',
  'foraction',     'attribute',     'ternary',       'array',
  'ifcond',        'lop',           'function',      'doublequoted_with_quotes',
  'static_class_access',  'object',        'arrayindex',    'indexdef',
  'varvarele',     'objectchain',   'objectelement',  'method',
  'params',        'modifier',      'modparameters',  'modparameter',
  'arrayelements',  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= OTHER",
 /*  14 */ "template_element ::= LINEBREAK",
 /*  15 */ "literal ::= LITERALSTART LITERALEND",
 /*  16 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  17 */ "literal_elements ::= literal_elements literal_element",
 /*  18 */ "literal_elements ::=",
 /*  19 */ "literal_element ::= literal",
 /*  20 */ "literal_element ::= LITERAL",
 /*  21 */ "literal_element ::= PHPSTARTTAG",
 /*  22 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  23 */ "literal_element ::= PHPENDTAG",
 /*  24 */ "literal_element ::= ASPSTARTTAG",
 /*  25 */ "literal_element ::= ASPENDTAG",
 /*  26 */ "smartytag ::= LDEL value RDEL",
 /*  27 */ "smartytag ::= LDEL value modifierlist attributes RDEL",
 /*  28 */ "smartytag ::= LDEL value attributes RDEL",
 /*  29 */ "smartytag ::= LDEL variable modifierlist attributes RDEL",
 /*  30 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  31 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  32 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  34 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  35 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  36 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  37 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  38 */ "smartytag ::= LDEL ID RDEL",
 /*  39 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  40 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  41 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  42 */ "smartytag ::= LDELIF expr RDEL",
 /*  43 */ "smartytag ::= LDELIF expr attributes RDEL",
 /*  44 */ "smartytag ::= LDELIF statement RDEL",
 /*  45 */ "smartytag ::= LDELIF statement attributes RDEL",
 /*  46 */ "smartytag ::= LDELFOR statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes RDEL",
 /*  47 */ "foraction ::= EQUAL expr",
 /*  48 */ "foraction ::= INCDEC",
 /*  49 */ "smartytag ::= LDELFOR statement TO expr attributes RDEL",
 /*  50 */ "smartytag ::= LDELFOR statement TO expr STEP expr attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  54 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes RDEL",
 /*  55 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  56 */ "smartytag ::= SMARTYBLOCKCHILD",
 /*  57 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  58 */ "smartytag ::= LDELSLASH ID modifierlist RDEL",
 /*  59 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  60 */ "smartytag ::= LDELSLASH ID PTR ID modifierlist RDEL",
 /*  61 */ "attributes ::= attributes attribute",
 /*  62 */ "attributes ::= attribute",
 /*  63 */ "attributes ::=",
 /*  64 */ "attribute ::= SPACE ID EQUAL ID",
 /*  65 */ "attribute ::= SPACE ID EQUAL expr",
 /*  66 */ "attribute ::= SPACE ID EQUAL value",
 /*  67 */ "attribute ::= SPACE ID",
 /*  68 */ "attribute ::= SPACE expr",
 /*  69 */ "attribute ::= SPACE value",
 /*  70 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  71 */ "statements ::= statement",
 /*  72 */ "statements ::= statements COMMA statement",
 /*  73 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  74 */ "statement ::= varindexed EQUAL expr",
 /*  75 */ "statement ::= OPENP statement CLOSEP",
 /*  76 */ "expr ::= value",
 /*  77 */ "expr ::= ternary",
 /*  78 */ "expr ::= DOLLAR ID COLON ID",
 /*  79 */ "expr ::= expr MATH value",
 /*  80 */ "expr ::= expr UNIMATH value",
 /*  81 */ "expr ::= expr ANDSYM value",
 /*  82 */ "expr ::= array",
 /*  83 */ "expr ::= expr modifierlist",
 /*  84 */ "expr ::= expr ifcond expr",
 /*  85 */ "expr ::= expr ISIN array",
 /*  86 */ "expr ::= expr ISIN value",
 /*  87 */ "expr ::= expr lop expr",
 /*  88 */ "expr ::= expr ISDIVBY expr",
 /*  89 */ "expr ::= expr ISNOTDIVBY expr",
 /*  90 */ "expr ::= expr ISEVEN",
 /*  91 */ "expr ::= expr ISNOTEVEN",
 /*  92 */ "expr ::= expr ISEVENBY expr",
 /*  93 */ "expr ::= expr ISNOTEVENBY expr",
 /*  94 */ "expr ::= expr ISODD",
 /*  95 */ "expr ::= expr ISNOTODD",
 /*  96 */ "expr ::= expr ISODDBY expr",
 /*  97 */ "expr ::= expr ISNOTODDBY expr",
 /*  98 */ "expr ::= value INSTANCEOF ID",
 /*  99 */ "expr ::= value INSTANCEOF value",
 /* 100 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /* 101 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /* 102 */ "value ::= variable",
 /* 103 */ "value ::= UNIMATH value",
 /* 104 */ "value ::= NOT value",
 /* 105 */ "value ::= TYPECAST value",
 /* 106 */ "value ::= variable INCDEC",
 /* 107 */ "value ::= HEX",
 /* 108 */ "value ::= INTEGER",
 /* 109 */ "value ::= INTEGER DOT INTEGER",
 /* 110 */ "value ::= INTEGER DOT",
 /* 111 */ "value ::= DOT INTEGER",
 /* 112 */ "value ::= ID",
 /* 113 */ "value ::= function",
 /* 114 */ "value ::= OPENP expr CLOSEP",
 /* 115 */ "value ::= SINGLEQUOTESTRING",
 /* 116 */ "value ::= doublequoted_with_quotes",
 /* 117 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 118 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 119 */ "value ::= smartytag",
 /* 120 */ "value ::= value modifierlist",
 /* 121 */ "variable ::= varindexed",
 /* 122 */ "variable ::= DOLLAR varvar AT ID",
 /* 123 */ "variable ::= object",
 /* 124 */ "variable ::= HATCH ID HATCH",
 /* 125 */ "variable ::= HATCH variable HATCH",
 /* 126 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 127 */ "arrayindex ::= arrayindex indexdef",
 /* 128 */ "arrayindex ::=",
 /* 129 */ "indexdef ::= DOT DOLLAR varvar",
 /* 130 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 131 */ "indexdef ::= DOT ID",
 /* 132 */ "indexdef ::= DOT INTEGER",
 /* 133 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 134 */ "indexdef ::= OPENB ID CLOSEB",
 /* 135 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 136 */ "indexdef ::= OPENB expr CLOSEB",
 /* 137 */ "indexdef ::= OPENB CLOSEB",
 /* 138 */ "varvar ::= varvarele",
 /* 139 */ "varvar ::= varvar varvarele",
 /* 140 */ "varvarele ::= ID",
 /* 141 */ "varvarele ::= LDEL expr RDEL",
 /* 142 */ "object ::= varindexed objectchain",
 /* 143 */ "objectchain ::= objectelement",
 /* 144 */ "objectchain ::= objectchain objectelement",
 /* 145 */ "objectelement ::= PTR ID arrayindex",
 /* 146 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 147 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 148 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 149 */ "objectelement ::= PTR method",
 /* 150 */ "function ::= ID OPENP params CLOSEP",
 /* 151 */ "method ::= ID OPENP params CLOSEP",
 /* 152 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 153 */ "params ::= params COMMA expr",
 /* 154 */ "params ::= expr",
 /* 155 */ "params ::=",
 /* 156 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 157 */ "modifierlist ::= modifier modparameters",
 /* 158 */ "modifier ::= VERT AT ID",
 /* 159 */ "modifier ::= VERT ID",
 /* 160 */ "modparameters ::= modparameters modparameter",
 /* 161 */ "modparameters ::=",
 /* 162 */ "modparameter ::= COLON value",
 /* 163 */ "modparameter ::= COLON array",
 /* 164 */ "static_class_access ::= method",
 /* 165 */ "static_class_access ::= method objectchain",
 /* 166 */ "static_class_access ::= ID",
 /* 167 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 168 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 169 */ "ifcond ::= EQUALS",
 /* 170 */ "ifcond ::= NOTEQUALS",
 /* 171 */ "ifcond ::= GREATERTHAN",
 /* 172 */ "ifcond ::= LESSTHAN",
 /* 173 */ "ifcond ::= GREATEREQUAL",
 /* 174 */ "ifcond ::= LESSEQUAL",
 /* 175 */ "ifcond ::= IDENTITY",
 /* 176 */ "ifcond ::= NONEIDENTITY",
 /* 177 */ "ifcond ::= MOD",
 /* 178 */ "lop ::= LAND",
 /* 179 */ "lop ::= LOR",
 /* 180 */ "lop ::= LXOR",
 /* 181 */ "array ::= OPENB arrayelements CLOSEB",
 /* 182 */ "arrayelements ::= arrayelement",
 /* 183 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 184 */ "arrayelements ::=",
 /* 185 */ "arrayelement ::= value APTR expr",
 /* 186 */ "arrayelement ::= ID APTR expr",
 /* 187 */ "arrayelement ::= expr",
 /* 188 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 189 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 190 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 191 */ "doublequoted ::= doublequotedcontent",
 /* 192 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 193 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 194 */ "doublequotedcontent ::= DOLLARID",
 /* 195 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 196 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 197 */ "doublequotedcontent ::= smartytag",
 /* 198 */ "doublequotedcontent ::= OTHER",
 /* 199 */ "optspace ::= SPACE",
 /* 200 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 73 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1751 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 2 ),
  array( 'lhs' => 80, 'rhs' => 0 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 0 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 12 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 0 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 4 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 98, 'rhs' => 8 ),
  array( 'lhs' => 98, 'rhs' => 7 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 0 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 4 ),
  array( 'lhs' => 110, 'rhs' => 5 ),
  array( 'lhs' => 110, 'rhs' => 6 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 0 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 3 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 0 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 0 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        18 => 15,
        16 => 16,
        17 => 17,
        103 => 17,
        105 => 17,
        106 => 17,
        165 => 17,
        19 => 19,
        20 => 19,
        76 => 19,
        77 => 19,
        102 => 19,
        107 => 19,
        108 => 19,
        113 => 19,
        115 => 19,
        116 => 19,
        123 => 19,
        164 => 19,
        182 => 19,
        21 => 21,
        22 => 21,
        23 => 23,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        29 => 27,
        28 => 28,
        30 => 28,
        32 => 28,
        31 => 31,
        33 => 33,
        34 => 33,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        44 => 42,
        43 => 43,
        45 => 43,
        46 => 46,
        47 => 47,
        48 => 48,
        68 => 48,
        69 => 48,
        166 => 48,
        187 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        61 => 61,
        62 => 62,
        71 => 62,
        154 => 62,
        158 => 62,
        63 => 63,
        155 => 63,
        64 => 64,
        65 => 65,
        66 => 65,
        67 => 67,
        70 => 70,
        72 => 72,
        73 => 73,
        74 => 73,
        75 => 75,
        78 => 78,
        79 => 79,
        80 => 79,
        81 => 79,
        82 => 82,
        138 => 82,
        199 => 82,
        83 => 83,
        120 => 83,
        84 => 84,
        87 => 84,
        98 => 84,
        85 => 85,
        86 => 86,
        88 => 88,
        89 => 89,
        90 => 90,
        95 => 90,
        91 => 91,
        94 => 91,
        92 => 92,
        97 => 92,
        93 => 93,
        96 => 93,
        99 => 99,
        100 => 100,
        101 => 101,
        104 => 104,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        114 => 114,
        117 => 117,
        118 => 118,
        119 => 119,
        121 => 121,
        122 => 122,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        136 => 133,
        134 => 134,
        135 => 135,
        137 => 137,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        153 => 153,
        156 => 156,
        157 => 157,
        159 => 159,
        160 => 160,
        161 => 161,
        162 => 162,
        163 => 162,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        183 => 183,
        184 => 184,
        185 => 185,
        186 => 186,
        188 => 188,
        189 => 189,
        190 => 190,
        191 => 191,
        192 => 192,
        193 => 192,
        195 => 192,
        194 => 194,
        196 => 196,
        197 => 197,
        198 => 198,
        200 => 200,
    );
#line 84 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->root_buffer->to_smarty_php();     }
#line 2179 "smarty_internal_templateparser.php"
#line 90 "smarty_internal_templateparser.y"
    function yy_r1(){ $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);     }
#line 2182 "smarty_internal_templateparser.php"
#line 102 "smarty_internal_templateparser.y"
    function yy_r4(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
                                         } else {
                                           $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
                                         }
                                         $this->compiler->has_variable_string = false;
                                         $this->block_nesting_level = count($this->compiler->_tag_stack);
                                            }
#line 2194 "smarty_internal_templateparser.php"
#line 114 "smarty_internal_templateparser.y"
    function yy_r5(){ $this->_retvalue = new _smarty_tag($this, '');    }
#line 2197 "smarty_internal_templateparser.php"
#line 117 "smarty_internal_templateparser.y"
    function yy_r6(){ $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2200 "smarty_internal_templateparser.php"
#line 120 "smarty_internal_templateparser.y"
    function yy_r7(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2213 "smarty_internal_templateparser.php"
#line 132 "smarty_internal_templateparser.y"
    function yy_r8(){if ($this->is_xml) {
                                       $this->compiler->tag_nocache = true;
                                       $this->is_xml = false;
                                       $save = $this->template->has_nocache_code;
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>", $this->compiler, true));
                                       $this->template->has_nocache_code = $save;
                                      }elseif ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2231 "smarty_internal_templateparser.php"
#line 150 "smarty_internal_templateparser.y"
    function yy_r9(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }
                                        }
#line 2252 "smarty_internal_templateparser.php"
#line 171 "smarty_internal_templateparser.y"
    function yy_r10(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }
                                        }
#line 2273 "smarty_internal_templateparser.php"
#line 191 "smarty_internal_templateparser.y"
    function yy_r11(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor)));
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
                                     }
                                        }
#line 2281 "smarty_internal_templateparser.php"
#line 199 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->compiler->tag_nocache = true;
                                   $this->is_xml = true;
                                   $save = $this->template->has_nocache_code;
                                   $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));
                                   $this->template->has_nocache_code = $save;
                                      }
#line 2289 "smarty_internal_templateparser.php"
#line 207 "smarty_internal_templateparser.y"
    function yy_r13(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
                                     }
                                        }
#line 2297 "smarty_internal_templateparser.php"
#line 213 "smarty_internal_templateparser.y"
    function yy_r14(){
                                     $this->_retvalue = new _smarty_linebreak($this, $this->yystack[$this->yyidx + 0]->minor);
                                       }
#line 2302 "smarty_internal_templateparser.php"
#line 218 "smarty_internal_templateparser.y"
    function yy_r15(){ $this->_retvalue = '';     }
#line 2305 "smarty_internal_templateparser.php"
#line 219 "smarty_internal_templateparser.y"
    function yy_r16(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2308 "smarty_internal_templateparser.php"
#line 221 "smarty_internal_templateparser.y"
    function yy_r17(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2311 "smarty_internal_templateparser.php"
#line 224 "smarty_internal_templateparser.y"
    function yy_r19(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2314 "smarty_internal_templateparser.php"
#line 226 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2317 "smarty_internal_templateparser.php"
#line 228 "smarty_internal_templateparser.y"
    function yy_r23(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2320 "smarty_internal_templateparser.php"
#line 229 "smarty_internal_templateparser.y"
    function yy_r24(){ $this->_retvalue = '<<?php ?>%';     }
#line 2323 "smarty_internal_templateparser.php"
#line 230 "smarty_internal_templateparser.y"
    function yy_r25(){ $this->_retvalue = '%<?php ?>>';     }
#line 2326 "smarty_internal_templateparser.php"
#line 238 "smarty_internal_templateparser.y"
    function yy_r26(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2329 "smarty_internal_templateparser.php"
#line 239 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor, 'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2332 "smarty_internal_templateparser.php"
#line 240 "smarty_internal_templateparser.y"
    function yy_r28(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2335 "smarty_internal_templateparser.php"
#line 243 "smarty_internal_templateparser.y"
    function yy_r31(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2338 "smarty_internal_templateparser.php"
#line 251 "smarty_internal_templateparser.y"
    function yy_r33(){ $this->_retvalue = $this->compiler->compileTag('assign',array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'")));    }
#line 2341 "smarty_internal_templateparser.php"
#line 253 "smarty_internal_templateparser.y"
    function yy_r35(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'")),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2344 "smarty_internal_templateparser.php"
#line 254 "smarty_internal_templateparser.y"
    function yy_r36(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>$this->yystack[$this->yyidx + -4]->minor['var'])),$this->yystack[$this->yyidx + -1]->minor),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -4]->minor['smarty_internal_index']));    }
#line 2347 "smarty_internal_templateparser.php"
#line 256 "smarty_internal_templateparser.y"
    function yy_r37(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2350 "smarty_internal_templateparser.php"
#line 257 "smarty_internal_templateparser.y"
    function yy_r38(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2353 "smarty_internal_templateparser.php"
#line 259 "smarty_internal_templateparser.y"
    function yy_r39(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2356 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r40(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                     }
#line 2361 "smarty_internal_templateparser.php"
#line 265 "smarty_internal_templateparser.y"
    function yy_r41(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -3]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                                }
#line 2366 "smarty_internal_templateparser.php"
#line 269 "smarty_internal_templateparser.y"
    function yy_r42(){ $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2369 "smarty_internal_templateparser.php"
#line 270 "smarty_internal_templateparser.y"
    function yy_r43(){ $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + -1]->minor,array('if condition'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2372 "smarty_internal_templateparser.php"
#line 274 "smarty_internal_templateparser.y"
    function yy_r46(){
                                                             $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -10]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -7]->minor),array('var'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),1);    }
#line 2376 "smarty_internal_templateparser.php"
#line 277 "smarty_internal_templateparser.y"
    function yy_r47(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2379 "smarty_internal_templateparser.php"
#line 278 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2382 "smarty_internal_templateparser.php"
#line 279 "smarty_internal_templateparser.y"
    function yy_r49(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -4]->minor),array('to'=>$this->yystack[$this->yyidx + -2]->minor))),0);    }
#line 2385 "smarty_internal_templateparser.php"
#line 280 "smarty_internal_templateparser.y"
    function yy_r50(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('to'=>$this->yystack[$this->yyidx + -4]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),0);    }
#line 2388 "smarty_internal_templateparser.php"
#line 282 "smarty_internal_templateparser.y"
    function yy_r51(){ $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2391 "smarty_internal_templateparser.php"
#line 284 "smarty_internal_templateparser.y"
    function yy_r52(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));    }
#line 2395 "smarty_internal_templateparser.php"
#line 286 "smarty_internal_templateparser.y"
    function yy_r53(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));    }
#line 2399 "smarty_internal_templateparser.php"
#line 288 "smarty_internal_templateparser.y"
    function yy_r54(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));    }
#line 2403 "smarty_internal_templateparser.php"
#line 290 "smarty_internal_templateparser.y"
    function yy_r55(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));    }
#line 2407 "smarty_internal_templateparser.php"
#line 294 "smarty_internal_templateparser.y"
    function yy_r56(){ $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);    }
#line 2410 "smarty_internal_templateparser.php"
#line 298 "smarty_internal_templateparser.y"
    function yy_r57(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2413 "smarty_internal_templateparser.php"
#line 300 "smarty_internal_templateparser.y"
    function yy_r58(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
                                                                                          }
#line 2417 "smarty_internal_templateparser.php"
#line 303 "smarty_internal_templateparser.y"
    function yy_r59(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2420 "smarty_internal_templateparser.php"
#line 304 "smarty_internal_templateparser.y"
    function yy_r60(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2423 "smarty_internal_templateparser.php"
#line 310 "smarty_internal_templateparser.y"
    function yy_r61(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor; $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2426 "smarty_internal_templateparser.php"
#line 312 "smarty_internal_templateparser.y"
    function yy_r62(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2429 "smarty_internal_templateparser.php"
#line 314 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = array();    }
#line 2432 "smarty_internal_templateparser.php"
#line 317 "smarty_internal_templateparser.y"
    function yy_r64(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
                                                 } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
                                                 } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
                                                 } else
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2442 "smarty_internal_templateparser.php"
#line 325 "smarty_internal_templateparser.y"
    function yy_r65(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2445 "smarty_internal_templateparser.php"
#line 327 "smarty_internal_templateparser.y"
    function yy_r67(){ $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";    }
#line 2448 "smarty_internal_templateparser.php"
#line 330 "smarty_internal_templateparser.y"
    function yy_r70(){$this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2451 "smarty_internal_templateparser.php"
#line 337 "smarty_internal_templateparser.y"
    function yy_r72(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2454 "smarty_internal_templateparser.php"
#line 339 "smarty_internal_templateparser.y"
    function yy_r73(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2457 "smarty_internal_templateparser.php"
#line 341 "smarty_internal_templateparser.y"
    function yy_r75(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;    }
#line 2460 "smarty_internal_templateparser.php"
#line 352 "smarty_internal_templateparser.y"
    function yy_r78(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2463 "smarty_internal_templateparser.php"
#line 354 "smarty_internal_templateparser.y"
    function yy_r79(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2466 "smarty_internal_templateparser.php"
#line 360 "smarty_internal_templateparser.y"
    function yy_r82(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2469 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r83(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));     }
#line 2472 "smarty_internal_templateparser.php"
#line 367 "smarty_internal_templateparser.y"
    function yy_r84(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2475 "smarty_internal_templateparser.php"
#line 368 "smarty_internal_templateparser.y"
    function yy_r85(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2478 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r86(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2481 "smarty_internal_templateparser.php"
#line 371 "smarty_internal_templateparser.y"
    function yy_r88(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2484 "smarty_internal_templateparser.php"
#line 372 "smarty_internal_templateparser.y"
    function yy_r89(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2487 "smarty_internal_templateparser.php"
#line 373 "smarty_internal_templateparser.y"
    function yy_r90(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2490 "smarty_internal_templateparser.php"
#line 374 "smarty_internal_templateparser.y"
    function yy_r91(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2493 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r92(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2496 "smarty_internal_templateparser.php"
#line 376 "smarty_internal_templateparser.y"
    function yy_r93(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2499 "smarty_internal_templateparser.php"
#line 382 "smarty_internal_templateparser.y"
    function yy_r99(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2502 "smarty_internal_templateparser.php"
#line 388 "smarty_internal_templateparser.y"
    function yy_r100(){ $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.' ? $_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'\')->value : '.$this->yystack[$this->yyidx + 0]->minor;  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + -2]->minor', null, true, false)->nocache;    }
#line 2505 "smarty_internal_templateparser.php"
#line 389 "smarty_internal_templateparser.y"
    function yy_r101(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2508 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r104(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2511 "smarty_internal_templateparser.php"
#line 402 "smarty_internal_templateparser.y"
    function yy_r109(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2514 "smarty_internal_templateparser.php"
#line 403 "smarty_internal_templateparser.y"
    function yy_r110(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';     }
#line 2517 "smarty_internal_templateparser.php"
#line 404 "smarty_internal_templateparser.y"
    function yy_r111(){ $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2520 "smarty_internal_templateparser.php"
#line 406 "smarty_internal_templateparser.y"
    function yy_r112(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'true';
                               } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'false';
                               } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'null';
                               } else
                               $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";     }
#line 2530 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r114(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2533 "smarty_internal_templateparser.php"
#line 423 "smarty_internal_templateparser.y"
    function yy_r117(){if (!$this->security || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor]) || $this->smarty->security_policy->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
                      																				   if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
                                                                  $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
                      																				   } else {
                                                                  $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
                                                                 }
                                                                } else {
                                                                 $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
                                                                }
                                                                   }
#line 2545 "smarty_internal_templateparser.php"
#line 433 "smarty_internal_templateparser.y"
    function yy_r118(){ if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2549 "smarty_internal_templateparser.php"
#line 436 "smarty_internal_templateparser.y"
    function yy_r119(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2552 "smarty_internal_templateparser.php"
#line 446 "smarty_internal_templateparser.y"
    function yy_r121(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') {
																				$smarty_var = $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
																				$this->_retvalue = $smarty_var;
                                      } else {
                                      	// used for array reset,next,prev,end,current
                                      	$this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
                                      	$this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + 0]->minor['var']])) {
                                          $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + 0]->minor['var'] .']->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	} else {
                                          $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	}
                                      	$this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;
                                     }
                                        }
#line 2569 "smarty_internal_templateparser.php"
#line 462 "smarty_internal_templateparser.y"
    function yy_r122(){if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + -2]->minor])) {
                                                  $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 } else {
                                                  $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 }
                                                  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2577 "smarty_internal_templateparser.php"
#line 471 "smarty_internal_templateparser.y"
    function yy_r124(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2580 "smarty_internal_templateparser.php"
#line 472 "smarty_internal_templateparser.y"
    function yy_r125(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2583 "smarty_internal_templateparser.php"
#line 475 "smarty_internal_templateparser.y"
    function yy_r126(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2586 "smarty_internal_templateparser.php"
#line 481 "smarty_internal_templateparser.y"
    function yy_r127(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2589 "smarty_internal_templateparser.php"
#line 483 "smarty_internal_templateparser.y"
    function yy_r128(){return;    }
#line 2592 "smarty_internal_templateparser.php"
#line 487 "smarty_internal_templateparser.y"
    function yy_r129(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2595 "smarty_internal_templateparser.php"
#line 488 "smarty_internal_templateparser.y"
    function yy_r130(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2598 "smarty_internal_templateparser.php"
#line 489 "smarty_internal_templateparser.y"
    function yy_r131(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2601 "smarty_internal_templateparser.php"
#line 490 "smarty_internal_templateparser.y"
    function yy_r132(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2604 "smarty_internal_templateparser.php"
#line 491 "smarty_internal_templateparser.y"
    function yy_r133(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2607 "smarty_internal_templateparser.php"
#line 493 "smarty_internal_templateparser.y"
    function yy_r134(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2610 "smarty_internal_templateparser.php"
#line 494 "smarty_internal_templateparser.y"
    function yy_r135(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2613 "smarty_internal_templateparser.php"
#line 498 "smarty_internal_templateparser.y"
    function yy_r137(){$this->_retvalue = '[]';    }
#line 2616 "smarty_internal_templateparser.php"
#line 506 "smarty_internal_templateparser.y"
    function yy_r139(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2619 "smarty_internal_templateparser.php"
#line 508 "smarty_internal_templateparser.y"
    function yy_r140(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2622 "smarty_internal_templateparser.php"
#line 510 "smarty_internal_templateparser.y"
    function yy_r141(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2625 "smarty_internal_templateparser.php"
#line 515 "smarty_internal_templateparser.y"
    function yy_r142(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2629 "smarty_internal_templateparser.php"
#line 518 "smarty_internal_templateparser.y"
    function yy_r143(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2632 "smarty_internal_templateparser.php"
#line 520 "smarty_internal_templateparser.y"
    function yy_r144(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2635 "smarty_internal_templateparser.php"
#line 522 "smarty_internal_templateparser.y"
    function yy_r145(){if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '_') {
                                                      $this->compiler->trigger_template_error (self::Err1);
																									   }
                                                     $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
                                                         }
#line 2642 "smarty_internal_templateparser.php"
#line 527 "smarty_internal_templateparser.y"
    function yy_r146(){if ($this->security) {
                                                                 $this->compiler->trigger_template_error (self::Err2);
																															 }
                                                               $this->_retvalue = '->{$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor .')->value'.$this->yystack[$this->yyidx + 0]->minor.'}'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor,"'"), null, true, false)->nocache;
                                                                   }
#line 2649 "smarty_internal_templateparser.php"
#line 532 "smarty_internal_templateparser.y"
    function yy_r147(){if ($this->security) {
                                                                 $this->compiler->trigger_template_error (self::Err2);
																															   }
                     																						 $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
                     																						    }
#line 2656 "smarty_internal_templateparser.php"
#line 537 "smarty_internal_templateparser.y"
    function yy_r148(){if ($this->security) {
                                                                         $this->compiler->trigger_template_error (self::Err2);
																															         }
                                                                       $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
                                                                          }
#line 2663 "smarty_internal_templateparser.php"
#line 543 "smarty_internal_templateparser.y"
    function yy_r149(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2666 "smarty_internal_templateparser.php"
#line 549 "smarty_internal_templateparser.y"
    function yy_r150(){if (!$this->security || $this->smarty->security_policy->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'array') === 0 || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $func_name = strtolower($this->yystack[$this->yyidx + -3]->minor);
																					                if ($func_name == 'isset') {
																					                  if (count($this->yystack[$this->yyidx + -1]->minor) == 0) {
																					                   $this->compiler->trigger_template_error ('Illegal number of paramer in "isset()"');
																					                  }
																					                  $isset_par=str_replace("')->value","',null,true,false)->value",implode(',',$this->yystack[$this->yyidx + -1]->minor));
																					                  $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $isset_par .")";
																						              } elseif (in_array($func_name,array('empty','reset','current','end','prev','next'))){
																					                  if (count($this->yystack[$this->yyidx + -1]->minor) != 1) {
																					                   $this->compiler->trigger_template_error ('Illegal number of paramer in "empty()"');
																					                  }
																					                  if ($func_name == 'empty') {
																					                  	$this->_retvalue = $func_name.'('.str_replace("')->value","',null,true,false)->value",$this->yystack[$this->yyidx + -1]->minor[0]).')';
																					                  } else {
																					                  	$this->_retvalue = $func_name.'('.$this->yystack[$this->yyidx + -1]->minor[0].')';
																					                  }
																					                } else {
																					                  $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
																					                }
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                     }
                                                        }
#line 2694 "smarty_internal_templateparser.php"
#line 579 "smarty_internal_templateparser.y"
    function yy_r151(){if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) == '_') {
                                                      $this->compiler->trigger_template_error (self::Err1);
																									 }
                                                   $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
                                                      }
#line 2701 "smarty_internal_templateparser.php"
#line 584 "smarty_internal_templateparser.y"
    function yy_r152(){if ($this->security) {
                                                              $this->compiler->trigger_template_error (self::Err2);
																													 }
                                                           $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
                                                              }
#line 2708 "smarty_internal_templateparser.php"
#line 592 "smarty_internal_templateparser.y"
    function yy_r153(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));    }
#line 2711 "smarty_internal_templateparser.php"
#line 601 "smarty_internal_templateparser.y"
    function yy_r156(){$this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));    }
#line 2714 "smarty_internal_templateparser.php"
#line 602 "smarty_internal_templateparser.y"
    function yy_r157(){$this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));    }
#line 2717 "smarty_internal_templateparser.php"
#line 605 "smarty_internal_templateparser.y"
    function yy_r159(){ $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2720 "smarty_internal_templateparser.php"
#line 610 "smarty_internal_templateparser.y"
    function yy_r160(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2723 "smarty_internal_templateparser.php"
#line 612 "smarty_internal_templateparser.y"
    function yy_r161(){$this->_retvalue = array();    }
#line 2726 "smarty_internal_templateparser.php"
#line 614 "smarty_internal_templateparser.y"
    function yy_r162(){$this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2729 "smarty_internal_templateparser.php"
#line 624 "smarty_internal_templateparser.y"
    function yy_r167(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2732 "smarty_internal_templateparser.php"
#line 626 "smarty_internal_templateparser.y"
    function yy_r168(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2735 "smarty_internal_templateparser.php"
#line 635 "smarty_internal_templateparser.y"
    function yy_r169(){$this->_retvalue = '==';    }
#line 2738 "smarty_internal_templateparser.php"
#line 636 "smarty_internal_templateparser.y"
    function yy_r170(){$this->_retvalue = '!=';    }
#line 2741 "smarty_internal_templateparser.php"
#line 637 "smarty_internal_templateparser.y"
    function yy_r171(){$this->_retvalue = '>';    }
#line 2744 "smarty_internal_templateparser.php"
#line 638 "smarty_internal_templateparser.y"
    function yy_r172(){$this->_retvalue = '<';    }
#line 2747 "smarty_internal_templateparser.php"
#line 639 "smarty_internal_templateparser.y"
    function yy_r173(){$this->_retvalue = '>=';    }
#line 2750 "smarty_internal_templateparser.php"
#line 640 "smarty_internal_templateparser.y"
    function yy_r174(){$this->_retvalue = '<=';    }
#line 2753 "smarty_internal_templateparser.php"
#line 641 "smarty_internal_templateparser.y"
    function yy_r175(){$this->_retvalue = '===';    }
#line 2756 "smarty_internal_templateparser.php"
#line 642 "smarty_internal_templateparser.y"
    function yy_r176(){$this->_retvalue = '!==';    }
#line 2759 "smarty_internal_templateparser.php"
#line 643 "smarty_internal_templateparser.y"
    function yy_r177(){$this->_retvalue = '%';    }
#line 2762 "smarty_internal_templateparser.php"
#line 645 "smarty_internal_templateparser.y"
    function yy_r178(){$this->_retvalue = '&&';    }
#line 2765 "smarty_internal_templateparser.php"
#line 646 "smarty_internal_templateparser.y"
    function yy_r179(){$this->_retvalue = '||';    }
#line 2768 "smarty_internal_templateparser.php"
#line 647 "smarty_internal_templateparser.y"
    function yy_r180(){$this->_retvalue = ' XOR ';    }
#line 2771 "smarty_internal_templateparser.php"
#line 652 "smarty_internal_templateparser.y"
    function yy_r181(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2774 "smarty_internal_templateparser.php"
#line 654 "smarty_internal_templateparser.y"
    function yy_r183(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2777 "smarty_internal_templateparser.php"
#line 655 "smarty_internal_templateparser.y"
    function yy_r184(){ return;     }
#line 2780 "smarty_internal_templateparser.php"
#line 656 "smarty_internal_templateparser.y"
    function yy_r185(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2783 "smarty_internal_templateparser.php"
#line 657 "smarty_internal_templateparser.y"
    function yy_r186(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2786 "smarty_internal_templateparser.php"
#line 664 "smarty_internal_templateparser.y"
    function yy_r188(){ $this->_retvalue = "''";     }
#line 2789 "smarty_internal_templateparser.php"
#line 665 "smarty_internal_templateparser.y"
    function yy_r189(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();     }
#line 2792 "smarty_internal_templateparser.php"
#line 667 "smarty_internal_templateparser.y"
    function yy_r190(){ $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2795 "smarty_internal_templateparser.php"
#line 668 "smarty_internal_templateparser.y"
    function yy_r191(){ $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2798 "smarty_internal_templateparser.php"
#line 670 "smarty_internal_templateparser.y"
    function yy_r192(){ $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2801 "smarty_internal_templateparser.php"
#line 672 "smarty_internal_templateparser.y"
    function yy_r194(){if (isset($this->compiler->local_var["'".substr($this->yystack[$this->yyidx + 0]->minor,1)."'"])) {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
                                                      } else {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value');
                                                      }
                                                      $this->compiler->tag_nocache = $this->compiler->tag_nocache | $this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache;
      }
#line 2810 "smarty_internal_templateparser.php"
#line 680 "smarty_internal_templateparser.y"
    function yy_r196(){ $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');     }
#line 2813 "smarty_internal_templateparser.php"
#line 681 "smarty_internal_templateparser.y"
    function yy_r197(){
   $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
      }
#line 2818 "smarty_internal_templateparser.php"
#line 684 "smarty_internal_templateparser.y"
    function yy_r198(){ $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2821 "smarty_internal_templateparser.php"
#line 691 "smarty_internal_templateparser.y"
    function yy_r200(){$this->_retvalue = '';    }
#line 2824 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 66 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2887 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 58 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2905 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);

        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>