//*****************************************************************************
//                                DlgPrefs.hpp                                *
//                               --------------                               *
// Description : This dialogue is used to enter applications preferences.     *
// Started     : 17/10/2006                                                   *
// Last Update : 16/04/2010                                                   *
// Copyright   : (C) 2006 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef DLGPREFS_HPP
#define DLGPREFS_HPP

// System Includes

#include <iostream>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/config.h>
#include <wx/tooltip.h>

// Application Includes

#include "CmdLinePcr.hpp"
#include "utility/PnlValue.hpp"
#include "utility/TextCtrl.hpp"
#include "utility/ConvertType.hpp"

// Local Constant Declarations


//*****************************************************************************

class DlgPrefs : public wxDialog
{
  private :

    // Pointer to global configuration object
    wxConfig    * m_poCfg;

    // Display controls
    wxLabel     m_oLblViewer;
    wxChoice    m_oChoViewer;
    wxLabel     m_oLblTmpFileMgt;
    wxChoice    m_oChoTmpFileMgt;
    wxLabel     m_oLblPrecision;
    wxChoice    m_oChoPrecision;
    PnlValue    m_oPnlNbkMaxLines;
    wxCheckBox  m_oCbxSyncSwpSrcs;
    wxCheckBox  m_oCbxToolTips;

    // Button controls
    wxButton      m_oBtnOk;
    wxButton      m_oBtnCancel;

    // Object initialization functions
    void  Initialize( void );
    void  Create    ( void );
    void  ToolTips  ( void );
    void  DoLayout  ( void );

    void  Load( void );
    void  Save( void );

  public :

    DlgPrefs( wxWindow * poWin );
   ~DlgPrefs( );

    bool  bClear( void );

    const  wxString  rosGetViewer     ( void )
                              { return( m_oChoViewer.GetStringSelection( ) ); }
           int         iGetNbkMaxLines( void )
                              { return( (int)m_oPnlNbkMaxLines.liGetValue()); }
           int         iGetTmpFileMgt ( void )
                              { return( m_oChoTmpFileMgt.GetSelection( )   ); }
           int         iGetPrecision ( void )
                              { return( m_oChoPrecision.GetSelection( )    ); }
           bool        bGetSyncSwpSrcs( void )
                              { return( m_oCbxSyncSwpSrcs.IsChecked( )     ); }
           bool        bGetToolTips   ( void )
                              { return( m_oCbxToolTips.IsChecked( )        ); }

    // Event handlers
    void  OnBtnOk    ( wxCommandEvent & roEvtCmd );
    void  OnBtnCancel( wxCommandEvent & roEvtCmd );

    friend  class  FrmMain;

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eDlgItemID
    {
      ID_CHO_SIMENG = 0,
      ID_CHO_VIEWER,
      ID_CHO_TMPFILEMGT,
      ID_CHO_PRECISION,

      ID_PNL_NBKMAXLINES,

      ID_CBX_SYNCSWPSRCS,
      ID_CBX_TOOLTIPS,

      ID_BTN_OK,
      ID_BTN_CANCEL,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_CHO_SIMENG,
      ID_LST = ID_BTN_CANCEL
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // DLGPREFS_HPP
