/*
 * JasperReports - Free Java Reporting Library.
 * Copyright (C) 2001 - 2016 TIBCO Software Inc. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of JasperReports.
 *
 * JasperReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JasperReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with JasperReports. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.jasperreports.util;




/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 */
public class CastorMapping
{
	private String key;
	// the version at which the mapping became effective
	// null version means that mapping is the initial mapping
	private String version;
	private String path;
	
	/**
	 * 
	 */
	public CastorMapping(String path)
	{
		this.path = path;
	}
	
	public CastorMapping(String key, String version, String path)
	{
		this.key = key;
		this.version = version;
		this.path = path;
	}

	/**
	 * 
	 */
	public String getPath()
	{
		return path;
	}

	/**
	 * 
	 */
	public void setPath(String path)
	{
		this.path = path;
	}

	public String getKey()
	{
		return key;
	}

	public void setKey(String key)
	{
		this.key = key;
	}

	public String getVersion()
	{
		return version;
	}

	public void setVersion(String version)
	{
		this.version = version;
	}
}
