/*
 * The JTS Topology Suite is a collection of Java classes that
 * implement the fundamental operations required to validate a given
 * geo-spatial data set to a known topological specification.
 *
 * Copyright (C) 2001 Vivid Solutions
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, contact:
 *
 *     Vivid Solutions
 *     Suite #1A
 *     2328 Government Street
 *     Victoria BC  V8T 5G5
 *     Canada
 *
 *     (250)385-6040
 *     www.vividsolutions.com
 */
package com.vividsolutions.jts.io.geojson;


/**
 * Constants for GeoJSON objects
 * 
 * @author Martin Davis
 */
public class GeoJsonConstants {

  public static final String NAME_GEOMETRIES = "geometries";
  public static final String NAME_CRS = "crs";
  public static final String NAME_PROPERTIES = "properties";
  public static final String NAME_NAME = "name";
  public static final String NAME_TYPE = "type";
  public static final String NAME_POINT = "Point";
  public static final String NAME_LINESTRING = "LineString";
  public static final String NAME_POLYGON = "Polygon";
  public static final String NAME_COORDINATES = "coordinates";
  public static final String NAME_GEOMETRYCOLLECTION = "GeometryCollection";
  public static final String NAME_MULTIPOLYGON = "MultiPolygon";
  public static final String NAME_MULTILINESTRING = "MultiLineString";
  public static final String NAME_MULTIPOINT = "MultiPoint";

}
