/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgetplaque.h"
#include "tirage.h"

#include <QtGui>

//Cration d'un widget regroupant 1 Lcd et 2 pushbuttons pour les plaques
WidgetPlaque::WidgetPlaque( QWidget *parent, int numW, int type_plaqueW)
        : QWidget( parent) {
	
	//init du num de widget et de la variable d'tat est_compte
	//num est un identifiant unique qui doit tre diffrent pour chaque plaque
	num=numW;
	type_plaque=type_plaqueW;
	
	//init des elements graphiques
	QVBoxLayout *vboxLayout = new QVBoxLayout(this);
	vboxLayout->setSpacing(0);
	vboxLayout->setMargin(0);
	
	//un afficheur lcd
	lcd = new QLCDNumber(this);
	
	if (type_plaque==0) {
		lcd->setNumDigits( 1 );
		lcd->setFixedSize( 32, 51 );
	} else {
		lcd->setNumDigits( 3 );
		lcd->setFixedHeight( 28 );
	}
	
	lcd->setSegmentStyle( QLCDNumber::Flat );
	lcd->setAutoFillBackground ( true );
	
	if (type_plaque==0) {		//plaque du compte
		colorise(0); cliquable=false; reglable=true;
	} else if (type_plaque==1){	//plaque du tirage
		colorise(1); cliquable=true; reglable=true;
	} else {			//plaque de rsolution
		colorise(3); cliquable=false; reglable=false;
	}
	
	vboxLayout->addWidget(lcd);
	
	//cration du timer
	timer= new QTimer;
	connect(timer, SIGNAL(timeout()), this, SLOT(pbClicked()) );
}

void WidgetPlaque::pbClicked() {
	emit change(num, clicPlus);
}

void WidgetPlaque::displayRefresh(int numW, int valeur) {
	//rception du signal si le numro de widget correspond
	//mthode un peu lourde mais qui permet de supprimer le nom des widgets
	if(num==numW) {
		if(numW>=100){	//cas d'un lcd du widget de rsolution
			if (valeur <=999) {lcd->setNumDigits(3);}
			else if(valeur <=9999) {lcd->setNumDigits(4);}
			else if(valeur <=99999) {lcd->setNumDigits(5);}
			else if(valeur <=999999) {lcd->setNumDigits(6);}
			else if(valeur <=9999999) {lcd->setNumDigits(7);}
			else if(valeur <=99999999) {lcd->setNumDigits(8);}
			else lcd->setNumDigits(9);
		}
		lcd->display(valeur);
		//on n'affiche que les plaques que l'on utilise
		if(numW>=tirage::nb_plaques && numW<10){
			hide();
		}
		else{
			show();
		}
	}
}

void WidgetPlaque::updateEtat(int numW, int valeur) {
	if(num==numW) {
		if(valeur==0){		//plaque en attente d'un clic
			cliquable=true;
			colorise(1);	//colore en blanc
		} else
		if(valeur==1){		//plaque du tirage dsactive
			cliquable=false;
			colorise(1);	//colore en blanc
		} else
		if(valeur==2){		//plaque = le bon compte
			cliquable=false;
			colorise(0);	//colore en orange
		} else
		if(valeur==3){		//plaque utilise
			cliquable=false;
			colorise(2);	//colore en gris
		} else {		//plaque cache
			cliquable=false;
			colorise(3);	//colore en gris total
		}
	}
}

//pour rendre non cliquable une plaque
void WidgetPlaque::nonCliquable(int numW){
	if(num==numW) {
		cliquable=false;
	}
}

//action effectue lorsqu'on utilise la molette de la souris
void WidgetPlaque::wheelEvent(QWheelEvent *event) {
	if (!reglable) return;
	if (event->delta()>0){
		clicPlus=true;
	} else {
		clicPlus=false;
	}
	pbClicked();
}

//on met la valeur de la plaque ds qu'il y a un clic
void WidgetPlaque::mousePressEvent(QMouseEvent *event) {
	if(reglable){
		if(event->button()==Qt::RightButton) {
			clicPlus=false;
		} else {
			clicPlus=true;
		}
		pbClicked();
		timer->start(150); //launch the timer to repeat the action
	} else
	if(cliquable){
		cliquable=false;
		colorise(2);
		emit valeur(num,lcd->intValue());
	}
}

//dtection de la relche du bouton
void WidgetPlaque::mouseReleaseEvent ( QMouseEvent *) {
	timer->stop();
}

//permet d'activer/dsactiver les possibilits de rglage de la plaque
void WidgetPlaque::estReglable(bool regl) {
	reglable = regl;
}

void WidgetPlaque::colorise(int couleur) {
	if (couleur==0) {
		lcd->setPalette( palette_orange );
	} else
	if (couleur==1) {
		lcd->setPalette( palette_blanc );
	} else
	if (couleur==2) {
		lcd->setPalette( palette_gris );
	} else {
		lcd->setPalette( palette_gris_total );
	}
}
