#pragma once
/*
 *      Copyright (C) 2005-2019 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1335, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

#include "tinyxml.h"
#include "kodi/libXBMC_pvr.h"

#include <memory>
#include <string>
#include <vector>

namespace enigma2
{
  namespace data
  {
    class BaseChannel
    {
    public:
      BaseChannel() = default;
      BaseChannel(const BaseChannel& b) : m_radio(b.IsRadio()), m_uniqueId(b.GetUniqueId()),
        m_channelName(b.GetChannelName()), m_serviceReference(b.GetServiceReference()) {};
      ~BaseChannel() = default;

      bool IsRadio() const { return m_radio; }
      void SetRadio(bool value) { m_radio = value; }

      int GetUniqueId() const { return m_uniqueId; }
      void SetUniqueId(int value) { m_uniqueId = value; }

      const std::string& GetChannelName() const { return m_channelName; }
      void SetChannelName(const std::string& value) { m_channelName = value; }

      const std::string& GetServiceReference() const { return m_serviceReference; }
      void SetServiceReference(const std::string& value) { m_serviceReference = value; }

    protected:
      bool m_radio;
      int m_uniqueId = -1;
      std::string m_channelName;
      std::string m_serviceReference;
    };
  } //namespace data
} //namespace enigma2