#!/usr/bin/env python

from lbserver import *

def splitHostPort(s):
    h,p = s.split(':')
    p = int(p)
    if h == '*':
        h = ''
    return h,p

class ConfigError(Exception): pass

class LBServerFactory:
    def __init__(self, filename=None, xml=None):
        dom = self._loadDOM(filename, xml)
        if dom.nodeName != 'lbsconfig':
            raise ConfigError, "expected top level 'lbsconfig', got '%s'"%(dom.nodeName)
    def _loadDOM(self, filename, xml):
        from xml.dom.minidom import parseString
        if filename is not None:
            xml = open(filename).read()
        elif xml is None:
            raise ConfigError, "need filename or xml"
        self.dom = parseString(xml)
        return self.dom.childNodes[0]
    def _createLBServer(self):
        return LBServer()
    def _loadLBServer(self, elem):
        lbServer = self._createLBServer()
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'lbservice':
                if item.hasAttribute('listen'):
                    lbServer.lblisten = splitHostPort(item.getAttribute('listen'))
                if item.hasAttribute('max-threads'):
                    lbServer.maxthreads = int(item.getAttribute('max-threads'))
                if item.hasAttribute('refresh-delay'):
                    lbServer.refresh = int(item.getAttribute('refresh-delay'))
                if item.hasAttribute('returns'):
                    lbServer.returns = item.getAttribute('returns').replace('$','')
            elif item.nodeName == u'lbslave':
                if item.hasAttribute('is-slave'):
                    lbServer.isslave = item.getAttribute('is-slave').lower()=="true"
                if item.hasAttribute('master-url'):
                    lbServer.masterurl = item.getAttribute('master-url')
                if item.hasAttribute('config-refresh-delay'):
                    lbServer.cfgrefresh = int(item.getAttribute('config-refresh-delay'))
            elif item.nodeName == u'mgmtservice':
                if item.hasAttribute('listen'):
                    lbServer.mgmtlisten = splitHostPort(item.getAttribute('listen'))
                if item.hasAttribute('enabled'):
                    lbServer.mgmtenabled = item.getAttribute('enabled').lower()=="true"
            elif item.nodeName == u'nodes':
                lbServer.groups=self._loadGroups(lbServer,item)
            elif item.nodeName == u'rules':
                lbServer.variables=self._loadVariables(item)
            else: raise ConfigError, "expected 'lbservice', 'lbslave', 'mgmtservice', 'nodes' or 'rules', got '%s'"%item.nodeName
        return lbServer
    def _loadGroups(self,lbServer, elem):
        groups = {}
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'group':
                group = self._loadGroup(lbServer,item)
                groups[group.name]=group
            else: raise ConfigError, "expected 'group' got '%s'"%item.nodeName
        return groups
    def _loadGroup(self,lbServer, elem):
        group = LBGroup(lbServer)
        if elem.hasAttribute('name'):
            group.name = elem.getAttribute('name')
        if elem.hasAttribute('default'):
            group.default = elem.getAttribute('default').lower()=="true"
        if elem.hasAttribute('backup'):
            group.backup = elem.getAttribute('backup')
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'node':
                group.nodes.append(self._loadNode(lbServer,item))
            else: raise ConfigError, "expected 'node' got '%s'"%item.nodeName
        return group
    def _loadNode(self, lbServer, elem):
        node = LBNode(lbServer)
        if elem.hasAttribute('name'):
            node.name = elem.getAttribute('name')
        if elem.hasAttribute('address'):
            node.address = elem.getAttribute('address')
        return node
    def _loadVariables(self, elem):
        variables = []
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'variable':
                variables.append(self._loadVariable(item))
            else: raise ConfigError, "expected 'variable' got '%s'"%item.nodeName
        return variables
    def _loadVariable(self, elem):
        variable = LBVariable()
        if elem.hasAttribute('name'):
            variable.name = elem.getAttribute('name')
        if elem.hasAttribute('weight'):
            variable.weight = int(elem.getAttribute('weight'))
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'choose':
                variable.rules += self._loadChoose(item)
            elif item.nodeName == u'rule':
                variable.rules.append(self._loadRule(item))
            else: raise ConfigError, "expected 'choose' or 'rule' got '%s'"%item.nodeName
        return variable
    def _loadChoose(self, elem):
        rules = []
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'when' or item.nodeName == u'otherwise':
                rules.append(self._loadWhenCase(item))
            else: raise ConfigError, "expected 'when' or 'otherwise' got '%s'"%item.nodeName
        return rules
    def _loadWhenCase(self, elem):
        rule = None
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'rule':
                rule = self._loadRule(item)
            else: raise ConfigError, "expected 'rule' got '%s'"%item.nodeName
        if elem.nodeName == u'when':
            rule.test = elem.getAttribute('test')
        return rule
    def _loadRule(self, elem):
        rule = LBRule()
        if elem.hasAttribute('capacity'):
            rule.capacity = elem.getAttribute('capacity')
        if elem.hasAttribute('critical'):
            rule.critical = elem.getAttribute('critical')
        return rule
    def newLBServer(self):
        lbServer = self._loadLBServer(self.dom.childNodes[0])
        return lbServer


def main():
    pass

if __name__ == "__main__":
    main()
