/*
 * @(#)PropertyCheckUtil.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.ant;


import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

import junit.framework.Assert;


/**
 * Checks for property files.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     March 9, 2004
 */
public class PropertyCheckUtil extends Assert
{
    public static void assertEquals( String text, Properties expected,
            Properties actual )
    {
        StringBuffer missing = new StringBuffer( text );
        int badCount = 0;
        
        Enumeration enum = expected.propertyNames();
        while (enum.hasMoreElements())
        {
            String key = (String)enum.nextElement();
            String value = expected.getProperty( key );
            String actualValue = expected.getProperty( key );
            if (!value.equals( actualValue ))
            {
                ++badCount;
                missing.append( "; expected property '" ).
                    append( key ).append( "' to have value '" ).
                    append( value ).append( "', but found '" ).
                    append( actualValue ).append( "'" );
            }
        }
        
        enum = actual.propertyNames();
        while (enum.hasMoreElements())
        {
            String key = (String)enum.nextElement();
            if (expected.getProperty( key ) == null)
            {
                ++badCount;
                missing.append( "; found extra property '" ).
                    append( key ).append( "' = '" ).
                    append( actual.getProperty( key ) ).append( "'" );
            }
        }
        
        if (badCount > 0)
        {
            fail( missing.toString() );
        }
    }
    

    public static Properties loadGroboProperties()
            throws IOException
    {
        return loadProperties( "./grobocoverage.properties" );
    }
    
    
    public static Properties loadProperties( String file )
            throws IOException
    {
        Properties props = new Properties();
        InputStream is = new FileInputStream( file );
        try
        {
            props.load( is );
        }
        finally
        {
            is.close();
        }
        return props;
    }
}

