/*
 * Port of im-client.c using libindicate-qt
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#ifndef QIM_CLIENT_H
#define QIM_CLIENT_H

#include <QApplication>
#include <QObject>
#include <QStringList>

class Controller : public QObject
{
Q_OBJECT
public:
    Controller()
    {
        mUserList << "Homer" << "Marge" << "Bart" << "Liza";
        mPos = 0;
    }

public Q_SLOTS:
    void createCountIndicator();
    void createAttentionIndicator();
    void modifyAttentionIndicator();
    void slotServerDisplay();
    void slotInterestAdded(QIndicate::Interest);
    void slotInterestRemoved(QIndicate::Interest);
    void slotIndicatorDisplay(QIndicate::Indicator*);

public:
    QIndicate::Indicator* mCountIndicator;
    QIndicate::Indicator* mAttentionIndicator;
    QStringList mUserList;
    int mPos;
};

#endif /* QIM_CLIENT_H */
