/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.loader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/**
 * Very basic test case that provides methods to create a cache loader config.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 */

@Test(groups = "functional")
public abstract class AbstractCacheLoaderTestBase
{
   protected final Log log = LogFactory.getLog(getClass());

   protected CacheLoaderConfig getSingleCacheLoaderConfig(String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared) throws Exception
   {
      return getSingleCacheLoaderConfig(preload, cacheloaderClass, properties, async, fetchPersistentState, shared, false);
   }

   protected CacheLoaderConfig getSingleCacheLoaderConfig(String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup) throws Exception
   {
      return getSingleCacheLoaderConfig(false, preload, cacheloaderClass, properties, async, fetchPersistentState, shared, purgeOnStartup);
   }

   protected CacheLoaderConfig getSingleCacheLoaderConfig(boolean passivation, String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup) throws Exception
   {
      String xml = "<config>\n" +
            "<passivation>" + passivation + "</passivation>\n" +
            "<preload>" + preload + "</preload>\n" +
            "<cacheloader>\n" +
            "<class>" + cacheloaderClass + "</class>\n" +
            "<properties>" + properties + "</properties>\n" +
            "<async>" + async + "</async>\n" +
            "<shared>" + shared + "</shared>\n" +
            "<fetchPersistentState>" + fetchPersistentState + "</fetchPersistentState>\n" +
            "<purgeOnStartup>" + purgeOnStartup + "</purgeOnStartup>\n" +
            "</cacheloader>\n" +
            "</config>";
      Element element = XmlHelper.stringToElement(xml);
      return XmlConfigurationParser.parseCacheLoaderConfig(element);
   }
}
