/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.prefs.Preferences;

/**
 *
 * @author lahvac
 */
public class AddUnderscoresPanel extends javax.swing.JPanel {
    
    private final Preferences prefs;

    public AddUnderscoresPanel(Preferences prefs) {
        initComponents();
        this.prefs = prefs;

        binary.setValue(AddUnderscores.getSizeForRadix(prefs, 2));
        decimal.setValue(AddUnderscores.getSizeForRadix(prefs, 10));
        hexa.setValue(AddUnderscores.getSizeForRadix(prefs, 16));
        replaceExisting.setSelected(AddUnderscores.isReplaceLiteralsWithUnderscores(prefs));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        binary = new javax.swing.JSpinner();
        decimal = new javax.swing.JSpinner();
        hexa = new javax.swing.JSpinner();
        replaceExisting = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(AddUnderscoresPanel.class, "AddUnderscoresPanel.jLabel1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(AddUnderscoresPanel.class, "AddUnderscoresPanel.jLabel2.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(AddUnderscoresPanel.class, "AddUnderscoresPanel.jLabel3.text")); // NOI18N

        binary.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                binaryStateChanged(evt);
            }
        });

        decimal.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                decimalStateChanged(evt);
            }
        });

        hexa.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                hexaStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(replaceExisting, org.openide.util.NbBundle.getMessage(AddUnderscoresPanel.class, "AddUnderscoresPanel.replaceExisting.text")); // NOI18N
        replaceExisting.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                replaceExistingStateChanged(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(replaceExisting)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel3)
                            .addComponent(jLabel2)
                            .addComponent(jLabel1))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(binary, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(decimal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(hexa, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(binary, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(decimal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(hexa, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(replaceExisting)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void binaryStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_binaryStateChanged
        AddUnderscores.setSizeForRadix(prefs, 2, (Integer) binary.getValue());
    }//GEN-LAST:event_binaryStateChanged

    private void decimalStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_decimalStateChanged
        AddUnderscores.setSizeForRadix(prefs, 10, (Integer) decimal.getValue());
    }//GEN-LAST:event_decimalStateChanged

    private void hexaStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_hexaStateChanged
        AddUnderscores.setSizeForRadix(prefs, 16, (Integer) hexa.getValue());
    }//GEN-LAST:event_hexaStateChanged

    private void replaceExistingStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_replaceExistingStateChanged
        AddUnderscores.setReplaceLiteralsWithUnderscores(prefs, replaceExisting.isSelected());
    }//GEN-LAST:event_replaceExistingStateChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSpinner binary;
    private javax.swing.JSpinner decimal;
    private javax.swing.JSpinner hexa;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JCheckBox replaceExisting;
    // End of variables declaration//GEN-END:variables
}
