use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'Postfix';
my $samplepath = sprintf("./set-of-emails/private/lhost-%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->makeinquiry;
my $isexpected = {
    # INDEX => [['D.S.N.', 'replycode', 'REASON', 'hardbounce'], [...]]
    '1001'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1002'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1003'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1004'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1005'  => [['5.0.0',   '554', 'filtered',        0]],
    '1006'  => [['5.7.1',   '550', 'userunknown',     1]],
    '1007'  => [['5.0.0',   '554', 'filtered',        0]],
    '1008'  => [['5.0.910', '',    'filtered',        0]],
    '1009'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1010'  => [['5.0.0',   '',    'hostunknown',     1]],
    '1011'  => [['5.0.0',   '551', 'systemerror',     0]],
    '1012'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1013'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1014'  => [['5.1.1',   '',    'userunknown',     1]],
    '1015'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1016'  => [['4.3.2',   '452', 'toomanyconn',     0]],
    '1017'  => [['4.4.1',   '',    'expired',         0]],
    '1018'  => [['5.4.6',   '',    'systemerror',     0]],
    '1019'  => [['5.7.1',   '553', 'userunknown',     1]],
    '1020'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1021'  => [['4.4.1',   '',    'expired',         0]],
    '1022'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1023'  => [['5.0.0',   '550', 'blocked',         0]],
    '1024'  => [['5.1.1',   '',    'userunknown',     1]],
    '1025'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1026'  => [['4.4.1',   '',    'expired',         0]],
    '1027'  => [['5.4.6',   '',    'systemerror',     0]],
    '1028'  => [['5.0.0',   '551', 'suspend',         0]],
    '1029'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1030'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1031'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1032'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1033'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1034'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1035'  => [['4.2.2',   '',    'mailboxfull',     0]],
    '1036'  => [['5.4.4',   '',    'hostunknown',     1]],
    '1037'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1038'  => [['5.0.0',   '550', 'blocked',         0]],
    '1039'  => [['5.1.1',   '',    'userunknown',     1]],
    '1040'  => [['5.7.1',   '550', 'userunknown',     1]],
    '1041'  => [['5.1.1',   '',    'userunknown',     1]],
    '1042'  => [['5.4.4',   '',    'networkerror',    0]],
    '1043'  => [['5.1.6',   '550', 'hasmoved',        1]],
    '1044'  => [['5.3.4',   '',    'mesgtoobig',      0]],
    '1045'  => [['5.3.4',   '',    'mesgtoobig',      0]],
    '1046'  => [['5.0.0',   '534', 'mesgtoobig',      0]],
    '1047'  => [['5.7.1',   '554', 'mesgtoobig',      0]],
    '1048'  => [['5.1.1',   '550', 'userunknown',     1],
                ['5.1.1',   '550', 'userunknown',     1],
                ['5.1.1',   '550', 'userunknown',     1],
                ['5.1.1',   '550', 'userunknown',     1],
                ['5.1.1',   '550', 'userunknown',     1]],
    '1049'  => [['5.0.0',   '550', 'hostunknown',     1]],
    '1050'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1051'  => [['5.7.1',   '553', 'norelaying',      0]],
    '1052'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1053'  => [['5.4.6',   '',    'systemerror',     0]],
    '1054'  => [['5.1.1',   '',    'userunknown',     1]],
    '1055'  => [['5.2.1',   '550', 'filtered',        0]],
    '1056'  => [['5.1.1',   '',    'mailererror',     0]],
    '1057'  => [['5.2.1',   '550', 'userunknown',     1],
                ['5.1.1',   '550', 'userunknown',     1]],
    '1058'  => [['5.0.0',   '550', 'filtered',        0]],
    '1059'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1060'  => [['4.1.1',   '450', 'userunknown',     1]],
    '1061'  => [['5.4.4',   '',    'hostunknown',     1]],
    '1062'  => [['5.0.910', '550', 'filtered',        0]],
    '1063'  => [['5.1.1',   '',    'mailererror',     0]],
    '1064'  => [['5.0.0',   '',    'hostunknown',     1]],
    '1065'  => [['5.0.0',   '',    'networkerror',    0]],
    '1066'  => [['5.0.0',   '554', 'norelaying',      0]],
    '1067'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1068'  => [['5.0.0',   '554', 'norelaying',      0]],
    '1069'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1070'  => [['5.0.944', '',    'networkerror',    0]],
    '1071'  => [['5.0.922', '',    'mailboxfull',     0]],
    '1072'  => [['5.0.901', '554', 'onhold',          0]],
    '1073'  => [['4.0.0',   '452', 'mailboxfull',     0]],
    '1074'  => [['5.0.0',   '550', 'mailboxfull',     0]],
    '1075'  => [['5.7.0',   '',    'mailboxfull',     0]],
    '1076'  => [['5.0.0',   '554', 'filtered',        0]],
    '1077'  => [['5.7.1',   '553', 'norelaying',      0]],
    '1078'  => [['5.0.0',   '550', 'norelaying',      0]],
    '1079'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1080'  => [['5.7.1',   '554', 'spamdetected',    0]],
    '1081'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1082'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1083'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1084'  => [['5.7.1',   '554', 'spamdetected',    0]],
    '1085'  => [['5.7.1',   '554', 'spamdetected',    0]],
    '1086'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1087'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1088'  => [['5.6.0',   '554', 'spamdetected',    0]],
    '1089'  => [['5.7.1',   '554', 'spamdetected',    0]],
    '1090'  => [['5.7.1',   '554', 'spamdetected',    0]],
    '1091'  => [['5.0.0',   '500', 'spamdetected',    0]],
    '1092'  => [['5.0.0',   '554', 'spamdetected',    0]],
    '1093'  => [['5.7.1',   '554', 'spamdetected',    0]],
    '1094'  => [['5.7.1',   '550', 'policyviolation', 0]],
    '1095'  => [['5.0.0',   '554', 'spamdetected',    0]],
    '1096'  => [['5.0.0',   '554', 'spamdetected',    0]],
    '1097'  => [['5.7.3',   '553', 'spamdetected',    0]],
    '1098'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1099'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1100'  => [['5.0.0',   '554', 'spamdetected',    0]],
    '1101'  => [['5.0.0',   '554', 'virusdetected',   0]],
    '1102'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1103'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1104'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1105'  => [['5.0.0',   '551', 'spamdetected',    0]],
    '1106'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1107'  => [['5.7.1',   '554', 'spamdetected',    0]],
    '1108'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1109'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1110'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1111'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1112'  => [['5.0.0',   '554', 'spamdetected',    0]],
    '1113'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1114'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1115'  => [['5.0.0',   '554', 'blocked',         0]],
    '1116'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1117'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1118'  => [['5.0.0',   '554', 'spamdetected',    0]],
    '1119'  => [['5.0.0',   '553', 'spamdetected',    0]],
    '1120'  => [['5.7.1',   '550', 'spamdetected',    0]],
    '1121'  => [['5.3.0',   '554', 'spamdetected',    0]],
    '1122'  => [['5.4.4',   '',    'hostunknown',     1]],
    '1123'  => [['5.7.1',   '554', 'userunknown',     1]],
    '1124'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1125'  => [['5.2.3',   '',    'mailboxfull',     0]],
    '1126'  => [['5.0.0',   '',    'systemerror',     0]],
    '1127'  => [['5.7.17',  '550', 'userunknown',     1]],
    '1128'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1129'  => [['5.0.0',   '554', 'filtered',        0]],
    '1130'  => [['5.0.0',   '552', 'mailboxfull',     0]],
    '1131'  => [['5.2.3',   '',    'mailboxfull',     0]],
    '1132'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1133'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1134'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1135'  => [['5.2.1',   '550', 'suspend',         0]],
    '1136'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1137'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1138'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1139'  => [['5.1.3',   '501', 'userunknown',     1]],
    '1140'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1141'  => [['5.0.0',   '',    'filtered',        0]],
    '1142'  => [['5.0.0',   '550', 'blocked',         0]],
    '1143'  => [['5.3.0',   '553', 'userunknown',     1]],
    '1144'  => [['5.0.0',   '554', 'suspend',         0]],
    '1145'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1146'  => [['5.1.3',   '',    'userunknown',     1]],
    '1147'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1148'  => [['5.2.1',   '550', 'userunknown',     1]],
    '1149'  => [['5.2.2',   '550', 'mailboxfull',     0]],
    '1150'  => [['5.0.910', '',    'filtered',        0]],
    '1151'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1152'  => [['5.3.0',   '553', 'blocked',         0]],
    '1153'  => [['5.7.1',   '550', 'badreputation',   0]],
    '1154'  => [['4.7.0',   '421', 'blocked',         0]],
    '1155'  => [['5.1.0',   '550', 'userunknown',     1]],
    '1156'  => [['5.1.0',   '550', 'userunknown',     1]],
    '1157'  => [['4.0.0',   '',    'blocked',         0]],
    '1158'  => [['5.6.0',   '554', 'spamdetected',    0]],
    '1159'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1160'  => [['4.0.0',   '451', 'systemerror',     0]],
    '1161'  => [['5.0.0',   '',    'mailboxfull',     0]],
    '1162'  => [['5.0.0',   '550', 'policyviolation', 0]],
    '1163'  => [['5.0.0',   '550', 'policyviolation', 0]],
    '1164'  => [['5.0.0',   '550', 'blocked',         0]],
    '1165'  => [['5.5.0',   '550', 'userunknown',     1]],
    '1166'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1167'  => [['4.0.0',   '',    'blocked',         0]],
    '1168'  => [['5.0.0',   '',    'rejected',        0]],
    '1169'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1170'  => [['5.0.0',   '550', 'requireptr',      0]],
    '1171'  => [['5.2.0',   '',    'mailboxfull',     0]],
    '1172'  => [['4.3.0',   '',    'mailererror',     0]],
    '1173'  => [['4.4.2',   '',    'networkerror',    0]],
    '1174'  => [['4.3.2',   '451', 'notaccept',       0]],
    '1175'  => [['5.7.9',   '554', 'policyviolation', 0]],
    '1176'  => [['5.7.1',   '554', 'userunknown',     1]],
    '1177'  => [['5.7.1',   '550', 'userunknown',     1]],
    '1178'  => [['5.7.1',   '550', 'blocked',         0]],
    '1179'  => [['5.7.1',   '501', 'norelaying',      0]],
    '1180'  => [['5.4.1',   '550', 'userunknown',     1]],
    '1181'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1182'  => [['5.7.0',   '550', 'spamdetected',    0]],
    '1183'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1184'  => [['5.7.1',   '550', 'norelaying',      0]],
    '1185'  => [['4.0.0',   '451', 'systemerror',     0]],
    '1186'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1187'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1188'  => [['4.4.1',   '',    'expired',         0]],
    '1189'  => [['5.4.4',   '',    'hostunknown',     1]],
    '1190'  => [['5.1.1',   '',    'userunknown',     1]],
    '1191'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1192'  => [['5.1.1',   '550', 'speeding',        0]],
    '1193'  => [['5.0.0',   '550', 'filtered',        0]],
    '1194'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1195'  => [['4.4.1',   '',    'expired',         0]],
    '1196'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1197'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1198'  => [['5.0.0',   '554', 'systemerror',     0]],
    '1199'  => [['5.0.0',   '552', 'toomanyconn',     0]],
    '1200'  => [['4.0.0',   '421', 'blocked',         0]],
    '1201'  => [['4.0.0',   '421', 'blocked',         0]],
    '1202'  => [['5.7.0',   '550', 'policyviolation', 0]],
    '1203'  => [['5.0.0',   '554', 'suspend',         0]],
    '1204'  => [['5.0.0',   '504', 'syntaxerror',     0]],
    '1205'  => [['5.7.1',   '550', 'rejected',        0]],
    '1206'  => [['5.0.0',   '552', 'toomanyconn',     0]],
    '1207'  => [['5.0.0',   '550', 'toomanyconn',     0]],
    '1208'  => [['5.0.0',   '550', 'toomanyconn',     0]],
    '1209'  => [['4.4.2',   '',    'networkerror',    0]],
    '1210'  => [['5.0.0',   '550', 'authfailure',     0]],
    '1211'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1212'  => [['5.2.1',   '550', 'userunknown',     1]],
    '1213'  => [['5.1.1',   '550', 'userunknown',     1]],
    '1214'  => [['5.2.1',   '550', 'speeding',        0]],
    '1215'  => [['5.2.1',   '550', 'speeding',        0]],
    '1216'  => [['4.0.0',   '',    'requireptr',      0]],
    '1217'  => [['4.0.0',   '',    'requireptr',      0]],
    '1218'  => [['4.0.0',   '',    'requireptr',      0]],
    '1219'  => [['5.0.0',   '550', 'suspend',         0]],
    '1220'  => [['5.0.0',   '550', 'virusdetected',   0]],
    '1221'  => [['5.1.1',   '',    'userunknown',     1]],
    '1222'  => [['5.2.2',   '552', 'mailboxfull',     0]],
    '1223'  => [['5.7.9',   '554', 'policyviolation', 0]],
    '1224'  => [['5.7.9',   '554', 'policyviolation', 0]],
    '1225'  => [['5.0.0',   '554', 'policyviolation', 0]],
    '1226'  => [['5.7.9',   '554', 'policyviolation', 0]],
    '1227'  => [['5.7.26',  '550', 'authfailure',     0]],
    '1228'  => [['5.7.1',   '554', 'authfailure',     0]],
    '1229'  => [['5.7.1',   '550', 'authfailure',     0]],
    '1230'  => [['5.7.1',   '550', 'authfailure',     0]],
    '1231'  => [['5.7.9',   '550', 'policyviolation', 0],
                ['5.7.1',   '550', 'authfailure',     0],
                ['5.7.1',   '550', 'authfailure',     0]],
    '1232'  => [['4.7.0',   '421', 'rejected',        0]],
    '1233'  => [['5.0.0',   '550', 'blocked',         0]],
    '1234'  => [['5.0.0',   '553', 'rejected',        0]],
    '1235'  => [['5.0.0',   '554', 'spamdetected',    0]],
    '1236'  => [['5.0.0',   '550', 'badreputation',   0]],
    '1237'  => [['5.0.0',   '550', 'norelaying',      0]],
    '1238'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1239'  => [['5.0.0',   '550', 'blocked',         0]],
    '1240'  => [['5.0.0',   '550', 'rejected',        0]],
    '1241'  => [['5.0.0',   '550', 'rejected',        0]],
    '1242'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1243'  => [['5.0.0',   '554', 'badreputation',   0]],
    '1244'  => [['5.8.5',   '550', 'policyviolation', 0]],
    '1245'  => [['5.0.0',   '554', 'blocked',         0]],
    '1246'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1247'  => [['5.0.0',   '550', 'norelaying',      0]],
    '1248'  => [['5.0.0',   '550', 'blocked',         0]],
    '1249'  => [['5.0.0',   '550', 'blocked',         0]],
    '1250'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1251'  => [['5.0.0',   '550', 'spamdetected',    0]],
    '1252'  => [['5.0.0',   '',    'onhold',          0]],
    '1253'  => [['5.0.0',   '554', 'spamdetected',    0]],
    '1254'  => [['5.0.0',   '554', 'policyviolation', 0]],
    '1255'  => [['5.4.6',   '554', 'systemerror',     0]],
    '1256'  => [['5.5.1',   '554', 'blocked',         0]],
    '1257'  => [['5.0.0',   '550', 'notaccept',       1]],
    '1258'  => [['5.0.0',   '550', 'rejected',        0]],
    '1259'  => [['5.0.0',   '',    'onhold',          0]],
    '1260'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1261'  => [['5.0.0',   '550', 'norelaying',      0]],
    '1262'  => [['5.0.0',   '550', 'norelaying',      0]],
    '1263'  => [['5.0.0',   '550', 'filtered',        0]],
    '1264'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1265'  => [['5.0.0',   '554', 'rejected',        0]],
    '1266'  => [['5.0.0',   '550', 'suspend',         0]],
    '1267'  => [['5.0.0',   '550', 'onhold',          0]], # spamdetected
    '1268'  => [['5.0.0',   '550', 'suspend',         0]],
    '1269'  => [['5.0.0',   '550', 'virusdetected',   0]],
    '1270'  => [['5.0.0',   '554', 'norelaying',      0]],
    '1271'  => [['5.0.0',   '554', 'notcompliantrfc', 0]],
    '1272'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1273'  => [['5.0.0',   '550', 'userunknown',     1]],
    '1274'  => [['5.0.939', '',    'mailererror',     0]],
    '1275'  => [['5.4.14',  '554', 'networkerror',    0],
                ['5.4.14',  '554', 'networkerror',    0]],
    '1276'  => [['5.7.26',  '550', 'authfailure',     0]],
    '1277'  => [['5.7.26',  '550', 'authfailure',     0]],
    '1278'  => [['5.7.25',  '550', 'requireptr',      0]],
    '1279'  => [['5.2.2',   '552', 'mailboxfull',     0]],
    '1280'  => [['5.7.1',   '550', 'notcompliantrfc', 0]],
};

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

