#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

# Copyright © 2017
#       Dominik George <nik@naturalnet.de>
#
# Provided that these terms and disclaimer and all copyright notices
# are retained or reproduced in an accompanying document, permission
# is granted to deal in this work without restriction, including un‐
# limited rights to use, publicly perform, distribute, sell, modify,
# merge, give away, or sublicence.
#
# This work is provided “AS IS” and WITHOUT WARRANTY of any kind, to
# the utmost extent permitted by applicable law, neither express nor
# implied; without malicious intent or gross negligence. In no event
# may a licensor, author or contributor be held liable for indirect,
# direct, other damage, loss, or other issues arising in any way out
# of dealing in the work, even if advised of the possibility of such
# damage or existence of a defect, except proven that it results out
# of said person’s immediate fault when using the work as intended.

import os
import unittest

from mmllib.parser import mml_file, mml_file_meta

class ParserTests(unittest.TestCase):
    def setUp(self):
        self.datadir = os.path.join(os.path.dirname(__file__), "data")
        self.examplesdir = os.path.abspath(os.path.join(self.datadir, "..", "..", "examples"))

    def test_mml_file_meta(self):
        mmlfile = os.path.join(self.examplesdir, "loreley.mml")
        res_meta = mml_file_meta(mmlfile)
        expected_meta = {'arranger': u'Klavier: August Linder; MML: mirabilos',
                         'composer': u'Ph. Friedrich Silcher (1789\u20131860), 1837',
                         'copyright': u'MML encoding & arrangement \xa9 2016 mirabilos, published under The MirOS Licence; copyright for text, music, and piano arrangement has expired',
                         'duration': 37.89473684210526,
                         'encoder': u'mirabilos, 2016',
                         'instruments': u'Piano, Voice',
                         'key signature': u'C Major',
                         'language': u'German',
                         'lyrics': u'Heinrich Heine (1797\u20131856), 1824',
                         'measures': u'16',
                         'mml tracks': u'4 (5)',
                         'pickup measure': u'1/8',
                         'source': u'Linder, August (Hrsg.): Deutsche Weisen : Die beliebtesten Volks- und geistlichen Lieder. Stuttgart: Albert Auer\u2019s Musikverlag, n.d., c. 1900.',
                         'tempo': u'Andante',
                         'time signature': u'6/8',
                         'title': u'Loreley',
                         'verses': u'3',
                         'voices': 4}
        self.assertDictEqual(res_meta, expected_meta)

    def test_mml_file(self):
        mmlfile = os.path.join(self.examplesdir, "loreley.mml")
        res = mml_file(mmlfile)
        expected = [[(391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (391.99543598174927, 0.5921052631578948),
                     (440.0, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (523.2511306011972, 0.39473684210526316),
                     (493.8833012561241, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (440.0, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (391.99543598174927, 1.036184210526316),
                     (0, 0.14802631578947367),
                     (349.2282314330039, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 0.518092105263158),
                     (0, 0.07401315789473684),
                     (329.6275569128699, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (329.6275569128699, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (293.6647679174076, 0.39473684210526316),
                     (261.6255653005986, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 1.529605263157895),
                     (0, 0.4440789473684211),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (391.99543598174927, 0.5921052631578948),
                     (440.0, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (523.2511306011972, 0.39473684210526316),
                     (493.8833012561241, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (440.0, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (391.99543598174927, 1.036184210526316),
                     (0, 0.14802631578947367),
                     (349.2282314330039, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 0.518092105263158),
                     (0, 0.07401315789473684),
                     (329.6275569128699, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (329.6275569128699, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (261.6255653005986, 1.529605263157895),
                     (0, 0.4440789473684211),
                     (329.6275569128699, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (293.6647679174076, 0.5921052631578948),
                     (329.6275569128699, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (493.8833012561241, 1.036184210526316),
                     (0, 0.14802631578947367),
                     (440.0, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (440.0, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (391.99543598174927, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (369.9944227116344, 0.39473684210526316),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (440.0, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (391.99543598174927, 1.875),
                     (0, 0.09868421052631582),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (391.99543598174927, 0.518092105263158),
                     (0, 0.07401315789473684),
                     (440.0, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (523.2511306011972, 0.39473684210526316),
                     (493.8833012561241, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (440.0, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (391.99543598174927, 0.7894736842105263),
                     (659.2551138257398, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (587.3295358348151, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (587.3295358348151, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (523.2511306011972, 0.518092105263158),
                     (0, 0.07401315789473684),
                     (523.2511306011972, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (523.2511306011972, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (493.8833012561241, 0.39473684210526316),
                     (440.0, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (493.8833012561241, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (523.2511306011972, 1.529605263157895),
                     (0, 0.4440789473684211),
                     1],
                    [(0, 0.39473684210526316),
                     1,
                     (329.6275569128699, 0.5921052631578948),
                     (349.2282314330039, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (329.6275569128699, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.7401315789473684),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 1.036184210526316),
                     (0, 0.14802631578947367),
                     (293.6647679174076, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (261.6255653005986, 0.518092105263158),
                     (0, 0.07401315789473684),
                     (261.6255653005986, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (261.6255653005986, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (246.94165062806206, 0.39473684210526316),
                     (220.0, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (261.6255653005986, 1.529605263157895),
                     (0, 0.8388157894736843),
                     1,
                     (329.6275569128699, 0.5921052631578948),
                     (349.2282314330039, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (329.6275569128699, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.7401315789473684),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 1.036184210526316),
                     (0, 0.14802631578947367),
                     (293.6647679174076, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (261.6255653005986, 0.518092105263158),
                     (0, 0.07401315789473684),
                     (261.6255653005986, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (261.6255653005986, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (0, 2.368421052631579),
                     1,
                     (246.94165062806206, 0.5921052631578948),
                     (261.6255653005986, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (293.6647679174076, 1.036184210526316),
                     (0, 0.14802631578947367),
                     (261.6255653005986, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (261.6255653005986, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (246.94165062806206, 0.6907894736842105),
                     (0, 0.493421052631579),
                     (220.0, 0.39473684210526316),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (261.6255653005986, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (97.99885899543733, 0.39473684210526316),
                     (123.47082531403103, 0.39473684210526316),
                     (130.8127826502993, 0.39473684210526316),
                     (146.8323839587038, 0.39473684210526316),
                     (130.8127826502993, 0.39473684210526316),
                     (123.47082531403103, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 0.518092105263158),
                     (0, 0.07401315789473684),
                     (349.2282314330039, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (329.6275569128699, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.7401315789473684),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 0.7894736842105263),
                     (391.99543598174927, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 0.518092105263158),
                     (0, 0.07401315789473684),
                     (329.6275569128699, 0.17269736842105263),
                     (0, 0.024671052631578955),
                     (329.6275569128699, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.7401315789473684),
                     (0, 0.04934210526315791),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (329.6275569128699, 1.529605263157895),
                     (0, 0.4440789473684211),
                     1],
                    [(0, 0.39473684210526316),
                     1,
                     (0, 2.368421052631579),
                     1,
                     (0, 2.368421052631579),
                     1,
                     (0, 1.1842105263157896),
                     (195.99771799087463, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (195.99771799087463, 0.39473684210526316),
                     (0, 1.973684210526316),
                     1,
                     (0, 2.368421052631579),
                     1,
                     (0, 2.368421052631579),
                     1,
                     (0, 1.1842105263157894),
                     (146.8323839587038, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (146.8323839587038, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (174.61411571650194, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (164.81377845643496, 0.39473684210526316),
                     (0, 1.973684210526316),
                     1,
                     (0, 1.1842105263157894),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.8388157894736843),
                     1,
                     (391.99543598174927, 1.036184210526316),
                     (0, 0.14802631578947367),
                     (329.6275569128699, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (329.6275569128699, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (293.6647679174076, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (146.8323839587038, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (146.8323839587038, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (146.8323839587038, 1.875),
                     (0, 0.09868421052631582),
                     (349.2282314330039, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (0, 2.368421052631579),
                     1,
                     (0, 2.368421052631579),
                     1,
                     (0, 1.1842105263157894),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (195.99771799087463, 0.39473684210526316),
                     (0, 1.5789473684210527),
                     1],
                    [(0, 0.39473684210526316),
                     1,
                     (130.8127826502993, 0.19736842105263158),
                     (195.99771799087463, 0.19736842105263158),
                     (261.6255653005986, 0.39473684210526316),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (130.8127826502993, 0.19736842105263158),
                     (220.0, 0.19736842105263158),
                     (293.6647679174076, 0.39473684210526316),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (130.8127826502993, 0.19736842105263158),
                     (195.99771799087463, 0.19736842105263158),
                     (261.6255653005986, 0.39473684210526316),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (87.30705785825097, 0.19736842105263158),
                     (174.61411571650194, 0.19736842105263158),
                     (220.0, 0.39473684210526316),
                     (174.61411571650194, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (97.99885899543733, 0.19736842105263158),
                     (164.81377845643496, 0.19736842105263158),
                     (195.99771799087463, 0.39473684210526316),
                     (164.81377845643496, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (97.99885899543733, 0.6907894736842105),
                     (0, 0.09868421052631582),
                     (97.99885899543733, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (130.8127826502993, 0.39473684210526316),
                     (97.99885899543733, 0.39473684210526316),
                     (82.4068892282175, 0.39473684210526316),
                     (65.40639132514966, 0.6907894736842105),
                     (0, 0.493421052631579),
                     1,
                     (130.8127826502993, 0.19736842105263158),
                     (195.99771799087463, 0.19736842105263158),
                     (261.6255653005986, 0.39473684210526316),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (130.8127826502993, 0.19736842105263158),
                     (220.0, 0.19736842105263158),
                     (293.6647679174076, 0.39473684210526316),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (130.8127826502993, 0.19736842105263158),
                     (195.99771799087463, 0.19736842105263158),
                     (261.6255653005986, 0.39473684210526316),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (87.30705785825097, 0.19736842105263158),
                     (174.61411571650194, 0.19736842105263158),
                     (220.0, 0.39473684210526316),
                     (174.61411571650194, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (97.99885899543733, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (130.8127826502993, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (97.99885899543733, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (97.99885899543733, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (97.99885899543733, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (130.8127826502993, 0.39473684210526316),
                     (82.4068892282175, 0.39473684210526316),
                     (97.99885899543733, 0.39473684210526316),
                     (65.40639132514966, 0.6907894736842105),
                     (0, 0.493421052631579),
                     1,
                     (97.99885899543733, 0.39473684210526316),
                     (146.8323839587038, 0.39473684210526316),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (97.99885899543733, 0.39473684210526316),
                     (146.8323839587038, 0.39473684210526316),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (97.99885899543733, 0.39473684210526316),
                     (146.8323839587038, 0.39473684210526316),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (65.40639132514966, 0.39473684210526316),
                     (164.81377845643496, 0.39473684210526316),
                     (220.0, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (73.41619197935188, 0.39473684210526316),
                     (146.8323839587038, 0.39473684210526316),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.8388157894736843),
                     (184.9972113558172, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (246.94165062806206, 0.39473684210526316),
                     (293.6647679174076, 0.39473684210526316),
                     (329.6275569128699, 0.39473684210526316),
                     (349.2282314330039, 0.39473684210526316),
                     (329.6275569128699, 0.39473684210526316),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (130.8127826502993, 0.19736842105263158),
                     (195.99771799087463, 0.19736842105263158),
                     (261.6255653005986, 0.39473684210526316),
                     (195.99771799087463, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (130.8127826502993, 0.19736842105263158),
                     (220.0, 0.19736842105263158),
                     (293.6647679174076, 0.39473684210526316),
                     (246.94165062806206, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (130.8127826502993, 0.19736842105263158),
                     (195.99771799087463, 0.19736842105263158),
                     (261.6255653005986, 0.17269736842105263),
                     (0, 0.6167763157894737),
                     (87.30705785825097, 0.19736842105263158),
                     (220.0, 0.19736842105263158),
                     (293.6647679174076, 0.17269736842105263),
                     (0, 0.6167763157894737),
                     1,
                     (97.99885899543733, 0.19736842105263158),
                     (195.99771799087463, 0.19736842105263158),
                     (261.6255653005986, 0.17269736842105263),
                     (0, 0.6167763157894737),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (261.6255653005986, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     (293.6647679174076, 0.34539473684210525),
                     (0, 0.04934210526315791),
                     1,
                     (130.8127826502993, 0.39473684210526316),
                     (164.81377845643496, 0.39473684210526316),
                     (195.99771799087463, 0.39473684210526316),
                     (130.8127826502993, 0.34539473684210525),
                     (0, 0.4440789473684211),
                     1]]
        self.assertListEqual(res, expected)

if __name__ == "__main__":
    unittest.main()
