<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/ebpf.plugin/integrations/ebpf_filesystem.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/ebpf.plugin/metadata.yaml"
sidebar_label: "eBPF Filesystem"
learn_status: "Published"
learn_rel_path: "Data Collection/eBPF"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# eBPF Filesystem


<img src="https://netdata.cloud/img/ebpf.jpg" width="150"/>


Plugin: ebpf.plugin
Module: filesystem

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor latency for main actions on filesystem like I/O events.

Attach tracing (kprobe, trampoline) to internal kernel functions according options used to compile kernel.

This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

The plugin needs setuid because it loads data inside kernel. Netada sets necessary permission during installation time.

### Default Behavior

#### Auto-Detection

The plugin checks kernel compilation flags (CONFIG_KPROBES, CONFIG_BPF, CONFIG_BPF_SYSCALL, CONFIG_BPF_JIT), files inside debugfs, and presence of BTF files to decide which eBPF program will be attached.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per filesystem

Latency charts associate with filesystem actions.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| filesystem.read_latency | latency period | calls/s |
| filesystem.open_latency | latency period | calls/s |
| filesystem.sync_latency | latency period | calls/s |

### Per iilesystem



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| filesystem.write_latency | latency period | calls/s |

### Per eBPF Filesystem instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| filesystem.attributte_latency | latency period | calls/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Compile kernel

Check if your kernel was compiled with necessary options (CONFIG_KPROBES, CONFIG_BPF, CONFIG_BPF_SYSCALL, CONFIG_BPF_JIT) in `/proc/config.gz` or inside /boot/config file. Some cited names can be different accoring preferences of Linux distributions.
When you do not have options set, it is necessary to get the kernel source code from https://kernel.org or a kernel package from your distribution, this last is preferred. The kernel compilation has a well definedd pattern, but distributions can deliver their configuration files
with different names.

Now follow steps:
1. Copy the configuration file to /usr/src/linux/.config.
2. Select the necessary options: make oldconfig
3. Compile your kernel image: make bzImage
4. Compile your modules: make modules
5. Copy your new kernel image for boot loader directory
6. Install the new modules: make modules_install
7. Generate an initial ramdisk image (`initrd`) if it is necessary.
8. Update your boot loader



### Configuration

#### File

The configuration file name for this integration is `ebpf.d/filesystem.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config ebpf.d/filesystem.conf
```
#### Options

This configuration file have two different sections. The `[global]` overwrites default options, while `[filesystem]` allow user to select the filesystems to monitor.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update every | Data collection frequency. | 5 | False |
| ebpf load mode | Define whether plugin will monitor the call (`entry`) for the functions or it will also monitor the return (`return`). | entry | False |
| lifetime | Set default lifetime for thread when enabled by cloud. | 300 | False |
| btrfsdist | Enable or disable latency monitoring for functions associated with btrfs filesystem. | yes | False |
| ext4dist | Enable or disable latency monitoring for functions associated with ext4 filesystem. | yes | False |
| nfsdist | Enable or disable latency monitoring for functions associated with nfs filesystem. | yes | False |
| xfsdist | Enable or disable latency monitoring for functions associated with xfs filesystem. | yes | False |
| zfsdist | Enable or disable latency monitoring for functions associated with zfs filesystem. | yes | False |

</details>

#### Examples
There are no configuration examples.


