// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomAPI_ExtremaCurveSurface_HeaderFile
#define _GeomAPI_ExtremaCurveSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Extrema_ExtCS_HeaderFile
#include <Extrema_ExtCS.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class Geom_Curve;
class Geom_Surface;
class gp_Pnt;
class Extrema_ExtCS;


//! Describes functions for computing all the extrema <br>
//! between a curve and a surface. <br>
//! An ExtremaCurveSurface algorithm minimizes or <br>
//! maximizes the distance between a point on the curve <br>
//! and a point on the surface. Thus, it computes start <br>
//! and end points of perpendiculars common to the <br>
//! curve and the surface (an intersection point is not an <br>
//! extremum except where the curve and the surface <br>
//! are tangential at this point). <br>
//! Solutions consist of pairs of points, and an extremum <br>
//! is considered to be a segment joining the two points of a solution. <br>
//! An ExtremaCurveSurface object provides a framework for: <br>
//! -   defining the construction of the extrema, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the results. <br>
//! Warning <br>
//! In some cases, the nearest points between a curve <br>
//! and a surface do not correspond to one of the <br>
//! computed extrema. Instead, they may be given by: <br>
//! -   a point of a bounding curve of the surface and one of the following: <br>
//!   -   its orthogonal projection on the curve, <br>
//!   -   a limit point of the curve; or <br>
//! -   a limit point of the curve and its projection on the surface; or <br>
//! -   an intersection point between the curve and the surface. <br>
class GeomAPI_ExtremaCurveSurface  {
public:

  DEFINE_STANDARD_ALLOC

  //! Constructs an empty algorithm for computing <br>
//! extrema between a curve and a surface. Use an <br>
//! Init function to define the curve and the surface on <br>
//! which it is going to work. <br>
  Standard_EXPORT   GeomAPI_ExtremaCurveSurface();
  //! Computes  the  extrema  distances  between  the <br>
//!          curve <C> and the surface  <S>. <br>
  Standard_EXPORT   GeomAPI_ExtremaCurveSurface(const Handle(Geom_Curve)& Curve,const Handle(Geom_Surface)& Surface);
  //! Computes  the  extrema  distances  between  the <br>
//!          curve <C>  and the  surface  <S>.  The solution <br>
//!          point are computed in the domain [Wmin,Wmax] of <br>
//!          the  curve   and  in  the  domain   [Umin,Umax] <br>
//!          [Vmin,Vmax] of the surface. <br>
//!	Warning <br>
//! Use the function NbExtrema to obtain the number <br>
//! of solutions. If this algorithm fails, NbExtrema returns 0. <br>
  Standard_EXPORT   GeomAPI_ExtremaCurveSurface(const Handle(Geom_Curve)& Curve,const Handle(Geom_Surface)& Surface,const Quantity_Parameter Wmin,const Quantity_Parameter Wmax,const Quantity_Parameter Umin,const Quantity_Parameter Umax,const Quantity_Parameter Vmin,const Quantity_Parameter Vmax);
  //! Computes  the  extrema  distances  between  the <br>
//!          curve <C> and the surface  <S>. <br>
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& Curve,const Handle(Geom_Surface)& Surface) ;
  //! Computes  the  extrema  distances  between  the <br>
//!          curve <C>  and the  surface  <S>.  The solution <br>
//!          point are computed in the domain [Wmin,Wmax] of <br>
//!          the  curve   and  in  the  domain   [Umin,Umax] <br>
//!          [Vmin,Vmax] of the surface. <br>
//! Warning <br>
//! Use the function NbExtrema to obtain the number <br>
//! of solutions. If this algorithm fails, NbExtrema returns 0. <br>
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& Curve,const Handle(Geom_Surface)& Surface,const Quantity_Parameter Wmin,const Quantity_Parameter Wmax,const Quantity_Parameter Umin,const Quantity_Parameter Umax,const Quantity_Parameter Vmin,const Quantity_Parameter Vmax) ;
  //! Returns the number of extrema computed by this algorithm. <br>
//! Note: if this algorithm fails, NbExtrema returns 0. <br>
  Standard_EXPORT     Standard_Integer NbExtrema() const;
Standard_EXPORT operator Standard_Integer() const;
  //! Returns the points P1 on the curve and P2 on the <br>
//! surface, which are the ends of the extremum of index <br>
//! Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
  Standard_EXPORT     void Points(const Standard_Integer Index,gp_Pnt& P1,gp_Pnt& P2) const;
  //! Returns the parameters W of the point on the curve, <br>
//! and (U,V) of the point on the surface, which are the <br>
//! ends of the extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
  Standard_EXPORT     void Parameters(const Standard_Integer Index,Quantity_Parameter& W,Quantity_Parameter& U,Quantity_Parameter& V) const;
  //! Computes the distance between the end points of the <br>
//! extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
  Standard_EXPORT     Quantity_Length Distance(const Standard_Integer Index) const;
  //! Returns the points PC on the curve and PS on the <br>
//! surface, which are the ends of the shortest extremum computed by this algorithm. <br>
//! Exceptions - StdFail_NotDone if this algorithm fails. <br>
  Standard_EXPORT     void NearestPoints(gp_Pnt& PC,gp_Pnt& PS) const;
  //! Returns the parameters W of the point on the curve <br>
//! and (U,V) of the point on the surface, which are the <br>
//! ends of the shortest extremum computed by this algorithm. <br>
//! Exceptions - StdFail_NotDone if this algorithm fails. <br>
  Standard_EXPORT     void LowerDistanceParameters(Quantity_Parameter& W,Quantity_Parameter& U,Quantity_Parameter& V) const;
  //! Computes the distance between the end points of the <br>
//! shortest extremum computed by this algorithm. <br>
//! Exceptions - StdFail_NotDone if this algorithm fails. <br>
  Standard_EXPORT     Quantity_Length LowerDistance() const;
Standard_EXPORT operator Standard_Real() const;
  //! Returns the algorithmic object from Extrema <br>
       const Extrema_ExtCS& Extrema() const;





protected:





private:



Standard_Boolean myIsDone;
Standard_Integer myIndex;
Extrema_ExtCS myExtCS;


};


#include <GeomAPI_ExtremaCurveSurface.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
