/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_BootConcreteDependency.h"
#include "OpenDRIM_BootConcreteDependencyAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define Boot_OpenDRIM_BootConcreteDependencyProviderSetInstance Boot_OpenDRIM_BootConcreteDependencyProviderModifyInstance
#endif

int Boot_OpenDRIM_BootConcreteDependency_init(const CMPIBroker* broker);

int Boot_OpenDRIM_BootConcreteDependency_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_BootConcreteDependency> instances;
	string errorMessage;
	
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = Boot_OpenDRIM_BootConcreteDependency_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_BootConcreteDependency> instances;
	string errorMessage;
	
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = Boot_OpenDRIM_BootConcreteDependency_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BootConcreteDependency instance;
	Boot_OpenDRIM_BootConcreteDependency_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = Boot_OpenDRIM_BootConcreteDependency_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BootConcreteDependency newInstance, oldInstance;
	Boot_OpenDRIM_BootConcreteDependency_toCPP(_broker, ci, newInstance);
	Boot_OpenDRIM_BootConcreteDependency_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Boot_OpenDRIM_BootConcreteDependency_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BootConcreteDependency instance;
	Boot_OpenDRIM_BootConcreteDependency_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Boot_OpenDRIM_BootConcreteDependency_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Boot_OpenDRIM_BootConcreteDependency_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = Boot_OpenDRIM_BootConcreteDependency_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_BootConcreteDependency instance;
	Boot_OpenDRIM_BootConcreteDependency_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Boot_OpenDRIM_BootConcreteDependency_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                     Association Provider Interface                         */
/* ---------------------------------------------------------------------------*/

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderAssociationCleanup(CMPIAssociationMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderAssociatorNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnObjectPath(rslt, associatedInstances[i].getObjectpath().getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderAssociators(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, properties, associatedInstances, leftToRight, errorMessage, "a");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnInstance(rslt, associatedInstances[i].getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderReferenceNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_BootConcreteDependency> associationInstances;
	if (leftToRight)
		errorCode = Boot_OpenDRIM_BootConcreteDependency_referenceAntecedentToDependent(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	else
		errorCode = Boot_OpenDRIM_BootConcreteDependency_referenceDependentToAntecedent(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIObjectPath* op = Boot_OpenDRIM_BootConcreteDependency_toCMPIObjectPath(_broker, associationInstances[i]);
		CMReturnObjectPath(rslt, op);
	}
	_L_;
	return rc;
}

CMPIStatus Boot_OpenDRIM_BootConcreteDependencyProviderReferences(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = Boot_OpenDRIM_BootConcreteDependency_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_BootConcreteDependency> associationInstances;
	if (leftToRight)
		errorCode = Boot_OpenDRIM_BootConcreteDependency_referenceAntecedentToDependent(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	else
		errorCode = Boot_OpenDRIM_BootConcreteDependency_referenceDependentToAntecedent(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIInstance* inst = Boot_OpenDRIM_BootConcreteDependency_toCMPIInstance(_broker, associationInstances[i]);
		CMReturnInstance(rslt, inst);
	}
	_L_;
	return rc;
}

/* ---------------------------------------------------------------------------*/
/*                  End Of Association Provider Interface                     */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int Boot_OpenDRIM_BootConcreteDependency_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = Boot_OpenDRIM_BootConcreteDependency_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "Boot_OpenDRIM_BootConcreteDependency_init FAILED: " + (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootConcreteDependency_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = Boot_OpenDRIM_BootConcreteDependency_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "Boot_OpenDRIM_BootConcreteDependency_unload FAILED: " + (string) OpenDRIM_BootConcreteDependency_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define Boot_OpenDRIM_BootConcreteDependency_INIT if (Boot_OpenDRIM_BootConcreteDependency_init(_broker) < 0) return NULL

CMInstanceMIStub(Boot_OpenDRIM_BootConcreteDependencyProvider, Boot_OpenDRIM_BootConcreteDependencyProvider, _broker, Boot_OpenDRIM_BootConcreteDependency_INIT);
CMAssociationMIStub(Boot_OpenDRIM_BootConcreteDependencyProvider, Boot_OpenDRIM_BootConcreteDependencyProvider, _broker, Boot_OpenDRIM_BootConcreteDependency_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
