/*
 *  Copyright (c) 2011 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_COLOR_CONVERTERS_H_
#define _GTLCORE_COLOR_CONVERTERS_H_

#include <GTLCore/Export.h>

namespace {
  class StaticPointerColorConverters;
}

namespace GTLCore {
  class PixelDescription;
  class Type;

  class AbstractColorConverter;
  class GTLCORE_EXPORT ColorConverters {
    friend class ::StaticPointerColorConverters;
    ColorConverters();
    ~ColorConverters();
  public:
    
    static const ColorConverters* instance();
    
    /**
     * Try to guess what type color converter to use. Only works if all the channels have the same type.
     * Otherwise return 0.
     */
    const AbstractColorConverter* guess(const GTLCore::PixelDescription& _pixelDescription) const;
    /**
     * If _channels == 1 assumes Gray
     * If _channels == 2 assumes Gray + Alpha
     * If _channels == 3 assumes Rgb
     * If _channels == 4 assumes Rgb + Alpha
     */
    const AbstractColorConverter* guess(const GTLCore::Type* _type, int _channels) const;
    
    const AbstractColorConverter* sGrayaU8() const;
    const AbstractColorConverter* sGrayU8() const;
    const AbstractColorConverter* sGrayaU16() const;
    const AbstractColorConverter* sGrayU16() const;
    const AbstractColorConverter* sGrayaF32() const;
    const AbstractColorConverter* sGrayF32() const;
    const AbstractColorConverter* sRgbaU8() const;
    const AbstractColorConverter* sRgbU8() const;
    const AbstractColorConverter* sRgbaU16() const;
    const AbstractColorConverter* sRgbU16() const;
    const AbstractColorConverter* sRgbaF32() const;
    const AbstractColorConverter* sRgbF32() const;
  private:
    struct Private;
    Private* const d;
  };
}

#endif
