/*=========================================================================

  Program:   OpenIGTLLink Library -- Dummy status data
  Module:    $RCSfile: $
  Language:  C
  Date:      $Date: $
  Version:   $Revision: $

  Copyright (c) Insight Software Consortium. All rights reserved.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __IGTL_TEST_DATA_BIND_H
#define __IGTL_TEST_DATA_BIND_H

char test_bind_message_header[] = {
  0x00, 0x01,                                     /* Version number */
  0x42, 0x49, 0x4e, 0x44, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* BIND */ 
  0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
  0x6d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Device name */
  0x00, 0x00, 0x00, 0x00, 0x49, 0x96, 0x02, 0xd2, /* Time stamp */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd8, /* Body size */
  0xd3, 0x4d, 0x56, 0xba, 0x63, 0xaf, 0x8a, 0x6a, /* CRC */
};

char test_bind_message_bind_header[] = {          /* 98 bytes */

  0x00, 0x03,                                     /* Number of child messages */

  0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52,
  0x4d, 0x00, 0x00, 0x00,                         /* Device type 0 (TRANSFORM) */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, /* Data size 0 */
  0x49, 0x4d, 0x41, 0x47, 0x45, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Device type 1 (IMAGE) */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x0c, /* Data size 1 */
  0x53, 0x45, 0x4e, 0x53, 0x4f, 0x52, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Device type 2 (SENSOR)*/
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, /* Body size 2 */

  0x00, 0x22,                                     /* Length of device name table */

  0x43, 0x68, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x61,
  0x6e, 0x73, 0x00,                               /* Device name 0 ("ChildTrans") */

  0x43, 0x68, 0x69, 0x6c, 0x64, 0x49, 0x6d, 0x61,
  0x67, 0x65, 0x00,                               /* Device name 1 ("ChildImage") */
  0x43, 0x68, 0x69, 0x6c, 0x64, 0x53, 0x65, 0x6e,
  0x73, 0x6f, 0x72, 0x00,                         /* Device name 2 ("ChildSensor") */
 
};


char test_bind_message_bind_body[] = {            /* 48+2572+58 = 2678 bytes */
  
  /* TRANSFORM */
  0xBF, 0x74, 0x73, 0xCD, 0x3E, 0x49, 0x59, 0xE6, /* tx, ty */
  0xBE, 0x63, 0xDD, 0x98, 0xBE, 0x49, 0x59, 0xE6, /* tz, sx */
  0x3E, 0x12, 0x49, 0x1B, 0x3F, 0x78, 0x52, 0xD6, /* sy, sz */
  0x3E, 0x63, 0xDD, 0x98, 0x3F, 0x78, 0x52, 0xD6, /* nx, ny */
  0xBD, 0xC8, 0x30, 0xAE, 0x42, 0x38, 0x36, 0x60, /* nz, px */
  0x41, 0x9B, 0xC4, 0x67, 0x42, 0x38, 0x36, 0x60, /* py, pz */

  /* IMAGE */
  /* Image header */
  0x00, 0x01,                                     /* Version number */
  0x01,                                           /* Number of components (scalar) */
  0x03,                                           /* Scalar type (8-bit unsigned int) */
  0x02,                                           /* Little endian */
  0x01,                                           /* Image coordinate */
  0x00, 0x32, 0x00, 0x32, 0x00, 0x01,             /* Number of pixels */
  0xBF, 0x74, 0x73, 0xCD, 0x3E, 0x49, 0x59, 0xE6, 
  0xBE, 0x63, 0xDD, 0x98,                         /* tx, ty, tz */
  0xBE, 0x49, 0x59, 0xE6, 0x3E, 0x12, 0x49, 0x1B,
  0x3F, 0x78, 0x52, 0xD6,                         /* sx, sy, sz */
  0x3E, 0x63, 0xDD, 0x98, 0x3F, 0x78, 0x52, 0xD6, 
  0xBD, 0xC8, 0x30, 0xAE,                         /* nx, ny, nz */
  0x42, 0x38, 0x36, 0x60, 0x41, 0x9B, 0xC4, 0x67,
  0x42, 0x38, 0x36, 0x60,                         /* px, py, pz */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,             /* Starting index of subvolume */
  0x00, 0x32, 0x00, 0x32, 0x00, 0x01,             /* Number of pixels in subvolume */

  /* Image data */
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x44, 0x14, 0xfd, 0x27, 0x13, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x77, 0x9a, 0xfd, 0xfd, 0xfd, 0xfd, 0x52, 0xfd, 0x98, 0xfd, 0x2f,
  0xfd, 0x2d, 0x46, 0x1f, 0x0d, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x2b, 0xfd, 0xfd, 0x86, 0xfd, 0xfd, 0xfd, 0xfd, 0x66, 0xfd, 0x00,
  0xfd, 0x22, 0x83, 0xfd, 0x34, 0x79, 0x62, 0x00, 0x23, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0x08, 0x39, 0xfd, 0x5c, 0x76, 0xfd, 0x20, 0xfd, 0x45, 0xfd, 0xfd, 0x58,
  0x4f, 0xb0, 0xfd, 0x73, 0xfd, 0x13, 0xa0, 0x23, 0x44, 0x26, 0xfd, 0x03, 0x9e, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x2c, 0x0d, 0x16, 0xfd, 0x1b, 0x67, 0x59, 0x51, 0x72, 0x41, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x1c, 0x27, 0x9c, 0x3d, 0x4e, 0x95, 0xfd, 0x53, 0xfd, 0x26, 0x20,
  0x08, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x0c, 0xd5, 0x22, 0x09, 0x01, 0x67, 0xfd, 0x98, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x05, 0xfd, 0x6f, 0x74, 0xfd,
  0xfd, 0x34, 0x80, 0x61, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x00, 0x2f, 0x44, 0xfd, 0x7b, 0x5e, 0xb9, 0x5e, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0x28, 0x06, 0x7e, 0x43, 0x09, 0x00, 0x85, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x78, 0xfd, 0xfd, 0x9a, 0x9c, 0xb6, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0x0f, 0x36, 0xfd, 0x05, 0x01, 0x31, 0xa0, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x25, 0x01, 0x2a, 0xfd, 0x24, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x15, 0x18, 0x6d, 0x2a, 0xa2, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xa8, 0xfd, 0xfd, 0x17, 0x14, 0x40,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x36, 0xfd, 0x18, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x01, 0xfd, 0x7c, 0x64, 0x74,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x5d, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x08, 0x66, 0xfd, 0xfd,
  0x5f, 0x3b, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xc0, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xb9, 0xfd,
  0xfd, 0xfd, 0x71, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0x95, 0x6c, 0xca, 0x08, 0x39, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x09,
  0x39, 0x09, 0x8d, 0x20, 0xfd, 0x06, 0x34, 0x19, 0x19, 0x19, 0x19, 0x33, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x0a, 0xfd, 0xb0, 0x30, 0x9e, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0x06, 0xfd, 0xfd, 0x64, 0xfd, 0x1c, 0x70, 0x9f, 0xdb, 0xdd, 0x9f, 0xd8, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x0c, 0xfd, 0x18, 0x2a, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0x64, 0x6f, 0x92, 0x38, 0x46, 0xfd, 0xfd, 0xfd, 0xfd, 0x8b, 0xfc, 0xac, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x8f, 0x55, 0xfd, 0x22, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x14, 0x10, 0xfd, 0x96, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc,
  0x21, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x34, 0xfd, 0xfd,
  0xab, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x60, 0x61, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc,
  0xfc, 0xfc, 0x4d, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x0a, 0xeb, 0xfc, 0xc5, 0xea, 0x57, 0x0a,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x32,
  0x15, 0x41, 0xfd, 0x1f, 0xfd, 0xfd, 0xfd, 0xfd, 0x6e, 0x53, 0x4a, 0xa9, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0x6e, 0x8a, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x57, 0xfc, 0xfc, 0xd0, 0xfd, 0xfd,
  0xfd, 0x78, 0x57, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0x3c, 0x49, 0x2f, 0x16, 0xfd, 0xfd, 0xfd, 0xfd, 0x04, 0x2b, 0x16, 0x05, 0xfd, 0xfd,
  0xfd, 0x0d, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xe3, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc, 0xfc, 0xaa,
  0xfd, 0xfd, 0xfd, 0xfd, 0x13, 0xfc, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0x3e, 0x69, 0xfd, 0x68, 0xfd, 0xfd, 0xfd, 0x43, 0x35, 0x8e, 0x39, 0x05,
  0xfd, 0xfd, 0xfd, 0x1c, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xac, 0xfd, 0xfd, 0xba, 0xfc, 0xfc, 0xfc,
  0xfc, 0x82, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x69, 0x12, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x92, 0x17, 0x58, 0x2c, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0x99, 0xfd, 0xfd, 0xfd, 0xfd, 0x06, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xaa, 0xfd, 0xfd, 0xfc, 0xfc,
  0xfc, 0xfc, 0xfc, 0xcd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x39, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x01, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x57, 0xfd, 0x97,
  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xaf, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x05, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x70,
  0xfd, 0xda, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x1d, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x06, 0xfc, 0xfc, 0xfc, 0xfc,
  0xfc, 0xe2, 0xfd, 0xc0, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xae, 0xfd, 0xa7, 0x1d, 0x1d, 0x1d, 0x1d,
  0x1d, 0xa1, 0x70, 0xe8, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xea, 0xaa, 0xe3, 0xfc, 0x96, 0xb6, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x62, 0xfd, 0xfd, 0x84, 0xfd, 0xfd, 0xfd, 0xfd, 0x1e, 0xfc, 0xfc,
  0xfc, 0xfc, 0xfc, 0xd0, 0xfd, 0x51, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xed, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0x64, 0x97, 0xfd, 0x2d, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x6b, 0xfd, 0xfd, 0xfd, 0xfd,
  0x2e, 0x42, 0x1f, 0x25, 0xfd, 0xfd, 0xfd, 0x49, 0x20, 0x42, 0x31, 0xfd, 0xfd, 0xfd, 0xfd, 0x1f,
  0xa1, 0x47, 0x47, 0x47, 0x47, 0xd2, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xc9, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xa8, 0xfd, 0xfd, 0x6d, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x1b, 0xfd, 0xfd,
  0xfd, 0xfd, 0x29, 0x2f, 0x1e, 0x8e, 0xfd, 0xfd, 0xfd, 0x59, 0xfd, 0xfd, 0xfd, 0x01, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xf7, 0xfc, 0xfc, 0xfc, 0xfc, 0x70,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x04, 0xd1, 0xfd, 0xfd, 0x4d, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x14,
  0xfd, 0xfd, 0xfd, 0xfd, 0x13, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x04, 0x04, 0x8a, 0x35, 0x58,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc,
  0xfc, 0x57, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfd, 0xfd, 0xfd, 0x85, 0xfc, 0xfc, 0xfc, 0xfc,
  0xfc, 0x7a, 0xfd, 0xfd, 0xfd, 0xfd, 0x42, 0x52, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x5c, 0x0a,
  0x58, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x04,
  0xfc, 0xfc, 0xfc, 0x82, 0xfd, 0xfd, 0xfd, 0x4f, 0xfc, 0xfd, 0xfd, 0xfd, 0xfd, 0xa5, 0xfc, 0xfc,
  0xfc, 0xfc, 0xfc, 0x53, 0xfd, 0xfd, 0xfd, 0x0c, 0x46, 0x93, 0xfd, 0x84, 0xfd, 0xfd, 0xfd, 0xfd,
  0x0a, 0x07, 0x81, 0xb3, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0x49, 0xd6, 0xd6, 0x21, 0xc8, 0xfc, 0x81, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x2b,
  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x23, 0xfd, 0xfd, 0xfd, 0x05, 0xfd, 0x0f, 0x65, 0x0f, 0xfd, 0xfd,
  0xfd, 0xfd, 0x5d, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0x51, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x23, 0xfd, 0xfd, 0x07, 0x0b, 0xfd, 0xfd, 0x05, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xb3, 0xc4, 0x8b, 0xc4, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0x63, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x36, 0xfd, 0xfd, 0xfd, 0x35, 0xfd, 0x2a,
  0x7a, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x05, 0x2e, 0x6b, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x33, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x29, 0xfd, 0xfd, 0xfd, 0xfd,
  0xb5, 0x00, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xba, 0xfd, 0x4b, 0x6b, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x24,
  0x1a, 0xfd, 0xfd, 0x37, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xab, 0xfd, 0xfd,
  0x37, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0x0c, 0x41, 0x95, 0x33, 0x14, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x3f,
  0x38, 0xfd, 0x26, 0x4d, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0x1b, 0xfd, 0x6e, 0x04, 0x01, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0x1f, 0xbf, 0x3c, 0x0f, 0x87, 0x4d, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0x19, 0x62, 0xfd, 0xfd, 0x52, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0x0f, 0x12, 0x76, 0xc2, 0x23, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0x4d, 0x33, 0x72, 0x58, 0xdf, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x03, 0xfd, 0x08, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0x09, 0x5e, 0x45, 0xfd, 0x3d, 0x4e, 0x08, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xc1, 0x04, 0x05, 0x0a, 0xfd, 0x8b,
  0x80, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x65, 0x62, 0xfd, 0x56, 0x31, 0x00, 0x13, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0x6b, 0xfd, 0x05, 0x31, 0x06, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xa3, 0xd4, 0xfd, 0x1e, 0x45, 0xfd, 0x16, 0x07, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xc7, 0x80, 0x00, 0xfd, 0x3d, 0x6f, 0x38, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x5c, 0xfd, 0x4d, 0xfd, 0xfd, 0xf9, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0x35, 0x55, 0x23, 0x9b, 0xfd, 0x46, 0xfd, 0x11, 0xa7, 0x09, 0x85, 0x5c,
  0xfd, 0x5d, 0x9d, 0x21, 0xa5, 0xa5, 0x4b, 0xfd, 0xfd, 0xfd, 0xfd, 0x9b, 0x2a, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x52, 0xfd, 0x67, 0xfd, 0x08, 0x1e, 0xfd,
  0x20, 0xfd, 0x7f, 0x0e, 0xfd, 0x5b, 0xfd, 0x8a, 0xfd, 0x02, 0xfd, 0xfd, 0xfd, 0x6d, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x30, 0x94, 0xfd, 0xfd, 0x9b,
  0xfd, 0xfd, 0x7a, 0xfd, 0x9a, 0xfd, 0x69, 0x5c, 0xfd, 0x21, 0xfd, 0x67, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0x64, 0x1b, 0x46, 0xfd, 0xab, 0x25, 0x5c, 0xfd, 0x62, 0x4c, 0x4f, 0x14, 0x4b, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0x18, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
  0xfd, 0xfd, 0xfd, 0xfd,

  /* SENSOR */
  0x06,                                           /* larray */
  0x00,                                           /* status */
  0x00, 0x44, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, /* unit */

  0x40, 0xfe, 0x24, 0x0c, 0x7a, 0xe1, 0x47, 0xae, /* value: sensor #0 */
  0x40, 0xc8, 0x1c, 0xd6, 0xc8, 0xb4, 0x39, 0x58, /* value: sensor #1 */
  0x40, 0x93, 0x4a, 0x45, 0x6d, 0x5c, 0xfa, 0xad, /* value: sensor #2 */
  0x40, 0x5e, 0xdd, 0x3b, 0xe2, 0x2e, 0x5d, 0xe1, /* value: sensor #3 */
  0x40, 0x28, 0xb0, 0xfc, 0xb4, 0xf1, 0xe4, 0xb4, /* value: sensor #4 */
  0x3f, 0xf3, 0xc0, 0xca, 0x2a, 0x5b, 0x1d, 0x5d, /* value: sensor #4 */
  
};


#endif /* IGTL_TEST_DATA_BIND_H */




