#region License
//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2013 Stefanos Apostolopoulos for the Open Toolkit Library
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
#endregion

using System;
using System.Runtime.InteropServices;

namespace OpenTK.Graphics.OpenGL
{
    #pragma warning disable 626
    #pragma warning disable 1591

    partial class GL
    {
        /// <summary>
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="obj">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "Version20", Version = "2.0", EntryPoint = "glGetAttachedShaders")]
        [Obsolete("Use GetAttachedShaders out/array overload instead")]
        public static 
        unsafe void GetAttachedShaders(Int32 program, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] Int32[] obj) { throw new NotImplementedException(); }


        /// <summary>
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="obj">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "Version20", Version = "2.0", EntryPoint = "glGetAttachedShaders")]
        [Obsolete("Use GetAttachedShaders out/array overload instead")]
        public static 
        unsafe void GetAttachedShaders(UInt32 program, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] UInt32[] obj) { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] T5[] span)
            where T5 : struct { throw new NotImplementedException(); }

        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] T5[,] span)
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] T5[,,] span)
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload instead")]
        public static 
        void GetSeparableFilter<T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] ref T5 span)
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T4,T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [InAttribute, OutAttribute] T4[] column, [InAttribute, OutAttribute] T5[,,] span)
            where T4 : struct
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T4,T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [InAttribute, OutAttribute] T4[,] column, [InAttribute, OutAttribute] T5[,,] span)
            where T4 : struct
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T4,T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [InAttribute, OutAttribute] T4[,,] column, [InAttribute, OutAttribute] T5[,,] span)
            where T4 : struct
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T4,T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [InAttribute, OutAttribute] ref T4 column, [InAttribute, OutAttribute] T5[,,] span)
            where T4 : struct
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload with equal array dimensions instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T3,T4,T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[] row, [InAttribute, OutAttribute] T4[,,] column, [InAttribute, OutAttribute] T5[,,] span)
            where T3 : struct
            where T4 : struct
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> overload with equal array dimensions instead")]
        [CLSCompliant(false)]
        public static 
        void GetSeparableFilter<T3,T4,T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[,] row, [InAttribute, OutAttribute] T4[,,] column, [InAttribute, OutAttribute] T5[,,] span)
            where T3 : struct
            where T4 : struct
            where T5 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Get separable convolution filter kernel images
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to storage for the row filter image.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to storage for the column filter image.
        /// </para>
        /// </param>
        /// <param name="span">
        /// <para>
        /// Pointer to storage for the span filter image (currently unused).
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glGetSeparableFilter")]
        [Obsolete("Use GetSeparableFilter<T3, T4, T5> with three ref arguments instead")]
        public static 
        void GetSeparableFilter<T3,T4,T5>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T3 row, [InAttribute, OutAttribute] T4[,,] column, [InAttribute, OutAttribute] T5[,,] span)
            where T3 : struct
            where T4 : struct
            where T5 : struct { throw new NotImplementedException(); }


        [System.CLSCompliant(false)]
        [AutoGenerated(Category = "ArbSync", Version = "1.2", EntryPoint = "glGetSynciv")]
        [Obsolete("Use out/array overload instead")]
        public static 
        unsafe void GetSync(IntPtr sync, OpenTK.Graphics.OpenGL.ArbSync pname, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] Int32[] values) { throw new NotImplementedException(); }


        /// <summary>
        /// Define a separable two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glSeparableFilter2D")]
        [Obsolete("Use overload with equal array dimensions instead")]
        [CLSCompliant(false)]
        public static 
        void SeparableFilter2D<T7>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] T7[] column)
            where T7 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Define a separable two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glSeparableFilter2D")]
        [Obsolete("Use overload with equal array dimensions instead")]
        [CLSCompliant(false)]
        public static 
        void SeparableFilter2D<T7>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] T7[,] column)
            where T7 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Define a separable two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glSeparableFilter2D")]
        [Obsolete("Use overload with equal array dimensions instead")]
        [CLSCompliant(false)]
        public static 
        void SeparableFilter2D<T7>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] T7[,,] column)
            where T7 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Define a separable two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glSeparableFilter2D")]
        [Obsolete("Use overload with equal array dimensions instead")]
        public static 
        void SeparableFilter2D<T7>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] ref T7 column)
            where T7 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Define a separable two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glSeparableFilter2D")]
        [Obsolete("Use overload with equal array dimensions instead")]
        [CLSCompliant(false)]
        public static 
        void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[] row, [InAttribute, OutAttribute] T7[,,] column)
            where T6 : struct
            where T7 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Define a separable two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glSeparableFilter2D")]
        [Obsolete("Use overload with equal array dimensions instead")]
        [CLSCompliant(false)]
        public static 
        void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[,] row, [InAttribute, OutAttribute] T7[,,] column)
            where T6 : struct
            where T7 : struct { throw new NotImplementedException(); }


        /// <summary>
        /// Define a separable two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "Version12Deprecated", Version = "1.2", EntryPoint = "glSeparableFilter2D")]
        [Obsolete("Use overload with equal array dimensions instead")]
        [CLSCompliant(false)]
        public static 
        void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.SeparableTarget target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T6 row, [InAttribute, OutAttribute] T7[,,] column)
            where T6 : struct
            where T7 : struct { throw new NotImplementedException(); }

        partial class Amd
        {
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            unsafe void GetPerfMonitorCounterData(Int32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] Int32[] data, [OutAttribute] Int32* bytesWritten) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            unsafe void GetPerfMonitorCounterData(Int32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] UInt32[] data, [OutAttribute] Int32* bytesWritten) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCounterDataAMD")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            unsafe void GetPerfMonitorCounterData(UInt32 monitor, OpenTK.Graphics.OpenGL.AmdPerformanceMonitor pname, Int32 dataSize, [OutAttribute] UInt32[] data, [OutAttribute] Int32* bytesWritten) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCountersAMD")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            unsafe void GetPerfMonitorCounters(Int32 group, [OutAttribute] Int32* numCounters, [OutAttribute] Int32* maxActiveCounters, Int32 counterSize, [OutAttribute] Int32[] counters) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorCountersAMD")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            unsafe void GetPerfMonitorCounters(UInt32 group, [OutAttribute] Int32* numCounters, [OutAttribute] Int32* maxActiveCounters, Int32 counterSize, [OutAttribute] UInt32[] counters) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            [Obsolete("Use GetPerfMonitorGroups instead")]
            public static 
            void GetPerfMonitorGroup([OutAttribute] out Int32 numGroups, Int32 groupsSize, [OutAttribute] out Int32 groups) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            [Obsolete("Use GetPerfMonitorGroups instead")]
            public static 
            void GetPerfMonitorGroup([OutAttribute] out Int32 numGroups, Int32 groupsSize, [OutAttribute] out UInt32 groups) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            [Obsolete("Use GetPerfMonitorGroups instead")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] Int32[] groups) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            [Obsolete("Use GetPerfMonitorGroups instead")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] Int32* groups) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            [Obsolete("Use GetPerfMonitorGroups instead")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] UInt32[] groups) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AmdPerformanceMonitor", Version = "1.2", EntryPoint = "glGetPerfMonitorGroupsAMD")]
            [Obsolete("Use GetPerfMonitorGroups instead")]
            public static 
            unsafe void GetPerfMonitorGroup([OutAttribute] Int32* numGroups, Int32 groupsSize, [OutAttribute] UInt32* groups) { throw new NotImplementedException(); }
        }

        partial class Arb
        {
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetAttachedObjectsARB")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            unsafe void GetAttachedObjects(Int32 containerObj, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] Int32[] obj) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ArbShaderObjects", Version = "1.2", EntryPoint = "glGetAttachedObjectsARB")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            unsafe void GetAttachedObjects(UInt32 containerObj, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] UInt32[] obj) { throw new NotImplementedException(); }
        }

        partial class Ati
        {
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glPassTexCoordATI")]
            [Obsolete("Use PassTexCoord instead")]
            public static 
            void PassTexCoor(Int32 dst, Int32 coord, OpenTK.Graphics.OpenGL.AtiFragmentShader swizzle) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "AtiFragmentShader", Version = "1.2", EntryPoint = "glPassTexCoordATI")]
            [Obsolete("Use PassTexCoord instead")]
            public static 
            void PassTexCoor(UInt32 dst, UInt32 coord, OpenTK.Graphics.OpenGL.AtiFragmentShader swizzle) { throw new NotImplementedException(); }
        }

        partial class Ext
        {
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjecti64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            void GetQueryObjecti64(Int32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] Int64[] @params) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjecti64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            void GetQueryObjecti64(Int32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] out Int64 @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjecti64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            unsafe void GetQueryObjecti64(Int32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] Int64* @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjecti64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            void GetQueryObjecti64(UInt32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] Int64[] @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjecti64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            void GetQueryObjecti64(UInt32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] out Int64 @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjecti64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            unsafe void GetQueryObjecti64(UInt32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] Int64* @params) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjectui64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            void GetQueryObjectui64(Int32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] Int64[] @params) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjectui64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            void GetQueryObjectui64(Int32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] out Int64 @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjectui64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            unsafe void GetQueryObjectui64(Int32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] Int64* @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjectui64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            void GetQueryObjectui64(UInt32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] UInt64[] @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjectui64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            void GetQueryObjectui64(UInt32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] out UInt64 @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "ExtTimerQuery", Version = "1.5", EntryPoint = "glGetQueryObjectui64vEXT")]
            [Obsolete("Use GetQueryObject overload instead")]
            public static 
            unsafe void GetQueryObjectui64(UInt32 id, OpenTK.Graphics.OpenGL.ExtTimerQuery pname, [OutAttribute] UInt64* @params) { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            public static 
            void GetSeparableFilter(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] IntPtr span) { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            public static 
            void GetSeparableFilter<T4, T5, T6>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, ref T4 row, ref T5 column, ref T6 span)
                where T4 : struct
                where T5 : struct
                where T6 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T4, T5, T6>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] T4[] row, [OutAttribute] T5[] column, [InAttribute, OutAttribute] T6[] span)
                where T4 : struct
                where T5 : struct
                where T6 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T4, T5, T6>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] T4[,] row, [OutAttribute] T5[,] column, [InAttribute, OutAttribute] T6[,] span)
                where T4 : struct
                where T5 : struct
                where T6 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T4, T5, T6>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] T4[,,] row, [OutAttribute] T5[,,] column, [InAttribute, OutAttribute] T6[,,] span)
                where T4 : struct
                where T5 : struct
                where T6 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] T5[] span)
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] T5[,] span)
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] T5[,,] span)
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            public static 
            void GetSeparableFilter<T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [OutAttribute] IntPtr column, [InAttribute, OutAttribute] ref T5 span)
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T4,T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [InAttribute, OutAttribute] T4[] column, [InAttribute, OutAttribute] T5[,,] span)
                where T4 : struct
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T4,T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [InAttribute, OutAttribute] T4[,] column, [InAttribute, OutAttribute] T5[,,] span)
                where T4 : struct
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T4,T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [InAttribute, OutAttribute] T4[,,] column, [InAttribute, OutAttribute] T5[,,] span)
                where T4 : struct
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use GetSeparableFilter<T4, T5, T6> overloads instead")]
            public static 
            void GetSeparableFilter<T4,T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [OutAttribute] IntPtr row, [InAttribute, OutAttribute] ref T4 column, [InAttribute, OutAttribute] T5[,,] span)
                where T4 : struct
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use ref/array overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T3,T4,T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[] row, [InAttribute, OutAttribute] T4[,,] column, [InAttribute, OutAttribute] T5[,,] span)
                where T3 : struct
                where T4 : struct
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use ref/array overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T3,T4,T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[,] row, [InAttribute, OutAttribute] T4[,,] column, [InAttribute, OutAttribute] T5[,,] span)
                where T3 : struct
                where T4 : struct
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Get separable convolution filter kernel images
            /// </summary>
            /// <param name="target">
            /// <para>
            /// The separable filter to be retrieved. Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// Format of the output images. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// Data type of components in the output images. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to storage for the row filter image.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to storage for the column filter image.
            /// </para>
            /// </param>
            /// <param name="span">
            /// <para>
            /// Pointer to storage for the span filter image (currently unused).
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glGetSeparableFilterEXT")]
            [Obsolete("Use ref/array overloads instead")]
            [CLSCompliant(false)]
            public static 
            void GetSeparableFilter<T3,T4,T5>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T3 row, [InAttribute, OutAttribute] T4[,,] column, [InAttribute, OutAttribute] T5[,,] span)
                where T3 : struct
                where T4 : struct
                where T5 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use SeparableFilter2D<T6, T7> overloads instead")]
            public static 
            void SeparableFilter2D(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] IntPtr column) { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T6 row, [InAttribute, OutAttribute] ref T7 column)
                where T6 : struct
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use ref/array overloads instead")]
            [CLSCompliant(false)]
            public static 
            void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[] row, [InAttribute, OutAttribute] T7[] column)
                where T6 : struct
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use ref/array overloads instead")]
            [CLSCompliant(false)]
            public static 
            void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[,] row, [InAttribute, OutAttribute] T7[,] column)
                where T6 : struct
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use ref/array overloads instead")]
            [CLSCompliant(false)]
            public static 
            void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[,,] row, [InAttribute, OutAttribute] T7[,,] column)
                where T6 : struct
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use SeparableFilter2D<T6, T7> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void SeparableFilter2D<T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] T7[] column)
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use SeparableFilter2D<T6, T7> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void SeparableFilter2D<T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] T7[,] column)
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use SeparableFilter2D<T6, T7> overloads instead")]
            [CLSCompliant(false)]
            public static 
            void SeparableFilter2D<T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] T7[,,] column)
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use SeparableFilter2D<T6, T7> overloads instead")]
            public static 
            void SeparableFilter2D<T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, IntPtr row, [InAttribute, OutAttribute] ref T7 column)
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use ref/array overloads instead")]
            [CLSCompliant(false)]
            public static 
            void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[] row, [InAttribute, OutAttribute] T7[,,] column)
                where T6 : struct
                where T7 : struct { throw new NotImplementedException(); }


            /// <summary>
            /// Define a separable two-dimensional convolution filter
            /// </summary>
            /// <param name="target">
            /// <para>
            /// Must be GL_SEPARABLE_2D.
            /// </para>
            /// </param>
            /// <param name="internalformat">
            /// <para>
            /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
            /// </para>
            /// </param>
            /// <param name="width">
            /// <para>
            /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="height">
            /// <para>
            /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
            /// </para>
            /// </param>
            /// <param name="format">
            /// <para>
            /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
            /// </para>
            /// </param>
            /// <param name="type">
            /// <para>
            /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
            /// </para>
            /// </param>
            /// <param name="row">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
            /// </para>
            /// </param>
            /// <param name="column">
            /// <para>
            /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
            /// </para>
            /// </param>
            [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
            [Obsolete("Use ref/array overloads instead")]
            public static 
            void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[,] row, [InAttribute, OutAttribute] T7[,,] column)
                where T6 : struct
                where T7 : struct { throw new NotImplementedException(); }
        }

        /// <summary>
        /// Define a separable two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of elements in the pixel array referenced by row. (This is the width of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The number of elements in the pixel array referenced by column. (This is the height of the separable filter kernel.)
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in row and column. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_INTENSITY, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in row and column. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="row">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the row filter kernel.
        /// </para>
        /// </param>
        /// <param name="column">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the column filter kernel.
        /// </para>
        /// </param>
        [AutoGenerated(Category = "ExtConvolution", Version = "1.0", EntryPoint = "glSeparableFilter2DEXT")]
        [Obsolete("Use ref/array overloads instead")]
        public static 
        void SeparableFilter2D<T6,T7>(OpenTK.Graphics.OpenGL.ExtConvolution target, OpenTK.Graphics.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, OpenTK.Graphics.OpenGL.PixelFormat format, OpenTK.Graphics.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T6 row, [InAttribute, OutAttribute] T7[,,] column)
            where T6 : struct
            where T7 : struct { throw new NotImplementedException(); }


        partial class Ibm
        {
            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawArraysIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            void MultiModeDrawArrays(OpenTK.Graphics.OpenGL.BeginMode[] mode, Int32[] first, Int32[] count, Int32 primcount, Int32 modestride) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawArraysIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            void MultiModeDrawArrays(ref OpenTK.Graphics.OpenGL.BeginMode mode, ref Int32 first, ref Int32 count, Int32 primcount, Int32 modestride) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawArraysIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            unsafe void MultiModeDrawArrays(OpenTK.Graphics.OpenGL.BeginMode* mode, Int32* first, Int32* count, Int32 primcount, Int32 modestride) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            void MultiModeDrawElements(OpenTK.Graphics.OpenGL.BeginMode[] mode, Int32[] count, OpenTK.Graphics.OpenGL.DrawElementsType type, IntPtr indices, Int32 primcount, Int32 modestride) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            [CLSCompliant(false)]
            public static 
            void MultiModeDrawElements<T3>(OpenTK.Graphics.OpenGL.BeginMode[] mode, Int32[] count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            [CLSCompliant(false)]
            public static 
            void MultiModeDrawElements<T3>(OpenTK.Graphics.OpenGL.BeginMode[] mode, Int32[] count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            [CLSCompliant(false)]
            public static 
            void MultiModeDrawElements<T3>(OpenTK.Graphics.OpenGL.BeginMode[] mode, Int32[] count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,,] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            void MultiModeDrawElements<T3>(OpenTK.Graphics.OpenGL.BeginMode[] mode, Int32[] count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            void MultiModeDrawElements(ref OpenTK.Graphics.OpenGL.BeginMode mode, ref Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, IntPtr indices, Int32 primcount, Int32 modestride) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            [CLSCompliant(false)]
            public static 
            void MultiModeDrawElements<T3>(ref OpenTK.Graphics.OpenGL.BeginMode mode, ref Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            [CLSCompliant(false)]
            public static 
            void MultiModeDrawElements<T3>(ref OpenTK.Graphics.OpenGL.BeginMode mode, ref Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            [CLSCompliant(false)]
            public static 
            void MultiModeDrawElements<T3>(ref OpenTK.Graphics.OpenGL.BeginMode mode, ref Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,,] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            [CLSCompliant(false)]
            public static 
            void MultiModeDrawElements<T3>(ref OpenTK.Graphics.OpenGL.BeginMode mode, ref Int32 count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            unsafe void MultiModeDrawElements(OpenTK.Graphics.OpenGL.BeginMode* mode, Int32* count, OpenTK.Graphics.OpenGL.DrawElementsType type, IntPtr indices, Int32 primcount, Int32 modestride) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            unsafe void MultiModeDrawElements<T3>(OpenTK.Graphics.OpenGL.BeginMode* mode, Int32* count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            unsafe void MultiModeDrawElements<T3>(OpenTK.Graphics.OpenGL.BeginMode* mode, Int32* count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            unsafe void MultiModeDrawElements<T3>(OpenTK.Graphics.OpenGL.BeginMode* mode, Int32* count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,,] indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "IbmMultimodeDrawArrays", Version = "1.1", EntryPoint = "glMultiModeDrawElementsIBM")]
            [Obsolete("Use PrimitiveType overload instead")]
            public static 
            unsafe void MultiModeDrawElements<T3>(OpenTK.Graphics.OpenGL.BeginMode* mode, Int32* count, OpenTK.Graphics.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices, Int32 primcount, Int32 modestride)
                where T3 : struct { throw new NotImplementedException(); }
        }

        partial class NV
        {
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glDeleteTransformFeedbacksNV")]
            [Obsolete("Use DeleteTransformFeedbacks overload instead")]
            public static 
            void DeleteTransformFeedback(Int32 n, Int32[] ids) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glDeleteTransformFeedbacksNV")]
            [Obsolete("Use DeleteTransformFeedbacks overload instead")]
            public static 
            void DeleteTransformFeedback(Int32 n, ref Int32 ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glDeleteTransformFeedbacksNV")]
            [Obsolete("Use DeleteTransformFeedbacks overload instead")]
            public static 
            unsafe void DeleteTransformFeedback(Int32 n, Int32* ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glDeleteTransformFeedbacksNV")]
            [Obsolete("Use DeleteTransformFeedbacks overload instead")]
            public static 
            void DeleteTransformFeedback(Int32 n, UInt32[] ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glDeleteTransformFeedbacksNV")]
            [Obsolete("Use DeleteTransformFeedbacks overload instead")]
            public static 
            void DeleteTransformFeedback(Int32 n, ref UInt32 ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glDeleteTransformFeedbacksNV")]
            [Obsolete("Use DeleteTransformFeedbacks overload instead")]
            public static 
            unsafe void DeleteTransformFeedback(Int32 n, UInt32* ids) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glGenTransformFeedbacksNV")]
            [Obsolete("Use GenTransformFeedbacks overload instead")]
            public static 
            void GenTransformFeedback(Int32 n, [OutAttribute] Int32[] ids) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glGenTransformFeedbacksNV")]
            [Obsolete("Use GenTransformFeedbacks overload instead")]
            public static 
            void GenTransformFeedback(Int32 n, [OutAttribute] out Int32 ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glGenTransformFeedbacksNV")]
            [Obsolete("Use GenTransformFeedbacks overload instead")]
            public static 
            unsafe void GenTransformFeedback(Int32 n, [OutAttribute] Int32* ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glGenTransformFeedbacksNV")]
            [Obsolete("Use GenTransformFeedbacks overload instead")]
            public static 
            void GenTransformFeedback(Int32 n, [OutAttribute] UInt32[] ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glGenTransformFeedbacksNV")]
            [Obsolete("Use GenTransformFeedbacks overload instead")]
            public static 
            void GenTransformFeedback(Int32 n, [OutAttribute] out UInt32 ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvTransformFeedback2", Version = "", EntryPoint = "glGenTransformFeedbacksNV")]
            [Obsolete("Use GenTransformFeedbacks overload instead")]
            public static 
            unsafe void GenTransformFeedback(Int32 n, [OutAttribute] UInt32* ids) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvFragmentProgram", Version = "1.2", EntryPoint = "glGetProgramNamedParameterdvNV")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void GetProgramNamedParameter(Int32 id, Int32 len, Byte* name, [OutAttribute] Double[] @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvFragmentProgram", Version = "1.2", EntryPoint = "glGetProgramNamedParameterdvNV")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void GetProgramNamedParameter(UInt32 id, Int32 len, Byte* name, [OutAttribute] Double[] @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvFragmentProgram", Version = "1.2", EntryPoint = "glGetProgramNamedParameterfvNV")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void GetProgramNamedParameter(Int32 id, Int32 len, Byte* name, [OutAttribute] Single[] @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvFragmentProgram", Version = "1.2", EntryPoint = "glGetProgramNamedParameterfvNV")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void GetProgramNamedParameter(UInt32 id, Int32 len, Byte* name, [OutAttribute] Single[] @params) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoi64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            void GetVideoi64(Int32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] Int64[] @params) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoi64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            void GetVideoi64(Int32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] out Int64 @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoi64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            unsafe void GetVideoi64(Int32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] Int64* @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoi64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            void GetVideoi64(UInt32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] Int64[] @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoi64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            void GetVideoi64(UInt32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] out Int64 @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoi64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            unsafe void GetVideoi64(UInt32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] Int64* @params) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoui64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            void GetVideoui64(Int32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] Int64[] @params) { throw new NotImplementedException(); }


            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoui64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            void GetVideoui64(Int32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] out Int64 @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoui64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            unsafe void GetVideoui64(Int32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] Int64* @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoui64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            void GetVideoui64(UInt32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] UInt64[] @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoui64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            void GetVideoui64(UInt32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] out UInt64 @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvPresentVideo", Version = "1.2", EntryPoint = "glGetVideoui64vNV")]
            [Obsolete("Use GetVideo overload instead")]
            public static 
            unsafe void GetVideoui64(UInt32 video_slot, OpenTK.Graphics.OpenGL.NvPresentVideo pname, [OutAttribute] UInt64* @params) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvFragmentProgram", Version = "1.2", EntryPoint = "glProgramNamedParameter4dvNV")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ProgramNamedParameter4(Int32 id, Int32 len, Byte* name, Double[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvFragmentProgram", Version = "1.2", EntryPoint = "glProgramNamedParameter4dvNV")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ProgramNamedParameter4(UInt32 id, Int32 len, Byte* name, Double[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvFragmentProgram", Version = "1.2", EntryPoint = "glProgramNamedParameter4fvNV")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ProgramNamedParameter4(Int32 id, Int32 len, Byte* name, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "NvFragmentProgram", Version = "1.2", EntryPoint = "glProgramNamedParameter4fvNV")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ProgramNamedParameter4(UInt32 id, Int32 len, Byte* name, Single[] v) { throw new NotImplementedException(); }
        }

        partial class Sun
        {
            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiColor3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiColor3fVertex3(Int32* rc, Single[] c, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiColor3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiColor3fVertex3(UInt32* rc, Single[] c, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiColor4fNormal3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiColor4fNormal3fVertex3(Int32* rc, Single[] c, Single[] n, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiColor4fNormal3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiColor4fNormal3fVertex3(UInt32* rc, Single[] c, Single[] n, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiColor4ubVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiColor4ubVertex3(Int32* rc, Byte[] c, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiColor4ubVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiColor4ubVertex3(UInt32* rc, Byte[] c, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiNormal3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiNormal3fVertex3(Int32* rc, Single[] n, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiNormal3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiNormal3fVertex3(UInt32* rc, Single[] n, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3(Int32* rc, Single[] tc, Single[] c, Single[] n, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3(UInt32* rc, Single[] tc, Single[] c, Single[] n, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiTexCoord2fNormal3fVertex3(Int32* rc, Single[] tc, Single[] n, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiTexCoord2fNormal3fVertex3(UInt32* rc, Single[] tc, Single[] n, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiTexCoord2fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiTexCoord2fVertex3(Int32* rc, Single[] tc, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiTexCoord2fVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiTexCoord2fVertex3(UInt32* rc, Single[] tc, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiVertex3(Int32* rc, Single[] v) { throw new NotImplementedException(); }


            [System.CLSCompliant(false)]
            [AutoGenerated(Category = "SunVertex", Version = "1.1", EntryPoint = "glReplacementCodeuiVertex3fvSUN")]
            [Obsolete("Use ref/array overload instead")]
            public static 
            unsafe void ReplacementCodeuiVertex3(UInt32* rc, Single[] v) { throw new NotImplementedException(); }
        }
    }
}
